/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrTypeTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\fH\u0016J)\u0010\r\u001a\u0002H\u000e\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u0002H\u000eH\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/backend/ir/IrConstChecker;", "Lorg/jetbrains/kotlin/ir/visitors/IrTypeTransformerVoid;", "<init>", "()V", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitFile", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "transformType", "Type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "container", "type", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/types/IrType;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "checkAnnotations", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nIrConstCheckerHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrConstCheckerHandler.kt\norg/jetbrains/kotlin/test/backend/ir/IrConstChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1611#2,9:90\n1863#2:99\n1864#2:101\n1620#2:102\n1863#2,2:103\n1863#2:105\n1863#2:106\n1863#2,2:107\n1864#2:109\n1864#2:110\n1#3:100\n*S KotlinDebug\n*F\n+ 1 IrConstCheckerHandler.kt\norg/jetbrains/kotlin/test/backend/ir/IrConstChecker\n*L\n54#1:90,9\n54#1:99\n54#1:101\n54#1:102\n54#1:103,2\n71#1:105\n78#1:106\n82#1:107,2\n78#1:109\n71#1:110\n54#1:100\n*E\n"})
final class IrConstChecker
extends IrTypeTransformerVoid {
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IrVisitorsKt.acceptChildrenVoid((IrElement)element, (IrElementVisitorVoid)((IrElementVisitorVoid)this));
    }

    public void visitFile(@NotNull IrFile declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.checkAnnotations((IrAnnotationContainer)declaration);
        IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)declaration), (IrElementVisitorVoid)((IrElementVisitorVoid)this));
    }

    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.checkAnnotations((IrAnnotationContainer)declaration);
        IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)declaration), (IrElementVisitorVoid)((IrElementVisitorVoid)this));
    }

    /*
     * WARNING - void declaration
     */
    public <Type extends IrType> Type transformType(@NotNull IrElement container, Type type) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (type == null) {
            return type;
        }
        this.checkAnnotations((IrAnnotationContainer)type);
        if (type instanceof IrSimpleType) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = ((IrSimpleType)type).getArguments();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                IrType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                IrTypeArgument it = (IrTypeArgument)element$iv$iv;
                boolean bl2 = false;
                if (IrTypesKt.getTypeOrNull((IrTypeArgument)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                IrType it = (IrType)element$iv;
                boolean bl = false;
                this.transformType(container, it);
            }
        }
        return type;
    }

    public void visitField(@NotNull IrField declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrPropertySymbol irPropertySymbol = declaration.getCorrespondingPropertySymbol();
        boolean bl = irPropertySymbol != null && (irPropertySymbol = (IrProperty)irPropertySymbol.getOwner()) != null ? irPropertySymbol.isConst() : false;
        if (bl) {
            IrExpressionBody irExpressionBody = declaration.getInitializer();
            if (!((irExpressionBody != null ? irExpressionBody.getExpression() : null) instanceof IrConst)) {
                IrExpressionBody irExpressionBody2 = declaration.getInitializer();
                String string = "Const field is not containing const expression. Got " + (irExpressionBody2 != null ? DumpIrTreeKt.dump$default((IrElement)((IrElement)irExpressionBody2), null, (int)1, null) : null);
                throw new IllegalStateException(string.toString());
            }
        }
        super.visitField(declaration);
    }

    private final void checkAnnotations(IrAnnotationContainer container) {
        Iterable $this$forEach$iv = container.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrConstructorCall annotation = (IrConstructorCall)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = IrUtilsKt.getAllArgumentsWithIr((IrMemberAccessExpression)((IrMemberAccessExpression)annotation));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IrExpression actualArg;
                IrExpression irExpression;
                Pair pair = (Pair)element$iv2;
                boolean bl2 = false;
                IrValueParameter param = (IrValueParameter)pair.component1();
                IrExpression arg = (IrExpression)pair.component2();
                Object object = arg;
                if (object == null) {
                    IrExpressionBody irExpressionBody = param.getDefaultValue();
                    object = irExpressionBody != null ? irExpressionBody.getExpression() : null;
                }
                if ((irExpression = (actualArg = object)) == null) {
                    throw new IllegalStateException(("IR annotation has null argument.\n Annotation: " + DumpIrTreeKt.dump$default((IrElement)((IrElement)annotation), null, (int)1, null) + '.').toString());
                }
                if (irExpression instanceof IrVararg) {
                    Iterable $this$forEach$iv3 = ((IrVararg)actualArg).getElements();
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        IrVarargElement element = (IrVarargElement)element$iv3;
                        boolean bl3 = false;
                        IrConstChecker.checkAnnotations$lambda$4$checkIsConst((IrElement)element, annotation);
                    }
                    continue;
                }
                IrConstChecker.checkAnnotations$lambda$4$checkIsConst((IrElement)actualArg, annotation);
            }
        }
    }

    private static final boolean checkAnnotations$isConst(IrElement $this$checkAnnotations_u24isConst) {
        return $this$checkAnnotations_u24isConst instanceof IrConst || $this$checkAnnotations_u24isConst instanceof IrGetEnumValue || $this$checkAnnotations_u24isConst instanceof IrClassReference || $this$checkAnnotations_u24isConst instanceof IrConstructorCall && IrTypeUtilsKt.isAnnotation((IrType)((IrConstructorCall)$this$checkAnnotations_u24isConst).getType());
    }

    private static final void checkAnnotations$lambda$4$checkIsConst(IrElement $this$checkAnnotations_u24lambda_u244_u24checkIsConst, IrConstructorCall $annotation) {
        if (IrConstChecker.checkAnnotations$isConst($this$checkAnnotations_u24lambda_u244_u24checkIsConst)) {
            return;
        }
        if ($this$checkAnnotations_u24lambda_u244_u24checkIsConst instanceof IrErrorExpression && StringsKt.startsWith$default((String)((IrErrorExpression)$this$checkAnnotations_u24lambda_u244_u24checkIsConst).getDescription(), (String)"Stub expression", (boolean)false, (int)2, null)) {
            return;
        }
        throw new IllegalStateException(("IR annotation has non constant argument.\n Annotation: " + DumpIrTreeKt.dump$default((IrElement)((IrElement)$annotation), null, (int)1, null) + ".\n Argument: " + DumpIrTreeKt.dump$default((IrElement)$this$checkAnnotations_u24lambda_u244_u24checkIsConst, null, (int)1, null)).toString());
    }
}

