/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhaseKt;
import org.jetbrains.kotlin.fir.declarations.FirResolveStateKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolver;
import org.jetbrains.kotlin.fir.symbols.FirLazyResolveContractViolationException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirCompilerLazyDeclarationResolverWithPhaseChecking;", "Lorg/jetbrains/kotlin/fir/symbols/FirLazyDeclarationResolver;", "<init>", "()V", "currentTransformerPhase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "exceptions", "", "Lorg/jetbrains/kotlin/fir/symbols/FirLazyResolveContractViolationException;", "getContractViolationExceptions", "", "lazyResolveToPhase", "", "element", "Lorg/jetbrains/kotlin/fir/FirElementWithResolveState;", "toPhase", "lazyResolveToPhaseWithCallableMembers", "clazz", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "lazyResolveToPhaseRecursively", "startResolvingPhase", "phase", "finishResolvingPhase", "checkIfCanLazyResolveToPhase", "requestedPhase", "elementPhase", "tests-common-new_test"})
public final class FirCompilerLazyDeclarationResolverWithPhaseChecking
extends FirLazyDeclarationResolver {
    @Nullable
    private FirResolvePhase currentTransformerPhase;
    @NotNull
    private final List<FirLazyResolveContractViolationException> exceptions = new ArrayList();

    @NotNull
    public final List<FirLazyResolveContractViolationException> getContractViolationExceptions() {
        return this.exceptions;
    }

    public void lazyResolveToPhase(@NotNull FirElementWithResolveState element, @NotNull FirResolvePhase toPhase) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)toPhase, (String)"toPhase");
        this.checkIfCanLazyResolveToPhase(toPhase, FirResolveStateKt.getResolvePhase((FirElementWithResolveState)element));
    }

    public void lazyResolveToPhaseWithCallableMembers(@NotNull FirClass clazz, @NotNull FirResolvePhase toPhase) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)toPhase, (String)"toPhase");
        this.checkIfCanLazyResolveToPhase(toPhase, FirResolveStateKt.getResolvePhase((FirElementWithResolveState)((FirElementWithResolveState)clazz)));
    }

    public void lazyResolveToPhaseRecursively(@NotNull FirElementWithResolveState element, @NotNull FirResolvePhase toPhase) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)toPhase, (String)"toPhase");
        this.checkIfCanLazyResolveToPhase(toPhase, FirResolveStateKt.getResolvePhase((FirElementWithResolveState)element));
    }

    public void startResolvingPhase(@NotNull FirResolvePhase phase) {
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        if (!(this.currentTransformerPhase == null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.currentTransformerPhase = phase;
    }

    public void finishResolvingPhase(@NotNull FirResolvePhase phase) {
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        if (!(this.currentTransformerPhase == phase)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.currentTransformerPhase = null;
    }

    private final void checkIfCanLazyResolveToPhase(FirResolvePhase requestedPhase, FirResolvePhase elementPhase) {
        if (!this.getLazyResolveContractChecksEnabled() || elementPhase.compareTo((Enum)requestedPhase) >= 0) {
            return;
        }
        FirResolvePhase firResolvePhase = this.currentTransformerPhase;
        if (firResolvePhase == null) {
            throw new IllegalStateException("Current phase is not set, please call startResolvingPhase before starting transforming the file".toString());
        }
        FirResolvePhase currentPhase = firResolvePhase;
        if (!FirResolvePhaseKt.isItAllowedToCallLazyResolveTo((FirResolvePhase)currentPhase, (FirResolvePhase)requestedPhase)) {
            ((Collection)this.exceptions).add(new FirLazyResolveContractViolationException(currentPhase, requestedPhase));
        }
    }
}

