/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.configuration;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsKt;
import org.jetbrains.kotlin.load.java.JavaNullabilityAnnotationSettingsKt;
import org.jetbrains.kotlin.load.java.JavaTypeEnhancementState;
import org.jetbrains.kotlin.load.java.Jsr305Settings;
import org.jetbrains.kotlin.load.java.NullabilityAnnotationStates;
import org.jetbrains.kotlin.load.java.NullabilityAnnotationStatesImpl;
import org.jetbrains.kotlin.load.java.ReportLevel;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.MockLibraryUtil;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.directives.ForeignAnnotationsDirectives;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.JUnit5Assertions;
import org.jetbrains.kotlin.test.services.KotlinStandardLibrariesPathProviderKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.AdditionalClassPathForJavaCompilationOrAnalysis;
import org.jetbrains.kotlin.test.services.configuration.JavaForeignAnnotationType;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u000b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/JvmForeignAnnotationsConfigurator;", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "provideAdditionalAnalysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "directives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "configureCompilerConfiguration", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "createJsr305Jar", "Ljava/io/File;", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nJvmForeignAnnotationsConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmForeignAnnotationsConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/JvmForeignAnnotationsConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1611#2,9:136\n1863#2:145\n1864#2:148\n1620#2:149\n1557#2:150\n1628#2,3:151\n1557#2:154\n1628#2,3:155\n1557#2:158\n1628#2,3:159\n1#3:146\n1#3:147\n*S KotlinDebug\n*F\n+ 1 JvmForeignAnnotationsConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/JvmForeignAnnotationsConfigurator\n*L\n58#1:136,9\n58#1:145\n58#1:148\n58#1:149\n99#1:150\n99#1:151,3\n115#1:154\n115#1:155,3\n131#1:158\n131#1:159,3\n58#1:147\n*E\n"})
public class JvmForeignAnnotationsConfigurator
extends EnvironmentConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String JSR_305_TEST_ANNOTATIONS_PATH = "compiler/testData/diagnostics/helpers/jsr305_test_annotations";

    public JvmForeignAnnotationsConfigurator(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)ForeignAnnotationsDirectives.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<AnalysisFlag<?>, Object> provideAdditionalAnalysisFlags(@NotNull RegisteredDirectives directives, @NotNull LanguageVersion languageVersion) {
        Map map;
        void $this$mapNotNullTo$iv$iv;
        ReportLevel reportLevel;
        ReportLevel globalState;
        Intrinsics.checkNotNullParameter((Object)directives, (String)"directives");
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        if (!directives.contains(ForeignAnnotationsDirectives.INSTANCE.getENABLE_FOREIGN_ANNOTATIONS())) {
            return MapsKt.emptyMap();
        }
        Jsr305Settings defaultJsr305Settings = JavaNullabilityAnnotationSettingsKt.getDefaultJsr305Settings((KotlinVersion)LanguageVersionSettingsKt.toKotlinVersion((LanguageVersion)languageVersion));
        ReportLevel reportLevel2 = DirectiveKt.singleOrZeroValue(directives, ForeignAnnotationsDirectives.INSTANCE.getJSR305_GLOBAL_REPORT());
        if (reportLevel2 == null) {
            reportLevel2 = globalState = defaultJsr305Settings.getGlobalLevel();
        }
        if ((reportLevel = DirectiveKt.singleOrZeroValue(directives, ForeignAnnotationsDirectives.INSTANCE.getJSR305_MIGRATION_REPORT())) == null) {
            reportLevel = defaultJsr305Settings.getMigrationLevel();
        }
        ReportLevel migrationState = reportLevel;
        Iterable $this$mapNotNull$iv = directives.get(ForeignAnnotationsDirectives.INSTANCE.getJSR305_SPECIAL_REPORT());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Object object = new String[]{":"};
            Object it2 = object = StringsKt.split$default((CharSequence)it, (String[])object, (boolean)false, (int)0, (int)6, null);
            boolean bl3 = false;
            if ((it2.size() == 2 ? object : null) == null) {
                pair = null;
            } else {
                ReportLevel state;
                Object object2;
                object2 = object2;
                String name = (String)object2.get(0);
                String stateDescription = (String)object2.get(1);
                pair = ReportLevel.Companion.findByDescription(stateDescription) == null ? null : TuplesKt.to((Object)new FqName(name), (Object)state);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map userAnnotationsState = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Map $this$provideAdditionalAnalysisFlags_u24lambda_u243 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        ReportLevel reportLevel3 = DirectiveKt.singleOrZeroValue(directives, ForeignAnnotationsDirectives.INSTANCE.getJSPECIFY_STATE());
        if (reportLevel3 != null) {
            ReportLevel it = reportLevel3;
            boolean bl5 = false;
            $this$provideAdditionalAnalysisFlags_u24lambda_u243.put(JavaNullabilityAnnotationSettingsKt.getJSPECIFY_OLD_ANNOTATIONS_PACKAGE(), it);
            $this$provideAdditionalAnalysisFlags_u24lambda_u243.put(JavaNullabilityAnnotationSettingsKt.getJSPECIFY_ANNOTATIONS_PACKAGE(), it);
        }
        for (Pair<FqName, ReportLevel> pair : directives.get(ForeignAnnotationsDirectives.INSTANCE.getNULLABILITY_ANNOTATIONS())) {
            FqName fqname = (FqName)pair.component1();
            ReportLevel reportLevel4 = (ReportLevel)pair.component2();
            $this$provideAdditionalAnalysisFlags_u24lambda_u243.put(fqname, reportLevel4);
        }
        Map map2 = MapsKt.build((Map)map);
        NullabilityAnnotationStatesImpl configuredReportLevels = new NullabilityAnnotationStatesImpl(map2);
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)JvmAnalysisFlags.getJavaTypeEnhancementState(), (Object)new JavaTypeEnhancementState(new Jsr305Settings(globalState, migrationState, userAnnotationsState), arg_0 -> JvmForeignAnnotationsConfigurator.provideAdditionalAnalysisFlags$lambda$4(configuredReportLevels, arg_0))));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureCompilerConfiguration(@NotNull CompilerConfiguration configuration2, @NotNull TestModule module) {
        Collection collection;
        void $this$mapTo$iv$iv;
        File file;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        RegisteredDirectives registeredDirectives = module.getDirectives();
        if (!registeredDirectives.contains(ForeignAnnotationsDirectives.INSTANCE.getENABLE_FOREIGN_ANNOTATIONS())) {
            return;
        }
        JavaForeignAnnotationType javaForeignAnnotationType = (JavaForeignAnnotationType)((Object)CollectionsKt.singleOrNull(registeredDirectives.get(ForeignAnnotationsDirectives.INSTANCE.getANNOTATIONS_PATH())));
        if (javaForeignAnnotationType == null) {
            javaForeignAnnotationType = JavaForeignAnnotationType.Java8Annotations;
        }
        JavaForeignAnnotationType annotationPath = javaForeignAnnotationType;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempDirectory(null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        File it = file = path.toFile();
        boolean bl = false;
        File file2 = new File(annotationPath.getPath());
        Intrinsics.checkNotNull((Object)it);
        FilesKt.copyRecursively$default((File)file2, (File)it, (boolean)false, null, (int)6, null);
        File javaFilesDir = file;
        File jsr305JarFile = this.createJsr305Jar(configuration2);
        boolean useJava11ToCompileIncludedJavaFiles = CollectionsKt.singleOrNull(registeredDirectives.get(JvmEnvironmentConfigurationDirectives.INSTANCE.getJDK_KIND())) == TestJdkKind.FULL_JDK_11;
        String string = javaFilesDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Object object = string;
        Object object2 = JUnit5Assertions.INSTANCE;
        Iterable $this$map$iv = JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)configuration2);
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            File file3 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it2.getAbsolutePath());
        }
        List list = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)jsr305JarFile.getAbsolutePath());
        File foreignAnnotationsJar = MockLibraryUtil.compileJavaFilesLibraryToJar$default((String)object, "foreign-annotations", false, null, list, null, (Assertions)object2, useJava11ToCompileIncludedJavaFiles, 44, null);
        JvmArgumentsKt.addModularRootIfNotNull((CompilerConfiguration)configuration2, (boolean)useJava11ToCompileIncludedJavaFiles, (String)"java9_annotations", (File)foreignAnnotationsJar);
        this.getTestServices().register((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(AdditionalClassPathForJavaCompilationOrAnalysis.class), new AdditionalClassPathForJavaCompilationOrAnalysis(CollectionsKt.listOf((Object)jsr305JarFile.getAbsolutePath())));
        JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration2, (File)KotlinStandardLibrariesPathProviderKt.getStandardLibrariesPathProvider(this.getTestServices()).jvmAnnotationsForTests());
        if (registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getWITH_JSR305_TEST_ANNOTATIONS())) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            object2 = new FileAttribute[]{};
            Path path2 = Files.createTempDirectory(null, Arrays.copyOf(object2, ((FileAttribute[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createTempDirectory(...)");
            Object it3 = object = path2.toFile();
            boolean bl3 = false;
            File file4 = new File(JSR_305_TEST_ANNOTATIONS_PATH);
            Intrinsics.checkNotNull((Object)it3);
            FilesKt.copyRecursively$default((File)file4, (File)it3, (boolean)false, null, (int)6, null);
            Object jsr305AnnotationsDir = object;
            String string2 = ((File)jsr305AnnotationsDir).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            object2 = string2;
            JUnit5Assertions jUnit5Assertions = JUnit5Assertions.INSTANCE;
            Iterable $i$f$map2 = JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)configuration2);
            collection = configuration2;
            boolean $i$f$map3 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it4;
                File bl2 = (File)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl4 = false;
                collection2.add(it4.getAbsolutePath());
            }
            List list2 = CollectionsKt.plus((Collection)((List)destination$iv$iv2), (Object)jsr305JarFile.getAbsolutePath());
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)collection, (File)MockLibraryUtil.compileJavaFilesLibraryToJar$default((String)object2, "jsr-305-test-annotations", false, null, list2, null, jUnit5Assertions, false, 172, null));
            File file5 = KtTestUtil.getAnnotationsJar();
            Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"getAnnotationsJar(...)");
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration2, (File)file5);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final File createJsr305Jar(CompilerConfiguration configuration2) {
        void $this$mapTo$iv$iv;
        File file;
        Object object = new FileAttribute[]{};
        Path path = Files.createTempDirectory(null, Arrays.copyOf(object, ((FileAttribute[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        File it = file = path.toFile();
        boolean bl = false;
        File file2 = new File(JavaForeignAnnotationType.Jsr305.getPath());
        Intrinsics.checkNotNull((Object)it);
        FilesKt.copyRecursively$default((File)file2, (File)it, (boolean)false, null, (int)6, null);
        File jsr305FilesDir = file;
        String string = jsr305FilesDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        object = string;
        JUnit5Assertions jUnit5Assertions = JUnit5Assertions.INSTANCE;
        Iterable $this$map$iv = JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)configuration2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            File file3 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it2.getAbsolutePath());
        }
        List list = (List)destination$iv$iv;
        return MockLibraryUtil.compileJavaFilesLibraryToJar$default((String)object, "jsr305", false, null, list, null, jUnit5Assertions, false, 172, null);
    }

    private static final ReportLevel provideAdditionalAnalysisFlags$lambda$4(NullabilityAnnotationStatesImpl $configuredReportLevels, FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JavaNullabilityAnnotationSettingsKt.getReportLevelForAnnotation$default((FqName)it, (NullabilityAnnotationStates)((NullabilityAnnotationStates)$configuredReportLevels), null, (int)4, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/JvmForeignAnnotationsConfigurator$Companion;", "", "<init>", "()V", "JSR_305_TEST_ANNOTATIONS_PATH", "", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

