/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.TestSetupUtilsKt;
import org.jetbrains.kotlin.test.frontend.K1AndK2OutputArtifact;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontendFacade;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontendOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.FirFrontendFacade;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.model.FrontendFacade;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManagerKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/test/frontend/K1AndK2FrontendFacade;", "Lorg/jetbrains/kotlin/test/model/FrontendFacade;", "Lorg/jetbrains/kotlin/test/frontend/K1AndK2OutputArtifact;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "additionalServices", "", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "()Ljava/util/List;", "classicFrontendFacade", "Lorg/jetbrains/kotlin/test/frontend/classic/ClassicFrontendFacade;", "firFrontendFacade", "Lorg/jetbrains/kotlin/test/frontend/fir/FirFrontendFacade;", "analyze", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "tests-common-new_test"})
public final class K1AndK2FrontendFacade
extends FrontendFacade<K1AndK2OutputArtifact> {
    @NotNull
    private final ClassicFrontendFacade classicFrontendFacade;
    @NotNull
    private final FirFrontendFacade firFrontendFacade;

    public K1AndK2FrontendFacade(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, FrontendKinds.ClassicAndFIR.INSTANCE);
        this.classicFrontendFacade = new ClassicFrontendFacade(testServices);
        this.firFrontendFacade = new FirFrontendFacade(testServices);
    }

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        return CollectionsKt.plus((Collection)this.classicFrontendFacade.getAdditionalServices(), (Iterable)this.firFrontendFacade.getAdditionalServices());
    }

    @Override
    @NotNull
    public K1AndK2OutputArtifact analyze(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices()).setSpecifiedFrontendKind(FrontendKinds.ClassicFrontend.INSTANCE);
        ClassicFrontendOutputArtifact k1Artifact = this.classicFrontendFacade.analyze(module);
        CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices()).setSpecifiedFrontendKind(FrontendKinds.FIR.INSTANCE);
        FirOutputArtifact k2Artifact = (FirOutputArtifact)TestSetupUtilsKt.runWithEnablingFirUseOption(this.getTestServices(), module, () -> K1AndK2FrontendFacade.analyze$lambda$0(this, module));
        return new K1AndK2OutputArtifact(k1Artifact, k2Artifact);
    }

    private static final FirOutputArtifact analyze$lambda$0(K1AndK2FrontendFacade this$0, TestModule $module) {
        return this$0.firFrontendFacade.analyze($module);
    }
}

