/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.cli;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.test.cli.CliDiagnostic;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J\b\u0010 \u001a\u00020\u0017H\u0016J\b\u0010!\u001a\u00020\u0017H\u0016R\u0018\u0010\u0004\u001a\n \u0005*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/test/cli/DiagnosticCollectingMessageRenderer;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "<init>", "()V", "delegate", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "diagnostics", "", "Lorg/jetbrains/kotlin/test/cli/CliDiagnostic;", "getDiagnostics", "()Ljava/util/List;", "otherOutput", "Ljava/lang/StringBuilder;", "getOtherOutput", "()Ljava/lang/StringBuilder;", "hasErrors", "", "getHasErrors", "()Z", "setHasErrors", "(Z)V", "render", "", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "renderPreamble", "renderUsage", "usage", "renderConclusion", "getName", "Companion", "tests-common-new_test"})
final class DiagnosticCollectingMessageRenderer
implements MessageRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final MessageRenderer delegate = MessageRenderer.PLAIN_RELATIVE_PATHS;
    @NotNull
    private final List<CliDiagnostic> diagnostics = new ArrayList();
    @NotNull
    private final StringBuilder otherOutput = new StringBuilder();
    private boolean hasErrors;
    @NotNull
    private static final Regex diagnosticNameRegex = new Regex("\\[([A-Z_0-9]+)\\]");

    @NotNull
    public final List<CliDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final StringBuilder getOtherOutput() {
        return this.otherOutput;
    }

    public final boolean getHasErrors() {
        return this.hasErrors;
    }

    public final void setHasErrors(boolean bl) {
        this.hasErrors = bl;
    }

    @NotNull
    public String render(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
        MatchResult matchResult;
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (severity.isError()) {
            this.hasErrors = true;
        }
        if (location != null && (matchResult = diagnosticNameRegex.matchAt((CharSequence)message, 0)) != null) {
            String diagnosticName = (String)matchResult.getDestructured().getMatch().getGroupValues().get(1);
            this.diagnostics.add(new CliDiagnostic(diagnosticName, location.getLine(), location.getLineEnd(), location.getColumn(), location.getColumnEnd()));
            return "";
        }
        StringBuilder stringBuilder = this.otherOutput.append(this.delegate.render(severity, message, location));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        return "";
    }

    @NotNull
    public String renderPreamble() {
        return "";
    }

    @NotNull
    public String renderUsage(@NotNull String usage) {
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        AddToStdlibKt.shouldNotBeCalled$default(null, (int)1, null);
        throw null;
    }

    @NotNull
    public String renderConclusion() {
        return "";
    }

    @NotNull
    public String getName() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/cli/DiagnosticCollectingMessageRenderer$Companion;", "", "<init>", "()V", "diagnosticNameRegex", "Lkotlin/text/Regex;", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

