/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic.handlers;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.UnmodifiableIterator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codeMetaInfo.model.ParsedCodeMetaInfo;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.descriptors.PackageDescriptorUtilKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontendOutputArtifact;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicFrontendAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 12\u00020\u0001:\u000212B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0002J \u0010&\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0002J&\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010(2\u0006\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001eH\u0002J\u001a\u00100\u001a\u0004\u0018\u00010 2\u0006\u0010)\u001a\u00020#2\u0006\u0010/\u001a\u00020\u001eH\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ConstantValuesHandler;", "Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicFrontendAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "metaInfoHandler", "Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/classic/ClassicFrontendOutputArtifact;", "processFile", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "mode", "Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ConstantValuesHandler$Mode;", "processAfterAllModules", "someAssertionWasFailed", "", "checkConstant", "", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "checkIsPure", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "project", "Lcom/intellij/openapi/project/Project;", "checkVariableAsConstant", "evaluateInitializer", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "context", "property", "getPropertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "name", "getLocalVarDescriptor", "Companion", "Mode", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nConstantValuesHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantValuesHandler.kt\norg/jetbrains/kotlin/test/frontend/classic/handlers/ConstantValuesHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n774#2:159\n865#2,2:160\n*S KotlinDebug\n*F\n+ 1 ConstantValuesHandler.kt\norg/jetbrains/kotlin/test/frontend/classic/handlers/ConstantValuesHandler\n*L\n65#1:159\n65#1:160,2\n*E\n"})
public final class ConstantValuesHandler
extends ClassicFrontendAnalysisHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GlobalMetadataInfoHandler metaInfoHandler;
    @NotNull
    private static final String DEBUG_INFO_CONSTANT = "DEBUG_INFO_CONSTANT_VALUE";
    @NotNull
    private static final Regex propertyNameMatchingRegex = new Regex("val ([\\w\\d]+)(: .*)? =");

    public ConstantValuesHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, false, 6, null);
        this.metaInfoHandler = GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)DiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull ClassicFrontendOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Mode mode = DirectiveKt.singleOrZeroValue(module.getDirectives(), DiagnosticsDirectives.INSTANCE.getCHECK_COMPILE_TIME_VALUES());
        if (mode == null) {
            return;
        }
        Mode mode2 = mode;
        for (Map.Entry<TestFile, KtFile> entry : info.getKtFiles().entrySet()) {
            TestFile file = entry.getKey();
            KtFile ktFile = entry.getValue();
            this.processFile(file, ktFile, info, mode2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processFile(TestFile file, KtFile ktFile, ClassicFrontendOutputArtifact info, Mode mode) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.metaInfoHandler.getExistingMetaInfosForFile(file);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ParsedCodeMetaInfo it = (ParsedCodeMetaInfo)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTag(), (Object)DEBUG_INFO_CONSTANT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List expectedMetaInfos = (List)destination$iv$iv;
        String fileText = ktFile.getText();
        PackageFragmentDescriptor packageFragmentDescriptor = PackageDescriptorUtilKt.findPackageFragmentForFile((ModuleDescriptor)info.getAnalysisResult().getModuleDescriptor(), (KtFile)ktFile);
        if (packageFragmentDescriptor == null) {
            return;
        }
        PackageFragmentDescriptor packageFragmentDescriptor2 = packageFragmentDescriptor;
        BindingContext bindingContext = info.getAnalysisResult().getBindingContext();
        Project project = info.getProject();
        List actualMetaInfos = new ArrayList();
        for (ParsedCodeMetaInfo expectedMetaInfo : expectedMetaInfos) {
            String string;
            VariableDescriptor variableDescriptor;
            String markedText;
            int start = expectedMetaInfo.getStart();
            int end = expectedMetaInfo.getEnd();
            Intrinsics.checkNotNull((Object)fileText);
            Intrinsics.checkNotNullExpressionValue((Object)fileText.substring(start, end), (String)"substring(...)");
            Object object = Regex.find$default((Regex)propertyNameMatchingRegex, (CharSequence)markedText, (int)0, (int)2, null);
            if (object == null || (object = object.getGroups()) == null || (object = object.get(1)) == null || (object = object.getValue()) == null) continue;
            Object propertyName = object;
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(packageFragmentDescriptor2, (String)propertyName);
            if (propertyDescriptor != null) {
                variableDescriptor = (VariableDescriptor)propertyDescriptor;
            } else {
                variableDescriptor = this.getLocalVarDescriptor(bindingContext, (String)propertyName);
                if (variableDescriptor == null) continue;
            }
            VariableDescriptor propertyDescriptor2 = variableDescriptor;
            switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                case 1: {
                    string = this.checkConstant(propertyDescriptor2);
                    break;
                }
                case 2: {
                    string = this.checkIsPure(bindingContext, propertyDescriptor2, project);
                    break;
                }
                case 3: {
                    string = this.checkVariableAsConstant(bindingContext, propertyDescriptor2, project);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String actualValue = string;
            ((Collection)actualMetaInfos).add(new ParsedCodeMetaInfo(start, end, new ArrayList(), DEBUG_INFO_CONSTANT, actualValue));
        }
        this.metaInfoHandler.addMetadataInfosForFile(file, actualMetaInfos);
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }

    private final String checkConstant(VariableDescriptor variableDescriptor) {
        ConstantValue compileTimeConstant = variableDescriptor.getCompileTimeInitializer();
        return compileTimeConstant instanceof StringValue ? "\\\"" + (String)((StringValue)compileTimeConstant).getValue() + "\\\"" : String.valueOf(compileTimeConstant);
    }

    private final String checkIsPure(BindingContext bindingContext, VariableDescriptor variableDescriptor, Project project) {
        CompileTimeConstant<?> compileTimeConstant = this.evaluateInitializer(bindingContext, variableDescriptor, project);
        return String.valueOf(compileTimeConstant != null ? Boolean.valueOf(compileTimeConstant.isPure()) : null);
    }

    private final String checkVariableAsConstant(BindingContext bindingContext, VariableDescriptor variableDescriptor, Project project) {
        CompileTimeConstant<?> compileTimeConstant = this.evaluateInitializer(bindingContext, variableDescriptor, project);
        return String.valueOf(compileTimeConstant != null ? Boolean.valueOf(compileTimeConstant.getUsesVariableAsConstant()) : null);
    }

    private final CompileTimeConstant<?> evaluateInitializer(BindingContext context, VariableDescriptor property, Project project) {
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)property));
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
        KtProperty propertyDeclaration = (KtProperty)psiElement;
        ConstantExpressionEvaluator constantExpressionEvaluator = new ConstantExpressionEvaluator(DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)property)), (LanguageVersionSettings)LanguageVersionSettingsImpl.DEFAULT, project, null, 8, null);
        KtExpression ktExpression = propertyDeclaration.getInitializer();
        Intrinsics.checkNotNull((Object)ktExpression);
        return constantExpressionEvaluator.evaluateExpression(ktExpression, (BindingTrace)new DelegatingBindingTrace(context, "trace for evaluating compile time constant", false, null, false, null, 60, null), property.getType());
    }

    private final PropertyDescriptor getPropertyDescriptor(PackageFragmentDescriptor packageView, String name) {
        Name name2 = Name.identifier((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        Name propertyName = name2;
        MemberScope memberScope = packageView.getMemberScope();
        Collection properties = memberScope.getContributedVariables(propertyName, (LookupLocation)NoLookupLocation.FROM_TEST);
        if (properties.isEmpty()) {
            for (DeclarationDescriptor descriptor : DescriptorUtils.getAllDescriptors((MemberScope)memberScope)) {
                Collection classProperties;
                if (!(descriptor instanceof ClassDescriptor) || (classProperties = ((ClassDescriptor)descriptor).getMemberScope(CollectionsKt.emptyList()).getContributedVariables(propertyName, (LookupLocation)NoLookupLocation.FROM_TEST)).isEmpty()) continue;
                properties = classProperties;
                break;
            }
        }
        if (properties.size() != 1) {
            return null;
        }
        return (PropertyDescriptor)properties.iterator().next();
    }

    private final VariableDescriptor getLocalVarDescriptor(BindingContext context, String name) {
        UnmodifiableIterator unmodifiableIterator = ((ImmutableCollection)context.getSliceContents((ReadOnlySlice)BindingContext.VARIABLE).values()).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)unmodifiableIterator, (String)"iterator(...)");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        while (unmodifiableIterator2.hasNext()) {
            VariableDescriptor descriptor = (VariableDescriptor)unmodifiableIterator2.next();
            if (!Intrinsics.areEqual((Object)descriptor.getName().asString(), (Object)name)) continue;
            return descriptor;
        }
        TestCase.fail((String)("Failed to find local variable " + name));
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ConstantValuesHandler$Companion;", "", "<init>", "()V", "DEBUG_INFO_CONSTANT", "", "propertyNameMatchingRegex", "Lkotlin/text/Regex;", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ConstantValuesHandler$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "Constant", "IsPure", "UsesVariableAsConstant", "tests-common-new_test"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode Constant = new Mode();
        public static final /* enum */ Mode IsPure = new Mode();
        public static final /* enum */ Mode UsesVariableAsConstant = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.Constant, Mode.IsPure, Mode.UsesVariableAsConstant};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.Constant.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.IsPure.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.UsesVariableAsConstant.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

