/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.runners.AbstractJvmAbiConsistencyTest;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

public class JvmAbiConsistencyTestRestGenerated
extends AbstractJvmAbiConsistencyTest {

    @Nested
    @TestMetadata(value="compiler/testData/codegen/script")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Script {
        @Test
        @TestMetadata(value="adder.kts")
        public void testAdder() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/adder.kts");
        }

        @Test
        public void testAllFilesPresentInScript() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/script"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="classLiteralInsideFunction.kts")
        public void testClassLiteralInsideFunction() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/classLiteralInsideFunction.kts");
        }

        @Test
        @TestMetadata(value="destructuringDeclaration.kts")
        public void testDestructuringDeclaration() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/destructuringDeclaration.kts");
        }

        @Test
        @TestMetadata(value="destructuringDeclarationUnderscore.kts")
        public void testDestructuringDeclarationUnderscore() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/destructuringDeclarationUnderscore.kts");
        }

        @Test
        @TestMetadata(value="empty.kts")
        public void testEmpty() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/empty.kts");
        }

        @Test
        @TestMetadata(value="helloWorld.kts")
        public void testHelloWorld() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/helloWorld.kts");
        }

        @Test
        @TestMetadata(value="inline.kts")
        public void testInline() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/inline.kts");
        }

        @Test
        @TestMetadata(value="innerClass.kts")
        public void testInnerClass() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/innerClass.kts");
        }

        @Test
        @TestMetadata(value="kt20707.kts")
        public void testKt20707() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/kt20707.kts");
        }

        @Test
        @TestMetadata(value="kt22029.kts")
        public void testKt22029() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/kt22029.kts");
        }

        @Test
        @TestMetadata(value="kt48025.kts")
        public void testKt48025() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/kt48025.kts");
        }

        @Test
        @TestMetadata(value="localDelegatedProperty.kts")
        public void testLocalDelegatedProperty() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/localDelegatedProperty.kts");
        }

        @Test
        @TestMetadata(value="localDelegatedPropertyInLambda.kts")
        public void testLocalDelegatedPropertyInLambda() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/localDelegatedPropertyInLambda.kts");
        }

        @Test
        @TestMetadata(value="localDelegatedPropertyNoExplicitType.kts")
        public void testLocalDelegatedPropertyNoExplicitType() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/localDelegatedPropertyNoExplicitType.kts");
        }

        @Test
        @TestMetadata(value="localFunction.kts")
        public void testLocalFunction() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/localFunction.kts");
        }

        @Test
        @TestMetadata(value="outerCapture.kts")
        public void testOuterCapture() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/outerCapture.kts");
        }

        @Test
        @TestMetadata(value="parameter.kts")
        public void testParameter() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/parameter.kts");
        }

        @Test
        @TestMetadata(value="parameterArray.kts")
        public void testParameterArray() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/parameterArray.kts");
        }

        @Test
        @TestMetadata(value="parameterClosure.kts")
        public void testParameterClosure() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/parameterClosure.kts");
        }

        @Test
        @TestMetadata(value="parameterLong.kts")
        public void testParameterLong() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/parameterLong.kts");
        }

        @Test
        @TestMetadata(value="secondLevelFunction.kts")
        public void testSecondLevelFunction() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/secondLevelFunction.kts");
        }

        @Test
        @TestMetadata(value="secondLevelFunctionClosure.kts")
        public void testSecondLevelFunctionClosure() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/secondLevelFunctionClosure.kts");
        }

        @Test
        @TestMetadata(value="secondLevelVal.kts")
        public void testSecondLevelVal() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/secondLevelVal.kts");
        }

        @Test
        @TestMetadata(value="simpleClass.kts")
        public void testSimpleClass() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/simpleClass.kts");
        }

        @Test
        @TestMetadata(value="string.kts")
        public void testString() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/string.kts");
        }

        @Test
        @TestMetadata(value="topLevelFunction.kts")
        public void testTopLevelFunction() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/topLevelFunction.kts");
        }

        @Test
        @TestMetadata(value="topLevelFunctionClosure.kts")
        public void testTopLevelFunctionClosure() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/topLevelFunctionClosure.kts");
        }

        @Test
        @TestMetadata(value="topLevelLocalDelegatedProperty.kts")
        public void testTopLevelLocalDelegatedProperty() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/topLevelLocalDelegatedProperty.kts");
        }

        @Test
        @TestMetadata(value="topLevelPropertiesWithGetSet.kts")
        public void testTopLevelPropertiesWithGetSet() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/topLevelPropertiesWithGetSet.kts");
        }

        @Test
        @TestMetadata(value="topLevelProperty.kts")
        public void testTopLevelProperty() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/topLevelProperty.kts");
        }

        @Test
        @TestMetadata(value="topLevelPropertyWithProvideDelegate.kts")
        public void testTopLevelPropertyWithProvideDelegate() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/topLevelPropertyWithProvideDelegate.kts");
        }

        @Test
        @TestMetadata(value="topLevelTypealias.kts")
        public void testTopLevelTypealias() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/topLevelTypealias.kts");
        }

        @Test
        @TestMetadata(value="twoDestructuringDeclarations.kts")
        public void testTwoDestructuringDeclarations() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/twoDestructuringDeclarations.kts");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/script/scriptInstanceCapturing")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ScriptInstanceCapturing {
            @Test
            public void testAllFilesPresentInScriptInstanceCapturing() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/script/scriptInstanceCapturing"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="anonymousObjectCapturesProperty.kts")
            public void testAnonymousObjectCapturesProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/anonymousObjectCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="classCapturesExtensionIndirect.kts")
            public void testClassCapturesExtensionIndirect() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesExtensionIndirect.kts");
            }

            @Test
            @TestMetadata(value="classCapturesExtensionIndirect2x.kts")
            public void testClassCapturesExtensionIndirect2x() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesExtensionIndirect2x.kts");
            }

            @Test
            @TestMetadata(value="classCapturesFunction.kts")
            public void testClassCapturesFunction() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesFunction.kts");
            }

            @Test
            @TestMetadata(value="classCapturesProperty.kts")
            public void testClassCapturesProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="classCapturesPropertyInStringTemplate.kts")
            public void testClassCapturesPropertyInStringTemplate() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesPropertyInStringTemplate.kts");
            }

            @Test
            @TestMetadata(value="classCapturesPropertyIndirect.kts")
            public void testClassCapturesPropertyIndirect() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesPropertyIndirect.kts");
            }

            @Test
            @TestMetadata(value="classCapturesPropertyIndirect2x.kts")
            public void testClassCapturesPropertyIndirect2x() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesPropertyIndirect2x.kts");
            }

            @Test
            @TestMetadata(value="companionCapturesProperty.kts")
            public void testCompanionCapturesProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/companionCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="enumCapturesProperty.kts")
            public void testEnumCapturesProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/enumCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="enumEntryCapturesProperty.kts")
            public void testEnumEntryCapturesProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/enumEntryCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="innerClassesHierarchyCaptureProperty.kts")
            public void testInnerClassesHierarchyCaptureProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/innerClassesHierarchyCaptureProperty.kts");
            }

            @Test
            @TestMetadata(value="interfaceCapturesProperty.kts")
            public void testInterfaceCapturesProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/interfaceCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="nestedAndOuterClassesCaptureProperty.kts")
            public void testNestedAndOuterClassesCaptureProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/nestedAndOuterClassesCaptureProperty.kts");
            }

            @Test
            @TestMetadata(value="nestedClassCapturesProperty.kts")
            public void testNestedClassCapturesProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/nestedClassCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="nestedInnerClassCapturesProperty.kts")
            public void testNestedInnerClassCapturesProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/nestedInnerClassCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="nestedToObjectClassCapturesProperty.kts")
            public void testNestedToObjectClassCapturesProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/nestedToObjectClassCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="objectCapturesProperty.kts")
            public void testObjectCapturesProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/objectCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="objectCapturesPropertyIndirect.kts")
            public void testObjectCapturesPropertyIndirect() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/objectCapturesPropertyIndirect.kts");
            }

            @Test
            @TestMetadata(value="objectCapturesPropertyViaExtension.kts")
            public void testObjectCapturesPropertyViaExtension() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/objectCapturesPropertyViaExtension.kts");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/defaultArguments")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DefaultArguments {
        @Test
        public void testAllFilesPresentInDefaultArguments() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/defaultArguments/reflection")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Reflection {
            @Test
            public void testAllFilesPresentInReflection() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/defaultArguments/reflection"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classInClassObject.kt")
            public void testClassInClassObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/classInClassObject.kt");
            }

            @Test
            @TestMetadata(value="classInObject.kt")
            public void testClassInObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/classInObject.kt");
            }

            @Test
            @TestMetadata(value="classWithTwoDefaultArgs.kt")
            public void testClassWithTwoDefaultArgs() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/classWithTwoDefaultArgs.kt");
            }

            @Test
            @TestMetadata(value="classWithVararg.kt")
            public void testClassWithVararg() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/classWithVararg.kt");
            }

            @Test
            @TestMetadata(value="enum.kt")
            public void testEnum() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/enum.kt");
            }

            @Test
            @TestMetadata(value="internalClass.kt")
            public void testInternalClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/internalClass.kt");
            }

            @Test
            @TestMetadata(value="privateClass.kt")
            public void testPrivateClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/privateClass.kt");
            }

            @Test
            @TestMetadata(value="privateConstructor.kt")
            public void testPrivateConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/privateConstructor.kt");
            }

            @Test
            @TestMetadata(value="publicClass.kt")
            public void testPublicClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/publicClass.kt");
            }

            @Test
            @TestMetadata(value="publicClassWoDefArgs.kt")
            public void testPublicClassWoDefArgs() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/publicClassWoDefArgs.kt");
            }

            @Test
            @TestMetadata(value="publicInnerClass.kt")
            public void testPublicInnerClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/publicInnerClass.kt");
            }

            @Test
            @TestMetadata(value="publicInnerClassInPrivateClass.kt")
            public void testPublicInnerClassInPrivateClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/publicInnerClassInPrivateClass.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/composeLikeBytecodeText")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ComposeLikeBytecodeText {
        @Test
        public void testAllFilesPresentInComposeLikeBytecodeText() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/composeLikeBytecodeText"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="default.kt")
        public void testDefault() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/composeLikeBytecodeText/default.kt");
        }

        @Test
        @TestMetadata(value="defaultInline.kt")
        public void testDefaultInline() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/composeLikeBytecodeText/defaultInline.kt");
        }

        @Test
        @TestMetadata(value="defaultLocal.kt")
        public void testDefaultLocal() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/composeLikeBytecodeText/defaultLocal.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/composeLike")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ComposeLike {
        @Test
        public void testAllFilesPresentInComposeLike() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/composeLike"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="default.kt")
        public void testDefault() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/composeLike/default.kt");
        }

        @Test
        @TestMetadata(value="defaultInline.kt")
        public void testDefaultInline() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/composeLike/defaultInline.kt");
        }

        @Test
        @TestMetadata(value="defaultLocal.kt")
        public void testDefaultLocal() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/composeLike/defaultLocal.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing")
    @TestDataPath(value="$PROJECT_ROOT")
    public class BytecodeListing {
        @Test
        @TestMetadata(value="accessorForProtectedPropertyWithPrivateSetter.kt")
        public void testAccessorForProtectedPropertyWithPrivateSetter() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/accessorForProtectedPropertyWithPrivateSetter.kt");
        }

        @Test
        @TestMetadata(value="accessorForProtectedPropertyWithPrivateSetterInObjectLiteral.kt")
        public void testAccessorForProtectedPropertyWithPrivateSetterInObjectLiteral() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/accessorForProtectedPropertyWithPrivateSetterInObjectLiteral.kt");
        }

        @Test
        @TestMetadata(value="accessorForTopLevelMembers.kt")
        public void testAccessorForTopLevelMembers() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/accessorForTopLevelMembers.kt");
        }

        @Test
        @TestMetadata(value="accessorsForProtectedStaticJavaFieldInOtherPackage.kt")
        public void testAccessorsForProtectedStaticJavaFieldInOtherPackage() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/accessorsForProtectedStaticJavaFieldInOtherPackage.kt");
        }

        @Test
        public void testAllFilesPresentInBytecodeListing() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="anonymousObjectInGenericFun.kt")
        public void testAnonymousObjectInGenericFun() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/anonymousObjectInGenericFun.kt");
        }

        @Test
        @TestMetadata(value="callableNameIntrinsic.kt")
        public void testCallableNameIntrinsic() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/callableNameIntrinsic.kt");
        }

        @Test
        @TestMetadata(value="callableReferenceArrayConstructorArguments.kt")
        public void testCallableReferenceArrayConstructorArguments() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/callableReferenceArrayConstructorArguments.kt");
        }

        @Test
        @TestMetadata(value="cloneable.kt")
        public void testCloneable() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/cloneable.kt");
        }

        @Test
        @TestMetadata(value="companionObjectVisibility_after.kt")
        public void testCompanionObjectVisibility_after() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/companionObjectVisibility_after.kt");
        }

        @Test
        @TestMetadata(value="companionObjectVisibility_before.kt")
        public void testCompanionObjectVisibility_before() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/companionObjectVisibility_before.kt");
        }

        @Test
        @TestMetadata(value="defaultImpls.kt")
        public void testDefaultImpls() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/defaultImpls.kt");
        }

        @Test
        @TestMetadata(value="delegationToJavaInterfaceWithWildcardType.kt")
        public void testDelegationToJavaInterfaceWithWildcardType() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/delegationToJavaInterfaceWithWildcardType.kt");
        }

        @Test
        @TestMetadata(value="deprecatedConstantPropertyInterfaceCompanion.kt")
        public void testDeprecatedConstantPropertyInterfaceCompanion() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecatedConstantPropertyInterfaceCompanion.kt");
        }

        @Test
        @TestMetadata(value="deserializeLambdaMethod.kt")
        public void testDeserializeLambdaMethod() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deserializeLambdaMethod.kt");
        }

        @Test
        @TestMetadata(value="enum.kt")
        public void testEnum() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/enum.kt");
        }

        @Test
        @TestMetadata(value="enumEntries.kt")
        public void testEnumEntries() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/enumEntries.kt");
        }

        @Test
        @TestMetadata(value="extension.kt")
        public void testExtension() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/extension.kt");
        }

        @Test
        @TestMetadata(value="fileClassWithPrivateDeclarationsOnly_after.kt")
        public void testFileClassWithPrivateDeclarationsOnly_after() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/fileClassWithPrivateDeclarationsOnly_after.kt");
        }

        @Test
        @TestMetadata(value="fileClassWithPrivateDeclarationsOnly_before.kt")
        public void testFileClassWithPrivateDeclarationsOnly_before() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/fileClassWithPrivateDeclarationsOnly_before.kt");
        }

        @Test
        @TestMetadata(value="immutableCollection.kt")
        public void testImmutableCollection() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/immutableCollection.kt");
        }

        @Test
        @TestMetadata(value="javaDeprecated.kt")
        public void testJavaDeprecated() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/javaDeprecated.kt");
        }

        @Test
        @TestMetadata(value="jvmOverloadsAndParametersAnnotations.kt")
        public void testJvmOverloadsAndParametersAnnotations() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvmOverloadsAndParametersAnnotations.kt");
        }

        @Test
        @TestMetadata(value="jvmOverloadsExternal.kt")
        public void testJvmOverloadsExternal() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvmOverloadsExternal.kt");
        }

        @Test
        @TestMetadata(value="jvmRecordStructure.kt")
        public void testJvmRecordStructure() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvmRecordStructure.kt");
        }

        @Test
        @TestMetadata(value="kt42137.kt")
        public void testKt42137() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt42137.kt");
        }

        @Test
        @TestMetadata(value="kt42879.kt")
        public void testKt42879() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt42879.kt");
        }

        @Test
        @TestMetadata(value="kt43217.kt")
        public void testKt43217() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt43217.kt");
        }

        @Test
        @TestMetadata(value="kt43440.kt")
        public void testKt43440() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt43440.kt");
        }

        @Test
        @TestMetadata(value="kt45853.kt")
        public void testKt45853() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt45853.kt");
        }

        @Test
        @TestMetadata(value="kt45853a.kt")
        public void testKt45853a() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt45853a.kt");
        }

        @Test
        @TestMetadata(value="kt45934.kt")
        public void testKt45934() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt45934.kt");
        }

        @Test
        @TestMetadata(value="kt47328.kt")
        public void testKt47328() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt47328.kt");
        }

        @Test
        @TestMetadata(value="kt55769.kt")
        public void testKt55769() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt55769.kt");
        }

        @Test
        @TestMetadata(value="noCollectionStubMethodsInInterface.kt")
        public void testNoCollectionStubMethodsInInterface() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/noCollectionStubMethodsInInterface.kt");
        }

        @Test
        @TestMetadata(value="noDelegationsToPrivateInterfaceMembers.kt")
        public void testNoDelegationsToPrivateInterfaceMembers() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/noDelegationsToPrivateInterfaceMembers.kt");
        }

        @Test
        @TestMetadata(value="noReceiverInCallableReferenceClasses.kt")
        public void testNoReceiverInCallableReferenceClasses() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/noReceiverInCallableReferenceClasses.kt");
        }

        @Test
        @TestMetadata(value="noRemoveAtInReadOnly.kt")
        public void testNoRemoveAtInReadOnly() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/noRemoveAtInReadOnly.kt");
        }

        @Test
        @TestMetadata(value="overrideWithPrimitiveUpperBound.kt")
        public void testOverrideWithPrimitiveUpperBound() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/overrideWithPrimitiveUpperBound.kt");
        }

        @Test
        @TestMetadata(value="overrideWithPrimitiveUpperBound2.kt")
        public void testOverrideWithPrimitiveUpperBound2() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/overrideWithPrimitiveUpperBound2.kt");
        }

        @Test
        @TestMetadata(value="privateCompanionFields.kt")
        public void testPrivateCompanionFields() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/privateCompanionFields.kt");
        }

        @Test
        @TestMetadata(value="privateDefaultImpls.kt")
        public void testPrivateDefaultImpls() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/privateDefaultImpls.kt");
        }

        @Test
        @TestMetadata(value="privateDefaultSetter.kt")
        public void testPrivateDefaultSetter() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/privateDefaultSetter.kt");
        }

        @Test
        @TestMetadata(value="privateNestedClassInInterface.kt")
        public void testPrivateNestedClassInInterface() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/privateNestedClassInInterface.kt");
        }

        @Test
        @TestMetadata(value="rawTypeInSignature.kt")
        public void testRawTypeInSignature() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/rawTypeInSignature.kt");
        }

        @Test
        @TestMetadata(value="strictfpFlag.kt")
        public void testStrictfpFlag() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/strictfpFlag.kt");
        }

        @Test
        @TestMetadata(value="synchronizedFlag.kt")
        public void testSynchronizedFlag() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/synchronizedFlag.kt");
        }

        @Test
        @TestMetadata(value="varargsBridge.kt")
        public void testVarargsBridge() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/varargsBridge.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/valueClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ValueClasses {
            @Test
            public void testAllFilesPresentInValueClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/valueClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="annotations.kt")
            public void testAnnotations() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/valueClasses/annotations.kt");
            }

            @Test
            @TestMetadata(value="nullabilityAnnotationsOnInlineClassMembers.kt")
            public void testNullabilityAnnotationsOnInlineClassMembers() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/valueClasses/nullabilityAnnotationsOnInlineClassMembers.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/specialBridges")
        @TestDataPath(value="$PROJECT_ROOT")
        public class SpecialBridges {
            @Test
            @TestMetadata(value="abstractCollections.kt")
            public void testAbstractCollections() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractCollections.kt");
            }

            @Test
            @TestMetadata(value="abstractIterables.kt")
            public void testAbstractIterables() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractIterables.kt");
            }

            @Test
            @TestMetadata(value="abstractLists.kt")
            public void testAbstractLists() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractLists.kt");
            }

            @Test
            @TestMetadata(value="abstractListsWithJavaBase.kt")
            public void testAbstractListsWithJavaBase() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractListsWithJavaBase.kt");
            }

            @Test
            @TestMetadata(value="abstractMutableCollectionOfPrimitive.kt")
            public void testAbstractMutableCollectionOfPrimitive() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableCollectionOfPrimitive.kt");
            }

            @Test
            @TestMetadata(value="abstractMutableListOfPrimitive.kt")
            public void testAbstractMutableListOfPrimitive() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableListOfPrimitive.kt");
            }

            @Test
            @TestMetadata(value="abstractMutableLists.kt")
            public void testAbstractMutableLists() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableLists.kt");
            }

            @Test
            @TestMetadata(value="abstractSets.kt")
            public void testAbstractSets() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractSets.kt");
            }

            @Test
            public void testAllFilesPresentInSpecialBridges() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/specialBridges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="charSequence.kt")
            public void testCharSequence() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/charSequence.kt");
            }

            @Test
            @TestMetadata(value="contains.kt")
            public void testContains() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/contains.kt");
            }

            @Test
            @TestMetadata(value="kt41123.kt")
            public void testKt41123() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/kt41123.kt");
            }

            @Test
            @TestMetadata(value="kt48945.kt")
            public void testKt48945() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/kt48945.kt");
            }

            @Test
            @TestMetadata(value="mutableCollectionOfPrimitive.kt")
            public void testMutableCollectionOfPrimitive() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/mutableCollectionOfPrimitive.kt");
            }

            @Test
            @TestMetadata(value="mutableListOfPrimitive.kt")
            public void testMutableListOfPrimitive() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/mutableListOfPrimitive.kt");
            }

            @Test
            @TestMetadata(value="noDefaultImplsOnEmptySubInterface.kt")
            public void testNoDefaultImplsOnEmptySubInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/noDefaultImplsOnEmptySubInterface.kt");
            }

            @Test
            @TestMetadata(value="noSpecialBridgeIfPresentInSuperClass.kt")
            public void testNoSpecialBridgeIfPresentInSuperClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/noSpecialBridgeIfPresentInSuperClass.kt");
            }

            @Test
            @TestMetadata(value="number.kt")
            public void testNumber() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/number.kt");
            }

            @Test
            @TestMetadata(value="redundantStubForSize.kt")
            public void testRedundantStubForSize() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/redundantStubForSize.kt");
            }

            @Test
            @TestMetadata(value="removeAtTwoSpecialBridges.kt")
            public void testRemoveAtTwoSpecialBridges() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/removeAtTwoSpecialBridges.kt");
            }

            @Test
            @TestMetadata(value="specialBridgeForGet.kt")
            public void testSpecialBridgeForGet() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/specialBridgeForGet.kt");
            }

            @Test
            @TestMetadata(value="unsignedArray.kt")
            public void testUnsignedArray() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/unsignedArray.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/specialBridges/signatures")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Signatures {
                @Test
                public void testAllFilesPresentInSignatures() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/specialBridges/signatures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="genericClass.kt")
                public void testGenericClass() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/genericClass.kt");
                }

                @Test
                @TestMetadata(value="implementsJavaMap.kt")
                public void testImplementsJavaMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsJavaMap.kt");
                }

                @Test
                @TestMetadata(value="implementsJavaMapWithCustomEntries.kt")
                public void testImplementsJavaMapWithCustomEntries() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsJavaMapWithCustomEntries.kt");
                }

                @Test
                @TestMetadata(value="implementsMap.kt")
                public void testImplementsMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsMap.kt");
                }

                @Test
                @TestMetadata(value="implementsSortedMap.kt")
                public void testImplementsSortedMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsSortedMap.kt");
                }

                @Test
                @TestMetadata(value="kt43610.kt")
                public void testKt43610() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/kt43610.kt");
                }

                @Test
                @TestMetadata(value="nonGenericClass.kt")
                public void testNonGenericClass() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/nonGenericClass.kt");
                }

                @Test
                @TestMetadata(value="partiallySpecializedClass.kt")
                public void testPartiallySpecializedClass() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/partiallySpecializedClass.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/sealed")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Sealed {
            @Test
            public void testAllFilesPresentInSealed() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/sealed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="annotationsOnSealedConstructor.kt")
            public void testAnnotationsOnSealedConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sealed/annotationsOnSealedConstructor.kt");
            }

            @Test
            @TestMetadata(value="permittedSubclasses_1_7.kt")
            public void testPermittedSubclasses_1_7() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sealed/permittedSubclasses_1_7.kt");
            }

            @Test
            @TestMetadata(value="sealedClassConstructor_1_4.kt")
            public void testSealedClassConstructor_1_4() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sealed/sealedClassConstructor_1_4.kt");
            }

            @Test
            @TestMetadata(value="sealedClassConstructor_1_5.kt")
            public void testSealedClassConstructor_1_5() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sealed/sealedClassConstructor_1_5.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/sam")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Sam {
            @Test
            public void testAllFilesPresentInSam() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="callableRefGenericFunInterface.kt")
            public void testCallableRefGenericFunInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefGenericFunInterface.kt");
            }

            @Test
            @TestMetadata(value="callableRefGenericSamInterface.kt")
            public void testCallableRefGenericSamInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefGenericSamInterface.kt");
            }

            @Test
            @TestMetadata(value="callableRefSpecializedFunInterface.kt")
            public void testCallableRefSpecializedFunInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefSpecializedFunInterface.kt");
            }

            @Test
            @TestMetadata(value="callableRefSpecializedSamInterface.kt")
            public void testCallableRefSpecializedSamInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefSpecializedSamInterface.kt");
            }

            @Test
            @TestMetadata(value="genericFunInterface.kt")
            public void testGenericFunInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/genericFunInterface.kt");
            }

            @Test
            @TestMetadata(value="genericSamInterface.kt")
            public void testGenericSamInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/genericSamInterface.kt");
            }

            @Test
            @TestMetadata(value="indySamConversionViaProxyFun.kt")
            public void testIndySamConversionViaProxyFun() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/indySamConversionViaProxyFun.kt");
            }

            @Test
            @TestMetadata(value="kt16650.kt")
            public void testKt16650() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/kt16650.kt");
            }

            @Test
            @TestMetadata(value="lambdaGenericFunInterface.kt")
            public void testLambdaGenericFunInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaGenericFunInterface.kt");
            }

            @Test
            @TestMetadata(value="lambdaGenericSamInterface.kt")
            public void testLambdaGenericSamInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaGenericSamInterface.kt");
            }

            @Test
            @TestMetadata(value="lambdaSpecializedFunInterface.kt")
            public void testLambdaSpecializedFunInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaSpecializedFunInterface.kt");
            }

            @Test
            @TestMetadata(value="lambdaSpecializedSamInterface.kt")
            public void testLambdaSpecializedSamInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaSpecializedSamInterface.kt");
            }

            @Test
            @TestMetadata(value="nonApproxToValidSupertype.kt")
            public void testNonApproxToValidSupertype() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/nonApproxToValidSupertype.kt");
            }

            @Test
            @TestMetadata(value="nonApproxToValidSupertype2.kt")
            public void testNonApproxToValidSupertype2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/nonApproxToValidSupertype2.kt");
            }

            @Test
            @TestMetadata(value="privateInlineSamAdapter.kt")
            public void testPrivateInlineSamAdapter() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/privateInlineSamAdapter.kt");
            }

            @Test
            @TestMetadata(value="reusedSamWrapperClasses.kt")
            public void testReusedSamWrapperClasses() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/reusedSamWrapperClasses.kt");
            }

            @Test
            @TestMetadata(value="samAdapterAndInlinedOne.kt")
            public void testSamAdapterAndInlinedOne() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/samAdapterAndInlinedOne.kt");
            }

            @Test
            @TestMetadata(value="samAdapterInInlineLambda.kt")
            public void testSamAdapterInInlineLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/samAdapterInInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="samWithContravariantProjection.kt")
            public void testSamWithContravariantProjection() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/samWithContravariantProjection.kt");
            }

            @Test
            @TestMetadata(value="severalProxyFunsInInit.kt")
            public void testSeveralProxyFunsInInit() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/severalProxyFunsInInit.kt");
            }

            @Test
            @TestMetadata(value="specializedFunInterface.kt")
            public void testSpecializedFunInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/specializedFunInterface.kt");
            }

            @Test
            @TestMetadata(value="specializedSamInterface.kt")
            public void testSpecializedSamInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/specializedSamInterface.kt");
            }

            @Test
            @TestMetadata(value="wrapperInlinedFromAnotherClass.kt")
            public void testWrapperInlinedFromAnotherClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/wrapperInlinedFromAnotherClass.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/properties")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Properties {
            @Test
            public void testAllFilesPresentInProperties() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/properties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/properties/backingField")
            @TestDataPath(value="$PROJECT_ROOT")
            public class BackingField {
                @Test
                public void testAllFilesPresentInBackingField() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/properties/backingField"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="explicitBackingFieldsInJava.kt")
                public void testExplicitBackingFieldsInJava() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/properties/backingField/explicitBackingFieldsInJava.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/nullabilityAnnotations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NullabilityAnnotations {
            @Test
            public void testAllFilesPresentInNullabilityAnnotations() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="lateInitNotNull.kt")
            public void testLateInitNotNull() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/lateInitNotNull.kt");
            }

            @Test
            @TestMetadata(value="nullabilityAnnotationsForReturnType.kt")
            public void testNullabilityAnnotationsForReturnType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/nullabilityAnnotationsForReturnType.kt");
            }

            @Test
            @TestMetadata(value="nullabilityAnnotationsOnDelegatedMembers.kt")
            public void testNullabilityAnnotationsOnDelegatedMembers() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/nullabilityAnnotationsOnDelegatedMembers.kt");
            }

            @Test
            @TestMetadata(value="platformTypes.kt")
            public void testPlatformTypes() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/platformTypes.kt");
            }

            @Test
            @TestMetadata(value="samAdapterForJavaInterfaceWithNullability.kt")
            public void testSamAdapterForJavaInterfaceWithNullability() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/samAdapterForJavaInterfaceWithNullability.kt");
            }

            @Test
            @TestMetadata(value="suspendFunction.kt")
            public void testSuspendFunction() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/suspendFunction.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/multiplatform")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Multiplatform {
            @Test
            public void testAllFilesPresentInMultiplatform() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="optionalExpectation.kt")
            public void testOptionalExpectation() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multiplatform/optionalExpectation.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/multifileClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class MultifileClasses {
            @Test
            public void testAllFilesPresentInMultifileClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="emptyMultifileFacade.kt")
            public void testEmptyMultifileFacade() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/emptyMultifileFacade.kt");
            }

            @Test
            @TestMetadata(value="jvmSynthetic.kt")
            public void testJvmSynthetic() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/jvmSynthetic.kt");
            }

            @Test
            @TestMetadata(value="kt43519.kt")
            public void testKt43519() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/kt43519.kt");
            }

            @Test
            @TestMetadata(value="multiClassPartSourceMultipleParts.kt")
            public void testMultiClassPartSourceMultipleParts() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/multiClassPartSourceMultipleParts.kt");
            }

            @Test
            @TestMetadata(value="multiClassPartSourceSinglePart.kt")
            public void testMultiClassPartSourceSinglePart() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/multiClassPartSourceSinglePart.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/main")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Main {
            @Test
            public void testAllFilesPresentInMain() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/main"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="multifileSuspend.kt")
            public void testMultifileSuspend() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/main/multifileSuspend.kt");
            }

            @Test
            @TestMetadata(value="parameterlessMain.kt")
            public void testParameterlessMain() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/main/parameterlessMain.kt");
            }

            @Test
            @TestMetadata(value="parameterlessMain_before.kt")
            public void testParameterlessMain_before() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/main/parameterlessMain_before.kt");
            }

            @Test
            @TestMetadata(value="suspendMain.kt")
            public void testSuspendMain() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/main/suspendMain.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/localFunctions")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LocalFunctions {
            @Test
            public void testAllFilesPresentInLocalFunctions() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/localFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="genericClass.kt")
            public void testGenericClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericClass.kt");
            }

            @Test
            @TestMetadata(value="genericInnerClass.kt")
            public void testGenericInnerClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericInnerClass.kt");
            }

            @Test
            @TestMetadata(value="genericLocalClass.kt")
            public void testGenericLocalClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericLocalClass.kt");
            }

            @Test
            @TestMetadata(value="inInitBlock.kt")
            public void testInInitBlock() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/inInitBlock.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/simple.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvmStatic")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JvmStatic {
            @Test
            public void testAllFilesPresentInJvmStatic() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvmStatic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="jvmStaticExternal.kt")
            public void testJvmStaticExternal() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticExternal.kt");
            }

            @Test
            @TestMetadata(value="jvmStaticPrivate.kt")
            public void testJvmStaticPrivate() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticPrivate.kt");
            }

            @Test
            @TestMetadata(value="jvmStaticWithDefaultParameters.kt")
            public void testJvmStaticWithDefaultParameters() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticWithDefaultParameters.kt");
            }

            @Test
            @TestMetadata(value="kt31389.kt")
            public void testKt31389() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/kt31389.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Jvm8 {
            @Test
            public void testAllFilesPresentInJvm8() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8/defaults")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Defaults {
                @Test
                public void testAllFilesPresentInDefaults() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl")
                @TestDataPath(value="$PROJECT_ROOT")
                public class NoDefaultImpl {
                    @Test
                    public void testAllFilesPresentInNoDefaultImpl() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="interfaceProperty.kt")
                    public void testInterfaceProperty() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl/interfaceProperty.kt");
                    }

                    @Test
                    @TestMetadata(value="privateAccessorNaming.kt")
                    public void testPrivateAccessorNaming() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl/privateAccessorNaming.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility")
                @TestDataPath(value="$PROJECT_ROOT")
                public class AllCompatibility {
                    @Test
                    public void testAllFilesPresentInAllCompatibility() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="deprecation.kt")
                    public void testDeprecation() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/deprecation.kt");
                    }

                    @Test
                    @TestMetadata(value="deprecationWithDefault.kt")
                    public void testDeprecationWithDefault() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/deprecationWithDefault.kt");
                    }

                    @Test
                    @TestMetadata(value="interfaceProperty.kt")
                    public void testInterfaceProperty() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/interfaceProperty.kt");
                    }

                    @Test
                    @TestMetadata(value="jvmDefaultWithoutCompatibility.kt")
                    public void testJvmDefaultWithoutCompatibility() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/jvmDefaultWithoutCompatibility.kt");
                    }

                    @Test
                    @TestMetadata(value="noDefaultImplsOnEmptySubInterface.kt")
                    public void testNoDefaultImplsOnEmptySubInterface() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/noDefaultImplsOnEmptySubInterface.kt");
                    }

                    @Nested
                    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization")
                    @TestDataPath(value="$PROJECT_ROOT")
                    public class Specialization {
                        @Test
                        public void testAllFilesPresentInSpecialization() {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                        }

                        @Test
                        @TestMetadata(value="primitiveAndAny.kt")
                        public void testPrimitiveAndAny() {
                            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization/primitiveAndAny.kt");
                        }

                        @Test
                        @TestMetadata(value="primitiveAndNullable.kt")
                        public void testPrimitiveAndNullable() {
                            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization/primitiveAndNullable.kt");
                        }
                    }
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="annotatedPropertyWithInlineClassTypeInSignature.kt")
            public void testAnnotatedPropertyWithInlineClassTypeInSignature() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotatedPropertyWithInlineClassTypeInSignature.kt");
            }

            @Test
            @TestMetadata(value="annotationGetters.kt")
            public void testAnnotationGetters() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotationGetters.kt");
            }

            @Test
            @TestMetadata(value="annotationsOnHiddenConstructor.kt")
            public void testAnnotationsOnHiddenConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotationsOnHiddenConstructor.kt");
            }

            @Test
            @TestMetadata(value="companionObjectInsideInlineClass.kt")
            public void testCompanionObjectInsideInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/companionObjectInsideInlineClass.kt");
            }

            @Test
            @TestMetadata(value="computablePropertiesInsideInlineClass.kt")
            public void testComputablePropertiesInsideInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/computablePropertiesInsideInlineClass.kt");
            }

            @Test
            @TestMetadata(value="constructor.kt")
            public void testConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/constructor.kt");
            }

            @Test
            @TestMetadata(value="constructorsWithDefaultParameterValues.kt")
            public void testConstructorsWithDefaultParameterValues() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/constructorsWithDefaultParameterValues.kt");
            }

            @Test
            @TestMetadata(value="defaultInterfaceMethodsInInlineClass.kt")
            public void testDefaultInterfaceMethodsInInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMethodsInInlineClass.kt");
            }

            @Test
            @TestMetadata(value="genericChild.kt")
            public void testGenericChild() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/genericChild.kt");
            }

            @Test
            @TestMetadata(value="hiddenConstructor.kt")
            public void testHiddenConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/hiddenConstructor.kt");
            }

            @Test
            @TestMetadata(value="inlineCharSequence.kt")
            public void testInlineCharSequence() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCharSequence.kt");
            }

            @Test
            @TestMetadata(value="inlineClassMembersVisibility.kt")
            public void testInlineClassMembersVisibility() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassMembersVisibility.kt");
            }

            @Test
            @TestMetadata(value="inlineClassTypeParametersInConstructor.kt")
            public void testInlineClassTypeParametersInConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassTypeParametersInConstructor.kt");
            }

            @Test
            @TestMetadata(value="inlineClassWithInlineClassUnderlyingType.kt")
            public void testInlineClassWithInlineClassUnderlyingType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassWithInlineClassUnderlyingType.kt");
            }

            @Test
            @TestMetadata(value="inlineClassWithManyKindsOfMembers.kt")
            public void testInlineClassWithManyKindsOfMembers() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassWithManyKindsOfMembers.kt");
            }

            @Test
            @TestMetadata(value="jvmName.kt")
            public void testJvmName() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/jvmName.kt");
            }

            @Test
            @TestMetadata(value="jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt")
            public void testJvmOverloadsOnTopLevelFunctionReturningInlineClassValue() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt");
            }

            @Test
            @TestMetadata(value="memberExtensionProperty.kt")
            public void testMemberExtensionProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/memberExtensionProperty.kt");
            }

            @Test
            @TestMetadata(value="noArgConstructorForInlineClassParameter.kt")
            public void testNoArgConstructorForInlineClassParameter() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/noArgConstructorForInlineClassParameter.kt");
            }

            @Test
            @TestMetadata(value="noBridgesForErasedInlineClass.kt")
            public void testNoBridgesForErasedInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/noBridgesForErasedInlineClass.kt");
            }

            @Test
            @TestMetadata(value="nullabilityAnnotationsOnInlineClassMembers.kt")
            public void testNullabilityAnnotationsOnInlineClassMembers() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullabilityAnnotationsOnInlineClassMembers.kt");
            }

            @Test
            @TestMetadata(value="nullabilityInExpansion.kt")
            public void testNullabilityInExpansion() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullabilityInExpansion.kt");
            }

            @Test
            @TestMetadata(value="nullableAndNotNullPrimitive.kt")
            public void testNullableAndNotNullPrimitive() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullableAndNotNullPrimitive.kt");
            }

            @Test
            @TestMetadata(value="overridingGenericMethodWithInlineClassParameterType.kt")
            public void testOverridingGenericMethodWithInlineClassParameterType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/overridingGenericMethodWithInlineClassParameterType.kt");
            }

            @Test
            @TestMetadata(value="overridingGenericMethodWithInlineClassReturnType.kt")
            public void testOverridingGenericMethodWithInlineClassReturnType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/overridingGenericMethodWithInlineClassReturnType.kt");
            }

            @Test
            @TestMetadata(value="primaryValsWithDifferentVisibilities.kt")
            public void testPrimaryValsWithDifferentVisibilities() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/primaryValsWithDifferentVisibilities.kt");
            }

            @Test
            @TestMetadata(value="publishedApiAnnotationOnInlineClassConstructor.kt")
            public void testPublishedApiAnnotationOnInlineClassConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/publishedApiAnnotationOnInlineClassConstructor.kt");
            }

            @Test
            @TestMetadata(value="shapeOfInlineClassWithPrimitive.kt")
            public void testShapeOfInlineClassWithPrimitive() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/shapeOfInlineClassWithPrimitive.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430")
            @TestDataPath(value="$PROJECT_ROOT")
            public class StdlibManglingIn1430 {
                @Test
                public void testAllFilesPresentInStdlibManglingIn1430() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="new.kt")
                public void testNew() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430/new.kt");
                }

                @Test
                @TestMetadata(value="old.kt")
                public void testOld() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430/old.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ReturnResult {
                @Test
                public void testAllFilesPresentInReturnResult() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="class.kt")
                public void testClass() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/class.kt");
                }

                @Test
                @TestMetadata(value="classAnyOverride.kt")
                public void testClassAnyOverride() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classAnyOverride.kt");
                }

                @Test
                @TestMetadata(value="classGenericOverride.kt")
                public void testClassGenericOverride() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classGenericOverride.kt");
                }

                @Test
                @TestMetadata(value="classResultOverride.kt")
                public void testClassResultOverride() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classResultOverride.kt");
                }

                @Test
                @TestMetadata(value="interface.kt")
                public void testInterface() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/interface.kt");
                }

                @Test
                @TestMetadata(value="topLevel.kt")
                public void testTopLevel() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/topLevel.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineCollectionOfInlineClass {
                @Test
                public void testAllFilesPresentInInlineCollectionOfInlineClass() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="collection.kt")
                public void testCollection() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/collection.kt");
                }

                @Test
                @TestMetadata(value="iterable.kt")
                public void testIterable() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/iterable.kt");
                }

                @Test
                @TestMetadata(value="iterator.kt")
                public void testIterator() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/iterator.kt");
                }

                @Test
                @TestMetadata(value="list.kt")
                public void testList() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/list.kt");
                }

                @Test
                @TestMetadata(value="map.kt")
                public void testMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/map.kt");
                }

                @Test
                @TestMetadata(value="mapEntry.kt")
                public void testMapEntry() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mapEntry.kt");
                }

                @Test
                @TestMetadata(value="mutableCollection.kt")
                public void testMutableCollection() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableCollection.kt");
                }

                @Test
                @TestMetadata(value="mutableIterable.kt")
                public void testMutableIterable() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableIterable.kt");
                }

                @Test
                @TestMetadata(value="mutableIterator.kt")
                public void testMutableIterator() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableIterator.kt");
                }

                @Test
                @TestMetadata(value="mutableList.kt")
                public void testMutableList() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableList.kt");
                }

                @Test
                @TestMetadata(value="mutableMap.kt")
                public void testMutableMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableMap.kt");
                }

                @Test
                @TestMetadata(value="mutableMapEntry.kt")
                public void testMutableMapEntry() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableMapEntry.kt");
                }

                @Test
                @TestMetadata(value="mutableSet.kt")
                public void testMutableSet() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableSet.kt");
                }

                @Test
                @TestMetadata(value="mutableSet2.kt")
                public void testMutableSet2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableSet2.kt");
                }

                @Test
                @TestMetadata(value="set.kt")
                public void testSet() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/set.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineCollection {
                @Test
                public void testAllFilesPresentInInlineCollection() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="collection.kt")
                public void testCollection() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/collection.kt");
                }

                @Test
                @TestMetadata(value="iterable.kt")
                public void testIterable() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/iterable.kt");
                }

                @Test
                @TestMetadata(value="iterator.kt")
                public void testIterator() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/iterator.kt");
                }

                @Test
                @TestMetadata(value="list.kt")
                public void testList() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/list.kt");
                }

                @Test
                @TestMetadata(value="map.kt")
                public void testMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/map.kt");
                }

                @Test
                @TestMetadata(value="mapEntry.kt")
                public void testMapEntry() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mapEntry.kt");
                }

                @Test
                @TestMetadata(value="mutableCollection.kt")
                public void testMutableCollection() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableCollection.kt");
                }

                @Test
                @TestMetadata(value="mutableIterable.kt")
                public void testMutableIterable() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableIterable.kt");
                }

                @Test
                @TestMetadata(value="mutableIterator.kt")
                public void testMutableIterator() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableIterator.kt");
                }

                @Test
                @TestMetadata(value="mutableList.kt")
                public void testMutableList() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableList.kt");
                }

                @Test
                @TestMetadata(value="mutableMap.kt")
                public void testMutableMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableMap.kt");
                }

                @Test
                @TestMetadata(value="mutableMapEntry.kt")
                public void testMutableMapEntry() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableMapEntry.kt");
                }

                @Test
                @TestMetadata(value="mutableSet.kt")
                public void testMutableSet() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableSet.kt");
                }

                @Test
                @TestMetadata(value="set.kt")
                public void testSet() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/set.kt");
                }

                @Test
                @TestMetadata(value="UIntArrayWithFullJdk.kt")
                public void testUIntArrayWithFullJdk() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/UIntArrayWithFullJdk.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DefaultInterfaceMembers {
                @Test
                public void testAllFilesPresentInDefaultInterfaceMembers() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="javaDefaultInterfaceMember.kt")
                public void testJavaDefaultInterfaceMember() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers/javaDefaultInterfaceMember.kt");
                }

                @Test
                @TestMetadata(value="jvmDefaultAll.kt")
                public void testJvmDefaultAll() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers/jvmDefaultAll.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inline")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Inline {
            @Test
            public void testAllFilesPresentInInline() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="genericReified.kt")
            public void testGenericReified() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/genericReified.kt");
            }

            @Test
            @TestMetadata(value="inlineOnly.kt")
            public void testInlineOnly() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineOnly.kt");
            }

            @Test
            @TestMetadata(value="InlineOnlyMultifile.kt")
            public void testInlineOnlyMultifile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/InlineOnlyMultifile.kt");
            }

            @Test
            @TestMetadata(value="inlineOnlyProperty.kt")
            public void testInlineOnlyProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineOnlyProperty.kt");
            }

            @Test
            @TestMetadata(value="InlineOnlyPropertyMultifile.kt")
            public void testInlineOnlyPropertyMultifile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/InlineOnlyPropertyMultifile.kt");
            }

            @Test
            @TestMetadata(value="inlineReified.kt")
            public void testInlineReified() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReified.kt");
            }

            @Test
            @TestMetadata(value="InlineReifiedMultifile.kt")
            public void testInlineReifiedMultifile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/InlineReifiedMultifile.kt");
            }

            @Test
            @TestMetadata(value="inlineReifiedProperty.kt")
            public void testInlineReifiedProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedProperty.kt");
            }

            @Test
            @TestMetadata(value="InlineReifiedPropertyMultifile.kt")
            public void testInlineReifiedPropertyMultifile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/InlineReifiedPropertyMultifile.kt");
            }

            @Test
            @TestMetadata(value="inlineReifiedPropertyVisibility.kt")
            public void testInlineReifiedPropertyVisibility() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedPropertyVisibility.kt");
            }

            @Test
            @TestMetadata(value="inlineReifiedVisibility.kt")
            public void testInlineReifiedVisibility() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedVisibility.kt");
            }

            @Test
            @TestMetadata(value="simpleNamed.kt")
            public void testSimpleNamed() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/simpleNamed.kt");
            }

            @Test
            @TestMetadata(value="suspendInlineReified.kt")
            public void testSuspendInlineReified() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/suspendInlineReified.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inline/enclosingInfo")
            @TestDataPath(value="$PROJECT_ROOT")
            public class EnclosingInfo {
                @Test
                public void testAllFilesPresentInEnclosingInfo() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="crossinlineLambdaChain.kt")
                public void testCrossinlineLambdaChain() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/crossinlineLambdaChain.kt");
                }

                @Test
                @TestMetadata(value="kt10259.kt")
                public void testKt10259() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/kt10259.kt");
                }

                @Test
                @TestMetadata(value="lambdaInInitBlockNoPrimaryConstructor.kt")
                public void testLambdaInInitBlockNoPrimaryConstructor() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/lambdaInInitBlockNoPrimaryConstructor.kt");
                }

                @Test
                @TestMetadata(value="lambdaInInnerClassConstructor.kt")
                public void testLambdaInInnerClassConstructor() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/lambdaInInnerClassConstructor.kt");
                }

                @Test
                @TestMetadata(value="transformedConstructor.kt")
                public void testTransformedConstructor() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/transformedConstructor.kt");
                }

                @Test
                @TestMetadata(value="transformedConstructorWithNestedInline.kt")
                public void testTransformedConstructorWithNestedInline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/transformedConstructorWithNestedInline.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/deprecated")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Deprecated {
            @Test
            public void testAllFilesPresentInDeprecated() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/deprecated"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="deprecatedClass.kt")
            public void testDeprecatedClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedClass.kt");
            }

            @Test
            @TestMetadata(value="deprecatedEnumEntryFields.kt")
            public void testDeprecatedEnumEntryFields() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedEnumEntryFields.kt");
            }

            @Test
            @TestMetadata(value="deprecatedInMultifileClass.kt")
            public void testDeprecatedInMultifileClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedInMultifileClass.kt");
            }

            @Test
            @TestMetadata(value="deprecatedLateinitVar.kt")
            public void testDeprecatedLateinitVar() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedLateinitVar.kt");
            }

            @Test
            @TestMetadata(value="deprecatedProperty.kt")
            public void testDeprecatedProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedProperty.kt");
            }

            @Test
            @TestMetadata(value="hidden.kt")
            public void testHidden() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/hidden.kt");
            }

            @Test
            @TestMetadata(value="inheritingDeprecation.kt")
            public void testInheritingDeprecation() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/inheritingDeprecation.kt");
            }

            @Test
            @TestMetadata(value="inlineClassTypesInSignature.kt")
            public void testInlineClassTypesInSignature() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/inlineClassTypesInSignature.kt");
            }

            @Test
            @TestMetadata(value="jvmStaticDeprecatedProperty.kt")
            public void testJvmStaticDeprecatedProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/jvmStaticDeprecatedProperty.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/delegatedProperty")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DelegatedProperty {
            @Test
            public void testAllFilesPresentInDelegatedProperty() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="delegateMethodIsNonOverridable.kt")
            public void testDelegateMethodIsNonOverridable() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/delegateMethodIsNonOverridable.kt");
            }

            @Test
            @TestMetadata(value="delegatedPropertiesInCompanionObject.kt")
            public void testDelegatedPropertiesInCompanionObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/delegatedPropertiesInCompanionObject.kt");
            }

            @Test
            @TestMetadata(value="localDelegatedProperty.kt")
            public void testLocalDelegatedProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/localDelegatedProperty.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/defaultArguments")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DefaultArguments {
            @Test
            public void testAllFilesPresentInDefaultArguments() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="functionInMultifileClass.kt")
            public void testFunctionInMultifileClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/functionInMultifileClass.kt");
            }

            @Test
            @TestMetadata(value="functionInMultifileClassWithInheritedParts.kt")
            public void testFunctionInMultifileClassWithInheritedParts() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/functionInMultifileClassWithInheritedParts.kt");
            }

            @Test
            @TestMetadata(value="internalNameMangling.kt")
            public void testInternalNameMangling() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/internalNameMangling.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/coroutines")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Coroutines {
            @Test
            public void testAllFilesPresentInCoroutines() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="coroutineContextIntrinsic.kt")
            public void testCoroutineContextIntrinsic() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/coroutineContextIntrinsic.kt");
            }

            @Test
            @TestMetadata(value="coroutineFields.kt")
            public void testCoroutineFields() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/coroutineFields.kt");
            }

            @Test
            @TestMetadata(value="oomInReturnUnit.kt")
            public void testOomInReturnUnit() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/oomInReturnUnit.kt");
            }

            @Test
            @TestMetadata(value="privateAccessor.kt")
            public void testPrivateAccessor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/privateAccessor.kt");
            }

            @Test
            @TestMetadata(value="privateSuspendFun.kt")
            public void testPrivateSuspendFun() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/privateSuspendFun.kt");
            }

            @Test
            @TestMetadata(value="suspendConversion.kt")
            public void testSuspendConversion() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendConversion.kt");
            }

            @Test
            @TestMetadata(value="suspendImpl.kt")
            public void testSuspendImpl() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendImpl.kt");
            }

            @Test
            @TestMetadata(value="suspendReifiedFun.kt")
            public void testSuspendReifiedFun() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendReifiedFun.kt");
            }

            @Test
            @TestMetadata(value="tcoContinuation.kt")
            public void testTcoContinuation() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/tcoContinuation.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/coroutines/spilling")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Spilling {
                @Test
                public void testAllFilesPresentInSpilling() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/coroutines/spilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="booleanParameter.kt")
                public void testBooleanParameter() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/booleanParameter.kt");
                }

                @Test
                @TestMetadata(value="component1.kt")
                public void testComponent1() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/component1.kt");
                }

                @Test
                @TestMetadata(value="destructured.kt")
                public void testDestructured() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/destructured.kt");
                }

                @Test
                @TestMetadata(value="field.kt")
                public void testField() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/field.kt");
                }

                @Test
                @TestMetadata(value="lambda.kt")
                public void testLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/lambda.kt");
                }

                @Test
                @TestMetadata(value="select.kt")
                public void testSelect() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/select.kt");
                }

                @Test
                @TestMetadata(value="unreachable.kt")
                public void testUnreachable() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/unreachable.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/contextReceivers")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ContextReceivers {
            @Test
            public void testAllFilesPresentInContextReceivers() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/contextReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="class.kt")
            public void testClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/class.kt");
            }

            @Test
            @TestMetadata(value="function.kt")
            public void testFunction() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/function.kt");
            }

            @Test
            @TestMetadata(value="property.kt")
            public void testProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/property.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP")
            @TestDataPath(value="$PROJECT_ROOT")
            public class FromKEEP {
                @Test
                public void testAllFilesPresentInFromKEEP() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="canvas.kt")
                public void testCanvas() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/canvas.kt");
                }

                @Test
                @TestMetadata(value="compareTo.kt")
                public void testCompareTo() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/compareTo.kt");
                }

                @Test
                @TestMetadata(value="dp.kt")
                public void testDp() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/dp.kt");
                }

                @Test
                @TestMetadata(value="functionalType.kt")
                public void testFunctionalType() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/functionalType.kt");
                }

                @Test
                @TestMetadata(value="monoidSum.kt")
                public void testMonoidSum() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/monoidSum.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/collectionStubs")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CollectionStubs {
            @Test
            @TestMetadata(value="abstractMapRedefiningGetAny.kt")
            public void testAbstractMapRedefiningGetAny() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractMapRedefiningGetAny.kt");
            }

            @Test
            public void testAllFilesPresentInCollectionStubs() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="collectionByDelegation.kt")
            public void testCollectionByDelegation() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation.kt");
            }

            @Test
            @TestMetadata(value="collectionByDelegation2.kt")
            public void testCollectionByDelegation2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation2.kt");
            }

            @Test
            @TestMetadata(value="collectionByDelegation2WithFullJdk.kt")
            public void testCollectionByDelegation2WithFullJdk() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation2WithFullJdk.kt");
            }

            @Test
            @TestMetadata(value="collectionByDelegation3.kt")
            public void testCollectionByDelegation3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation3.kt");
            }

            @Test
            @TestMetadata(value="collectionByDelegation3WithFullJdk.kt")
            public void testCollectionByDelegation3WithFullJdk() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation3WithFullJdk.kt");
            }

            @Test
            @TestMetadata(value="collectionByDelegationWithFullJdk.kt")
            public void testCollectionByDelegationWithFullJdk() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegationWithFullJdk.kt");
            }

            @Test
            @TestMetadata(value="collectionWithInternalRemove.kt")
            public void testCollectionWithInternalRemove() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionWithInternalRemove.kt");
            }

            @Test
            @TestMetadata(value="collectionsWithFullJdk.kt")
            public void testCollectionsWithFullJdk() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionsWithFullJdk.kt");
            }

            @Test
            @TestMetadata(value="customListIterator.kt")
            public void testCustomListIterator() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/customListIterator.kt");
            }

            @Test
            @TestMetadata(value="customMutableListIterator.kt")
            public void testCustomMutableListIterator() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/customMutableListIterator.kt");
            }

            @Test
            @TestMetadata(value="emptyList.kt")
            public void testEmptyList() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/emptyList.kt");
            }

            @Test
            @TestMetadata(value="extendingAbstractCollection.kt")
            public void testExtendingAbstractCollection() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/extendingAbstractCollection.kt");
            }

            @Test
            @TestMetadata(value="inheritingFromAbstractCollections.kt")
            public void testInheritingFromAbstractCollections() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractCollections.kt");
            }

            @Test
            @TestMetadata(value="inheritingFromAbstractMap.kt")
            public void testInheritingFromAbstractMap() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractMap.kt");
            }

            @Test
            @TestMetadata(value="inheritingFromAbstractMutableList.kt")
            public void testInheritingFromAbstractMutableList() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractMutableList.kt");
            }

            @Test
            @TestMetadata(value="intArrayList.kt")
            public void testIntArrayList() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/intArrayList.kt");
            }

            @Test
            @TestMetadata(value="kt44233.kt")
            public void testKt44233() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/kt44233.kt");
            }

            @Test
            @TestMetadata(value="ListAndSet.kt")
            public void testListAndSet() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/ListAndSet.kt");
            }

            @Test
            @TestMetadata(value="mapOfPrimitivesFullJdk.kt")
            public void testMapOfPrimitivesFullJdk() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/mapOfPrimitivesFullJdk.kt");
            }

            @Test
            @TestMetadata(value="noStubsForCollection.kt")
            public void testNoStubsForCollection() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForCollection.kt");
            }

            @Test
            @TestMetadata(value="noStubsForMapImplementations.kt")
            public void testNoStubsForMapImplementations() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForMapImplementations.kt");
            }

            @Test
            @TestMetadata(value="noStubsForMutableSetIterators.kt")
            public void testNoStubsForMutableSetIterators() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForMutableSetIterators.kt");
            }

            @Test
            @TestMetadata(value="noStubsForSetIterators.kt")
            public void testNoStubsForSetIterators() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForSetIterators.kt");
            }

            @Test
            @TestMetadata(value="noStubsInIterable.kt")
            public void testNoStubsInIterable() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInIterable.kt");
            }

            @Test
            @TestMetadata(value="noStubsInJavaSuperClass.kt")
            public void testNoStubsInJavaSuperClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInJavaSuperClass.kt");
            }

            @Test
            @TestMetadata(value="noStubsInMutableIterable.kt")
            public void testNoStubsInMutableIterable() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInMutableIterable.kt");
            }

            @Test
            @TestMetadata(value="observableMutableMap.kt")
            public void testObservableMutableMap() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/observableMutableMap.kt");
            }

            @Test
            @TestMetadata(value="stubForAbstractFun.kt")
            public void testStubForAbstractFun() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFun.kt");
            }

            @Test
            @TestMetadata(value="stubForAbstractFunInAbstractClass.kt")
            public void testStubForAbstractFunInAbstractClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunInAbstractClass.kt");
            }

            @Test
            @TestMetadata(value="stubForAbstractFunInAbstractClassWithCovariantOverride.kt")
            public void testStubForAbstractFunInAbstractClassWithCovariantOverride() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunInAbstractClassWithCovariantOverride.kt");
            }

            @Test
            @TestMetadata(value="stubForAbstractFunWithCovariantOverride.kt")
            public void testStubForAbstractFunWithCovariantOverride() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunWithCovariantOverride.kt");
            }

            @Test
            @TestMetadata(value="stubLikeMethodSignatures.kt")
            public void testStubLikeMethodSignatures() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubLikeMethodSignatures.kt");
            }

            @Test
            @TestMetadata(value="stubsFromSuperclass.kt")
            public void testStubsFromSuperclass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubsFromSuperclass.kt");
            }

            @Test
            @TestMetadata(value="stubsFromSuperclassNoBridges.kt")
            public void testStubsFromSuperclassNoBridges() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubsFromSuperclassNoBridges.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/collectionStubs/toArray")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ToArray {
                @Test
                public void testAllFilesPresentInToArray() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="customNonGenericToArray.kt")
                public void testCustomNonGenericToArray() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/customNonGenericToArray.kt");
                }

                @Test
                @TestMetadata(value="internalGenericToArray.kt")
                public void testInternalGenericToArray() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/internalGenericToArray.kt");
                }

                @Test
                @TestMetadata(value="noToArrayInJava.kt")
                public void testNoToArrayInJava() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/noToArrayInJava.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures")
            @TestDataPath(value="$PROJECT_ROOT")
            public class AbstractStubSignatures {
                @Test
                public void testAllFilesPresentInAbstractStubSignatures() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="byteShortMap.kt")
                public void testByteShortMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/byteShortMap.kt");
                }

                @Test
                @TestMetadata(value="byteShortMutableMap.kt")
                public void testByteShortMutableMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/byteShortMutableMap.kt");
                }

                @Test
                @TestMetadata(value="collection.kt")
                public void testCollection() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/collection.kt");
                }

                @Test
                @TestMetadata(value="genericCollection.kt")
                public void testGenericCollection() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericCollection.kt");
                }

                @Test
                @TestMetadata(value="genericMap.kt")
                public void testGenericMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMap.kt");
                }

                @Test
                @TestMetadata(value="genericMutableCollection.kt")
                public void testGenericMutableCollection() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableCollection.kt");
                }

                @Test
                @TestMetadata(value="genericMutableList.kt")
                public void testGenericMutableList() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableList.kt");
                }

                @Test
                @TestMetadata(value="genericMutableMap.kt")
                public void testGenericMutableMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableMap.kt");
                }

                @Test
                @TestMetadata(value="genericStringMap.kt")
                public void testGenericStringMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericStringMap.kt");
                }

                @Test
                @TestMetadata(value="genericStringMutableMap.kt")
                public void testGenericStringMutableMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericStringMutableMap.kt");
                }

                @Test
                @TestMetadata(value="iterable.kt")
                public void testIterable() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/iterable.kt");
                }

                @Test
                @TestMetadata(value="iterator.kt")
                public void testIterator() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/iterator.kt");
                }

                @Test
                @TestMetadata(value="list.kt")
                public void testList() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/list.kt");
                }

                @Test
                @TestMetadata(value="listIterator.kt")
                public void testListIterator() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/listIterator.kt");
                }

                @Test
                @TestMetadata(value="mapEntry.kt")
                public void testMapEntry() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mapEntry.kt");
                }

                @Test
                @TestMetadata(value="mutableCollection.kt")
                public void testMutableCollection() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableCollection.kt");
                }

                @Test
                @TestMetadata(value="mutableIterable.kt")
                public void testMutableIterable() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableIterable.kt");
                }

                @Test
                @TestMetadata(value="mutableIterator.kt")
                public void testMutableIterator() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableIterator.kt");
                }

                @Test
                @TestMetadata(value="mutableList.kt")
                public void testMutableList() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableList.kt");
                }

                @Test
                @TestMetadata(value="mutableListIterator.kt")
                public void testMutableListIterator() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableListIterator.kt");
                }

                @Test
                @TestMetadata(value="mutableMapEntry.kt")
                public void testMutableMapEntry() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableMapEntry.kt");
                }

                @Test
                @TestMetadata(value="numberStringMap.kt")
                public void testNumberStringMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/numberStringMap.kt");
                }

                @Test
                @TestMetadata(value="numberStringMutableMap.kt")
                public void testNumberStringMutableMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/numberStringMutableMap.kt");
                }

                @Test
                @TestMetadata(value="set.kt")
                public void testSet() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/set.kt");
                }

                @Test
                @TestMetadata(value="specializedGenericMap.kt")
                public void testSpecializedGenericMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/specializedGenericMap.kt");
                }

                @Test
                @TestMetadata(value="stringGenericMap.kt")
                public void testStringGenericMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/stringGenericMap.kt");
                }

                @Test
                @TestMetadata(value="stringGenericMutableMap.kt")
                public void testStringGenericMutableMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/stringGenericMutableMap.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/callableReference")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CallableReference {
            @Test
            @TestMetadata(value="adaptedReference.kt")
            public void testAdaptedReference() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/callableReference/adaptedReference.kt");
            }

            @Test
            public void testAllFilesPresentInCallableReference() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/annotations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Annotations {
            @Test
            public void testAllFilesPresentInAnnotations() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="annotationCtorCallGenerateSynthetic.kt")
            public void testAnnotationCtorCallGenerateSynthetic() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationCtorCallGenerateSynthetic.kt");
            }

            @Test
            @TestMetadata(value="annotationCtorCallNoSynthetic.kt")
            public void testAnnotationCtorCallNoSynthetic() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationCtorCallNoSynthetic.kt");
            }

            @Test
            @TestMetadata(value="annotationsOnDelegatedMembers.kt")
            public void testAnnotationsOnDelegatedMembers() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationsOnDelegatedMembers.kt");
            }

            @Test
            @TestMetadata(value="defaultTargets.kt")
            public void testDefaultTargets() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/defaultTargets.kt");
            }

            @Test
            @TestMetadata(value="deprecatedJvmOverloads.kt")
            public void testDeprecatedJvmOverloads() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/deprecatedJvmOverloads.kt");
            }

            @Test
            @TestMetadata(value="internalPropertyOrTypealias.kt")
            public void testInternalPropertyOrTypealias() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/internalPropertyOrTypealias.kt");
            }

            @Test
            @TestMetadata(value="JvmSynthetic.kt")
            public void testJvmSynthetic() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/JvmSynthetic.kt");
            }

            @Test
            @TestMetadata(value="kt27895.kt")
            public void testKt27895() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/kt27895.kt");
            }

            @Test
            @TestMetadata(value="kt43399.kt")
            public void testKt43399() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/kt43399.kt");
            }

            @Test
            @TestMetadata(value="kt43459.kt")
            public void testKt43459() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/kt43459.kt");
            }

            @Test
            @TestMetadata(value="kt62788.kt")
            public void testKt62788() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/kt62788.kt");
            }

            @Test
            @TestMetadata(value="kt9320.kt")
            public void testKt9320() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/kt9320.kt");
            }

            @Test
            @TestMetadata(value="literals.kt")
            public void testLiterals() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/literals.kt");
            }

            @Test
            @TestMetadata(value="localClassWithCapturedParams.kt")
            public void testLocalClassWithCapturedParams() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/localClassWithCapturedParams.kt");
            }

            @Test
            @TestMetadata(value="noAdditionalAnnotationsInAccessors.kt")
            public void testNoAdditionalAnnotationsInAccessors() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/noAdditionalAnnotationsInAccessors.kt");
            }

            @Test
            @TestMetadata(value="noAnnotationsInSyntheticAccessors.kt")
            public void testNoAnnotationsInSyntheticAccessors() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/noAnnotationsInSyntheticAccessors.kt");
            }

            @Test
            @TestMetadata(value="onProperties.kt")
            public void testOnProperties() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/onProperties.kt");
            }

            @Test
            @TestMetadata(value="onReceiver.kt")
            public void testOnReceiver() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/onReceiver.kt");
            }

            @Test
            @TestMetadata(value="unsignedTypes.kt")
            public void testUnsignedTypes() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/unsignedTypes.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/annotations/repeatable")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Repeatable {
                @Test
                public void testAllFilesPresentInRepeatable() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/annotations/repeatable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="javaAnnotation.kt")
                public void testJavaAnnotation() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/javaAnnotation.kt");
                }

                @Test
                @TestMetadata(value="kotlinAnnotation.kt")
                public void testKotlinAnnotation() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinAnnotation.kt");
                }

                @Test
                @TestMetadata(value="kotlinAnnotationWithBothRepeatables.kt")
                public void testKotlinAnnotationWithBothRepeatables() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinAnnotationWithBothRepeatables.kt");
                }

                @Test
                @TestMetadata(value="kotlinSpecificTargets.kt")
                public void testKotlinSpecificTargets() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinSpecificTargets.kt");
                }

                @Test
                @TestMetadata(value="multipleRepeatableOrder.kt")
                public void testMultipleRepeatableOrder() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/multipleRepeatableOrder.kt");
                }

                @Test
                @TestMetadata(value="nonRepeatedAnnotationWithItsContainer.kt")
                public void testNonRepeatedAnnotationWithItsContainer() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/nonRepeatedAnnotationWithItsContainer.kt");
                }

                @Test
                @TestMetadata(value="propertyGetterUseSiteTarget.kt")
                public void testPropertyGetterUseSiteTarget() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/propertyGetterUseSiteTarget.kt");
                }

                @Test
                @TestMetadata(value="retentionAndTarget.kt")
                public void testRetentionAndTarget() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/retentionAndTarget.kt");
                }
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText")
    @TestDataPath(value="$PROJECT_ROOT")
    public class BytecodeText {
        @Test
        @TestMetadata(value="accessorForOverridenVal.kt")
        public void testAccessorForOverridenVal() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/accessorForOverridenVal.kt");
        }

        @Test
        @TestMetadata(value="accessorForProtected.kt")
        public void testAccessorForProtected() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/accessorForProtected.kt");
        }

        @Test
        @TestMetadata(value="accessorNaming.kt")
        public void testAccessorNaming() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/accessorNaming.kt");
        }

        @Test
        public void testAllFilesPresentInBytecodeText() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="annotationDefaultValue.kt")
        public void testAnnotationDefaultValue() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/annotationDefaultValue.kt");
        }

        @Test
        @TestMetadata(value="annotationDefaultValueOfUnsigned.kt")
        public void testAnnotationDefaultValueOfUnsigned() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/annotationDefaultValueOfUnsigned.kt");
        }

        @Test
        @TestMetadata(value="annotationJavaRetentionPolicyRuntime.kt")
        public void testAnnotationJavaRetentionPolicyRuntime() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/annotationJavaRetentionPolicyRuntime.kt");
        }

        @Test
        @TestMetadata(value="annotationRetentionPolicyClass.kt")
        public void testAnnotationRetentionPolicyClass() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyClass.kt");
        }

        @Test
        @TestMetadata(value="annotationRetentionPolicyRuntime.kt")
        public void testAnnotationRetentionPolicyRuntime() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyRuntime.kt");
        }

        @Test
        @TestMetadata(value="annotationRetentionPolicySource.kt")
        public void testAnnotationRetentionPolicySource() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicySource.kt");
        }

        @Test
        @TestMetadata(value="boxedNotNumberTypeOnUnboxing.kt")
        public void testBoxedNotNumberTypeOnUnboxing() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxedNotNumberTypeOnUnboxing.kt");
        }

        @Test
        @TestMetadata(value="bridgeForFakeOverride.kt")
        public void testBridgeForFakeOverride() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/bridgeForFakeOverride.kt");
        }

        @Test
        @TestMetadata(value="charConstant.kt")
        public void testCharConstant() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/charConstant.kt");
        }

        @Test
        @TestMetadata(value="checkcastOnThrow.kt")
        public void testCheckcastOnThrow() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcastOnThrow.kt");
        }

        @Test
        @TestMetadata(value="collectionStubs.kt")
        public void testCollectionStubs() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/collectionStubs.kt");
        }

        @Test
        @TestMetadata(value="componentEvaluatesOnlyOnce.kt")
        public void testComponentEvaluatesOnlyOnce() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/componentEvaluatesOnlyOnce.kt");
        }

        @Test
        @TestMetadata(value="constClosureOptimization.kt")
        public void testConstClosureOptimization() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constClosureOptimization.kt");
        }

        @Test
        @TestMetadata(value="defaultMethodBody.kt")
        public void testDefaultMethodBody() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultMethodBody.kt");
        }

        @Test
        @TestMetadata(value="doNotStoreNullForTmpInDestructuring.kt")
        public void testDoNotStoreNullForTmpInDestructuring() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/doNotStoreNullForTmpInDestructuring.kt");
        }

        @Test
        @TestMetadata(value="doNotStoreNullsForCapturedVars.kt")
        public void testDoNotStoreNullsForCapturedVars() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/doNotStoreNullsForCapturedVars.kt");
        }

        @Test
        @TestMetadata(value="falseSmartCast.kt")
        public void testFalseSmartCast() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/falseSmartCast.kt");
        }

        @Test
        @TestMetadata(value="flagsInMultiFileInherit.kt")
        public void testFlagsInMultiFileInherit() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/flagsInMultiFileInherit.kt");
        }

        @Test
        @TestMetadata(value="iincGeneration.kt")
        public void testIincGeneration() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/iincGeneration.kt");
        }

        @Test
        @TestMetadata(value="inheritedPropertyAnnotations.kt")
        public void testInheritedPropertyAnnotations() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inheritedPropertyAnnotations.kt");
        }

        @Test
        @TestMetadata(value="inlineFromOtherModule.kt")
        public void testInlineFromOtherModule() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineFromOtherModule.kt");
        }

        @Test
        @TestMetadata(value="inlineJavaConstantFromSubclass.kt")
        public void testInlineJavaConstantFromSubclass() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineJavaConstantFromSubclass.kt");
        }

        @Test
        @TestMetadata(value="inlineJavaStaticFields.kt")
        public void testInlineJavaStaticFields() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineJavaStaticFields.kt");
        }

        @Test
        @TestMetadata(value="inlineProtectedJavaConstantFromOtherPackage.kt")
        public void testInlineProtectedJavaConstantFromOtherPackage() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineProtectedJavaConstantFromOtherPackage.kt");
        }

        @Test
        @TestMetadata(value="intConstantNotNull.kt")
        public void testIntConstantNotNull() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intConstantNotNull.kt");
        }

        @Test
        @TestMetadata(value="intConstantNullable.kt")
        public void testIntConstantNullable() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intConstantNullable.kt");
        }

        @Test
        @TestMetadata(value="intConstantNullableSafeCall.kt")
        public void testIntConstantNullableSafeCall() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intConstantNullableSafeCall.kt");
        }

        @Test
        @TestMetadata(value="intConstantSafeCall.kt")
        public void testIntConstantSafeCall() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intConstantSafeCall.kt");
        }

        @Test
        @TestMetadata(value="intProgressionNoBoxing.kt")
        public void testIntProgressionNoBoxing() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intProgressionNoBoxing.kt");
        }

        @Test
        @TestMetadata(value="intRangeNoBoxing.kt")
        public void testIntRangeNoBoxing() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intRangeNoBoxing.kt");
        }

        @Test
        @TestMetadata(value="interfaceDefaultImpl.kt")
        public void testInterfaceDefaultImpl() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaceDefaultImpl.kt");
        }

        @Test
        @TestMetadata(value="isArrayOf.kt")
        public void testIsArrayOf() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/isArrayOf.kt");
        }

        @Test
        @TestMetadata(value="javaExtensionPropertyIntrinsic.kt")
        public void testJavaExtensionPropertyIntrinsic() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/javaExtensionPropertyIntrinsic.kt");
        }

        @Test
        @TestMetadata(value="javaFields.kt")
        public void testJavaFields() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/javaFields.kt");
        }

        @Test
        @TestMetadata(value="javaFieldsWithIntersectionTypes.kt")
        public void testJavaFieldsWithIntersectionTypes() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/javaFieldsWithIntersectionTypes.kt");
        }

        @Test
        @TestMetadata(value="javaFieldsWithIntersectionTypes_k1.kt")
        public void testJavaFieldsWithIntersectionTypes_k1() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/javaFieldsWithIntersectionTypes_k1.kt");
        }

        @Test
        @TestMetadata(value="javaFields_k1.kt")
        public void testJavaFields_k1() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/javaFields_k1.kt");
        }

        @Test
        @TestMetadata(value="javaStatics.kt")
        public void testJavaStatics() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/javaStatics.kt");
        }

        @Test
        @TestMetadata(value="jvmField.kt")
        public void testJvmField() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvmField.kt");
        }

        @Test
        @TestMetadata(value="jvmStaticInternalMangling.kt")
        public void testJvmStaticInternalMangling() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvmStaticInternalMangling.kt");
        }

        @Test
        @TestMetadata(value="kt10259.kt")
        public void testKt10259() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt10259.kt");
        }

        @Test
        @TestMetadata(value="kt10259_2.kt")
        public void testKt10259_2() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt10259_2.kt");
        }

        @Test
        @TestMetadata(value="kt10259_3.kt")
        public void testKt10259_3() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt10259_3.kt");
        }

        @Test
        @TestMetadata(value="kt2202.kt")
        public void testKt2202() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt2202.kt");
        }

        @Test
        @TestMetadata(value="kt2887.kt")
        public void testKt2887() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt2887.kt");
        }

        @Test
        @TestMetadata(value="kt3845.kt")
        public void testKt3845() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt3845.kt");
        }

        @Test
        @TestMetadata(value="kt46615.kt")
        public void testKt46615() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt46615.kt");
        }

        @Test
        @TestMetadata(value="kt48367.kt")
        public void testKt48367() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt48367.kt");
        }

        @Test
        @TestMetadata(value="kt5016.kt")
        public void testKt5016() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt5016.kt");
        }

        @Test
        @TestMetadata(value="kt5016int.kt")
        public void testKt5016int() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt5016int.kt");
        }

        @Test
        @TestMetadata(value="kt5016intOrNull.kt")
        public void testKt5016intOrNull() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt5016intOrNull.kt");
        }

        @Test
        @TestMetadata(value="kt56923.kt")
        public void testKt56923() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt56923.kt");
        }

        @Test
        @TestMetadata(value="kt7188.kt")
        public void testKt7188() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt7188.kt");
        }

        @Test
        @TestMetadata(value="kt7769.kt")
        public void testKt7769() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt7769.kt");
        }

        @Test
        @TestMetadata(value="kt9603.kt")
        public void testKt9603() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt9603.kt");
        }

        @Test
        @TestMetadata(value="mapGetOrDefault.kt")
        public void testMapGetOrDefault() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/mapGetOrDefault.kt");
        }

        @Test
        @TestMetadata(value="maxStackAfterOptimizations.kt")
        public void testMaxStackAfterOptimizations() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/maxStackAfterOptimizations.kt");
        }

        @Test
        @TestMetadata(value="mergedProgression.kt")
        public void testMergedProgression() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/mergedProgression.kt");
        }

        @Test
        @TestMetadata(value="noAccessorForProtectedInSamePackageCrossinline.kt")
        public void testNoAccessorForProtectedInSamePackageCrossinline() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/noAccessorForProtectedInSamePackageCrossinline.kt");
        }

        @Test
        @TestMetadata(value="noAccessorForProtectedInSamePackagePrivateInline.kt")
        public void testNoAccessorForProtectedInSamePackagePrivateInline() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/noAccessorForProtectedInSamePackagePrivateInline.kt");
        }

        @Test
        @TestMetadata(value="noFlagAnnotations.kt")
        public void testNoFlagAnnotations() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/noFlagAnnotations.kt");
        }

        @Test
        @TestMetadata(value="noNumberCheckCast.kt")
        public void testNoNumberCheckCast() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/noNumberCheckCast.kt");
        }

        @Test
        @TestMetadata(value="noSuperCheckInDefaultConstuctor.kt")
        public void testNoSuperCheckInDefaultConstuctor() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/noSuperCheckInDefaultConstuctor.kt");
        }

        @Test
        @TestMetadata(value="noSyntheticAccessorForPrivateCompanionObjectWhenNotRequired.kt")
        public void testNoSyntheticAccessorForPrivateCompanionObjectWhenNotRequired() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/noSyntheticAccessorForPrivateCompanionObjectWhenNotRequired.kt");
        }

        @Test
        @TestMetadata(value="noWrapperForMethodReturningPrimitive.kt")
        public void testNoWrapperForMethodReturningPrimitive() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/noWrapperForMethodReturningPrimitive.kt");
        }

        @Test
        @TestMetadata(value="nopsInDoWhile.kt")
        public void testNopsInDoWhile() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nopsInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="partMembersCall.kt")
        public void testPartMembersCall() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/partMembersCall.kt");
        }

        @Test
        @TestMetadata(value="partMembersInline.kt")
        public void testPartMembersInline() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/partMembersInline.kt");
        }

        @Test
        @TestMetadata(value="preEvaluateInlineJavaStaticFields.kt")
        public void testPreEvaluateInlineJavaStaticFields() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/preEvaluateInlineJavaStaticFields.kt");
        }

        @Test
        @TestMetadata(value="prefixIntVarIncrement.kt")
        public void testPrefixIntVarIncrement() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/prefixIntVarIncrement.kt");
        }

        @Test
        @TestMetadata(value="privateDefaultArgs.kt")
        public void testPrivateDefaultArgs() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/privateDefaultArgs.kt");
        }

        @Test
        @TestMetadata(value="redundantGotoRemoving.kt")
        public void testRedundantGotoRemoving() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/redundantGotoRemoving.kt");
        }

        @Test
        @TestMetadata(value="redundantInitializer.kt")
        public void testRedundantInitializer() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/redundantInitializer.kt");
        }

        @Test
        @TestMetadata(value="redundantInitializerNumber.kt")
        public void testRedundantInitializerNumber() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/redundantInitializerNumber.kt");
        }

        @Test
        @TestMetadata(value="redundantValInitializer.kt")
        public void testRedundantValInitializer() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/redundantValInitializer.kt");
        }

        @Test
        @TestMetadata(value="redundantValInitializerInObject.kt")
        public void testRedundantValInitializerInObject() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/redundantValInitializerInObject.kt");
        }

        @Test
        @TestMetadata(value="redundantVarInitializer.kt")
        public void testRedundantVarInitializer() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/redundantVarInitializer.kt");
        }

        @Test
        @TestMetadata(value="redundantVarInitializerInObject.kt")
        public void testRedundantVarInitializerInObject() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/redundantVarInitializerInObject.kt");
        }

        @Test
        @TestMetadata(value="reifiedAsCheck.kt")
        public void testReifiedAsCheck() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/reifiedAsCheck.kt");
        }

        @Test
        @TestMetadata(value="reifiedAsCheckWithNullable.kt")
        public void testReifiedAsCheckWithNullable() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/reifiedAsCheckWithNullable.kt");
        }

        @Test
        @TestMetadata(value="reifiedIsCheck.kt")
        public void testReifiedIsCheck() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/reifiedIsCheck.kt");
        }

        @Test
        @TestMetadata(value="reifiedIsCheckWithNullable.kt")
        public void testReifiedIsCheckWithNullable() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/reifiedIsCheckWithNullable.kt");
        }

        @Test
        @TestMetadata(value="reifiedSafeAsCheck.kt")
        public void testReifiedSafeAsCheck() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/reifiedSafeAsCheck.kt");
        }

        @Test
        @TestMetadata(value="safeAsWithMutable.kt")
        public void testSafeAsWithMutable() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/safeAsWithMutable.kt");
        }

        @Test
        @TestMetadata(value="superFlagInMultiFileFacade.kt")
        public void testSuperFlagInMultiFileFacade() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/superFlagInMultiFileFacade.kt");
        }

        @Test
        @TestMetadata(value="superToString.kt")
        public void testSuperToString() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/superToString.kt");
        }

        @Test
        @TestMetadata(value="suspendCoroutineUninterceptedOrReturn.kt")
        public void testSuspendCoroutineUninterceptedOrReturn() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/suspendCoroutineUninterceptedOrReturn.kt");
        }

        @Test
        @TestMetadata(value="topLevelFunWithDefaultArgs.kt")
        public void testTopLevelFunWithDefaultArgs() {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/topLevelFunWithDefaultArgs.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/whenStringOptimization")
        @TestDataPath(value="$PROJECT_ROOT")
        public class WhenStringOptimization {
            @Test
            public void testAllFilesPresentInWhenStringOptimization() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenStringOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="denseHashCode.kt")
            public void testDenseHashCode() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/denseHashCode.kt");
            }

            @Test
            @TestMetadata(value="duplicatingItems.kt")
            public void testDuplicatingItems() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItems.kt");
            }

            @Test
            @TestMetadata(value="duplicatingItemsSameHashCodeFewBranches.kt")
            public void testDuplicatingItemsSameHashCodeFewBranches() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItemsSameHashCodeFewBranches.kt");
            }

            @Test
            @TestMetadata(value="duplicatingItemsSameHashCodeMoreBranches.kt")
            public void testDuplicatingItemsSameHashCodeMoreBranches() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItemsSameHashCodeMoreBranches.kt");
            }

            @Test
            @TestMetadata(value="expression.kt")
            public void testExpression() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/expression.kt");
            }

            @Test
            @TestMetadata(value="inlineStringConstInsideWhen.kt")
            public void testInlineStringConstInsideWhen() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/inlineStringConstInsideWhen.kt");
            }

            @Test
            @TestMetadata(value="nullability.kt")
            public void testNullability() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/nullability.kt");
            }

            @Test
            @TestMetadata(value="sameHashCode.kt")
            public void testSameHashCode() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/sameHashCode.kt");
            }

            @Test
            @TestMetadata(value="statement.kt")
            public void testStatement() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/statement.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/whenEnumOptimization")
        @TestDataPath(value="$PROJECT_ROOT")
        public class WhenEnumOptimization {
            @Test
            public void testAllFilesPresentInWhenEnumOptimization() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenEnumOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="bigEnum.kt")
            public void testBigEnum() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/bigEnum.kt");
            }

            @Test
            @TestMetadata(value="differentEnumClasses.kt")
            public void testDifferentEnumClasses() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/differentEnumClasses.kt");
            }

            @Test
            @TestMetadata(value="differentEnumClasses2.kt")
            public void testDifferentEnumClasses2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/differentEnumClasses2.kt");
            }

            @Test
            @TestMetadata(value="duplicatingItems.kt")
            public void testDuplicatingItems() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/duplicatingItems.kt");
            }

            @Test
            @TestMetadata(value="expression.kt")
            public void testExpression() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/expression.kt");
            }

            @Test
            @TestMetadata(value="functionLiteralInTopLevel.kt")
            public void testFunctionLiteralInTopLevel() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/functionLiteralInTopLevel.kt");
            }

            @Test
            @TestMetadata(value="importedEnumEntry.kt")
            public void testImportedEnumEntry() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/importedEnumEntry.kt");
            }

            @Test
            @TestMetadata(value="kt14597_full.kt")
            public void testKt14597_full() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt14597_full.kt");
            }

            @Test
            @TestMetadata(value="kt14802.kt")
            public void testKt14802() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt14802.kt");
            }

            @Test
            @TestMetadata(value="manyWhensWithinClass.kt")
            public void testManyWhensWithinClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/manyWhensWithinClass.kt");
            }

            @Test
            @TestMetadata(value="nestedWhenInCondition.kt")
            public void testNestedWhenInCondition() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nestedWhenInCondition.kt");
            }

            @Test
            @TestMetadata(value="nonConstantEnum.kt")
            public void testNonConstantEnum() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nonConstantEnum.kt");
            }

            @Test
            @TestMetadata(value="nullability.kt")
            public void testNullability() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nullability.kt");
            }

            @Test
            @TestMetadata(value="subjectAny.kt")
            public void testSubjectAny() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/subjectAny.kt");
            }

            @Test
            @TestMetadata(value="whenOr.kt")
            public void testWhenOr() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/whenOr.kt");
            }

            @Test
            @TestMetadata(value="withoutElse.kt")
            public void testWithoutElse() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/withoutElse.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/when")
        @TestDataPath(value="$PROJECT_ROOT")
        public class When {
            @Test
            public void testAllFilesPresentInWhen() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/when"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="edgeCases.kt")
            public void testEdgeCases() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/edgeCases.kt");
            }

            @Test
            @TestMetadata(value="exhaustiveWhenInitialization.kt")
            public void testExhaustiveWhenInitialization() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenInitialization.kt");
            }

            @Test
            @TestMetadata(value="exhaustiveWhenReturn.kt")
            public void testExhaustiveWhenReturn() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenReturn.kt");
            }

            @Test
            @TestMetadata(value="exhaustiveWhenSpecialCases.kt")
            public void testExhaustiveWhenSpecialCases() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenSpecialCases.kt");
            }

            @Test
            @TestMetadata(value="exhaustiveWhenUnit.kt")
            public void testExhaustiveWhenUnit() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnit.kt");
            }

            @Test
            @TestMetadata(value="exhaustiveWhenUnitStatement.kt")
            public void testExhaustiveWhenUnitStatement() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnitStatement.kt");
            }

            @Test
            @TestMetadata(value="inlineConstValsInsideWhen.kt")
            public void testInlineConstValsInsideWhen() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/inlineConstValsInsideWhen.kt");
            }

            @Test
            @TestMetadata(value="integralWhenWithNoInlinedConstants.kt")
            public void testIntegralWhenWithNoInlinedConstants() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/integralWhenWithNoInlinedConstants.kt");
            }

            @Test
            @TestMetadata(value="kt18818.kt")
            public void testKt18818() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/kt18818.kt");
            }

            @Test
            @TestMetadata(value="lookupSwitch.kt")
            public void testLookupSwitch() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/lookupSwitch.kt");
            }

            @Test
            @TestMetadata(value="lookupSwitchWithSubjectVal.kt")
            public void testLookupSwitchWithSubjectVal() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/lookupSwitchWithSubjectVal.kt");
            }

            @Test
            @TestMetadata(value="noBoxingInDefaultWhenWithSpecialCases.kt")
            public void testNoBoxingInDefaultWhenWithSpecialCases() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/noBoxingInDefaultWhenWithSpecialCases.kt");
            }

            @Test
            @TestMetadata(value="qualifiedConstValsInsideWhen.kt")
            public void testQualifiedConstValsInsideWhen() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/qualifiedConstValsInsideWhen.kt");
            }

            @Test
            @TestMetadata(value="sealedWhenInitialization.kt")
            public void testSealedWhenInitialization() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/sealedWhenInitialization.kt");
            }

            @Test
            @TestMetadata(value="simpleConstValsInsideWhen.kt")
            public void testSimpleConstValsInsideWhen() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/simpleConstValsInsideWhen.kt");
            }

            @Test
            @TestMetadata(value="stringSwitchWithSubjectVal.kt")
            public void testStringSwitchWithSubjectVal() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/stringSwitchWithSubjectVal.kt");
            }

            @Test
            @TestMetadata(value="subjectValHasLocalVariableSlot.kt")
            public void testSubjectValHasLocalVariableSlot() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValHasLocalVariableSlot.kt");
            }

            @Test
            @TestMetadata(value="subjectValInEnumWhenHasLocalVariableSlot.kt")
            public void testSubjectValInEnumWhenHasLocalVariableSlot() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValInEnumWhenHasLocalVariableSlot.kt");
            }

            @Test
            @TestMetadata(value="subjectValInIntWhenHasLocalVariableSlot.kt")
            public void testSubjectValInIntWhenHasLocalVariableSlot() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValInIntWhenHasLocalVariableSlot.kt");
            }

            @Test
            @TestMetadata(value="subjectValInStringWhenHasLocalVariableSlot.kt")
            public void testSubjectValInStringWhenHasLocalVariableSlot() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValInStringWhenHasLocalVariableSlot.kt");
            }

            @Test
            @TestMetadata(value="switchOptimizationDuplicates.kt")
            public void testSwitchOptimizationDuplicates() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/switchOptimizationDuplicates.kt");
            }

            @Test
            @TestMetadata(value="tableSwitch.kt")
            public void testTableSwitch() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/tableSwitch.kt");
            }

            @Test
            @TestMetadata(value="tableSwitchWithSubjectVal.kt")
            public void testTableSwitchWithSubjectVal() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/tableSwitchWithSubjectVal.kt");
            }

            @Test
            @TestMetadata(value="whenNull.kt")
            public void testWhenNull() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/whenNull.kt");
            }

            @Test
            @TestMetadata(value="whenZero.kt")
            public void testWhenZero() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/whenZero.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/varargs")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Varargs {
            @Test
            public void testAllFilesPresentInVarargs() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/varargs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="doNotCopyImmediatelyCreatedArrays.kt")
            public void testDoNotCopyImmediatelyCreatedArrays() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/varargs/doNotCopyImmediatelyCreatedArrays.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/valueClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ValueClasses {
            @Test
            public void testAllFilesPresentInValueClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/valueClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="conditionalExpressions.kt")
            public void testConditionalExpressions() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/conditionalExpressions.kt");
            }

            @Test
            @TestMetadata(value="equalsBoxTest.kt")
            public void testEqualsBoxTest() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/equalsBoxTest.kt");
            }

            @Test
            @TestMetadata(value="mfvcDeclaration.kt")
            public void testMfvcDeclaration() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/mfvcDeclaration.kt");
            }

            @Test
            @TestMetadata(value="mfvcReassignments.kt")
            public void testMfvcReassignments() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/mfvcReassignments.kt");
            }

            @Test
            @TestMetadata(value="passingMFVC2Functions.kt")
            public void testPassingMFVC2Functions() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/passingMFVC2Functions.kt");
            }

            @Test
            @TestMetadata(value="regularClassWithMFVC.kt")
            public void testRegularClassWithMFVC() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/regularClassWithMFVC.kt");
            }

            @Test
            @TestMetadata(value="tryExpressions.kt")
            public void testTryExpressions() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/tryExpressions.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/unsignedTypes")
        @TestDataPath(value="$PROJECT_ROOT")
        public class UnsignedTypes {
            @Test
            public void testAllFilesPresentInUnsignedTypes() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/unsignedTypes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="unsignedIntCompare_jvm18.kt")
            public void testUnsignedIntCompare_jvm18() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntCompare_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedIntDivide_jvm18.kt")
            public void testUnsignedIntDivide_jvm18() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntDivide_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedIntRemainder_jvm18.kt")
            public void testUnsignedIntRemainder_jvm18() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntRemainder_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedIntSmartCasts_jvm18.kt")
            public void testUnsignedIntSmartCasts_jvm18() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntSmartCasts_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedIntToString_jvm18.kt")
            public void testUnsignedIntToString_jvm18() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntToString_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedLongCompare_jvm18.kt")
            public void testUnsignedLongCompare_jvm18() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongCompare_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedLongDivide_jvm18.kt")
            public void testUnsignedLongDivide_jvm18() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongDivide_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedLongRemainder_jvm18.kt")
            public void testUnsignedLongRemainder_jvm18() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongRemainder_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedLongToString_jvm18.kt")
            public void testUnsignedLongToString_jvm18() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongToString_jvm18.kt");
            }

            @Test
            @TestMetadata(value="whenByUnsigned.kt")
            public void testWhenByUnsigned() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/whenByUnsigned.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/toArray")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ToArray {
            @Test
            public void testAllFilesPresentInToArray() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/toArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="noAccessorForToArray.kt")
            public void testNoAccessorForToArray() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/toArray/noAccessorForToArray.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/temporaryVals")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TemporaryVals {
            @Test
            public void testAllFilesPresentInTemporaryVals() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/temporaryVals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayCompoundAssignment.kt")
            public void testArrayCompoundAssignment() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/arrayCompoundAssignment.kt");
            }

            @Test
            @TestMetadata(value="elvisChain.kt")
            public void testElvisChain() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/elvisChain.kt");
            }

            @Test
            @TestMetadata(value="noTemporaryInCheckedCast.kt")
            public void testNoTemporaryInCheckedCast() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/noTemporaryInCheckedCast.kt");
            }

            @Test
            @TestMetadata(value="notNullReceiversInChain.kt")
            public void testNotNullReceiversInChain() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/notNullReceiversInChain.kt");
            }

            @Test
            @TestMetadata(value="safeCallChain1.kt")
            public void testSafeCallChain1() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChain1.kt");
            }

            @Test
            @TestMetadata(value="safeCallChain2.kt")
            public void testSafeCallChain2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChain2.kt");
            }

            @Test
            @TestMetadata(value="safeCallChainMemberExt1.kt")
            public void testSafeCallChainMemberExt1() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChainMemberExt1.kt");
            }

            @Test
            @TestMetadata(value="safeCallChainMemberExt2.kt")
            public void testSafeCallChainMemberExt2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChainMemberExt2.kt");
            }

            @Test
            @TestMetadata(value="safeCallElvisSafeCallElvisSomething.kt")
            public void testSafeCallElvisSafeCallElvisSomething() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallElvisSafeCallElvisSomething.kt");
            }

            @Test
            @TestMetadata(value="safeCallWithElvis.kt")
            public void testSafeCallWithElvis() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallWithElvis.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/stringOperations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class StringOperations {
            @Test
            public void testAllFilesPresentInStringOperations() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/stringOperations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="concat.kt")
            public void testConcat() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concat.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic.kt")
            public void testConcatDynamic() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic199.kt")
            public void testConcatDynamic199() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic199.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic200.kt")
            public void testConcatDynamic200() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic200.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic201.kt")
            public void testConcatDynamic201() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic201.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicConstants.kt")
            public void testConcatDynamicConstants() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicConstants.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicDataClass.kt")
            public void testConcatDynamicDataClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicDataClass.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicIndy.kt")
            public void testConcatDynamicIndy() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndy.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicIndy201.kt")
            public void testConcatDynamicIndy201() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndy201.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicIndyDataClass.kt")
            public void testConcatDynamicIndyDataClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndyDataClass.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicSpecialSymbols.kt")
            public void testConcatDynamicSpecialSymbols() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicSpecialSymbols.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicUnit.kt")
            public void testConcatDynamicUnit() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicUnit.kt");
            }

            @Test
            @TestMetadata(value="concatNotDynamic.kt")
            public void testConcatNotDynamic() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatNotDynamic.kt");
            }

            @Test
            @TestMetadata(value="constConcat.kt")
            public void testConstConcat() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/constConcat.kt");
            }

            @Test
            @TestMetadata(value="constValConcat.kt")
            public void testConstValConcat() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/constValConcat.kt");
            }

            @Test
            @TestMetadata(value="doNotAppendEmptyString.kt")
            public void testDoNotAppendEmptyString() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/doNotAppendEmptyString.kt");
            }

            @Test
            @TestMetadata(value="interpolation.kt")
            public void testInterpolation() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/interpolation.kt");
            }

            @Test
            @TestMetadata(value="kt15235.kt")
            public void testKt15235() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt15235.kt");
            }

            @Test
            @TestMetadata(value="kt19037.kt")
            public void testKt19037() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt19037.kt");
            }

            @Test
            @TestMetadata(value="kt42457_old.kt")
            public void testKt42457_old() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt42457_old.kt");
            }

            @Test
            @TestMetadata(value="multipleNestedConcat.kt")
            public void testMultipleNestedConcat() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/multipleNestedConcat.kt");
            }

            @Test
            @TestMetadata(value="nestedConcat.kt")
            public void testNestedConcat() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/nestedConcat.kt");
            }

            @Test
            @TestMetadata(value="nonNullableStringPlus.kt")
            public void testNonNullableStringPlus() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/nonNullableStringPlus.kt");
            }

            @Test
            @TestMetadata(value="nullableStringPlus.kt")
            public void testNullableStringPlus() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/nullableStringPlus.kt");
            }

            @Test
            @TestMetadata(value="partiallyConstConcat.kt")
            public void testPartiallyConstConcat() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/partiallyConstConcat.kt");
            }

            @Test
            @TestMetadata(value="plusAssign.kt")
            public void testPlusAssign() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/plusAssign.kt");
            }

            @Test
            @TestMetadata(value="primitiveToString.kt")
            public void testPrimitiveToString() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitiveToString.kt");
            }

            @Test
            @TestMetadata(value="primitiveToStringNotOptimizable.kt")
            public void testPrimitiveToStringNotOptimizable() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitiveToStringNotOptimizable.kt");
            }

            @Test
            @TestMetadata(value="primitivesAsStringTemplates.kt")
            public void testPrimitivesAsStringTemplates() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitivesAsStringTemplates.kt");
            }

            @Test
            @TestMetadata(value="singleConcat.kt")
            public void testSingleConcat() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/singleConcat.kt");
            }

            @Test
            @TestMetadata(value="stringBuilderToString.kt")
            public void testStringBuilderToString() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/stringBuilderToString.kt");
            }

            @Test
            @TestMetadata(value="stringPlus.kt")
            public void testStringPlus() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/stringPlus.kt");
            }

            @Test
            @TestMetadata(value="useAppendCharForOneCharStringInTemplate.kt")
            public void testUseAppendCharForOneCharStringInTemplate() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringInTemplate.kt");
            }

            @Test
            @TestMetadata(value="useAppendCharForOneCharStringInTemplate_2.kt")
            public void testUseAppendCharForOneCharStringInTemplate_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringInTemplate_2.kt");
            }

            @Test
            @TestMetadata(value="useAppendCharForOneCharStringUsingPlus.kt")
            public void testUseAppendCharForOneCharStringUsingPlus() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringUsingPlus.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/storeStackBeforeInline")
        @TestDataPath(value="$PROJECT_ROOT")
        public class StoreStackBeforeInline {
            @Test
            public void testAllFilesPresentInStoreStackBeforeInline() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/storeStackBeforeInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayConstructor.kt")
            public void testArrayConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/arrayConstructor.kt");
            }

            @Test
            @TestMetadata(value="differentTypes.kt")
            public void testDifferentTypes() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/differentTypes.kt");
            }

            @Test
            @TestMetadata(value="primitiveMerge.kt")
            public void testPrimitiveMerge() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/primitiveMerge.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/simple.kt");
            }

            @Test
            @TestMetadata(value="unreachableMarker.kt")
            public void testUnreachableMarker() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/unreachableMarker.kt");
            }

            @Test
            @TestMetadata(value="withLambda.kt")
            public void testWithLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/withLambda.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/staticFields")
        @TestDataPath(value="$PROJECT_ROOT")
        public class StaticFields {
            @Test
            public void testAllFilesPresentInStaticFields() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/staticFields"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classObject.kt")
            public void testClassObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/staticFields/classObject.kt");
            }

            @Test
            @TestMetadata(value="object.kt")
            public void testObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/staticFields/object.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/statements")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Statements {
            @Test
            public void testAllFilesPresentInStatements() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/statements"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="ifSingleBranch.kt")
            public void testIfSingleBranch() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/ifSingleBranch.kt");
            }

            @Test
            @TestMetadata(value="ifThenElse.kt")
            public void testIfThenElse() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/ifThenElse.kt");
            }

            @Test
            @TestMetadata(value="ifThenElseEmpty.kt")
            public void testIfThenElseEmpty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/ifThenElseEmpty.kt");
            }

            @Test
            @TestMetadata(value="labeled.kt")
            public void testLabeled() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/labeled.kt");
            }

            @Test
            @TestMetadata(value="statementsComposition.kt")
            public void testStatementsComposition() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/statementsComposition.kt");
            }

            @Test
            @TestMetadata(value="tryCatchFinally.kt")
            public void testTryCatchFinally() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/tryCatchFinally.kt");
            }

            @Test
            @TestMetadata(value="when.kt")
            public void testWhen() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/when.kt");
            }

            @Test
            @TestMetadata(value="whenSubject.kt")
            public void testWhenSubject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/whenSubject.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/sam")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Sam {
            @Test
            public void testAllFilesPresentInSam() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="samWrapperForNullInitialization.kt")
            public void testSamWrapperForNullInitialization() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperForNullInitialization.kt");
            }

            @Test
            @TestMetadata(value="samWrapperForNullableInitialization.kt")
            public void testSamWrapperForNullableInitialization() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperForNullableInitialization.kt");
            }

            @Test
            @TestMetadata(value="samWrapperInInlineLambda.kt")
            public void testSamWrapperInInlineLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperInInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="samWrapperInInlineLambda2.kt")
            public void testSamWrapperInInlineLambda2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperInInlineLambda2.kt");
            }

            @Test
            @TestMetadata(value="samWrapperOfLambda.kt")
            public void testSamWrapperOfLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperOfLambda.kt");
            }

            @Test
            @TestMetadata(value="samWrapperOfReference.kt")
            public void testSamWrapperOfReference() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperOfReference.kt");
            }

            @Test
            @TestMetadata(value="samWrapperRawTypes.kt")
            public void testSamWrapperRawTypes() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperRawTypes.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/ranges")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Ranges {
            @Test
            public void testAllFilesPresentInRanges() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ranges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="ifNotInRange.kt")
            public void testIfNotInRange() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/ifNotInRange.kt");
            }

            @Test
            @TestMetadata(value="inArrayIndices.kt")
            public void testInArrayIndices() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inArrayIndices.kt");
            }

            @Test
            @TestMetadata(value="inCharSequenceIndices.kt")
            public void testInCharSequenceIndices() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inCharSequenceIndices.kt");
            }

            @Test
            @TestMetadata(value="inCollectionIndices.kt")
            public void testInCollectionIndices() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inCollectionIndices.kt");
            }

            @Test
            @TestMetadata(value="inComparableRangeLiteral.kt")
            public void testInComparableRangeLiteral() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inComparableRangeLiteral.kt");
            }

            @Test
            @TestMetadata(value="inMixedUnsignedRange.kt")
            public void testInMixedUnsignedRange() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inMixedUnsignedRange.kt");
            }

            @Test
            @TestMetadata(value="inMixedUnsignedRange_2.kt")
            public void testInMixedUnsignedRange_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inMixedUnsignedRange_2.kt");
            }

            @Test
            @TestMetadata(value="inNonMatchingRangeIntrinsified.kt")
            public void testInNonMatchingRangeIntrinsified() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inNonMatchingRangeIntrinsified.kt");
            }

            @Test
            @TestMetadata(value="inOptimizableRange.kt")
            public void testInOptimizableRange() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inOptimizableRange.kt");
            }

            @Test
            @TestMetadata(value="inOptimizableUnsignedRange.kt")
            public void testInOptimizableUnsignedRange() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inOptimizableUnsignedRange.kt");
            }

            @Test
            @TestMetadata(value="inRangeUntil.kt")
            public void testInRangeUntil() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inRangeUntil.kt");
            }

            @Test
            @TestMetadata(value="inUntil.kt")
            public void testInUntil() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inUntil.kt");
            }

            @Test
            @TestMetadata(value="noDupXForLiteralRangeContains.kt")
            public void testNoDupXForLiteralRangeContains() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/noDupXForLiteralRangeContains.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/properties")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Properties {
            @Test
            public void testAllFilesPresentInProperties() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/properties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="dataClass.kt")
            public void testDataClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/dataClass.kt");
            }

            @Test
            @TestMetadata(value="openDataClass.kt")
            public void testOpenDataClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/openDataClass.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/properties/lateinit")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Lateinit {
                @Test
                public void testAllFilesPresentInLateinit() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/properties/lateinit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="companionObject.kt")
                public void testCompanionObject() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/lateinit/companionObject.kt");
                }

                @Test
                @TestMetadata(value="companionObjectFromLambda.kt")
                public void testCompanionObjectFromLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/lateinit/companionObjectFromLambda.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/parameterlessMain")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ParameterlessMain {
            @Test
            public void testAllFilesPresentInParameterlessMain() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/parameterlessMain"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="dontGenerateOnExtensionReceiver.kt")
            public void testDontGenerateOnExtensionReceiver() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnExtensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="dontGenerateOnJvmNameMain.kt")
            public void testDontGenerateOnJvmNameMain() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnJvmNameMain.kt");
            }

            @Test
            @TestMetadata(value="dontGenerateOnJvmOverloads.kt")
            public void testDontGenerateOnJvmOverloads() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnJvmOverloads.kt");
            }

            @Test
            @TestMetadata(value="dontGenerateOnMain.kt")
            public void testDontGenerateOnMain() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnMain.kt");
            }

            @Test
            @TestMetadata(value="dontGenerateOnMainExtension.kt")
            public void testDontGenerateOnMainExtension() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnMainExtension.kt");
            }

            @Test
            @TestMetadata(value="dontGenerateOnNullableArray.kt")
            public void testDontGenerateOnNullableArray() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnNullableArray.kt");
            }

            @Test
            @TestMetadata(value="dontGenerateOnNullableString.kt")
            public void testDontGenerateOnNullableString() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnNullableString.kt");
            }

            @Test
            @TestMetadata(value="dontGenerateOnVarargsString.kt")
            public void testDontGenerateOnVarargsString() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnVarargsString.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/outerClass")
        @TestDataPath(value="$PROJECT_ROOT")
        public class OuterClass {
            @Test
            public void testAllFilesPresentInOuterClass() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/outerClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classInClinit.kt")
            public void testClassInClinit() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/outerClass/classInClinit.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties")
        @TestDataPath(value="$PROJECT_ROOT")
        public class OptimizedDelegatedProperties {
            @Test
            public void testAllFilesPresentInOptimizedDelegatedProperties() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="definedInSources.kt")
            public void testDefinedInSources() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/definedInSources.kt");
            }

            @Test
            @TestMetadata(value="delegateToAnother.kt")
            public void testDelegateToAnother() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/delegateToAnother.kt");
            }

            @Test
            @TestMetadata(value="inSeparateModule.kt")
            public void testInSeparateModule() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/inSeparateModule.kt");
            }

            @Test
            @TestMetadata(value="lazy.kt")
            public void testLazy() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/lazy.kt");
            }

            @Test
            @TestMetadata(value="withNonNullMetadataParameter.kt")
            public void testWithNonNullMetadataParameter() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/withNonNullMetadataParameter.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/nullCheckOptimization")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NullCheckOptimization {
            @Test
            public void testAllFilesPresentInNullCheckOptimization() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/nullCheckOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="alreadyCheckedForIs.kt")
            public void testAlreadyCheckedForIs() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/alreadyCheckedForIs.kt");
            }

            @Test
            @TestMetadata(value="alreadyCheckedForNull.kt")
            public void testAlreadyCheckedForNull() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/alreadyCheckedForNull.kt");
            }

            @Test
            @TestMetadata(value="deterministicNotNullChecks.kt")
            public void testDeterministicNotNullChecks() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/deterministicNotNullChecks.kt");
            }

            @Test
            @TestMetadata(value="exclExclAsNotNullType.kt")
            public void testExclExclAsNotNullType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/exclExclAsNotNullType.kt");
            }

            @Test
            @TestMetadata(value="expressionValueIsNotNull.kt")
            public void testExpressionValueIsNotNull() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNull.kt");
            }

            @Test
            @TestMetadata(value="expressionValueIsNotNullAfterExclExcl.kt")
            public void testExpressionValueIsNotNullAfterExclExcl() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNullAfterExclExcl.kt");
            }

            @Test
            @TestMetadata(value="expressionValueIsNotNullTwice.kt")
            public void testExpressionValueIsNotNullTwice() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNullTwice.kt");
            }

            @Test
            @TestMetadata(value="ifNullEqualsNull.kt")
            public void testIfNullEqualsNull() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifNullEqualsNull.kt");
            }

            @Test
            @TestMetadata(value="ifNullEqualsNullInline.kt")
            public void testIfNullEqualsNullInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifNullEqualsNullInline.kt");
            }

            @Test
            @TestMetadata(value="ifUnitEqualsNull.kt")
            public void testIfUnitEqualsNull() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifUnitEqualsNull.kt");
            }

            @Test
            @TestMetadata(value="ifUnitEqualsNullInline.kt")
            public void testIfUnitEqualsNullInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifUnitEqualsNullInline.kt");
            }

            @Test
            @TestMetadata(value="kt12839.kt")
            public void testKt12839() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/kt12839.kt");
            }

            @Test
            @TestMetadata(value="multipleExclExcl_1_4.kt")
            public void testMultipleExclExcl_1_4() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/multipleExclExcl_1_4.kt");
            }

            @Test
            @TestMetadata(value="noNullCheckAfterCast.kt")
            public void testNoNullCheckAfterCast() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/noNullCheckAfterCast.kt");
            }

            @Test
            @TestMetadata(value="notNullAsNotNullable.kt")
            public void testNotNullAsNotNullable() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/notNullAsNotNullable.kt");
            }

            @Test
            @TestMetadata(value="notNullExpressionValueTwice_1_4.kt")
            public void testNotNullExpressionValueTwice_1_4() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/notNullExpressionValueTwice_1_4.kt");
            }

            @Test
            @TestMetadata(value="nullCheckAfterExclExcl_1_4.kt")
            public void testNullCheckAfterExclExcl_1_4() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/nullCheckAfterExclExcl_1_4.kt");
            }

            @Test
            @TestMetadata(value="nullabilityAssertionOnDispatchReceiver.kt")
            public void testNullabilityAssertionOnDispatchReceiver() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/nullabilityAssertionOnDispatchReceiver.kt");
            }

            @Test
            @TestMetadata(value="primitiveCheck.kt")
            public void testPrimitiveCheck() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/primitiveCheck.kt");
            }

            @Test
            @TestMetadata(value="redundantSafeCall.kt")
            public void testRedundantSafeCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/redundantSafeCall.kt");
            }

            @Test
            @TestMetadata(value="redundantSafeCall_1_4.kt")
            public void testRedundantSafeCall_1_4() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/redundantSafeCall_1_4.kt");
            }

            @Test
            @TestMetadata(value="reifiedIs.kt")
            public void testReifiedIs() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/reifiedIs.kt");
            }

            @Test
            @TestMetadata(value="reifiedNullIs.kt")
            public void testReifiedNullIs() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/reifiedNullIs.kt");
            }

            @Test
            @TestMetadata(value="safeCallAndElvisChains.kt")
            public void testSafeCallAndElvisChains() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/safeCallAndElvisChains.kt");
            }

            @Test
            @TestMetadata(value="trivialInstanceOf.kt")
            public void testTrivialInstanceOf() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/trivialInstanceOf.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit")
            @TestDataPath(value="$PROJECT_ROOT")
            public class LocalLateinit {
                @Test
                public void testAllFilesPresentInLocalLateinit() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="checkedAlways.kt")
                public void testCheckedAlways() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/checkedAlways.kt");
                }

                @Test
                @TestMetadata(value="checkedOnce.kt")
                public void testCheckedOnce() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/checkedOnce.kt");
                }

                @Test
                @TestMetadata(value="initialized.kt")
                public void testInitialized() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/initialized.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/notNullAssertions")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NotNullAssertions {
            @Test
            public void testAllFilesPresentInNotNullAssertions() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/notNullAssertions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayListGet.kt")
            public void testArrayListGet() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/arrayListGet.kt");
            }

            @Test
            @TestMetadata(value="assertionForNotNullCaptured.kt")
            public void testAssertionForNotNullCaptured() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullCaptured.kt");
            }

            @Test
            @TestMetadata(value="assertionForNotNullTypeParam.kt")
            public void testAssertionForNotNullTypeParam() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullTypeParam.kt");
            }

            @Test
            @TestMetadata(value="assertionForNotNullTypeParam_1_4.kt")
            public void testAssertionForNotNullTypeParam_1_4() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullTypeParam_1_4.kt");
            }

            @Test
            @TestMetadata(value="doNotGenerateParamAssertions.kt")
            public void testDoNotGenerateParamAssertions() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/doNotGenerateParamAssertions.kt");
            }

            @Test
            @TestMetadata(value="javaMultipleSubstitutions.kt")
            public void testJavaMultipleSubstitutions() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/javaMultipleSubstitutions.kt");
            }

            @Test
            @TestMetadata(value="noAssertionForNullableCaptured.kt")
            public void testNoAssertionForNullableCaptured() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableCaptured.kt");
            }

            @Test
            @TestMetadata(value="noAssertionForNullableGenericMethod.kt")
            public void testNoAssertionForNullableGenericMethod() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableGenericMethod.kt");
            }

            @Test
            @TestMetadata(value="noAssertionForNullableGenericMethodCall.kt")
            public void testNoAssertionForNullableGenericMethodCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableGenericMethodCall.kt");
            }

            @Test
            @TestMetadata(value="noAssertionForPrivateMethod.kt")
            public void testNoAssertionForPrivateMethod() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForPrivateMethod.kt");
            }

            @Test
            @TestMetadata(value="noAssertionsForKotlin.kt")
            public void testNoAssertionsForKotlin() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionsForKotlin.kt");
            }

            @Test
            @TestMetadata(value="noTemporaryVariableInNullCheckOnExpression.kt")
            public void testNoTemporaryVariableInNullCheckOnExpression() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noTemporaryVariableInNullCheckOnExpression.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/multifileClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class MultifileClasses {
            @Test
            public void testAllFilesPresentInMultifileClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultFunctionInMultifileClass.kt")
            public void testDefaultFunctionInMultifileClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/multifileClasses/defaultFunctionInMultifileClass.kt");
            }

            @Test
            @TestMetadata(value="optimizedMultifileClassFacadeMethods.kt")
            public void testOptimizedMultifileClassFacadeMethods() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/multifileClasses/optimizedMultifileClassFacadeMethods.kt");
            }

            @Test
            @TestMetadata(value="privateFunctionName.kt")
            public void testPrivateFunctionName() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/multifileClasses/privateFunctionName.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/mangling")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Mangling {
            @Test
            public void testAllFilesPresentInMangling() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/mangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="parentheses.kt")
            public void testParentheses() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/mangling/parentheses.kt");
            }

            @Test
            @TestMetadata(value="parenthesesNoSanitize.kt")
            public void testParenthesesNoSanitize() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/mangling/parenthesesNoSanitize.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/localInitializationLVT")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LocalInitializationLVT {
            @Test
            public void testAllFilesPresentInLocalInitializationLVT() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/localInitializationLVT"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="boxing.kt")
            public void testBoxing() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/boxing.kt");
            }

            @Test
            @TestMetadata(value="boxingVar.kt")
            public void testBoxingVar() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/boxingVar.kt");
            }

            @Test
            @TestMetadata(value="contract.kt")
            public void testContract() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/contract.kt");
            }

            @Test
            @TestMetadata(value="contractVar.kt")
            public void testContractVar() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/contractVar.kt");
            }

            @Test
            @TestMetadata(value="generics.kt")
            public void testGenerics() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/generics.kt");
            }

            @Test
            @TestMetadata(value="genericsVar.kt")
            public void testGenericsVar() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/genericsVar.kt");
            }

            @Test
            @TestMetadata(value="ifStatement.kt")
            public void testIfStatement() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatement.kt");
            }

            @Test
            @TestMetadata(value="ifStatementVar.kt")
            public void testIfStatementVar() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementVar.kt");
            }

            @Test
            @TestMetadata(value="ifStatementWithoutBlock.kt")
            public void testIfStatementWithoutBlock() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementWithoutBlock.kt");
            }

            @Test
            @TestMetadata(value="ifStatementWithoutBlockVar.kt")
            public void testIfStatementWithoutBlockVar() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementWithoutBlockVar.kt");
            }

            @Test
            @TestMetadata(value="inlineClass.kt")
            public void testInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/inlineClass.kt");
            }

            @Test
            @TestMetadata(value="inlineClassVar.kt")
            public void testInlineClassVar() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/inlineClassVar.kt");
            }

            @Test
            @TestMetadata(value="lateinit.kt")
            public void testLateinit() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/lateinit.kt");
            }

            @Test
            @TestMetadata(value="run.kt")
            public void testRun() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/run.kt");
            }

            @Test
            @TestMetadata(value="runVar.kt")
            public void testRunVar() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/runVar.kt");
            }

            @Test
            @TestMetadata(value="singleBlock.kt")
            public void testSingleBlock() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/singleBlock.kt");
            }

            @Test
            @TestMetadata(value="singleBlockVar.kt")
            public void testSingleBlockVar() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/singleBlockVar.kt");
            }

            @Test
            @TestMetadata(value="whenStatement.kt")
            public void testWhenStatement() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/whenStatement.kt");
            }

            @Test
            @TestMetadata(value="whenStatementVar.kt")
            public void testWhenStatementVar() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/whenStatementVar.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/lineNumbers")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LineNumbers {
            @Test
            public void testAllFilesPresentInLineNumbers() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lineNumbers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="delegationToList.kt")
            public void testDelegationToList() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/delegationToList.kt");
            }

            @Test
            @TestMetadata(value="ifConsts.kt")
            public void testIfConsts() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifConsts.kt");
            }

            @Test
            @TestMetadata(value="ifElse.kt")
            public void testIfElse() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifElse.kt");
            }

            @Test
            @TestMetadata(value="ifFalse.kt")
            public void testIfFalse() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifFalse.kt");
            }

            @Test
            @TestMetadata(value="ifFalseElse.kt")
            public void testIfFalseElse() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifFalseElse.kt");
            }

            @Test
            @TestMetadata(value="ifTrue.kt")
            public void testIfTrue() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifTrue.kt");
            }

            @Test
            @TestMetadata(value="ifTrueElse.kt")
            public void testIfTrueElse() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifTrueElse.kt");
            }

            @Test
            @TestMetadata(value="inlineCondition.kt")
            public void testInlineCondition() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineCondition.kt");
            }

            @Test
            @TestMetadata(value="inlineCondition2.kt")
            public void testInlineCondition2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineCondition2.kt");
            }

            @Test
            @TestMetadata(value="inlineLambdaObjectInit.kt")
            public void testInlineLambdaObjectInit() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineLambdaObjectInit.kt");
            }

            @Test
            @TestMetadata(value="kt61768.kt")
            public void testKt61768() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/kt61768.kt");
            }

            @Test
            @TestMetadata(value="singleThen.kt")
            public void testSingleThen() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/singleThen.kt");
            }

            @Test
            @TestMetadata(value="tryCatch.kt")
            public void testTryCatch() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/tryCatch.kt");
            }

            @Test
            @TestMetadata(value="tryFinally.kt")
            public void testTryFinally() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/tryFinally.kt");
            }

            @Test
            @TestMetadata(value="when.kt")
            public void testWhen() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/when.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/lazyCodegen")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LazyCodegen {
            @Test
            public void testAllFilesPresentInLazyCodegen() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lazyCodegen"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="inlineConstInsideComparison.kt")
            public void testInlineConstInsideComparison() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/inlineConstInsideComparison.kt");
            }

            @Test
            @TestMetadata(value="negateConst.kt")
            public void testNegateConst() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateConst.kt");
            }

            @Test
            @TestMetadata(value="negateObjectComp.kt")
            public void testNegateObjectComp() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectComp.kt");
            }

            @Test
            @TestMetadata(value="negateObjectCompChaing.kt")
            public void testNegateObjectCompChaing() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectCompChaing.kt");
            }

            @Test
            @TestMetadata(value="negateVar.kt")
            public void testNegateVar() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVar.kt");
            }

            @Test
            @TestMetadata(value="negateVarChain.kt")
            public void testNegateVarChain() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVarChain.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Jvm8 {
            @Test
            public void testAllFilesPresentInJvm8() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8/jvmDefault")
            @TestDataPath(value="$PROJECT_ROOT")
            public class JvmDefault {
                @Test
                public void testAllFilesPresentInJvmDefault() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility")
                @TestDataPath(value="$PROJECT_ROOT")
                public class AllCompatibility {
                    @Test
                    public void testAllFilesPresentInAllCompatibility() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="defaultArgs.kt")
                    public void testDefaultArgs() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/defaultArgs.kt");
                    }

                    @Test
                    @TestMetadata(value="simpleDiamond.kt")
                    public void testSimpleDiamond() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleDiamond.kt");
                    }

                    @Test
                    @TestMetadata(value="simpleFunction.kt")
                    public void testSimpleFunction() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleFunction.kt");
                    }

                    @Test
                    @TestMetadata(value="simpleFunctionWithAbstractOverride.kt")
                    public void testSimpleFunctionWithAbstractOverride() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleFunctionWithAbstractOverride.kt");
                    }

                    @Test
                    @TestMetadata(value="simpleProperty.kt")
                    public void testSimpleProperty() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleProperty.kt");
                    }
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8/hashCode")
            @TestDataPath(value="$PROJECT_ROOT")
            public class HashCode {
                @Test
                public void testAllFilesPresentInHashCode() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="dataClass.kt")
                public void testDataClass() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/hashCode/dataClass.kt");
                }

                @Test
                @TestMetadata(value="hashCode.kt")
                public void testHashCode() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/hashCode/hashCode.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/invokedynamic")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Invokedynamic {
            @Test
            public void testAllFilesPresentInInvokedynamic() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/invokedynamic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="extensionReceiversNames.kt")
            public void testExtensionReceiversNames() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/extensionReceiversNames.kt");
            }

            @Test
            @TestMetadata(value="functionRefToJavaInterface.kt")
            public void testFunctionRefToJavaInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/functionRefToJavaInterface.kt");
            }

            @Test
            @TestMetadata(value="lambdas.kt")
            public void testLambdas() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/lambdas.kt");
            }

            @Test
            @TestMetadata(value="streamApi.kt")
            public void testStreamApi() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/streamApi.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/intrinsicsTrim")
        @TestDataPath(value="$PROJECT_ROOT")
        public class IntrinsicsTrim {
            @Test
            public void testAllFilesPresentInIntrinsicsTrim() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsicsTrim"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="trimIndentNegative.kt")
            public void testTrimIndentNegative() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimIndentNegative.kt");
            }

            @Test
            @TestMetadata(value="trimIndentPositive.kt")
            public void testTrimIndentPositive() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimIndentPositive.kt");
            }

            @Test
            @TestMetadata(value="trimMarginNegative.kt")
            public void testTrimMarginNegative() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimMarginNegative.kt");
            }

            @Test
            @TestMetadata(value="trimMarginPositive.kt")
            public void testTrimMarginPositive() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimMarginPositive.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/intrinsicsCompare")
        @TestDataPath(value="$PROJECT_ROOT")
        public class IntrinsicsCompare {
            @Test
            public void testAllFilesPresentInIntrinsicsCompare() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsicsCompare"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="byteSmartCast_after.kt")
            public void testByteSmartCast_after() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/byteSmartCast_after.kt");
            }

            @Test
            @TestMetadata(value="byteSmartCast_before.kt")
            public void testByteSmartCast_before() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/byteSmartCast_before.kt");
            }

            @Test
            @TestMetadata(value="charSmartCast.kt")
            public void testCharSmartCast() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/charSmartCast.kt");
            }

            @Test
            @TestMetadata(value="differentTypes_after.kt")
            public void testDifferentTypes_after() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/differentTypes_after.kt");
            }

            @Test
            @TestMetadata(value="differentTypes_before.kt")
            public void testDifferentTypes_before() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/differentTypes_before.kt");
            }

            @Test
            @TestMetadata(value="intSmartCast_after.kt")
            public void testIntSmartCast_after() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/intSmartCast_after.kt");
            }

            @Test
            @TestMetadata(value="intSmartCast_before.kt")
            public void testIntSmartCast_before() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/intSmartCast_before.kt");
            }

            @Test
            @TestMetadata(value="longSmartCast.kt")
            public void testLongSmartCast() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/longSmartCast.kt");
            }

            @Test
            @TestMetadata(value="shortSmartCast_after.kt")
            public void testShortSmartCast_after() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/shortSmartCast_after.kt");
            }

            @Test
            @TestMetadata(value="shortSmartCast_before.kt")
            public void testShortSmartCast_before() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/shortSmartCast_before.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/intrinsics")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Intrinsics {
            @Test
            public void testAllFilesPresentInIntrinsics() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="javaObjectType.kt")
            public void testJavaObjectType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsics/javaObjectType.kt");
            }

            @Test
            @TestMetadata(value="javaPrimitiveType.kt")
            public void testJavaPrimitiveType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsics/javaPrimitiveType.kt");
            }

            @Test
            @TestMetadata(value="postfixIncrDecr.kt")
            public void testPostfixIncrDecr() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsics/postfixIncrDecr.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/interfaces")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Interfaces {
            @Test
            @TestMetadata(value="addedInterfaceBridge.kt")
            public void testAddedInterfaceBridge() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/addedInterfaceBridge.kt");
            }

            @Test
            public void testAllFilesPresentInInterfaces() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/interfaces"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="firstInheritedMethodIsAbstract.kt")
            public void testFirstInheritedMethodIsAbstract() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/firstInheritedMethodIsAbstract.kt");
            }

            @Test
            @TestMetadata(value="noAnyMethodsOnInterfaceInheritance.kt")
            public void testNoAnyMethodsOnInterfaceInheritance() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/noAnyMethodsOnInterfaceInheritance.kt");
            }

            @Test
            @TestMetadata(value="noNullCheckOnThisInDefaultMethod.kt")
            public void testNoNullCheckOnThisInDefaultMethod() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/noNullCheckOnThisInDefaultMethod.kt");
            }

            @Test
            @TestMetadata(value="noPrivateMemberInJavaInterface.kt")
            public void testNoPrivateMemberInJavaInterface() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/noPrivateMemberInJavaInterface.kt");
            }

            @Test
            @TestMetadata(value="traitImplGeneratedOnce.kt")
            public void testTraitImplGeneratedOnce() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/traitImplGeneratedOnce.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/innerClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InnerClasses {
            @Test
            public void testAllFilesPresentInInnerClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/innerClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt27936.kt")
            public void testKt27936() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt27936.kt");
            }

            @Test
            @TestMetadata(value="kt53804.kt")
            public void testKt53804() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt53804.kt");
            }

            @Test
            @TestMetadata(value="kt56104.kt")
            public void testKt56104() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt56104.kt");
            }

            @Test
            @TestMetadata(value="kt57714.kt")
            public void testKt57714() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt57714.kt");
            }

            @Test
            @TestMetadata(value="nestedClassInAnnotationArgument.kt")
            public void testNestedClassInAnnotationArgument() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/nestedClassInAnnotationArgument.kt");
            }

            @Test
            @TestMetadata(value="nestedClassInAnnotationArgumentOldMode.kt")
            public void testNestedClassInAnnotationArgumentOldMode() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/nestedClassInAnnotationArgumentOldMode.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/inlineClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="asCastForInlineClass.kt")
            public void testAsCastForInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/asCastForInlineClass.kt");
            }

            @Test
            @TestMetadata(value="assertionsForParametersOfInlineClassTypes.kt")
            public void testAssertionsForParametersOfInlineClassTypes() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/assertionsForParametersOfInlineClassTypes.kt");
            }

            @Test
            @TestMetadata(value="boxInlineClassInsideElvisWithNullConstant.kt")
            public void testBoxInlineClassInsideElvisWithNullConstant() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxInlineClassInsideElvisWithNullConstant.kt");
            }

            @Test
            @TestMetadata(value="boxInlineClassesOnPassingToVarargs.kt")
            public void testBoxInlineClassesOnPassingToVarargs() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxInlineClassesOnPassingToVarargs.kt");
            }

            @Test
            @TestMetadata(value="boxMethodCalledByInlineClass.kt")
            public void testBoxMethodCalledByInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxMethodCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="boxResultAfterConstructorCall.kt")
            public void testBoxResultAfterConstructorCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxResultAfterConstructorCall.kt");
            }

            @Test
            @TestMetadata(value="boxResultInlineClassOfConstructorCall.kt")
            public void testBoxResultInlineClassOfConstructorCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxResultInlineClassOfConstructorCall.kt");
            }

            @Test
            @TestMetadata(value="boxThisOfInlineClass.kt")
            public void testBoxThisOfInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxThisOfInlineClass.kt");
            }

            @Test
            @TestMetadata(value="boxUnboxInlineClassFromMethodReturnType.kt")
            public void testBoxUnboxInlineClassFromMethodReturnType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxInlineClassFromMethodReturnType.kt");
            }

            @Test
            @TestMetadata(value="boxUnboxInsideLambdaAsLastExpression.kt")
            public void testBoxUnboxInsideLambdaAsLastExpression() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxInsideLambdaAsLastExpression.kt");
            }

            @Test
            @TestMetadata(value="boxUnboxOfInlineClassesWithFunctionalTypes.kt")
            public void testBoxUnboxOfInlineClassesWithFunctionalTypes() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxOfInlineClassesWithFunctionalTypes.kt");
            }

            @Test
            @TestMetadata(value="boxUnboxOnInlinedParameters.kt")
            public void testBoxUnboxOnInlinedParameters() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxOnInlinedParameters.kt");
            }

            @Test
            @TestMetadata(value="boxingForNonLocalAndLabeledReturnsOfInlineClasses.kt")
            public void testBoxingForNonLocalAndLabeledReturnsOfInlineClasses() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxingForNonLocalAndLabeledReturnsOfInlineClasses.kt");
            }

            @Test
            @TestMetadata(value="callMemberMethodsInsideInlineClass.kt")
            public void testCallMemberMethodsInsideInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/callMemberMethodsInsideInlineClass.kt");
            }

            @Test
            @TestMetadata(value="checkBoxingInInlineClass.kt")
            public void testCheckBoxingInInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/checkBoxingInInlineClass.kt");
            }

            @Test
            @TestMetadata(value="checkOuterInlineFunctionCall.kt")
            public void testCheckOuterInlineFunctionCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/checkOuterInlineFunctionCall.kt");
            }

            @Test
            @TestMetadata(value="constructorBridge.kt")
            public void testConstructorBridge() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/constructorBridge.kt");
            }

            @Test
            @TestMetadata(value="constructorWithDefaultArguments.kt")
            public void testConstructorWithDefaultArguments() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/constructorWithDefaultArguments.kt");
            }

            @Test
            @TestMetadata(value="defaultParametersDontBox.kt")
            public void testDefaultParametersDontBox() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/defaultParametersDontBox.kt");
            }

            @Test
            @TestMetadata(value="delegatedPropertyMangling.kt")
            public void testDelegatedPropertyMangling() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/delegatedPropertyMangling.kt");
            }

            @Test
            @TestMetadata(value="equalsDoesNotBox.kt")
            public void testEqualsDoesNotBox() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/equalsDoesNotBox.kt");
            }

            @Test
            @TestMetadata(value="equalsIsCalledByInlineClass.kt")
            public void testEqualsIsCalledByInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/equalsIsCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="factoryMethodForSecondaryConstructorsCalledByInlineClass.kt")
            public void testFactoryMethodForSecondaryConstructorsCalledByInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/factoryMethodForSecondaryConstructorsCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="functionsWithInlineClassParametersHaveStableMangledNames.kt")
            public void testFunctionsWithInlineClassParametersHaveStableMangledNames() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/functionsWithInlineClassParametersHaveStableMangledNames.kt");
            }

            @Test
            @TestMetadata(value="generationOfAccessorToUnderlyingValue.kt")
            public void testGenerationOfAccessorToUnderlyingValue() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/generationOfAccessorToUnderlyingValue.kt");
            }

            @Test
            @TestMetadata(value="genericNoUnbox.kt")
            public void testGenericNoUnbox() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/genericNoUnbox.kt");
            }

            @Test
            @TestMetadata(value="hashCodeIsCalledByInlineClass.kt")
            public void testHashCodeIsCalledByInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/hashCodeIsCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="inlineClassBoxingOnAssignment.kt")
            public void testInlineClassBoxingOnAssignment() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingOnAssignment.kt");
            }

            @Test
            @TestMetadata(value="inlineClassBoxingOnFunctionCall.kt")
            public void testInlineClassBoxingOnFunctionCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingOnFunctionCall.kt");
            }

            @Test
            @TestMetadata(value="inlineClassBoxingUnboxingInsideInlinedLambda.kt")
            public void testInlineClassBoxingUnboxingInsideInlinedLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingUnboxingInsideInlinedLambda.kt");
            }

            @Test
            @TestMetadata(value="inlineClassInGeneratedToString.kt")
            public void testInlineClassInGeneratedToString() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassInGeneratedToString.kt");
            }

            @Test
            @TestMetadata(value="inlineClassInStringTemplate.kt")
            public void testInlineClassInStringTemplate() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassInStringTemplate.kt");
            }

            @Test
            @TestMetadata(value="inlineClassesUnboxingAfterAssertionOperator.kt")
            public void testInlineClassesUnboxingAfterAssertionOperator() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassesUnboxingAfterAssertionOperator.kt");
            }

            @Test
            @TestMetadata(value="interfaceDefaultImplStubs.kt")
            public void testInterfaceDefaultImplStubs() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/interfaceDefaultImplStubs.kt");
            }

            @Test
            @TestMetadata(value="isCheckForInlineClass.kt")
            public void testIsCheckForInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/isCheckForInlineClass.kt");
            }

            @Test
            @TestMetadata(value="kt33722.kt")
            public void testKt33722() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/kt33722.kt");
            }

            @Test
            @TestMetadata(value="mangledInlineClassInterfaceImplementation.kt")
            public void testMangledInlineClassInterfaceImplementation() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledInlineClassInterfaceImplementation.kt");
            }

            @Test
            @TestMetadata(value="mangledSamWrappers.kt")
            public void testMangledSamWrappers() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappers.kt");
            }

            @Test
            @TestMetadata(value="mangledSamWrappersIndy.kt")
            public void testMangledSamWrappersIndy() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappersIndy.kt");
            }

            @Test
            @TestMetadata(value="mangledSamWrappersOld.kt")
            public void testMangledSamWrappersOld() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappersOld.kt");
            }

            @Test
            @TestMetadata(value="noActualCallsOfInlineFunctionsOfInlineClass.kt")
            public void testNoActualCallsOfInlineFunctionsOfInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noActualCallsOfInlineFunctionsOfInlineClass.kt");
            }

            @Test
            @TestMetadata(value="noAssertionsForInlineClassesBasedOnNullableTypes.kt")
            public void testNoAssertionsForInlineClassesBasedOnNullableTypes() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noAssertionsForInlineClassesBasedOnNullableTypes.kt");
            }

            @Test
            @TestMetadata(value="noBoxingInMethod.kt")
            public void testNoBoxingInMethod() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingInMethod.kt");
            }

            @Test
            @TestMetadata(value="noBoxingOnCastOperations.kt")
            public void testNoBoxingOnCastOperations() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingOnCastOperations.kt");
            }

            @Test
            @TestMetadata(value="noBoxingOperationsOnNonTrivialSpread.kt")
            public void testNoBoxingOperationsOnNonTrivialSpread() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingOperationsOnNonTrivialSpread.kt");
            }

            @Test
            @TestMetadata(value="noBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate.kt")
            public void testNoBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate.kt");
            }

            @Test
            @TestMetadata(value="noManglingForFunctionsWithJvmName.kt")
            public void testNoManglingForFunctionsWithJvmName() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noManglingForFunctionsWithJvmName.kt");
            }

            @Test
            @TestMetadata(value="noReturnTypeMangling.kt")
            public void testNoReturnTypeMangling() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noReturnTypeMangling.kt");
            }

            @Test
            @TestMetadata(value="nonOverridingMethodsAreCalledByInlineClass.kt")
            public void testNonOverridingMethodsAreCalledByInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/nonOverridingMethodsAreCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="overridingMethodsAreCalledByInlineClass.kt")
            public void testOverridingMethodsAreCalledByInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/overridingMethodsAreCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="passInlineClassesWithSpreadOperatorToVarargs.kt")
            public void testPassInlineClassesWithSpreadOperatorToVarargs() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/passInlineClassesWithSpreadOperatorToVarargs.kt");
            }

            @Test
            @TestMetadata(value="primaryConstructorCalledByInlineClass.kt")
            public void testPrimaryConstructorCalledByInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/primaryConstructorCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="propertyAccessorsAreCalledByInlineClass.kt")
            public void testPropertyAccessorsAreCalledByInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/propertyAccessorsAreCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="propertySetterWithInlineClassTypeArgument.kt")
            public void testPropertySetterWithInlineClassTypeArgument() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/propertySetterWithInlineClassTypeArgument.kt");
            }

            @Test
            @TestMetadata(value="resultApiDoesntCallSpecializedEquals.kt")
            public void testResultApiDoesntCallSpecializedEquals() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiDoesntCallSpecializedEquals.kt");
            }

            @Test
            @TestMetadata(value="resultApiDoesntUseBox.kt")
            public void testResultApiDoesntUseBox() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiDoesntUseBox.kt");
            }

            @Test
            @TestMetadata(value="resultApiEqualsDoesntBox.kt")
            public void testResultApiEqualsDoesntBox() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiEqualsDoesntBox.kt");
            }

            @Test
            @TestMetadata(value="resultApiRunCatchingDoesntBox.kt")
            public void testResultApiRunCatchingDoesntBox() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiRunCatchingDoesntBox.kt");
            }

            @Test
            @TestMetadata(value="resultApiStringInterpolationDoesntBox.kt")
            public void testResultApiStringInterpolationDoesntBox() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiStringInterpolationDoesntBox.kt");
            }

            @Test
            @TestMetadata(value="resultMangling.kt")
            public void testResultMangling() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultMangling.kt");
            }

            @Test
            @TestMetadata(value="skipCallToUnderlyingValueOfInlineClass.kt")
            public void testSkipCallToUnderlyingValueOfInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/skipCallToUnderlyingValueOfInlineClass.kt");
            }

            @Test
            @TestMetadata(value="suspendFunctionMangling.kt")
            public void testSuspendFunctionMangling() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/suspendFunctionMangling.kt");
            }

            @Test
            @TestMetadata(value="toStringOfInlineClassValue.kt")
            public void testToStringOfInlineClassValue() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/toStringOfInlineClassValue.kt");
            }

            @Test
            @TestMetadata(value="toStringOfReferenceInlineClassValue.kt")
            public void testToStringOfReferenceInlineClassValue() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/toStringOfReferenceInlineClassValue.kt");
            }

            @Test
            @TestMetadata(value="uIntArrayIteratorWithoutBoxing.kt")
            public void testUIntArrayIteratorWithoutBoxing() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/uIntArrayIteratorWithoutBoxing.kt");
            }

            @Test
            @TestMetadata(value="uIntArraySwapBoxing.kt")
            public void testUIntArraySwapBoxing() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/uIntArraySwapBoxing.kt");
            }

            @Test
            @TestMetadata(value="unboxInlineClassAfterElvis.kt")
            public void testUnboxInlineClassAfterElvis() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassAfterElvis.kt");
            }

            @Test
            @TestMetadata(value="unboxInlineClassAfterSafeCall.kt")
            public void testUnboxInlineClassAfterSafeCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassAfterSafeCall.kt");
            }

            @Test
            @TestMetadata(value="unboxInlineClassFromParameterizedType.kt")
            public void testUnboxInlineClassFromParameterizedType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassFromParameterizedType.kt");
            }

            @Test
            @TestMetadata(value="unboxInlineClassesAfterSmartCasts.kt")
            public void testUnboxInlineClassesAfterSmartCasts() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassesAfterSmartCasts.kt");
            }

            @Test
            @TestMetadata(value="unboxMethodCalledByInlineClass.kt")
            public void testUnboxMethodCalledByInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxMethodCalledByInlineClass.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/inlineArgsInPlace")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineArgsInPlace {
            @Test
            public void testAllFilesPresentInInlineArgsInPlace() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inlineArgsInPlace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kotlinMathMax.kt")
            public void testKotlinMathMax() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/kotlinMathMax.kt");
            }

            @Test
            @TestMetadata(value="println.kt")
            public void testPrintln() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/println.kt");
            }

            @Test
            @TestMetadata(value="sin.kt")
            public void testSin() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/sin.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/inline")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Inline {
            @Test
            public void testAllFilesPresentInInline() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultLambda.kt")
            public void testDefaultLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/defaultLambda.kt");
            }

            @Test
            @TestMetadata(value="deleteClassOnTransformation.kt")
            public void testDeleteClassOnTransformation() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/deleteClassOnTransformation.kt");
            }

            @Test
            @TestMetadata(value="entriesMappingOnCallSite.kt")
            public void testEntriesMappingOnCallSite() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/entriesMappingOnCallSite.kt");
            }

            @Test
            @TestMetadata(value="finallyMarkers.kt")
            public void testFinallyMarkers() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/finallyMarkers.kt");
            }

            @Test
            @TestMetadata(value="inlineArgumentSlots.kt")
            public void testInlineArgumentSlots() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineArgumentSlots.kt");
            }

            @Test
            @TestMetadata(value="inlineReturnsNothing1.kt")
            public void testInlineReturnsNothing1() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing1.kt");
            }

            @Test
            @TestMetadata(value="inlineReturnsNothing2.kt")
            public void testInlineReturnsNothing2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing2.kt");
            }

            @Test
            @TestMetadata(value="inlineReturnsNothing3.kt")
            public void testInlineReturnsNothing3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing3.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendReifiedNoSpilling.kt")
            public void testInlineSuspendReifiedNoSpilling() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineSuspendReifiedNoSpilling.kt");
            }

            @Test
            @TestMetadata(value="interfaceDefaultMethod.kt")
            public void testInterfaceDefaultMethod() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/interfaceDefaultMethod.kt");
            }

            @Test
            @TestMetadata(value="linenumberForOneParametersArgumentCall.kt")
            public void testLinenumberForOneParametersArgumentCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/linenumberForOneParametersArgumentCall.kt");
            }

            @Test
            @TestMetadata(value="noFakeVariableForInlineOnlyFun.kt")
            public void testNoFakeVariableForInlineOnlyFun() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFun.kt");
            }

            @Test
            @TestMetadata(value="noFakeVariableForInlineOnlyFunFromStdlib.kt")
            public void testNoFakeVariableForInlineOnlyFunFromStdlib() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunFromStdlib.kt");
            }

            @Test
            @TestMetadata(value="noFakeVariableForInlineOnlyFunMap.kt")
            public void testNoFakeVariableForInlineOnlyFunMap() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunMap.kt");
            }

            @Test
            @TestMetadata(value="noFakeVariableForInlineOnlyFunWithLambda.kt")
            public void testNoFakeVariableForInlineOnlyFunWithLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunWithLambda.kt");
            }

            @Test
            @TestMetadata(value="noSynAccessor.kt")
            public void testNoSynAccessor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessor.kt");
            }

            @Test
            @TestMetadata(value="noSynAccessorToDirectFieldAccess.kt")
            public void testNoSynAccessorToDirectFieldAccess() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToDirectFieldAccess.kt");
            }

            @Test
            @TestMetadata(value="noSynAccessorToSuper.kt")
            public void testNoSynAccessorToSuper() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToSuper.kt");
            }

            @Test
            @TestMetadata(value="notSplitedExceptionTable.kt")
            public void testNotSplitedExceptionTable() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/notSplitedExceptionTable.kt");
            }

            @Test
            @TestMetadata(value="reifiedSafeAsWithMutable.kt")
            public void testReifiedSafeAsWithMutable() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/reifiedSafeAsWithMutable.kt");
            }

            @Test
            @TestMetadata(value="remappedLocalVar.kt")
            public void testRemappedLocalVar() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/remappedLocalVar.kt");
            }

            @Test
            @TestMetadata(value="removedFinallyMarkers.kt")
            public void testRemovedFinallyMarkers() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/removedFinallyMarkers.kt");
            }

            @Test
            @TestMetadata(value="specialEnumFunction.kt")
            public void testSpecialEnumFunction() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/specialEnumFunction.kt");
            }

            @Test
            @TestMetadata(value="splitedExceptionTable.kt")
            public void testSplitedExceptionTable() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/splitedExceptionTable.kt");
            }

            @Test
            @TestMetadata(value="whenMappingOnCallSite.kt")
            public void testWhenMappingOnCallSite() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/whenMappingOnCallSite.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/inline/property")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Property {
                @Test
                public void testAllFilesPresentInProperty() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/property/simple.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/ieee754")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Ieee754 {
            @Test
            public void testAllFilesPresentInIeee754() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ieee754"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="nullableDoubleEquals.kt")
            public void testNullableDoubleEquals() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleEquals.kt");
            }

            @Test
            @TestMetadata(value="nullableDoubleNotEquals.kt")
            public void testNullableDoubleNotEquals() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleNotEquals.kt");
            }

            @Test
            @TestMetadata(value="nullableFloatEquals.kt")
            public void testNullableFloatEquals() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatEquals.kt");
            }

            @Test
            @TestMetadata(value="nullableFloatNotEquals.kt")
            public void testNullableFloatNotEquals() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatNotEquals.kt");
            }

            @Test
            @TestMetadata(value="smartCastsForDouble.kt")
            public void testSmartCastsForDouble() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForDouble.kt");
            }

            @Test
            @TestMetadata(value="smartCastsForFloat.kt")
            public void testSmartCastsForFloat() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForFloat.kt");
            }

            @Test
            @TestMetadata(value="when.kt")
            public void testWhen() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/when.kt");
            }

            @Test
            @TestMetadata(value="whenNullableSmartCast.kt")
            public void testWhenNullableSmartCast() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/whenNullableSmartCast.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/hashCode")
        @TestDataPath(value="$PROJECT_ROOT")
        public class HashCode {
            @Test
            public void testAllFilesPresentInHashCode() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="interfaceHashCode.kt")
            public void testInterfaceHashCode() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/hashCode/interfaceHashCode.kt");
            }

            @Test
            @TestMetadata(value="interfaceHashCodeWithSmartCast.kt")
            public void testInterfaceHashCodeWithSmartCast() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/hashCode/interfaceHashCodeWithSmartCast.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForLoop {
            @Test
            public void testAllFilesPresentInForLoop() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInCharSequence.kt")
            public void testForInCharSequence() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequence.kt");
            }

            @Test
            @TestMetadata(value="forInCharSequenceTypeParameter.kt")
            public void testForInCharSequenceTypeParameter() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceTypeParameter.kt");
            }

            @Test
            @TestMetadata(value="forInDownToCharMinValue.kt")
            public void testForInDownToCharMinValue() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToCharMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInDownToIntMinValue.kt")
            public void testForInDownToIntMinValue() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToIntMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInDownToLongConstNoUnderflow.kt")
            public void testForInDownToLongConstNoUnderflow() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToLongConstNoUnderflow.kt");
            }

            @Test
            @TestMetadata(value="forInDownToLongMinValue.kt")
            public void testForInDownToLongMinValue() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToLongMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInObjectArray.kt")
            public void testForInObjectArray() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInObjectArray.kt");
            }

            @Test
            @TestMetadata(value="forInPrimitiveArray.kt")
            public void testForInPrimitiveArray() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInPrimitiveArray.kt");
            }

            @Test
            @TestMetadata(value="forInRangeInlinedFromStdlib.kt")
            public void testForInRangeInlinedFromStdlib() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeInlinedFromStdlib.kt");
            }

            @Test
            @TestMetadata(value="forInRangeSpecializedToUntil.kt")
            public void testForInRangeSpecializedToUntil() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeSpecializedToUntil.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToCharConst.kt")
            public void testForInRangeToCharConst() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToCharConst.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToCharMaxValue.kt")
            public void testForInRangeToCharMaxValue() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToCharMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToConst.kt")
            public void testForInRangeToConst() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToConst.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToIntMaxValue.kt")
            public void testForInRangeToIntMaxValue() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToIntMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToLongConst.kt")
            public void testForInRangeToLongConst() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToLongConst.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToLongMaxValue.kt")
            public void testForInRangeToLongMaxValue() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToLongMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToQualifiedConst.kt")
            public void testForInRangeToQualifiedConst() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToQualifiedConst.kt");
            }

            @Test
            @TestMetadata(value="forInRangeWithImplicitReceiver.kt")
            public void testForInRangeWithImplicitReceiver() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithImplicitReceiver.kt");
            }

            @Test
            @TestMetadata(value="forInStringSpecialized.kt")
            public void testForInStringSpecialized() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInStringSpecialized.kt");
            }

            @Test
            @TestMetadata(value="forIntInDownTo.kt")
            public void testForIntInDownTo() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forIntInDownTo.kt");
            }

            @Test
            @TestMetadata(value="iincGeneration.kt")
            public void testIincGeneration() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/iincGeneration.kt");
            }

            @Test
            @TestMetadata(value="intrinsicArrayConstructorsUseCounterLoop.kt")
            public void testIntrinsicArrayConstructorsUseCounterLoop() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/intrinsicArrayConstructorsUseCounterLoop.kt");
            }

            @Test
            @TestMetadata(value="loopVarInterval.kt")
            public void testLoopVarInterval() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/loopVarInterval.kt");
            }

            @Test
            @TestMetadata(value="primitiveLiteralRange1.kt")
            public void testPrimitiveLiteralRange1() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange1.kt");
            }

            @Test
            @TestMetadata(value="primitiveLiteralRange2.kt")
            public void testPrimitiveLiteralRange2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange2.kt");
            }

            @Test
            @TestMetadata(value="primitiveProgression.kt")
            public void testPrimitiveProgression() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveProgression.kt");
            }

            @Test
            @TestMetadata(value="primitiveRange.kt")
            public void testPrimitiveRange() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveRange.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/unsigned")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Unsigned {
                @Test
                public void testAllFilesPresentInUnsigned() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/unsigned"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInConstBoundUnsignedRange.kt")
                public void testForInConstBoundUnsignedRange() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInConstBoundUnsignedRange.kt");
                }

                @Test
                @TestMetadata(value="forInDownToUIntMinValue.kt")
                public void testForInDownToUIntMinValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInDownToUIntMinValue.kt");
                }

                @Test
                @TestMetadata(value="forInDownToULongMinValue.kt")
                public void testForInDownToULongMinValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInDownToULongMinValue.kt");
                }

                @Test
                @TestMetadata(value="forInOptimizableUnsignedRange.kt")
                public void testForInOptimizableUnsignedRange() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInOptimizableUnsignedRange.kt");
                }

                @Test
                @TestMetadata(value="forInRangeToUIntMaxValue.kt")
                public void testForInRangeToUIntMaxValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInRangeToUIntMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInRangeToULongMaxValue.kt")
                public void testForInRangeToULongMaxValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInRangeToULongMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInUnsignedArray.kt")
                public void testForInUnsignedArray() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArray.kt");
                }

                @Test
                @TestMetadata(value="forInUnsignedArrayIndices.kt")
                public void testForInUnsignedArrayIndices() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArrayIndices.kt");
                }

                @Test
                @TestMetadata(value="forInUnsignedArrayWithIndex.kt")
                public void testForInUnsignedArrayWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArrayWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInUntilUIntMaxValue.kt")
                public void testForInUntilUIntMaxValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilUIntMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilUIntMinValue.kt")
                public void testForInUntilUIntMinValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilUIntMinValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilULongMaxValue.kt")
                public void testForInUntilULongMaxValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilULongMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilULongMinValue.kt")
                public void testForInUntilULongMinValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilULongMinValue.kt");
                }

                @Test
                @TestMetadata(value="illegalStepConst.kt")
                public void testIllegalStepConst() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/illegalStepConst.kt");
                }

                @Test
                @TestMetadata(value="reversedThenStep.kt")
                public void testReversedThenStep() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/reversedThenStep.kt");
                }

                @Test
                @TestMetadata(value="stepConstOnNonLiteralProgression.kt")
                public void testStepConstOnNonLiteralProgression() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepConstOnNonLiteralProgression.kt");
                }

                @Test
                @TestMetadata(value="stepNonConstOnNonLiteralProgression.kt")
                public void testStepNonConstOnNonLiteralProgression() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepNonConstOnNonLiteralProgression.kt");
                }

                @Test
                @TestMetadata(value="stepOnNonLiteralRange.kt")
                public void testStepOnNonLiteralRange() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepOnNonLiteralRange.kt");
                }

                @Test
                @TestMetadata(value="stepThenDifferentStep.kt")
                public void testStepThenDifferentStep() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepThenDifferentStep.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/stepped")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Stepped {
                @Test
                public void testAllFilesPresentInStepped() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/stepped"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="illegalStepConst.kt")
                public void testIllegalStepConst() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/illegalStepConst.kt");
                }

                @Test
                @TestMetadata(value="reversedThenStep.kt")
                public void testReversedThenStep() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/reversedThenStep.kt");
                }

                @Test
                @TestMetadata(value="stepConst.kt")
                public void testStepConst() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepConst.kt");
                }

                @Test
                @TestMetadata(value="stepConstOnNonLiteralProgression.kt")
                public void testStepConstOnNonLiteralProgression() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepConstOnNonLiteralProgression.kt");
                }

                @Test
                @TestMetadata(value="stepNonConst.kt")
                public void testStepNonConst() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepNonConst.kt");
                }

                @Test
                @TestMetadata(value="stepNonConstOnNonLiteralProgression.kt")
                public void testStepNonConstOnNonLiteralProgression() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepNonConstOnNonLiteralProgression.kt");
                }

                @Test
                @TestMetadata(value="stepOnNonLiteralRange.kt")
                public void testStepOnNonLiteralRange() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOnNonLiteralRange.kt");
                }

                @Test
                @TestMetadata(value="stepOne.kt")
                public void testStepOne() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOne.kt");
                }

                @Test
                @TestMetadata(value="stepOneThenStepOne.kt")
                public void testStepOneThenStepOne() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOneThenStepOne.kt");
                }

                @Test
                @TestMetadata(value="stepThenDifferentStep.kt")
                public void testStepThenDifferentStep() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenDifferentStep.kt");
                }

                @Test
                @TestMetadata(value="stepThenReversed.kt")
                public void testStepThenReversed() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenReversed.kt");
                }

                @Test
                @TestMetadata(value="stepThenSameStep.kt")
                public void testStepThenSameStep() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenSameStep.kt");
                }

                @Test
                @TestMetadata(value="stepThenStepNonConst.kt")
                public void testStepThenStepNonConst() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenStepNonConst.kt");
                }

                @Test
                @TestMetadata(value="stepThenStepOne.kt")
                public void testStepThenStepOne() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenStepOne.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInUntil")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInUntil {
                @Test
                public void testAllFilesPresentInForInUntil() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInUntil"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInUntilChar.kt")
                public void testForInUntilChar() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilChar.kt");
                }

                @Test
                @TestMetadata(value="forInUntilCharMaxValue.kt")
                public void testForInUntilCharMaxValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilCharMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilCharMinValue.kt")
                public void testForInUntilCharMinValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilCharMinValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilInt.kt")
                public void testForInUntilInt() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilInt.kt");
                }

                @Test
                @TestMetadata(value="forInUntilIntMaxValue.kt")
                public void testForInUntilIntMaxValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilIntMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilIntMinValue.kt")
                public void testForInUntilIntMinValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilIntMinValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilLong.kt")
                public void testForInUntilLong() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLong.kt");
                }

                @Test
                @TestMetadata(value="forInUntilLongMaxValue.kt")
                public void testForInUntilLongMaxValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLongMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilLongMinValue.kt")
                public void testForInUntilLongMinValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLongMinValue.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInSequenceWithIndex {
                @Test
                public void testAllFilesPresentInForInSequenceWithIndex() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInEmptySequenceWithIndex.kt")
                public void testForInEmptySequenceWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInEmptySequenceWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInSequenceTypeParameterWithIndex.kt")
                public void testForInSequenceTypeParameterWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceTypeParameterWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInSequenceWithIndex.kt")
                public void testForInSequenceWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInSequenceWithIndexNoElementVar.kt")
                public void testForInSequenceWithIndexNoElementVar() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexNoElementVar.kt");
                }

                @Test
                @TestMetadata(value="forInSequenceWithIndexNoIndexVar.kt")
                public void testForInSequenceWithIndexNoIndexVar() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVar.kt");
                }

                @Test
                @TestMetadata(value="forInSequenceWithIndexThrowsCME.kt")
                public void testForInSequenceWithIndexThrowsCME() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexThrowsCME.kt");
                }

                @Test
                @TestMetadata(value="forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt")
                public void testForInSequenceWithIndexWithExplicitlyTypedIndexVariable() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInReversed")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInReversed {
                @Test
                public void testAllFilesPresentInForInReversed() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInReversed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInReversedArrayIndices.kt")
                public void testForInReversedArrayIndices() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedArrayIndices.kt");
                }

                @Test
                @TestMetadata(value="forInReversedCharSequenceIndices.kt")
                public void testForInReversedCharSequenceIndices() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedCharSequenceIndices.kt");
                }

                @Test
                @TestMetadata(value="forInReversedCollectionIndices.kt")
                public void testForInReversedCollectionIndices() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedCollectionIndices.kt");
                }

                @Test
                @TestMetadata(value="forInReversedDownTo.kt")
                public void testForInReversedDownTo() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedDownTo.kt");
                }

                @Test
                @TestMetadata(value="forInReversedEmptyRangeLiteral.kt")
                public void testForInReversedEmptyRangeLiteral() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedEmptyRangeLiteral.kt");
                }

                @Test
                @TestMetadata(value="forInReversedRange.kt")
                public void testForInReversedRange() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedRange.kt");
                }

                @Test
                @TestMetadata(value="forInReversedRangeLiteral.kt")
                public void testForInReversedRangeLiteral() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedRangeLiteral.kt");
                }

                @Test
                @TestMetadata(value="forInReversedReversedArrayIndices.kt")
                public void testForInReversedReversedArrayIndices() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedArrayIndices.kt");
                }

                @Test
                @TestMetadata(value="forInReversedReversedDownTo.kt")
                public void testForInReversedReversedDownTo() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedDownTo.kt");
                }

                @Test
                @TestMetadata(value="forInReversedReversedRange.kt")
                public void testForInReversedReversedRange() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedRange.kt");
                }

                @Test
                @TestMetadata(value="forInReversedReversedReversedRange.kt")
                public void testForInReversedReversedReversedRange() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedReversedRange.kt");
                }

                @Test
                @TestMetadata(value="forInReversedReversedUntil.kt")
                public void testForInReversedReversedUntil() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedUntil.kt");
                }

                @Test
                @TestMetadata(value="forInReversedUntil.kt")
                public void testForInReversedUntil() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedUntil.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInRangeWithUpperBoundMinus1 {
                @Test
                public void testAllFilesPresentInForInRangeWithUpperBoundMinus1() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="booleanArray.kt")
                public void testBooleanArray() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/booleanArray.kt");
                }

                @Test
                @TestMetadata(value="byteArray.kt")
                public void testByteArray() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/byteArray.kt");
                }

                @Test
                @TestMetadata(value="charArray.kt")
                public void testCharArray() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/charArray.kt");
                }

                @Test
                @TestMetadata(value="charSequence.kt")
                public void testCharSequence() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/charSequence.kt");
                }

                @Test
                @TestMetadata(value="doubleArray.kt")
                public void testDoubleArray() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/doubleArray.kt");
                }

                @Test
                @TestMetadata(value="emptyList.kt")
                public void testEmptyList() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptyList.kt");
                }

                @Test
                @TestMetadata(value="emptyMap.kt")
                public void testEmptyMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptyMap.kt");
                }

                @Test
                @TestMetadata(value="emptySet.kt")
                public void testEmptySet() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptySet.kt");
                }

                @Test
                @TestMetadata(value="floatArray.kt")
                public void testFloatArray() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/floatArray.kt");
                }

                @Test
                @TestMetadata(value="intArray.kt")
                public void testIntArray() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/intArray.kt");
                }

                @Test
                @TestMetadata(value="list.kt")
                public void testList() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/list.kt");
                }

                @Test
                @TestMetadata(value="longArray.kt")
                public void testLongArray() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/longArray.kt");
                }

                @Test
                @TestMetadata(value="map.kt")
                public void testMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/map.kt");
                }

                @Test
                @TestMetadata(value="mutableList.kt")
                public void testMutableList() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableList.kt");
                }

                @Test
                @TestMetadata(value="mutableMap.kt")
                public void testMutableMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableMap.kt");
                }

                @Test
                @TestMetadata(value="mutableSet.kt")
                public void testMutableSet() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableSet.kt");
                }

                @Test
                @TestMetadata(value="set.kt")
                public void testSet() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/set.kt");
                }

                @Test
                @TestMetadata(value="shortArray.kt")
                public void testShortArray() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/shortArray.kt");
                }

                @Test
                @TestMetadata(value="string.kt")
                public void testString() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/string.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInRangeUntil {
                @Test
                public void testAllFilesPresentInForInRangeUntil() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInRangeUntilChar.kt")
                public void testForInRangeUntilChar() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilChar.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilCharMaxValue.kt")
                public void testForInRangeUntilCharMaxValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilCharMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilCharMinValue.kt")
                public void testForInRangeUntilCharMinValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilCharMinValue.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilInt.kt")
                public void testForInRangeUntilInt() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilInt.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilIntMaxValue.kt")
                public void testForInRangeUntilIntMaxValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilIntMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilIntMinValue.kt")
                public void testForInRangeUntilIntMinValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilIntMinValue.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilLong.kt")
                public void testForInRangeUntilLong() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLong.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilLongMaxValue.kt")
                public void testForInRangeUntilLongMaxValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLongMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilLongMinValue.kt")
                public void testForInRangeUntilLongMinValue() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLongMinValue.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInProgressionWithIndex {
                @Test
                public void testAllFilesPresentInForInProgressionWithIndex() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInDownToWithIndex.kt")
                public void testForInDownToWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInDownToWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInIndicesWithIndex.kt")
                public void testForInIndicesWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInIndicesWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInRangeToWithIndex.kt")
                public void testForInRangeToWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInRangeToWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInReversedStepWithIndex.kt")
                public void testForInReversedStepWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInReversedStepWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInReversedWithIndex.kt")
                public void testForInReversedWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInReversedWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInStepReversedWithIndex.kt")
                public void testForInStepReversedWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInStepReversedWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInStepWithIndex.kt")
                public void testForInStepWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInStepWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInUntilWithIndex.kt")
                public void testForInUntilWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInUntilWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInWithIndexNoIndexOrElementVar.kt")
                public void testForInWithIndexNoIndexOrElementVar() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexNoIndexOrElementVar.kt");
                }

                @Test
                @TestMetadata(value="forInWithIndexNotDestructured.kt")
                public void testForInWithIndexNotDestructured() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexNotDestructured.kt");
                }

                @Test
                @TestMetadata(value="forInWithIndexReversed.kt")
                public void testForInWithIndexReversed() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexReversed.kt");
                }

                @Test
                @TestMetadata(value="forInWithIndexWithIndex.kt")
                public void testForInWithIndexWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexWithIndex.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInIterableWithIndex {
                @Test
                public void testAllFilesPresentInForInIterableWithIndex() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInEmptyListWithIndex.kt")
                public void testForInEmptyListWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInEmptyListWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInIterableTypeParameterWithIndex.kt")
                public void testForInIterableTypeParameterWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInIterableTypeParameterWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInListWithIndex.kt")
                public void testForInListWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInListWithIndexNoElementVar.kt")
                public void testForInListWithIndexNoElementVar() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexNoElementVar.kt");
                }

                @Test
                @TestMetadata(value="forInListWithIndexNoIndexVar.kt")
                public void testForInListWithIndexNoIndexVar() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexNoIndexVar.kt");
                }

                @Test
                @TestMetadata(value="forInListWithIndexWithExplicitlyTypedIndexVariable.kt")
                public void testForInListWithIndexWithExplicitlyTypedIndexVariable() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexWithExplicitlyTypedIndexVariable.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInIndices")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInIndices {
                @Test
                public void testAllFilesPresentInForInIndices() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIndices"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInArrayListIndices.kt")
                public void testForInArrayListIndices() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInArrayListIndices.kt");
                }

                @Test
                @TestMetadata(value="forInCharSequenceIndices.kt")
                public void testForInCharSequenceIndices() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCharSequenceIndices.kt");
                }

                @Test
                @TestMetadata(value="forInCharSequenceTypeParameterIndices.kt")
                public void testForInCharSequenceTypeParameterIndices() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCharSequenceTypeParameterIndices.kt");
                }

                @Test
                @TestMetadata(value="forInCollectionImplicitReceiverIndices.kt")
                public void testForInCollectionImplicitReceiverIndices() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionImplicitReceiverIndices.kt");
                }

                @Test
                @TestMetadata(value="forInCollectionIndices.kt")
                public void testForInCollectionIndices() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionIndices.kt");
                }

                @Test
                @TestMetadata(value="forInCollectionTypeParameterIndices.kt")
                public void testForInCollectionTypeParameterIndices() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionTypeParameterIndices.kt");
                }

                @Test
                @TestMetadata(value="forInNonOptimizedIndices.kt")
                public void testForInNonOptimizedIndices() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInNonOptimizedIndices.kt");
                }

                @Test
                @TestMetadata(value="forInObjectArrayIndices.kt")
                public void testForInObjectArrayIndices() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInObjectArrayIndices.kt");
                }

                @Test
                @TestMetadata(value="forInPrimitiveArrayIndices.kt")
                public void testForInPrimitiveArrayIndices() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInPrimitiveArrayIndices.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInCharSequenceWithIndex {
                @Test
                public void testAllFilesPresentInForInCharSequenceWithIndex() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInCharSequenceWithIndex.kt")
                public void testForInCharSequenceWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInCharSequenceWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInEmptyStringWithIndex.kt")
                public void testForInEmptyStringWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInEmptyStringWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInStringWithIndex.kt")
                public void testForInStringWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInStringWithIndexNoElementVar.kt")
                public void testForInStringWithIndexNoElementVar() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexNoElementVar.kt");
                }

                @Test
                @TestMetadata(value="forInStringWithIndexNoIndexVar.kt")
                public void testForInStringWithIndexNoIndexVar() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexNoIndexVar.kt");
                }

                @Test
                @TestMetadata(value="forInStringWithIndexWithExplicitlyTypedIndexVariable.kt")
                public void testForInStringWithIndexWithExplicitlyTypedIndexVariable() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexWithExplicitlyTypedIndexVariable.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInArrayWithIndex {
                @Test
                public void testAllFilesPresentInForInArrayWithIndex() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInArrayWithIndexNoElementVar.kt")
                public void testForInArrayWithIndexNoElementVar() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInArrayWithIndexNoElementVar.kt");
                }

                @Test
                @TestMetadata(value="forInArrayWithIndexNoIndexVar.kt")
                public void testForInArrayWithIndexNoIndexVar() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInArrayWithIndexNoIndexVar.kt");
                }

                @Test
                @TestMetadata(value="forInEmptyArrayWithIndex.kt")
                public void testForInEmptyArrayWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInEmptyArrayWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInIntArrayWithIndex.kt")
                public void testForInIntArrayWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInIntArrayWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInObjectArrayWithIndex.kt")
                public void testForInObjectArrayWithIndex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInObjectArrayWithIndex.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/fieldsForCapturedValues")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FieldsForCapturedValues {
            @Test
            public void testAllFilesPresentInFieldsForCapturedValues() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="constructorOnly.kt")
            public void testConstructorOnly() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/constructorOnly.kt");
            }

            @Test
            @TestMetadata(value="extensionLambdaExtensionReceiver.kt")
            public void testExtensionLambdaExtensionReceiver() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/extensionLambdaExtensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="extensionReceiver.kt")
            public void testExtensionReceiver() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/extensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="innerAndOuterThis.kt")
            public void testInnerAndOuterThis() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/innerAndOuterThis.kt");
            }

            @Test
            @TestMetadata(value="labeledExtensionLambdaExtensionReceiver.kt")
            public void testLabeledExtensionLambdaExtensionReceiver() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/labeledExtensionLambdaExtensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="multipleExtensionReceivers.kt")
            public void testMultipleExtensionReceivers() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/multipleExtensionReceivers.kt");
            }

            @Test
            @TestMetadata(value="outerThis.kt")
            public void testOuterThis() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThis.kt");
            }

            @Test
            @TestMetadata(value="outerThisInInnerConstructor.kt")
            public void testOuterThisInInnerConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThisInInnerConstructor.kt");
            }

            @Test
            @TestMetadata(value="outerThisInInnerInitBlock.kt")
            public void testOuterThisInInnerInitBlock() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThisInInnerInitBlock.kt");
            }

            @Test
            @TestMetadata(value="this.kt")
            public void testThis() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/this.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/exclExcl")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ExclExcl {
            @Test
            public void testAllFilesPresentInExclExcl() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/exclExcl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="exclExclOnPlatformType.kt")
            public void testExclExclOnPlatformType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/exclExcl/exclExclOnPlatformType.kt");
            }

            @Test
            @TestMetadata(value="primitive.kt")
            public void testPrimitive() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/exclExcl/primitive.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/enum")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Enum {
            @Test
            public void testAllFilesPresentInEnum() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="constructorAccessors.kt")
            public void testConstructorAccessors() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/constructorAccessors.kt");
            }

            @Test
            @TestMetadata(value="enumCheckcasts.kt")
            public void testEnumCheckcasts() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumCheckcasts.kt");
            }

            @Test
            @TestMetadata(value="enumEntries.kt")
            public void testEnumEntries() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntries.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesIntrinsic.kt")
            public void testEnumEntriesIntrinsic() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesIntrinsic.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesIntrinsicForJava.kt")
            public void testEnumEntriesIntrinsicForJava() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesIntrinsicForJava.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesMapping.kt")
            public void testEnumEntriesMapping() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesMapping.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesMultiMapping.kt")
            public void testEnumEntriesMultiMapping() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesMultiMapping.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesNoMapping.kt")
            public void testEnumEntriesNoMapping() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesNoMapping.kt");
            }

            @Test
            @TestMetadata(value="kt18731.kt")
            public void testKt18731() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/kt18731.kt");
            }

            @Test
            @TestMetadata(value="kt18731_2.kt")
            public void testKt18731_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/kt18731_2.kt");
            }

            @Test
            @TestMetadata(value="kt57671_1.kt")
            public void testKt57671_1() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/kt57671_1.kt");
            }

            @Test
            @TestMetadata(value="kt57671_2.kt")
            public void testKt57671_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/kt57671_2.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/disabledOptimizations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DisabledOptimizations {
            @Test
            public void testAllFilesPresentInDisabledOptimizations() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/disabledOptimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="noJumpInLastBranch.kt")
            public void testNoJumpInLastBranch() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noJumpInLastBranch.kt");
            }

            @Test
            @TestMetadata(value="noJumpInSingleBranch.kt")
            public void testNoJumpInSingleBranch() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noJumpInSingleBranch.kt");
            }

            @Test
            @TestMetadata(value="noObjectCastAfterReification.kt")
            public void testNoObjectCastAfterReification() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noObjectCastAfterReification.kt");
            }

            @Test
            @TestMetadata(value="noUnitInstanceInDefaultParameterInitialization.kt")
            public void testNoUnitInstanceInDefaultParameterInitialization() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnitInstanceInDefaultParameterInitialization.kt");
            }

            @Test
            @TestMetadata(value="noUnitInstanceOnVoidFunctionCall.kt")
            public void testNoUnitInstanceOnVoidFunctionCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnitInstanceOnVoidFunctionCall.kt");
            }

            @Test
            @TestMetadata(value="noUnusedLabel.kt")
            public void testNoUnusedLabel() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnusedLabel.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/directInvoke")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DirectInvoke {
            @Test
            public void testAllFilesPresentInDirectInvoke() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/directInvoke"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="callableReference.kt")
            public void testCallableReference() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/directInvoke/callableReference.kt");
            }

            @Test
            @TestMetadata(value="inplaceClosure.kt")
            public void testInplaceClosure() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/directInvoke/inplaceClosure.kt");
            }

            @Test
            @TestMetadata(value="localFun.kt")
            public void testLocalFun() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/directInvoke/localFun.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/defaultArguments")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DefaultArguments {
            @Test
            public void testAllFilesPresentInDefaultArguments() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="inheritedInterfaceFunction.kt")
            public void testInheritedInterfaceFunction() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/inheritedInterfaceFunction.kt");
            }

            @Test
            @TestMetadata(value="kt11962.kt")
            public void testKt11962() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/kt11962.kt");
            }

            @Test
            @TestMetadata(value="localVariablesInInlinedDefaultStubs.kt")
            public void testLocalVariablesInInlinedDefaultStubs() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/localVariablesInInlinedDefaultStubs.kt");
            }

            @Test
            @TestMetadata(value="maskAndArgumentElimination.kt")
            public void testMaskAndArgumentElimination() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/maskAndArgumentElimination.kt");
            }

            @Test
            @TestMetadata(value="maskCheckSequence.kt")
            public void testMaskCheckSequence() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/maskCheckSequence.kt");
            }

            @Test
            @TestMetadata(value="methodHandlerElimination.kt")
            public void testMethodHandlerElimination() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/methodHandlerElimination.kt");
            }

            @Test
            @TestMetadata(value="noAccessorForDefault.kt")
            public void testNoAccessorForDefault() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noAccessorForDefault.kt");
            }

            @Test
            @TestMetadata(value="noAnonymousObjectRegenerationInDefaultStub.kt")
            public void testNoAnonymousObjectRegenerationInDefaultStub() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noAnonymousObjectRegenerationInDefaultStub.kt");
            }

            @Test
            @TestMetadata(value="noEmptyArray.kt")
            public void testNoEmptyArray() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noEmptyArray.kt");
            }

            @Test
            @TestMetadata(value="noSyntheticParameters.kt")
            public void testNoSyntheticParameters() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noSyntheticParameters.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/deadCodeElimination")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DeadCodeElimination {
            @Test
            public void testAllFilesPresentInDeadCodeElimination() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/deadCodeElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayConstructor.kt")
            public void testArrayConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/arrayConstructor.kt");
            }

            @Test
            @TestMetadata(value="boxing.kt")
            public void testBoxing() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/boxing.kt");
            }

            @Test
            @TestMetadata(value="boxingNotOptimizable.kt")
            public void testBoxingNotOptimizable() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/boxingNotOptimizable.kt");
            }

            @Test
            @TestMetadata(value="emptyVariableRange.kt")
            public void testEmptyVariableRange() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/emptyVariableRange.kt");
            }

            @Test
            @TestMetadata(value="kt14357.kt")
            public void testKt14357() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/kt14357.kt");
            }

            @Test
            @TestMetadata(value="lastReturn.kt")
            public void testLastReturn() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/lastReturn.kt");
            }

            @Test
            @TestMetadata(value="literal.kt")
            public void testLiteral() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/literal.kt");
            }

            @Test
            @TestMetadata(value="simpleConstructor.kt")
            public void testSimpleConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructor.kt");
            }

            @Test
            @TestMetadata(value="simpleConstructorNotRedundant.kt")
            public void testSimpleConstructorNotRedundant() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructorNotRedundant.kt");
            }

            @Test
            @TestMetadata(value="simpleConstructorNotRedundantNotOptimizable.kt")
            public void testSimpleConstructorNotRedundantNotOptimizable() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructorNotRedundantNotOptimizable.kt");
            }

            @Test
            @TestMetadata(value="unusedPrimitiveAndObjectEquals.kt")
            public void testUnusedPrimitiveAndObjectEquals() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/unusedPrimitiveAndObjectEquals.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Coroutines {
            @Test
            public void testAllFilesPresentInCoroutines() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="crossinlineSuspendContinuation_1_3.kt")
            public void testCrossinlineSuspendContinuation_1_3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/crossinlineSuspendContinuation_1_3.kt");
            }

            @Test
            @TestMetadata(value="doNotReassignContinuation.kt")
            public void testDoNotReassignContinuation() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/doNotReassignContinuation.kt");
            }

            @Test
            @TestMetadata(value="effectivelyInlineOnly.kt")
            public void testEffectivelyInlineOnly() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/effectivelyInlineOnly.kt");
            }

            @Test
            @TestMetadata(value="internalInlineSuspend.kt")
            public void testInternalInlineSuspend() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/internalInlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="mergeLvt.kt")
            public void testMergeLvt() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/mergeLvt.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn.kt")
            public void testNonLocalReturn() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/nonLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="returnUnitInLambda.kt")
            public void testReturnUnitInLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/returnUnitInLambda.kt");
            }

            @Test
            @TestMetadata(value="suspendMain.kt")
            public void testSuspendMain() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/suspendMain.kt");
            }

            @Test
            @TestMetadata(value="throwOnFailure.kt")
            public void testThrowOnFailure() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/throwOnFailure.kt");
            }

            @Test
            @TestMetadata(value="varValueConflictsWithTable.kt")
            public void testVarValueConflictsWithTable() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTable.kt");
            }

            @Test
            @TestMetadata(value="varValueConflictsWithTableSameSort.kt")
            public void testVarValueConflictsWithTableSameSort() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTableSameSort.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/stateMachine")
            @TestDataPath(value="$PROJECT_ROOT")
            public class StateMachine {
                @Test
                public void testAllFilesPresentInStateMachine() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/stateMachine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="kt25893.kt")
                public void testKt25893() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/stateMachine/kt25893.kt");
                }

                @Test
                @TestMetadata(value="withTypeParameter.kt")
                public void testWithTypeParameter() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/stateMachine/withTypeParameter.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling")
            @TestDataPath(value="$PROJECT_ROOT")
            public class IntLikeVarSpilling {
                @Test
                public void testAllFilesPresentInIntLikeVarSpilling() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="complicatedMerge.kt")
                public void testComplicatedMerge() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/complicatedMerge.kt");
                }

                @Test
                @TestMetadata(value="i2bResult.kt")
                public void testI2bResult() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/i2bResult.kt");
                }

                @Test
                @TestMetadata(value="loadFromBooleanArray.kt")
                public void testLoadFromBooleanArray() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt");
                }

                @Test
                @TestMetadata(value="loadFromByteArray.kt")
                public void testLoadFromByteArray() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromByteArray.kt");
                }

                @Test
                @TestMetadata(value="noVariableInTable.kt")
                public void testNoVariableInTable() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/noVariableInTable.kt");
                }

                @Test
                @TestMetadata(value="sameIconst1ManyVars.kt")
                public void testSameIconst1ManyVars() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt");
                }

                @Test
                @TestMetadata(value="usedInArrayStore.kt")
                public void testUsedInArrayStore() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInArrayStore.kt");
                }

                @Test
                @TestMetadata(value="usedInMethodCall.kt")
                public void testUsedInMethodCall() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInMethodCall.kt");
                }

                @Test
                @TestMetadata(value="usedInPutfield.kt")
                public void testUsedInPutfield() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInPutfield.kt");
                }

                @Test
                @TestMetadata(value="usedInVarStore.kt")
                public void testUsedInVarStore() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInVarStore.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/inlineClasses")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineClasses {
                @Test
                public void testAllFilesPresentInInlineClasses() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineClassBoxingInSuspendFunReturn_Primitive.kt")
                public void testInlineClassBoxingInSuspendFunReturn_Primitive() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/inlineClassBoxingInSuspendFunReturn_Primitive.kt");
                }

                @Test
                @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_Any.kt")
                public void testNoInlineClassBoxingInSuspendFunReturn_Any() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_Any.kt");
                }

                @Test
                @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_InlineAny.kt")
                public void testNoInlineClassBoxingInSuspendFunReturn_InlineAny() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_InlineAny.kt");
                }

                @Test
                @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_SameJvmType.kt")
                public void testNoInlineClassBoxingInSuspendFunReturn_SameJvmType() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_SameJvmType.kt");
                }

                @Test
                @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_String.kt")
                public void testNoInlineClassBoxingInSuspendFunReturn_String() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_String.kt");
                }

                @Test
                @TestMetadata(value="returnResult.kt")
                public void testReturnResult() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/returnResult.kt");
                }

                @Test
                @TestMetadata(value="returnStringOverride.kt")
                public void testReturnStringOverride() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/returnStringOverride.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DestructuringInLambda {
                @Test
                public void testAllFilesPresentInDestructuringInLambda() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineSeparateFiles.kt")
                public void testInlineSeparateFiles() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda/inlineSeparateFiles.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/debug")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Debug {
                @Test
                public void testAllFilesPresentInDebug() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/debug"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="continuationInLvt.kt")
                public void testContinuationInLvt() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/continuationInLvt.kt");
                }

                @Test
                @TestMetadata(value="localVariableCorrectLabel.kt")
                public void testLocalVariableCorrectLabel() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/localVariableCorrectLabel.kt");
                }

                @Test
                @TestMetadata(value="probeCoroutineSuspended.kt")
                public void testProbeCoroutineSuspended() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/probeCoroutineSuspended.kt");
                }

                @Test
                @TestMetadata(value="shrinkLvtTopLevel.kt")
                public void testShrinkLvtTopLevel() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/shrinkLvtTopLevel.kt");
                }

                @Test
                @TestMetadata(value="thisAndResultInLvt.kt")
                public void testThisAndResultInLvt() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/thisAndResultInLvt.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/controlStructures")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ControlStructures {
            @Test
            public void testAllFilesPresentInControlStructures() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/controlStructures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="ifConsts.kt")
            public void testIfConsts() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/controlStructures/ifConsts.kt");
            }

            @Test
            @TestMetadata(value="kt17110.kt")
            public void testKt17110() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/controlStructures/kt17110.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/constructors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Constructors {
            @Test
            public void testAllFilesPresentInConstructors() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constructors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="enumPrimaryDefaults.kt")
            public void testEnumPrimaryDefaults() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/enumPrimaryDefaults.kt");
            }

            @Test
            @TestMetadata(value="inlineArgumentPrimaryDefaults.kt")
            public void testInlineArgumentPrimaryDefaults() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/inlineArgumentPrimaryDefaults.kt");
            }

            @Test
            @TestMetadata(value="inlinePrimaryDefaults.kt")
            public void testInlinePrimaryDefaults() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/inlinePrimaryDefaults.kt");
            }

            @Test
            @TestMetadata(value="innerClassConstructor.kt")
            public void testInnerClassConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/innerClassConstructor.kt");
            }

            @Test
            @TestMetadata(value="innerPrimaryDefaults.kt")
            public void testInnerPrimaryDefaults() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/innerPrimaryDefaults.kt");
            }

            @Test
            @TestMetadata(value="internalPrimaryDefaults.kt")
            public void testInternalPrimaryDefaults() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/internalPrimaryDefaults.kt");
            }

            @Test
            @TestMetadata(value="localPrimaryDefaults.kt")
            public void testLocalPrimaryDefaults() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/localPrimaryDefaults.kt");
            }

            @Test
            @TestMetadata(value="parameterlessPrimary.kt")
            public void testParameterlessPrimary() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/parameterlessPrimary.kt");
            }

            @Test
            @TestMetadata(value="privatePrimaryDefaults.kt")
            public void testPrivatePrimaryDefaults() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/privatePrimaryDefaults.kt");
            }

            @Test
            @TestMetadata(value="protectedPrimaryDefaults.kt")
            public void testProtectedPrimaryDefaults() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/protectedPrimaryDefaults.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/constants")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Constants {
            @Test
            public void testAllFilesPresentInConstants() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constants"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="byte.kt")
            public void testByte() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/byte.kt");
            }

            @Test
            @TestMetadata(value="comparisonFalse.kt")
            public void testComparisonFalse() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/comparisonFalse.kt");
            }

            @Test
            @TestMetadata(value="comparisonTrue.kt")
            public void testComparisonTrue() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/comparisonTrue.kt");
            }

            @Test
            @TestMetadata(value="floatingPoints.kt")
            public void testFloatingPoints() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/floatingPoints.kt");
            }

            @Test
            @TestMetadata(value="inlineUnsignedIntConstant.kt")
            public void testInlineUnsignedIntConstant() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/inlineUnsignedIntConstant.kt");
            }

            @Test
            @TestMetadata(value="kt9532.kt")
            public void testKt9532() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/kt9532.kt");
            }

            @Test
            @TestMetadata(value="noInlineNonConst.kt")
            public void testNoInlineNonConst() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonConst.kt");
            }

            @Test
            @TestMetadata(value="noInlineNonStaticJavaField.kt")
            public void testNoInlineNonStaticJavaField() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonStaticJavaField.kt");
            }

            @Test
            @TestMetadata(value="nullableByteAndShort.kt")
            public void testNullableByteAndShort() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/nullableByteAndShort.kt");
            }

            @Test
            @TestMetadata(value="partialString.kt")
            public void testPartialString() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/partialString.kt");
            }

            @Test
            @TestMetadata(value="short.kt")
            public void testShort() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/short.kt");
            }

            @Test
            @TestMetadata(value="string.kt")
            public void testString() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/string.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/constantConditions")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ConstantConditions {
            @Test
            public void testAllFilesPresentInConstantConditions() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constantConditions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="cmpIntWith0.kt")
            public void testCmpIntWith0() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/cmpIntWith0.kt");
            }

            @Test
            @TestMetadata(value="constantFlag.kt")
            public void testConstantFlag() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/constantFlag.kt");
            }

            @Test
            @TestMetadata(value="constantInt.kt")
            public void testConstantInt() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/constantInt.kt");
            }

            @Test
            @TestMetadata(value="inlineIfFalse.kt")
            public void testInlineIfFalse() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/inlineIfFalse.kt");
            }

            @Test
            @TestMetadata(value="kt3098.kt")
            public void testKt3098() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/kt3098.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/constProperty")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ConstProperty {
            @Test
            public void testAllFilesPresentInConstProperty() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="noAccessorsForPrivateConstants.kt")
            public void testNoAccessorsForPrivateConstants() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constProperty/noAccessorsForPrivateConstants.kt");
            }

            @Test
            @TestMetadata(value="nonConstValHasNoDefaultValue_after.kt")
            public void testNonConstValHasNoDefaultValue_after() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constProperty/nonConstValHasNoDefaultValue_after.kt");
            }

            @Test
            @TestMetadata(value="nonConstValHasNoDefaultValue_before.kt")
            public void testNonConstValHasNoDefaultValue_before() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constProperty/nonConstValHasNoDefaultValue_before.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/conditions")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Conditions {
            @Test
            public void testAllFilesPresentInConditions() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/conditions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="conjunction.kt")
            public void testConjunction() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/conjunction.kt");
            }

            @Test
            @TestMetadata(value="conjunctionInDoWhile.kt")
            public void testConjunctionInDoWhile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/conjunctionInDoWhile.kt");
            }

            @Test
            @TestMetadata(value="conjunctionInWhile.kt")
            public void testConjunctionInWhile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/conjunctionInWhile.kt");
            }

            @Test
            @TestMetadata(value="disjunction.kt")
            public void testDisjunction() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/disjunction.kt");
            }

            @Test
            @TestMetadata(value="negatedConjuction.kt")
            public void testNegatedConjuction() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedConjuction.kt");
            }

            @Test
            @TestMetadata(value="negatedDisjunction.kt")
            public void testNegatedDisjunction() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedDisjunction.kt");
            }

            @Test
            @TestMetadata(value="negatedNonZeroCompareInDoWhile.kt")
            public void testNegatedNonZeroCompareInDoWhile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInDoWhile.kt");
            }

            @Test
            @TestMetadata(value="negatedNonZeroCompareInIf.kt")
            public void testNegatedNonZeroCompareInIf() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInIf.kt");
            }

            @Test
            @TestMetadata(value="negatedNonZeroCompareInWhile.kt")
            public void testNegatedNonZeroCompareInWhile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInWhile.kt");
            }

            @Test
            @TestMetadata(value="negatedNullCompareInDoWhile.kt")
            public void testNegatedNullCompareInDoWhile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInDoWhile.kt");
            }

            @Test
            @TestMetadata(value="negatedNullCompareInIf.kt")
            public void testNegatedNullCompareInIf() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInIf.kt");
            }

            @Test
            @TestMetadata(value="negatedNullCompareInWhile.kt")
            public void testNegatedNullCompareInWhile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInWhile.kt");
            }

            @Test
            @TestMetadata(value="negatedZeroCompareInDoWhile.kt")
            public void testNegatedZeroCompareInDoWhile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInDoWhile.kt");
            }

            @Test
            @TestMetadata(value="negatedZeroCompareInIf.kt")
            public void testNegatedZeroCompareInIf() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInIf.kt");
            }

            @Test
            @TestMetadata(value="negatedZeroCompareInWhile.kt")
            public void testNegatedZeroCompareInWhile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInWhile.kt");
            }

            @Test
            @TestMetadata(value="noBoxingForBoxedEqPrimitive.kt")
            public void testNoBoxingForBoxedEqPrimitive() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForBoxedEqPrimitive.kt");
            }

            @Test
            @TestMetadata(value="noBoxingForPrimitiveEqBoxed.kt")
            public void testNoBoxingForPrimitiveEqBoxed() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForPrimitiveEqBoxed.kt");
            }

            @Test
            @TestMetadata(value="noBoxingForPrimitiveEqObject.kt")
            public void testNoBoxingForPrimitiveEqObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForPrimitiveEqObject.kt");
            }

            @Test
            @TestMetadata(value="nonZeroCompareInDoWhile.kt")
            public void testNonZeroCompareInDoWhile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInDoWhile.kt");
            }

            @Test
            @TestMetadata(value="nonZeroCompareInIf.kt")
            public void testNonZeroCompareInIf() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInIf.kt");
            }

            @Test
            @TestMetadata(value="nonZeroCompareInWhile.kt")
            public void testNonZeroCompareInWhile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInWhile.kt");
            }

            @Test
            @TestMetadata(value="nullCompareConst.kt")
            public void testNullCompareConst() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareConst.kt");
            }

            @Test
            @TestMetadata(value="nullCompareInDoWhile.kt")
            public void testNullCompareInDoWhile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInDoWhile.kt");
            }

            @Test
            @TestMetadata(value="nullCompareInIf.kt")
            public void testNullCompareInIf() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInIf.kt");
            }

            @Test
            @TestMetadata(value="nullCompareInWhile.kt")
            public void testNullCompareInWhile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInWhile.kt");
            }

            @Test
            @TestMetadata(value="zeroCompareInDoWhile.kt")
            public void testZeroCompareInDoWhile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInDoWhile.kt");
            }

            @Test
            @TestMetadata(value="zeroCompareInIf.kt")
            public void testZeroCompareInIf() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInIf.kt");
            }

            @Test
            @TestMetadata(value="zeroCompareInWhile.kt")
            public void testZeroCompareInWhile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInWhile.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/companion")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Companion {
            @Test
            public void testAllFilesPresentInCompanion() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/companion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="directAccessToBackingField.kt")
            public void testDirectAccessToBackingField() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/directAccessToBackingField.kt");
            }

            @Test
            @TestMetadata(value="floatingPointCompanionAccess.kt")
            public void testFloatingPointCompanionAccess() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/floatingPointCompanionAccess.kt");
            }

            @Test
            @TestMetadata(value="inlineFunctionCompanionPropertyAccess.kt")
            public void testInlineFunctionCompanionPropertyAccess() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/inlineFunctionCompanionPropertyAccess.kt");
            }

            @Test
            @TestMetadata(value="inlineFunctionObjectCompanionPropertyAccess.kt")
            public void testInlineFunctionObjectCompanionPropertyAccess() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/inlineFunctionObjectCompanionPropertyAccess.kt");
            }

            @Test
            @TestMetadata(value="kt14258_1.kt")
            public void testKt14258_1() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_1.kt");
            }

            @Test
            @TestMetadata(value="kt14258_2.kt")
            public void testKt14258_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_2.kt");
            }

            @Test
            @TestMetadata(value="kt14258_3.kt")
            public void testKt14258_3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_3.kt");
            }

            @Test
            @TestMetadata(value="kt14258_4.kt")
            public void testKt14258_4() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_4.kt");
            }

            @Test
            @TestMetadata(value="kt14258_5.kt")
            public void testKt14258_5() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_5.kt");
            }

            @Test
            @TestMetadata(value="nonDefaultAccessors.kt")
            public void testNonDefaultAccessors() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/nonDefaultAccessors.kt");
            }

            @Test
            @TestMetadata(value="privateCompanionObjectAccessors_after.kt")
            public void testPrivateCompanionObjectAccessors_after() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/privateCompanionObjectAccessors_after.kt");
            }

            @Test
            @TestMetadata(value="privateCompanionObjectAccessors_before.kt")
            public void testPrivateCompanionObjectAccessors_before() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/privateCompanionObjectAccessors_before.kt");
            }

            @Test
            @TestMetadata(value="protectedCompanionObjectAccessors_after.kt")
            public void testProtectedCompanionObjectAccessors_after() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/protectedCompanionObjectAccessors_after.kt");
            }

            @Test
            @TestMetadata(value="protectedCompanionObjectAccessors_before.kt")
            public void testProtectedCompanionObjectAccessors_before() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/protectedCompanionObjectAccessors_before.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/coercionToUnitOptimization")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CoercionToUnitOptimization {
            @Test
            public void testAllFilesPresentInCoercionToUnitOptimization() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="inRangeCheckWithConst.kt")
            public void testInRangeCheckWithConst() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/inRangeCheckWithConst.kt");
            }

            @Test
            @TestMetadata(value="kt14360.kt")
            public void testKt14360() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/kt14360.kt");
            }

            @Test
            @TestMetadata(value="largeMethodWithCoercionToUnit.kt")
            public void testLargeMethodWithCoercionToUnit() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/largeMethodWithCoercionToUnit.kt");
            }

            @Test
            @TestMetadata(value="nopInlineFuns.kt")
            public void testNopInlineFuns() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/nopInlineFuns.kt");
            }

            @Test
            @TestMetadata(value="returnsUnit.kt")
            public void testReturnsUnit() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/returnsUnit.kt");
            }

            @Test
            @TestMetadata(value="safeCall.kt")
            public void testSafeCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCall.kt");
            }

            @Test
            @TestMetadata(value="safeCallWithReturnValue.kt")
            public void testSafeCallWithReturnValue() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCallWithReturnValue.kt");
            }

            @Test
            @TestMetadata(value="safeLet.kt")
            public void testSafeLet() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeLet.kt");
            }

            @Test
            @TestMetadata(value="tryInlined.kt")
            public void testTryInlined() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/tryInlined.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/checkcast")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Checkcast {
            @Test
            public void testAllFilesPresentInCheckcast() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/checkcast"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt14811.kt")
            public void testKt14811() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt14811.kt");
            }

            @Test
            @TestMetadata(value="kt14963.kt")
            public void testKt14963() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt14963.kt");
            }

            @Test
            @TestMetadata(value="kt15411.kt")
            public void testKt15411() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt15411.kt");
            }

            @Test
            @TestMetadata(value="kt22714.kt")
            public void testKt22714() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt22714.kt");
            }

            @Test
            @TestMetadata(value="kt53465.kt")
            public void testKt53465() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt53465.kt");
            }

            @Test
            @TestMetadata(value="noCheckcastOnDelegatingDefaultImplsCall.kt")
            public void testNoCheckcastOnDelegatingDefaultImplsCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/noCheckcastOnDelegatingDefaultImplsCall.kt");
            }

            @Test
            @TestMetadata(value="noCheckcastOnSuper.kt")
            public void testNoCheckcastOnSuper() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/noCheckcastOnSuper.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/capturedVarsOptimization")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CapturedVarsOptimization {
            @Test
            public void testAllFilesPresentInCapturedVarsOptimization() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/capturedVarsOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="capturedInChainOfInlineFuns.kt")
            public void testCapturedInChainOfInlineFuns() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInChainOfInlineFuns.kt");
            }

            @Test
            @TestMetadata(value="capturedInInlineOnly.kt")
            public void testCapturedInInlineOnly() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInInlineOnly.kt");
            }

            @Test
            @TestMetadata(value="capturedInLocalObject.kt")
            public void testCapturedInLocalObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInLocalObject.kt");
            }

            @Test
            @TestMetadata(value="capturedInNoInlineOnly.kt")
            public void testCapturedInNoInlineOnly() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInNoInlineOnly.kt");
            }

            @Test
            @TestMetadata(value="capturedInNoInlneInsideChainOfInlineFuns.kt")
            public void testCapturedInNoInlneInsideChainOfInlineFuns() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInNoInlneInsideChainOfInlineFuns.kt");
            }

            @Test
            @TestMetadata(value="capturedValInLambdaInitializedInside.kt")
            public void testCapturedValInLambdaInitializedInside() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedValInLambdaInitializedInside.kt");
            }

            @Test
            @TestMetadata(value="capturedValInLambdaInitializedOutside.kt")
            public void testCapturedValInLambdaInitializedOutside() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedValInLambdaInitializedOutside.kt");
            }

            @Test
            @TestMetadata(value="capturedVarsOfSize2.kt")
            public void testCapturedVarsOfSize2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedVarsOfSize2.kt");
            }

            @Test
            @TestMetadata(value="returnValueOfArrayConstructor.kt")
            public void testReturnValueOfArrayConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/returnValueOfArrayConstructor.kt");
            }

            @Test
            @TestMetadata(value="sharedSlotsWithCapturedVars.kt")
            public void testSharedSlotsWithCapturedVars() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/sharedSlotsWithCapturedVars.kt");
            }

            @Test
            @TestMetadata(value="withStackNormalization.kt")
            public void testWithStackNormalization() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/withStackNormalization.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/callableReference")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CallableReference {
            @Test
            public void testAllFilesPresentInCallableReference() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="boundFieldReferenceInInline.kt")
            public void testBoundFieldReferenceInInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/boundFieldReferenceInInline.kt");
            }

            @Test
            @TestMetadata(value="boundFunReferenceInInline.kt")
            public void testBoundFunReferenceInInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/boundFunReferenceInInline.kt");
            }

            @Test
            @TestMetadata(value="boundPropertyReferenceInInline.kt")
            public void testBoundPropertyReferenceInInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/boundPropertyReferenceInInline.kt");
            }

            @Test
            @TestMetadata(value="kt36975.kt")
            public void testKt36975() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/kt36975.kt");
            }

            @Test
            @TestMetadata(value="kt39612.kt")
            public void testKt39612() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/kt39612.kt");
            }

            @Test
            @TestMetadata(value="nameIntrinsicWithImplicitThis.kt")
            public void testNameIntrinsicWithImplicitThis() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/nameIntrinsicWithImplicitThis.kt");
            }

            @Test
            @TestMetadata(value="noMetadata.kt")
            public void testNoMetadata() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/noMetadata.kt");
            }

            @Test
            @TestMetadata(value="unboundFieldReferenceInInline.kt")
            public void testUnboundFieldReferenceInInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundFieldReferenceInInline.kt");
            }

            @Test
            @TestMetadata(value="unboundFunReferenceInInline.kt")
            public void testUnboundFunReferenceInInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundFunReferenceInInline.kt");
            }

            @Test
            @TestMetadata(value="unboundPropertyReferenceInInline.kt")
            public void testUnboundPropertyReferenceInInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundPropertyReferenceInInline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/builtinFunctions")
        @TestDataPath(value="$PROJECT_ROOT")
        public class BuiltinFunctions {
            @Test
            public void testAllFilesPresentInBuiltinFunctions() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="charSequence.kt")
            public void testCharSequence() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/charSequence.kt");
            }

            @Test
            @TestMetadata(value="contains.kt")
            public void testContains() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/contains.kt");
            }

            @Test
            @TestMetadata(value="removeAt.kt")
            public void testRemoveAt() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/removeAt.kt");
            }

            @Test
            @TestMetadata(value="size.kt")
            public void testSize() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/size.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge")
            @TestDataPath(value="$PROJECT_ROOT")
            public class GenericParameterBridge {
                @Test
                @TestMetadata(value="abstractList.kt")
                public void testAbstractList() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/abstractList.kt");
                }

                @Test
                public void testAllFilesPresentInGenericParameterBridge() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="IntMC.kt")
                public void testIntMC() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/IntMC.kt");
                }

                @Test
                @TestMetadata(value="mutableCollection.kt")
                public void testMutableCollection() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableCollection.kt");
                }

                @Test
                @TestMetadata(value="mutableSetInterfaces.kt")
                public void testMutableSetInterfaces() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableSetInterfaces.kt");
                }

                @Test
                @TestMetadata(value="notNullAnyMC.kt")
                public void testNotNullAnyMC() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullAnyMC.kt");
                }

                @Test
                @TestMetadata(value="notNullParamMC.kt")
                public void testNotNullParamMC() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullParamMC.kt");
                }

                @Test
                @TestMetadata(value="nullableAnyMC.kt")
                public void testNullableAnyMC() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/nullableAnyMC.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/boxingOptimization")
        @TestDataPath(value="$PROJECT_ROOT")
        public class BoxingOptimization {
            @Test
            public void testAllFilesPresentInBoxingOptimization() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxingOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="boxingAndEquals.kt")
            public void testBoxingAndEquals() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/boxingAndEquals.kt");
            }

            @Test
            @TestMetadata(value="casts.kt")
            public void testCasts() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/casts.kt");
            }

            @Test
            @TestMetadata(value="checkcastAndInstanceOf.kt")
            public void testCheckcastAndInstanceOf() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/checkcastAndInstanceOf.kt");
            }

            @Test
            @TestMetadata(value="fold.kt")
            public void testFold() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/fold.kt");
            }

            @Test
            @TestMetadata(value="hashCodeOnNonNull.kt")
            public void testHashCodeOnNonNull() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/hashCodeOnNonNull.kt");
            }

            @Test
            @TestMetadata(value="inlineClassesAndInlinedLambda.kt")
            public void testInlineClassesAndInlinedLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/inlineClassesAndInlinedLambda.kt");
            }

            @Test
            @TestMetadata(value="intCompareTo.kt")
            public void testIntCompareTo() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/intCompareTo.kt");
            }

            @Test
            @TestMetadata(value="kClassInAnnotation.kt")
            public void testKClassInAnnotation() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotation.kt");
            }

            @Test
            @TestMetadata(value="kClassInAnnotationEscaping.kt")
            public void testKClassInAnnotationEscaping() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotationEscaping.kt");
            }

            @Test
            @TestMetadata(value="kt15862.kt")
            public void testKt15862() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt15862.kt");
            }

            @Test
            @TestMetadata(value="kt15862_2.kt")
            public void testKt15862_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt15862_2.kt");
            }

            @Test
            @TestMetadata(value="kt6842.kt")
            public void testKt6842() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt6842.kt");
            }

            @Test
            @TestMetadata(value="kt7224.kt")
            public void testKt7224() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt7224.kt");
            }

            @Test
            @TestMetadata(value="maxMinByOrNull.kt")
            public void testMaxMinByOrNull() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/maxMinByOrNull.kt");
            }

            @Test
            @TestMetadata(value="nullCheck.kt")
            public void testNullCheck() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/nullCheck.kt");
            }

            @Test
            @TestMetadata(value="progressions.kt")
            public void testProgressions() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/progressions.kt");
            }

            @Test
            @TestMetadata(value="safeCallToPrimitiveEquality1.kt")
            public void testSafeCallToPrimitiveEquality1() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality1.kt");
            }

            @Test
            @TestMetadata(value="safeCallToPrimitiveEquality2.kt")
            public void testSafeCallToPrimitiveEquality2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality2.kt");
            }

            @Test
            @TestMetadata(value="safeCallToPrimitiveEquality3.kt")
            public void testSafeCallToPrimitiveEquality3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality3.kt");
            }

            @Test
            @TestMetadata(value="safeCallWithElvis.kt")
            public void testSafeCallWithElvis() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallWithElvis.kt");
            }

            @Test
            @TestMetadata(value="safeCallWithElvisMultipleFiles.kt")
            public void testSafeCallWithElvisMultipleFiles() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallWithElvisMultipleFiles.kt");
            }

            @Test
            @TestMetadata(value="severalInlines.kt")
            public void testSeveralInlines() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/severalInlines.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/simple.kt");
            }

            @Test
            @TestMetadata(value="simpleUninitializedMerge.kt")
            public void testSimpleUninitializedMerge() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/simpleUninitializedMerge.kt");
            }

            @Test
            @TestMetadata(value="suspendBoxing.kt")
            public void testSuspendBoxing() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/suspendBoxing.kt");
            }

            @Test
            @TestMetadata(value="unsafeRemoving.kt")
            public void testUnsafeRemoving() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/unsafeRemoving.kt");
            }

            @Test
            @TestMetadata(value="unsignedRangeIteratorSpecialization.kt")
            public void testUnsignedRangeIteratorSpecialization() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/unsignedRangeIteratorSpecialization.kt");
            }

            @Test
            @TestMetadata(value="variableClash.kt")
            public void testVariableClash() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/variableClash.kt");
            }

            @Test
            @TestMetadata(value="variables.kt")
            public void testVariables() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/variables.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/boxing")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Boxing {
            @Test
            public void testAllFilesPresentInBoxing() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="crossinlineSuspend.kt")
            public void testCrossinlineSuspend() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxing/crossinlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspend.kt")
            public void testInlineSuspend() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxing/inlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="suspend.kt")
            public void testSuspend() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxing/suspend.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/assert")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Assert {
            @Test
            public void testAllFilesPresentInAssert() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="jvmCrossinline.kt")
            public void testJvmCrossinline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmCrossinline.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineAssertInLambda.kt")
            public void testJvmCrossinlineAssertInLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmCrossinlineAssertInLambda.kt");
            }

            @Test
            @TestMetadata(value="jvmInline.kt")
            public void testJvmInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmInline.kt");
            }

            @Test
            @TestMetadata(value="jvmInlineLambda.kt")
            public void testJvmInlineLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="jvmNestedClass.kt")
            public void testJvmNestedClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmNestedClass.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/argumentOrder")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ArgumentOrder {
            @Test
            public void testAllFilesPresentInArgumentOrder() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="sameOrder.kt")
            public void testSameOrder() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrder.kt");
            }

            @Test
            @TestMetadata(value="sameOrderWithDefault.kt")
            public void testSameOrderWithDefault() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrderWithDefault.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/boxModernJdk")
    @TestDataPath(value="$PROJECT_ROOT")
    public class BoxModernJdk {
        @Test
        public void testAllFilesPresentInBoxModernJdk() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava21")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TestsWithJava21 {
            @Test
            @TestMetadata(value="addRemoveOnMutableList.kt")
            public void testAddRemoveOnMutableList() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava21/addRemoveOnMutableList.kt");
            }

            @Test
            public void testAllFilesPresentInTestsWithJava21() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava21"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }
        }

        @Nested
        @Tag(value="<modernJava>")
        @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TestsWithJava17 {
            @Test
            public void testAllFilesPresentInTestsWithJava17() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Sealed {
                @Test
                public void testAllFilesPresentInSealed() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="compiledJavaSealedClass.kt")
                public void testCompiledJavaSealedClass() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/compiledJavaSealedClass.kt");
                }

                @Test
                @TestMetadata(value="compiledJavaSealedInterface.kt")
                public void testCompiledJavaSealedInterface() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/compiledJavaSealedInterface.kt");
                }

                @Test
                @TestMetadata(value="javaExhaustiveWhenOnKotlinSealedClass.kt")
                public void testJavaExhaustiveWhenOnKotlinSealedClass() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/javaExhaustiveWhenOnKotlinSealedClass.kt");
                }

                @Test
                @TestMetadata(value="javaRecordsViaKotlinReflection.kt")
                public void testJavaRecordsViaKotlinReflection() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/javaRecordsViaKotlinReflection.kt");
                }

                @Test
                @TestMetadata(value="javaSealedClass.kt")
                public void testJavaSealedClass() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/javaSealedClass.kt");
                }

                @Test
                @TestMetadata(value="javaSealedInterface.kt")
                public void testJavaSealedInterface() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/javaSealedInterface.kt");
                }

                @Test
                @TestMetadata(value="kotlinExhaustiveWhenOnJavaSealedClass.kt")
                public void testKotlinExhaustiveWhenOnJavaSealedClass() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/kotlinExhaustiveWhenOnJavaSealedClass.kt");
                }

                @Test
                @TestMetadata(value="permittedSubclassesOfSealedKotlinClass.kt")
                public void testPermittedSubclassesOfSealedKotlinClass() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/permittedSubclassesOfSealedKotlinClass.kt");
                }

                @Test
                @TestMetadata(value="sealedJavaClassViaJavaReflection.kt")
                public void testSealedJavaClassViaJavaReflection() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/sealedJavaClassViaJavaReflection.kt");
                }

                @Test
                @TestMetadata(value="sealedJavaClassViaKotlinReflection.kt")
                public void testSealedJavaClassViaKotlinReflection() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/sealedJavaClassViaKotlinReflection.kt");
                }

                @Test
                @TestMetadata(value="sealedJavaInterfaceViaKotlinReflection.kt")
                public void testSealedJavaInterfaceViaKotlinReflection() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/sealedJavaInterfaceViaKotlinReflection.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ReleaseFlag {
                @Test
                public void testAllFilesPresentInReleaseFlag() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava")
                @TestDataPath(value="$PROJECT_ROOT")
                public class WithJava {
                    @Test
                    public void testAllFilesPresentInWithJava() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="withJava_10.kt")
                    public void testWithJava_10() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_10.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_11.kt")
                    public void testWithJava_11() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_11.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_12.kt")
                    public void testWithJava_12() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_12.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_13.kt")
                    public void testWithJava_13() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_13.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_14.kt")
                    public void testWithJava_14() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_14.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_15.kt")
                    public void testWithJava_15() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_15.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_16.kt")
                    public void testWithJava_16() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_16.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_17.kt")
                    public void testWithJava_17() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_17.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_8.kt")
                    public void testWithJava_8() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_8.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_9.kt")
                    public void testWithJava_9() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_9.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass")
                @TestDataPath(value="$PROJECT_ROOT")
                public class InnerClass {
                    @Test
                    public void testAllFilesPresentInInnerClass() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="threadState_10.kt")
                    public void testThreadState_10() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_10.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_11.kt")
                    public void testThreadState_11() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_11.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_12.kt")
                    public void testThreadState_12() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_12.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_13.kt")
                    public void testThreadState_13() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_13.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_14.kt")
                    public void testThreadState_14() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_14.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_15.kt")
                    public void testThreadState_15() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_15.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_16.kt")
                    public void testThreadState_16() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_16.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_17.kt")
                    public void testThreadState_17() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_17.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_8.kt")
                    public void testThreadState_8() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_8.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_9.kt")
                    public void testThreadState_9() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_9.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable")
                @TestDataPath(value="$PROJECT_ROOT")
                public class Constable {
                    @Test
                    public void testAllFilesPresentInConstable() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="constable.kt")
                    public void testConstable() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_10.kt")
                    public void testConstable_10() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_10.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_11.kt")
                    public void testConstable_11() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_11.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_12.kt")
                    public void testConstable_12() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_12.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_13.kt")
                    public void testConstable_13() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_13.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_14.kt")
                    public void testConstable_14() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_14.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_15.kt")
                    public void testConstable_15() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_15.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_16.kt")
                    public void testConstable_16() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_16.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_17.kt")
                    public void testConstable_17() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_17.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_8.kt")
                    public void testConstable_8() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_8.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_9.kt")
                    public void testConstable_9() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_9.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer")
                @TestDataPath(value="$PROJECT_ROOT")
                public class ByteBuffer {
                    @Test
                    public void testAllFilesPresentInByteBuffer() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="byteBuffer.kt")
                    public void testByteBuffer() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_10.kt")
                    public void testByteBuffer_10() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_10.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_11.kt")
                    public void testByteBuffer_11() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_11.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_12.kt")
                    public void testByteBuffer_12() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_12.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_13.kt")
                    public void testByteBuffer_13() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_13.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_14.kt")
                    public void testByteBuffer_14() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_14.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_15.kt")
                    public void testByteBuffer_15() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_15.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_16.kt")
                    public void testByteBuffer_16() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_16.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_17.kt")
                    public void testByteBuffer_17() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_17.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_8.kt")
                    public void testByteBuffer_8() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_8.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_9.kt")
                    public void testByteBuffer_9() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_9.kt");
                    }
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17/records")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Records {
                @Test
                public void testAllFilesPresentInRecords() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/records"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="binaryRecord.kt")
                public void testBinaryRecord() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/binaryRecord.kt");
                }

                @Test
                @TestMetadata(value="bytecodeShapeForJava.kt")
                public void testBytecodeShapeForJava() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/bytecodeShapeForJava.kt");
                }

                @Test
                @TestMetadata(value="callableReferenceToGenericRecord.kt")
                public void testCallableReferenceToGenericRecord() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/callableReferenceToGenericRecord.kt");
                }

                @Test
                @TestMetadata(value="collectionSizeOverrides.kt")
                public void testCollectionSizeOverrides() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/collectionSizeOverrides.kt");
                }

                @Test
                @TestMetadata(value="dataJvmRecord.kt")
                public void testDataJvmRecord() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/dataJvmRecord.kt");
                }

                @Test
                @TestMetadata(value="jvmRecordBinary.kt")
                public void testJvmRecordBinary() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/jvmRecordBinary.kt");
                }

                @Test
                @TestMetadata(value="kt54573.kt")
                public void testKt54573() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/kt54573.kt");
                }

                @Test
                @TestMetadata(value="propertiesOverrides.kt")
                public void testPropertiesOverrides() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/propertiesOverrides.kt");
                }

                @Test
                @TestMetadata(value="propertiesOverridesAllCompatibilityJvmDefault.kt")
                public void testPropertiesOverridesAllCompatibilityJvmDefault() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/propertiesOverridesAllCompatibilityJvmDefault.kt");
                }

                @Test
                @TestMetadata(value="propertiesOverridesAllJvmDefault.kt")
                public void testPropertiesOverridesAllJvmDefault() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/propertiesOverridesAllJvmDefault.kt");
                }

                @Test
                @TestMetadata(value="recordDifferentPropertyOverride.kt")
                public void testRecordDifferentPropertyOverride() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/recordDifferentPropertyOverride.kt");
                }

                @Test
                @TestMetadata(value="recordDifferentSyntheticProperty.kt")
                public void testRecordDifferentSyntheticProperty() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/recordDifferentSyntheticProperty.kt");
                }

                @Test
                @TestMetadata(value="recordPropertyAccess.kt")
                public void testRecordPropertyAccess() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/recordPropertyAccess.kt");
                }

                @Test
                @TestMetadata(value="recordWithCompanion.kt")
                public void testRecordWithCompanion() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/recordWithCompanion.kt");
                }
            }
        }

        @Nested
        @Tag(value="<modernJava>")
        @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava11")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TestsWithJava11 {
            @Test
            public void testAllFilesPresentInTestsWithJava11() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="concatDynamic.kt")
            public void testConcatDynamic() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic199Long.kt")
            public void testConcatDynamic199Long() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic199Long.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic200.kt")
            public void testConcatDynamic200() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic200.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic200Long.kt")
            public void testConcatDynamic200Long() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic200Long.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic201.kt")
            public void testConcatDynamic201() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic201.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicIndy199Long.kt")
            public void testConcatDynamicIndy199Long() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicIndy199Long.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicIndy200.kt")
            public void testConcatDynamicIndy200() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicIndy200.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicIndy200Long.kt")
            public void testConcatDynamicIndy200Long() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicIndy200Long.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicIndy201.kt")
            public void testConcatDynamicIndy201() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicIndy201.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicInlineClasses.kt")
            public void testConcatDynamicInlineClasses() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicInlineClasses.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicSpecialSymbols.kt")
            public void testConcatDynamicSpecialSymbols() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicSpecialSymbols.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicWithInline.kt")
            public void testConcatDynamicWithInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicWithInline.kt");
            }

            @Test
            @TestMetadata(value="kt36984.kt")
            public void testKt36984() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt36984.kt");
            }

            @Test
            @TestMetadata(value="kt47917.kt")
            public void testKt47917() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt47917.kt");
            }

            @Test
            @TestMetadata(value="kt47917_oldBackend.kt")
            public void testKt47917_oldBackend() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt47917_oldBackend.kt");
            }

            @Test
            @TestMetadata(value="kt47917_russian.kt")
            public void testKt47917_russian() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt47917_russian.kt");
            }

            @Test
            @TestMetadata(value="kt47917_surrogatePairs.kt")
            public void testKt47917_surrogatePairs() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt47917_surrogatePairs.kt");
            }

            @Test
            @TestMetadata(value="varHandle.kt")
            public void testVarHandle() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/varHandle.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ReleaseFlag {
                @Test
                public void testAllFilesPresentInReleaseFlag() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava")
                @TestDataPath(value="$PROJECT_ROOT")
                public class WithJava {
                    @Test
                    public void testAllFilesPresentInWithJava() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="withJava_10.kt")
                    public void testWithJava_10() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_10.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_11.kt")
                    public void testWithJava_11() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_11.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_6.kt")
                    public void testWithJava_6() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_6.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_8.kt")
                    public void testWithJava_8() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_8.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_9.kt")
                    public void testWithJava_9() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_9.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective")
                @TestDataPath(value="$PROJECT_ROOT")
                public class Reflective {
                    @Test
                    public void testAllFilesPresentInReflective() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="reflective.kt")
                    public void testReflective() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective.kt");
                    }

                    @Test
                    @TestMetadata(value="reflective_10.kt")
                    public void testReflective_10() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_10.kt");
                    }

                    @Test
                    @TestMetadata(value="reflective_11.kt")
                    public void testReflective_11() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_11.kt");
                    }

                    @Test
                    @TestMetadata(value="reflective_6.kt")
                    public void testReflective_6() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_6.kt");
                    }

                    @Test
                    @TestMetadata(value="reflective_8.kt")
                    public void testReflective_8() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_8.kt");
                    }

                    @Test
                    @TestMetadata(value="reflective_9.kt")
                    public void testReflective_9() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_9.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass")
                @TestDataPath(value="$PROJECT_ROOT")
                public class InnerClass {
                    @Test
                    public void testAllFilesPresentInInnerClass() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="threadState_10.kt")
                    public void testThreadState_10() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass/threadState_10.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_11.kt")
                    public void testThreadState_11() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass/threadState_11.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_8.kt")
                    public void testThreadState_8() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass/threadState_8.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_9.kt")
                    public void testThreadState_9() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass/threadState_9.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer")
                @TestDataPath(value="$PROJECT_ROOT")
                public class ByteBuffer {
                    @Test
                    public void testAllFilesPresentInByteBuffer() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="byteBuffer.kt")
                    public void testByteBuffer() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_10.kt")
                    public void testByteBuffer_10() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_10.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_11.kt")
                    public void testByteBuffer_11() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_11.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_6.kt")
                    public void testByteBuffer_6() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_6.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_8.kt")
                    public void testByteBuffer_8() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_8.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_9.kt")
                    public void testByteBuffer_9() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_9.kt");
                    }
                }
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/boxInline")
    @TestDataPath(value="$PROJECT_ROOT")
    public class BoxInline {
        @Test
        public void testAllFilesPresentInBoxInline() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/varargs")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Varargs {
            @Test
            public void testAllFilesPresentInVarargs() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/varargs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt17653.kt")
            public void testKt17653() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/varargs/kt17653.kt");
            }

            @Test
            @TestMetadata(value="varargAndDefaultParameters.kt")
            public void testVarargAndDefaultParameters() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/varargs/varargAndDefaultParameters.kt");
            }

            @Test
            @TestMetadata(value="varargAndDefaultParameters2.kt")
            public void testVarargAndDefaultParameters2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/varargs/varargAndDefaultParameters2.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/typeParameters")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TypeParameters {
            @Test
            public void testAllFilesPresentInTypeParameters() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/typeParameters"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="anonymousObject.kt")
            public void testAnonymousObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/anonymousObject.kt");
            }

            @Test
            @TestMetadata(value="basic.kt")
            public void testBasic() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/basic.kt");
            }

            @Test
            @TestMetadata(value="projectionTypeArguments.kt")
            public void testProjectionTypeArguments() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/projectionTypeArguments.kt");
            }

            @Test
            @TestMetadata(value="severalUpperBounds.kt")
            public void testSeveralUpperBounds() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/severalUpperBounds.kt");
            }

            @Test
            @TestMetadata(value="typeArgFromGenericBaseClass.kt")
            public void testTypeArgFromGenericBaseClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/typeArgFromGenericBaseClass.kt");
            }

            @Test
            @TestMetadata(value="uncheckedCastToNothing.kt")
            public void testUncheckedCastToNothing() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/uncheckedCastToNothing.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/tryCatchFinally")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TryCatchFinally {
            @Test
            public void testAllFilesPresentInTryCatchFinally() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/tryCatchFinally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt5863.kt")
            public void testKt5863() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/tryCatchFinally/kt5863.kt");
            }

            @Test
            @TestMetadata(value="tryCatch.kt")
            public void testTryCatch() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatch.kt");
            }

            @Test
            @TestMetadata(value="tryCatch2.kt")
            public void testTryCatch2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatch2.kt");
            }

            @Test
            @TestMetadata(value="tryCatchFinally.kt")
            public void testTryCatchFinally() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatchFinally.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/trait")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Trait {
            @Test
            public void testAllFilesPresentInTrait() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/trait"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="trait.kt")
            public void testTrait() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/trait/trait.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/syntheticAccessors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class SyntheticAccessors {
            @Test
            public void testAllFilesPresentInSyntheticAccessors() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/syntheticAccessors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="constField.kt")
            public void testConstField() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/constField.kt");
            }

            @Test
            @TestMetadata(value="packagePrivateMembers.kt")
            public void testPackagePrivateMembers() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/packagePrivateMembers.kt");
            }

            @Test
            @TestMetadata(value="propertyModifiers.kt")
            public void testPropertyModifiers() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/propertyModifiers.kt");
            }

            @Test
            @TestMetadata(value="protectedMembers.kt")
            public void testProtectedMembers() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/protectedMembers.kt");
            }

            @Test
            @TestMetadata(value="protectedMembersFromSuper.kt")
            public void testProtectedMembersFromSuper() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/protectedMembersFromSuper.kt");
            }

            @Test
            @TestMetadata(value="superCall.kt")
            public void testSuperCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superCall.kt");
            }

            @Test
            @TestMetadata(value="superCallFromMultipleSubclasses.kt")
            public void testSuperCallFromMultipleSubclasses() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superCallFromMultipleSubclasses.kt");
            }

            @Test
            @TestMetadata(value="superProperty.kt")
            public void testSuperProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superProperty.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda")
            @TestDataPath(value="$PROJECT_ROOT")
            public class WithinInlineLambda {
                @Test
                public void testAllFilesPresentInWithinInlineLambda() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="directFieldAccess.kt")
                public void testDirectFieldAccess() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/directFieldAccess.kt");
                }

                @Test
                @TestMetadata(value="directFieldAccessInCrossInline.kt")
                public void testDirectFieldAccessInCrossInline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/directFieldAccessInCrossInline.kt");
                }

                @Test
                @TestMetadata(value="privateCall.kt")
                public void testPrivateCall() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateCall.kt");
                }

                @Test
                @TestMetadata(value="privateInCrossInline.kt")
                public void testPrivateInCrossInline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateInCrossInline.kt");
                }

                @Test
                @TestMetadata(value="privateInDefaultStubArgument.kt")
                public void testPrivateInDefaultStubArgument() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateInDefaultStubArgument.kt");
                }

                @Test
                @TestMetadata(value="protectedInCrossinline.kt")
                public void testProtectedInCrossinline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/protectedInCrossinline.kt");
                }

                @Test
                @TestMetadata(value="protectedMembersFromSuper.kt")
                public void testProtectedMembersFromSuper() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/protectedMembersFromSuper.kt");
                }

                @Test
                @TestMetadata(value="superCall.kt")
                public void testSuperCall() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/superCall.kt");
                }

                @Test
                @TestMetadata(value="superInCrossInline.kt")
                public void testSuperInCrossInline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/superInCrossInline.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/suspend")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Suspend {
            @Test
            public void testAllFilesPresentInSuspend() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="capturedVariables.kt")
            public void testCapturedVariables() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/capturedVariables.kt");
            }

            @Test
            @TestMetadata(value="crossinlineSuspendLambdaInsideCrossinlineSuspendLambda.kt")
            public void testCrossinlineSuspendLambdaInsideCrossinlineSuspendLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/crossinlineSuspendLambdaInsideCrossinlineSuspendLambda.kt");
            }

            @Test
            @TestMetadata(value="debugMetadataCrossinline.kt")
            public void testDebugMetadataCrossinline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/debugMetadataCrossinline.kt");
            }

            @Test
            @TestMetadata(value="delegatedProperties.kt")
            public void testDelegatedProperties() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/delegatedProperties.kt");
            }

            @Test
            @TestMetadata(value="doubleRegenerationWithNonSuspendingLambda.kt")
            public void testDoubleRegenerationWithNonSuspendingLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/doubleRegenerationWithNonSuspendingLambda.kt");
            }

            @Test
            @TestMetadata(value="enclodingMethod.kt")
            public void testEnclodingMethod() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/enclodingMethod.kt");
            }

            @Test
            @TestMetadata(value="fileNameInMetadata.kt")
            public void testFileNameInMetadata() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/fileNameInMetadata.kt");
            }

            @Test
            @TestMetadata(value="inlineOrdinaryOfCrossinlineSuspend.kt")
            public void testInlineOrdinaryOfCrossinlineSuspend() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineOrdinaryOfCrossinlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="inlineOrdinaryOfNoinlineSuspend.kt")
            public void testInlineOrdinaryOfNoinlineSuspend() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineOrdinaryOfNoinlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="inlinePassthrough.kt")
            public void testInlinePassthrough() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlinePassthrough.kt");
            }

            @Test
            @TestMetadata(value="inlinePassthroughWithSuspendConversion.kt")
            public void testInlinePassthroughWithSuspendConversion() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlinePassthroughWithSuspendConversion.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendContinuation.kt")
            public void testInlineSuspendContinuation() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendContinuation.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendInMultifileClass.kt")
            public void testInlineSuspendInMultifileClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendInMultifileClass.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfCrossinlineOrdinary.kt")
            public void testInlineSuspendOfCrossinlineOrdinary() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfCrossinlineOrdinary.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfCrossinlineSuspend.kt")
            public void testInlineSuspendOfCrossinlineSuspend() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfCrossinlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfNoinlineOrdinary.kt")
            public void testInlineSuspendOfNoinlineOrdinary() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfNoinlineOrdinary.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfNoinlineSuspend.kt")
            public void testInlineSuspendOfNoinlineSuspend() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfNoinlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfOrdinary.kt")
            public void testInlineSuspendOfOrdinary() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfOrdinary.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfSuspend.kt")
            public void testInlineSuspendOfSuspend() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfSuspend.kt");
            }

            @Test
            @TestMetadata(value="jvmName.kt")
            public void testJvmName() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/jvmName.kt");
            }

            @Test
            @TestMetadata(value="kt26658.kt")
            public void testKt26658() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/kt26658.kt");
            }

            @Test
            @TestMetadata(value="kt52198.kt")
            public void testKt52198() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/kt52198.kt");
            }

            @Test
            @TestMetadata(value="maxStackWithCrossinline.kt")
            public void testMaxStackWithCrossinline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/maxStackWithCrossinline.kt");
            }

            @Test
            @TestMetadata(value="multipleLocals.kt")
            public void testMultipleLocals() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/multipleLocals.kt");
            }

            @Test
            @TestMetadata(value="multipleSuspensionPoints.kt")
            public void testMultipleSuspensionPoints() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/multipleSuspensionPoints.kt");
            }

            @Test
            @TestMetadata(value="nestedMethodWith2XParameter.kt")
            public void testNestedMethodWith2XParameter() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/nestedMethodWith2XParameter.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn.kt")
            public void testNonLocalReturn() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/nonLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="nonSuspendCrossinline.kt")
            public void testNonSuspendCrossinline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/nonSuspendCrossinline.kt");
            }

            @Test
            @TestMetadata(value="returnValue.kt")
            public void testReturnValue() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/returnValue.kt");
            }

            @Test
            @TestMetadata(value="tryCatchReceiver.kt")
            public void testTryCatchReceiver() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/tryCatchReceiver.kt");
            }

            @Test
            @TestMetadata(value="tryCatchStackTransform.kt")
            public void testTryCatchStackTransform() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/tryCatchStackTransform.kt");
            }

            @Test
            @TestMetadata(value="twiceRegeneratedAnonymousObject.kt")
            public void testTwiceRegeneratedAnonymousObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/twiceRegeneratedAnonymousObject.kt");
            }

            @Test
            @TestMetadata(value="twiceRegeneratedSuspendLambda.kt")
            public void testTwiceRegeneratedSuspendLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/twiceRegeneratedSuspendLambda.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/stateMachine")
            @TestDataPath(value="$PROJECT_ROOT")
            public class StateMachine {
                @Test
                public void testAllFilesPresentInStateMachine() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/stateMachine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="crossingCoroutineBoundaries.kt")
                public void testCrossingCoroutineBoundaries() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/crossingCoroutineBoundaries.kt");
                }

                @Test
                @TestMetadata(value="independentInline.kt")
                public void testIndependentInline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/independentInline.kt");
                }

                @Test
                @TestMetadata(value="innerLambda.kt")
                public void testInnerLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambda.kt");
                }

                @Test
                @TestMetadata(value="innerLambdaInsideLambda.kt")
                public void testInnerLambdaInsideLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambdaInsideLambda.kt");
                }

                @Test
                @TestMetadata(value="innerLambdaWithoutCrossinline.kt")
                public void testInnerLambdaWithoutCrossinline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambdaWithoutCrossinline.kt");
                }

                @Test
                @TestMetadata(value="innerMadness.kt")
                public void testInnerMadness() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerMadness.kt");
                }

                @Test
                @TestMetadata(value="innerMadnessCallSite.kt")
                public void testInnerMadnessCallSite() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerMadnessCallSite.kt");
                }

                @Test
                @TestMetadata(value="innerObject.kt")
                public void testInnerObject() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObject.kt");
                }

                @Test
                @TestMetadata(value="innerObjectInsideInnerObject.kt")
                public void testInnerObjectInsideInnerObject() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectInsideInnerObject.kt");
                }

                @Test
                @TestMetadata(value="innerObjectRetransformation.kt")
                public void testInnerObjectRetransformation() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectRetransformation.kt");
                }

                @Test
                @TestMetadata(value="innerObjectSeveralFunctions.kt")
                public void testInnerObjectSeveralFunctions() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectSeveralFunctions.kt");
                }

                @Test
                @TestMetadata(value="innerObjectWithoutCapturingCrossinline.kt")
                public void testInnerObjectWithoutCapturingCrossinline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectWithoutCapturingCrossinline.kt");
                }

                @Test
                @TestMetadata(value="insideObject.kt")
                public void testInsideObject() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/insideObject.kt");
                }

                @Test
                @TestMetadata(value="kt30708.kt")
                public void testKt30708() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/kt30708.kt");
                }

                @Test
                @TestMetadata(value="lambdaTransformation.kt")
                public void testLambdaTransformation() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/lambdaTransformation.kt");
                }

                @Test
                @TestMetadata(value="normalInline.kt")
                public void testNormalInline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/normalInline.kt");
                }

                @Test
                @TestMetadata(value="numberOfSuspentions.kt")
                public void testNumberOfSuspentions() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/numberOfSuspentions.kt");
                }

                @Test
                @TestMetadata(value="objectInsideLambdas.kt")
                public void testObjectInsideLambdas() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/objectInsideLambdas.kt");
                }

                @Test
                @TestMetadata(value="oneInlineTwoCaptures.kt")
                public void testOneInlineTwoCaptures() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/oneInlineTwoCaptures.kt");
                }

                @Test
                @TestMetadata(value="passLambda.kt")
                public void testPassLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passLambda.kt");
                }

                @Test
                @TestMetadata(value="passParameter.kt")
                public void testPassParameter() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passParameter.kt");
                }

                @Test
                @TestMetadata(value="passParameterLambda.kt")
                public void testPassParameterLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passParameterLambda.kt");
                }

                @Test
                @TestMetadata(value="unreachableSuspendMarker.kt")
                public void testUnreachableSuspendMarker() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/unreachableSuspendMarker.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/receiver")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Receiver {
                @Test
                public void testAllFilesPresentInReceiver() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/receiver"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineOrdinaryOfCrossinlineSuspend.kt")
                public void testInlineOrdinaryOfCrossinlineSuspend() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineOrdinaryOfCrossinlineSuspend.kt");
                }

                @Test
                @TestMetadata(value="inlineOrdinaryOfNoinlineSuspend.kt")
                public void testInlineOrdinaryOfNoinlineSuspend() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineOrdinaryOfNoinlineSuspend.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfCrossinlineOrdinary.kt")
                public void testInlineSuspendOfCrossinlineOrdinary() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfCrossinlineOrdinary.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfCrossinlineSuspend.kt")
                public void testInlineSuspendOfCrossinlineSuspend() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfCrossinlineSuspend.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfNoinlineOrdinary.kt")
                public void testInlineSuspendOfNoinlineOrdinary() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfNoinlineOrdinary.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfNoinlineSuspend.kt")
                public void testInlineSuspendOfNoinlineSuspend() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfNoinlineSuspend.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfOrdinary.kt")
                public void testInlineSuspendOfOrdinary() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfOrdinary.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfSuspend.kt")
                public void testInlineSuspendOfSuspend() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfSuspend.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineUsedAsNoinline {
                @Test
                public void testAllFilesPresentInInlineUsedAsNoinline() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineOnly.kt")
                public void testInlineOnly() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/inlineOnly.kt");
                }

                @Test
                @TestMetadata(value="simpleNamed.kt")
                public void testSimpleNamed() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/simpleNamed.kt");
                }

                @Test
                @TestMetadata(value="withCapturedInlineLambda.kt")
                public void testWithCapturedInlineLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/withCapturedInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="withCapturedInlineLambda2.kt")
                public void testWithCapturedInlineLambda2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/withCapturedInlineLambda2.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/inlineClass")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineClass {
                @Test
                public void testAllFilesPresentInInlineClass() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/inlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="returnBoxedFromLambda.kt")
                public void testReturnBoxedFromLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnBoxedFromLambda.kt");
                }

                @Test
                @TestMetadata(value="returnUnboxedDirect.kt")
                public void testReturnUnboxedDirect() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedDirect.kt");
                }

                @Test
                @TestMetadata(value="returnUnboxedFromLambda.kt")
                public void testReturnUnboxedFromLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedFromLambda.kt");
                }

                @Test
                @TestMetadata(value="returnUnboxedResume.kt")
                public void testReturnUnboxedResume() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedResume.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/defaultParameter")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DefaultParameter {
                @Test
                public void testAllFilesPresentInDefaultParameter() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/defaultParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="defaultInlineLambda.kt")
                public void testDefaultInlineLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="defaultInlineReference.kt")
                public void testDefaultInlineReference() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultInlineReference.kt");
                }

                @Test
                @TestMetadata(value="defaultValueCrossinline.kt")
                public void testDefaultValueCrossinline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueCrossinline.kt");
                }

                @Test
                @TestMetadata(value="defaultValueInClass.kt")
                public void testDefaultValueInClass() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInClass.kt");
                }

                @Test
                @TestMetadata(value="defaultValueInline.kt")
                public void testDefaultValueInline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInline.kt");
                }

                @Test
                @TestMetadata(value="defaultValueInlineFromMultiFileFacade.kt")
                public void testDefaultValueInlineFromMultiFileFacade() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInlineFromMultiFileFacade.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/callableReference")
            @TestDataPath(value="$PROJECT_ROOT")
            public class CallableReference {
                @Test
                public void testAllFilesPresentInCallableReference() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="isAsReified.kt")
                public void testIsAsReified() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/isAsReified.kt");
                }

                @Test
                @TestMetadata(value="isAsReified2.kt")
                public void testIsAsReified2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/isAsReified2.kt");
                }

                @Test
                @TestMetadata(value="nonTailCall.kt")
                public void testNonTailCall() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/nonTailCall.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/simple.kt");
                }

                @Test
                @TestMetadata(value="unitReturn.kt")
                public void testUnitReturn() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/unitReturn.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/stackOnReturn")
        @TestDataPath(value="$PROJECT_ROOT")
        public class StackOnReturn {
            @Test
            public void testAllFilesPresentInStackOnReturn() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/stackOnReturn"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="elvis.kt")
            public void testElvis() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/elvis.kt");
            }

            @Test
            @TestMetadata(value="ifThenElse.kt")
            public void testIfThenElse() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/ifThenElse.kt");
            }

            @Test
            @TestMetadata(value="kt11499.kt")
            public void testKt11499() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt11499.kt");
            }

            @Test
            @TestMetadata(value="kt17591.kt")
            public void testKt17591() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591.kt");
            }

            @Test
            @TestMetadata(value="kt17591a.kt")
            public void testKt17591a() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591a.kt");
            }

            @Test
            @TestMetadata(value="kt17591b.kt")
            public void testKt17591b() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591b.kt");
            }

            @Test
            @TestMetadata(value="mixedTypesOnStack1.kt")
            public void testMixedTypesOnStack1() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack1.kt");
            }

            @Test
            @TestMetadata(value="mixedTypesOnStack2.kt")
            public void testMixedTypesOnStack2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack2.kt");
            }

            @Test
            @TestMetadata(value="mixedTypesOnStack3.kt")
            public void testMixedTypesOnStack3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack3.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn1.kt")
            public void testNonLocalReturn1() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn1.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn2.kt")
            public void testNonLocalReturn2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn2.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn3.kt")
            public void testNonLocalReturn3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn3.kt");
            }

            @Test
            @TestMetadata(value="poppedLocalReturn.kt")
            public void testPoppedLocalReturn() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/poppedLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="poppedLocalReturn2.kt")
            public void testPoppedLocalReturn2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/poppedLocalReturn2.kt");
            }

            @Test
            @TestMetadata(value="returnLong.kt")
            public void testReturnLong() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/returnLong.kt");
            }

            @Test
            @TestMetadata(value="tryFinally.kt")
            public void testTryFinally() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/tryFinally.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/special")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Special {
            @Test
            public void testAllFilesPresentInSpecial() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/special"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="blockReturnsNullableUnit.kt")
            public void testBlockReturnsNullableUnit() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/blockReturnsNullableUnit.kt");
            }

            @Test
            @TestMetadata(value="identityCheck.kt")
            public void testIdentityCheck() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/identityCheck.kt");
            }

            @Test
            @TestMetadata(value="ifBranches.kt")
            public void testIfBranches() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/ifBranches.kt");
            }

            @Test
            @TestMetadata(value="iinc.kt")
            public void testIinc() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/iinc.kt");
            }

            @Test
            @TestMetadata(value="inlineChain.kt")
            public void testInlineChain() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/inlineChain.kt");
            }

            @Test
            @TestMetadata(value="loopInStoreLoadChains.kt")
            public void testLoopInStoreLoadChains() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/loopInStoreLoadChains.kt");
            }

            @Test
            @TestMetadata(value="loopInStoreLoadChains2.kt")
            public void testLoopInStoreLoadChains2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/loopInStoreLoadChains2.kt");
            }

            @Test
            @TestMetadata(value="monitorEnterExit.kt")
            public void testMonitorEnterExit() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/monitorEnterExit.kt");
            }

            @Test
            @TestMetadata(value="plusAssign.kt")
            public void testPlusAssign() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/plusAssign.kt");
            }

            @Test
            @TestMetadata(value="stackHeightBug.kt")
            public void testStackHeightBug() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/stackHeightBug.kt");
            }

            @Test
            @TestMetadata(value="unusedInlineLambda.kt")
            public void testUnusedInlineLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/unusedInlineLambda.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/smap")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Smap {
            @Test
            public void testAllFilesPresentInSmap() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="assertion.kt")
            public void testAssertion() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/assertion.kt");
            }

            @Test
            @TestMetadata(value="classCycle.kt")
            public void testClassCycle() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/classCycle.kt");
            }

            @Test
            @TestMetadata(value="classFromDefaultPackage.kt")
            public void testClassFromDefaultPackage() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/classFromDefaultPackage.kt");
            }

            @Test
            @TestMetadata(value="coroutinesWithTailCallOtpimization.kt")
            public void testCoroutinesWithTailCallOtpimization() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/coroutinesWithTailCallOtpimization.kt");
            }

            @Test
            @TestMetadata(value="crossroutines.kt")
            public void testCrossroutines() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/crossroutines.kt");
            }

            @Test
            @TestMetadata(value="defaultFunction.kt")
            public void testDefaultFunction() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultFunction.kt");
            }

            @Test
            @TestMetadata(value="defaultFunctionWithInlineCall.kt")
            public void testDefaultFunctionWithInlineCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultFunctionWithInlineCall.kt");
            }

            @Test
            @TestMetadata(value="forInline.kt")
            public void testForInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/forInline.kt");
            }

            @Test
            @TestMetadata(value="inlineProperty.kt")
            public void testInlineProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineProperty.kt");
            }

            @Test
            @TestMetadata(value="interleavedFiles.kt")
            public void testInterleavedFiles() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/interleavedFiles.kt");
            }

            @Test
            @TestMetadata(value="kt23369.kt")
            public void testKt23369() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/kt23369.kt");
            }

            @Test
            @TestMetadata(value="kt23369_2.kt")
            public void testKt23369_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/kt23369_2.kt");
            }

            @Test
            @TestMetadata(value="kt23369_3.kt")
            public void testKt23369_3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/kt23369_3.kt");
            }

            @Test
            @TestMetadata(value="kt35006.kt")
            public void testKt35006() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/kt35006.kt");
            }

            @Test
            @TestMetadata(value="multiFileFacade.kt")
            public void testMultiFileFacade() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/multiFileFacade.kt");
            }

            @Test
            @TestMetadata(value="oneFile.kt")
            public void testOneFile() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/oneFile.kt");
            }

            @Test
            @TestMetadata(value="rangeFolding.kt")
            public void testRangeFolding() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/rangeFolding.kt");
            }

            @Test
            @TestMetadata(value="rangeFoldingInClass.kt")
            public void testRangeFoldingInClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/rangeFoldingInClass.kt");
            }

            @Test
            @TestMetadata(value="smap.kt")
            public void testSmap() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/smap.kt");
            }

            @Test
            @TestMetadata(value="smapWithNewSyntax.kt")
            public void testSmapWithNewSyntax() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/smapWithNewSyntax.kt");
            }

            @Test
            @TestMetadata(value="smapWithOldSyntax.kt")
            public void testSmapWithOldSyntax() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/smapWithOldSyntax.kt");
            }

            @Test
            @TestMetadata(value="tryFinally1.kt")
            public void testTryFinally1() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/tryFinally1.kt");
            }

            @Test
            @TestMetadata(value="tryFinally2.kt")
            public void testTryFinally2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/tryFinally2.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/resolve")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Resolve {
                @Test
                public void testAllFilesPresentInResolve() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/resolve"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineComponent.kt")
                public void testInlineComponent() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/resolve/inlineComponent.kt");
                }

                @Test
                @TestMetadata(value="inlineIterator.kt")
                public void testInlineIterator() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/resolve/inlineIterator.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/newsmap")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Newsmap {
                @Test
                public void testAllFilesPresentInNewsmap() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/newsmap"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="differentMapping.kt")
                public void testDifferentMapping() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/newsmap/differentMapping.kt");
                }

                @Test
                @TestMetadata(value="mappingInInlineFunLambda.kt")
                public void testMappingInInlineFunLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInInlineFunLambda.kt");
                }

                @Test
                @TestMetadata(value="mappingInSubInlineLambda.kt")
                public void testMappingInSubInlineLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInSubInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="mappingInSubInlineLambdaSameFileInline.kt")
                public void testMappingInSubInlineLambdaSameFileInline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInSubInlineLambdaSameFileInline.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/inlineOnly")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineOnly {
                @Test
                public void testAllFilesPresentInInlineOnly() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/inlineOnly"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="noSmap.kt")
                public void testNoSmap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/noSmap.kt");
                }

                @Test
                @TestMetadata(value="noSmapWithProperty.kt")
                public void testNoSmapWithProperty() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/noSmapWithProperty.kt");
                }

                @Test
                @TestMetadata(value="reified.kt")
                public void testReified() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/reified.kt");
                }

                @Test
                @TestMetadata(value="reifiedProperty.kt")
                public void testReifiedProperty() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/reifiedProperty.kt");
                }

                @Test
                @TestMetadata(value="stdlibInlineOnly.kt")
                public void testStdlibInlineOnly() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/stdlibInlineOnly.kt");
                }

                @Test
                @TestMetadata(value="stdlibInlineOnlyOneLine.kt")
                public void testStdlibInlineOnlyOneLine() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/stdlibInlineOnlyOneLine.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/defaultLambda")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DefaultLambda {
                @Test
                public void testAllFilesPresentInDefaultLambda() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/defaultLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="defaultLambdaInAnonymous.kt")
                public void testDefaultLambdaInAnonymous() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/defaultLambdaInAnonymous.kt");
                }

                @Test
                @TestMetadata(value="inlineAnonymousInDefault.kt")
                public void testInlineAnonymousInDefault() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineAnonymousInDefault.kt");
                }

                @Test
                @TestMetadata(value="inlineAnonymousInDefault2.kt")
                public void testInlineAnonymousInDefault2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineAnonymousInDefault2.kt");
                }

                @Test
                @TestMetadata(value="inlineInDefault.kt")
                public void testInlineInDefault() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineInDefault.kt");
                }

                @Test
                @TestMetadata(value="inlineInDefault2.kt")
                public void testInlineInDefault2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineInDefault2.kt");
                }

                @Test
                @TestMetadata(value="kt21827.kt")
                public void testKt21827() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/kt21827.kt");
                }

                @Test
                @TestMetadata(value="nested.kt")
                public void testNested() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/nested.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/simple.kt");
                }

                @Test
                @TestMetadata(value="simple2.kt")
                public void testSimple2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/simple2.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/anonymous")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Anonymous {
                @Test
                public void testAllFilesPresentInAnonymous() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/anonymous"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="kt19175.kt")
                public void testKt19175() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/kt19175.kt");
                }

                @Test
                @TestMetadata(value="lambda.kt")
                public void testLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambda.kt");
                }

                @Test
                @TestMetadata(value="lambdaOnCallSite.kt")
                public void testLambdaOnCallSite() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambdaOnCallSite.kt");
                }

                @Test
                @TestMetadata(value="lambdaOnInlineCallSite.kt")
                public void testLambdaOnInlineCallSite() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambdaOnInlineCallSite.kt");
                }

                @Test
                @TestMetadata(value="object.kt")
                public void testObject() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/object.kt");
                }

                @Test
                @TestMetadata(value="objectOnCallSite.kt")
                public void testObjectOnCallSite() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnCallSite.kt");
                }

                @Test
                @TestMetadata(value="objectOnInlineCallSite.kt")
                public void testObjectOnInlineCallSite() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSite.kt");
                }

                @Test
                @TestMetadata(value="objectOnInlineCallSite2.kt")
                public void testObjectOnInlineCallSite2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSite2.kt");
                }

                @Test
                @TestMetadata(value="objectOnInlineCallSiteWithCapture.kt")
                public void testObjectOnInlineCallSiteWithCapture() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSiteWithCapture.kt");
                }

                @Test
                @TestMetadata(value="severalMappingsForDefaultFile.kt")
                public void testSeveralMappingsForDefaultFile() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/severalMappingsForDefaultFile.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/simple")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Simple {
            @Test
            public void testAllFilesPresentInSimple() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/simple"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="captureAndArgumentIncompatibleTypes.kt")
            public void testCaptureAndArgumentIncompatibleTypes() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/captureAndArgumentIncompatibleTypes.kt");
            }

            @Test
            @TestMetadata(value="classObject.kt")
            public void testClassObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/classObject.kt");
            }

            @Test
            @TestMetadata(value="destructuring.kt")
            public void testDestructuring() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/destructuring.kt");
            }

            @Test
            @TestMetadata(value="destructuringIndexClash.kt")
            public void testDestructuringIndexClash() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/destructuringIndexClash.kt");
            }

            @Test
            @TestMetadata(value="extension.kt")
            public void testExtension() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/extension.kt");
            }

            @Test
            @TestMetadata(value="extensionLambda.kt")
            public void testExtensionLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/extensionLambda.kt");
            }

            @Test
            @TestMetadata(value="funImportedFromObject.kt")
            public void testFunImportedFromObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/funImportedFromObject.kt");
            }

            @Test
            @TestMetadata(value="importedJavaStaticField.kt")
            public void testImportedJavaStaticField() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/importedJavaStaticField.kt");
            }

            @Test
            @TestMetadata(value="inlineCallInInlineLambda.kt")
            public void testInlineCallInInlineLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/inlineCallInInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="kt17431.kt")
            public void testKt17431() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/kt17431.kt");
            }

            @Test
            @TestMetadata(value="kt28547.kt")
            public void testKt28547() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/kt28547.kt");
            }

            @Test
            @TestMetadata(value="kt28547_2.kt")
            public void testKt28547_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/kt28547_2.kt");
            }

            @Test
            @TestMetadata(value="params.kt")
            public void testParams() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/params.kt");
            }

            @Test
            @TestMetadata(value="propImportedFromObject.kt")
            public void testPropImportedFromObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/propImportedFromObject.kt");
            }

            @Test
            @TestMetadata(value="rootConstructor.kt")
            public void testRootConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/rootConstructor.kt");
            }

            @Test
            @TestMetadata(value="safeCall.kt")
            public void testSafeCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/safeCall.kt");
            }

            @Test
            @TestMetadata(value="severalClosures.kt")
            public void testSeveralClosures() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/severalClosures.kt");
            }

            @Test
            @TestMetadata(value="severalUsage.kt")
            public void testSeveralUsage() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/severalUsage.kt");
            }

            @Test
            @TestMetadata(value="simpleDouble.kt")
            public void testSimpleDouble() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleDouble.kt");
            }

            @Test
            @TestMetadata(value="simpleEnum.kt")
            public void testSimpleEnum() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleEnum.kt");
            }

            @Test
            @TestMetadata(value="simpleGenerics.kt")
            public void testSimpleGenerics() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleGenerics.kt");
            }

            @Test
            @TestMetadata(value="simpleInt.kt")
            public void testSimpleInt() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleInt.kt");
            }

            @Test
            @TestMetadata(value="simpleLambda.kt")
            public void testSimpleLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleLambda.kt");
            }

            @Test
            @TestMetadata(value="simpleObject.kt")
            public void testSimpleObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleObject.kt");
            }

            @Test
            @TestMetadata(value="vararg.kt")
            public void testVararg() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/vararg.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/signatureMangling")
        @TestDataPath(value="$PROJECT_ROOT")
        public class SignatureMangling {
            @Test
            public void testAllFilesPresentInSignatureMangling() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/signatureMangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="flexibleType.kt")
            public void testFlexibleType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signatureMangling/flexibleType.kt");
            }

            @Test
            @TestMetadata(value="indices.kt")
            public void testIndices() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signatureMangling/indices.kt");
            }

            @Test
            @TestMetadata(value="inheritFromJava.kt")
            public void testInheritFromJava() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signatureMangling/inheritFromJava.kt");
            }

            @Test
            @TestMetadata(value="rawType.kt")
            public void testRawType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signatureMangling/rawType.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/signature")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Signature {
            @Test
            public void testAllFilesPresentInSignature() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/signature"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="byteIteratorWithForLoop.kt")
            public void testByteIteratorWithForLoop() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/byteIteratorWithForLoop.kt");
            }

            @Test
            @TestMetadata(value="byteIteratorWithWhileLoop.kt")
            public void testByteIteratorWithWhileLoop() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/byteIteratorWithWhileLoop.kt");
            }

            @Test
            @TestMetadata(value="inProjectionSubstitution.kt")
            public void testInProjectionSubstitution() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/inProjectionSubstitution.kt");
            }

            @Test
            @TestMetadata(value="outProjectionSubstitution.kt")
            public void testOutProjectionSubstitution() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/outProjectionSubstitution.kt");
            }

            @Test
            @TestMetadata(value="recursion.kt")
            public void testRecursion() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/recursion.kt");
            }

            @Test
            @TestMetadata(value="sameFormalParameterName.kt")
            public void testSameFormalParameterName() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/sameFormalParameterName.kt");
            }

            @Test
            @TestMetadata(value="sameReifiedFormalParameterName.kt")
            public void testSameReifiedFormalParameterName() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/sameReifiedFormalParameterName.kt");
            }

            @Test
            @TestMetadata(value="starProjectionSubstitution.kt")
            public void testStarProjectionSubstitution() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/starProjectionSubstitution.kt");
            }

            @Test
            @TestMetadata(value="typeParameterInLambda.kt")
            public void testTypeParameterInLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/typeParameterInLambda.kt");
            }

            @Test
            @TestMetadata(value="typeParametersSubstitution.kt")
            public void testTypeParametersSubstitution() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/typeParametersSubstitution.kt");
            }

            @Test
            @TestMetadata(value="typeParametersSubstitution2.kt")
            public void testTypeParametersSubstitution2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/typeParametersSubstitution2.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/reified")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Reified {
            @Test
            public void testAllFilesPresentInReified() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayConstructor.kt")
            public void testArrayConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/arrayConstructor.kt");
            }

            @Test
            @TestMetadata(value="arrayOf.kt")
            public void testArrayOf() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/arrayOf.kt");
            }

            @Test
            @TestMetadata(value="capturedLambda.kt")
            public void testCapturedLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/capturedLambda.kt");
            }

            @Test
            @TestMetadata(value="capturedLambda2.kt")
            public void testCapturedLambda2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/capturedLambda2.kt");
            }

            @Test
            @TestMetadata(value="dontSubstituteNonReified.kt")
            public void testDontSubstituteNonReified() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/dontSubstituteNonReified.kt");
            }

            @Test
            @TestMetadata(value="kt11081.kt")
            public void testKt11081() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt11081.kt");
            }

            @Test
            @TestMetadata(value="kt11677.kt")
            public void testKt11677() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt11677.kt");
            }

            @Test
            @TestMetadata(value="kt15956.kt")
            public void testKt15956() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt15956.kt");
            }

            @Test
            @TestMetadata(value="kt15997.kt")
            public void testKt15997() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt15997.kt");
            }

            @Test
            @TestMetadata(value="kt15997_2.kt")
            public void testKt15997_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt15997_2.kt");
            }

            @Test
            @TestMetadata(value="kt18977.kt")
            public void testKt18977() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt18977.kt");
            }

            @Test
            @TestMetadata(value="kt28234.kt")
            public void testKt28234() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt28234.kt");
            }

            @Test
            @TestMetadata(value="kt35511.kt")
            public void testKt35511() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt35511.kt");
            }

            @Test
            @TestMetadata(value="kt35511_try.kt")
            public void testKt35511_try() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt35511_try.kt");
            }

            @Test
            @TestMetadata(value="kt35511_try_valueOf.kt")
            public void testKt35511_try_valueOf() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt35511_try_valueOf.kt");
            }

            @Test
            @TestMetadata(value="kt35511_try_values.kt")
            public void testKt35511_try_values() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt35511_try_values.kt");
            }

            @Test
            @TestMetadata(value="kt44770.kt")
            public void testKt44770() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt44770.kt");
            }

            @Test
            @TestMetadata(value="kt44770_2.kt")
            public void testKt44770_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt44770_2.kt");
            }

            @Test
            @TestMetadata(value="kt46584.kt")
            public void testKt46584() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt46584.kt");
            }

            @Test
            @TestMetadata(value="kt46584_2.kt")
            public void testKt46584_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt46584_2.kt");
            }

            @Test
            @TestMetadata(value="kt55398.kt")
            public void testKt55398() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt55398.kt");
            }

            @Test
            @TestMetadata(value="kt6988.kt")
            public void testKt6988() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt6988.kt");
            }

            @Test
            @TestMetadata(value="kt6988_2.kt")
            public void testKt6988_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt6988_2.kt");
            }

            @Test
            @TestMetadata(value="kt6990.kt")
            public void testKt6990() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt6990.kt");
            }

            @Test
            @TestMetadata(value="kt7017.kt")
            public void testKt7017() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt7017.kt");
            }

            @Test
            @TestMetadata(value="kt8047.kt")
            public void testKt8047() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt8047.kt");
            }

            @Test
            @TestMetadata(value="kt8047_2.kt")
            public void testKt8047_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt8047_2.kt");
            }

            @Test
            @TestMetadata(value="kt9637.kt")
            public void testKt9637() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt9637.kt");
            }

            @Test
            @TestMetadata(value="kt9637_2.kt")
            public void testKt9637_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt9637_2.kt");
            }

            @Test
            @TestMetadata(value="nameClash.kt")
            public void testNameClash() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/nameClash.kt");
            }

            @Test
            @TestMetadata(value="nonCapturingObjectInLambda.kt")
            public void testNonCapturingObjectInLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/nonCapturingObjectInLambda.kt");
            }

            @Test
            @TestMetadata(value="packages.kt")
            public void testPackages() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/packages.kt");
            }

            @Test
            @TestMetadata(value="singletonLambda.kt")
            public void testSingletonLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/singletonLambda.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/reified/isCheck")
            @TestDataPath(value="$PROJECT_ROOT")
            public class IsCheck {
                @Test
                public void testAllFilesPresentInIsCheck() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/isCheck"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="chain.kt")
                public void testChain() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/isCheck/chain.kt");
                }

                @Test
                @TestMetadata(value="nullable.kt")
                public void testNullable() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/isCheck/nullable.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/isCheck/simple.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/reified/defaultLambda")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DefaultLambda {
                @Test
                public void testAllFilesPresentInDefaultLambda() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/defaultLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="chain.kt")
                public void testChain() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/chain.kt");
                }

                @Test
                @TestMetadata(value="nested.kt")
                public void testNested() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested.kt");
                }

                @Test
                @TestMetadata(value="nested2.kt")
                public void testNested2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested2.kt");
                }

                @Test
                @TestMetadata(value="nested2Static.kt")
                public void testNested2Static() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested2Static.kt");
                }

                @Test
                @TestMetadata(value="nestedStatic.kt")
                public void testNestedStatic() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nestedStatic.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/simple.kt");
                }

                @Test
                @TestMetadata(value="transitiveChain.kt")
                public void testTransitiveChain() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/transitiveChain.kt");
                }

                @Test
                @TestMetadata(value="transitiveChainStatic.kt")
                public void testTransitiveChainStatic() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/transitiveChainStatic.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/reified/checkCast")
            @TestDataPath(value="$PROJECT_ROOT")
            public class CheckCast {
                @Test
                public void testAllFilesPresentInCheckCast() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/checkCast"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="chain.kt")
                public void testChain() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/chain.kt");
                }

                @Test
                @TestMetadata(value="kt26435.kt")
                public void testKt26435() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435.kt");
                }

                @Test
                @TestMetadata(value="kt26435_2.kt")
                public void testKt26435_2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435_2.kt");
                }

                @Test
                @TestMetadata(value="kt26435_3.kt")
                public void testKt26435_3() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435_3.kt");
                }

                @Test
                @TestMetadata(value="kt8043.kt")
                public void testKt8043() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt8043.kt");
                }

                @Test
                @TestMetadata(value="maxStack.kt")
                public void testMaxStack() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/maxStack.kt");
                }

                @Test
                @TestMetadata(value="nullable.kt")
                public void testNullable() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/nullable.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/simple.kt");
                }

                @Test
                @TestMetadata(value="simpleSafe.kt")
                public void testSimpleSafe() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/simpleSafe.kt");
                }

                @Test
                @TestMetadata(value="simple_1_3.kt")
                public void testSimple_1_3() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/simple_1_3.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/property")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Property {
            @Test
            public void testAllFilesPresentInProperty() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="augAssignmentAndInc.kt")
            public void testAugAssignmentAndInc() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndInc.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncInClass.kt")
            public void testAugAssignmentAndIncInClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncInClass.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncInClassViaConvention.kt")
            public void testAugAssignmentAndIncInClassViaConvention() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncInClassViaConvention.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncOnExtension.kt")
            public void testAugAssignmentAndIncOnExtension() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncOnExtension.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncOnExtensionInClass.kt")
            public void testAugAssignmentAndIncOnExtensionInClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncOnExtensionInClass.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncViaConvention.kt")
            public void testAugAssignmentAndIncViaConvention() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncViaConvention.kt");
            }

            @Test
            @TestMetadata(value="crossinlineFunctional.kt")
            public void testCrossinlineFunctional() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/crossinlineFunctional.kt");
            }

            @Test
            @TestMetadata(value="fromObject.kt")
            public void testFromObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/fromObject.kt");
            }

            @Test
            @TestMetadata(value="kt22649.kt")
            public void testKt22649() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/kt22649.kt");
            }

            @Test
            @TestMetadata(value="noinlineFunctional.kt")
            public void testNoinlineFunctional() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/noinlineFunctional.kt");
            }

            @Test
            @TestMetadata(value="property.kt")
            public void testProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/property.kt");
            }

            @Test
            @TestMetadata(value="reifiedVal.kt")
            public void testReifiedVal() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/reifiedVal.kt");
            }

            @Test
            @TestMetadata(value="reifiedValMultiModule.kt")
            public void testReifiedValMultiModule() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/reifiedValMultiModule.kt");
            }

            @Test
            @TestMetadata(value="reifiedVar.kt")
            public void testReifiedVar() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/reifiedVar.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/simple.kt");
            }

            @Test
            @TestMetadata(value="simpleExtension.kt")
            public void testSimpleExtension() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/simpleExtension.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/private")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Private {
            @Test
            @TestMetadata(value="accessorForConst.kt")
            public void testAccessorForConst() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/accessorForConst.kt");
            }

            @Test
            @TestMetadata(value="accessorStability.kt")
            public void testAccessorStability() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/accessorStability.kt");
            }

            @Test
            @TestMetadata(value="accessorStabilityInClass.kt")
            public void testAccessorStabilityInClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/accessorStabilityInClass.kt");
            }

            @Test
            public void testAllFilesPresentInPrivate() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/private"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="effectivePrivate.kt")
            public void testEffectivePrivate() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/effectivePrivate.kt");
            }

            @Test
            @TestMetadata(value="kt6453.kt")
            public void testKt6453() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/kt6453.kt");
            }

            @Test
            @TestMetadata(value="kt8094.kt")
            public void testKt8094() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/kt8094.kt");
            }

            @Test
            @TestMetadata(value="kt8095.kt")
            public void testKt8095() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/kt8095.kt");
            }

            @Test
            @TestMetadata(value="nestedInPrivateClass.kt")
            public void testNestedInPrivateClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/nestedInPrivateClass.kt");
            }

            @Test
            @TestMetadata(value="nestedInPrivateClass2.kt")
            public void testNestedInPrivateClass2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/nestedInPrivateClass2.kt");
            }

            @Test
            @TestMetadata(value="privateClass.kt")
            public void testPrivateClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/privateClass.kt");
            }

            @Test
            @TestMetadata(value="privateClassExtensionLambda.kt")
            public void testPrivateClassExtensionLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/privateClassExtensionLambda.kt");
            }

            @Test
            @TestMetadata(value="privateInInlineInMultiFileFacade.kt")
            public void testPrivateInInlineInMultiFileFacade() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/privateInInlineInMultiFileFacade.kt");
            }

            @Test
            @TestMetadata(value="privateInline.kt")
            public void testPrivateInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/privateInline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/optimizations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Optimizations {
            @Test
            public void testAllFilesPresentInOptimizations() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/optimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt20844.kt")
            public void testKt20844() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/optimizations/kt20844.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NonLocalReturns {
            @Test
            public void testAllFilesPresentInNonLocalReturns() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="explicitLocalReturn.kt")
            public void testExplicitLocalReturn() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/explicitLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGenerator.kt")
            public void testFromArrayGenerator() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGenerator.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorCatch.kt")
            public void testFromArrayGeneratorCatch() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorCatch.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorNested.kt")
            public void testFromArrayGeneratorNested() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorNested.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithCapture.kt")
            public void testFromArrayGeneratorWithCapture() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithCapture.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithCatch.kt")
            public void testFromArrayGeneratorWithCatch() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithCatch.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithFinally.kt")
            public void testFromArrayGeneratorWithFinally() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinally.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithFinallyX2.kt")
            public void testFromArrayGeneratorWithFinallyX2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinallyX2.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithFinallyX2_2.kt")
            public void testFromArrayGeneratorWithFinallyX2_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinallyX2_2.kt");
            }

            @Test
            @TestMetadata(value="fromInterfaceDefaultGetter.kt")
            public void testFromInterfaceDefaultGetter() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromInterfaceDefaultGetter.kt");
            }

            @Test
            @TestMetadata(value="justReturnInLambda.kt")
            public void testJustReturnInLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/justReturnInLambda.kt");
            }

            @Test
            @TestMetadata(value="kt5199.kt")
            public void testKt5199() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt5199.kt");
            }

            @Test
            @TestMetadata(value="kt8948.kt")
            public void testKt8948() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt8948.kt");
            }

            @Test
            @TestMetadata(value="kt8948v2.kt")
            public void testKt8948v2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt8948v2.kt");
            }

            @Test
            @TestMetadata(value="kt9304.kt")
            public void testKt9304() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt9304.kt");
            }

            @Test
            @TestMetadata(value="nestedNonLocals.kt")
            public void testNestedNonLocals() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/nestedNonLocals.kt");
            }

            @Test
            @TestMetadata(value="noInlineLocalReturn.kt")
            public void testNoInlineLocalReturn() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/noInlineLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturnFromOuterLambda.kt")
            public void testNonLocalReturnFromOuterLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/nonLocalReturnFromOuterLambda.kt");
            }

            @Test
            @TestMetadata(value="propertyAccessors.kt")
            public void testPropertyAccessors() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/propertyAccessors.kt");
            }

            @Test
            @TestMetadata(value="returnFromFunctionExpr.kt")
            public void testReturnFromFunctionExpr() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/returnFromFunctionExpr.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simple.kt");
            }

            @Test
            @TestMetadata(value="simpleFunctional.kt")
            public void testSimpleFunctional() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simpleFunctional.kt");
            }

            @Test
            @TestMetadata(value="simpleVoid.kt")
            public void testSimpleVoid() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simpleVoid.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally")
            @TestDataPath(value="$PROJECT_ROOT")
            public class TryFinally {
                @Test
                public void testAllFilesPresentInTryFinally() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="kt16417.kt")
                public void testKt16417() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt16417.kt");
                }

                @Test
                @TestMetadata(value="kt20433.kt")
                public void testKt20433() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433.kt");
                }

                @Test
                @TestMetadata(value="kt20433_2.kt")
                public void testKt20433_2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_2.kt");
                }

                @Test
                @TestMetadata(value="kt20433_2_void.kt")
                public void testKt20433_2_void() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_2_void.kt");
                }

                @Test
                @TestMetadata(value="kt20433_void.kt")
                public void testKt20433_void() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_void.kt");
                }

                @Test
                @TestMetadata(value="kt26384.kt")
                public void testKt26384() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt26384.kt");
                }

                @Test
                @TestMetadata(value="kt26384_2.kt")
                public void testKt26384_2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt26384_2.kt");
                }

                @Test
                @TestMetadata(value="kt28546.kt")
                public void testKt28546() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt28546.kt");
                }

                @Test
                @TestMetadata(value="kt6956.kt")
                public void testKt6956() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt6956.kt");
                }

                @Test
                @TestMetadata(value="kt7273.kt")
                public void testKt7273() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt7273.kt");
                }

                @Test
                @TestMetadata(value="nonLocalReturnFromCatchBlock.kt")
                public void testNonLocalReturnFromCatchBlock() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnFromCatchBlock.kt");
                }

                @Test
                @TestMetadata(value="nonLocalReturnFromOuterLambda.kt")
                public void testNonLocalReturnFromOuterLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnFromOuterLambda.kt");
                }

                @Test
                @TestMetadata(value="nonLocalReturnToCatchBlock.kt")
                public void testNonLocalReturnToCatchBlock() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnToCatchBlock.kt");
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables")
                @TestDataPath(value="$PROJECT_ROOT")
                public class Variables {
                    @Test
                    public void testAllFilesPresentInVariables() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="kt7792.kt")
                    public void testKt7792() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables/kt7792.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable")
                @TestDataPath(value="$PROJECT_ROOT")
                public class ExceptionTable {
                    @Test
                    public void testAllFilesPresentInExceptionTable() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="break.kt")
                    public void testBreak() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/break.kt");
                    }

                    @Test
                    @TestMetadata(value="continue.kt")
                    public void testContinue() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/continue.kt");
                    }

                    @Test
                    @TestMetadata(value="exceptionInFinally.kt")
                    public void testExceptionInFinally() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/exceptionInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="forInFinally.kt")
                    public void testForInFinally() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/forInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="innerAndExternal.kt")
                    public void testInnerAndExternal() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternal.kt");
                    }

                    @Test
                    @TestMetadata(value="innerAndExternalNested.kt")
                    public void testInnerAndExternalNested() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternalNested.kt");
                    }

                    @Test
                    @TestMetadata(value="innerAndExternalSimple.kt")
                    public void testInnerAndExternalSimple() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternalSimple.kt");
                    }

                    @Test
                    @TestMetadata(value="kt31653.kt")
                    public void testKt31653() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31653.kt");
                    }

                    @Test
                    @TestMetadata(value="kt31653_2.kt")
                    public void testKt31653_2() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31653_2.kt");
                    }

                    @Test
                    @TestMetadata(value="kt31923.kt")
                    public void testKt31923() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923.kt");
                    }

                    @Test
                    @TestMetadata(value="kt31923_2.kt")
                    public void testKt31923_2() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923_2.kt");
                    }

                    @Test
                    @TestMetadata(value="kt31923_wrong.kt")
                    public void testKt31923_wrong() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923_wrong.kt");
                    }

                    @Test
                    @TestMetadata(value="nested.kt")
                    public void testNested() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nested.kt");
                    }

                    @Test
                    @TestMetadata(value="nestedWithReturns.kt")
                    public void testNestedWithReturns() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nestedWithReturns.kt");
                    }

                    @Test
                    @TestMetadata(value="nestedWithReturnsSimple.kt")
                    public void testNestedWithReturnsSimple() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nestedWithReturnsSimple.kt");
                    }

                    @Test
                    @TestMetadata(value="noFinally.kt")
                    public void testNoFinally() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/noFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="severalCatchClause.kt")
                    public void testSeveralCatchClause() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/severalCatchClause.kt");
                    }

                    @Test
                    @TestMetadata(value="simpleThrow.kt")
                    public void testSimpleThrow() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/simpleThrow.kt");
                    }

                    @Test
                    @TestMetadata(value="synchonized.kt")
                    public void testSynchonized() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/synchonized.kt");
                    }

                    @Test
                    @TestMetadata(value="throwInFinally.kt")
                    public void testThrowInFinally() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/throwInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="tryCatchInFinally.kt")
                    public void testTryCatchInFinally() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/tryCatchInFinally.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite")
                @TestDataPath(value="$PROJECT_ROOT")
                public class DeclSite {
                    @Test
                    public void testAllFilesPresentInDeclSite() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="complex.kt")
                    public void testComplex() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/complex.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturn.kt")
                    public void testIntReturn() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/intReturn.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex.kt")
                    public void testIntReturnComplex() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/intReturnComplex.kt");
                    }

                    @Test
                    @TestMetadata(value="longReturn.kt")
                    public void testLongReturn() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/longReturn.kt");
                    }

                    @Test
                    @TestMetadata(value="nested.kt")
                    public void testNested() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/nested.kt");
                    }

                    @Test
                    @TestMetadata(value="returnInFinally.kt")
                    public void testReturnInFinally() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="returnInTry.kt")
                    public void testReturnInTry() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInTry.kt");
                    }

                    @Test
                    @TestMetadata(value="returnInTryAndFinally.kt")
                    public void testReturnInTryAndFinally() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInTryAndFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="severalInTry.kt")
                    public void testSeveralInTry() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/severalInTry.kt");
                    }

                    @Test
                    @TestMetadata(value="severalInTryComplex.kt")
                    public void testSeveralInTryComplex() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/severalInTryComplex.kt");
                    }

                    @Test
                    @TestMetadata(value="voidInlineFun.kt")
                    public void testVoidInlineFun() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/voidInlineFun.kt");
                    }

                    @Test
                    @TestMetadata(value="voidNonLocal.kt")
                    public void testVoidNonLocal() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/voidNonLocal.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained")
                @TestDataPath(value="$PROJECT_ROOT")
                public class Chained {
                    @Test
                    public void testAllFilesPresentInChained() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="finallyInFinally.kt")
                    public void testFinallyInFinally() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/finallyInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="finallyInFinally2.kt")
                    public void testFinallyInFinally2() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/finallyInFinally2.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturn.kt")
                    public void testIntReturn() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturn.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex.kt")
                    public void testIntReturnComplex() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex2.kt")
                    public void testIntReturnComplex2() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex2.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex3.kt")
                    public void testIntReturnComplex3() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex3.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex4.kt")
                    public void testIntReturnComplex4() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex4.kt");
                    }

                    @Test
                    @TestMetadata(value="nestedLambda.kt")
                    public void testNestedLambda() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/nestedLambda.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite")
                @TestDataPath(value="$PROJECT_ROOT")
                public class CallSite {
                    @Test
                    public void testAllFilesPresentInCallSite() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="callSite.kt")
                    public void testCallSite() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/callSite.kt");
                    }

                    @Test
                    @TestMetadata(value="callSiteComplex.kt")
                    public void testCallSiteComplex() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/callSiteComplex.kt");
                    }

                    @Test
                    @TestMetadata(value="exceptionTableSplit.kt")
                    public void testExceptionTableSplit() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/exceptionTableSplit.kt");
                    }

                    @Test
                    @TestMetadata(value="exceptionTableSplitNoReturn.kt")
                    public void testExceptionTableSplitNoReturn() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/exceptionTableSplitNoReturn.kt");
                    }

                    @Test
                    @TestMetadata(value="finallyInFinally.kt")
                    public void testFinallyInFinally() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/finallyInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="wrongVarInterval.kt")
                    public void testWrongVarInterval() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/wrongVarInterval.kt");
                    }
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Deparenthesize {
                @Test
                public void testAllFilesPresentInDeparenthesize() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="bracket.kt")
                public void testBracket() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize/bracket.kt");
                }

                @Test
                @TestMetadata(value="labeled.kt")
                public void testLabeled() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize/labeled.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/noInline")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NoInline {
            @Test
            public void testAllFilesPresentInNoInline() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/noInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="extensionReceiver.kt")
            public void testExtensionReceiver() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/extensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="lambdaAsGeneric.kt")
            public void testLambdaAsGeneric() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/lambdaAsGeneric.kt");
            }

            @Test
            @TestMetadata(value="lambdaAsNonFunction.kt")
            public void testLambdaAsNonFunction() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/lambdaAsNonFunction.kt");
            }

            @Test
            @TestMetadata(value="noInline.kt")
            public void testNoInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/noInline.kt");
            }

            @Test
            @TestMetadata(value="noInlineLambdaChain.kt")
            public void testNoInlineLambdaChain() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/noInlineLambdaChain.kt");
            }

            @Test
            @TestMetadata(value="noInlineLambdaChainWithCapturedInline.kt")
            public void testNoInlineLambdaChainWithCapturedInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/noInlineLambdaChainWithCapturedInline.kt");
            }

            @Test
            @TestMetadata(value="withoutInline.kt")
            public void testWithoutInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/withoutInline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/multiplatform")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Multiplatform {
            @Test
            public void testAllFilesPresentInMultiplatform() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/multiplatform/defaultArguments")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DefaultArguments {
                @Test
                public void testAllFilesPresentInDefaultArguments() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiplatform/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="receiversAndParametersInLambda.kt")
                public void testReceiversAndParametersInLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/multiplatform/defaultArguments/receiversAndParametersInLambda.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/multifileClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class MultifileClasses {
            @Test
            public void testAllFilesPresentInMultifileClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultArguments.kt")
            public void testDefaultArguments() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/multifileClasses/defaultArguments.kt");
            }

            @Test
            @TestMetadata(value="inlineFromOptimizedMultifileClass.kt")
            public void testInlineFromOptimizedMultifileClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/multifileClasses/inlineFromOptimizedMultifileClass.kt");
            }

            @Test
            @TestMetadata(value="inlineFromOtherPackage.kt")
            public void testInlineFromOtherPackage() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/multifileClasses/inlineFromOtherPackage.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/multiModule")
        @TestDataPath(value="$PROJECT_ROOT")
        public class MultiModule {
            @Test
            public void testAllFilesPresentInMultiModule() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiModule"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="tryCatchWithRecursiveInline.kt")
            public void testTryCatchWithRecursiveInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/multiModule/tryCatchWithRecursiveInline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/localFunInLambda")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LocalFunInLambda {
            @Test
            public void testAllFilesPresentInLocalFunInLambda() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/localFunInLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultParam.kt")
            public void testDefaultParam() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/localFunInLambda/defaultParam.kt");
            }

            @Test
            @TestMetadata(value="lambdaInLambdaCapturesAnotherFun.kt")
            public void testLambdaInLambdaCapturesAnotherFun() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/localFunInLambda/lambdaInLambdaCapturesAnotherFun.kt");
            }

            @Test
            @TestMetadata(value="localFunInLambda.kt")
            public void testLocalFunInLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambda.kt");
            }

            @Test
            @TestMetadata(value="localFunInLambdaCapturesAnotherFun.kt")
            public void testLocalFunInLambdaCapturesAnotherFun() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambdaCapturesAnotherFun.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/lambdaTransformation")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LambdaTransformation {
            @Test
            public void testAllFilesPresentInLambdaTransformation() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/lambdaTransformation"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="lambdaCloning.kt")
            public void testLambdaCloning() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaCloning.kt");
            }

            @Test
            @TestMetadata(value="lambdaInLambda2.kt")
            public void testLambdaInLambda2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaInLambda2.kt");
            }

            @Test
            @TestMetadata(value="lambdaInLambdaNoInline.kt")
            public void testLambdaInLambdaNoInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaInLambdaNoInline.kt");
            }

            @Test
            @TestMetadata(value="regeneratedLambdaName.kt")
            public void testRegeneratedLambdaName() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/regeneratedLambdaName.kt");
            }

            @Test
            @TestMetadata(value="regeneratedLambdaName2.kt")
            public void testRegeneratedLambdaName2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/regeneratedLambdaName2.kt");
            }

            @Test
            @TestMetadata(value="sameCaptured.kt")
            public void testSameCaptured() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/sameCaptured.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/lambdaClassClash")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LambdaClassClash {
            @Test
            public void testAllFilesPresentInLambdaClassClash() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/lambdaClassClash"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="lambdaClassClash.kt")
            public void testLambdaClassClash() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaClassClash/lambdaClassClash.kt");
            }

            @Test
            @TestMetadata(value="noInlineLambdaX2.kt")
            public void testNoInlineLambdaX2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaClassClash/noInlineLambdaX2.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/jvmPackageName")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JvmPackageName {
            @Test
            public void testAllFilesPresentInJvmPackageName() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/jvmPackageName"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/jvmPackageName/simple.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/jvmName")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JvmName {
            @Test
            public void testAllFilesPresentInJvmName() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/jvmName"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/jvmName/simple.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/invokedynamic")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Invokedynamic {
            @Test
            public void testAllFilesPresentInInvokedynamic() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/invokedynamic/sam")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Sam {
                @Test
                public void testAllFilesPresentInSam() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="crossinlineLambda1.kt")
                public void testCrossinlineLambda1() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/crossinlineLambda1.kt");
                }

                @Test
                @TestMetadata(value="crossinlineLambda2.kt")
                public void testCrossinlineLambda2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/crossinlineLambda2.kt");
                }

                @Test
                @TestMetadata(value="inlineFunInDifferentPackage.kt")
                public void testInlineFunInDifferentPackage() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/inlineFunInDifferentPackage.kt");
                }

                @Test
                @TestMetadata(value="inlineLambda1.kt")
                public void testInlineLambda1() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/inlineLambda1.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/invokedynamic/lambdas")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Lambdas {
                @Test
                public void testAllFilesPresentInLambdas() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic/lambdas"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="crossinlineLambda1.kt")
                public void testCrossinlineLambda1() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/crossinlineLambda1.kt");
                }

                @Test
                @TestMetadata(value="crossinlineLambda2.kt")
                public void testCrossinlineLambda2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/crossinlineLambda2.kt");
                }

                @Test
                @TestMetadata(value="inlineFunInDifferentPackage.kt")
                public void testInlineFunInDifferentPackage() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/inlineFunInDifferentPackage.kt");
                }

                @Test
                @TestMetadata(value="inlineLambda1.kt")
                public void testInlineLambda1() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/inlineLambda1.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/innerClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InnerClasses {
            @Test
            public void testAllFilesPresentInInnerClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/innerClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="captureThisAndOuter.kt")
            public void testCaptureThisAndOuter() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/captureThisAndOuter.kt");
            }

            @Test
            @TestMetadata(value="fakeOverride.kt")
            public void testFakeOverride() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/fakeOverride.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuter.kt")
            public void testInnerInlineFunCapturesOuter() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuter.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuterByAnotherInlineFun.kt")
            public void testInnerInlineFunCapturesOuterByAnotherInlineFun() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterByAnotherInlineFun.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuterDeep.kt")
            public void testInnerInlineFunCapturesOuterDeep() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterDeep.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuterFunRef.kt")
            public void testInnerInlineFunCapturesOuterFunRef() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterFunRef.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuterWithInlineClass.kt")
            public void testInnerInlineFunCapturesOuterWithInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterWithInlineClass.kt");
            }

            @Test
            @TestMetadata(value="innerLambda.kt")
            public void testInnerLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerLambda.kt");
            }

            @Test
            @TestMetadata(value="kt10259.kt")
            public void testKt10259() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/kt10259.kt");
            }

            @Test
            @TestMetadata(value="kt12126.kt")
            public void testKt12126() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/kt12126.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="anonymousObject.kt")
            public void testAnonymousObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/anonymousObject.kt");
            }

            @Test
            @TestMetadata(value="inlineClassWithInlineValReturningInlineClass.kt")
            public void testInlineClassWithInlineValReturningInlineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/inlineClassWithInlineValReturningInlineClass.kt");
            }

            @Test
            @TestMetadata(value="inlineFunctionInsideInlineClassesBox.kt")
            public void testInlineFunctionInsideInlineClassesBox() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/inlineFunctionInsideInlineClassesBox.kt");
            }

            @Test
            @TestMetadata(value="kt62313.kt")
            public void testKt62313() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/kt62313.kt");
            }

            @Test
            @TestMetadata(value="noReturnTypeManglingFun.kt")
            public void testNoReturnTypeManglingFun() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/noReturnTypeManglingFun.kt");
            }

            @Test
            @TestMetadata(value="noReturnTypeManglingFunJvmName.kt")
            public void testNoReturnTypeManglingFunJvmName() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/noReturnTypeManglingFunJvmName.kt");
            }

            @Test
            @TestMetadata(value="noReturnTypeManglingVal.kt")
            public void testNoReturnTypeManglingVal() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/noReturnTypeManglingVal.kt");
            }

            @Test
            @TestMetadata(value="withReturnTypeManglingFun.kt")
            public void testWithReturnTypeManglingFun() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingFun.kt");
            }

            @Test
            @TestMetadata(value="withReturnTypeManglingFunJvmName.kt")
            public void testWithReturnTypeManglingFunJvmName() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingFunJvmName.kt");
            }

            @Test
            @TestMetadata(value="withReturnTypeManglingVal.kt")
            public void testWithReturnTypeManglingVal() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingVal.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter")
            @TestDataPath(value="$PROJECT_ROOT")
            public class UnboxGenericParameter {
                @Test
                public void testAllFilesPresentInUnboxGenericParameter() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral")
                @TestDataPath(value="$PROJECT_ROOT")
                public class ObjectLiteral {
                    @Test
                    public void testAllFilesPresentInObjectLiteral() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="any.kt")
                    public void testAny() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/any.kt");
                    }

                    @Test
                    @TestMetadata(value="anyN.kt")
                    public void testAnyN() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/anyN.kt");
                    }

                    @Test
                    @TestMetadata(value="iface.kt")
                    public void testIface() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/iface.kt");
                    }

                    @Test
                    @TestMetadata(value="ifaceChild.kt")
                    public void testIfaceChild() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/ifaceChild.kt");
                    }

                    @Test
                    @TestMetadata(value="primitive.kt")
                    public void testPrimitive() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/primitive.kt");
                    }

                    @Test
                    @TestMetadata(value="string.kt")
                    public void testString() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/string.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda")
                @TestDataPath(value="$PROJECT_ROOT")
                public class Lambda {
                    @Test
                    public void testAllFilesPresentInLambda() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="any.kt")
                    public void testAny() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/any.kt");
                    }

                    @Test
                    @TestMetadata(value="anyN.kt")
                    public void testAnyN() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/anyN.kt");
                    }

                    @Test
                    @TestMetadata(value="iface.kt")
                    public void testIface() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/iface.kt");
                    }

                    @Test
                    @TestMetadata(value="ifaceChild.kt")
                    public void testIfaceChild() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/ifaceChild.kt");
                    }

                    @Test
                    @TestMetadata(value="primitive.kt")
                    public void testPrimitive() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/primitive.kt");
                    }

                    @Test
                    @TestMetadata(value="string.kt")
                    public void testString() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/string.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface")
                @TestDataPath(value="$PROJECT_ROOT")
                public class FunInterface {
                    @Test
                    public void testAllFilesPresentInFunInterface() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="any.kt")
                    public void testAny() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/any.kt");
                    }

                    @Test
                    @TestMetadata(value="anyN.kt")
                    public void testAnyN() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/anyN.kt");
                    }

                    @Test
                    @TestMetadata(value="iface.kt")
                    public void testIface() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/iface.kt");
                    }

                    @Test
                    @TestMetadata(value="ifaceChild.kt")
                    public void testIfaceChild() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/ifaceChild.kt");
                    }

                    @Test
                    @TestMetadata(value="primitive.kt")
                    public void testPrimitive() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/primitive.kt");
                    }

                    @Test
                    @TestMetadata(value="string.kt")
                    public void testString() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/string.kt");
                    }
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/inlineArgsInplace")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineArgsInplace {
            @Test
            public void testAllFilesPresentInInlineArgsInplace() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineArgsInplace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="callArgumentReordering.kt")
            public void testCallArgumentReordering() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineArgsInplace/callArgumentReordering.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/functionExpression")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FunctionExpression {
            @Test
            public void testAllFilesPresentInFunctionExpression() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/functionExpression"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="extension.kt")
            public void testExtension() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/functionExpression/extension.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/enum")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Enum {
            @Test
            public void testAllFilesPresentInEnum() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="enumEntries.kt")
            public void testEnumEntries() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/enumEntries.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesChainCapturedType.kt")
            public void testEnumEntriesChainCapturedType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/enumEntriesChainCapturedType.kt");
            }

            @Test
            @TestMetadata(value="javaEnumEntries.kt")
            public void testJavaEnumEntries() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/javaEnumEntries.kt");
            }

            @Test
            @TestMetadata(value="javaEnumEntriesChainCapturedType.kt")
            public void testJavaEnumEntriesChainCapturedType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/javaEnumEntriesChainCapturedType.kt");
            }

            @Test
            @TestMetadata(value="kt10569.kt")
            public void testKt10569() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/kt10569.kt");
            }

            @Test
            @TestMetadata(value="kt18254.kt")
            public void testKt18254() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/kt18254.kt");
            }

            @Test
            @TestMetadata(value="valueOf.kt")
            public void testValueOf() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOf.kt");
            }

            @Test
            @TestMetadata(value="valueOfCapturedType.kt")
            public void testValueOfCapturedType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOfCapturedType.kt");
            }

            @Test
            @TestMetadata(value="valueOfChain.kt")
            public void testValueOfChain() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOfChain.kt");
            }

            @Test
            @TestMetadata(value="valueOfChainCapturedType.kt")
            public void testValueOfChainCapturedType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOfChainCapturedType.kt");
            }

            @Test
            @TestMetadata(value="valueOfNonReified.kt")
            public void testValueOfNonReified() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOfNonReified.kt");
            }

            @Test
            @TestMetadata(value="values.kt")
            public void testValues() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/values.kt");
            }

            @Test
            @TestMetadata(value="valuesAsArray.kt")
            public void testValuesAsArray() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesAsArray.kt");
            }

            @Test
            @TestMetadata(value="valuesCapturedType.kt")
            public void testValuesCapturedType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesCapturedType.kt");
            }

            @Test
            @TestMetadata(value="valuesChain.kt")
            public void testValuesChain() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesChain.kt");
            }

            @Test
            @TestMetadata(value="valuesChainCapturedType.kt")
            public void testValuesChainCapturedType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesChainCapturedType.kt");
            }

            @Test
            @TestMetadata(value="valuesNonReified.kt")
            public void testValuesNonReified() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesNonReified.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/enclosingInfo")
        @TestDataPath(value="$PROJECT_ROOT")
        public class EnclosingInfo {
            @Test
            public void testAllFilesPresentInEnclosingInfo() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/enclosingInfo"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="anonymousInLambda.kt")
            public void testAnonymousInLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/anonymousInLambda.kt");
            }

            @Test
            @TestMetadata(value="inlineChain.kt")
            public void testInlineChain() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/inlineChain.kt");
            }

            @Test
            @TestMetadata(value="inlineChain2.kt")
            public void testInlineChain2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/inlineChain2.kt");
            }

            @Test
            @TestMetadata(value="kt52417.kt")
            public void testKt52417() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/kt52417.kt");
            }

            @Test
            @TestMetadata(value="objectInInlineFun.kt")
            public void testObjectInInlineFun() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/objectInInlineFun.kt");
            }

            @Test
            @TestMetadata(value="transformedConstructor.kt")
            public void testTransformedConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructor.kt");
            }

            @Test
            @TestMetadata(value="transformedConstructorWithAdditionalObject.kt")
            public void testTransformedConstructorWithAdditionalObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructorWithAdditionalObject.kt");
            }

            @Test
            @TestMetadata(value="transformedConstructorWithNestedInline.kt")
            public void testTransformedConstructorWithNestedInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructorWithNestedInline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/dontReify")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DontReify {
            @Test
            public void testAllFilesPresentInDontReify() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/dontReify"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayRead.kt")
            public void testArrayRead() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/arrayRead.kt");
            }

            @Test
            @TestMetadata(value="arrayWrite.kt")
            public void testArrayWrite() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/arrayWrite.kt");
            }

            @Test
            @TestMetadata(value="dispatchReceiver.kt")
            public void testDispatchReceiver() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/dispatchReceiver.kt");
            }

            @Test
            @TestMetadata(value="extensionReceiver.kt")
            public void testExtensionReceiver() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/extensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="lambdaParameter.kt")
            public void testLambdaParameter() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/lambdaParameter.kt");
            }

            @Test
            @TestMetadata(value="localDelegatedProperty.kt")
            public void testLocalDelegatedProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/localDelegatedProperty.kt");
            }

            @Test
            @TestMetadata(value="localObjectProperty.kt")
            public void testLocalObjectProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/localObjectProperty.kt");
            }

            @Test
            @TestMetadata(value="localVariable.kt")
            public void testLocalVariable() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/localVariable.kt");
            }

            @Test
            @TestMetadata(value="methodReturnType.kt")
            public void testMethodReturnType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/methodReturnType.kt");
            }

            @Test
            @TestMetadata(value="parameterInLocalObject.kt")
            public void testParameterInLocalObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/parameterInLocalObject.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/delegatedProperty")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DelegatedProperty {
            @Test
            public void testAllFilesPresentInDelegatedProperty() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt16864.kt")
            public void testKt16864() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/kt16864.kt");
            }

            @Test
            @TestMetadata(value="kt48498.kt")
            public void testKt48498() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/kt48498.kt");
            }

            @Test
            @TestMetadata(value="local.kt")
            public void testLocal() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/local.kt");
            }

            @Test
            @TestMetadata(value="localDeclaredInLambda.kt")
            public void testLocalDeclaredInLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/localDeclaredInLambda.kt");
            }

            @Test
            @TestMetadata(value="localInAnonymousObject.kt")
            public void testLocalInAnonymousObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/localInAnonymousObject.kt");
            }

            @Test
            @TestMetadata(value="localInLambda.kt")
            public void testLocalInLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/localInLambda.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/defaultValues")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DefaultValues {
            @Test
            @TestMetadata(value="33Parameters.kt")
            public void test33Parameters() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/33Parameters.kt");
            }

            @Test
            @TestMetadata(value="33ParametersInConstructor.kt")
            public void test33ParametersInConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/33ParametersInConstructor.kt");
            }

            @Test
            public void testAllFilesPresentInDefaultValues() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultInExtension.kt")
            public void testDefaultInExtension() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/defaultInExtension.kt");
            }

            @Test
            @TestMetadata(value="defaultMethod.kt")
            public void testDefaultMethod() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/defaultMethod.kt");
            }

            @Test
            @TestMetadata(value="defaultMethodInClass.kt")
            public void testDefaultMethodInClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/defaultMethodInClass.kt");
            }

            @Test
            @TestMetadata(value="defaultParamRemapping.kt")
            public void testDefaultParamRemapping() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/defaultParamRemapping.kt");
            }

            @Test
            @TestMetadata(value="inlineInDefaultParameter.kt")
            public void testInlineInDefaultParameter() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/inlineInDefaultParameter.kt");
            }

            @Test
            @TestMetadata(value="inlineLambdaInNoInlineDefault.kt")
            public void testInlineLambdaInNoInlineDefault() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/inlineLambdaInNoInlineDefault.kt");
            }

            @Test
            @TestMetadata(value="kt11479.kt")
            public void testKt11479() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt11479.kt");
            }

            @Test
            @TestMetadata(value="kt11479InlinedDefaultParameter.kt")
            public void testKt11479InlinedDefaultParameter() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt11479InlinedDefaultParameter.kt");
            }

            @Test
            @TestMetadata(value="kt14564.kt")
            public void testKt14564() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt14564.kt");
            }

            @Test
            @TestMetadata(value="kt14564_2.kt")
            public void testKt14564_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt14564_2.kt");
            }

            @Test
            @TestMetadata(value="kt16496.kt")
            public void testKt16496() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt16496.kt");
            }

            @Test
            @TestMetadata(value="kt18689.kt")
            public void testKt18689() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689.kt");
            }

            @Test
            @TestMetadata(value="kt18689_2.kt")
            public void testKt18689_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_2.kt");
            }

            @Test
            @TestMetadata(value="kt18689_3.kt")
            public void testKt18689_3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_3.kt");
            }

            @Test
            @TestMetadata(value="kt18689_4.kt")
            public void testKt18689_4() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_4.kt");
            }

            @Test
            @TestMetadata(value="kt5685.kt")
            public void testKt5685() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt5685.kt");
            }

            @Test
            @TestMetadata(value="simpleDefaultMethod.kt")
            public void testSimpleDefaultMethod() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/simpleDefaultMethod.kt");
            }

            @Test
            @TestMetadata(value="varArgNoInline.kt")
            public void testVarArgNoInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/varArgNoInline.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/defaultValues/maskElimination")
            @TestDataPath(value="$PROJECT_ROOT")
            public class MaskElimination {
                @Test
                @TestMetadata(value="32Parameters.kt")
                public void test32Parameters() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/32Parameters.kt");
                }

                @Test
                @TestMetadata(value="33Parameters.kt")
                public void test33Parameters() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/33Parameters.kt");
                }

                @Test
                public void testAllFilesPresentInMaskElimination() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/maskElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="kt18792.kt")
                public void testKt18792() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt18792.kt");
                }

                @Test
                @TestMetadata(value="kt19679.kt")
                public void testKt19679() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679.kt");
                }

                @Test
                @TestMetadata(value="kt19679_2.kt")
                public void testKt19679_2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679_2.kt");
                }

                @Test
                @TestMetadata(value="kt19679_3.kt")
                public void testKt19679_3() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679_3.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/simple.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/defaultValues/lambdaInlining")
            @TestDataPath(value="$PROJECT_ROOT")
            public class LambdaInlining {
                @Test
                public void testAllFilesPresentInLambdaInlining() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="checkLambdaClassIsPresent.kt")
                public void testCheckLambdaClassIsPresent() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkLambdaClassIsPresent.kt");
                }

                @Test
                @TestMetadata(value="checkLambdaClassesArePresent.kt")
                public void testCheckLambdaClassesArePresent() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkLambdaClassesArePresent.kt");
                }

                @Test
                @TestMetadata(value="checkObjectClassIsPresent.kt")
                public void testCheckObjectClassIsPresent() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkObjectClassIsPresent.kt");
                }

                @Test
                @TestMetadata(value="checkStaticLambdaClassIsPresent.kt")
                public void testCheckStaticLambdaClassIsPresent() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticLambdaClassIsPresent.kt");
                }

                @Test
                @TestMetadata(value="checkStaticLambdaClassesArePresent.kt")
                public void testCheckStaticLambdaClassesArePresent() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticLambdaClassesArePresent.kt");
                }

                @Test
                @TestMetadata(value="checkStaticObjectClassIsPresent.kt")
                public void testCheckStaticObjectClassIsPresent() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticObjectClassIsPresent.kt");
                }

                @Test
                @TestMetadata(value="defaultAfterCapturing.kt")
                public void testDefaultAfterCapturing() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultAfterCapturing.kt");
                }

                @Test
                @TestMetadata(value="defaultCallInDefaultLambda.kt")
                public void testDefaultCallInDefaultLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultCallInDefaultLambda.kt");
                }

                @Test
                @TestMetadata(value="defaultLambdaInNoInline.kt")
                public void testDefaultLambdaInNoInline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultLambdaInNoInline.kt");
                }

                @Test
                @TestMetadata(value="differentInvokeSignature.kt")
                public void testDifferentInvokeSignature() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/differentInvokeSignature.kt");
                }

                @Test
                @TestMetadata(value="genericLambda.kt")
                public void testGenericLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/genericLambda.kt");
                }

                @Test
                @TestMetadata(value="instanceCapturedInClass.kt")
                public void testInstanceCapturedInClass() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/instanceCapturedInClass.kt");
                }

                @Test
                @TestMetadata(value="instanceCapturedInInterface.kt")
                public void testInstanceCapturedInInterface() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/instanceCapturedInInterface.kt");
                }

                @Test
                @TestMetadata(value="jvmStaticDefault.kt")
                public void testJvmStaticDefault() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/jvmStaticDefault.kt");
                }

                @Test
                @TestMetadata(value="kt21827.kt")
                public void testKt21827() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt21827.kt");
                }

                @Test
                @TestMetadata(value="kt21946.kt")
                public void testKt21946() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt21946.kt");
                }

                @Test
                @TestMetadata(value="kt24477.kt")
                public void testKt24477() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt24477.kt");
                }

                @Test
                @TestMetadata(value="kt25106.kt")
                public void testKt25106() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt25106.kt");
                }

                @Test
                @TestMetadata(value="kt26636.kt")
                public void testKt26636() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt26636.kt");
                }

                @Test
                @TestMetadata(value="lambdaTakesResult.kt")
                public void testLambdaTakesResult() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/lambdaTakesResult.kt");
                }

                @Test
                @TestMetadata(value="noInline.kt")
                public void testNoInline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/noInline.kt");
                }

                @Test
                @TestMetadata(value="nonDefaultInlineInNoInline.kt")
                public void testNonDefaultInlineInNoInline() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/nonDefaultInlineInNoInline.kt");
                }

                @Test
                @TestMetadata(value="receiverClash.kt")
                public void testReceiverClash() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClash.kt");
                }

                @Test
                @TestMetadata(value="receiverClash2.kt")
                public void testReceiverClash2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClash2.kt");
                }

                @Test
                @TestMetadata(value="receiverClashInClass.kt")
                public void testReceiverClashInClass() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClashInClass.kt");
                }

                @Test
                @TestMetadata(value="receiverClashInClass2.kt")
                public void testReceiverClashInClass2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClashInClass2.kt");
                }

                @Test
                @TestMetadata(value="reordering.kt")
                public void testReordering() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/reordering.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simple.kt");
                }

                @Test
                @TestMetadata(value="simpleErased.kt")
                public void testSimpleErased() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleErased.kt");
                }

                @Test
                @TestMetadata(value="simpleErasedStaticInstance.kt")
                public void testSimpleErasedStaticInstance() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleErasedStaticInstance.kt");
                }

                @Test
                @TestMetadata(value="simpleExtension.kt")
                public void testSimpleExtension() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleExtension.kt");
                }

                @Test
                @TestMetadata(value="simpleGeneric.kt")
                public void testSimpleGeneric() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleGeneric.kt");
                }

                @Test
                @TestMetadata(value="simpleStaticInstance.kt")
                public void testSimpleStaticInstance() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleStaticInstance.kt");
                }

                @Test
                @TestMetadata(value="thisClash.kt")
                public void testThisClash() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/thisClash.kt");
                }

                @Test
                @TestMetadata(value="thisClashInClass.kt")
                public void testThisClashInClass() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/thisClashInClass.kt");
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences")
                @TestDataPath(value="$PROJECT_ROOT")
                public class CallableReferences {
                    @Test
                    public void testAllFilesPresentInCallableReferences() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="boundFunctionReference.kt")
                    public void testBoundFunctionReference() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReference.kt");
                    }

                    @Test
                    @TestMetadata(value="boundFunctionReferenceOnInt.kt")
                    public void testBoundFunctionReferenceOnInt() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReferenceOnInt.kt");
                    }

                    @Test
                    @TestMetadata(value="boundFunctionReferenceOnLong.kt")
                    public void testBoundFunctionReferenceOnLong() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReferenceOnLong.kt");
                    }

                    @Test
                    @TestMetadata(value="boundInlineClassMethod.kt")
                    public void testBoundInlineClassMethod() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethod.kt");
                    }

                    @Test
                    @TestMetadata(value="boundInlineClassMethodWithAny.kt")
                    public void testBoundInlineClassMethodWithAny() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethodWithAny.kt");
                    }

                    @Test
                    @TestMetadata(value="boundInlineClassMethodWithInt.kt")
                    public void testBoundInlineClassMethodWithInt() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethodWithInt.kt");
                    }

                    @Test
                    @TestMetadata(value="boundPropertyReference.kt")
                    public void testBoundPropertyReference() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReference.kt");
                    }

                    @Test
                    @TestMetadata(value="boundPropertyReferenceOnInt.kt")
                    public void testBoundPropertyReferenceOnInt() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReferenceOnInt.kt");
                    }

                    @Test
                    @TestMetadata(value="boundPropertyReferenceOnLong.kt")
                    public void testBoundPropertyReferenceOnLong() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReferenceOnLong.kt");
                    }

                    @Test
                    @TestMetadata(value="constuctorReference.kt")
                    public void testConstuctorReference() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/constuctorReference.kt");
                    }

                    @Test
                    @TestMetadata(value="defaultAfterBoundReference.kt")
                    public void testDefaultAfterBoundReference() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/defaultAfterBoundReference.kt");
                    }

                    @Test
                    @TestMetadata(value="differentInvokeSignature.kt")
                    public void testDifferentInvokeSignature() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature.kt");
                    }

                    @Test
                    @TestMetadata(value="differentInvokeSignature2.kt")
                    public void testDifferentInvokeSignature2() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature2.kt");
                    }

                    @Test
                    @TestMetadata(value="differentInvokeSignature3.kt")
                    public void testDifferentInvokeSignature3() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature3.kt");
                    }

                    @Test
                    @TestMetadata(value="functionImportedFromObject.kt")
                    public void testFunctionImportedFromObject() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionImportedFromObject.kt");
                    }

                    @Test
                    @TestMetadata(value="functionReference.kt")
                    public void testFunctionReference() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReference.kt");
                    }

                    @Test
                    @TestMetadata(value="functionReferenceFromClass.kt")
                    public void testFunctionReferenceFromClass() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReferenceFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="functionReferenceFromObject.kt")
                    public void testFunctionReferenceFromObject() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReferenceFromObject.kt");
                    }

                    @Test
                    @TestMetadata(value="innerClassConstuctorReference.kt")
                    public void testInnerClassConstuctorReference() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/innerClassConstuctorReference.kt");
                    }

                    @Test
                    @TestMetadata(value="mutableBoundPropertyReferenceFromClass.kt")
                    public void testMutableBoundPropertyReferenceFromClass() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/mutableBoundPropertyReferenceFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="mutablePropertyReferenceFromClass.kt")
                    public void testMutablePropertyReferenceFromClass() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/mutablePropertyReferenceFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="privateFunctionReference.kt")
                    public void testPrivateFunctionReference() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/privateFunctionReference.kt");
                    }

                    @Test
                    @TestMetadata(value="privatePropertyReference.kt")
                    public void testPrivatePropertyReference() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/privatePropertyReference.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyImportedFromObject.kt")
                    public void testPropertyImportedFromObject() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyImportedFromObject.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyReference.kt")
                    public void testPropertyReference() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReference.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyReferenceFromClass.kt")
                    public void testPropertyReferenceFromClass() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReferenceFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyReferenceFromObject.kt")
                    public void testPropertyReferenceFromObject() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReferenceFromObject.kt");
                    }

                    @Test
                    @TestMetadata(value="withInlineClassParameter.kt")
                    public void testWithInlineClassParameter() {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/withInlineClassParameter.kt");
                    }
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/contracts")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Contracts {
            @Test
            public void testAllFilesPresentInContracts() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/contracts"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="cfgDependendValInitialization.kt")
            public void testCfgDependendValInitialization() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/cfgDependendValInitialization.kt");
            }

            @Test
            @TestMetadata(value="complexInitializer.kt")
            public void testComplexInitializer() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/complexInitializer.kt");
            }

            @Test
            @TestMetadata(value="complexInitializerWithStackTransformation.kt")
            public void testComplexInitializerWithStackTransformation() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/complexInitializerWithStackTransformation.kt");
            }

            @Test
            @TestMetadata(value="crossinlineCallableReference.kt")
            public void testCrossinlineCallableReference() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/crossinlineCallableReference.kt");
            }

            @Test
            @TestMetadata(value="definiteLongValInitialization.kt")
            public void testDefiniteLongValInitialization() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/definiteLongValInitialization.kt");
            }

            @Test
            @TestMetadata(value="definiteNestedValInitialization.kt")
            public void testDefiniteNestedValInitialization() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/definiteNestedValInitialization.kt");
            }

            @Test
            @TestMetadata(value="definiteValInitInInitializer.kt")
            public void testDefiniteValInitInInitializer() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/definiteValInitInInitializer.kt");
            }

            @Test
            @TestMetadata(value="definiteValInitialization.kt")
            public void testDefiniteValInitialization() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/definiteValInitialization.kt");
            }

            @Test
            @TestMetadata(value="exactlyOnceCrossinline.kt")
            public void testExactlyOnceCrossinline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceCrossinline.kt");
            }

            @Test
            @TestMetadata(value="exactlyOnceCrossinline2.kt")
            public void testExactlyOnceCrossinline2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceCrossinline2.kt");
            }

            @Test
            @TestMetadata(value="exactlyOnceNoinline.kt")
            public void testExactlyOnceNoinline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceNoinline.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn.kt")
            public void testNonLocalReturn() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/nonLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturnWithCycle.kt")
            public void testNonLocalReturnWithCycle() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/nonLocalReturnWithCycle.kt");
            }

            @Test
            @TestMetadata(value="propertyInitialization.kt")
            public void testPropertyInitialization() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/propertyInitialization.kt");
            }

            @Test
            @TestMetadata(value="valInitializationAndUsageInNestedLambda.kt")
            public void testValInitializationAndUsageInNestedLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/valInitializationAndUsageInNestedLambda.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/complexStack")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ComplexStack {
            @Test
            public void testAllFilesPresentInComplexStack() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/complexStack"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="asCheck.kt")
            public void testAsCheck() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/asCheck.kt");
            }

            @Test
            @TestMetadata(value="asCheck2.kt")
            public void testAsCheck2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/asCheck2.kt");
            }

            @Test
            @TestMetadata(value="breakContinueInInlineLambdaArgument.kt")
            public void testBreakContinueInInlineLambdaArgument() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/breakContinueInInlineLambdaArgument.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simple.kt");
            }

            @Test
            @TestMetadata(value="simple2.kt")
            public void testSimple2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simple2.kt");
            }

            @Test
            @TestMetadata(value="simple3.kt")
            public void testSimple3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simple3.kt");
            }

            @Test
            @TestMetadata(value="simple4.kt")
            public void testSimple4() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simple4.kt");
            }

            @Test
            @TestMetadata(value="simpleExtension.kt")
            public void testSimpleExtension() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simpleExtension.kt");
            }

            @Test
            @TestMetadata(value="spillConstructorArgumentsAndInlineLambdaParameter.kt")
            public void testSpillConstructorArgumentsAndInlineLambdaParameter() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/spillConstructorArgumentsAndInlineLambdaParameter.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/complex")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Complex {
            @Test
            public void testAllFilesPresentInComplex() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/complex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="closureChain.kt")
            public void testClosureChain() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/closureChain.kt");
            }

            @Test
            @TestMetadata(value="forEachLine.kt")
            public void testForEachLine() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/forEachLine.kt");
            }

            @Test
            @TestMetadata(value="kt44429.kt")
            public void testKt44429() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/kt44429.kt");
            }

            @Test
            @TestMetadata(value="kt44429MustFail.kt")
            public void testKt44429MustFail() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/kt44429MustFail.kt");
            }

            @Test
            @TestMetadata(value="lambdaInLambda.kt")
            public void testLambdaInLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/lambdaInLambda.kt");
            }

            @Test
            @TestMetadata(value="nestedCallsWithGeneric.kt")
            public void testNestedCallsWithGeneric() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/nestedCallsWithGeneric.kt");
            }

            @Test
            @TestMetadata(value="nestedCallsWithGenericToInt.kt")
            public void testNestedCallsWithGenericToInt() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/nestedCallsWithGenericToInt.kt");
            }

            @Test
            @TestMetadata(value="swapAndWith.kt")
            public void testSwapAndWith() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/swapAndWith.kt");
            }

            @Test
            @TestMetadata(value="swapAndWith2.kt")
            public void testSwapAndWith2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/swapAndWith2.kt");
            }

            @Test
            @TestMetadata(value="use.kt")
            public void testUse() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/use.kt");
            }

            @Test
            @TestMetadata(value="with.kt")
            public void testWith() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/with.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/capture")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Capture {
            @Test
            public void testAllFilesPresentInCapture() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/capture"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="captureInlinable.kt")
            public void testCaptureInlinable() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/captureInlinable.kt");
            }

            @Test
            @TestMetadata(value="captureInlinableAndOther.kt")
            public void testCaptureInlinableAndOther() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/captureInlinableAndOther.kt");
            }

            @Test
            @TestMetadata(value="captureThisAndReceiver.kt")
            public void testCaptureThisAndReceiver() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/captureThisAndReceiver.kt");
            }

            @Test
            @TestMetadata(value="generics.kt")
            public void testGenerics() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/generics.kt");
            }

            @Test
            @TestMetadata(value="kt48230.kt")
            public void testKt48230() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt48230.kt");
            }

            @Test
            @TestMetadata(value="kt48230_2.kt")
            public void testKt48230_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt48230_2.kt");
            }

            @Test
            @TestMetadata(value="kt56500.kt")
            public void testKt56500() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt56500.kt");
            }

            @Test
            @TestMetadata(value="kt56965.kt")
            public void testKt56965() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt56965.kt");
            }

            @Test
            @TestMetadata(value="kt56965_2.kt")
            public void testKt56965_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt56965_2.kt");
            }

            @Test
            @TestMetadata(value="simpleCapturingInClass.kt")
            public void testSimpleCapturingInClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/simpleCapturingInClass.kt");
            }

            @Test
            @TestMetadata(value="simpleCapturingInPackage.kt")
            public void testSimpleCapturingInPackage() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/simpleCapturingInPackage.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/callableReference")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CallableReference {
            @Test
            @TestMetadata(value="adapted.kt")
            public void testAdapted() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adapted.kt");
            }

            @Test
            public void testAllFilesPresentInCallableReference() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classLevel.kt")
            public void testClassLevel() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/classLevel.kt");
            }

            @Test
            @TestMetadata(value="classLevel2.kt")
            public void testClassLevel2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/classLevel2.kt");
            }

            @Test
            @TestMetadata(value="constructor.kt")
            public void testConstructor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/constructor.kt");
            }

            @Test
            @TestMetadata(value="inlineCallableReference.kt")
            public void testInlineCallableReference() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/inlineCallableReference.kt");
            }

            @Test
            @TestMetadata(value="innerGenericConstuctor.kt")
            public void testInnerGenericConstuctor() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/innerGenericConstuctor.kt");
            }

            @Test
            @TestMetadata(value="intrinsic.kt")
            public void testIntrinsic() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/intrinsic.kt");
            }

            @Test
            @TestMetadata(value="jvmFieldProperty.kt")
            public void testJvmFieldProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/jvmFieldProperty.kt");
            }

            @Test
            @TestMetadata(value="kt15449.kt")
            public void testKt15449() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/kt15449.kt");
            }

            @Test
            @TestMetadata(value="kt15751_2.kt")
            public void testKt15751_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/kt15751_2.kt");
            }

            @Test
            @TestMetadata(value="kt16411.kt")
            public void testKt16411() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/kt16411.kt");
            }

            @Test
            @TestMetadata(value="kt35101.kt")
            public void testKt35101() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/kt35101.kt");
            }

            @Test
            @TestMetadata(value="propertyIntrinsic.kt")
            public void testPropertyIntrinsic() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/propertyIntrinsic.kt");
            }

            @Test
            @TestMetadata(value="propertyReference.kt")
            public void testPropertyReference() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/propertyReference.kt");
            }

            @Test
            @TestMetadata(value="topLevel.kt")
            public void testTopLevel() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/topLevel.kt");
            }

            @Test
            @TestMetadata(value="topLevelExtension.kt")
            public void testTopLevelExtension() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/topLevelExtension.kt");
            }

            @Test
            @TestMetadata(value="topLevelProperty.kt")
            public void testTopLevelProperty() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/topLevelProperty.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/callableReference/bound")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Bound {
                @Test
                public void testAllFilesPresentInBound() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="classProperty.kt")
                public void testClassProperty() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/classProperty.kt");
                }

                @Test
                @TestMetadata(value="doubleBoundToThis.kt")
                public void testDoubleBoundToThis() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/doubleBoundToThis.kt");
                }

                @Test
                @TestMetadata(value="emptyLhsFunction.kt")
                public void testEmptyLhsFunction() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsFunction.kt");
                }

                @Test
                @TestMetadata(value="emptyLhsOnInlineProperty.kt")
                public void testEmptyLhsOnInlineProperty() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsOnInlineProperty.kt");
                }

                @Test
                @TestMetadata(value="emptyLhsProperty.kt")
                public void testEmptyLhsProperty() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsProperty.kt");
                }

                @Test
                @TestMetadata(value="expression.kt")
                public void testExpression() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/expression.kt");
                }

                @Test
                @TestMetadata(value="extensionReceiver.kt")
                public void testExtensionReceiver() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/extensionReceiver.kt");
                }

                @Test
                @TestMetadata(value="filter.kt")
                public void testFilter() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/filter.kt");
                }

                @Test
                @TestMetadata(value="inlineValueParameterInsteadOfReceiver.kt")
                public void testInlineValueParameterInsteadOfReceiver() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/inlineValueParameterInsteadOfReceiver.kt");
                }

                @Test
                @TestMetadata(value="innerGenericConstuctor.kt")
                public void testInnerGenericConstuctor() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/innerGenericConstuctor.kt");
                }

                @Test
                @TestMetadata(value="intrinsic.kt")
                public void testIntrinsic() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/intrinsic.kt");
                }

                @Test
                @TestMetadata(value="jvmFieldProperty.kt")
                public void testJvmFieldProperty() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/jvmFieldProperty.kt");
                }

                @Test
                @TestMetadata(value="kt18728.kt")
                public void testKt18728() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728.kt");
                }

                @Test
                @TestMetadata(value="kt18728_2.kt")
                public void testKt18728_2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_2.kt");
                }

                @Test
                @TestMetadata(value="kt18728_3.kt")
                public void testKt18728_3() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_3.kt");
                }

                @Test
                @TestMetadata(value="kt18728_4.kt")
                public void testKt18728_4() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_4.kt");
                }

                @Test
                @TestMetadata(value="kt30933.kt")
                public void testKt30933() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt30933.kt");
                }

                @Test
                @TestMetadata(value="lambdaOnLhs.kt")
                public void testLambdaOnLhs() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/lambdaOnLhs.kt");
                }

                @Test
                @TestMetadata(value="map.kt")
                public void testMap() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/map.kt");
                }

                @Test
                @TestMetadata(value="mixed.kt")
                public void testMixed() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/mixed.kt");
                }

                @Test
                @TestMetadata(value="objectProperty.kt")
                public void testObjectProperty() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/objectProperty.kt");
                }

                @Test
                @TestMetadata(value="propertyImportedFromObject.kt")
                public void testPropertyImportedFromObject() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/propertyImportedFromObject.kt");
                }

                @Test
                @TestMetadata(value="sideEffect.kt")
                public void testSideEffect() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/sideEffect.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/simple.kt");
                }

                @Test
                @TestMetadata(value="simpleVal.kt")
                public void testSimpleVal() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/simpleVal.kt");
                }

                @Test
                @TestMetadata(value="simpleVal2.kt")
                public void testSimpleVal2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/simpleVal2.kt");
                }

                @Test
                @TestMetadata(value="topLevelExtensionProperty.kt")
                public void testTopLevelExtensionProperty() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/topLevelExtensionProperty.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/callableReference/adaptedReferences")
            @TestDataPath(value="$PROJECT_ROOT")
            public class AdaptedReferences {
                @Test
                public void testAllFilesPresentInAdaptedReferences() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference/adaptedReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineBound.kt")
                public void testInlineBound() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineBound.kt");
                }

                @Test
                @TestMetadata(value="inlineDefault.kt")
                public void testInlineDefault() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineDefault.kt");
                }

                @Test
                @TestMetadata(value="inlineVararg.kt")
                public void testInlineVararg() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVararg.kt");
                }

                @Test
                @TestMetadata(value="inlineVarargAndDefault.kt")
                public void testInlineVarargAndDefault() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVarargAndDefault.kt");
                }

                @Test
                @TestMetadata(value="inlineVarargInts.kt")
                public void testInlineVarargInts() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVarargInts.kt");
                }

                @Test
                @TestMetadata(value="multipleCallableReferenceUsage.kt")
                public void testMultipleCallableReferenceUsage() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/multipleCallableReferenceUsage.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/bytecodePreprocessing")
        @TestDataPath(value="$PROJECT_ROOT")
        public class BytecodePreprocessing {
            @Test
            public void testAllFilesPresentInBytecodePreprocessing() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/bytecodePreprocessing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="apiVersionAtLeast1.kt")
            public void testApiVersionAtLeast1() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/bytecodePreprocessing/apiVersionAtLeast1.kt");
            }

            @Test
            @TestMetadata(value="inlineApiVersionAtLeastInStdlibInlineFunction.kt")
            public void testInlineApiVersionAtLeastInStdlibInlineFunction() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/bytecodePreprocessing/inlineApiVersionAtLeastInStdlibInlineFunction.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/builders")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Builders {
            @Test
            public void testAllFilesPresentInBuilders() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/builders"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="builders.kt")
            public void testBuilders() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/builders/builders.kt");
            }

            @Test
            @TestMetadata(value="buildersAndLambdaCapturing.kt")
            public void testBuildersAndLambdaCapturing() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/builders/buildersAndLambdaCapturing.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/assert")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Assert {
            @Test
            public void testAllFilesPresentInAssert() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="jvmAssertInlineFunctionAssertionsDisabled.kt")
            public void testJvmAssertInlineFunctionAssertionsDisabled() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineFunctionAssertionsDisabled.kt");
            }

            @Test
            @TestMetadata(value="jvmAssertInlineFunctionAssertionsEnabled.kt")
            public void testJvmAssertInlineFunctionAssertionsEnabled() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineFunctionAssertionsEnabled.kt");
            }

            @Test
            @TestMetadata(value="jvmAssertInlineLambda.kt")
            public void testJvmAssertInlineLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="jvmClassInitializer.kt")
            public void testJvmClassInitializer() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmClassInitializer.kt");
            }

            @Test
            @TestMetadata(value="jvmCompanion.kt")
            public void testJvmCompanion() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCompanion.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineLambda.kt")
            public void testJvmCrossinlineLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambda.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineLambda2.kt")
            public void testJvmCrossinlineLambda2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambda2.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineLambdaDeclarationSite.kt")
            public void testJvmCrossinlineLambdaDeclarationSite() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambdaDeclarationSite.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineLambdaDeclarationSiteOnly.kt")
            public void testJvmCrossinlineLambdaDeclarationSiteOnly() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambdaDeclarationSiteOnly.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineRedundant.kt")
            public void testJvmCrossinlineRedundant() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineRedundant.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineSAMDeclarationSite.kt")
            public void testJvmCrossinlineSAMDeclarationSite() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineSAMDeclarationSite.kt");
            }

            @Test
            @TestMetadata(value="jvmDoubleInline.kt")
            public void testJvmDoubleInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmDoubleInline.kt");
            }

            @Test
            @TestMetadata(value="jvmInlineIntoTwoMethods.kt")
            public void testJvmInlineIntoTwoMethods() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmInlineIntoTwoMethods.kt");
            }

            @Test
            @TestMetadata(value="jvmInlineUsedAsNoinline.kt")
            public void testJvmInlineUsedAsNoinline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmInlineUsedAsNoinline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/arrayConvention")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ArrayConvention {
            @Test
            public void testAllFilesPresentInArrayConvention() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/arrayConvention"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="simpleAccess.kt")
            public void testSimpleAccess() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccess.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessInClass.kt")
            public void testSimpleAccessInClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessInClass.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessWithDefault.kt")
            public void testSimpleAccessWithDefault() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithDefault.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessWithDefaultInClass.kt")
            public void testSimpleAccessWithDefaultInClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithDefaultInClass.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessWithLambda.kt")
            public void testSimpleAccessWithLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithLambda.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessWithLambdaInClass.kt")
            public void testSimpleAccessWithLambdaInClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithLambdaInClass.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/argumentOrder")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ArgumentOrder {
            @Test
            public void testAllFilesPresentInArgumentOrder() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="boundFunctionReference.kt")
            public void testBoundFunctionReference() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/boundFunctionReference.kt");
            }

            @Test
            @TestMetadata(value="boundFunctionReference2.kt")
            public void testBoundFunctionReference2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/boundFunctionReference2.kt");
            }

            @Test
            @TestMetadata(value="captured.kt")
            public void testCaptured() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/captured.kt");
            }

            @Test
            @TestMetadata(value="capturedInExtension.kt")
            public void testCapturedInExtension() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/capturedInExtension.kt");
            }

            @Test
            @TestMetadata(value="defaultParametersAndLastVararg.kt")
            public void testDefaultParametersAndLastVararg() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/defaultParametersAndLastVararg.kt");
            }

            @Test
            @TestMetadata(value="defaultParametersAndLastVarargWithCorrectOrder.kt")
            public void testDefaultParametersAndLastVarargWithCorrectOrder() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/defaultParametersAndLastVarargWithCorrectOrder.kt");
            }

            @Test
            @TestMetadata(value="extension.kt")
            public void testExtension() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/extension.kt");
            }

            @Test
            @TestMetadata(value="extensionInClass.kt")
            public void testExtensionInClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/extensionInClass.kt");
            }

            @Test
            @TestMetadata(value="lambdaMigration.kt")
            public void testLambdaMigration() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/lambdaMigration.kt");
            }

            @Test
            @TestMetadata(value="lambdaMigrationInClass.kt")
            public void testLambdaMigrationInClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/lambdaMigrationInClass.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/simple.kt");
            }

            @Test
            @TestMetadata(value="simpleInClass.kt")
            public void testSimpleInClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/simpleInClass.kt");
            }

            @Test
            @TestMetadata(value="varargAndDefaultParameters.kt")
            public void testVarargAndDefaultParameters() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/varargAndDefaultParameters.kt");
            }

            @Test
            @TestMetadata(value="varargAndDefaultParametersWithCorrectOrder.kt")
            public void testVarargAndDefaultParametersWithCorrectOrder() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/varargAndDefaultParametersWithCorrectOrder.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject")
        @TestDataPath(value="$PROJECT_ROOT")
        public class AnonymousObject {
            @Test
            public void testAllFilesPresentInAnonymousObject() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="anonymousObjectInCallChildren.kt")
            public void testAnonymousObjectInCallChildren() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectInCallChildren.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectInDefault.kt")
            public void testAnonymousObjectInDefault() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectInDefault.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectOnCallSite.kt")
            public void testAnonymousObjectOnCallSite() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnCallSite.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectOnCallSiteSuperParams.kt")
            public void testAnonymousObjectOnCallSiteSuperParams() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnCallSiteSuperParams.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectOnDeclarationSite.kt")
            public void testAnonymousObjectOnDeclarationSite() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnDeclarationSite.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectOnDeclarationSiteSuperParams.kt")
            public void testAnonymousObjectOnDeclarationSiteSuperParams() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnDeclarationSiteSuperParams.kt");
            }

            @Test
            @TestMetadata(value="capturedLambdaInInline.kt")
            public void testCapturedLambdaInInline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline.kt");
            }

            @Test
            @TestMetadata(value="capturedLambdaInInline2.kt")
            public void testCapturedLambdaInInline2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline2.kt");
            }

            @Test
            @TestMetadata(value="capturedLambdaInInline3.kt")
            public void testCapturedLambdaInInline3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline3.kt");
            }

            @Test
            @TestMetadata(value="capturedLambdaInInlineObject.kt")
            public void testCapturedLambdaInInlineObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInlineObject.kt");
            }

            @Test
            @TestMetadata(value="capturedLocalFun.kt")
            public void testCapturedLocalFun() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLocalFun.kt");
            }

            @Test
            @TestMetadata(value="capturedLocalFunRef.kt")
            public void testCapturedLocalFunRef() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLocalFunRef.kt");
            }

            @Test
            @TestMetadata(value="changingReturnType.kt")
            public void testChangingReturnType() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/changingReturnType.kt");
            }

            @Test
            @TestMetadata(value="constructOriginalInRegenerated.kt")
            public void testConstructOriginalInRegenerated() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/constructOriginalInRegenerated.kt");
            }

            @Test
            @TestMetadata(value="constructorVisibility.kt")
            public void testConstructorVisibility() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibility.kt");
            }

            @Test
            @TestMetadata(value="constructorVisibilityInConstLambda.kt")
            public void testConstructorVisibilityInConstLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibilityInConstLambda.kt");
            }

            @Test
            @TestMetadata(value="constructorVisibilityInLambda.kt")
            public void testConstructorVisibilityInLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibilityInLambda.kt");
            }

            @Test
            @TestMetadata(value="defineClass.kt")
            public void testDefineClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/defineClass.kt");
            }

            @Test
            @TestMetadata(value="fakeOverrideInDefaultMultiModule.kt")
            public void testFakeOverrideInDefaultMultiModule() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/fakeOverrideInDefaultMultiModule.kt");
            }

            @Test
            @TestMetadata(value="fakeOverrideMultiModule.kt")
            public void testFakeOverrideMultiModule() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/fakeOverrideMultiModule.kt");
            }

            @Test
            @TestMetadata(value="functionExpression.kt")
            public void testFunctionExpression() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/functionExpression.kt");
            }

            @Test
            @TestMetadata(value="inlineCallInsideInlineLambda.kt")
            public void testInlineCallInsideInlineLambda() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/inlineCallInsideInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="kt13133.kt")
            public void testKt13133() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13133.kt");
            }

            @Test
            @TestMetadata(value="kt13182.kt")
            public void testKt13182() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13182.kt");
            }

            @Test
            @TestMetadata(value="kt13374.kt")
            public void testKt13374() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13374.kt");
            }

            @Test
            @TestMetadata(value="kt14011.kt")
            public void testKt14011() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011.kt");
            }

            @Test
            @TestMetadata(value="kt14011_2.kt")
            public void testKt14011_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011_2.kt");
            }

            @Test
            @TestMetadata(value="kt14011_3.kt")
            public void testKt14011_3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011_3.kt");
            }

            @Test
            @TestMetadata(value="kt15751.kt")
            public void testKt15751() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt15751.kt");
            }

            @Test
            @TestMetadata(value="kt16193.kt")
            public void testKt16193() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt16193.kt");
            }

            @Test
            @TestMetadata(value="kt17972.kt")
            public void testKt17972() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972.kt");
            }

            @Test
            @TestMetadata(value="kt17972_2.kt")
            public void testKt17972_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_2.kt");
            }

            @Test
            @TestMetadata(value="kt17972_3.kt")
            public void testKt17972_3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_3.kt");
            }

            @Test
            @TestMetadata(value="kt17972_4.kt")
            public void testKt17972_4() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_4.kt");
            }

            @Test
            @TestMetadata(value="kt17972_5.kt")
            public void testKt17972_5() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_5.kt");
            }

            @Test
            @TestMetadata(value="kt17972_super.kt")
            public void testKt17972_super() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super.kt");
            }

            @Test
            @TestMetadata(value="kt17972_super2.kt")
            public void testKt17972_super2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super2.kt");
            }

            @Test
            @TestMetadata(value="kt17972_super3.kt")
            public void testKt17972_super3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super3.kt");
            }

            @Test
            @TestMetadata(value="kt19389.kt")
            public void testKt19389() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19389.kt");
            }

            @Test
            @TestMetadata(value="kt19399.kt")
            public void testKt19399() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19399.kt");
            }

            @Test
            @TestMetadata(value="kt19434.kt")
            public void testKt19434() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19434.kt");
            }

            @Test
            @TestMetadata(value="kt19434_2.kt")
            public void testKt19434_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19434_2.kt");
            }

            @Test
            @TestMetadata(value="kt19723.kt")
            public void testKt19723() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19723.kt");
            }

            @Test
            @TestMetadata(value="kt29595.kt")
            public void testKt29595() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt29595.kt");
            }

            @Test
            @TestMetadata(value="kt30696.kt")
            public void testKt30696() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt30696.kt");
            }

            @Test
            @TestMetadata(value="kt34656.kt")
            public void testKt34656() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt34656.kt");
            }

            @Test
            @TestMetadata(value="kt38197.kt")
            public void testKt38197() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt38197.kt");
            }

            @Test
            @TestMetadata(value="kt41174.kt")
            public void testKt41174() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt41174.kt");
            }

            @Test
            @TestMetadata(value="kt42815.kt")
            public void testKt42815() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt42815.kt");
            }

            @Test
            @TestMetadata(value="kt42815_delegated.kt")
            public void testKt42815_delegated() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt42815_delegated.kt");
            }

            @Test
            @TestMetadata(value="kt51950.kt")
            public void testKt51950() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt51950.kt");
            }

            @Test
            @TestMetadata(value="kt52795.kt")
            public void testKt52795() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795.kt");
            }

            @Test
            @TestMetadata(value="kt52795_2.kt")
            public void testKt52795_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_2.kt");
            }

            @Test
            @TestMetadata(value="kt52795_3.kt")
            public void testKt52795_3() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_3.kt");
            }

            @Test
            @TestMetadata(value="kt52795_4.kt")
            public void testKt52795_4() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_4.kt");
            }

            @Test
            @TestMetadata(value="kt52795_5.kt")
            public void testKt52795_5() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_5.kt");
            }

            @Test
            @TestMetadata(value="kt57053.kt")
            public void testKt57053() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt57053.kt");
            }

            @Test
            @TestMetadata(value="kt6007.kt")
            public void testKt6007() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt6007.kt");
            }

            @Test
            @TestMetadata(value="kt6552.kt")
            public void testKt6552() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt6552.kt");
            }

            @Test
            @TestMetadata(value="kt8133.kt")
            public void testKt8133() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt8133.kt");
            }

            @Test
            @TestMetadata(value="kt9064.kt")
            public void testKt9064() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9064.kt");
            }

            @Test
            @TestMetadata(value="kt9064v2.kt")
            public void testKt9064v2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9064v2.kt");
            }

            @Test
            @TestMetadata(value="kt9591.kt")
            public void testKt9591() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9591.kt");
            }

            @Test
            @TestMetadata(value="kt9877.kt")
            public void testKt9877() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9877.kt");
            }

            @Test
            @TestMetadata(value="kt9877_2.kt")
            public void testKt9877_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9877_2.kt");
            }

            @Test
            @TestMetadata(value="objectInLambdaCapturesAnotherObject.kt")
            public void testObjectInLambdaCapturesAnotherObject() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/objectInLambdaCapturesAnotherObject.kt");
            }

            @Test
            @TestMetadata(value="safeCall.kt")
            public void testSafeCall() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/safeCall.kt");
            }

            @Test
            @TestMetadata(value="safeCall_2.kt")
            public void testSafeCall_2() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/safeCall_2.kt");
            }

            @Test
            @TestMetadata(value="sam.kt")
            public void testSam() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam.kt");
            }

            @Test
            @TestMetadata(value="sharedFromCrossinline.kt")
            public void testSharedFromCrossinline() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sharedFromCrossinline.kt");
            }

            @Test
            @TestMetadata(value="superConstructorWithObjectParameter.kt")
            public void testSuperConstructorWithObjectParameter() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/superConstructorWithObjectParameter.kt");
            }

            @Test
            @TestMetadata(value="typeInfo.kt")
            public void testTypeInfo() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/typeInfo.kt");
            }

            @Test
            @TestMetadata(value="withInlineMethod.kt")
            public void testWithInlineMethod() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/withInlineMethod.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers")
            @TestDataPath(value="$PROJECT_ROOT")
            public class TwoCapturedReceivers {
                @Test
                public void testAllFilesPresentInTwoCapturedReceivers() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="kt8668.kt")
                public void testKt8668() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668.kt");
                }

                @Test
                @TestMetadata(value="kt8668_2.kt")
                public void testKt8668_2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_2.kt");
                }

                @Test
                @TestMetadata(value="kt8668_3.kt")
                public void testKt8668_3() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_3.kt");
                }

                @Test
                @TestMetadata(value="kt8668_nested.kt")
                public void testKt8668_nested() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_nested.kt");
                }

                @Test
                @TestMetadata(value="kt8668_nested_2.kt")
                public void testKt8668_nested_2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_nested_2.kt");
                }

                @Test
                @TestMetadata(value="twoDifferentDispatchReceivers.kt")
                public void testTwoDifferentDispatchReceivers() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/twoDifferentDispatchReceivers.kt");
                }

                @Test
                @TestMetadata(value="twoExtensionReceivers.kt")
                public void testTwoExtensionReceivers() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/twoExtensionReceivers.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/sam")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Sam {
                @Test
                public void testAllFilesPresentInSam() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="anonymousObjectToSam.kt")
                public void testAnonymousObjectToSam() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/anonymousObjectToSam.kt");
                }

                @Test
                @TestMetadata(value="kt17091.kt")
                public void testKt17091() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt17091.kt");
                }

                @Test
                @TestMetadata(value="kt21671.kt")
                public void testKt21671() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671.kt");
                }

                @Test
                @TestMetadata(value="kt21671_2.kt")
                public void testKt21671_2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671_2.kt");
                }

                @Test
                @TestMetadata(value="kt21671_3.kt")
                public void testKt21671_3() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671_3.kt");
                }

                @Test
                @TestMetadata(value="kt22304.kt")
                public void testKt22304() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt22304.kt");
                }

                @Test
                @TestMetadata(value="samOnCallSite.kt")
                public void testSamOnCallSite() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/samOnCallSite.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ProperRecapturingInClass {
                @Test
                public void testAllFilesPresentInProperRecapturingInClass() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineChain.kt")
                public void testInlineChain() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/inlineChain.kt");
                }

                @Test
                @TestMetadata(value="inlinelambdaChain.kt")
                public void testInlinelambdaChain() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/inlinelambdaChain.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain.kt")
                public void testLambdaChain() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain.kt");
                }

                @Test
                @TestMetadata(value="lambdaChainSimple.kt")
                public void testLambdaChainSimple() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChainSimple.kt");
                }

                @Test
                @TestMetadata(value="lambdaChainSimple_2.kt")
                public void testLambdaChainSimple_2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChainSimple_2.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain_2.kt")
                public void testLambdaChain_2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain_2.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain_3.kt")
                public void testLambdaChain_3() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain_3.kt");
                }

                @Test
                @TestMetadata(value="noCapturedThisOnCallSite.kt")
                public void testNoCapturedThisOnCallSite() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/noCapturedThisOnCallSite.kt");
                }

                @Test
                @TestMetadata(value="noInlineLambda.kt")
                public void testNoInlineLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/noInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="twoInlineLambda.kt")
                public void testTwoInlineLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="twoInlineLambdaComplex.kt")
                public void testTwoInlineLambdaComplex() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambdaComplex.kt");
                }

                @Test
                @TestMetadata(value="twoInlineLambdaComplex_2.kt")
                public void testTwoInlineLambdaComplex_2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambdaComplex_2.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/properRecapturing")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ProperRecapturing {
                @Test
                public void testAllFilesPresentInProperRecapturing() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineChain.kt")
                public void testInlineChain() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/inlineChain.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain.kt")
                public void testLambdaChain() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain.kt");
                }

                @Test
                @TestMetadata(value="lambdaChainSimple.kt")
                public void testLambdaChainSimple() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChainSimple.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain_2.kt")
                public void testLambdaChain_2() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain_2.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain_3.kt")
                public void testLambdaChain_3() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain_3.kt");
                }

                @Test
                @TestMetadata(value="noInlineLambda.kt")
                public void testNoInlineLambda() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/noInlineLambda.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/enumWhen")
            @TestDataPath(value="$PROJECT_ROOT")
            public class EnumWhen {
                @Test
                public void testAllFilesPresentInEnumWhen() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/enumWhen"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="callSite.kt")
                public void testCallSite() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/callSite.kt");
                }

                @Test
                @TestMetadata(value="declSite.kt")
                public void testDeclSite() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSite.kt");
                }

                @Test
                @TestMetadata(value="declSiteSeveralMappings.kt")
                public void testDeclSiteSeveralMappings() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSiteSeveralMappings.kt");
                }

                @Test
                @TestMetadata(value="declSiteSeveralMappingsDifOrder.kt")
                public void testDeclSiteSeveralMappingsDifOrder() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSiteSeveralMappingsDifOrder.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/enumEntries")
            @TestDataPath(value="$PROJECT_ROOT")
            public class EnumEntries {
                @Test
                public void testAllFilesPresentInEnumEntries() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/enumEntries"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="callSite.kt")
                public void testCallSite() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/callSite.kt");
                }

                @Test
                @TestMetadata(value="declSite.kt")
                public void testDeclSite() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/declSite.kt");
                }

                @Test
                @TestMetadata(value="declSiteSeveralMappings.kt")
                public void testDeclSiteSeveralMappings() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/declSiteSeveralMappings.kt");
                }

                @Test
                @TestMetadata(value="declSiteSeveralMappingsDifOrder.kt")
                public void testDeclSiteSeveralMappingsDifOrder() {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/declSiteSeveralMappingsDifOrder.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/annotations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Annotations {
            @Test
            public void testAllFilesPresentInAnnotations() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="annotationInstanceInlining.kt")
            public void testAnnotationInstanceInlining() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/annotations/annotationInstanceInlining.kt");
            }

            @Test
            @TestMetadata(value="instanceInAnonymousClass.kt")
            public void testInstanceInAnonymousClass() {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/annotations/instanceInAnonymousClass.kt");
            }
        }
    }
}

