/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeOptions;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.AbstractIrHandler;
import org.jetbrains.kotlin.test.backend.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.test.backend.handlers.IrTextDumpHandler;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.BackendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 .2\u00020\u0001:\u0001.B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0016J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0014\u0010\"\u001a\u00020#*\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001bH\u0016J\u0018\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020&H\u0002J\u0016\u0010,\u001a\u00020&*\u00020\u001f2\b\b\u0002\u0010-\u001a\u00020\u001bH\u0002R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR0\u0010\u000e\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u0011j\b\u0012\u0004\u0012\u00020\u0010`\u000f0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u00060\u0019j\u0002`\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/AbstractIrHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "artifactKind", "Lorg/jetbrains/kotlin/test/model/BackendKind;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/test/model/BackendKind;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "additionalAfterAnalysisCheckers", "Lorg/jetbrains/kotlin/test/Constructor;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "Lkotlin/Function1;", "getAdditionalAfterAnalysisCheckers", "baseDumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "buildersForSeparateFileDumps", "", "Ljava/io/File;", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "byteCodeListingEnabled", "", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "compareDumpsOfExternalClasses", "findExternalClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "externalClassId", "", "processAfterAllModules", "someAssertionWasFailed", "checkOneExpectedFile", "expectedFile", "actualDump", "getDumpExtension", "ignoreFirIdentical", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nIrTextDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTextDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1557#2:169\n1628#2,3:170\n1863#2,2:173\n*S KotlinDebug\n*F\n+ 1 IrTextDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler\n*L\n131#1:169\n131#1:170,3\n152#1:173,2\n*E\n"})
public final class IrTextDumpHandler
extends AbstractIrHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiModuleInfoDumper baseDumper;
    @NotNull
    private final Map<File, StringBuilder> buildersForSeparateFileDumps;
    private boolean byteCodeListingEnabled;
    @NotNull
    public static final String DUMP_EXTENSION = "ir.txt";
    @NotNull
    public static final String DUMP_EXTENSION2 = "ir2.txt";
    @NotNull
    private static final Set<Name> HIDDEN_ENUM_METHOD_NAMES;

    public IrTextDumpHandler(@NotNull TestServices testServices, @NotNull BackendKind<IrBackendInput> artifactKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(artifactKind, (String)"artifactKind");
        super(testServices, artifactKind, false, false, 12, null);
        this.baseDumper = new MultiModuleInfoDumper(null, 1, null);
        this.buildersForSeparateFileDumps = new LinkedHashMap();
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        Object[] objectArray = new SimpleDirectivesContainer[]{CodegenTestDirectives.INSTANCE, FirDiagnosticsDirectives.INSTANCE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Function1<TestServices, AfterAnalysisChecker>> getAdditionalAfterAnalysisCheckers() {
        return CollectionsKt.listOf((Object)((Object)additionalAfterAnalysisCheckers.1.INSTANCE));
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull IrBackendInput info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        boolean bl = this.byteCodeListingEnabled = this.byteCodeListingEnabled || module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getCHECK_BYTECODE_LISTING());
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_IR())) {
            return;
        }
        IrBuiltIns irBuiltins = info.getIrModuleFragment().getIrBuiltins();
        DumpIrTreeOptions dumpOptions = new DumpIrTreeOptions(true, true, false, false, false, false, false, false, false, arg_0 -> IrTextDumpHandler.processModule$lambda$0(irBuiltins, arg_0), 420, null);
        StringBuilder builder = this.baseDumper.builderForModule(module.getName());
        List<Pair<TestFile, IrFile>> testFileToIrFile = Companion.groupWithTestFiles(info.getIrModuleFragment().getFiles(), module);
        for (Pair<TestFile, IrFile> pair : testFileToIrFile) {
            TestFile testFile = (TestFile)pair.component1();
            IrFile irFile = (IrFile)pair.component2();
            Object object = testFile;
            if (object != null && (object = ((TestFile)object).getDirectives()) != null ? ((RegisteredDirectives)object).contains(CodegenTestDirectives.INSTANCE.getEXTERNAL_FILE()) : false) continue;
            String actualDump = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFile, (int)0, (DumpIrTreeOptions)dumpOptions);
            if (((CharSequence)actualDump).length() == 0) {
                actualDump = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFile, (int)-1, (DumpIrTreeOptions)dumpOptions);
            }
            builder.append(actualDump);
        }
        this.compareDumpsOfExternalClasses(module, info);
    }

    /*
     * WARNING - void declaration
     */
    private final void compareDumpsOfExternalClasses(TestModule module, IrBackendInput info) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<String> externalClassIds = module.getDirectives().get(CodegenTestDirectives.INSTANCE.getDUMP_EXTERNAL_CLASS());
        if (externalClassIds.isEmpty()) {
            return;
        }
        DumpIrTreeOptions dumpOptions = new DumpIrTreeOptions(false, true, false, false, false, false, false, false, false, null, 1021, null);
        File baseFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        Iterable iterable = externalClassIds;
        Assertions assertions = this.getAssertions();
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void externalClassId;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(() -> IrTextDumpHandler.compareDumpsOfExternalClasses$lambda$2$lambda$1(this, info, (String)externalClassId, dumpOptions, baseFile, module));
        }
        assertions.assertAll((List)destination$iv$iv);
    }

    private final IrClass findExternalClass(IrPluginContext $this$findExternalClass, String externalClassId) {
        ClassId classId = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)externalClassId, (boolean)false, (int)2, null);
        IrClassSymbol irClassSymbol = $this$findExternalClass.referenceClass(classId);
        if (irClassSymbol == null || (irClassSymbol = (IrClass)irClassSymbol.getOwner()) == null) {
            this.getAssertions().fail((Function0<String>)((Function0)() -> IrTextDumpHandler.findExternalClass$lambda$3(externalClassId)));
            throw null;
        }
        return irClassSymbol;
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure(this.getTestServices());
        File defaultExpectedFile = FileUtilsKt.withExtension((File)CollectionsKt.first(moduleStructure.getOriginalTestDataFiles()), IrTextDumpHandler.getDumpExtension$default(this, (TestModule)CollectionsKt.first(moduleStructure.getModules()), false, 1, null));
        this.checkOneExpectedFile(defaultExpectedFile, this.baseDumper.generateResultingDump());
        Iterable $this$forEach$iv = this.buildersForSeparateFileDumps.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            File expectedFile = (File)entry.getKey();
            StringBuilder dump = (StringBuilder)entry.getValue();
            String string = dump.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.checkOneExpectedFile(expectedFile, string);
        }
    }

    private final void checkOneExpectedFile(File expectedFile, String actualDump) {
        if (((CharSequence)actualDump).length() > 0) {
            Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, actualDump, null, 4, null);
        } else {
            HandlerUtilsKt.assertFileDoesntExist(this.getAssertions(), expectedFile, CodegenTestDirectives.INSTANCE.getDUMP_IR());
        }
    }

    private final String getDumpExtension(TestModule $this$getDumpExtension, boolean ignoreFirIdentical) {
        return Companion.computeDumpExtension($this$getDumpExtension, this.byteCodeListingEnabled ? DUMP_EXTENSION2 : DUMP_EXTENSION, ignoreFirIdentical);
    }

    static /* synthetic */ String getDumpExtension$default(IrTextDumpHandler irTextDumpHandler, TestModule testModule, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return irTextDumpHandler.getDumpExtension(testModule, bl);
    }

    private static final boolean processModule$lambda$0(IrBuiltIns $irBuiltins, IrDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)$irBuiltins, (String)"$irBuiltins");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.isHiddenDeclaration(it, $irBuiltins);
    }

    private static final Unit compareDumpsOfExternalClasses$lambda$2$lambda$1(IrTextDumpHandler this$0, IrBackendInput $info, String $externalClassId, DumpIrTreeOptions $dumpOptions, File $baseFile, TestModule $module) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$info, (String)"$info");
        Intrinsics.checkNotNullParameter((Object)$externalClassId, (String)"$externalClassId");
        Intrinsics.checkNotNullParameter((Object)$dumpOptions, (String)"$dumpOptions");
        Intrinsics.checkNotNullParameter((Object)$baseFile, (String)"$baseFile");
        Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
        String classDump = DumpIrTreeKt.dump((IrElement)((IrElement)this$0.findExternalClass($info.getIrPluginContext(), $externalClassId)), (DumpIrTreeOptions)$dumpOptions);
        String suffix = ".__" + StringsKt.replace$default((String)$externalClassId, (String)"/", (String)".", (boolean)false, (int)4, null);
        File expectedFile = FileUtilsKt.withSuffixAndExtension($baseFile, suffix, this$0.getDumpExtension($module, true));
        Assertions.assertEqualsToFile$default(this$0.getAssertions(), expectedFile, classDump, null, 4, null);
        return Unit.INSTANCE;
    }

    private static final String findExternalClass$lambda$3(String $externalClassId) {
        Intrinsics.checkNotNullParameter((Object)$externalClassId, (String)"$externalClassId");
        return "Can't find a class in external dependencies: " + $externalClassId;
    }

    static {
        Object[] objectArray = new Name[]{Name.identifier((String)"finalize"), Name.identifier((String)"getDeclaringClass"), Name.identifier((String)"clone")};
        HIDDEN_ENUM_METHOD_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\fJ,\u0010\r\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000e*\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u0016\u001a\u00020\f*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0012\u001a\r\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler$Companion;", "", "<init>", "()V", "DUMP_EXTENSION", "", "DUMP_EXTENSION2", "computeDumpExtension", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "defaultExtension", "ignoreFirIdentical", "", "groupWithTestFiles", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/test/model/TestFile;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "HIDDEN_ENUM_METHOD_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "Lkotlin/jvm/internal/EnhancedNullability;", "isHiddenEnumMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "isHiddenDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nIrTextDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTextDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1611#2,9:169\n1863#2:178\n295#2,2:179\n1864#2:182\n1620#2:183\n1755#2,3:184\n1#3:181\n*S KotlinDebug\n*F\n+ 1 IrTextDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler$Companion\n*L\n59#1:169,9\n59#1:178\n61#1:179,2\n59#1:182\n59#1:183\n72#1:184,3\n59#1:181\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String computeDumpExtension(@NotNull TestModule module, @NotNull String defaultExtension, boolean ignoreFirIdentical) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)defaultExtension, (String)"defaultExtension");
            return Intrinsics.areEqual(module.getFrontendKind(), (Object)FrontendKinds.ClassicFrontend.INSTANCE) || !ignoreFirIdentical && module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL()) ? defaultExtension : "fir." + defaultExtension;
        }

        public static /* synthetic */ String computeDumpExtension$default(Companion companion, TestModule testModule, String string, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.computeDumpExtension(testModule, string, bl);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Pair<TestFile, IrFile>> groupWithTestFiles(@NotNull List<? extends IrFile> $this$groupWithTestFiles, @NotNull TestModule module) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$groupWithTestFiles, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Iterable $this$mapNotNull$iv = $this$groupWithTestFiles;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair it$iv$iv;
                Object v0;
                IrFile irFile;
                block2: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    irFile = (IrFile)element$iv$iv;
                    boolean bl2 = false;
                    String name = new File(irFile.getFileEntry().getName()).getName();
                    Iterable $this$firstOrNull$iv = module.getFiles();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        TestFile it = (TestFile)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                TestFile testFile = v0;
                if (TuplesKt.to((Object)testFile, (Object)irFile) == null) continue;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isHiddenEnumMethod(IrSimpleFunction $this$isHiddenEnumMethod, IrBuiltIns irBuiltIns) {
            boolean bl;
            if (!$this$isHiddenEnumMethod.isFakeOverride()) return false;
            Iterable $this$any$iv = IrUtilsKt.allOverridden((IrOverridableDeclaration)((IrOverridableDeclaration)$this$isHiddenEnumMethod), (boolean)true);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl2 = false;
                IrValueParameter irValueParameter = it.getDispatchReceiverParameter();
                if (Intrinsics.areEqual((Object)(irValueParameter != null && (irValueParameter = irValueParameter.getType()) != null ? IrTypesKt.getClassOrNull((IrType)irValueParameter) : null), (Object)irBuiltIns.getEnumClass()) && HIDDEN_ENUM_METHOD_NAMES.contains(it.getName())) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        public final boolean isHiddenDeclaration(@NotNull IrDeclaration declaration, @NotNull IrBuiltIns irBuiltIns) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
            IrSimpleFunction irSimpleFunction = declaration instanceof IrSimpleFunction ? (IrSimpleFunction)declaration : null;
            return irSimpleFunction != null ? this.isHiddenEnumMethod(irSimpleFunction, irBuiltIns) : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

