/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.generators.model;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.generators.model.MethodModel;
import org.jetbrains.kotlin.generators.util.TestGeneratorUtil;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001:\u0001'BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010$\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R-\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010#\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/generators/model/SimpleTestMethodModel;", "Lorg/jetbrains/kotlin/generators/model/MethodModel;", "rootDir", "Ljava/io/File;", "file", "filenamePattern", "Ljava/util/regex/Pattern;", "checkFilenameStartsLowerCase", "", "targetBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "skipIgnored", "tags", "", "", "<init>", "(Ljava/io/File;Ljava/io/File;Ljava/util/regex/Pattern;Ljava/lang/Boolean;Lorg/jetbrains/kotlin/test/TargetBackend;ZLjava/util/List;)V", "getFile", "()Ljava/io/File;", "getTargetBackend$test_generator_test", "()Lorg/jetbrains/kotlin/test/TargetBackend;", "getTags", "()Ljava/util/List;", "directives", "", "getDirectives", "()Ljava/util/Map;", "directives$delegate", "Lkotlin/Lazy;", "kind", "Lorg/jetbrains/kotlin/generators/model/MethodModel$Kind;", "getKind", "()Lorg/jetbrains/kotlin/generators/model/MethodModel$Kind;", "dataString", "getDataString", "()Ljava/lang/String;", "shouldBeGenerated", "name", "getName", "Kind", "test-generator_test"})
@SourceDebugExtension(value={"SMAP\nSimpleTestMethodModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleTestMethodModel.kt\norg/jetbrains/kotlin/generators/model/SimpleTestMethodModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public class SimpleTestMethodModel
implements MethodModel {
    @NotNull
    private final File rootDir;
    @NotNull
    private final File file;
    @NotNull
    private final Pattern filenamePattern;
    @NotNull
    private final TargetBackend targetBackend;
    private final boolean skipIgnored;
    @NotNull
    private final List<String> tags;
    @NotNull
    private final Lazy directives$delegate;

    public SimpleTestMethodModel(@NotNull File rootDir, @NotNull File file, @NotNull Pattern filenamePattern, @Nullable Boolean checkFilenameStartsLowerCase, @NotNull TargetBackend targetBackend, boolean skipIgnored, @NotNull List<String> tags) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)filenamePattern, (String)"filenamePattern");
        Intrinsics.checkNotNullParameter((Object)((Object)targetBackend), (String)"targetBackend");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.rootDir = rootDir;
        this.file = file;
        this.filenamePattern = filenamePattern;
        this.targetBackend = targetBackend;
        this.skipIgnored = skipIgnored;
        this.tags = tags;
        this.directives$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> SimpleTestMethodModel.directives_delegate$lambda$0(this));
        if (checkFilenameStartsLowerCase != null) {
            char c = this.file.getName().charAt(0);
            if (checkFilenameStartsLowerCase.booleanValue()) {
                boolean bl = Character.isLowerCase(c);
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-SimpleTestMethodModel$32 = false;
                    String $i$a$-assert-SimpleTestMethodModel$32 = "Invalid file name '" + this.file + "', file name should start with lower-case letter";
                    throw new AssertionError((Object)$i$a$-assert-SimpleTestMethodModel$32);
                }
            } else {
                boolean bl = Character.isUpperCase(c);
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string = "Invalid file name '" + this.file + "', file name should start with upper-case letter";
                    throw new AssertionError((Object)string);
                }
            }
        }
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final TargetBackend getTargetBackend$test_generator_test() {
        return this.targetBackend;
    }

    @Override
    @NotNull
    public List<String> getTags() {
        return this.tags;
    }

    @NotNull
    public final Map<String, List<String>> getDirectives() {
        Lazy lazy = this.directives$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Map)object;
    }

    @Override
    @NotNull
    public MethodModel.Kind getKind() {
        return Kind.INSTANCE;
    }

    @Override
    @NotNull
    public String getDataString() {
        String string = FileUtil.getRelativePath((File)this.rootDir, (File)this.file);
        Intrinsics.checkNotNull((Object)string);
        String path = string;
        String string2 = KtTestUtil.getFilePath(new File(path));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFilePath(...)");
        return string2;
    }

    @Override
    public boolean shouldBeGenerated() {
        return InTextDirectivesUtils.isCompatibleTarget(this.targetBackend, this.getDirectives());
    }

    @Override
    @NotNull
    public String getName() {
        String string;
        int n;
        char c;
        char p0;
        StringBuilder stringBuilder;
        char c2;
        String string2;
        String string3;
        String $i$a$-assert-SimpleTestMethodModel$name$422;
        boolean $i$a$-assert-SimpleTestMethodModel$name$322;
        Matcher matcher = this.filenamePattern.matcher(this.file.getName());
        boolean found = matcher.find();
        if (_Assertions.ENABLED && !found) {
            boolean $i$a$-assert-SimpleTestMethodModel$name$322 = false;
            String $i$a$-assert-SimpleTestMethodModel$name$322 = this.file.getName() + " isn't matched by regex " + this.filenamePattern.pattern();
            throw new AssertionError((Object)$i$a$-assert-SimpleTestMethodModel$name$322);
        }
        boolean bl = $i$a$-assert-SimpleTestMethodModel$name$322 = matcher.groupCount() >= 1;
        if (_Assertions.ENABLED && !$i$a$-assert-SimpleTestMethodModel$name$322) {
            boolean $i$a$-assert-SimpleTestMethodModel$name$422 = false;
            String string4 = this.filenamePattern.pattern();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"pattern(...)");
            String $i$a$-assert-SimpleTestMethodModel$name$422 = string4;
            throw new AssertionError((Object)$i$a$-assert-SimpleTestMethodModel$name$422);
        }
        try {
            String string5 = matcher.group(1);
            if (string5 == null) {
                throw new IllegalStateException(("extractedName should not be null: " + this.filenamePattern.pattern()).toString());
            }
            $i$a$-assert-SimpleTestMethodModel$name$422 = string5;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Error generating test " + this.file.getName(), e);
        }
        String extractedName = $i$a$-assert-SimpleTestMethodModel$name$422;
        if (Intrinsics.areEqual((Object)this.rootDir, (Object)this.file.getParentFile())) {
            string3 = extractedName;
        } else {
            String string6;
            String relativePath = FileUtil.getRelativePath((File)this.rootDir, (File)this.file.getParentFile());
            StringBuilder stringBuilder2 = new StringBuilder().append(relativePath).append('-');
            string2 = extractedName;
            if (((CharSequence)string2).length() > 0) {
                c2 = string2.charAt(0);
                stringBuilder = stringBuilder2;
                boolean $i$a$-replaceFirstCharWithChar-SimpleTestMethodModel$name$unescapedName$22 = false;
                c = Character.toUpperCase(p0);
                stringBuilder2 = stringBuilder;
                p0 = c;
                String $i$a$-replaceFirstCharWithChar-SimpleTestMethodModel$name$unescapedName$22 = string2;
                n = 1;
                String string7 = $i$a$-replaceFirstCharWithChar-SimpleTestMethodModel$name$unescapedName$22.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                $i$a$-replaceFirstCharWithChar-SimpleTestMethodModel$name$unescapedName$22 = string7;
                string6 = p0 + $i$a$-replaceFirstCharWithChar-SimpleTestMethodModel$name$unescapedName$22;
            } else {
                string6 = string2;
            }
            string3 = stringBuilder2.append(string6).toString();
        }
        String unescapedName = string3;
        boolean ignored = this.skipIgnored && InTextDirectivesUtils.isIgnoredTarget(this.targetBackend, this.getDirectives(), false, new String[0]);
        StringBuilder stringBuilder3 = new StringBuilder().append(ignored ? "ignore" : "test");
        string2 = TestGeneratorUtil.escapeForJavaIdentifier(unescapedName);
        if (((CharSequence)string2).length() > 0) {
            p0 = string2.charAt(0);
            stringBuilder = stringBuilder3;
            boolean bl2 = false;
            c = Character.toUpperCase(p0);
            stringBuilder3 = stringBuilder;
            c2 = c;
            String string8 = string2;
            n = 1;
            String string9 = string8.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
            string8 = string9;
            string = c2 + string8;
        } else {
            string = string2;
        }
        return stringBuilder3.append(string).toString();
    }

    private static final Map directives_delegate$lambda$0(SimpleTestMethodModel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = InTextDirectivesUtils.textWithDirectives(this$0.file);
        SpreadBuilder spreadBuilder = new SpreadBuilder(4);
        spreadBuilder.addSpread((Object)InTextDirectivesUtils.IGNORE_BACKEND_DIRECTIVE_PREFIXES);
        spreadBuilder.add((Object)"// TARGET_BACKEND: ");
        spreadBuilder.add((Object)"// DONT_TARGET_EXACT_BACKEND: ");
        spreadBuilder.add((Object)"// WORKS_WHEN_VALUE_CLASS");
        return InTextDirectivesUtils.findLinesByPrefixRemoved(string, (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/generators/model/SimpleTestMethodModel$Kind;", "Lorg/jetbrains/kotlin/generators/model/MethodModel$Kind;", "<init>", "()V", "test-generator_test"})
    public static final class Kind
    extends MethodModel.Kind {
        @NotNull
        public static final Kind INSTANCE = new Kind();

        private Kind() {
        }
    }
}

