/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.platform.konan.NativePlatforms;
import org.jetbrains.kotlin.platform.wasm.WasmPlatforms;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.builders.LanguageVersionSettingsBuilder;
import org.jetbrains.kotlin.test.directives.AdditionalFilesDirectives;
import org.jetbrains.kotlin.test.directives.ModuleStructureDirectives;
import org.jetbrains.kotlin.test.directives.TargetPlatformEnum;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.BackendKind;
import org.jetbrains.kotlin.test.model.BackendKinds;
import org.jetbrains.kotlin.test.model.BinaryKind;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.DependencyRelation;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AbstractEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.AdditionalSourceProvider;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.DefaultRegisteredDirectivesProviderKt;
import org.jetbrains.kotlin.test.services.DefaultsProvider;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.ExceptionFromModuleStructureTransformer;
import org.jetbrains.kotlin.test.services.ModuleStructureExtractor;
import org.jetbrains.kotlin.test.services.ModuleStructureTransformer;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.impl.ModuleStructureExtractorImplKt;
import org.jetbrains.kotlin.test.services.impl.RegisteredDirectivesParser;
import org.jetbrains.kotlin.test.services.impl.TestModuleStructureImpl;
import org.jetbrains.kotlin.test.util.StringUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl;", "Lorg/jetbrains/kotlin/test/services/ModuleStructureExtractor;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "additionalSourceProviders", "", "Lorg/jetbrains/kotlin/test/services/AdditionalSourceProvider;", "moduleStructureTransformers", "Lorg/jetbrains/kotlin/test/services/ModuleStructureTransformer;", "environmentConfigurators", "Lorg/jetbrains/kotlin/test/services/AbstractEnvironmentConfigurator;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "splitTestDataByModules", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "testDataFileName", "", "directivesContainer", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "Companion", "ModuleStructureExtractorWorker", "ModuleNameAndDependencies", "tests-common-new_test"})
public final class ModuleStructureExtractorImpl
extends ModuleStructureExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<AbstractEnvironmentConfigurator> environmentConfigurators;
    @NotNull
    private static final List<String> allowedExtensionsForFiles;
    @NotNull
    private static final Regex moduleDirectiveRegex;

    public ModuleStructureExtractorImpl(@NotNull TestServices testServices, @NotNull List<? extends AdditionalSourceProvider> additionalSourceProviders, @NotNull List<? extends ModuleStructureTransformer> moduleStructureTransformers, @NotNull List<? extends AbstractEnvironmentConfigurator> environmentConfigurators) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(additionalSourceProviders, (String)"additionalSourceProviders");
        Intrinsics.checkNotNullParameter(moduleStructureTransformers, (String)"moduleStructureTransformers");
        Intrinsics.checkNotNullParameter(environmentConfigurators, (String)"environmentConfigurators");
        super(testServices, additionalSourceProviders, moduleStructureTransformers);
        this.environmentConfigurators = environmentConfigurators;
    }

    @Override
    @NotNull
    public TestModuleStructure splitTestDataByModules(@NotNull String testDataFileName, @NotNull DirectivesContainer directivesContainer) {
        Intrinsics.checkNotNullParameter((Object)testDataFileName, (String)"testDataFileName");
        Intrinsics.checkNotNullParameter((Object)directivesContainer, (String)"directivesContainer");
        File testDataFile = new File(testDataFileName);
        ModuleStructureExtractorWorker extractor = new ModuleStructureExtractorWorker(CollectionsKt.listOf((Object)testDataFile), directivesContainer);
        TestModuleStructure result = extractor.splitTestDataByModules();
        for (ModuleStructureTransformer transformer : this.getModuleStructureTransformers()) {
            TestModuleStructure testModuleStructure;
            try {
                testModuleStructure = transformer.transformModuleStructure(result, DefaultsProviderKt.getDefaultsProvider(this.getTestServices()));
            }
            catch (Throwable e) {
                throw new ExceptionFromModuleStructureTransformer(e, result);
            }
            result = testModuleStructure;
        }
        return result;
    }

    static {
        Object[] objectArray = new String[]{".kt", ".kts", ".java", ".js", ".mjs", ".config", ".xml"};
        allowedExtensionsForFiles = CollectionsKt.listOf((Object[])objectArray);
        moduleDirectiveRegex = new Regex("([^()\\n]+)(\\((.*?)\\)(\\((.*?)\\)(\\((.*?)\\))?)?)?");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$Companion;", "", "<init>", "()V", "allowedExtensionsForFiles", "", "", "moduleDirectiveRegex", "Lkotlin/text/Regex;", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003JC\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$ModuleNameAndDependencies;", "", "name", "", "dependencies", "", "friends", "dependsOn", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getDependencies", "()Ljava/util/List;", "getFriends", "getDependsOn", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "tests-common-new_test"})
    private static final class ModuleNameAndDependencies {
        @NotNull
        private final String name;
        @NotNull
        private final List<String> dependencies;
        @NotNull
        private final List<String> friends;
        @NotNull
        private final List<String> dependsOn;

        public ModuleNameAndDependencies(@NotNull String name, @NotNull List<String> dependencies, @NotNull List<String> friends, @NotNull List<String> dependsOn) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter(friends, (String)"friends");
            Intrinsics.checkNotNullParameter(dependsOn, (String)"dependsOn");
            this.name = name;
            this.dependencies = dependencies;
            this.friends = friends;
            this.dependsOn = dependsOn;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<String> getDependencies() {
            return this.dependencies;
        }

        @NotNull
        public final List<String> getFriends() {
            return this.friends;
        }

        @NotNull
        public final List<String> getDependsOn() {
            return this.dependsOn;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final List<String> component2() {
            return this.dependencies;
        }

        @NotNull
        public final List<String> component3() {
            return this.friends;
        }

        @NotNull
        public final List<String> component4() {
            return this.dependsOn;
        }

        @NotNull
        public final ModuleNameAndDependencies copy(@NotNull String name, @NotNull List<String> dependencies, @NotNull List<String> friends, @NotNull List<String> dependsOn) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter(friends, (String)"friends");
            Intrinsics.checkNotNullParameter(dependsOn, (String)"dependsOn");
            return new ModuleNameAndDependencies(name, dependencies, friends, dependsOn);
        }

        public static /* synthetic */ ModuleNameAndDependencies copy$default(ModuleNameAndDependencies moduleNameAndDependencies, String string, List list, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                string = moduleNameAndDependencies.name;
            }
            if ((n & 2) != 0) {
                list = moduleNameAndDependencies.dependencies;
            }
            if ((n & 4) != 0) {
                list2 = moduleNameAndDependencies.friends;
            }
            if ((n & 8) != 0) {
                list3 = moduleNameAndDependencies.dependsOn;
            }
            return moduleNameAndDependencies.copy(string, list, list2, list3);
        }

        @NotNull
        public String toString() {
            return "ModuleNameAndDependencies(name=" + this.name + ", dependencies=" + this.dependencies + ", friends=" + this.friends + ", dependsOn=" + this.dependsOn + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + ((Object)this.dependencies).hashCode();
            result = result * 31 + ((Object)this.friends).hashCode();
            result = result * 31 + ((Object)this.dependsOn).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleNameAndDependencies)) {
                return false;
            }
            ModuleNameAndDependencies moduleNameAndDependencies = (ModuleNameAndDependencies)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)moduleNameAndDependencies.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.dependencies, moduleNameAndDependencies.dependencies)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.friends, moduleNameAndDependencies.friends)) {
                return false;
            }
            return Intrinsics.areEqual(this.dependsOn, moduleNameAndDependencies.dependsOn);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u00104\u001a\u000205J\u001c\u00106\u001a\b\u0012\u0004\u0012\u0002020\u00032\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u0003H\u0002J\u0016\u00107\u001a\u0002082\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u0003H\u0002J\u001a\u00109\u001a\u00020&2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020)H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u0013H\u0002J\b\u0010@\u001a\u000208H\u0002J*\u0010A\u001a\u000208*\u00020B2\b\b\u0002\u0010C\u001a\u00020&2\b\b\u0002\u0010D\u001a\u00020&2\b\b\u0002\u0010E\u001a\u00020&H\u0002J\u0010\u0010F\u001a\u0002082\u0006\u0010<\u001a\u00020)H\u0002J\u0012\u0010G\u001a\u0004\u0018\u00010\u00182\u0006\u0010H\u001a\u00020\u0013H\u0002J\u0010\u0010I\u001a\u0002082\u0006\u0010<\u001a\u00020)H\u0002J\b\u0010J\u001a\u000208H\u0002J\b\u0010K\u001a\u000208H\u0002J\b\u0010L\u001a\u000208H\u0002J\u0012\u0010M\u001a\u0002082\b\u0010:\u001a\u0004\u0018\u00010;H\u0002J\u0010\u0010N\u001a\u0002082\u0006\u0010O\u001a\u00020\u0013H\u0002J\b\u0010P\u001a\u00020\u001eH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u0002020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$ModuleStructureExtractorWorker;", "", "testDataFiles", "", "Ljava/io/File;", "directivesContainer", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "<init>", "(Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl;Ljava/util/List;Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;)V", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "getAssertions", "()Lorg/jetbrains/kotlin/test/Assertions;", "defaultsProvider", "Lorg/jetbrains/kotlin/test/services/DefaultsProvider;", "getDefaultsProvider", "()Lorg/jetbrains/kotlin/test/services/DefaultsProvider;", "currentTestDataFile", "defaultFileName", "", "getDefaultFileName", "()Ljava/lang/String;", "currentModuleName", "currentModuleTargetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "currentModuleFrontendKind", "Lorg/jetbrains/kotlin/test/model/FrontendKind;", "currentModuleTargetBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "currentModuleLanguageVersionSettingsBuilder", "Lorg/jetbrains/kotlin/test/builders/LanguageVersionSettingsBuilder;", "dependenciesOfCurrentModule", "", "Lorg/jetbrains/kotlin/test/model/DependencyDescription;", "filesOfCurrentModule", "Lorg/jetbrains/kotlin/test/model/TestFile;", "currentFileName", "firstFileInModule", "", "linesOfCurrentFile", "endLineNumberOfLastFile", "", "allowFilesWithSameNames", "directivesBuilder", "Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser;", "moduleDirectivesBuilder", "fileDirectivesBuilder", "globalDirectives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "modules", "Lorg/jetbrains/kotlin/test/model/TestModule;", "moduleStructureDirectiveBuilder", "splitTestDataByModules", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "sortModules", "checkCycles", "", "tryParseStructureDirective", "rawDirective", "Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$RawDirective;", "lineNumber", "splitRawModuleStringToNameAndDependencies", "Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$ModuleNameAndDependencies;", "moduleDirectiveString", "finishGlobalDirectives", "checkDirectiveApplicability", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "contextIsGlobal", "contextIsModule", "contextIsFile", "finishModule", "parseModulePlatformByName", "moduleName", "finishFile", "resetModuleCaches", "resetDirectivesBuilder", "resetFileCaches", "tryParseRegularDirective", "validateFileName", "fileName", "initLanguageSettingsBuilder", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nModuleStructureExtractorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleStructureExtractorImpl.kt\norg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$ModuleStructureExtractorWorker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ModuleStructureExtractorImpl.kt\norg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImplKt\n*L\n1#1,498:1\n1872#2,3:499\n1485#2:502\n1510#2,3:503\n1513#2,3:513\n1246#2,4:518\n1628#2,3:522\n1628#2,3:525\n1628#2,3:528\n1557#2:538\n1628#2,3:539\n1454#2,5:542\n774#2:547\n865#2,2:548\n2642#2:550\n1863#2,2:552\n1454#2,2:554\n1734#2,3:556\n1456#2,3:559\n1755#2,3:562\n2642#2:565\n1755#2,3:567\n1557#2:570\n1628#2,3:571\n381#3,7:506\n462#3:516\n412#3:517\n1#4:531\n1#4:551\n1#4:566\n490#5,6:532\n*S KotlinDebug\n*F\n+ 1 ModuleStructureExtractorImpl.kt\norg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$ModuleStructureExtractorWorker\n*L\n121#1:499,3\n138#1:502\n138#1:503,3\n138#1:513,3\n138#1:518,4\n187#1:522,3\n190#1:525,3\n193#1:528,3\n234#1:538\n234#1:539,3\n242#1:542,5\n282#1:547\n282#1:548,2\n308#1:550\n335#1:552,2\n363#1:554,2\n368#1:556,3\n363#1:559,3\n399#1:562,3\n402#1:565\n460#1:567,3\n142#1:570\n142#1:571,3\n138#1:506,7\n138#1:516\n138#1:517\n308#1:551\n402#1:566\n200#1:532,6\n*E\n"})
    private final class ModuleStructureExtractorWorker {
        @NotNull
        private final List<File> testDataFiles;
        @NotNull
        private final DirectivesContainer directivesContainer;
        private File currentTestDataFile;
        @Nullable
        private String currentModuleName;
        @Nullable
        private TargetPlatform currentModuleTargetPlatform;
        @Nullable
        private FrontendKind<?> currentModuleFrontendKind;
        @Nullable
        private TargetBackend currentModuleTargetBackend;
        @NotNull
        private LanguageVersionSettingsBuilder currentModuleLanguageVersionSettingsBuilder;
        @NotNull
        private List<DependencyDescription> dependenciesOfCurrentModule;
        @NotNull
        private List<TestFile> filesOfCurrentModule;
        @Nullable
        private String currentFileName;
        private boolean firstFileInModule;
        @NotNull
        private List<String> linesOfCurrentFile;
        private int endLineNumberOfLastFile;
        private boolean allowFilesWithSameNames;
        @NotNull
        private RegisteredDirectivesParser directivesBuilder;
        @NotNull
        private RegisteredDirectivesParser moduleDirectivesBuilder;
        @Nullable
        private RegisteredDirectivesParser fileDirectivesBuilder;
        @Nullable
        private RegisteredDirectives globalDirectives;
        @NotNull
        private final List<TestModule> modules;
        @NotNull
        private final RegisteredDirectivesParser moduleStructureDirectiveBuilder;

        public ModuleStructureExtractorWorker(@NotNull List<? extends File> testDataFiles, DirectivesContainer directivesContainer) {
            Intrinsics.checkNotNullParameter(testDataFiles, (String)"testDataFiles");
            Intrinsics.checkNotNullParameter((Object)directivesContainer, (String)"directivesContainer");
            this.testDataFiles = testDataFiles;
            this.directivesContainer = directivesContainer;
            this.currentModuleLanguageVersionSettingsBuilder = this.initLanguageSettingsBuilder();
            this.dependenciesOfCurrentModule = new ArrayList();
            this.filesOfCurrentModule = new ArrayList();
            this.firstFileInModule = true;
            this.linesOfCurrentFile = new ArrayList();
            this.endLineNumberOfLastFile = -1;
            this.moduleDirectivesBuilder = this.directivesBuilder = new RegisteredDirectivesParser(this.directivesContainer, this.getAssertions());
            this.modules = new ArrayList();
            this.moduleStructureDirectiveBuilder = new RegisteredDirectivesParser(ModuleStructureDirectives.INSTANCE, this.getAssertions());
        }

        private final Assertions getAssertions() {
            return AssertionsKt.getAssertions(ModuleStructureExtractorImpl.this.getTestServices());
        }

        private final DefaultsProvider getDefaultsProvider() {
            return DefaultsProviderKt.getDefaultsProvider(ModuleStructureExtractorImpl.this.getTestServices());
        }

        private final String getDefaultFileName() {
            File file = this.currentTestDataFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentTestDataFile");
                file = null;
            }
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TestModuleStructure splitTestDataByModules() {
            Iterator<File> iterator = this.testDataFiles.iterator();
            while (iterator.hasNext()) {
                File testDataFile;
                this.currentTestDataFile = testDataFile = iterator.next();
                List lines = FilesKt.readLines$default((File)testDataFile, null, (int)1, null);
                Iterable $this$forEachIndexed$iv = lines;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void line;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string = (String)item$iv;
                    int lineNumber = n;
                    boolean bl = false;
                    RegisteredDirectivesParser.RawDirective rawDirective = RegisteredDirectivesParser.Companion.parseDirective((String)line);
                    if (this.tryParseStructureDirective(rawDirective, lineNumber + 1)) {
                        this.linesOfCurrentFile.add((String)line);
                        continue;
                    }
                    this.tryParseRegularDirective(rawDirective);
                    this.linesOfCurrentFile.add((String)line);
                }
            }
            this.finishModule(-1);
            List<TestModule> sortedModules = this.sortModules(this.modules);
            this.checkCycles(this.modules);
            return new TestModuleStructureImpl(sortedModules, this.testDataFiles);
        }

        /*
         * WARNING - void declaration
         */
        private final List<TestModule> sortModules(List<TestModule> modules) {
            void $this$mapValuesTo$iv$iv;
            Object key$iv$iv;
            Map $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = modules;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object element$iv$iv = iterator.next();
                TestModule it = (TestModule)element$iv$iv;
                boolean bl = false;
                key$iv$iv = it.getName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                TestModule testModule;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map2 = map;
                boolean bl3 = false;
                String name = (String)entry.getKey();
                List modules2 = (List)entry.getValue();
                if ((TestModule)CollectionsKt.singleOrNull((List)modules2) == null) {
                    throw new IllegalStateException(("Duplicated modules with name " + name).toString());
                }
                map2.put(k, testModule);
            }
            Map moduleByName = destination$iv$iv;
            List list = DFS.topologicalOrder((Iterable)modules, arg_0 -> ModuleStructureExtractorWorker.sortModules$lambda$4(moduleByName, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"topologicalOrder(...)");
            return CollectionsKt.asReversedMutable((List)list);
        }

        private final void checkCycles(List<TestModule> modules) {
            Set visited = new LinkedHashSet();
            for (TestModule module : modules) {
                String moduleName = module.getName();
                visited.add(moduleName);
                for (DependencyDescription dependency : module.getAllDependencies()) {
                    String dependencyName = dependency.getModuleName();
                    if (Intrinsics.areEqual((Object)dependencyName, (Object)moduleName)) {
                        throw new IllegalStateException(("Module " + moduleName + " has dependency to itself").toString());
                    }
                    if (visited.contains(dependencyName)) continue;
                    throw new IllegalStateException(("There is cycle in modules dependencies. See modules: " + dependencyName + ", " + moduleName).toString());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final boolean tryParseStructureDirective(RegisteredDirectivesParser.RawDirective rawDirective, int lineNumber) {
            block51: {
                Directive directive;
                List<?> values;
                Directive directive2;
                block52: {
                    DependencyRelation dependencyRelation;
                    Directive friends2;
                    Object kind;
                    String name;
                    block54: {
                        Object object;
                        block53: {
                            DependencyKind dependencyKind;
                            block49: {
                                block50: {
                                    String name2;
                                    Collection collection;
                                    Iterable $this$mapTo$iv;
                                    if (rawDirective == null) {
                                        return false;
                                    }
                                    RegisteredDirectivesParser.ParsedDirective parsedDirective = this.moduleStructureDirectiveBuilder.convertToRegisteredDirective(rawDirective);
                                    if (parsedDirective == null) {
                                        return false;
                                    }
                                    RegisteredDirectivesParser.ParsedDirective parsedDirective2 = parsedDirective;
                                    directive2 = parsedDirective2.component1();
                                    values = parsedDirective2.component2();
                                    directive = directive2;
                                    if (!Intrinsics.areEqual((Object)directive, (Object)ModuleStructureDirectives.INSTANCE.getMODULE())) break block50;
                                    if (this.currentModuleName != null) {
                                        this.finishModule(lineNumber);
                                    } else {
                                        this.finishGlobalDirectives();
                                    }
                                    ModuleNameAndDependencies moduleNameAndDependencies = this.splitRawModuleStringToNameAndDependencies(CollectionsKt.joinToString$default((Iterable)values, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                                    String moduleName = moduleNameAndDependencies.component1();
                                    List<String> dependencies = moduleNameAndDependencies.component2();
                                    List<String> friends2 = moduleNameAndDependencies.component3();
                                    List<String> dependsOn = moduleNameAndDependencies.component4();
                                    this.currentModuleName = moduleName;
                                    DependencyKind kind2 = this.getDefaultsProvider().getDefaultDependencyKind();
                                    Iterable iterable = dependencies;
                                    Collection destination$iv = this.dependenciesOfCurrentModule;
                                    boolean $i$f$mapTo = false;
                                    for (Object item$iv : $this$mapTo$iv) {
                                        String string = (String)item$iv;
                                        collection = destination$iv;
                                        boolean bl = false;
                                        collection.add(new DependencyDescription(name2, kind2, DependencyRelation.RegularDependency));
                                    }
                                    $this$mapTo$iv = friends2;
                                    destination$iv = this.dependenciesOfCurrentModule;
                                    $i$f$mapTo = false;
                                    for (Object item$iv : $this$mapTo$iv) {
                                        name2 = (String)item$iv;
                                        collection = destination$iv;
                                        boolean bl = false;
                                        collection.add(new DependencyDescription(name2, kind2, DependencyRelation.FriendDependency));
                                    }
                                    $this$mapTo$iv = dependsOn;
                                    destination$iv = this.dependenciesOfCurrentModule;
                                    $i$f$mapTo = false;
                                    for (Object item$iv : $this$mapTo$iv) {
                                        name2 = (String)item$iv;
                                        collection = destination$iv;
                                        boolean bl = false;
                                        collection.add(new DependencyDescription(name2, DependencyKind.Source, DependencyRelation.DependsOnDependency));
                                    }
                                    break block51;
                                }
                                if (!Intrinsics.areEqual((Object)directive, (Object)ModuleStructureDirectives.INSTANCE.getDEPENDENCY()) && !Intrinsics.areEqual((Object)directive, (Object)ModuleStructureDirectives.INSTANCE.getDEPENDS_ON())) break block52;
                                Object object2 = CollectionsKt.first(values);
                                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
                                name = (String)object2;
                                object = CollectionsKt.getOrNull(values, (int)1);
                                if (object == null) break block53;
                                Object it = object;
                                boolean bl = false;
                                String value$iv = (String)it;
                                boolean $i$f$valueOfOrNull = false;
                                for (DependencyKind enumValue$iv : DependencyKind.values()) {
                                    if (!Intrinsics.areEqual((Object)enumValue$iv.name(), (Object)value$iv)) continue;
                                    dependencyKind = enumValue$iv;
                                    break block49;
                                }
                                dependencyKind = null;
                            }
                            object = dependencyKind;
                            if (dependencyKind != null) break block54;
                        }
                        object = kind = this.getDefaultsProvider().getDefaultDependencyKind();
                    }
                    if (Intrinsics.areEqual((Object)(friends2 = directive2), (Object)ModuleStructureDirectives.INSTANCE.getDEPENDENCY())) {
                        dependencyRelation = DependencyRelation.RegularDependency;
                    } else if (Intrinsics.areEqual((Object)friends2, (Object)ModuleStructureDirectives.INSTANCE.getDEPENDS_ON())) {
                        dependencyRelation = DependencyRelation.DependsOnDependency;
                    } else {
                        throw new IllegalStateException("Should not be here".toString());
                    }
                    DependencyRelation relation = dependencyRelation;
                    this.dependenciesOfCurrentModule.add(new DependencyDescription(name, (DependencyKind)((Object)kind), relation));
                    break block51;
                }
                if (Intrinsics.areEqual((Object)directive, (Object)ModuleStructureDirectives.INSTANCE.getTARGET_FRONTEND())) {
                    Object relation = CollectionsKt.singleOrNull(values);
                    String string = relation instanceof String ? (String)relation : null;
                    if (string == null) {
                        this.getAssertions().fail((Function0<String>)((Function0)() -> ModuleStructureExtractorWorker.tryParseStructureDirective$lambda$9(directive2)));
                        throw null;
                    }
                    String name = string;
                    FrontendKind<?> frontendKind = FrontendKinds.INSTANCE.fromString(name);
                    if (frontendKind == null) {
                        this.getAssertions().fail((Function0<String>)((Function0)() -> ModuleStructureExtractorWorker.tryParseStructureDirective$lambda$10(name)));
                        throw null;
                    }
                    this.currentModuleFrontendKind = frontendKind;
                } else if (Intrinsics.areEqual((Object)directive, ModuleStructureDirectives.INSTANCE.getTARGET_BACKEND_KIND())) {
                    Object object = CollectionsKt.single(values);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.test.TargetBackend");
                    this.currentModuleTargetBackend = (TargetBackend)((Object)object);
                } else if (Intrinsics.areEqual((Object)directive, (Object)ModuleStructureDirectives.INSTANCE.getFILE())) {
                    void p0;
                    String name;
                    if (this.currentFileName != null) {
                        this.finishFile(lineNumber);
                    } else {
                        this.resetFileCaches();
                    }
                    Object object = CollectionsKt.first(values);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    String kind = name = (String)object;
                    ModuleStructureExtractorWorker moduleStructureExtractorWorker = this;
                    boolean bl = false;
                    this.validateFileName((String)p0);
                    moduleStructureExtractorWorker.currentFileName = name;
                } else if (Intrinsics.areEqual((Object)directive, (Object)ModuleStructureDirectives.INSTANCE.getALLOW_FILES_WITH_SAME_NAMES())) {
                    this.allowFilesWithSameNames = true;
                } else if (Intrinsics.areEqual((Object)directive, ModuleStructureDirectives.INSTANCE.getTARGET_PLATFORM())) {
                    TargetPlatform targetPlatform;
                    Object object;
                    Collection $this$mapTo$iv$iv;
                    if (this.currentModuleTargetPlatform != null) {
                        this.getAssertions().fail((Function0<String>)((Function0)() -> ModuleStructureExtractorWorker.tryParseStructureDirective$lambda$11(this)));
                        throw null;
                    }
                    Iterable $this$map$iv = values;
                    boolean $i$f$map2 = false;
                    Iterable friends2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator bl = $this$mapTo$iv$iv.iterator();
                    while (bl.hasNext()) {
                        void it;
                        Object item$iv$iv;
                        Object $i$f$valueOfOrNull = item$iv$iv = bl.next();
                        object = destination$iv$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.test.directives.TargetPlatformEnum");
                        object.add(((TargetPlatformEnum)it).getTargetPlatform());
                    }
                    List platforms = (List)destination$iv$iv;
                    Object object3 = this;
                    switch (platforms.size()) {
                        case 0: {
                            this.getAssertions().fail((Function0<String>)((Function0)() -> ModuleStructureExtractorWorker.tryParseStructureDirective$lambda$13(directive2)));
                            throw null;
                        }
                        case 1: {
                            targetPlatform = (TargetPlatform)CollectionsKt.single((List)platforms);
                            break;
                        }
                        default: {
                            void destination$iv;
                            void $this$flatMapTo$iv;
                            if (values.contains((Object)TargetPlatformEnum.Common)) {
                                this.getAssertions().fail((Function0<String>)((Function0)ModuleStructureExtractorWorker::tryParseStructureDirective$lambda$14));
                                throw null;
                            }
                            Iterable $i$f$map2 = platforms;
                            $this$mapTo$iv$iv = new LinkedHashSet();
                            object = object3;
                            boolean $i$f$flatMapTo = false;
                            for (Object element$iv : $this$flatMapTo$iv) {
                                TargetPlatform it = (TargetPlatform)element$iv;
                                boolean bl3 = false;
                                Iterable list$iv = it.getComponentPlatforms();
                                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                            }
                            object3 = object;
                            Set set = (Set)destination$iv;
                            targetPlatform = new TargetPlatform(set);
                        }
                    }
                    ((ModuleStructureExtractorWorker)object3).currentModuleTargetPlatform = targetPlatform;
                } else {
                    if (Intrinsics.areEqual((Object)directive, (Object)ModuleStructureDirectives.INSTANCE.getJVM_TARGET())) {
                        TargetPlatform targetPlatform;
                        if (!JvmPlatformKt.isJvm((TargetPlatform)this.getDefaultsProvider().getDefaultPlatform())) {
                            return false;
                        }
                        if (this.currentModuleTargetPlatform != null) {
                            this.getAssertions().fail((Function0<String>)((Function0)() -> ModuleStructureExtractorWorker.tryParseStructureDirective$lambda$16(this)));
                            throw null;
                        }
                        if (values.size() != 1) {
                            this.getAssertions().fail((Function0<String>)((Function0)ModuleStructureExtractorWorker::tryParseStructureDirective$lambda$17));
                            throw null;
                        }
                        Object object = CollectionsKt.single(values);
                        if (Intrinsics.areEqual((Object)object, (Object)"1.6")) {
                            targetPlatform = JvmPlatforms.INSTANCE.getJvm6();
                        } else if (Intrinsics.areEqual((Object)object, (Object)"1.8")) {
                            targetPlatform = JvmPlatforms.INSTANCE.getJvm8();
                        } else if (Intrinsics.areEqual((Object)object, (Object)"11")) {
                            targetPlatform = JvmPlatforms.INSTANCE.getJvm11();
                        } else if (Intrinsics.areEqual((Object)object, (Object)"17")) {
                            targetPlatform = JvmPlatforms.INSTANCE.getJvm17();
                        } else {
                            this.getAssertions().fail((Function0<String>)((Function0)ModuleStructureExtractorWorker::tryParseStructureDirective$lambda$18));
                            throw null;
                        }
                        this.currentModuleTargetPlatform = targetPlatform;
                        return false;
                    }
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final ModuleNameAndDependencies splitRawModuleStringToNameAndDependencies(String moduleDirectiveString) {
            Object object;
            Object directives;
            String[] it;
            String string;
            MatchResult matchResult = moduleDirectiveRegex.matchEntire((CharSequence)moduleDirectiveString);
            if (matchResult == null) {
                throw new IllegalStateException(('\"' + moduleDirectiveString + "\" doesn't matches with pattern \"moduleName(dep1, dep2)\"").toString());
            }
            MatchResult matchResult2 = matchResult;
            MatchResult.Destructured destructured = matchResult2.getDestructured();
            String name = (String)destructured.getMatch().getGroupValues().get(1);
            String dependencies = (String)destructured.getMatch().getGroupValues().get(3);
            String friends = (String)destructured.getMatch().getGroupValues().get(5);
            String dependsOn = (String)destructured.getMatch().getGroupValues().get(7);
            Ref.ObjectRef dependenciesNames = new Ref.ObjectRef();
            String string2 = string = dependencies;
            Ref.ObjectRef objectRef = dependenciesNames;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
            Object object2 = bl2 ? string : null;
            if (object2 == null || (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])(it = new String[]{" "}), (boolean)false, (int)0, (int)6, null)) == null) {
                object2 = CollectionsKt.emptyList();
            }
            objectRef.element = object2;
            RegisteredDirectives registeredDirectives = this.globalDirectives;
            if (registeredDirectives != null) {
                directives = registeredDirectives;
                boolean bl3 = false;
                if (((RegisteredDirectives)directives).contains(AdditionalFilesDirectives.INSTANCE.getWITH_COROUTINES())) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable = (Iterable)dependenciesNames.element;
                    Ref.ObjectRef objectRef2 = dependenciesNames;
                    boolean $i$f$filter = false;
                    void var16_25 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it2 = (String)element$iv$iv;
                        boolean bl4 = false;
                        if (!(!Intrinsics.areEqual((Object)it2, (Object)"support"))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    objectRef2.element = (List)destination$iv$iv;
                }
            }
            Object it3 = directives = friends;
            boolean bl5 = false;
            Object object3 = !StringsKt.isBlank((CharSequence)((CharSequence)it3)) ? directives : null;
            if (object3 == null || (object3 = StringsKt.split$default((CharSequence)((CharSequence)object3), (String[])(object = new String[]{" "}), (boolean)false, (int)0, (int)6, null)) == null) {
                object3 = CollectionsKt.emptyList();
            }
            Object friendsNames = object3;
            object = dependsOn;
            String[] it4 = object;
            boolean bl6 = false;
            Object object4 = !StringsKt.isBlank((CharSequence)((CharSequence)it4)) ? object : null;
            if (object4 == null || (object4 = StringsKt.split$default((CharSequence)((CharSequence)object4), (String[])(it4 = new String[]{" "}), (boolean)false, (int)0, (int)6, null)) == null) {
                object4 = CollectionsKt.emptyList();
            }
            Object dependsOnNames = object4;
            Object $this$splitRawModuleStringToNameAndDependencies_u24lambda_u2424 = object = SetsKt.createSetBuilder();
            boolean bl7 = false;
            $this$splitRawModuleStringToNameAndDependencies_u24lambda_u2424.addAll(CollectionsKt.intersect((Iterable)((Iterable)dependenciesNames.element), (Iterable)((Iterable)friendsNames)));
            $this$splitRawModuleStringToNameAndDependencies_u24lambda_u2424.addAll(CollectionsKt.intersect((Iterable)((Iterable)dependenciesNames.element), (Iterable)((Iterable)dependsOnNames)));
            $this$splitRawModuleStringToNameAndDependencies_u24lambda_u2424.addAll(CollectionsKt.intersect((Iterable)((Iterable)friendsNames), (Iterable)((Iterable)dependsOnNames)));
            Set intersection = SetsKt.build((Set)object);
            if (!intersection.isEmpty()) {
                boolean bl8 = false;
                String m = intersection.size() == 1 ? "module" : "modules";
                String names = intersection.size() == 1 ? '`' + (String)CollectionsKt.first((Iterable)intersection) + '`' : StringUtilsKt.joinToArrayString(intersection);
                String string3 = "Module `" + name + "` depends on " + m + ' ' + names + " with different kinds simultaneously";
                throw new IllegalArgumentException(string3.toString());
            }
            return new ModuleNameAndDependencies(name, (List)dependenciesNames.element, (List<String>)friendsNames, (List<String>)dependsOnNames);
        }

        /*
         * WARNING - void declaration
         */
        private final void finishGlobalDirectives() {
            void $this$onEach$iv;
            void var3_4;
            Iterable iterable = this.directivesBuilder.build();
            ModuleStructureExtractorWorker moduleStructureExtractorWorker = this;
            boolean $i$f$onEach = false;
            void $this$onEach_u24lambda_u2419$iv = var3_4 = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
                Directive it = (Directive)element$iv;
                boolean bl2 = false;
                ModuleStructureExtractorWorker.checkDirectiveApplicability$default(this, it, true, false, false, 6, null);
            }
            moduleStructureExtractorWorker.globalDirectives = (RegisteredDirectives)var3_4;
            this.resetModuleCaches();
            this.resetFileCaches();
        }

        private final void checkDirectiveApplicability(Directive $this$checkDirectiveApplicability, boolean contextIsGlobal, boolean contextIsModule, boolean contextIsFile) {
            List list;
            if ($this$checkDirectiveApplicability.getApplicability().getForGlobal() && contextIsGlobal) {
                return;
            }
            if ($this$checkDirectiveApplicability.getApplicability().getForModule() && contextIsModule) {
                return;
            }
            if ($this$checkDirectiveApplicability.getApplicability().getForFile() && contextIsFile) {
                return;
            }
            List $this$checkDirectiveApplicability_u24lambda_u2427 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (contextIsGlobal) {
                $this$checkDirectiveApplicability_u24lambda_u2427.add("Global");
            }
            if (contextIsModule) {
                $this$checkDirectiveApplicability_u24lambda_u2427.add("Module");
            }
            if (contextIsFile) {
                $this$checkDirectiveApplicability_u24lambda_u2427.add("File");
            }
            String context = CollectionsKt.joinToString$default((Iterable)CollectionsKt.build((List)list), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalStateException(("Directive " + $this$checkDirectiveApplicability + " has " + (Object)((Object)$this$checkDirectiveApplicability.getApplicability()) + " applicability but it declared in " + context).toString());
        }

        static /* synthetic */ void checkDirectiveApplicability$default(ModuleStructureExtractorWorker moduleStructureExtractorWorker, Directive directive, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            moduleStructureExtractorWorker.checkDirectiveApplicability(directive, bl, bl2, bl3);
        }

        /*
         * WARNING - void declaration
         */
        private final void finishModule(int lineNumber) {
            TestModule testModule;
            FrontendKind<?> frontendKind;
            TargetPlatform targetPlatform;
            TargetPlatform targetPlatform2;
            String moduleName;
            FrontendKind<?> frontendKind2;
            TargetBackend targetBackend;
            this.finishFile(lineNumber);
            boolean isImplicitModule = this.currentModuleName == null;
            RegisteredDirectives moduleDirectives = ModuleStructureExtractorImplKt.access$plus(ModuleStructureExtractorImplKt.access$plus(this.moduleDirectivesBuilder.build(), DefaultRegisteredDirectivesProviderKt.getDefaultDirectives(ModuleStructureExtractorImpl.this.getTestServices())), this.globalDirectives);
            Iterable $this$forEach$iv = moduleDirectives;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Directive it = (Directive)element$iv;
                boolean bl = false;
                ModuleStructureExtractorWorker.checkDirectiveApplicability$default(this, it, isImplicitModule, true, false, 4, null);
            }
            TargetBackend targetBackend2 = this.currentModuleTargetBackend;
            if (targetBackend2 == null) {
                targetBackend2 = targetBackend = this.getDefaultsProvider().getDefaultTargetBackend();
            }
            if ((frontendKind2 = this.currentModuleFrontendKind) == null) {
                frontendKind2 = this.getDefaultsProvider().getDefaultFrontend();
            }
            FrontendKind<?> frontendKind3 = frontendKind2;
            this.currentModuleLanguageVersionSettingsBuilder.configureUsingDirectives(moduleDirectives, ModuleStructureExtractorImpl.this.environmentConfigurators, targetBackend, Intrinsics.areEqual(frontendKind3, (Object)FrontendKinds.FIR.INSTANCE));
            String string = this.currentModuleName;
            if (string == null && (string = (String)CollectionsKt.firstOrNull(DefaultRegisteredDirectivesProviderKt.getDefaultDirectives(ModuleStructureExtractorImpl.this.getTestServices()).get(ModuleStructureDirectives.INSTANCE.getMODULE()))) == null) {
                string = moduleName = "main";
            }
            if ((targetPlatform2 = this.currentModuleTargetPlatform) == null && (targetPlatform2 = this.parseModulePlatformByName(moduleName)) == null) {
                targetPlatform2 = targetPlatform = this.getDefaultsProvider().getDefaultPlatform();
            }
            if ((frontendKind = this.currentModuleFrontendKind) == null) {
                frontendKind = this.getDefaultsProvider().getDefaultFrontend();
            }
            BackendKind<?> backendKind = BackendKinds.INSTANCE.fromTargetBackend(targetBackend);
            BinaryKind<?> binaryKind = this.getDefaultsProvider().getDefaultArtifactKind();
            if (binaryKind == null) {
                binaryKind = TestModuleStructureImpl.Companion.toArtifactKind(targetPlatform, frontendKind3);
            }
            if (!Intrinsics.areEqual((testModule = new TestModule(moduleName, targetPlatform, targetBackend, frontendKind, backendKind, binaryKind, this.filesOfCurrentModule, this.dependenciesOfCurrentModule, moduleDirectives, this.currentModuleLanguageVersionSettingsBuilder.build())).getFrontendKind(), (Object)FrontendKinds.FIR.INSTANCE) || !testModule.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects) || this.modules.isEmpty()) {
                void $this$flatMapTo$iv;
                Iterable bl = ModuleStructureExtractorImpl.this.getAdditionalSourceProviders();
                Collection destination$iv = this.filesOfCurrentModule;
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    boolean bl2;
                    List<TestFile> list;
                    AdditionalSourceProvider additionalSourceProvider;
                    block14: {
                        additionalSourceProvider = (AdditionalSourceProvider)element$iv;
                        boolean bl3 = false;
                        RegisteredDirectives registeredDirectives = this.globalDirectives;
                        if (registeredDirectives == null) {
                            registeredDirectives = RegisteredDirectives.Companion.getEmpty();
                        }
                        List<TestFile> additionalFiles = list = additionalSourceProvider.produceAdditionalFiles(registeredDirectives, testModule);
                        boolean bl4 = false;
                        Iterable $this$all$iv = additionalFiles;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv) {
                                TestFile it = (TestFile)element$iv2;
                                boolean bl5 = false;
                                if (it.isAdditional()) continue;
                                bl2 = false;
                                break block14;
                            }
                            bl2 = true;
                        }
                    }
                    if (!bl2) {
                        boolean bl6 = false;
                        String string2 = "Files produced by " + Reflection.getOrCreateKotlinClass(additionalSourceProvider.getClass()).getQualifiedName() + " should have flag `isAdditional = true`";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    Iterable list$iv = list;
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
            }
            ((Collection)this.modules).add(testModule);
            this.firstFileInModule = true;
            this.resetModuleCaches();
        }

        private final TargetPlatform parseModulePlatformByName(String moduleName) {
            TargetPlatform targetPlatform;
            String string = StringsKt.substringAfterLast((String)moduleName, (String)"-", (String)"").toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String nameSuffix = string;
            if (Intrinsics.areEqual((Object)nameSuffix, (Object)"COMMON")) {
                targetPlatform = CommonPlatforms.INSTANCE.getDefaultCommonPlatform();
            } else if (Intrinsics.areEqual((Object)nameSuffix, (Object)"JVM")) {
                targetPlatform = JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
            } else if (Intrinsics.areEqual((Object)nameSuffix, (Object)"JS")) {
                targetPlatform = JsPlatforms.INSTANCE.getDefaultJsPlatform();
            } else if (Intrinsics.areEqual((Object)nameSuffix, (Object)"WASM")) {
                targetPlatform = (TargetPlatform)WasmPlatforms.Default.INSTANCE;
            } else if (Intrinsics.areEqual((Object)nameSuffix, (Object)"NATIVE")) {
                targetPlatform = NativePlatforms.INSTANCE.getUnspecifiedNativePlatform();
            } else if (((CharSequence)nameSuffix).length() == 0) {
                targetPlatform = null;
            } else {
                throw new IllegalStateException("Can't determine platform by name " + nameSuffix);
            }
            return targetPlatform;
        }

        private final void finishFile(int lineNumber) {
            RegisteredDirectives registeredDirectives;
            RegisteredDirectives registeredDirectives2;
            Object object;
            Object object2;
            String filename;
            String actualDefaultFileName = this.currentModuleName == null ? this.getDefaultFileName() : "module_" + this.currentModuleName + '_' + this.getDefaultFileName();
            String string = this.currentFileName;
            if (string == null) {
                string = filename = actualDefaultFileName;
            }
            if (!this.allowFilesWithSameNames) {
                boolean bl;
                Object $this$any$iv;
                block13: {
                    $this$any$iv = this.filesOfCurrentModule;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        object2 = $this$any$iv.iterator();
                        while (object2.hasNext()) {
                            Object element$iv = object2.next();
                            TestFile it = (TestFile)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)filename)) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    StringBuilder stringBuilder = new StringBuilder().append("File with name \"").append(filename).append("\" already defined in module ");
                    String string2 = this.currentModuleName;
                    if (string2 == null) {
                        string2 = actualDefaultFileName;
                    }
                    $this$any$iv = stringBuilder.append(string2).toString();
                    throw new IllegalStateException($this$any$iv.toString());
                }
            }
            if ((object = this.fileDirectivesBuilder) != null && (object = ((RegisteredDirectivesParser)object).build()) != null) {
                Iterable bl2;
                Iterable $this$onEach$iv = (Iterable)object;
                boolean $i$f$onEach = false;
                Iterable $this$onEach_u24lambda_u2419$iv = bl2 = $this$onEach$iv;
                boolean bl = false;
                for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
                    Directive it = (Directive)element$iv;
                    boolean bl3 = false;
                    ModuleStructureExtractorWorker.checkDirectiveApplicability$default(this, it, false, false, true, 3, null);
                }
                registeredDirectives2 = (RegisteredDirectives)bl2;
            } else {
                registeredDirectives2 = null;
            }
            RegisteredDirectives directives = registeredDirectives2;
            Object $this$finishFile_u24lambda_u2435 = object2 = new StringBuilder();
            boolean bl = false;
            int n = this.endLineNumberOfLastFile;
            for (int i = 0; i < n; ++i) {
                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$finishFile_u24lambda_u2435).append('\n'), (String)"append(...)");
            }
            StringBuilder stringBuilder = ((StringBuilder)$this$finishFile_u24lambda_u2435).append(CollectionsKt.joinToString$default((Iterable)this.linesOfCurrentFile, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
            String string3 = ((StringBuilder)object2).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            String fileContent = string3;
            File file = this.currentTestDataFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentTestDataFile");
                file = null;
            }
            if ((registeredDirectives = directives) == null) {
                registeredDirectives = RegisteredDirectives.Companion.getEmpty();
            }
            this.filesOfCurrentModule.add(new TestFile(filename, fileContent, file, this.endLineNumberOfLastFile, false, registeredDirectives));
            this.firstFileInModule = false;
            this.endLineNumberOfLastFile = lineNumber - 1;
            this.resetFileCaches();
        }

        private final void resetModuleCaches() {
            this.firstFileInModule = true;
            this.currentModuleName = null;
            this.currentModuleTargetPlatform = null;
            this.currentModuleTargetBackend = null;
            this.currentModuleFrontendKind = null;
            this.currentModuleLanguageVersionSettingsBuilder = this.initLanguageSettingsBuilder();
            this.filesOfCurrentModule = new ArrayList();
            this.dependenciesOfCurrentModule = new ArrayList();
            this.resetDirectivesBuilder();
            this.moduleDirectivesBuilder = this.directivesBuilder;
        }

        private final void resetDirectivesBuilder() {
            this.directivesBuilder = new RegisteredDirectivesParser(this.directivesContainer, this.getAssertions());
        }

        private final void resetFileCaches() {
            if (!this.firstFileInModule) {
                this.linesOfCurrentFile = new ArrayList();
            }
            if (this.firstFileInModule) {
                this.moduleDirectivesBuilder = this.directivesBuilder;
            }
            this.currentFileName = null;
            this.resetDirectivesBuilder();
            this.fileDirectivesBuilder = this.directivesBuilder;
        }

        private final void tryParseRegularDirective(RegisteredDirectivesParser.RawDirective rawDirective) {
            if (rawDirective == null) {
                return;
            }
            RegisteredDirectivesParser.ParsedDirective parsedDirective = this.directivesBuilder.convertToRegisteredDirective(rawDirective);
            if (parsedDirective == null) {
                return;
            }
            RegisteredDirectivesParser.ParsedDirective parsedDirective2 = parsedDirective;
            this.directivesBuilder.addParsedDirective(parsedDirective2);
        }

        private final void validateFileName(String fileName) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = allowedExtensionsForFiles;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.endsWith$default((String)fileName, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                this.getAssertions().fail((Function0<String>)((Function0)() -> ModuleStructureExtractorWorker.validateFileName$lambda$37(fileName)));
                throw null;
            }
        }

        private final LanguageVersionSettingsBuilder initLanguageSettingsBuilder() {
            return this.getDefaultsProvider().newLanguageSettingsBuilder();
        }

        /*
         * WARNING - void declaration
         */
        private static final Iterable sortModules$lambda$4(Map $moduleByName, TestModule module) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$moduleByName, (String)"$moduleByName");
            Iterable $this$map$iv = module.getAllDependencies();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DependencyDescription dependencyDescription = (DependencyDescription)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String moduleName = it.getModuleName();
                TestModule testModule = (TestModule)$moduleByName.get(moduleName);
                if (testModule == null) {
                    throw new IllegalStateException(("Module \"" + moduleName + "\" not found while observing dependencies of \"" + module.getName() + '\"').toString());
                }
                collection.add(testModule);
            }
            return (List)destination$iv$iv;
        }

        private static final String tryParseStructureDirective$lambda$9(Directive $directive) {
            Intrinsics.checkNotNullParameter((Object)$directive, (String)"$directive");
            return "Target frontend specified incorrectly\nUsage: " + $directive.getDescription();
        }

        private static final String tryParseStructureDirective$lambda$10(String $name) {
            Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
            return "Unknown frontend: " + $name;
        }

        private static final String tryParseStructureDirective$lambda$11(ModuleStructureExtractorWorker this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return "Target platform already specified twice for module " + this$0.currentModuleName;
        }

        private static final String tryParseStructureDirective$lambda$13(Directive $directive) {
            Intrinsics.checkNotNullParameter((Object)$directive, (String)"$directive");
            return "Target platform specified incorrectly\nUsage: " + $directive.getDescription();
        }

        private static final String tryParseStructureDirective$lambda$14() {
            return "You can't specify `Common` platform in combination with others";
        }

        private static final String tryParseStructureDirective$lambda$16(ModuleStructureExtractorWorker this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return "Target platform already specified twice for module " + this$0.currentModuleName;
        }

        private static final String tryParseStructureDirective$lambda$17() {
            return "JVM target should be single";
        }

        private static final String tryParseStructureDirective$lambda$18() {
            return "Incorrect value for JVM target";
        }

        private static final String validateFileName$lambda$37(String $fileName) {
            Intrinsics.checkNotNullParameter((Object)$fileName, (String)"$fileName");
            return "Filename " + $fileName + " is not valid. Allowed extensions: " + StringUtilsKt.joinToArrayString(allowedExtensionsForFiles);
        }
    }
}

