/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.js.config.WasmTarget;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.test.directives.JsEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.WasmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DirectiveToConfigurationKeyExtractor;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.KlibBasedEnvironmentConfiguratorUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u000b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/WasmEnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "provideAdditionalAnalysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "directives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "provideConfigurationKeys", "", "Lorg/jetbrains/kotlin/test/services/DirectiveToConfigurationKeyExtractor;", "configureCompilerConfiguration", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nWasmEnvironmentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/WasmEnvironmentConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1557#2:106\n1628#2,3:107\n*S KotlinDebug\n*F\n+ 1 WasmEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/WasmEnvironmentConfigurator\n*L\n96#1:106\n96#1:107,3\n*E\n"})
public abstract class WasmEnvironmentConfigurator
extends EnvironmentConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public WasmEnvironmentConfigurator(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)WasmEnvironmentConfigurationDirectives.INSTANCE);
    }

    @Override
    @NotNull
    public Map<AnalysisFlag<?>, Object> provideAdditionalAnalysisFlags(@NotNull RegisteredDirectives directives, @NotNull LanguageVersion languageVersion) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)directives, (String)"directives");
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        Map it = map = MapsKt.toMutableMap(super.provideAdditionalAnalysisFlags(directives, languageVersion));
        boolean bl = false;
        it.put(AnalysisFlags.getAllowFullyQualifiedNameInKClass(), false);
        return map;
    }

    @Override
    public void provideConfigurationKeys(@NotNull DirectiveToConfigurationKeyExtractor $this$provideConfigurationKeys) {
        Intrinsics.checkNotNullParameter((Object)$this$provideConfigurationKeys, (String)"<this>");
        SimpleDirective simpleDirective = JsEnvironmentConfigurationDirectives.INSTANCE.getPROPERTY_LAZY_INITIALIZATION();
        CompilerConfigurationKey compilerConfigurationKey = JSConfigurationKeys.PROPERTY_LAZY_INITIALIZATION;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey, (String)"PROPERTY_LAZY_INITIALIZATION");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective, compilerConfigurationKey, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureCompilerConfiguration(@NotNull CompilerConfiguration configuration2, @NotNull TestModule module) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        RegisteredDirectives registeredDirectives = module.getDirectives();
        configuration2.put(JSConfigurationKeys.MODULE_KIND, (Object)ModuleKind.ES);
        configuration2.put(CommonConfigurationKeys.MODULE_NAME, (Object)module.getName());
        configuration2.put(JSConfigurationKeys.WASM_ENABLE_ASSERTS, (Object)true);
        configuration2.put(JSConfigurationKeys.WASM_ENABLE_ARRAY_RANGE_CHECKS, (Object)true);
        Iterable $this$map$iv = module.getFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TestFile testFile = (TestFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOriginalFile().getParent());
        }
        List sourceDirs = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        configuration2.put(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, (Object)sourceDirs);
        configuration2.put(JSConfigurationKeys.SOURCE_MAP, (Object)true);
        SourceMapSourceEmbedding sourceMapSourceEmbedding = (SourceMapSourceEmbedding)CollectionsKt.singleOrNull(registeredDirectives.get(JsEnvironmentConfigurationDirectives.INSTANCE.getSOURCE_MAP_EMBED_SOURCES()));
        if (sourceMapSourceEmbedding == null) {
            sourceMapSourceEmbedding = SourceMapSourceEmbedding.NEVER;
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding2 = sourceMapSourceEmbedding;
        configuration2.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, (Object)sourceMapSourceEmbedding2);
        configuration2.put(JSConfigurationKeys.WASM_USE_TRAPS_INSTEAD_OF_EXCEPTIONS, (Object)registeredDirectives.contains(WasmEnvironmentConfigurationDirectives.INSTANCE.getDISABLE_WASM_EXCEPTION_HANDLING()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/WasmEnvironmentConfigurator$Companion;", "Lorg/jetbrains/kotlin/test/services/configuration/KlibBasedEnvironmentConfiguratorUtils;", "<init>", "()V", "getRuntimePathsForModule", "", "", "target", "Lorg/jetbrains/kotlin/js/config/WasmTarget;", "getMainModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "isMainModule", "", "module", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nWasmEnvironmentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/WasmEnvironmentConfigurator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n669#2,11:106\n*S KotlinDebug\n*F\n+ 1 WasmEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/WasmEnvironmentConfigurator$Companion\n*L\n65#1:106,11\n*E\n"})
    public static final class Companion
    implements KlibBasedEnvironmentConfiguratorUtils {
        private Companion() {
        }

        @NotNull
        public final List<String> getRuntimePathsForModule(@NotNull WasmTarget target) {
            String string;
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
                case 1: {
                    string = "-js";
                    break;
                }
                case 2: {
                    string = "-wasi";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected wasi target".toString());
                }
            }
            String suffix = string;
            Object[] objectArray = new String[2];
            Intrinsics.checkNotNull((Object)System.getProperty("kotlin.wasm" + suffix + ".stdlib.path"));
            Intrinsics.checkNotNull((Object)System.getProperty("kotlin.wasm" + suffix + ".kotlin.test.path"));
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final TestModule getMainModule(@NotNull TestServices testServices) {
            TestModule testModule;
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            List<TestModule> modules = TestModuleStructureKt.getModuleStructure(testServices).getModules();
            boolean inferMainModule = TestModuleStructureKt.getModuleStructure(testServices).getAllDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getINFER_MAIN_MODULE());
            if (inferMainModule) {
                testModule = (TestModule)CollectionsKt.last(modules);
            } else {
                Object v1;
                block5: {
                    Iterable $this$singleOrNull$iv = modules;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        TestModule it = (TestModule)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"main")) continue;
                        if (found$iv) {
                            v1 = null;
                            break block5;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                if ((testModule = (TestModule)v1) == null) {
                    testModule = (TestModule)CollectionsKt.last(modules);
                }
            }
            return testModule;
        }

        public final boolean isMainModule(@NotNull TestModule module, @NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            return Intrinsics.areEqual((Object)module, (Object)this.getMainModule(testServices));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=50)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[WasmTarget.values().length];
                try {
                    nArray[WasmTarget.JS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WasmTarget.WASI.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

