/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codeMetaInfo.CodeMetaInfoParser;
import org.jetbrains.kotlin.codeMetaInfo.CodeMetaInfoRenderer;
import org.jetbrains.kotlin.codeMetaInfo.model.CodeMetaInfo;
import org.jetbrains.kotlin.codeMetaInfo.model.ParsedCodeMetaInfo;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AdditionalMetaInfoProcessor;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.ReversibleSourceFilePreprocessor;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\u0016\u001a\u00020\u000bJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0016\u001a\u00020\u000bJ\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0010J\u001c\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005J\u0006\u0010\u001c\u001a\u00020\u0014J\u001d\u0010\u001d\u001a\u00020\u001e*\u00060 j\u0002`\u001f2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00050\nX\u0082.\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0011\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "processors", "", "Lorg/jetbrains/kotlin/test/services/AdditionalMetaInfoProcessor;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/util/List;)V", "existingInfosPerFile", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "Lorg/jetbrains/kotlin/codeMetaInfo/model/ParsedCodeMetaInfo;", "infosPerFile", "", "", "Lorg/jetbrains/kotlin/codeMetaInfo/model/CodeMetaInfo;", "existingInfosPerFilePerInfoCache", "Lkotlin/Pair;", "parseExistingMetadataInfosFromAllSources", "", "getExistingMetaInfosForFile", "file", "getReportedMetaInfosForFile", "getExistingMetaInfosForActualMetadata", "metaInfo", "addMetadataInfosForFile", "codeMetaInfos", "compareAllMetaDataInfos", "stripAdditionalEmptyLines", "", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/test/model/TestFile;)Ljava/lang/CharSequence;", "test-infrastructure_test"})
@SourceDebugExtension(value={"SMAP\nGlobalMetadataInfoHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalMetadataInfoHandler.kt\norg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,97:1\n1368#2:98\n1454#2,5:99\n774#2:107\n865#2,2:108\n1863#2,2:121\n808#2,11:123\n1827#2,8:134\n381#3,3:104\n384#3,4:110\n381#3,7:114\n*S KotlinDebug\n*F\n+ 1 GlobalMetadataInfoHandler.kt\norg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler\n*L\n29#1:98\n29#1:99,5\n45#1:107\n45#1:108,2\n61#1:121,2\n69#1:123,11\n72#1:134,8\n44#1:104,3\n44#1:110,4\n50#1:114,7\n*E\n"})
public final class GlobalMetadataInfoHandler
implements TestService {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final List<AdditionalMetaInfoProcessor> processors;
    private Map<TestFile, ? extends List<ParsedCodeMetaInfo>> existingInfosPerFile;
    @NotNull
    private final Map<TestFile, List<CodeMetaInfo>> infosPerFile;
    @NotNull
    private final Map<Pair<TestFile, CodeMetaInfo>, List<ParsedCodeMetaInfo>> existingInfosPerFilePerInfoCache;

    public GlobalMetadataInfoHandler(@NotNull TestServices testServices, @NotNull List<? extends AdditionalMetaInfoProcessor> processors) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(processors, (String)"processors");
        this.testServices = testServices;
        this.processors = processors;
        this.infosPerFile = MapsKt.withDefaultMutable((Map)new LinkedHashMap(), GlobalMetadataInfoHandler::infosPerFile$lambda$0);
        this.existingInfosPerFilePerInfoCache = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public final void parseExistingMetadataInfosFromAllSources() {
        void $this$flatMapTo$iv$iv;
        Map map;
        Map map2 = map = MapsKt.createMapBuilder();
        GlobalMetadataInfoHandler globalMetadataInfoHandler = this;
        boolean bl = false;
        Iterable $this$flatMap$iv = TestModuleStructureKt.getModuleStructure(this.testServices).getModules();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TestModule it = (TestModule)element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        for (TestFile file : (List)destination$iv$iv) {
            void $this$parseExistingMetadataInfosFromAllSources_u24lambda_u242;
            $this$parseExistingMetadataInfosFromAllSources_u24lambda_u242.put(file, CodeMetaInfoParser.INSTANCE.getCodeMetaInfoFromText(file.getOriginalContent()));
        }
        globalMetadataInfoHandler.existingInfosPerFile = MapsKt.build((Map)map);
    }

    @NotNull
    public final List<ParsedCodeMetaInfo> getExistingMetaInfosForFile(@NotNull TestFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map<TestFile, ? extends List<ParsedCodeMetaInfo>> map = this.existingInfosPerFile;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"existingInfosPerFile");
            map = null;
        }
        return (List)MapsKt.getValue(map, (Object)file);
    }

    @NotNull
    public final List<CodeMetaInfo> getReportedMetaInfosForFile(@NotNull TestFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (List)MapsKt.getValue(this.infosPerFile, (Object)file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ParsedCodeMetaInfo> getExistingMetaInfosForActualMetadata(@NotNull TestFile file, @NotNull CodeMetaInfo metaInfo) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)metaInfo, (String)"metaInfo");
        Map<Pair<TestFile, CodeMetaInfo>, List<ParsedCodeMetaInfo>> map = this.existingInfosPerFilePerInfoCache;
        Pair key$iv = TuplesKt.to((Object)file, (Object)metaInfo);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = this.getExistingMetaInfosForFile(file);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ParsedCodeMetaInfo it = (ParsedCodeMetaInfo)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)metaInfo)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List answer$iv = (List)destination$iv$iv;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (List)object;
    }

    public final void addMetadataInfosForFile(@NotNull TestFile file, @NotNull List<? extends CodeMetaInfo> codeMetaInfos) {
        List list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(codeMetaInfos, (String)"codeMetaInfos");
        Map<TestFile, List<CodeMetaInfo>> $this$getOrPut$iv = this.infosPerFile;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(file);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(file, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        List infos = list;
        CollectionsKt.addAll((Collection)infos, (Iterable)codeMetaInfos);
    }

    /*
     * WARNING - void declaration
     */
    public final void compareAllMetaDataInfos() {
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure(this.testServices);
        StringBuilder builder = new StringBuilder();
        for (TestModule module : moduleStructure.getModules()) {
            for (TestFile file : module.getFiles()) {
                void $this$filterIsInstanceTo$iv$iv;
                if (file.isAdditional()) continue;
                Iterable $this$forEach$iv = this.processors;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AdditionalMetaInfoProcessor it = (AdditionalMetaInfoProcessor)element$iv;
                    boolean bl = false;
                    it.processMetaInfos(module, file);
                }
                List codeMetaInfos = (List)MapsKt.getValue(this.infosPerFile, (Object)file);
                StringBuilder fileBuilder = new StringBuilder();
                CodeMetaInfoRenderer.INSTANCE.renderTagsToText(fileBuilder, codeMetaInfos, SourceFileProviderKt.getSourceFileProvider(this.testServices).getContentOfSourceFile(file));
                Iterable $this$filterIsInstance$iv = SourceFileProviderKt.getSourceFileProvider(this.testServices).getPreprocessors();
                boolean $i$f$filterIsInstance = false;
                Iterable bl = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ReversibleSourceFilePreprocessor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List reverseTransformers = (List)destination$iv$iv;
                String initialFileContent = ((Object)this.stripAdditionalEmptyLines(fileBuilder, file)).toString();
                List $this$foldRight$iv = reverseTransformers;
                boolean $i$f$foldRight = false;
                String accumulator$iv = initialFileContent;
                if (!$this$foldRight$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        void source;
                        Object element$iv$iv;
                        element$iv$iv = accumulator$iv;
                        ReversibleSourceFilePreprocessor transformer = (ReversibleSourceFilePreprocessor)iterator$iv.previous();
                        boolean bl2 = false;
                        accumulator$iv = transformer.revert(file, (String)source);
                    }
                }
                String actualFileContent = accumulator$iv;
                builder.append(actualFileContent);
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String actualText = string;
        Assertions.assertEqualsToFile$default((Assertions)AssertionsKt.getAssertions(this.testServices), (File)CollectionsKt.single(moduleStructure.getOriginalTestDataFiles()), actualText, null, 4, null);
    }

    private final CharSequence stripAdditionalEmptyLines(StringBuilder $this$stripAdditionalEmptyLines, TestFile file) {
        CharSequence charSequence;
        if (file.getStartLineNumberInOriginalFile() != 0) {
            charSequence = StringsKt.removePrefix((CharSequence)$this$stripAdditionalEmptyLines, (CharSequence)CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(1, file.getStartLineNumberInOriginalFile())), (CharSequence)"", null, null, (int)0, null, GlobalMetadataInfoHandler::stripAdditionalEmptyLines$lambda$8, (int)30, null));
        } else {
            String string = $this$stripAdditionalEmptyLines.toString();
            Intrinsics.checkNotNull((Object)string);
            charSequence = string;
        }
        return charSequence;
    }

    private static final List infosPerFile$lambda$0(TestFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final CharSequence stripAdditionalEmptyLines$lambda$8(int it) {
        return "\n";
    }
}

