/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners.ir;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.runners.ir.AbstractClassicJvmIrTextTest;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="compiler/testData/ir/irText")
@TestDataPath(value="$PROJECT_ROOT")
public class ClassicJvmIrTextTestGenerated
extends AbstractClassicJvmIrTextTest {
    @Test
    public void testAllFilesPresentInIrText() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, "declarations/multiplatform/k2");
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/types")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Types {
        @Test
        @TestMetadata(value="abbreviatedTypes.kt")
        public void testAbbreviatedTypes() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/abbreviatedTypes.kt");
        }

        @Test
        public void testAllFilesPresentInTypes() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/types"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="asOnPlatformType.kt")
        public void testAsOnPlatformType() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/asOnPlatformType.kt");
        }

        @Test
        @TestMetadata(value="castsInsideCoroutineInference.kt")
        public void testCastsInsideCoroutineInference() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/castsInsideCoroutineInference.kt");
        }

        @Test
        @TestMetadata(value="coercionToUnitInLambdaReturnValue.kt")
        public void testCoercionToUnitInLambdaReturnValue() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/coercionToUnitInLambdaReturnValue.kt");
        }

        @Test
        @TestMetadata(value="definitelyNonNull.kt")
        public void testDefinitelyNonNull() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/definitelyNonNull.kt");
        }

        @Test
        @TestMetadata(value="definitelyNonNullOverride.kt")
        public void testDefinitelyNonNullOverride() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/definitelyNonNullOverride.kt");
        }

        @Test
        @TestMetadata(value="definitelyNonNullSAM.kt")
        public void testDefinitelyNonNullSAM() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/definitelyNonNullSAM.kt");
        }

        @Test
        @TestMetadata(value="definitelyNonNullWithJava.kt")
        public void testDefinitelyNonNullWithJava() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/definitelyNonNullWithJava.kt");
        }

        @Test
        @TestMetadata(value="definitelyNotNullAsArgument.kt")
        public void testDefinitelyNotNullAsArgument() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/definitelyNotNullAsArgument.kt");
        }

        @Test
        @TestMetadata(value="definitelyNotNullAsReceiver.kt")
        public void testDefinitelyNotNullAsReceiver() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/definitelyNotNullAsReceiver.kt");
        }

        @Test
        @TestMetadata(value="definitelyNotNullWithIntersection1.kt")
        public void testDefinitelyNotNullWithIntersection1() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/definitelyNotNullWithIntersection1.kt");
        }

        @Test
        @TestMetadata(value="dontLeaveStubTypesInSetter.kt")
        public void testDontLeaveStubTypesInSetter() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/dontLeaveStubTypesInSetter.kt");
        }

        @Test
        @TestMetadata(value="genericDelegatedDeepProperty.kt")
        public void testGenericDelegatedDeepProperty() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/genericDelegatedDeepProperty.kt");
        }

        @Test
        @TestMetadata(value="genericFunWithStar.kt")
        public void testGenericFunWithStar() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/genericFunWithStar.kt");
        }

        @Test
        @TestMetadata(value="genericPropertyReferenceType.kt")
        public void testGenericPropertyReferenceType() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/genericPropertyReferenceType.kt");
        }

        @Test
        @TestMetadata(value="inStarProjectionInReceiverType.kt")
        public void testInStarProjectionInReceiverType() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/inStarProjectionInReceiverType.kt");
        }

        @Test
        @TestMetadata(value="inferenceOfDefinitelyNotNullableBoolean.kt")
        public void testInferenceOfDefinitelyNotNullableBoolean() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/inferenceOfDefinitelyNotNullableBoolean.kt");
        }

        @Test
        @TestMetadata(value="intersectionType1.kt")
        public void testIntersectionType1() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/intersectionType1.kt");
        }

        @Test
        @TestMetadata(value="intersectionType2.kt")
        public void testIntersectionType2() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/intersectionType2.kt");
        }

        @Test
        @TestMetadata(value="intersectionType3.kt")
        public void testIntersectionType3() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/intersectionType3.kt");
        }

        @Test
        @TestMetadata(value="intersectionTypeInSamType.kt")
        public void testIntersectionTypeInSamType() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/intersectionTypeInSamType.kt");
        }

        @Test
        @TestMetadata(value="javaWildcardType.kt")
        public void testJavaWildcardType() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/javaWildcardType.kt");
        }

        @Test
        @TestMetadata(value="kt36143.kt")
        public void testKt36143() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/kt36143.kt");
        }

        @Test
        @TestMetadata(value="kt49526.kt")
        public void testKt49526() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/kt49526.kt");
        }

        @Test
        @TestMetadata(value="localVariableOfIntersectionType.kt")
        public void testLocalVariableOfIntersectionType() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/localVariableOfIntersectionType.kt");
        }

        @Test
        @TestMetadata(value="rawTypeInSignature.kt")
        public void testRawTypeInSignature() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/rawTypeInSignature.kt");
        }

        @Test
        @TestMetadata(value="receiverOfIntersectionType.kt")
        public void testReceiverOfIntersectionType() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/receiverOfIntersectionType.kt");
        }

        @Test
        @TestMetadata(value="smartCastOnFakeOverrideReceiver.kt")
        public void testSmartCastOnFakeOverrideReceiver() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/smartCastOnFakeOverrideReceiver.kt");
        }

        @Test
        @TestMetadata(value="smartCastOnFieldReceiverOfGenericType.kt")
        public void testSmartCastOnFieldReceiverOfGenericType() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/smartCastOnFieldReceiverOfGenericType.kt");
        }

        @Test
        @TestMetadata(value="smartCastOnReceiverOfGenericType.kt")
        public void testSmartCastOnReceiverOfGenericType() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/smartCastOnReceiverOfGenericType.kt");
        }

        @Test
        @TestMetadata(value="starProjection.kt")
        public void testStarProjection() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/starProjection.kt");
        }

        @Test
        @TestMetadata(value="typeAliasWithUnsafeVariance.kt")
        public void testTypeAliasWithUnsafeVariance() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/typeAliasWithUnsafeVariance.kt");
        }

        @Test
        @TestMetadata(value="typeCheckOnDefinitelyNotNull.kt")
        public void testTypeCheckOnDefinitelyNotNull() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/typeCheckOnDefinitelyNotNull.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/types/nullChecks")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NullChecks {
            @Test
            public void testAllFilesPresentInNullChecks() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/types/nullChecks"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="enhancedNullability.kt")
            public void testEnhancedNullability() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/enhancedNullability.kt");
            }

            @Test
            @TestMetadata(value="enhancedNullabilityInDestructuringAssignment.kt")
            public void testEnhancedNullabilityInDestructuringAssignment() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/enhancedNullabilityInDestructuringAssignment.kt");
            }

            @Test
            @TestMetadata(value="enhancedNullabilityInForLoop.kt")
            public void testEnhancedNullabilityInForLoop() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/enhancedNullabilityInForLoop.kt");
            }

            @Test
            @TestMetadata(value="explicitEqualsAndCompareToCallsOnPlatformTypeReceiver.kt")
            public void testExplicitEqualsAndCompareToCallsOnPlatformTypeReceiver() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/explicitEqualsAndCompareToCallsOnPlatformTypeReceiver.kt");
            }

            @Test
            @TestMetadata(value="implicitNotNullOnPlatformType.kt")
            public void testImplicitNotNullOnPlatformType() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/implicitNotNullOnPlatformType.kt");
            }

            @Test
            @TestMetadata(value="nullCheckInElvisRhs.kt")
            public void testNullCheckInElvisRhs() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckInElvisRhs.kt");
            }

            @Test
            @TestMetadata(value="nullCheckOnInterfaceDelegation.kt")
            public void testNullCheckOnInterfaceDelegation() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnInterfaceDelegation.kt");
            }

            @Test
            @TestMetadata(value="nullabilityAssertionOnExtensionReceiver.kt")
            public void testNullabilityAssertionOnExtensionReceiver() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullabilityAssertionOnExtensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="platformTypeReceiver.kt")
            public void testPlatformTypeReceiver() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/platformTypeReceiver.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithMixedNullableAndNotNullableBounds.kt")
            public void testTypeParameterWithMixedNullableAndNotNullableBounds() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/typeParameterWithMixedNullableAndNotNullableBounds.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithMultipleNotNullableBounds.kt")
            public void testTypeParameterWithMultipleNotNullableBounds() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/typeParameterWithMultipleNotNullableBounds.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithMultipleNullableBounds.kt")
            public void testTypeParameterWithMultipleNullableBounds() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/typeParameterWithMultipleNullableBounds.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult")
            @TestDataPath(value="$PROJECT_ROOT")
            public class NullCheckOnLambdaResult {
                @Test
                public void testAllFilesPresentInNullCheckOnLambdaResult() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="nnStringVsT.kt")
                public void testNnStringVsT() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsT.kt");
                }

                @Test
                @TestMetadata(value="nnStringVsTAny.kt")
                public void testNnStringVsTAny() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTAny.kt");
                }

                @Test
                @TestMetadata(value="nnStringVsTConstrained.kt")
                public void testNnStringVsTConstrained() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTConstrained.kt");
                }

                @Test
                @TestMetadata(value="nnStringVsTXArray.kt")
                public void testNnStringVsTXArray() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTXArray.kt");
                }

                @Test
                @TestMetadata(value="nnStringVsTXString.kt")
                public void testNnStringVsTXString() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTXString.kt");
                }

                @Test
                @TestMetadata(value="stringVsAny.kt")
                public void testStringVsAny() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsAny.kt");
                }

                @Test
                @TestMetadata(value="stringVsT.kt")
                public void testStringVsT() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsT.kt");
                }

                @Test
                @TestMetadata(value="stringVsTAny.kt")
                public void testStringVsTAny() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTAny.kt");
                }

                @Test
                @TestMetadata(value="stringVsTConstrained.kt")
                public void testStringVsTConstrained() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTConstrained.kt");
                }

                @Test
                @TestMetadata(value="stringVsTXArray.kt")
                public void testStringVsTXArray() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTXArray.kt");
                }

                @Test
                @TestMetadata(value="stringVsTXString.kt")
                public void testStringVsTXString() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTXString.kt");
                }
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/stubs")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Stubs {
        @Test
        public void testAllFilesPresentInStubs() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/stubs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="arraysFromBuiltins.kt")
        public void testArraysFromBuiltins() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/arraysFromBuiltins.kt");
        }

        @Test
        @TestMetadata(value="builtinMap.kt")
        public void testBuiltinMap() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/builtinMap.kt");
        }

        @Test
        @TestMetadata(value="constFromBuiltins.kt")
        public void testConstFromBuiltins() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/constFromBuiltins.kt");
        }

        @Test
        @TestMetadata(value="genericClassInDifferentModule.kt")
        public void testGenericClassInDifferentModule() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/genericClassInDifferentModule.kt");
        }

        @Test
        @TestMetadata(value="javaConstructorWithTypeParameters.kt")
        public void testJavaConstructorWithTypeParameters() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaConstructorWithTypeParameters.kt");
        }

        @Test
        @TestMetadata(value="javaEnum.kt")
        public void testJavaEnum() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaEnum.kt");
        }

        @Test
        @TestMetadata(value="javaInnerClass.kt")
        public void testJavaInnerClass() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaInnerClass.kt");
        }

        @Test
        @TestMetadata(value="javaMethod.kt")
        public void testJavaMethod() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaMethod.kt");
        }

        @Test
        @TestMetadata(value="javaNestedClass.kt")
        public void testJavaNestedClass() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaNestedClass.kt");
        }

        @Test
        @TestMetadata(value="javaNestedClassesInHierarchy.kt")
        public void testJavaNestedClassesInHierarchy() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaNestedClassesInHierarchy.kt");
        }

        @Test
        @TestMetadata(value="javaStaticMethod.kt")
        public void testJavaStaticMethod() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaStaticMethod.kt");
        }

        @Test
        @TestMetadata(value="javaSyntheticProperty.kt")
        public void testJavaSyntheticProperty() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/javaSyntheticProperty.kt");
        }

        @Test
        @TestMetadata(value="jdkClassSyntheticProperty.kt")
        public void testJdkClassSyntheticProperty() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/jdkClassSyntheticProperty.kt");
        }

        @Test
        @TestMetadata(value="kotlinInnerClass.kt")
        public void testKotlinInnerClass() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/kotlinInnerClass.kt");
        }

        @Test
        @TestMetadata(value="simple.kt")
        public void testSimple() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/stubs/simple.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/singletons")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Singletons {
        @Test
        public void testAllFilesPresentInSingletons() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/singletons"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="companion.kt")
        public void testCompanion() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/singletons/companion.kt");
        }

        @Test
        @TestMetadata(value="enumEntry.kt")
        public void testEnumEntry() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/singletons/enumEntry.kt");
        }

        @Test
        @TestMetadata(value="object.kt")
        public void testObject() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/singletons/object.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/regressions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Regressions {
        @Test
        public void testAllFilesPresentInRegressions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/regressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="coercionInLoop.kt")
        public void testCoercionInLoop() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/coercionInLoop.kt");
        }

        @Test
        @TestMetadata(value="integerCoercionToT.kt")
        public void testIntegerCoercionToT() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/integerCoercionToT.kt");
        }

        @Test
        @TestMetadata(value="kt24114.kt")
        public void testKt24114() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/kt24114.kt");
        }

        @Test
        @TestMetadata(value="kt44855.kt")
        public void testKt44855() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/kt44855.kt");
        }

        @Test
        @TestMetadata(value="kt45236.kt")
        public void testKt45236() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/kt45236.kt");
        }

        @Test
        @TestMetadata(value="newInferenceFixationOrder1.kt")
        public void testNewInferenceFixationOrder1() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/newInferenceFixationOrder1.kt");
        }

        @Test
        @TestMetadata(value="noSyntheticTypeParameterLeftAfterPCLA.kt")
        public void testNoSyntheticTypeParameterLeftAfterPCLA() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/noSyntheticTypeParameterLeftAfterPCLA.kt");
        }

        @Test
        @TestMetadata(value="typeAliasCtorForGenericClass.kt")
        public void testTypeAliasCtorForGenericClass() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/typeAliasCtorForGenericClass.kt");
        }

        @Test
        @TestMetadata(value="typeParametersInImplicitCast.kt")
        public void testTypeParametersInImplicitCast() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/regressions/typeParametersInImplicitCast.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/properties")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Properties {
        @Test
        public void testAllFilesPresentInProperties() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/properties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/properties/backingField")
        @TestDataPath(value="$PROJECT_ROOT")
        public class BackingField {
            @Test
            public void testAllFilesPresentInBackingField() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/properties/backingField"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="backingFieldVisibility.kt")
            public void testBackingFieldVisibility() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/properties/backingField/backingFieldVisibility.kt");
            }

            @Test
            @TestMetadata(value="explicitBackingFieldType.kt")
            public void testExplicitBackingFieldType() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/properties/backingField/explicitBackingFieldType.kt");
            }

            @Test
            @TestMetadata(value="independentBackingFieldType.kt")
            public void testIndependentBackingFieldType() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/properties/backingField/independentBackingFieldType.kt");
            }

            @Test
            @TestMetadata(value="propertyTypeNarrowing.kt")
            public void testPropertyTypeNarrowing() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/properties/backingField/propertyTypeNarrowing.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/lambdas")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Lambdas {
        @Test
        public void testAllFilesPresentInLambdas() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/lambdas"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="anonymousFunction.kt")
        public void testAnonymousFunction() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/anonymousFunction.kt");
        }

        @Test
        @TestMetadata(value="destructuringInLambda.kt")
        public void testDestructuringInLambda() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/destructuringInLambda.kt");
        }

        @Test
        @TestMetadata(value="extensionLambda.kt")
        public void testExtensionLambda() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/extensionLambda.kt");
        }

        @Test
        @TestMetadata(value="justLambda.kt")
        public void testJustLambda() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/justLambda.kt");
        }

        @Test
        @TestMetadata(value="lambdaReturningUnit.kt")
        public void testLambdaReturningUnit() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/lambdaReturningUnit.kt");
        }

        @Test
        @TestMetadata(value="localFunction.kt")
        public void testLocalFunction() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/localFunction.kt");
        }

        @Test
        @TestMetadata(value="multipleImplicitReceivers.kt")
        public void testMultipleImplicitReceivers() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/multipleImplicitReceivers.kt");
        }

        @Test
        @TestMetadata(value="nonLocalReturn.kt")
        public void testNonLocalReturn() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/nonLocalReturn.kt");
        }

        @Test
        @TestMetadata(value="samAdapter.kt")
        public void testSamAdapter() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/lambdas/samAdapter.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/js")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Js {
        @Test
        public void testAllFilesPresentInJs() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/js"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/js/native")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Native {
            @Test
            public void testAllFilesPresentInNative() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/js/native"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/js/external")
        @TestDataPath(value="$PROJECT_ROOT")
        public class External {
            @Test
            public void testAllFilesPresentInExternal() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/js/external"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/js/dynamic")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Dynamic {
            @Test
            public void testAllFilesPresentInDynamic() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/js/dynamic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/firProblems")
    @TestDataPath(value="$PROJECT_ROOT")
    public class FirProblems {
        @Test
        @TestMetadata(value="AbstractMutableMap.kt")
        public void testAbstractMutableMap() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/AbstractMutableMap.kt");
        }

        @Test
        @TestMetadata(value="AllCandidates.kt")
        public void testAllCandidates() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/AllCandidates.kt");
        }

        @Test
        public void testAllFilesPresentInFirProblems() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/firProblems"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="AnnotationInAnnotation.kt")
        public void testAnnotationInAnnotation() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/AnnotationInAnnotation.kt");
        }

        @Test
        @TestMetadata(value="AnnotationLoader.kt")
        public void testAnnotationLoader() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/AnnotationLoader.kt");
        }

        @Test
        @TestMetadata(value="AnonymousAsReturnOfGenericFunction.kt")
        public void testAnonymousAsReturnOfGenericFunction() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/AnonymousAsReturnOfGenericFunction.kt");
        }

        @Test
        @TestMetadata(value="ArrayListOverrides.kt")
        public void testArrayListOverrides() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/ArrayListOverrides.kt");
        }

        @Test
        @TestMetadata(value="ArrayMap.kt")
        public void testArrayMap() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/ArrayMap.kt");
        }

        @Test
        @TestMetadata(value="AssignmentOperator.kt")
        public void testAssignmentOperator() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/AssignmentOperator.kt");
        }

        @Test
        @TestMetadata(value="candidateSymbol.kt")
        public void testCandidateSymbol() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/candidateSymbol.kt");
        }

        @Test
        @TestMetadata(value="cannotCastToFunction.kt")
        public void testCannotCastToFunction() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/cannotCastToFunction.kt");
        }

        @Test
        @TestMetadata(value="ClashResolutionDescriptor.kt")
        public void testClashResolutionDescriptor() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/ClashResolutionDescriptor.kt");
        }

        @Test
        @TestMetadata(value="coercionToUnitForNestedWhen.kt")
        public void testCoercionToUnitForNestedWhen() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/coercionToUnitForNestedWhen.kt");
        }

        @Test
        @TestMetadata(value="DeepCopyIrTree.kt")
        public void testDeepCopyIrTree() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/DeepCopyIrTree.kt");
        }

        @Test
        @TestMetadata(value="delegatedSetterShouldBeSpecialized.kt")
        public void testDelegatedSetterShouldBeSpecialized() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/delegatedSetterShouldBeSpecialized.kt");
        }

        @Test
        @TestMetadata(value="DelegationAndInheritanceFromJava.kt")
        public void testDelegationAndInheritanceFromJava() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/DelegationAndInheritanceFromJava.kt");
        }

        @Test
        @TestMetadata(value="deprecated.kt")
        public void testDeprecated() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/deprecated.kt");
        }

        @Test
        @TestMetadata(value="elvisOnBackingFieldInGetter.kt")
        public void testElvisOnBackingFieldInGetter() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/elvisOnBackingFieldInGetter.kt");
        }

        @Test
        @TestMetadata(value="emptyWhen.kt")
        public void testEmptyWhen() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/emptyWhen.kt");
        }

        @Test
        @TestMetadata(value="ErrorInDefaultValue.kt")
        public void testErrorInDefaultValue() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/ErrorInDefaultValue.kt");
        }

        @Test
        @TestMetadata(value="explicitIncrement.kt")
        public void testExplicitIncrement() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/explicitIncrement.kt");
        }

        @Test
        @TestMetadata(value="FakeOverrideInAnonymousWithDelegation.kt")
        public void testFakeOverrideInAnonymousWithDelegation() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/FakeOverrideInAnonymousWithDelegation.kt");
        }

        @Test
        @TestMetadata(value="FieldsFromJavaClass.kt")
        public void testFieldsFromJavaClass() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/FieldsFromJavaClass.kt");
        }

        @Test
        @TestMetadata(value="Fir2IrClassifierStorage.kt")
        public void testFir2IrClassifierStorage() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/Fir2IrClassifierStorage.kt");
        }

        @Test
        @TestMetadata(value="FirBuilder.kt")
        public void testFirBuilder() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/FirBuilder.kt");
        }

        @Test
        @TestMetadata(value="FlushFromAnonymous.kt")
        public void testFlushFromAnonymous() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/FlushFromAnonymous.kt");
        }

        @Test
        @TestMetadata(value="functionLiteralGenericSignature.kt")
        public void testFunctionLiteralGenericSignature() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/functionLiteralGenericSignature.kt");
        }

        @Test
        @TestMetadata(value="ImplicitReceiverStack.kt")
        public void testImplicitReceiverStack() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/ImplicitReceiverStack.kt");
        }

        @Test
        @TestMetadata(value="inapplicableCollectionSet.kt")
        public void testInapplicableCollectionSet() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/inapplicableCollectionSet.kt");
        }

        @Test
        @TestMetadata(value="InnerClassInAnonymous.kt")
        public void testInnerClassInAnonymous() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/InnerClassInAnonymous.kt");
        }

        @Test
        @TestMetadata(value="IntArrayAsVararg.kt")
        public void testIntArrayAsVararg() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/IntArrayAsVararg.kt");
        }

        @Test
        @TestMetadata(value="integerLiteralWithExpectedTypealiasType.kt")
        public void testIntegerLiteralWithExpectedTypealiasType() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/integerLiteralWithExpectedTypealiasType.kt");
        }

        @Test
        @TestMetadata(value="internalPotentialFakeOverride.kt")
        public void testInternalPotentialFakeOverride() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/internalPotentialFakeOverride.kt");
        }

        @Test
        @TestMetadata(value="internalPotentialOverride.kt")
        public void testInternalPotentialOverride() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/internalPotentialOverride.kt");
        }

        @Test
        @TestMetadata(value="kt19251.kt")
        public void testKt19251() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/kt19251.kt");
        }

        @Test
        @TestMetadata(value="kt43342.kt")
        public void testKt43342() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/kt43342.kt");
        }

        @Test
        @TestMetadata(value="kt55458.kt")
        public void testKt55458() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/kt55458.kt");
        }

        @Test
        @TestMetadata(value="kt59102.kt")
        public void testKt59102() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/kt59102.kt");
        }

        @Test
        @TestMetadata(value="lambdaInEnumEntryConstructorCall.kt")
        public void testLambdaInEnumEntryConstructorCall() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/lambdaInEnumEntryConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="localClassUsedBeforeDeclaration.kt")
        public void testLocalClassUsedBeforeDeclaration() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/localClassUsedBeforeDeclaration.kt");
        }

        @Test
        @TestMetadata(value="localCompanion.kt")
        public void testLocalCompanion() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/localCompanion.kt");
        }

        @Test
        @TestMetadata(value="LocalSuspendFun.kt")
        public void testLocalSuspendFun() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/LocalSuspendFun.kt");
        }

        @Test
        @TestMetadata(value="Modality.kt")
        public void testModality() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/Modality.kt");
        }

        @Test
        @TestMetadata(value="MultiList.kt")
        public void testMultiList() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/MultiList.kt");
        }

        @Test
        @TestMetadata(value="noErrorTypeAfterCaptureApproximation.kt")
        public void testNoErrorTypeAfterCaptureApproximation() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/noErrorTypeAfterCaptureApproximation.kt");
        }

        @Test
        @TestMetadata(value="OutBox.kt")
        public void testOutBox() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/OutBox.kt");
        }

        @Test
        @TestMetadata(value="putIfAbsent.kt")
        public void testPutIfAbsent() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/putIfAbsent.kt");
        }

        @Test
        @TestMetadata(value="readWriteProperty.kt")
        public void testReadWriteProperty() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/readWriteProperty.kt");
        }

        @Test
        @TestMetadata(value="recursiveCapturedTypeInPropertyReference.kt")
        public void testRecursiveCapturedTypeInPropertyReference() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/recursiveCapturedTypeInPropertyReference.kt");
        }

        @Test
        @TestMetadata(value="reflectFindAnnotationOnDefaultMethodParameter.kt")
        public void testReflectFindAnnotationOnDefaultMethodParameter() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/reflectFindAnnotationOnDefaultMethodParameter.kt");
        }

        @Test
        @TestMetadata(value="reflectGetOnNullableTypeAlias.kt")
        public void testReflectGetOnNullableTypeAlias() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/reflectGetOnNullableTypeAlias.kt");
        }

        @Test
        @TestMetadata(value="SafeLetWithReturn.kt")
        public void testSafeLetWithReturn() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/SafeLetWithReturn.kt");
        }

        @Test
        @TestMetadata(value="SameJavaFieldReferences.kt")
        public void testSameJavaFieldReferences() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/SameJavaFieldReferences.kt");
        }

        @Test
        @TestMetadata(value="SignatureClash.kt")
        public void testSignatureClash() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/SignatureClash.kt");
        }

        @Test
        @TestMetadata(value="SignatureComputationComplexJavaGeneric.kt")
        public void testSignatureComputationComplexJavaGeneric() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/SignatureComputationComplexJavaGeneric.kt");
        }

        @Test
        @TestMetadata(value="SimpleTypeMarker.kt")
        public void testSimpleTypeMarker() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/SimpleTypeMarker.kt");
        }

        @Test
        @TestMetadata(value="substitutionOverrideWithDelegate.kt")
        public void testSubstitutionOverrideWithDelegate() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/substitutionOverrideWithDelegate.kt");
        }

        @Test
        @TestMetadata(value="SyntheticSetterType.kt")
        public void testSyntheticSetterType() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/SyntheticSetterType.kt");
        }

        @Test
        @TestMetadata(value="thisInEnumConstructor.kt")
        public void testThisInEnumConstructor() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/thisInEnumConstructor.kt");
        }

        @Test
        @TestMetadata(value="throwableStackTrace.kt")
        public void testThrowableStackTrace() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/throwableStackTrace.kt");
        }

        @Test
        @TestMetadata(value="timesInBuilder.kt")
        public void testTimesInBuilder() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/timesInBuilder.kt");
        }

        @Test
        @TestMetadata(value="TypeAliasConstructorParameterMapping.kt")
        public void testTypeAliasConstructorParameterMapping() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/TypeAliasConstructorParameterMapping.kt");
        }

        @Test
        @TestMetadata(value="TypeParameterBounds.kt")
        public void testTypeParameterBounds() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/TypeParameterBounds.kt");
        }

        @Test
        @TestMetadata(value="typeParameterFromJavaClass.kt")
        public void testTypeParameterFromJavaClass() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/typeParameterFromJavaClass.kt");
        }

        @Test
        @TestMetadata(value="TypeParameterInClashingAccessor.kt")
        public void testTypeParameterInClashingAccessor() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/TypeParameterInClashingAccessor.kt");
        }

        @Test
        @TestMetadata(value="TypeParameterInNestedClass.kt")
        public void testTypeParameterInNestedClass() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/TypeParameterInNestedClass.kt");
        }

        @Test
        @TestMetadata(value="typeVariableAfterBuildMap.kt")
        public void testTypeVariableAfterBuildMap() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/typeVariableAfterBuildMap.kt");
        }

        @Test
        @TestMetadata(value="V8ArrayToList.kt")
        public void testV8ArrayToList() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/V8ArrayToList.kt");
        }

        @Test
        @TestMetadata(value="valueClassEquals.kt")
        public void testValueClassEquals() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/valueClassEquals.kt");
        }

        @Test
        @TestMetadata(value="VarInInit.kt")
        public void testVarInInit() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/VarInInit.kt");
        }

        @Test
        @TestMetadata(value="VarargIntegerLiteral.kt")
        public void testVarargIntegerLiteral() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/firProblems/VarargIntegerLiteral.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides")
    @TestDataPath(value="$PROJECT_ROOT")
    public class FakeOverrides {
        @Test
        public void testAllFilesPresentInFakeOverrides() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="annotatedTypeParameter.kt")
        public void testAnnotatedTypeParameter() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/annotatedTypeParameter.kt");
        }

        @Test
        @TestMetadata(value="fakeOverrideOfRaw.kt")
        public void testFakeOverrideOfRaw() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/fakeOverrideOfRaw.kt");
        }

        @Test
        @TestMetadata(value="fakeOverrideOfRawJavaCollection.kt")
        public void testFakeOverrideOfRawJavaCollection() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/fakeOverrideOfRawJavaCollection.kt");
        }

        @Test
        @TestMetadata(value="intersectionWithJava.kt")
        public void testIntersectionWithJava() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/intersectionWithJava.kt");
        }

        @Test
        @TestMetadata(value="intersectionWithMappedSignature.kt")
        public void testIntersectionWithMappedSignature() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/intersectionWithMappedSignature.kt");
        }

        @Test
        @TestMetadata(value="intersectionWithRawType.kt")
        public void testIntersectionWithRawType() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/intersectionWithRawType.kt");
        }

        @Test
        @TestMetadata(value="kjkWithRawTypes.kt")
        public void testKjkWithRawTypes() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/kjkWithRawTypes.kt");
        }

        @Test
        @TestMetadata(value="setterVisibliity.kt")
        public void testSetterVisibliity() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/setterVisibliity.kt");
        }

        @Test
        @TestMetadata(value="setterVisibliityWithJava.kt")
        public void testSetterVisibliityWithJava() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/setterVisibliityWithJava.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/void")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Void {
            @Test
            public void testAllFilesPresentInVoid() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/void"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="basicVoidOverride.kt")
            public void testBasicVoidOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/void/basicVoidOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionVoidOverride.kt")
            public void testIntersectionVoidOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/void/intersectionVoidOverride.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/visibility")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Visibility {
            @Test
            public void testAllFilesPresentInVisibility() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/visibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="allPropertiesAndMethodsKJ.kt")
            public void testAllPropertiesAndMethodsKJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/allPropertiesAndMethodsKJ.kt");
            }

            @Test
            @TestMetadata(value="allPropertiesAndMethodsKJJ.kt")
            public void testAllPropertiesAndMethodsKJJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/allPropertiesAndMethodsKJJ.kt");
            }

            @Test
            @TestMetadata(value="allPropertiesAndMethodsKJK.kt")
            public void testAllPropertiesAndMethodsKJK() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/allPropertiesAndMethodsKJK.kt");
            }

            @Test
            @TestMetadata(value="allPropertiesAndMethodsKJKJ.kt")
            public void testAllPropertiesAndMethodsKJKJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/allPropertiesAndMethodsKJKJ.kt");
            }

            @Test
            @TestMetadata(value="allPropertiesAndMethodsWithSeparateModuleKJJ.kt")
            public void testAllPropertiesAndMethodsWithSeparateModuleKJJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/allPropertiesAndMethodsWithSeparateModuleKJJ.kt");
            }

            @Test
            @TestMetadata(value="internalOverrideCrossModule.kt")
            public void testInternalOverrideCrossModule() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/internalOverrideCrossModule.kt");
            }

            @Test
            @TestMetadata(value="internalOverrideWithFriendModule.kt")
            public void testInternalOverrideWithFriendModule() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/internalOverrideWithFriendModule.kt");
            }

            @Test
            @TestMetadata(value="internalWithPublishedApiOverride.kt")
            public void testInternalWithPublishedApiOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/internalWithPublishedApiOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionVisibilityOverrideKJJ.kt")
            public void testIntersectionVisibilityOverrideKJJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/intersectionVisibilityOverrideKJJ.kt");
            }

            @Test
            @TestMetadata(value="intersectionVisibilityOverrideKJK.kt")
            public void testIntersectionVisibilityOverrideKJK() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/intersectionVisibilityOverrideKJK.kt");
            }

            @Test
            @TestMetadata(value="intersectionWithPublishedApiOverride.kt")
            public void testIntersectionWithPublishedApiOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/intersectionWithPublishedApiOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionWithSeparateModule.kt")
            public void testIntersectionWithSeparateModule() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/intersectionWithSeparateModule.kt");
            }

            @Test
            @TestMetadata(value="overrideKotlinMethodsKJKK.kt")
            public void testOverrideKotlinMethodsKJKK() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/overrideKotlinMethodsKJKK.kt");
            }

            @Test
            @TestMetadata(value="overridePropertiesKJKK.kt")
            public void testOverridePropertiesKJKK() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/overridePropertiesKJKK.kt");
            }

            @Test
            @TestMetadata(value="overrideSetAndGetKJK.kt")
            public void testOverrideSetAndGetKJK() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/visibility/overrideSetAndGetKJK.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/vararg")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Vararg {
            @Test
            public void testAllFilesPresentInVararg() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/vararg"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="basicVarargOverride.kt")
            public void testBasicVarargOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/vararg/basicVarargOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionOnVarargOverride.kt")
            public void testIntersectionOnVarargOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/vararg/intersectionOnVarargOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionWithGenericOnVarargOverride.kt")
            public void testIntersectionWithGenericOnVarargOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/vararg/intersectionWithGenericOnVarargOverride.kt");
            }

            @Test
            @TestMetadata(value="substitutionOnVarargOverride.kt")
            public void testSubstitutionOnVarargOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/vararg/substitutionOnVarargOverride.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/typenothing")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Typenothing {
            @Test
            public void testAllFilesPresentInTypenothing() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/typenothing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="baseOverrideOnNothing.kt")
            public void testBaseOverrideOnNothing() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/typenothing/baseOverrideOnNothing.kt");
            }

            @Test
            @TestMetadata(value="intersectionOverrrideOnNothing.kt")
            public void testIntersectionOverrrideOnNothing() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/typenothing/intersectionOverrrideOnNothing.kt");
            }

            @Test
            @TestMetadata(value="substitutionOverrideOnNothing.kt")
            public void testSubstitutionOverrideOnNothing() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/typenothing/substitutionOverrideOnNothing.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/platformtypes")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Platformtypes {
            @Test
            public void testAllFilesPresentInPlatformtypes() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/platformtypes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="basicCollectionOverrideOnComplexHierarchy.kt")
            public void testBasicCollectionOverrideOnComplexHierarchy() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/basicCollectionOverrideOnComplexHierarchy.kt");
            }

            @Test
            @TestMetadata(value="basicCollectionsOverride.kt")
            public void testBasicCollectionsOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/basicCollectionsOverride.kt");
            }

            @Test
            @TestMetadata(value="basicOverride.kt")
            public void testBasicOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/basicOverride.kt");
            }

            @Test
            @TestMetadata(value="basicOverrideOnComplexHierarchy.kt")
            public void testBasicOverrideOnComplexHierarchy() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/basicOverrideOnComplexHierarchy.kt");
            }

            @Test
            @TestMetadata(value="combinationExplicitImlicitOverride.kt")
            public void testCombinationExplicitImlicitOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/combinationExplicitImlicitOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionOnComplexHierarchy.kt")
            public void testIntersectionOnComplexHierarchy() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/intersectionOnComplexHierarchy.kt");
            }

            @Test
            @TestMetadata(value="intersectionOverride.kt")
            public void testIntersectionOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/intersectionOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionOverrideOnCollections.kt")
            public void testIntersectionOverrideOnCollections() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/intersectionOverrideOnCollections.kt");
            }

            @Test
            @TestMetadata(value="intersectionWithExplicitOverride.kt")
            public void testIntersectionWithExplicitOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/intersectionWithExplicitOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionWithGenericExplicitOverride.kt")
            public void testIntersectionWithGenericExplicitOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/intersectionWithGenericExplicitOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionWithGenericOnComplexHierarchy.kt")
            public void testIntersectionWithGenericOnComplexHierarchy() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/intersectionWithGenericOnComplexHierarchy.kt");
            }

            @Test
            @TestMetadata(value="intersectionWithGenericOverride.kt")
            public void testIntersectionWithGenericOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/intersectionWithGenericOverride.kt");
            }

            @Test
            @TestMetadata(value="substitutionOverride.kt")
            public void testSubstitutionOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/substitutionOverride.kt");
            }

            @Test
            @TestMetadata(value="substitutionOverrideOnCollections.kt")
            public void testSubstitutionOverrideOnCollections() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/substitutionOverrideOnCollections.kt");
            }

            @Test
            @TestMetadata(value="substitutionOverrideOnComplexHierarchy.kt")
            public void testSubstitutionOverrideOnComplexHierarchy() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/substitutionOverrideOnComplexHierarchy.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/operators")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Operators {
            @Test
            public void testAllFilesPresentInOperators() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/operators"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="basicOperatorsOverride.kt")
            public void testBasicOperatorsOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/operators/basicOperatorsOverride.kt");
            }

            @Test
            @TestMetadata(value="basicOverrideOnComplexHierarchy.kt")
            public void testBasicOverrideOnComplexHierarchy() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/operators/basicOverrideOnComplexHierarchy.kt");
            }

            @Test
            @TestMetadata(value="intersectionOperatorsOverride.kt")
            public void testIntersectionOperatorsOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/operators/intersectionOperatorsOverride.kt");
            }

            @Test
            @TestMetadata(value="substitutionOperatorsOverride.kt")
            public void testSubstitutionOperatorsOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/operators/substitutionOperatorsOverride.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/number")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Number {
            @Test
            public void testAllFilesPresentInNumber() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/number"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="javaNumberOverride.kt")
            public void testJavaNumberOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/number/javaNumberOverride.kt");
            }

            @Test
            @TestMetadata(value="kotlinNumberOverride.kt")
            public void testKotlinNumberOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/number/kotlinNumberOverride.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/methodparameters")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Methodparameters {
            @Test
            public void testAllFilesPresentInMethodparameters() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/methodparameters"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="basicJavaThisOverride.kt")
            public void testBasicJavaThisOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/methodparameters/basicJavaThisOverride.kt");
            }

            @Test
            @TestMetadata(value="basicKotlinDefaultParametersOverride.kt")
            public void testBasicKotlinDefaultParametersOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/methodparameters/basicKotlinDefaultParametersOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionJavaThisOverride.kt")
            public void testIntersectionJavaThisOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/methodparameters/intersectionJavaThisOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionKotlinDefaultParametersOverride.kt")
            public void testIntersectionKotlinDefaultParametersOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/methodparameters/intersectionKotlinDefaultParametersOverride.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/methodmodifiers")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Methodmodifiers {
            @Test
            public void testAllFilesPresentInMethodmodifiers() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/methodmodifiers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="basicJavaModifiersOverride.kt")
            public void testBasicJavaModifiersOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/methodmodifiers/basicJavaModifiersOverride.kt");
            }

            @Test
            @TestMetadata(value="basicKotlinModifiersOverride.kt")
            public void testBasicKotlinModifiersOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/methodmodifiers/basicKotlinModifiersOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionJavaModifiersOverride.kt")
            public void testIntersectionJavaModifiersOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/methodmodifiers/intersectionJavaModifiersOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionKotlinModifiersOverride.kt")
            public void testIntersectionKotlinModifiersOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/methodmodifiers/intersectionKotlinModifiersOverride.kt");
            }

            @Test
            @TestMetadata(value="kotlinFunParamModifiersOverride.kt")
            public void testKotlinFunParamModifiersOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/methodmodifiers/kotlinFunParamModifiersOverride.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/kotlinextensions")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Kotlinextensions {
            @Test
            public void testAllFilesPresentInKotlinextensions() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/kotlinextensions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kotlinExtensionsOverride.kt")
            public void testKotlinExtensionsOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/kotlinextensions/kotlinExtensionsOverride.kt");
            }

            @Test
            @TestMetadata(value="memberExtensionOverride.kt")
            public void testMemberExtensionOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/kotlinextensions/memberExtensionOverride.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/javastatic")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Javastatic {
            @Test
            public void testAllFilesPresentInJavastatic() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/javastatic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="intersectionOverrideOnStaticKJJ.kt")
            public void testIntersectionOverrideOnStaticKJJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/intersectionOverrideOnStaticKJJ.kt");
            }

            @Test
            @TestMetadata(value="intersectionOverrideOnStaticKJK.kt")
            public void testIntersectionOverrideOnStaticKJK() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/intersectionOverrideOnStaticKJK.kt");
            }

            @Test
            @TestMetadata(value="staticOverrideOnComplexHierarchy.kt")
            public void testStaticOverrideOnComplexHierarchy() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/staticOverrideOnComplexHierarchy.kt");
            }

            @Test
            @TestMetadata(value="staticOverrideOnKJ.kt")
            public void testStaticOverrideOnKJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/staticOverrideOnKJ.kt");
            }

            @Test
            @TestMetadata(value="staticOverrideOnKJJ.kt")
            public void testStaticOverrideOnKJJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/staticOverrideOnKJJ.kt");
            }

            @Test
            @TestMetadata(value="staticOverrideOnKJK.kt")
            public void testStaticOverrideOnKJK() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/staticOverrideOnKJK.kt");
            }

            @Test
            @TestMetadata(value="staticOverrideOnKJKJ.kt")
            public void testStaticOverrideOnKJKJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/staticOverrideOnKJKJ.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/java21")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Java21 {
            @Test
            public void testAllFilesPresentInJava21() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/java21"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="sequenceCollectionIntersectionOverrideKJJ.kt")
            public void testSequenceCollectionIntersectionOverrideKJJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceCollectionIntersectionOverrideKJJ.kt");
            }

            @Test
            @TestMetadata(value="sequenceCollectionIntersectionOverrideKJK.kt")
            public void testSequenceCollectionIntersectionOverrideKJK() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceCollectionIntersectionOverrideKJK.kt");
            }

            @Test
            @TestMetadata(value="sequenceCollectionOverride.kt")
            public void testSequenceCollectionOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceCollectionOverride.kt");
            }

            @Test
            @TestMetadata(value="sequenceMapIntersectionOverrideKJJ.kt")
            public void testSequenceMapIntersectionOverrideKJJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceMapIntersectionOverrideKJJ.kt");
            }

            @Test
            @TestMetadata(value="sequenceMapOverride.kt")
            public void testSequenceMapOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceMapOverride.kt");
            }

            @Test
            @TestMetadata(value="sequenceMapOverrideKJ.kt")
            public void testSequenceMapOverrideKJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceMapOverrideKJ.kt");
            }

            @Test
            @TestMetadata(value="sequenceSetIntersectionOverrideKJJ.kt")
            public void testSequenceSetIntersectionOverrideKJJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceSetIntersectionOverrideKJJ.kt");
            }

            @Test
            @TestMetadata(value="sequenceSetIntersectionOverrideKJK.kt")
            public void testSequenceSetIntersectionOverrideKJK() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceSetIntersectionOverrideKJK.kt");
            }

            @Test
            @TestMetadata(value="sequenceSetOverride.kt")
            public void testSequenceSetOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceSetOverride.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/gettersetter")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Gettersetter {
            @Test
            public void testAllFilesPresentInGettersetter() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/gettersetter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="getterSetterOverrideOnKJ.kt")
            public void testGetterSetterOverrideOnKJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/gettersetter/getterSetterOverrideOnKJ.kt");
            }

            @Test
            @TestMetadata(value="getterSetterOverrideOnKJK.kt")
            public void testGetterSetterOverrideOnKJK() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/gettersetter/getterSetterOverrideOnKJK.kt");
            }

            @Test
            @TestMetadata(value="getterSetterOverrideonComplexHierarchy.kt")
            public void testGetterSetterOverrideonComplexHierarchy() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/gettersetter/getterSetterOverrideonComplexHierarchy.kt");
            }

            @Test
            @TestMetadata(value="getterSetterOvverideOnKJJ.kt")
            public void testGetterSetterOvverideOnKJJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/gettersetter/getterSetterOvverideOnKJJ.kt");
            }

            @Test
            @TestMetadata(value="getterSetterOvverrideOnKJKJ.kt")
            public void testGetterSetterOvverrideOnKJKJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/gettersetter/getterSetterOvverrideOnKJKJ.kt");
            }

            @Test
            @TestMetadata(value="intersectionOverrideForGetterSetter.kt")
            public void testIntersectionOverrideForGetterSetter() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/gettersetter/intersectionOverrideForGetterSetter.kt");
            }

            @Test
            @TestMetadata(value="substitutionOverrideForGetterSetter.kt")
            public void testSubstitutionOverrideForGetterSetter() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/gettersetter/substitutionOverrideForGetterSetter.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/generics")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Generics {
            @Test
            public void testAllFilesPresentInGenerics() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/generics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="basicGenericMethodsOverride.kt")
            public void testBasicGenericMethodsOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/basicGenericMethodsOverride.kt");
            }

            @Test
            @TestMetadata(value="basicGenericWithBoundsOverride.kt")
            public void testBasicGenericWithBoundsOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/basicGenericWithBoundsOverride.kt");
            }

            @Test
            @TestMetadata(value="basicRawTypeOverride.kt")
            public void testBasicRawTypeOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/basicRawTypeOverride.kt");
            }

            @Test
            @TestMetadata(value="basicWilcardsOverride.kt")
            public void testBasicWilcardsOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/basicWilcardsOverride.kt");
            }

            @Test
            @TestMetadata(value="genericMethodOverrideOnComplexHierarchy.kt")
            public void testGenericMethodOverrideOnComplexHierarchy() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/genericMethodOverrideOnComplexHierarchy.kt");
            }

            @Test
            @TestMetadata(value="genericMethodOverrideOnKJJ.kt")
            public void testGenericMethodOverrideOnKJJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/genericMethodOverrideOnKJJ.kt");
            }

            @Test
            @TestMetadata(value="genericMethodOverrideOnKJK.kt")
            public void testGenericMethodOverrideOnKJK() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/genericMethodOverrideOnKJK.kt");
            }

            @Test
            @TestMetadata(value="genericWithBoundsOnComplexHierarchy.kt")
            public void testGenericWithBoundsOnComplexHierarchy() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/genericWithBoundsOnComplexHierarchy.kt");
            }

            @Test
            @TestMetadata(value="genericWithBoundsOnKJJ.kt")
            public void testGenericWithBoundsOnKJJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/genericWithBoundsOnKJJ.kt");
            }

            @Test
            @TestMetadata(value="genericWithBoundsOnKJK.kt")
            public void testGenericWithBoundsOnKJK() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/genericWithBoundsOnKJK.kt");
            }

            @Test
            @TestMetadata(value="intersectionGenericMethodOverride.kt")
            public void testIntersectionGenericMethodOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/intersectionGenericMethodOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionGenericWithBoundsOverride.kt")
            public void testIntersectionGenericWithBoundsOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/intersectionGenericWithBoundsOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionRawTypeOverride.kt")
            public void testIntersectionRawTypeOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/intersectionRawTypeOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionWildcardsOverride.kt")
            public void testIntersectionWildcardsOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/intersectionWildcardsOverride.kt");
            }

            @Test
            @TestMetadata(value="rawTypeOverrideOnComplexHierarchy.kt")
            public void testRawTypeOverrideOnComplexHierarchy() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/rawTypeOverrideOnComplexHierarchy.kt");
            }

            @Test
            @TestMetadata(value="rawTypeOverrideOnKJJ.kt")
            public void testRawTypeOverrideOnKJJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/rawTypeOverrideOnKJJ.kt");
            }

            @Test
            @TestMetadata(value="wildcardsOverrideOnComplexHierarchy.kt")
            public void testWildcardsOverrideOnComplexHierarchy() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/wildcardsOverrideOnComplexHierarchy.kt");
            }

            @Test
            @TestMetadata(value="wildcardsOverrideOnKJJ.kt")
            public void testWildcardsOverrideOnKJJ() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/wildcardsOverrideOnKJJ.kt");
            }

            @Test
            @TestMetadata(value="wildcardsOverrideOnKJK.kt")
            public void testWildcardsOverrideOnKJK() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/generics/wildcardsOverrideOnKJK.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/fieldmodifiers")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Fieldmodifiers {
            @Test
            public void testAllFilesPresentInFieldmodifiers() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/fieldmodifiers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="javaModifiersOverride.kt")
            public void testJavaModifiersOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/fieldmodifiers/javaModifiersOverride.kt");
            }

            @Test
            @TestMetadata(value="kotlinModifiersOverride.kt")
            public void testKotlinModifiersOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/fieldmodifiers/kotlinModifiersOverride.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/enum")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Enum {
            @Test
            public void testAllFilesPresentInEnum() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="enumMethodOverride.kt")
            public void testEnumMethodOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/enum/enumMethodOverride.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/dataclass")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Dataclass {
            @Test
            public void testAllFilesPresentInDataclass() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/dataclass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="dataClassMethodOverride.kt")
            public void testDataClassMethodOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/dataclass/dataClassMethodOverride.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/collections")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Collections {
            @Test
            public void testAllFilesPresentInCollections() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/collections"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/collections/set")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Set {
                @Test
                public void testAllFilesPresentInSet() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/collections/set"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="intersectionSetOverrideKJJ.kt")
                public void testIntersectionSetOverrideKJJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/set/intersectionSetOverrideKJJ.kt");
                }

                @Test
                @TestMetadata(value="intersectionSetOverrideKJK.kt")
                public void testIntersectionSetOverrideKJK() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/set/intersectionSetOverrideKJK.kt");
                }

                @Test
                @TestMetadata(value="setOverrideKJ.kt")
                public void testSetOverrideKJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/set/setOverrideKJ.kt");
                }

                @Test
                @TestMetadata(value="setOverrideKJJ.kt")
                public void testSetOverrideKJJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/set/setOverrideKJJ.kt");
                }

                @Test
                @TestMetadata(value="setOverrideKJK.kt")
                public void testSetOverrideKJK() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/set/setOverrideKJK.kt");
                }

                @Test
                @TestMetadata(value="setOverrideKJKJ.kt")
                public void testSetOverrideKJKJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/set/setOverrideKJKJ.kt");
                }

                @Test
                @TestMetadata(value="setOverrideOnComplexHierarchy.kt")
                public void testSetOverrideOnComplexHierarchy() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/set/setOverrideOnComplexHierarchy.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/collections/map")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Map {
                @Test
                public void testAllFilesPresentInMap() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/collections/map"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="intersectionMapOverrideKJJ.kt")
                public void testIntersectionMapOverrideKJJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/intersectionMapOverrideKJJ.kt");
                }

                @Test
                @TestMetadata(value="intersectionMapOverrideKJK.kt")
                public void testIntersectionMapOverrideKJK() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/intersectionMapOverrideKJK.kt");
                }

                @Test
                @TestMetadata(value="intersectionWithGenericMapOverrideKJJ.kt")
                public void testIntersectionWithGenericMapOverrideKJJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/intersectionWithGenericMapOverrideKJJ.kt");
                }

                @Test
                @TestMetadata(value="intersectionWithGenericMapOverrideKJK.kt")
                public void testIntersectionWithGenericMapOverrideKJK() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/intersectionWithGenericMapOverrideKJK.kt");
                }

                @Test
                @TestMetadata(value="mapOverrideKJKJ.kt")
                public void testMapOverrideKJKJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/mapOverrideKJKJ.kt");
                }

                @Test
                @TestMetadata(value="mapOverrideOnComplexHierarchy.kt")
                public void testMapOverrideOnComplexHierarchy() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/mapOverrideOnComplexHierarchy.kt");
                }

                @Test
                @TestMetadata(value="mapOverrideOnKJ.kt")
                public void testMapOverrideOnKJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/mapOverrideOnKJ.kt");
                }

                @Test
                @TestMetadata(value="mapOverrideOnKJJ.kt")
                public void testMapOverrideOnKJJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/mapOverrideOnKJJ.kt");
                }

                @Test
                @TestMetadata(value="mapOverrrideOnKJK.kt")
                public void testMapOverrrideOnKJK() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/mapOverrrideOnKJK.kt");
                }

                @Test
                @TestMetadata(value="substitutionMapOverrideKJJ.kt")
                public void testSubstitutionMapOverrideKJJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/substitutionMapOverrideKJJ.kt");
                }

                @Test
                @TestMetadata(value="substitutionMapOverrideKJK.kt")
                public void testSubstitutionMapOverrideKJK() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/substitutionMapOverrideKJK.kt");
                }

                @Test
                @TestMetadata(value="substitutionMapOverrideOnKJKJ.kt")
                public void testSubstitutionMapOverrideOnKJKJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/substitutionMapOverrideOnKJKJ.kt");
                }

                @Test
                @TestMetadata(value="sunstitutionMapOverrideKJ.kt")
                public void testSunstitutionMapOverrideKJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/sunstitutionMapOverrideKJ.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/collections/list")
            @TestDataPath(value="$PROJECT_ROOT")
            public class List {
                @Test
                public void testAllFilesPresentInList() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/collections/list"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="intersectionListOverrideKJJ.kt")
                public void testIntersectionListOverrideKJJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/intersectionListOverrideKJJ.kt");
                }

                @Test
                @TestMetadata(value="intersectionListOverrideKJK.kt")
                public void testIntersectionListOverrideKJK() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/intersectionListOverrideKJK.kt");
                }

                @Test
                @TestMetadata(value="listOverrideKJ.kt")
                public void testListOverrideKJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/listOverrideKJ.kt");
                }

                @Test
                @TestMetadata(value="listOverrideKJJ.kt")
                public void testListOverrideKJJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/listOverrideKJJ.kt");
                }

                @Test
                @TestMetadata(value="listOverrideKJK.kt")
                public void testListOverrideKJK() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/listOverrideKJK.kt");
                }

                @Test
                @TestMetadata(value="listOverrideOnComplexHierarchy.kt")
                public void testListOverrideOnComplexHierarchy() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/listOverrideOnComplexHierarchy.kt");
                }

                @Test
                @TestMetadata(value="listOverrideOnKJKJ.kt")
                public void testListOverrideOnKJKJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/listOverrideOnKJKJ.kt");
                }

                @Test
                @TestMetadata(value="substitutionListOverrideKJ.kt")
                public void testSubstitutionListOverrideKJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/substitutionListOverrideKJ.kt");
                }

                @Test
                @TestMetadata(value="substitutionListOverrideKJJ.kt")
                public void testSubstitutionListOverrideKJJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/substitutionListOverrideKJJ.kt");
                }

                @Test
                @TestMetadata(value="substitutionListOverrideKJK.kt")
                public void testSubstitutionListOverrideKJK() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/substitutionListOverrideKJK.kt");
                }

                @Test
                @TestMetadata(value="substitutionListOverrideKJKJ.kt")
                public void testSubstitutionListOverrideKJKJ() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/substitutionListOverrideKJKJ.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/charsequence")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Charsequence {
            @Test
            public void testAllFilesPresentInCharsequence() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/charsequence"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="javaCharSequenceOverride.kt")
            public void testJavaCharSequenceOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/charsequence/javaCharSequenceOverride.kt");
            }

            @Test
            @TestMetadata(value="kotlinCharSequenceOverride.kt")
            public void testKotlinCharSequenceOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/charsequence/kotlinCharSequenceOverride.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/fakeOverrides/annotations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Annotations {
            @Test
            public void testAllFilesPresentInAnnotations() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="basicNullabilityAnnotationOverride.kt")
            public void testBasicNullabilityAnnotationOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/annotations/basicNullabilityAnnotationOverride.kt");
            }

            @Test
            @TestMetadata(value="intersectionNullabilityAnnotation.kt")
            public void testIntersectionNullabilityAnnotation() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/annotations/intersectionNullabilityAnnotation.kt");
            }

            @Test
            @TestMetadata(value="kotlinCustomAnnotationOverride.kt")
            public void testKotlinCustomAnnotationOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/annotations/kotlinCustomAnnotationOverride.kt");
            }

            @Test
            @TestMetadata(value="nullabilityAnnotationOverrideOnComplexHierarchy.kt")
            public void testNullabilityAnnotationOverrideOnComplexHierarchy() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/annotations/nullabilityAnnotationOverrideOnComplexHierarchy.kt");
            }

            @Test
            @TestMetadata(value="platformAnnotationOverride.kt")
            public void testPlatformAnnotationOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/annotations/platformAnnotationOverride.kt");
            }

            @Test
            @TestMetadata(value="typeArgumentAnnotationOverride.kt")
            public void testTypeArgumentAnnotationOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/annotations/typeArgumentAnnotationOverride.kt");
            }

            @Test
            @TestMetadata(value="typeParameterAnnotationOverride.kt")
            public void testTypeParameterAnnotationOverride() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/fakeOverrides/annotations/typeParameterAnnotationOverride.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/expressions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Expressions {
        @Test
        public void testAllFilesPresentInExpressions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="ambiguousFieldAccess.kt")
        public void testAmbiguousFieldAccess() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/ambiguousFieldAccess.kt");
        }

        @Test
        @TestMetadata(value="argumentMappedWithError.kt")
        public void testArgumentMappedWithError() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/argumentMappedWithError.kt");
        }

        @Test
        @TestMetadata(value="arrayAccess.kt")
        public void testArrayAccess() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/arrayAccess.kt");
        }

        @Test
        @TestMetadata(value="arrayAssignment.kt")
        public void testArrayAssignment() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/arrayAssignment.kt");
        }

        @Test
        @TestMetadata(value="arrayAugmentedAssignment1.kt")
        public void testArrayAugmentedAssignment1() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/arrayAugmentedAssignment1.kt");
        }

        @Test
        @TestMetadata(value="arrayAugmentedAssignment2.kt")
        public void testArrayAugmentedAssignment2() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/arrayAugmentedAssignment2.kt");
        }

        @Test
        @TestMetadata(value="assignments.kt")
        public void testAssignments() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/assignments.kt");
        }

        @Test
        @TestMetadata(value="augmentedAssignment1.kt")
        public void testAugmentedAssignment1() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/augmentedAssignment1.kt");
        }

        @Test
        @TestMetadata(value="augmentedAssignment2.kt")
        public void testAugmentedAssignment2() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/augmentedAssignment2.kt");
        }

        @Test
        @TestMetadata(value="augmentedAssignmentWithExpression.kt")
        public void testAugmentedAssignmentWithExpression() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/augmentedAssignmentWithExpression.kt");
        }

        @Test
        @TestMetadata(value="badBreakContinue.kt")
        public void testBadBreakContinue() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/badBreakContinue.kt");
        }

        @Test
        @TestMetadata(value="badInlinedBreakContinue.kt")
        public void testBadInlinedBreakContinue() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/badInlinedBreakContinue.kt");
        }

        @Test
        @TestMetadata(value="bangbang.kt")
        public void testBangbang() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/bangbang.kt");
        }

        @Test
        @TestMetadata(value="booleanConstsInAndAndOrOr.kt")
        public void testBooleanConstsInAndAndOrOr() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/booleanConstsInAndAndOrOr.kt");
        }

        @Test
        @TestMetadata(value="booleanOperators.kt")
        public void testBooleanOperators() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/booleanOperators.kt");
        }

        @Test
        @TestMetadata(value="boundCallableReferences.kt")
        public void testBoundCallableReferences() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/boundCallableReferences.kt");
        }

        @Test
        @TestMetadata(value="boxOk.kt")
        public void testBoxOk() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/boxOk.kt");
        }

        @Test
        @TestMetadata(value="breakContinue.kt")
        public void testBreakContinue() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/breakContinue.kt");
        }

        @Test
        @TestMetadata(value="breakContinueInLoopHeader.kt")
        public void testBreakContinueInLoopHeader() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/breakContinueInLoopHeader.kt");
        }

        @Test
        @TestMetadata(value="breakContinueInWhen.kt")
        public void testBreakContinueInWhen() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/breakContinueInWhen.kt");
        }

        @Test
        @TestMetadata(value="builtinOperators.kt")
        public void testBuiltinOperators() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/builtinOperators.kt");
        }

        @Test
        @TestMetadata(value="callWithReorderedArguments.kt")
        public void testCallWithReorderedArguments() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callWithReorderedArguments.kt");
        }

        @Test
        @TestMetadata(value="calls.kt")
        public void testCalls() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/calls.kt");
        }

        @Test
        @TestMetadata(value="castToTypeParameter.kt")
        public void testCastToTypeParameter() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/castToTypeParameter.kt");
        }

        @Test
        @TestMetadata(value="catchParameterAccess.kt")
        public void testCatchParameterAccess() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/catchParameterAccess.kt");
        }

        @Test
        @TestMetadata(value="chainOfSafeCalls.kt")
        public void testChainOfSafeCalls() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/chainOfSafeCalls.kt");
        }

        @Test
        @TestMetadata(value="chainedFunSuspendConversionForSimpleExpression.kt")
        public void testChainedFunSuspendConversionForSimpleExpression() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/chainedFunSuspendConversionForSimpleExpression.kt");
        }

        @Test
        @TestMetadata(value="classReference.kt")
        public void testClassReference() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/classReference.kt");
        }

        @Test
        @TestMetadata(value="coercionToUnit.kt")
        public void testCoercionToUnit() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/coercionToUnit.kt");
        }

        @Test
        @TestMetadata(value="complexAugmentedAssignment.kt")
        public void testComplexAugmentedAssignment() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/complexAugmentedAssignment.kt");
        }

        @Test
        @TestMetadata(value="constructorWithOwnTypeParametersCall.kt")
        public void testConstructorWithOwnTypeParametersCall() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/constructorWithOwnTypeParametersCall.kt");
        }

        @Test
        @TestMetadata(value="contructorCall.kt")
        public void testContructorCall() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/contructorCall.kt");
        }

        @Test
        @TestMetadata(value="conventionComparisons.kt")
        public void testConventionComparisons() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/conventionComparisons.kt");
        }

        @Test
        @TestMetadata(value="destructuring1.kt")
        public void testDestructuring1() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/destructuring1.kt");
        }

        @Test
        @TestMetadata(value="destructuringWithUnderscore.kt")
        public void testDestructuringWithUnderscore() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/destructuringWithUnderscore.kt");
        }

        @Test
        @TestMetadata(value="dotQualified.kt")
        public void testDotQualified() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/dotQualified.kt");
        }

        @Test
        @TestMetadata(value="elvis.kt")
        public void testElvis() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/elvis.kt");
        }

        @Test
        @TestMetadata(value="enumEntryAsReceiver.kt")
        public void testEnumEntryAsReceiver() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/enumEntryAsReceiver.kt");
        }

        @Test
        @TestMetadata(value="enumEntryReferenceFromEnumEntryClass.kt")
        public void testEnumEntryReferenceFromEnumEntryClass() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/enumEntryReferenceFromEnumEntryClass.kt");
        }

        @Test
        @TestMetadata(value="equality.kt")
        public void testEquality() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/equality.kt");
        }

        @Test
        @TestMetadata(value="equals.kt")
        public void testEquals() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/equals.kt");
        }

        @Test
        @TestMetadata(value="exclExclOnPlatformType.kt")
        public void testExclExclOnPlatformType() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/exclExclOnPlatformType.kt");
        }

        @Test
        @TestMetadata(value="exhaustiveWhenElseBranch.kt")
        public void testExhaustiveWhenElseBranch() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/exhaustiveWhenElseBranch.kt");
        }

        @Test
        @TestMetadata(value="extFunInvokeAsFun.kt")
        public void testExtFunInvokeAsFun() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/extFunInvokeAsFun.kt");
        }

        @Test
        @TestMetadata(value="extFunSafeInvoke.kt")
        public void testExtFunSafeInvoke() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/extFunSafeInvoke.kt");
        }

        @Test
        @TestMetadata(value="extensionPropertyGetterCall.kt")
        public void testExtensionPropertyGetterCall() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/extensionPropertyGetterCall.kt");
        }

        @Test
        @TestMetadata(value="field.kt")
        public void testField() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/field.kt");
        }

        @Test
        @TestMetadata(value="for.kt")
        public void testFor() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/for.kt");
        }

        @Test
        @TestMetadata(value="forWithBreakContinue.kt")
        public void testForWithBreakContinue() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/forWithBreakContinue.kt");
        }

        @Test
        @TestMetadata(value="forWithImplicitReceivers.kt")
        public void testForWithImplicitReceivers() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/forWithImplicitReceivers.kt");
        }

        @Test
        @TestMetadata(value="funImportedFromObject.kt")
        public void testFunImportedFromObject() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funImportedFromObject.kt");
        }

        @Test
        @TestMetadata(value="funInterfaceConstructorReference.kt")
        public void testFunInterfaceConstructorReference() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterfaceConstructorReference.kt");
        }

        @Test
        @TestMetadata(value="genericConstructorCallWithTypeArguments.kt")
        public void testGenericConstructorCallWithTypeArguments() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/genericConstructorCallWithTypeArguments.kt");
        }

        @Test
        @TestMetadata(value="genericPropertyCall.kt")
        public void testGenericPropertyCall() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/genericPropertyCall.kt");
        }

        @Test
        @TestMetadata(value="genericPropertyRef.kt")
        public void testGenericPropertyRef() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/genericPropertyRef.kt");
        }

        @Test
        @TestMetadata(value="genericReceiverOnExtensionWithSmartcast.kt")
        public void testGenericReceiverOnExtensionWithSmartcast() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/genericReceiverOnExtensionWithSmartcast.kt");
        }

        @Test
        @TestMetadata(value="identity.kt")
        public void testIdentity() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/identity.kt");
        }

        @Test
        @TestMetadata(value="ifElseIf.kt")
        public void testIfElseIf() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/ifElseIf.kt");
        }

        @Test
        @TestMetadata(value="ifWithArrayOperation.kt")
        public void testIfWithArrayOperation() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/ifWithArrayOperation.kt");
        }

        @Test
        @TestMetadata(value="ifWithAssignment.kt")
        public void testIfWithAssignment() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/ifWithAssignment.kt");
        }

        @Test
        @TestMetadata(value="ifWithLoop.kt")
        public void testIfWithLoop() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/ifWithLoop.kt");
        }

        @Test
        @TestMetadata(value="implicitCastInReturnFromConstructor.kt")
        public void testImplicitCastInReturnFromConstructor() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/implicitCastInReturnFromConstructor.kt");
        }

        @Test
        @TestMetadata(value="implicitCastOnPlatformType.kt")
        public void testImplicitCastOnPlatformType() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/implicitCastOnPlatformType.kt");
        }

        @Test
        @TestMetadata(value="implicitCastToNonNull.kt")
        public void testImplicitCastToNonNull() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/implicitCastToNonNull.kt");
        }

        @Test
        @TestMetadata(value="implicitCastToTypeParameter.kt")
        public void testImplicitCastToTypeParameter() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/implicitCastToTypeParameter.kt");
        }

        @Test
        @TestMetadata(value="implicitNotNullInDestructuringAssignment.kt")
        public void testImplicitNotNullInDestructuringAssignment() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/implicitNotNullInDestructuringAssignment.kt");
        }

        @Test
        @TestMetadata(value="in.kt")
        public void testIn() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/in.kt");
        }

        @Test
        @TestMetadata(value="incrementDecrement.kt")
        public void testIncrementDecrement() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/incrementDecrement.kt");
        }

        @Test
        @TestMetadata(value="inlinedBreakContinue.kt")
        public void testInlinedBreakContinue() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/inlinedBreakContinue.kt");
        }

        @Test
        @TestMetadata(value="interfaceThisRef.kt")
        public void testInterfaceThisRef() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/interfaceThisRef.kt");
        }

        @Test
        @TestMetadata(value="intersectedSmartcastForExtensionReceiverWithSameConstructor.kt")
        public void testIntersectedSmartcastForExtensionReceiverWithSameConstructor() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/intersectedSmartcastForExtensionReceiverWithSameConstructor.kt");
        }

        @Test
        @TestMetadata(value="javaSyntheticGenericPropretyAccess.kt")
        public void testJavaSyntheticGenericPropretyAccess() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/javaSyntheticGenericPropretyAccess.kt");
        }

        @Test
        @TestMetadata(value="javaSyntheticPropertyAccess.kt")
        public void testJavaSyntheticPropertyAccess() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/javaSyntheticPropertyAccess.kt");
        }

        @Test
        @TestMetadata(value="jvmFieldReferenceWithIntersectionTypes.kt")
        public void testJvmFieldReferenceWithIntersectionTypes() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/jvmFieldReferenceWithIntersectionTypes.kt");
        }

        @Test
        @TestMetadata(value="jvmInstanceFieldReference.kt")
        public void testJvmInstanceFieldReference() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/jvmInstanceFieldReference.kt");
        }

        @Test
        @TestMetadata(value="jvmStaticFieldReference.kt")
        public void testJvmStaticFieldReference() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/jvmStaticFieldReference.kt");
        }

        @Test
        @TestMetadata(value="kt16904.kt")
        public void testKt16904() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt16904.kt");
        }

        @Test
        @TestMetadata(value="kt16905.kt")
        public void testKt16905() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt16905.kt");
        }

        @Test
        @TestMetadata(value="kt23030.kt")
        public void testKt23030() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt23030.kt");
        }

        @Test
        @TestMetadata(value="kt24804.kt")
        public void testKt24804() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt24804.kt");
        }

        @Test
        @TestMetadata(value="kt27933.kt")
        public void testKt27933() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt27933.kt");
        }

        @Test
        @TestMetadata(value="kt28006.kt")
        public void testKt28006() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt28006.kt");
        }

        @Test
        @TestMetadata(value="kt28456.kt")
        public void testKt28456() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt28456.kt");
        }

        @Test
        @TestMetadata(value="kt28456a.kt")
        public void testKt28456a() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt28456a.kt");
        }

        @Test
        @TestMetadata(value="kt28456b.kt")
        public void testKt28456b() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt28456b.kt");
        }

        @Test
        @TestMetadata(value="kt30020.kt")
        public void testKt30020() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt30020.kt");
        }

        @Test
        @TestMetadata(value="kt30796.kt")
        public void testKt30796() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt30796.kt");
        }

        @Test
        @TestMetadata(value="kt35730.kt")
        public void testKt35730() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt35730.kt");
        }

        @Test
        @TestMetadata(value="kt36956.kt")
        public void testKt36956() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt36956.kt");
        }

        @Test
        @TestMetadata(value="kt36963.kt")
        public void testKt36963() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt36963.kt");
        }

        @Test
        @TestMetadata(value="kt37570.kt")
        public void testKt37570() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt37570.kt");
        }

        @Test
        @TestMetadata(value="kt37779.kt")
        public void testKt37779() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt37779.kt");
        }

        @Test
        @TestMetadata(value="kt42321.kt")
        public void testKt42321() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt42321.kt");
        }

        @Test
        @TestMetadata(value="kt44993.kt")
        public void testKt44993() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt44993.kt");
        }

        @Test
        @TestMetadata(value="kt45022.kt")
        public void testKt45022() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt45022.kt");
        }

        @Test
        @TestMetadata(value="kt47082.kt")
        public void testKt47082() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt47082.kt");
        }

        @Test
        @TestMetadata(value="kt47245.kt")
        public void testKt47245() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt47245.kt");
        }

        @Test
        @TestMetadata(value="kt47328.kt")
        public void testKt47328() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt47328.kt");
        }

        @Test
        @TestMetadata(value="kt47450.kt")
        public void testKt47450() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt47450.kt");
        }

        @Test
        @TestMetadata(value="kt48708.kt")
        public void testKt48708() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt48708.kt");
        }

        @Test
        @TestMetadata(value="kt48806.kt")
        public void testKt48806() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt48806.kt");
        }

        @Test
        @TestMetadata(value="kt49203.kt")
        public void testKt49203() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt49203.kt");
        }

        @Test
        @TestMetadata(value="kt50028.kt")
        public void testKt50028() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt50028.kt");
        }

        @Test
        @TestMetadata(value="kt51036.kt")
        public void testKt51036() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/kt51036.kt");
        }

        @Test
        @TestMetadata(value="lambdaInCAO.kt")
        public void testLambdaInCAO() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/lambdaInCAO.kt");
        }

        @Test
        @TestMetadata(value="literals.kt")
        public void testLiterals() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/literals.kt");
        }

        @Test
        @TestMetadata(value="memberTypeArguments.kt")
        public void testMemberTypeArguments() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/memberTypeArguments.kt");
        }

        @Test
        @TestMetadata(value="membersImportedFromObject.kt")
        public void testMembersImportedFromObject() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/membersImportedFromObject.kt");
        }

        @Test
        @TestMetadata(value="multipleSmartCasts.kt")
        public void testMultipleSmartCasts() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/multipleSmartCasts.kt");
        }

        @Test
        @TestMetadata(value="multipleThisReferences.kt")
        public void testMultipleThisReferences() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/multipleThisReferences.kt");
        }

        @Test
        @TestMetadata(value="nullCheckOnGenericLambdaReturn.kt")
        public void testNullCheckOnGenericLambdaReturn() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/nullCheckOnGenericLambdaReturn.kt");
        }

        @Test
        @TestMetadata(value="nullCheckOnLambdaReturn.kt")
        public void testNullCheckOnLambdaReturn() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/nullCheckOnLambdaReturn.kt");
        }

        @Test
        @TestMetadata(value="objectAsCallable.kt")
        public void testObjectAsCallable() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/objectAsCallable.kt");
        }

        @Test
        @TestMetadata(value="objectByNameInsideObject.kt")
        public void testObjectByNameInsideObject() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/objectByNameInsideObject.kt");
        }

        @Test
        @TestMetadata(value="objectClassReference.kt")
        public void testObjectClassReference() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/objectClassReference.kt");
        }

        @Test
        @TestMetadata(value="objectReference.kt")
        public void testObjectReference() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/objectReference.kt");
        }

        @Test
        @TestMetadata(value="objectReferenceInClosureInSuperConstructorCall.kt")
        public void testObjectReferenceInClosureInSuperConstructorCall() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/objectReferenceInClosureInSuperConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="objectReferenceInFieldInitializer.kt")
        public void testObjectReferenceInFieldInitializer() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/objectReferenceInFieldInitializer.kt");
        }

        @Test
        @TestMetadata(value="outerClassInstanceReference.kt")
        public void testOuterClassInstanceReference() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/outerClassInstanceReference.kt");
        }

        @Test
        @TestMetadata(value="posptonedPCLACallInsideStringInterpolation.kt")
        public void testPosptonedPCLACallInsideStringInterpolation() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/posptonedPCLACallInsideStringInterpolation.kt");
        }

        @Test
        @TestMetadata(value="primitiveComparisons.kt")
        public void testPrimitiveComparisons() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/primitiveComparisons.kt");
        }

        @Test
        @TestMetadata(value="primitivesImplicitConversions.kt")
        public void testPrimitivesImplicitConversions() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/primitivesImplicitConversions.kt");
        }

        @Test
        @TestMetadata(value="propertyReferences.kt")
        public void testPropertyReferences() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/propertyReferences.kt");
        }

        @Test
        @TestMetadata(value="protectedJavaFieldRef.kt")
        public void testProtectedJavaFieldRef() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/protectedJavaFieldRef.kt");
        }

        @Test
        @TestMetadata(value="references.kt")
        public void testReferences() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/references.kt");
        }

        @Test
        @TestMetadata(value="reflectionLiterals.kt")
        public void testReflectionLiterals() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/reflectionLiterals.kt");
        }

        @Test
        @TestMetadata(value="safeAssignment.kt")
        public void testSafeAssignment() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/safeAssignment.kt");
        }

        @Test
        @TestMetadata(value="safeCallWithIncrementDecrement.kt")
        public void testSafeCallWithIncrementDecrement() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/safeCallWithIncrementDecrement.kt");
        }

        @Test
        @TestMetadata(value="safeCalls.kt")
        public void testSafeCalls() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/safeCalls.kt");
        }

        @Test
        @TestMetadata(value="setFieldWithImplicitCast.kt")
        public void testSetFieldWithImplicitCast() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/setFieldWithImplicitCast.kt");
        }

        @Test
        @TestMetadata(value="signedToUnsignedConversions.kt")
        public void testSignedToUnsignedConversions() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/signedToUnsignedConversions.kt");
        }

        @Test
        @TestMetadata(value="simpleOperators.kt")
        public void testSimpleOperators() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/simpleOperators.kt");
        }

        @Test
        @TestMetadata(value="simpleUnaryOperators.kt")
        public void testSimpleUnaryOperators() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/simpleUnaryOperators.kt");
        }

        @Test
        @TestMetadata(value="smartCastAside.kt")
        public void testSmartCastAside() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/smartCastAside.kt");
        }

        @Test
        @TestMetadata(value="smartCastAside2.kt")
        public void testSmartCastAside2() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/smartCastAside2.kt");
        }

        @Test
        @TestMetadata(value="smartCasts.kt")
        public void testSmartCasts() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/smartCasts.kt");
        }

        @Test
        @TestMetadata(value="smartCastsWithDestructuring.kt")
        public void testSmartCastsWithDestructuring() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/smartCastsWithDestructuring.kt");
        }

        @Test
        @TestMetadata(value="specializedTypeAliasConstructorCall.kt")
        public void testSpecializedTypeAliasConstructorCall() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/specializedTypeAliasConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="stringComparisons.kt")
        public void testStringComparisons() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/stringComparisons.kt");
        }

        @Test
        @TestMetadata(value="stringPlus.kt")
        public void testStringPlus() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/stringPlus.kt");
        }

        @Test
        @TestMetadata(value="stringTemplates.kt")
        public void testStringTemplates() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/stringTemplates.kt");
        }

        @Test
        @TestMetadata(value="suspendConversionForExtensionFunction.kt")
        public void testSuspendConversionForExtensionFunction() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/suspendConversionForExtensionFunction.kt");
        }

        @Test
        @TestMetadata(value="suspendConversionInVararg.kt")
        public void testSuspendConversionInVararg() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/suspendConversionInVararg.kt");
        }

        @Test
        @TestMetadata(value="suspendConversionOnArbitraryExpression.kt")
        public void testSuspendConversionOnArbitraryExpression() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/suspendConversionOnArbitraryExpression.kt");
        }

        @Test
        @TestMetadata(value="suspendConversionWithFunInterfaces.kt")
        public void testSuspendConversionWithFunInterfaces() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/suspendConversionWithFunInterfaces.kt");
        }

        @Test
        @TestMetadata(value="temporaryInEnumEntryInitializer.kt")
        public void testTemporaryInEnumEntryInitializer() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/temporaryInEnumEntryInitializer.kt");
        }

        @Test
        @TestMetadata(value="temporaryInInitBlock.kt")
        public void testTemporaryInInitBlock() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/temporaryInInitBlock.kt");
        }

        @Test
        @TestMetadata(value="thisOfGenericOuterClass.kt")
        public void testThisOfGenericOuterClass() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/thisOfGenericOuterClass.kt");
        }

        @Test
        @TestMetadata(value="thisRefToObjectInNestedClassConstructorCall.kt")
        public void testThisRefToObjectInNestedClassConstructorCall() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/thisRefToObjectInNestedClassConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="thisReferenceBeforeClassDeclared.kt")
        public void testThisReferenceBeforeClassDeclared() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/thisReferenceBeforeClassDeclared.kt");
        }

        @Test
        @TestMetadata(value="throw.kt")
        public void testThrow() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/throw.kt");
        }

        @Test
        @TestMetadata(value="tryCatch.kt")
        public void testTryCatch() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/tryCatch.kt");
        }

        @Test
        @TestMetadata(value="tryCatchWithImplicitCast.kt")
        public void testTryCatchWithImplicitCast() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/tryCatchWithImplicitCast.kt");
        }

        @Test
        @TestMetadata(value="typeAliasConstructorReference.kt")
        public void testTypeAliasConstructorReference() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/typeAliasConstructorReference.kt");
        }

        @Test
        @TestMetadata(value="typeArguments.kt")
        public void testTypeArguments() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/typeArguments.kt");
        }

        @Test
        @TestMetadata(value="typeOperators.kt")
        public void testTypeOperators() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/typeOperators.kt");
        }

        @Test
        @TestMetadata(value="typeParameterClassLiteral.kt")
        public void testTypeParameterClassLiteral() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/typeParameterClassLiteral.kt");
        }

        @Test
        @TestMetadata(value="unsignedIntegerLiterals.kt")
        public void testUnsignedIntegerLiterals() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/unsignedIntegerLiterals.kt");
        }

        @Test
        @TestMetadata(value="useImportedMember.kt")
        public void testUseImportedMember() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/useImportedMember.kt");
        }

        @Test
        @TestMetadata(value="values.kt")
        public void testValues() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/values.kt");
        }

        @Test
        @TestMetadata(value="vararg.kt")
        public void testVararg() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/vararg.kt");
        }

        @Test
        @TestMetadata(value="varargWithImplicitCast.kt")
        public void testVarargWithImplicitCast() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/varargWithImplicitCast.kt");
        }

        @Test
        @TestMetadata(value="variableAsFunctionCall.kt")
        public void testVariableAsFunctionCall() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/variableAsFunctionCall.kt");
        }

        @Test
        @TestMetadata(value="variableAsFunctionCallWithGenerics.kt")
        public void testVariableAsFunctionCallWithGenerics() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/variableAsFunctionCallWithGenerics.kt");
        }

        @Test
        @TestMetadata(value="when.kt")
        public void testWhen() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/when.kt");
        }

        @Test
        @TestMetadata(value="whenCoercedToUnit.kt")
        public void testWhenCoercedToUnit() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whenCoercedToUnit.kt");
        }

        @Test
        @TestMetadata(value="whenElse.kt")
        public void testWhenElse() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whenElse.kt");
        }

        @Test
        @TestMetadata(value="whenReturn.kt")
        public void testWhenReturn() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whenReturn.kt");
        }

        @Test
        @TestMetadata(value="whenReturnUnit.kt")
        public void testWhenReturnUnit() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whenReturnUnit.kt");
        }

        @Test
        @TestMetadata(value="whenSmartCastToEnum.kt")
        public void testWhenSmartCastToEnum() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whenSmartCastToEnum.kt");
        }

        @Test
        @TestMetadata(value="whenUnusedExpression.kt")
        public void testWhenUnusedExpression() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whenUnusedExpression.kt");
        }

        @Test
        @TestMetadata(value="whenWithSubjectVariable.kt")
        public void testWhenWithSubjectVariable() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whenWithSubjectVariable.kt");
        }

        @Test
        @TestMetadata(value="whileDoWhile.kt")
        public void testWhileDoWhile() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/whileDoWhile.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/expressions/sam")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Sam {
            @Test
            public void testAllFilesPresentInSam() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayAsVarargAfterSamArgument.kt")
            public void testArrayAsVarargAfterSamArgument() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/arrayAsVarargAfterSamArgument.kt");
            }

            @Test
            @TestMetadata(value="genericSamProjectedOut.kt")
            public void testGenericSamProjectedOut() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/genericSamProjectedOut.kt");
            }

            @Test
            @TestMetadata(value="genericSamSmartcast.kt")
            public void testGenericSamSmartcast() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/genericSamSmartcast.kt");
            }

            @Test
            @TestMetadata(value="samByProjectedType.kt")
            public void testSamByProjectedType() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/samByProjectedType.kt");
            }

            @Test
            @TestMetadata(value="samConstructors.kt")
            public void testSamConstructors() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/samConstructors.kt");
            }

            @Test
            @TestMetadata(value="samConversionInGenericConstructorCall.kt")
            public void testSamConversionInGenericConstructorCall() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/samConversionInGenericConstructorCall.kt");
            }

            @Test
            @TestMetadata(value="samConversionToGeneric.kt")
            public void testSamConversionToGeneric() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/samConversionToGeneric.kt");
            }

            @Test
            @TestMetadata(value="samConversions.kt")
            public void testSamConversions() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/samConversions.kt");
            }

            @Test
            @TestMetadata(value="samConversionsWithSmartCasts.kt")
            public void testSamConversionsWithSmartCasts() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/samConversionsWithSmartCasts.kt");
            }

            @Test
            @TestMetadata(value="samOperators.kt")
            public void testSamOperators() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/sam/samOperators.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/expressions/funInterface")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FunInterface {
            @Test
            public void testAllFilesPresentInFunInterface() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayAsVarargAfterSamArgument_fi.kt")
            public void testArrayAsVarargAfterSamArgument_fi() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/arrayAsVarargAfterSamArgument_fi.kt");
            }

            @Test
            @TestMetadata(value="basicFunInterfaceConversion.kt")
            public void testBasicFunInterfaceConversion() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/basicFunInterfaceConversion.kt");
            }

            @Test
            @TestMetadata(value="castFromAny.kt")
            public void testCastFromAny() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/castFromAny.kt");
            }

            @Test
            @TestMetadata(value="functionSupertype.kt")
            public void testFunctionSupertype() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/functionSupertype.kt");
            }

            @Test
            @TestMetadata(value="partialSam.kt")
            public void testPartialSam() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/partialSam.kt");
            }

            @Test
            @TestMetadata(value="samConversionInVarargs.kt")
            public void testSamConversionInVarargs() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionInVarargs.kt");
            }

            @Test
            @TestMetadata(value="samConversionInVarargsMixed.kt")
            public void testSamConversionInVarargsMixed() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionInVarargsMixed.kt");
            }

            @Test
            @TestMetadata(value="samConversionOnCallableReference.kt")
            public void testSamConversionOnCallableReference() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionOnCallableReference.kt");
            }

            @Test
            @TestMetadata(value="samConversionsWithSmartCasts.kt")
            public void testSamConversionsWithSmartCasts() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionsWithSmartCasts.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/expressions/floatingPointComparisons")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FloatingPointComparisons {
            @Test
            public void testAllFilesPresentInFloatingPointComparisons() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/floatingPointComparisons"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="comparableWithDoubleOrFloat.kt")
            public void testComparableWithDoubleOrFloat() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/comparableWithDoubleOrFloat.kt");
            }

            @Test
            @TestMetadata(value="eqeqRhsConditionPossiblyAffectingLhs.kt")
            public void testEqeqRhsConditionPossiblyAffectingLhs() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/eqeqRhsConditionPossiblyAffectingLhs.kt");
            }

            @Test
            @TestMetadata(value="floatingPointCompareTo.kt")
            public void testFloatingPointCompareTo() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointCompareTo.kt");
            }

            @Test
            @TestMetadata(value="floatingPointEqeq.kt")
            public void testFloatingPointEqeq() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointEqeq.kt");
            }

            @Test
            @TestMetadata(value="floatingPointEquals.kt")
            public void testFloatingPointEquals() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointEquals.kt");
            }

            @Test
            @TestMetadata(value="floatingPointExcleq.kt")
            public void testFloatingPointExcleq() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointExcleq.kt");
            }

            @Test
            @TestMetadata(value="floatingPointLess.kt")
            public void testFloatingPointLess() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointLess.kt");
            }

            @Test
            @TestMetadata(value="nullableAnyAsIntToDouble.kt")
            public void testNullableAnyAsIntToDouble() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/nullableAnyAsIntToDouble.kt");
            }

            @Test
            @TestMetadata(value="nullableFloatingPointEqeq.kt")
            public void testNullableFloatingPointEqeq() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/nullableFloatingPointEqeq.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithPrimitiveNumericSupertype.kt")
            public void testTypeParameterWithPrimitiveNumericSupertype() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/typeParameterWithPrimitiveNumericSupertype.kt");
            }

            @Test
            @TestMetadata(value="whenByFloatingPoint.kt")
            public void testWhenByFloatingPoint() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/whenByFloatingPoint.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/expressions/callableReferences")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CallableReferences {
            @Test
            @TestMetadata(value="adaptedExtensionFunctions.kt")
            public void testAdaptedExtensionFunctions() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/adaptedExtensionFunctions.kt");
            }

            @Test
            @TestMetadata(value="adaptedWithCoercionToUnit.kt")
            public void testAdaptedWithCoercionToUnit() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/adaptedWithCoercionToUnit.kt");
            }

            @Test
            public void testAllFilesPresentInCallableReferences() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/callableReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="boundInlineAdaptedReference.kt")
            public void testBoundInlineAdaptedReference() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/boundInlineAdaptedReference.kt");
            }

            @Test
            @TestMetadata(value="boundInnerGenericConstructor.kt")
            public void testBoundInnerGenericConstructor() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/boundInnerGenericConstructor.kt");
            }

            @Test
            @TestMetadata(value="caoWithAdaptationForSam.kt")
            public void testCaoWithAdaptationForSam() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/caoWithAdaptationForSam.kt");
            }

            @Test
            @TestMetadata(value="constructorWithAdaptedArguments.kt")
            public void testConstructorWithAdaptedArguments() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/constructorWithAdaptedArguments.kt");
            }

            @Test
            @TestMetadata(value="funWithDefaultParametersAsKCallableStar.kt")
            public void testFunWithDefaultParametersAsKCallableStar() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/funWithDefaultParametersAsKCallableStar.kt");
            }

            @Test
            @TestMetadata(value="genericLocalClassConstructorReference.kt")
            public void testGenericLocalClassConstructorReference() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/genericLocalClassConstructorReference.kt");
            }

            @Test
            @TestMetadata(value="genericMember.kt")
            public void testGenericMember() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/genericMember.kt");
            }

            @Test
            @TestMetadata(value="importedFromObject.kt")
            public void testImportedFromObject() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/importedFromObject.kt");
            }

            @Test
            @TestMetadata(value="kt37131.kt")
            public void testKt37131() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/kt37131.kt");
            }

            @Test
            @TestMetadata(value="kt46069.kt")
            public void testKt46069() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/kt46069.kt");
            }

            @Test
            @TestMetadata(value="suspendConversion.kt")
            public void testSuspendConversion() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/suspendConversion.kt");
            }

            @Test
            @TestMetadata(value="typeArguments.kt")
            public void testTypeArguments() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/typeArguments.kt");
            }

            @Test
            @TestMetadata(value="unboundMemberReferenceWithAdaptedArguments.kt")
            public void testUnboundMemberReferenceWithAdaptedArguments() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/unboundMemberReferenceWithAdaptedArguments.kt");
            }

            @Test
            @TestMetadata(value="varargFunImportedFromObject.kt")
            public void testVarargFunImportedFromObject() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/varargFunImportedFromObject.kt");
            }

            @Test
            @TestMetadata(value="withAdaptationForSam.kt")
            public void testWithAdaptationForSam() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/withAdaptationForSam.kt");
            }

            @Test
            @TestMetadata(value="withAdaptedArguments.kt")
            public void testWithAdaptedArguments() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/withAdaptedArguments.kt");
            }

            @Test
            @TestMetadata(value="withArgumentAdaptationAndReceiver.kt")
            public void testWithArgumentAdaptationAndReceiver() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/withArgumentAdaptationAndReceiver.kt");
            }

            @Test
            @TestMetadata(value="withVarargViewedAsArray.kt")
            public void testWithVarargViewedAsArray() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/expressions/callableReferences/withVarargViewedAsArray.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/errors")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Errors {
        @Test
        public void testAllFilesPresentInErrors() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/errors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="suppressedNonPublicCall.kt")
        public void testSuppressedNonPublicCall() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/errors/suppressedNonPublicCall.kt");
        }

        @Test
        @TestMetadata(value="unresolvedReference.kt")
        public void testUnresolvedReference() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/errors/unresolvedReference.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/declarations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Declarations {
        @Test
        public void testAllFilesPresentInDeclarations() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, "multiplatform/k2");
        }

        @Test
        @TestMetadata(value="catchParameterInTopLevelProperty.kt")
        public void testCatchParameterInTopLevelProperty() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/catchParameterInTopLevelProperty.kt");
        }

        @Test
        @TestMetadata(value="classLevelProperties.kt")
        public void testClassLevelProperties() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/classLevelProperties.kt");
        }

        @Test
        @TestMetadata(value="constValInitializers.kt")
        public void testConstValInitializers() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/constValInitializers.kt");
        }

        @Test
        @TestMetadata(value="defaultArguments.kt")
        public void testDefaultArguments() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/defaultArguments.kt");
        }

        @Test
        @TestMetadata(value="delegatedProperties.kt")
        public void testDelegatedProperties() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/delegatedProperties.kt");
        }

        @Test
        @TestMetadata(value="deprecatedProperty.kt")
        public void testDeprecatedProperty() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/deprecatedProperty.kt");
        }

        @Test
        @TestMetadata(value="extensionProperties.kt")
        public void testExtensionProperties() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/extensionProperties.kt");
        }

        @Test
        @TestMetadata(value="fakeOverrideModality.kt")
        public void testFakeOverrideModality() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/fakeOverrideModality.kt");
        }

        @Test
        @TestMetadata(value="fakeOverrides.kt")
        public void testFakeOverrides() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/fakeOverrides.kt");
        }

        @Test
        @TestMetadata(value="fileWithAnnotations.kt")
        public void testFileWithAnnotations() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/fileWithAnnotations.kt");
        }

        @Test
        @TestMetadata(value="fileWithTypeAliasesOnly.kt")
        public void testFileWithTypeAliasesOnly() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/fileWithTypeAliasesOnly.kt");
        }

        @Test
        @TestMetadata(value="genericDelegatedProperty.kt")
        public void testGenericDelegatedProperty() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/genericDelegatedProperty.kt");
        }

        @Test
        @TestMetadata(value="inlineCollectionOfInlineClass.kt")
        public void testInlineCollectionOfInlineClass() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/inlineCollectionOfInlineClass.kt");
        }

        @Test
        @TestMetadata(value="interfaceProperties.kt")
        public void testInterfaceProperties() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/interfaceProperties.kt");
        }

        @Test
        @TestMetadata(value="internalStdlibOverride.kt")
        public void testInternalStdlibOverride() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/internalStdlibOverride.kt");
        }

        @Test
        @TestMetadata(value="kt27005.kt")
        public void testKt27005() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/kt27005.kt");
        }

        @Test
        @TestMetadata(value="kt29833.kt")
        public void testKt29833() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/kt29833.kt");
        }

        @Test
        @TestMetadata(value="kt35550.kt")
        public void testKt35550() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/kt35550.kt");
        }

        @Test
        @TestMetadata(value="kt47527.kt")
        public void testKt47527() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/kt47527.kt");
        }

        @Test
        @TestMetadata(value="kt52677.kt")
        public void testKt52677() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/kt52677.kt");
        }

        @Test
        @TestMetadata(value="kt65236.kt")
        public void testKt65236() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/kt65236.kt");
        }

        @Test
        @TestMetadata(value="kt65273.kt")
        public void testKt65273() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/kt65273.kt");
        }

        @Test
        @TestMetadata(value="kt65432.kt")
        public void testKt65432() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/kt65432.kt");
        }

        @Test
        @TestMetadata(value="localClassWithOverrides.kt")
        public void testLocalClassWithOverrides() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/localClassWithOverrides.kt");
        }

        @Test
        @TestMetadata(value="localDelegatedProperties.kt")
        public void testLocalDelegatedProperties() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/localDelegatedProperties.kt");
        }

        @Test
        @TestMetadata(value="localVarInDoWhile.kt")
        public void testLocalVarInDoWhile() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/localVarInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="mainFunctionMangling.kt")
        public void testMainFunctionMangling() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/mainFunctionMangling.kt");
        }

        @Test
        @TestMetadata(value="mainFunctionManglingInJvm.kt")
        public void testMainFunctionManglingInJvm() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/mainFunctionManglingInJvm.kt");
        }

        @Test
        @TestMetadata(value="packageLevelProperties.kt")
        public void testPackageLevelProperties() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/packageLevelProperties.kt");
        }

        @Test
        @TestMetadata(value="primaryCtorDefaultArguments.kt")
        public void testPrimaryCtorDefaultArguments() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/primaryCtorDefaultArguments.kt");
        }

        @Test
        @TestMetadata(value="primaryCtorProperties.kt")
        public void testPrimaryCtorProperties() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/primaryCtorProperties.kt");
        }

        @Test
        @TestMetadata(value="typeAlias.kt")
        public void testTypeAlias() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/typeAlias.kt");
        }

        @Test
        @TestMetadata(value="typeAliasOfPrimitiveTypeInVarargArgument.kt")
        public void testTypeAliasOfPrimitiveTypeInVarargArgument() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/typeAliasOfPrimitiveTypeInVarargArgument.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/declarations/provideDelegate")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ProvideDelegate {
            @Test
            public void testAllFilesPresentInProvideDelegate() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/provideDelegate"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="differentReceivers.kt")
            public void testDifferentReceivers() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/provideDelegate/differentReceivers.kt");
            }

            @Test
            @TestMetadata(value="javaDelegate.kt")
            public void testJavaDelegate() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/provideDelegate/javaDelegate.kt");
            }

            @Test
            @TestMetadata(value="local.kt")
            public void testLocal() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/provideDelegate/local.kt");
            }

            @Test
            @TestMetadata(value="localDifferentReceivers.kt")
            public void testLocalDifferentReceivers() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/provideDelegate/localDifferentReceivers.kt");
            }

            @Test
            @TestMetadata(value="member.kt")
            public void testMember() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/provideDelegate/member.kt");
            }

            @Test
            @TestMetadata(value="memberExtension.kt")
            public void testMemberExtension() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/provideDelegate/memberExtension.kt");
            }

            @Test
            @TestMetadata(value="topLevel.kt")
            public void testTopLevel() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/provideDelegate/topLevel.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/declarations/parameters")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Parameters {
            @Test
            public void testAllFilesPresentInParameters() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/parameters"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="class.kt")
            public void testClass() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/class.kt");
            }

            @Test
            @TestMetadata(value="constructor.kt")
            public void testConstructor() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/constructor.kt");
            }

            @Test
            @TestMetadata(value="dataClassMembers.kt")
            public void testDataClassMembers() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/dataClassMembers.kt");
            }

            @Test
            @TestMetadata(value="defaultPropertyAccessors.kt")
            public void testDefaultPropertyAccessors() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/defaultPropertyAccessors.kt");
            }

            @Test
            @TestMetadata(value="delegatedMembers.kt")
            public void testDelegatedMembers() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/delegatedMembers.kt");
            }

            @Test
            @TestMetadata(value="fun.kt")
            public void testFun() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/fun.kt");
            }

            @Test
            @TestMetadata(value="genericInnerClass.kt")
            public void testGenericInnerClass() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/genericInnerClass.kt");
            }

            @Test
            @TestMetadata(value="lambdas.kt")
            public void testLambdas() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/lambdas.kt");
            }

            @Test
            @TestMetadata(value="localFun.kt")
            public void testLocalFun() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/localFun.kt");
            }

            @Test
            @TestMetadata(value="propertyAccessors.kt")
            public void testPropertyAccessors() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/propertyAccessors.kt");
            }

            @Test
            @TestMetadata(value="typeParameterBeforeBound.kt")
            public void testTypeParameterBeforeBound() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/typeParameterBeforeBound.kt");
            }

            @Test
            @TestMetadata(value="typeParameterBoundedBySubclass.kt")
            public void testTypeParameterBoundedBySubclass() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/typeParameterBoundedBySubclass.kt");
            }

            @Test
            @TestMetadata(value="useNextParamInLambda.kt")
            public void testUseNextParamInLambda() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/parameters/useNextParamInLambda.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/declarations/multiplatform")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Multiplatform {
            @Test
            public void testAllFilesPresentInMultiplatform() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, "k2");
            }

            @Nested
            @TestMetadata(value="compiler/testData/ir/irText/declarations/multiplatform/k1")
            @TestDataPath(value="$PROJECT_ROOT")
            public class K1 {
                @Test
                public void testAllFilesPresentInK1() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/multiplatform/k1"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="expectClassInherited.kt")
                public void testExpectClassInherited() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/multiplatform/k1/expectClassInherited.kt");
                }

                @Test
                @TestMetadata(value="expectIntersectionOverride.kt")
                public void testExpectIntersectionOverride() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/multiplatform/k1/expectIntersectionOverride.kt");
                }

                @Test
                @TestMetadata(value="expectMemberInNotExpectClass.kt")
                public void testExpectMemberInNotExpectClass() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/multiplatform/k1/expectMemberInNotExpectClass.kt");
                }

                @Test
                @TestMetadata(value="expectedEnumClass.kt")
                public void testExpectedEnumClass() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/multiplatform/k1/expectedEnumClass.kt");
                }

                @Test
                @TestMetadata(value="expectedSealedClass.kt")
                public void testExpectedSealedClass() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/multiplatform/k1/expectedSealedClass.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/declarations/jvmRecord")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JvmRecord {
            @Test
            public void testAllFilesPresentInJvmRecord() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/jvmRecord"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="dataClassWithJvmRecord.kt")
            public void testDataClassWithJvmRecord() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/jvmRecord/dataClassWithJvmRecord.kt");
            }

            @Test
            @TestMetadata(value="javaRecordComponentAccess.kt")
            public void testJavaRecordComponentAccess() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/jvmRecord/javaRecordComponentAccess.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/declarations/delegate")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Delegate {
            @Test
            public void testAllFilesPresentInDelegate() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/delegate"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="delegationEvaluationOrder1.kt")
            public void testDelegationEvaluationOrder1() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/delegate/delegationEvaluationOrder1.kt");
            }

            @Test
            @TestMetadata(value="delegationEvaluationOrder2.kt")
            public void testDelegationEvaluationOrder2() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/delegate/delegationEvaluationOrder2.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/declarations/contextReceivers")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ContextReceivers {
            @Test
            public void testAllFilesPresentInContextReceivers() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/contextReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayAccessCompositeOperators.kt")
            public void testArrayAccessCompositeOperators() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/arrayAccessCompositeOperators.kt");
            }

            @Test
            @TestMetadata(value="arrayAccessOperators.kt")
            public void testArrayAccessOperators() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/arrayAccessOperators.kt");
            }

            @Test
            @TestMetadata(value="class.kt")
            public void testClass() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/class.kt");
            }

            @Test
            @TestMetadata(value="compoundAssignmentOperators.kt")
            public void testCompoundAssignmentOperators() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/compoundAssignmentOperators.kt");
            }

            @Test
            @TestMetadata(value="contextReceiverMethod.kt")
            public void testContextReceiverMethod() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/contextReceiverMethod.kt");
            }

            @Test
            @TestMetadata(value="contextualFunctionConversion.kt")
            public void testContextualFunctionConversion() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/contextualFunctionConversion.kt");
            }

            @Test
            @TestMetadata(value="contextualInlineCall.kt")
            public void testContextualInlineCall() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/contextualInlineCall.kt");
            }

            @Test
            @TestMetadata(value="contextualPrimaryConstructorWithParams.kt")
            public void testContextualPrimaryConstructorWithParams() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/contextualPrimaryConstructorWithParams.kt");
            }

            @Test
            @TestMetadata(value="delegatedPropertiesOperators.kt")
            public void testDelegatedPropertiesOperators() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/delegatedPropertiesOperators.kt");
            }

            @Test
            @TestMetadata(value="function.kt")
            public void testFunction() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/function.kt");
            }

            @Test
            @TestMetadata(value="functionalType.kt")
            public void testFunctionalType() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/functionalType.kt");
            }

            @Test
            @TestMetadata(value="genericOuterClass.kt")
            public void testGenericOuterClass() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/genericOuterClass.kt");
            }

            @Test
            @TestMetadata(value="iteratorOperator.kt")
            public void testIteratorOperator() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/iteratorOperator.kt");
            }

            @Test
            @TestMetadata(value="kt52791.kt")
            public void testKt52791() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/kt52791.kt");
            }

            @Test
            @TestMetadata(value="lazy.kt")
            public void testLazy() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/lazy.kt");
            }

            @Test
            @TestMetadata(value="overloadPriority.kt")
            public void testOverloadPriority() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/overloadPriority.kt");
            }

            @Test
            @TestMetadata(value="overloading.kt")
            public void testOverloading() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/overloading.kt");
            }

            @Test
            @TestMetadata(value="passingLambdaToContextualParam.kt")
            public void testPassingLambdaToContextualParam() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/passingLambdaToContextualParam.kt");
            }

            @Test
            @TestMetadata(value="plusMatrix.kt")
            public void testPlusMatrix() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/plusMatrix.kt");
            }

            @Test
            @TestMetadata(value="property.kt")
            public void testProperty() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/property.kt");
            }

            @Test
            @TestMetadata(value="thisWithCustomLabel.kt")
            public void testThisWithCustomLabel() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/thisWithCustomLabel.kt");
            }

            @Test
            @TestMetadata(value="typeParameterAsContextReceiver.kt")
            public void testTypeParameterAsContextReceiver() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/typeParameterAsContextReceiver.kt");
            }

            @Test
            @TestMetadata(value="unaryOperators.kt")
            public void testUnaryOperators() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/unaryOperators.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP")
            @TestDataPath(value="$PROJECT_ROOT")
            public class FromKEEP {
                @Test
                public void testAllFilesPresentInFromKEEP() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="canvas.kt")
                public void testCanvas() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/canvas.kt");
                }

                @Test
                @TestMetadata(value="compareTo.kt")
                public void testCompareTo() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/compareTo.kt");
                }

                @Test
                @TestMetadata(value="dp.kt")
                public void testDp() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/dp.kt");
                }

                @Test
                @TestMetadata(value="functionalType.kt")
                public void testFunctionalType() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/functionalType.kt");
                }

                @Test
                @TestMetadata(value="monoidSum.kt")
                public void testMonoidSum() {
                    ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/monoidSum.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/declarations/annotations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Annotations {
            @Test
            public void testAllFilesPresentInAnnotations() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="annotationOnClassWithInitializer.kt")
            public void testAnnotationOnClassWithInitializer() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/annotationOnClassWithInitializer.kt");
            }

            @Test
            @TestMetadata(value="annotationsInAnnotationArguments.kt")
            public void testAnnotationsInAnnotationArguments() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/annotationsInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata(value="annotationsOnDelegatedMembers.kt")
            public void testAnnotationsOnDelegatedMembers() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/annotationsOnDelegatedMembers.kt");
            }

            @Test
            @TestMetadata(value="annotationsWithDefaultParameterValues.kt")
            public void testAnnotationsWithDefaultParameterValues() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/annotationsWithDefaultParameterValues.kt");
            }

            @Test
            @TestMetadata(value="annotationsWithVarargParameters.kt")
            public void testAnnotationsWithVarargParameters() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/annotationsWithVarargParameters.kt");
            }

            @Test
            @TestMetadata(value="argWithDefaultValueInAnnotationClass.kt")
            public void testArgWithDefaultValueInAnnotationClass() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/argWithDefaultValueInAnnotationClass.kt");
            }

            @Test
            @TestMetadata(value="arrayInAnnotationArguments.kt")
            public void testArrayInAnnotationArguments() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/arrayInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata(value="classLiteralInAnnotation.kt")
            public void testClassLiteralInAnnotation() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/classLiteralInAnnotation.kt");
            }

            @Test
            @TestMetadata(value="classesWithAnnotations.kt")
            public void testClassesWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/classesWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="constExpressionsInAnnotationArguments.kt")
            public void testConstExpressionsInAnnotationArguments() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/constExpressionsInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata(value="constructorsWithAnnotations.kt")
            public void testConstructorsWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/constructorsWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="delegateFieldWithAnnotations.kt")
            public void testDelegateFieldWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/delegateFieldWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="delegatedPropertyAccessorsWithAnnotations.kt")
            public void testDelegatedPropertyAccessorsWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/delegatedPropertyAccessorsWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesWithAnnotations.kt")
            public void testEnumEntriesWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/enumEntriesWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="enumsInAnnotationArguments.kt")
            public void testEnumsInAnnotationArguments() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/enumsInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata(value="fieldsWithAnnotations.kt")
            public void testFieldsWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/fieldsWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="fileAnnotations.kt")
            public void testFileAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/fileAnnotations.kt");
            }

            @Test
            @TestMetadata(value="functionsWithAnnotations.kt")
            public void testFunctionsWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/functionsWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="genericAnnotationClasses.kt")
            public void testGenericAnnotationClasses() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/genericAnnotationClasses.kt");
            }

            @Test
            @TestMetadata(value="inheritingDeprecation.kt")
            public void testInheritingDeprecation() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/inheritingDeprecation.kt");
            }

            @Test
            @TestMetadata(value="javaAnnotation.kt")
            public void testJavaAnnotation() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/javaAnnotation.kt");
            }

            @Test
            @TestMetadata(value="javaAnnotationWithSingleArrayArgument.kt")
            public void testJavaAnnotationWithSingleArrayArgument() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/javaAnnotationWithSingleArrayArgument.kt");
            }

            @Test
            @TestMetadata(value="localDelegatedPropertiesWithAnnotations.kt")
            public void testLocalDelegatedPropertiesWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/localDelegatedPropertiesWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="multipleAnnotationsInSquareBrackets.kt")
            public void testMultipleAnnotationsInSquareBrackets() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/multipleAnnotationsInSquareBrackets.kt");
            }

            @Test
            @TestMetadata(value="primaryConstructorParameterWithAnnotations.kt")
            public void testPrimaryConstructorParameterWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/primaryConstructorParameterWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="propertiesWithAnnotations.kt")
            public void testPropertiesWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/propertiesWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="propertyAccessorsFromClassHeaderWithAnnotations.kt")
            public void testPropertyAccessorsFromClassHeaderWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/propertyAccessorsFromClassHeaderWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="propertyAccessorsWithAnnotations.kt")
            public void testPropertyAccessorsWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/propertyAccessorsWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="propertySetterParameterWithAnnotations.kt")
            public void testPropertySetterParameterWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/propertySetterParameterWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="receiverParameterWithAnnotations.kt")
            public void testReceiverParameterWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/receiverParameterWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="spreadOperatorInAnnotationArguments.kt")
            public void testSpreadOperatorInAnnotationArguments() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/spreadOperatorInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata(value="typeAliasesWithAnnotations.kt")
            public void testTypeAliasesWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/typeAliasesWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="typeParametersWithAnnotations.kt")
            public void testTypeParametersWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/typeParametersWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="valueParametersWithAnnotations.kt")
            public void testValueParametersWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/valueParametersWithAnnotations.kt");
            }

            @Test
            @TestMetadata(value="varargsInAnnotationArguments.kt")
            public void testVarargsInAnnotationArguments() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/varargsInAnnotationArguments.kt");
            }

            @Test
            @TestMetadata(value="variablesWithAnnotations.kt")
            public void testVariablesWithAnnotations() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/declarations/annotations/variablesWithAnnotations.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/ir/irText/classes")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Classes {
        @Test
        @TestMetadata(value="47424.kt")
        public void test47424() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/47424.kt");
        }

        @Test
        @TestMetadata(value="abstractMembers.kt")
        public void testAbstractMembers() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/abstractMembers.kt");
        }

        @Test
        public void testAllFilesPresentInClasses() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/classes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="annotationClasses.kt")
        public void testAnnotationClasses() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/annotationClasses.kt");
        }

        @Test
        @TestMetadata(value="annotationsOnDelegatedMembers.kt")
        public void testAnnotationsOnDelegatedMembers() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/annotationsOnDelegatedMembers.kt");
        }

        @Test
        @TestMetadata(value="argumentReorderingInDelegatingConstructorCall.kt")
        public void testArgumentReorderingInDelegatingConstructorCall() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/argumentReorderingInDelegatingConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="clashingFakeOverrideSignatures.kt")
        public void testClashingFakeOverrideSignatures() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/clashingFakeOverrideSignatures.kt");
        }

        @Test
        @TestMetadata(value="classMembers.kt")
        public void testClassMembers() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/classMembers.kt");
        }

        @Test
        @TestMetadata(value="classes.kt")
        public void testClasses() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/classes.kt");
        }

        @Test
        @TestMetadata(value="cloneable.kt")
        public void testCloneable() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/cloneable.kt");
        }

        @Test
        @TestMetadata(value="companionObject.kt")
        public void testCompanionObject() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/companionObject.kt");
        }

        @Test
        @TestMetadata(value="declarationOrder.kt")
        public void testDeclarationOrder() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/declarationOrder.kt");
        }

        @Test
        @TestMetadata(value="delegatedGenericImplementation.kt")
        public void testDelegatedGenericImplementation() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/delegatedGenericImplementation.kt");
        }

        @Test
        @TestMetadata(value="delegatedImplementation.kt")
        public void testDelegatedImplementation() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/delegatedImplementation.kt");
        }

        @Test
        @TestMetadata(value="delegatedImplementationOfJavaInterface.kt")
        public void testDelegatedImplementationOfJavaInterface() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/delegatedImplementationOfJavaInterface.kt");
        }

        @Test
        @TestMetadata(value="delegatedImplementationWithExplicitOverride.kt")
        public void testDelegatedImplementationWithExplicitOverride() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/delegatedImplementationWithExplicitOverride.kt");
        }

        @Test
        @TestMetadata(value="delegatingConstructorCallToTypeAliasConstructor.kt")
        public void testDelegatingConstructorCallToTypeAliasConstructor() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/delegatingConstructorCallToTypeAliasConstructor.kt");
        }

        @Test
        @TestMetadata(value="delegatingConstructorCallsInSecondaryConstructors.kt")
        public void testDelegatingConstructorCallsInSecondaryConstructors() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/delegatingConstructorCallsInSecondaryConstructors.kt");
        }

        @Test
        @TestMetadata(value="enum.kt")
        public void testEnum() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/enum.kt");
        }

        @Test
        @TestMetadata(value="enumClassModality.kt")
        public void testEnumClassModality() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/enumClassModality.kt");
        }

        @Test
        @TestMetadata(value="enumEntries.kt")
        public void testEnumEntries() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/enumEntries.kt");
        }

        @Test
        @TestMetadata(value="enumWithMultipleCtors.kt")
        public void testEnumWithMultipleCtors() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/enumWithMultipleCtors.kt");
        }

        @Test
        @TestMetadata(value="enumWithSecondaryCtor.kt")
        public void testEnumWithSecondaryCtor() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/enumWithSecondaryCtor.kt");
        }

        @Test
        @TestMetadata(value="fakeOverridesForAnyMembers.kt")
        public void testFakeOverridesForAnyMembers() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/fakeOverridesForAnyMembers.kt");
        }

        @Test
        @TestMetadata(value="fakeOverridesForJavaNonStaticMembers.kt")
        public void testFakeOverridesForJavaNonStaticMembers() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/fakeOverridesForJavaNonStaticMembers.kt");
        }

        @Test
        @TestMetadata(value="fakeOverridesForJavaStaticMembers.kt")
        public void testFakeOverridesForJavaStaticMembers() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/fakeOverridesForJavaStaticMembers.kt");
        }

        @Test
        @TestMetadata(value="implicitNotNullOnDelegatedImplementation.kt")
        public void testImplicitNotNullOnDelegatedImplementation() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/implicitNotNullOnDelegatedImplementation.kt");
        }

        @Test
        @TestMetadata(value="initBlock.kt")
        public void testInitBlock() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/initBlock.kt");
        }

        @Test
        @TestMetadata(value="initVal.kt")
        public void testInitVal() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/initVal.kt");
        }

        @Test
        @TestMetadata(value="initValInLambda.kt")
        public void testInitValInLambda() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/initValInLambda.kt");
        }

        @Test
        @TestMetadata(value="initVar.kt")
        public void testInitVar() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/initVar.kt");
        }

        @Test
        @TestMetadata(value="inlineClass.kt")
        public void testInlineClass() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/inlineClass.kt");
        }

        @Test
        @TestMetadata(value="inlineClassSyntheticMethods.kt")
        public void testInlineClassSyntheticMethods() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/inlineClassSyntheticMethods.kt");
        }

        @Test
        @TestMetadata(value="innerClass.kt")
        public void testInnerClass() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/innerClass.kt");
        }

        @Test
        @TestMetadata(value="innerClassWithDelegatingConstructor.kt")
        public void testInnerClassWithDelegatingConstructor() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/innerClassWithDelegatingConstructor.kt");
        }

        @Test
        @TestMetadata(value="kt19306.kt")
        public void testKt19306() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/kt19306.kt");
        }

        @Test
        @TestMetadata(value="kt43217.kt")
        public void testKt43217() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/kt43217.kt");
        }

        @Test
        @TestMetadata(value="kt45853.kt")
        public void testKt45853() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/kt45853.kt");
        }

        @Test
        @TestMetadata(value="kt45934.kt")
        public void testKt45934() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/kt45934.kt");
        }

        @Test
        @TestMetadata(value="localClasses.kt")
        public void testLocalClasses() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/localClasses.kt");
        }

        @Test
        @TestMetadata(value="objectLiteralExpressions.kt")
        public void testObjectLiteralExpressions() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/objectLiteralExpressions.kt");
        }

        @Test
        @TestMetadata(value="objectWithInitializers.kt")
        public void testObjectWithInitializers() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/objectWithInitializers.kt");
        }

        @Test
        @TestMetadata(value="outerClassAccess.kt")
        public void testOuterClassAccess() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/outerClassAccess.kt");
        }

        @Test
        @TestMetadata(value="overriddenEquals.kt")
        public void testOverriddenEquals() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/overriddenEquals.kt");
        }

        @Test
        @TestMetadata(value="primaryConstructor.kt")
        public void testPrimaryConstructor() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/primaryConstructor.kt");
        }

        @Test
        @TestMetadata(value="primaryConstructorWithSuperConstructorCall.kt")
        public void testPrimaryConstructorWithSuperConstructorCall() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/primaryConstructorWithSuperConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="privateInterface.kt")
        public void testPrivateInterface() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/privateInterface.kt");
        }

        @Test
        @TestMetadata(value="qualifiedSuperCalls.kt")
        public void testQualifiedSuperCalls() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/qualifiedSuperCalls.kt");
        }

        @Test
        @TestMetadata(value="sealedClasses.kt")
        public void testSealedClasses() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/sealedClasses.kt");
        }

        @Test
        @TestMetadata(value="secondaryConstructorWithInitializersFromClassBody.kt")
        public void testSecondaryConstructorWithInitializersFromClassBody() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/secondaryConstructorWithInitializersFromClassBody.kt");
        }

        @Test
        @TestMetadata(value="secondaryConstructors.kt")
        public void testSecondaryConstructors() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/secondaryConstructors.kt");
        }

        @Test
        @TestMetadata(value="smartCastInValInitialization.kt")
        public void testSmartCastInValInitialization() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/smartCastInValInitialization.kt");
        }

        @Test
        @TestMetadata(value="superCalls.kt")
        public void testSuperCalls() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/superCalls.kt");
        }

        @Test
        @TestMetadata(value="superCallsComposed.kt")
        public void testSuperCallsComposed() {
            ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/superCallsComposed.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/ir/irText/classes/dataClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DataClasses {
            @Test
            public void testAllFilesPresentInDataClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/classes/dataClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="dataClassWithArrayMembers.kt")
            public void testDataClassWithArrayMembers() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/dataClassWithArrayMembers.kt");
            }

            @Test
            @TestMetadata(value="dataClasses.kt")
            public void testDataClasses() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/dataClasses.kt");
            }

            @Test
            @TestMetadata(value="dataClassesGeneric.kt")
            public void testDataClassesGeneric() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/dataClassesGeneric.kt");
            }

            @Test
            @TestMetadata(value="dataObject.kt")
            public void testDataObject() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/dataObject.kt");
            }

            @Test
            @TestMetadata(value="delegationInSealed.kt")
            public void testDelegationInSealed() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/delegationInSealed.kt");
            }

            @Test
            @TestMetadata(value="kt31649.kt")
            public void testKt31649() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/kt31649.kt");
            }

            @Test
            @TestMetadata(value="kt49936.kt")
            public void testKt49936() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/kt49936.kt");
            }

            @Test
            @TestMetadata(value="lambdaInDataClassDefaultParameter.kt")
            public void testLambdaInDataClassDefaultParameter() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/lambdaInDataClassDefaultParameter.kt");
            }

            @Test
            @TestMetadata(value="openDataClass.kt")
            public void testOpenDataClass() {
                ClassicJvmIrTextTestGenerated.this.runTest("compiler/testData/ir/irText/classes/dataClasses/openDataClass.kt");
            }
        }
    }
}

