/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic.handlers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.diagnostics.ActualDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.SyntaxErrorDiagnostic;
import org.jetbrains.kotlin.checkers.utils.CheckerTestUtil;
import org.jetbrains.kotlin.checkers.utils.DiagnosticsRenderingConfiguration;
import org.jetbrains.kotlin.cli.jvm.compiler.DuplicateJvmSignatureUtilKt;
import org.jetbrains.kotlin.codeMetaInfo.model.ParsedCodeMetaInfo;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactoryImpl;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.test.directives.AdditionalFilesDirectives;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontendOutputArtifact;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicDiagnosticReporter;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicDiagnosticReporterKt;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicDiagnosticsHandler;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicFrontendAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DiagnosticsService;
import org.jetbrains.kotlin.test.services.DiagnosticsServiceKt;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J8\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020)H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicDiagnosticsHandler;", "Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicFrontendAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "additionalServices", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "globalMetadataInfoHandler", "Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "getGlobalMetadataInfoHandler", "()Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "diagnosticsService", "Lorg/jetbrains/kotlin/test/services/DiagnosticsService;", "getDiagnosticsService", "()Lorg/jetbrains/kotlin/test/services/DiagnosticsService;", "reporter", "Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicDiagnosticReporter;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/classic/ClassicFrontendOutputArtifact;", "computeJvmSignatureDiagnostics", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "processDebugInfoDiagnostics", "configuration", "Lorg/jetbrains/kotlin/checkers/utils/DiagnosticsRenderingConfiguration;", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "withNewInferenceModeEnabled", "", "processAfterAllModules", "someAssertionWasFailed", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nClassicDiagnosticsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicDiagnosticsHandler.kt\norg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicDiagnosticsHandler\n+ 2 TestServices.kt\norg/jetbrains/kotlin/test/services/TestServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,132:1\n25#2:133\n774#3:134\n865#3,2:135\n774#3:137\n865#3,2:138\n1485#3:140\n1510#3,3:141\n1513#3,3:151\n1755#3,3:154\n1498#3:157\n1528#3,3:158\n1531#3,3:168\n1246#3,4:173\n1755#3,3:177\n381#4,7:144\n381#4,7:161\n462#4:171\n412#4:172\n*S KotlinDebug\n*F\n+ 1 ClassicDiagnosticsHandler.kt\norg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicDiagnosticsHandler\n*L\n37#1:133\n51#1:134\n51#1:135,2\n54#1:137\n54#1:138,2\n57#1:140\n57#1:141,3\n57#1:151,3\n76#1:154,3\n104#1:157\n104#1:158,3\n104#1:168,3\n108#1:173,4\n123#1:177,3\n57#1:144,7\n104#1:161,7\n108#1:171\n108#1:172\n*E\n"})
public final class ClassicDiagnosticsHandler
extends ClassicFrontendAnalysisHandler {
    @NotNull
    private final List<DirectivesContainer> directiveContainers;
    @NotNull
    private final List<ServiceRegistrationData> additionalServices;
    @NotNull
    private final ClassicDiagnosticReporter reporter;

    public ClassicDiagnosticsHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, false, 6, null);
        this.directiveContainers = CollectionsKt.listOf((Object)DiagnosticsDirectives.INSTANCE);
        Function1 serviceConstructor$iv = additionalServices.1.INSTANCE;
        boolean $i$f$service = false;
        this.additionalServices = CollectionsKt.listOf((Object)new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(DiagnosticsService.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv));
        this.reporter = new ClassicDiagnosticReporter(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return this.directiveContainers;
    }

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        return this.additionalServices;
    }

    private final GlobalMetadataInfoHandler getGlobalMetadataInfoHandler() {
        return GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler(this.getTestServices());
    }

    private final DiagnosticsService getDiagnosticsService() {
        return DiagnosticsServiceKt.getDiagnosticsService(this.getTestServices());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processModule(@NotNull TestModule module, @NotNull ClassicFrontendOutputArtifact info) {
        void $this$groupByTo$iv$iv;
        Diagnostic it;
        Iterable $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Iterable destination$iv$iv;
        boolean $i$f$filter;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Diagnostics diagnostics = info.getAnalysisResult().getBindingContext().getDiagnostics();
        Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"getDiagnostics(...)");
        List allDiagnostics = CollectionsKt.plus((Iterable)((Iterable)diagnostics), (Iterable)this.computeJvmSignatureDiagnostics(info));
        if (module.getDirectives().contains(AdditionalFilesDirectives.INSTANCE.getCHECK_TYPE())) {
            $this$filter$iv = allDiagnostics;
            $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Diagnostic)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getFactory().getName(), (Object)Errors.UNDERSCORE_USAGE_WITHOUT_BACKTICKS.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            allDiagnostics = (List)destination$iv$iv;
        }
        if (module.getDirectives().contains(LanguageSettingsDirectives.INSTANCE.getAPI_VERSION())) {
            $this$filter$iv = allDiagnostics;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Diagnostic)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getFactory().getName(), (Object)Errors.NEWER_VERSION_IN_SINCE_KOTLIN.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            allDiagnostics = (List)destination$iv$iv;
        }
        Iterable $this$groupBy$iv = allDiagnostics;
        boolean $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Diagnostic it2 = (Diagnostic)element$iv$iv;
            boolean bl = false;
            PsiFile key$iv$iv = it2.getPsiFile();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map diagnosticsPerFile = destination$iv$iv2;
        boolean withNewInferenceModeEnabled = ClassicDiagnosticReporterKt.withNewInferenceModeEnabled(this.getTestServices());
        DiagnosticsRenderingConfiguration configuration2 = this.reporter.createConfiguration(module);
        for (Map.Entry<TestFile, KtFile> entry : info.getKtFiles().entrySet()) {
            TestFile file = entry.getKey();
            KtFile ktFile = entry.getValue();
            List list = (List)diagnosticsPerFile.get(ktFile);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List diagnostics2 = list;
            for (Diagnostic diagnostic : diagnostics2) {
                if (!diagnostic.isValid() || !this.getDiagnosticsService().shouldRenderDiagnostic(module, diagnostic.getFactory().getName(), diagnostic.getSeverity())) continue;
                this.reporter.reportDiagnostic(diagnostic, module, file, configuration2, withNewInferenceModeEnabled);
            }
            for (PsiErrorElement errorElement : AnalyzingUtils.getSyntaxErrorRanges((PsiElement)((PsiElement)ktFile))) {
                this.reporter.reportDiagnostic((Diagnostic)new SyntaxErrorDiagnostic(errorElement), module, file, configuration2, withNewInferenceModeEnabled);
            }
            this.processDebugInfoDiagnostics(configuration2, module, file, ktFile, info, withNewInferenceModeEnabled);
        }
    }

    private final Set<Diagnostic> computeJvmSignatureDiagnostics(ClassicFrontendOutputArtifact info) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TestModule it = (TestModule)element$iv;
                    boolean bl2 = false;
                    if (!(!JvmPlatformKt.isJvm((TargetPlatform)it.getTargetPlatform()))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return SetsKt.emptySet();
        }
        if (!TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(DiagnosticsDirectives.INSTANCE.getREPORT_JVM_DIAGNOSTICS_ON_FRONTEND())) {
            return SetsKt.emptySet();
        }
        BindingContext bindingContext = info.getAnalysisResult().getBindingContext();
        HashSet jvmSignatureDiagnostics = new HashSet();
        for (KtFile ktFile : info.getKtFiles().values()) {
            Collection declarations;
            Intrinsics.checkNotNullExpressionValue((Object)PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)ktFile), KtDeclaration.class), (String)"findChildrenOfType(...)");
            for (KtDeclaration declaration : declarations) {
                Diagnostics diagnostics;
                Intrinsics.checkNotNull((Object)declaration);
                PsiElement psiElement = (PsiElement)declaration;
                Diagnostics diagnostics2 = bindingContext.getDiagnostics();
                Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"getDiagnostics(...)");
                if (DuplicateJvmSignatureUtilKt.getJvmSignatureDiagnostics((PsiElement)psiElement, (Diagnostics)diagnostics2) == null) continue;
                jvmSignatureDiagnostics.addAll(diagnostics.forElement((PsiElement)declaration));
            }
        }
        return jvmSignatureDiagnostics;
    }

    /*
     * WARNING - void declaration
     */
    private final void processDebugInfoDiagnostics(DiagnosticsRenderingConfiguration configuration2, TestModule module, TestFile file, KtFile ktFile, ClassicFrontendOutputArtifact info, boolean withNewInferenceModeEnabled) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        Map $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Iterable iterable = this.getGlobalMetadataInfoHandler().getExistingMetaInfosForFile(file);
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object2;
            ParsedCodeMetaInfo it2 = (ParsedCodeMetaInfo)element$iv$iv;
            boolean $i$a$-groupBy-ClassicDiagnosticsHandler$processDebugInfoDiagnostics$diagnosedRanges$32 = false;
            key$iv$iv = new IntRange(it2.getStart(), it2.getEnd());
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            ParsedCodeMetaInfo $i$a$-groupBy-ClassicDiagnosticsHandler$processDebugInfoDiagnostics$diagnosedRanges$32 = (ParsedCodeMetaInfo)element$iv$iv;
            object = list$iv$iv;
            boolean bl = false;
            object.add(it.getTag());
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = $this$getOrPut$iv$iv$iv;
            boolean bl2 = false;
            List it = (List)entry.getValue();
            Set set = CollectionsKt.toMutableSet((Iterable)it);
            object.put(k, set);
        }
        Map diagnosedRanges = destination$iv$iv;
        PsiElement psiElement = (PsiElement)ktFile;
        BindingContext bindingContext = info.getAnalysisResult().getBindingContext();
        boolean bl = module.getDirectives().contains(DiagnosticsDirectives.INSTANCE.getMARK_DYNAMIC_CALLS());
        List list = new ArrayList();
        DataFlowValueFactory dataFlowValueFactory = (DataFlowValueFactory)new DataFlowValueFactoryImpl(info.getLanguageVersionSettings());
        ModuleDescriptor moduleDescriptor = info.getAnalysisResult().getModuleDescriptor();
        Intrinsics.checkNotNull((Object)moduleDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl");
        List debugAnnotations = CheckerTestUtil.INSTANCE.getDebugInfoDiagnostics(psiElement, bindingContext, bl, list, configuration2, dataFlowValueFactory, (ModuleDescriptorImpl)moduleDescriptor, diagnosedRanges);
        boolean onlyExplicitlyDefined = module.getDirectives().contains(DiagnosticsDirectives.INSTANCE.getREPORT_ONLY_EXPLICITLY_DEFINED_DEBUG_INFO());
        for (ActualDiagnostic debugAnnotation : debugAnnotations) {
            DiagnosticFactory factory = debugAnnotation.getDiagnostic().getFactory();
            if (!this.getDiagnosticsService().shouldRenderDiagnostic(module, factory.getName(), factory.getSeverity())) continue;
            if (onlyExplicitlyDefined) {
                boolean bl3;
                block9: {
                    Iterable $this$any$iv = debugAnnotation.getDiagnostic().getTextRanges();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            TextRange it = (TextRange)element$iv;
                            boolean bl4 = false;
                            if (!diagnosedRanges.containsKey(new IntRange(it.getStartOffset(), it.getEndOffset()))) continue;
                            bl3 = true;
                            break block9;
                        }
                        bl3 = false;
                    }
                }
                if (!bl3) continue;
            }
            this.reporter.reportDiagnostic(debugAnnotation.getDiagnostic(), module, file, configuration2, withNewInferenceModeEnabled);
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }
}

