/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.directives.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;
import org.jetbrains.kotlin.test.util.StringUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\u0018\u00002\u00020\u0001BM\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0006\u0012\u001c\u0010\t\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\u0010\u001a\u00020\u0007H\u0096\u0002J'\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0003\"\b\b\u0000\u0010\u0013*\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00130\nH\u0096\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0096\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectivesImpl;", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "simpleDirectives", "", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "stringDirectives", "", "Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "", "valueDirectives", "Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", "", "<init>", "(Ljava/util/List;Ljava/util/Map;Ljava/util/Map;)V", "contains", "", "directive", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "get", "T", "isEmpty", "toString", "iterator", "", "test-infrastructure_test"})
@SourceDebugExtension(value={"SMAP\nDirective.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Directive.kt\norg/jetbrains/kotlin/test/directives/model/RegisteredDirectivesImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,177:1\n1863#2,2:178\n216#3,2:180\n216#3,2:182\n*S KotlinDebug\n*F\n+ 1 Directive.kt\norg/jetbrains/kotlin/test/directives/model/RegisteredDirectivesImpl\n*L\n91#1:178,2\n92#1:180,2\n93#1:182,2\n*E\n"})
public final class RegisteredDirectivesImpl
extends RegisteredDirectives {
    @NotNull
    private final List<SimpleDirective> simpleDirectives;
    @NotNull
    private final Map<StringDirective, List<String>> stringDirectives;
    @NotNull
    private final Map<ValueDirective<?>, List<Object>> valueDirectives;

    public RegisteredDirectivesImpl(@NotNull List<SimpleDirective> simpleDirectives, @NotNull Map<StringDirective, ? extends List<String>> stringDirectives, @NotNull Map<ValueDirective<?>, ? extends List<? extends Object>> valueDirectives) {
        Intrinsics.checkNotNullParameter(simpleDirectives, (String)"simpleDirectives");
        Intrinsics.checkNotNullParameter(stringDirectives, (String)"stringDirectives");
        Intrinsics.checkNotNullParameter(valueDirectives, (String)"valueDirectives");
        this.simpleDirectives = simpleDirectives;
        this.stringDirectives = stringDirectives;
        this.valueDirectives = valueDirectives;
    }

    @Override
    public boolean contains(@NotNull Directive directive) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        Directive directive2 = directive;
        if (directive2 instanceof SimpleDirective) {
            bl = this.simpleDirectives.contains(directive);
        } else if (directive2 instanceof StringDirective) {
            bl = this.stringDirectives.containsKey(directive);
        } else if (directive2 instanceof ValueDirective) {
            bl = this.valueDirectives.containsKey(directive);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    @NotNull
    public List<String> get(@NotNull StringDirective directive) {
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        List list = this.stringDirectives.get(directive);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public <T> List<T> get(@NotNull ValueDirective<T> directive) {
        Intrinsics.checkNotNullParameter(directive, (String)"directive");
        List list = this.valueDirectives.get(directive);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public boolean isEmpty() {
        return this.simpleDirectives.isEmpty() && this.stringDirectives.isEmpty() && this.valueDirectives.isEmpty();
    }

    @NotNull
    public String toString() {
        List v;
        Directive d;
        Object object;
        Object element$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Map<ValueDirective<?>, List<Object>> $this$forEach$iv = this.simpleDirectives;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            SimpleDirective it = (SimpleDirective)element$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder2 = $this$toString_u24lambda_u243.append("  " + it);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        }
        $this$forEach$iv = this.stringDirectives;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            object = element$iv = (Map.Entry)iterator.next();
            boolean bl3 = false;
            d = (StringDirective)object.getKey();
            v = (List)object.getValue();
            StringBuilder stringBuilder3 = $this$toString_u24lambda_u243.append("  " + d + ": " + StringUtilsKt.joinToArrayString(v));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        }
        $this$forEach$iv = this.valueDirectives;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            object = element$iv = (Map.Entry)iterator.next();
            boolean bl4 = false;
            d = (ValueDirective)object.getKey();
            v = (List)object.getValue();
            StringBuilder stringBuilder4 = $this$toString_u24lambda_u243.append("  " + d + ": " + StringUtilsKt.joinToArrayString(v));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public Iterator<Directive> iterator() {
        List list;
        List $this$iterator_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$iterator_u24lambda_u244.addAll((Collection)this.simpleDirectives);
        $this$iterator_u24lambda_u244.addAll((Collection)this.stringDirectives.keySet());
        $this$iterator_u24lambda_u244.addAll((Collection)this.valueDirectives.keySet());
        return CollectionsKt.build((List)list).iterator();
    }
}

