/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectivesImpl;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BO\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u0012\u001c\u0010\n\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b0\u0006\u00a2\u0006\u0004\b\f\u0010\rB\t\b\u0016\u00a2\u0006\u0004\b\f\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\f\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0013*\u00020\u0004H\u0086\u0002J\r\u0010\u0014\u001a\u00020\u0013*\u00020\u0004H\u0086\u0002J\u0015\u0010\u0015\u001a\u00020\u0013*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\tH\u0086\u0004J\u001b\u0010\u0015\u001a\u00020\u0013*\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0086\u0004J\u0015\u0010\u0018\u001a\u00020\u0013*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\tH\u0086\u0002J\r\u0010\u0014\u001a\u00020\u0013*\u00020\u0007H\u0086\u0002J*\u0010\u0015\u001a\u00020\u0013\"\b\b\u0000\u0010\u0019*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\u00190\u000b2\u0006\u0010\u0016\u001a\u0002H\u0019H\u0086\u0004\u00a2\u0006\u0002\u0010\u001aJ+\u0010\u0015\u001a\u00020\u0013\"\b\b\u0000\u0010\u0019*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\u00190\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00190\bH\u0086\u0004J\u0011\u0010\u0014\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030\u000bH\u0086\u0002J=\u0010\u001b\u001a\u00020\u0013\"\b\b\u0000\u0010\u001c*\u00020\u001d\"\u0004\b\u0001\u0010\u001e*\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u0002H\u001e0\u00062\u0006\u0010\u001f\u001a\u0002H\u001c2\u0006\u0010\u0016\u001a\u0002H\u001eH\u0002\u00a2\u0006\u0002\u0010 J\u0006\u0010!\u001a\u00020\u0010R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/test/builders/RegisteredDirectivesBuilder;", "", "simpleDirectives", "", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "stringDirectives", "", "Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "", "", "valueDirectives", "Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", "<init>", "(Ljava/util/List;Ljava/util/Map;Ljava/util/Map;)V", "()V", "old", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "(Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;)V", "unaryPlus", "", "unaryMinus", "with", "value", "values", "plus", "T", "(Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;Ljava/lang/Object;)V", "putWithExistsCheck", "K", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "V", "key", "(Ljava/util/Map;Lorg/jetbrains/kotlin/test/directives/model/Directive;Ljava/lang/Object;)V", "build", "tests-common-new_test"})
public final class RegisteredDirectivesBuilder {
    @NotNull
    private final List<SimpleDirective> simpleDirectives;
    @NotNull
    private final Map<StringDirective, List<String>> stringDirectives;
    @NotNull
    private final Map<ValueDirective<?>, List<Object>> valueDirectives;

    private RegisteredDirectivesBuilder(List<SimpleDirective> simpleDirectives, Map<StringDirective, List<String>> stringDirectives, Map<ValueDirective<?>, List<Object>> valueDirectives) {
        this.simpleDirectives = simpleDirectives;
        this.stringDirectives = stringDirectives;
        this.valueDirectives = valueDirectives;
    }

    public RegisteredDirectivesBuilder() {
        this(new ArrayList(), new LinkedHashMap(), new LinkedHashMap());
    }

    public RegisteredDirectivesBuilder(@NotNull RegisteredDirectives old) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        this();
        for (Directive directive : old) {
            Directive directive2 = directive;
            if (directive2 instanceof SimpleDirective) {
                this.unaryPlus((SimpleDirective)directive);
                continue;
            }
            if (directive2 instanceof StringDirective) {
                this.with((StringDirective)directive, old.get((StringDirective)directive));
                continue;
            }
            if (directive2 instanceof ValueDirective) {
                this.valueDirectives.put((ValueDirective<?>)directive, old.get((ValueDirective)directive));
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void unaryPlus(@NotNull SimpleDirective $this$unaryPlus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryPlus, (String)"<this>");
        ((Collection)this.simpleDirectives).add($this$unaryPlus);
    }

    public final void unaryMinus(@NotNull SimpleDirective $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        this.simpleDirectives.remove($this$unaryMinus);
    }

    public final void with(@NotNull StringDirective $this$with, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$with, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.with($this$with, CollectionsKt.listOf((Object)value));
    }

    public final void with(@NotNull StringDirective $this$with, @NotNull List<String> values) {
        Intrinsics.checkNotNullParameter((Object)$this$with, (String)"<this>");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.putWithExistsCheck(this.stringDirectives, (Directive)$this$with, values);
    }

    public final void plus(@NotNull StringDirective $this$plus, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        List list = this.stringDirectives.get($this$plus);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List previous = list;
        this.stringDirectives.put($this$plus, CollectionsKt.plus((Collection)previous, (Object)value));
    }

    public final void unaryMinus(@NotNull StringDirective $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        this.stringDirectives.remove($this$unaryMinus);
    }

    public final <T> void with(@NotNull ValueDirective<T> $this$with, @NotNull T value) {
        Intrinsics.checkNotNullParameter($this$with, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.with($this$with, CollectionsKt.listOf(value));
    }

    public final <T> void with(@NotNull ValueDirective<T> $this$with, @NotNull List<? extends T> values) {
        Intrinsics.checkNotNullParameter($this$with, (String)"<this>");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.putWithExistsCheck(this.valueDirectives, (Directive)$this$with, values);
    }

    public final void unaryMinus(@NotNull ValueDirective<?> $this$unaryMinus) {
        Intrinsics.checkNotNullParameter($this$unaryMinus, (String)"<this>");
        this.valueDirectives.remove($this$unaryMinus);
    }

    private final <K extends Directive, V> void putWithExistsCheck(Map<K, V> $this$putWithExistsCheck, K key, V value) {
        Object object;
        V alreadyRegistered = $this$putWithExistsCheck.get(key);
        if (alreadyRegistered == null) {
            object = $this$putWithExistsCheck.put(key, value);
        } else if (alreadyRegistered instanceof List && value instanceof List) {
            object = $this$putWithExistsCheck.put(key, CollectionsKt.plus((Collection)((Collection)alreadyRegistered), (Iterable)((Iterable)value)));
        } else {
            throw new IllegalStateException(("Default values for " + key + " directive already registered").toString());
        }
    }

    @NotNull
    public final RegisteredDirectives build() {
        return new RegisteredDirectivesImpl(this.simpleDirectives, this.stringDirectives, this.valueDirectives);
    }
}

