/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.FirIdenticalCheckerHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0014J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/SimpleFirIrIdenticalChecker;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "dumpExtension", "", "getDumpExtension", "()Ljava/lang/String;", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "simpleChecker", "Lorg/jetbrains/kotlin/test/utils/FirIdenticalCheckerHelper;", "getSimpleChecker", "()Lorg/jetbrains/kotlin/test/utils/FirIdenticalCheckerHelper;", "shouldRun", "", "check", "", "failedAssertions", "Lorg/jetbrains/kotlin/test/WrappedException;", "markedAsIdentical", "processClassicFileIfContentIsIdentical", "testDataFile", "Ljava/io/File;", "tests-common-new_test"})
public abstract class SimpleFirIrIdenticalChecker
extends AfterAnalysisChecker {
    @NotNull
    private final FirIdenticalCheckerHelper simpleChecker;

    public SimpleFirIrIdenticalChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
        this.simpleChecker = new FirIdenticalCheckerHelper(testServices, this){
            final /* synthetic */ SimpleFirIrIdenticalChecker this$0;
            {
                this.this$0 = $receiver;
                super($testServices);
            }

            public File getClassicFileToCompare(File testDataFile) {
                File file;
                Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
                File it = file = FileUtilsKt.withExtension(testDataFile, this.this$0.getDumpExtension());
                boolean bl = false;
                return it.exists() ? file : null;
            }

            public File getFirFileToCompare(File testDataFile) {
                File file;
                Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
                File it = file = FileUtilsKt.withExtension(testDataFile, "fir." + this.this$0.getDumpExtension());
                boolean bl = false;
                return it.exists() ? file : null;
            }
        };
    }

    @NotNull
    protected abstract String getDumpExtension();

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    @NotNull
    protected final FirIdenticalCheckerHelper getSimpleChecker() {
        return this.simpleChecker;
    }

    protected boolean shouldRun() {
        return true;
    }

    @Override
    public void check(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        if (!this.shouldRun()) {
            return;
        }
        if (!((Collection)failedAssertions).isEmpty()) {
            return;
        }
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        if (this.markedAsIdentical()) {
            this.simpleChecker.deleteFirFile(testDataFile);
            return;
        }
        if (FirIdenticalCheckerHelper.firAndClassicContentsAreEquals$default(this.simpleChecker, testDataFile, false, 2, null)) {
            this.simpleChecker.deleteFirFile(testDataFile);
            this.processClassicFileIfContentIsIdentical(testDataFile);
        }
    }

    protected boolean markedAsIdentical() {
        return TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL());
    }

    protected void processClassicFileIfContentIsIdentical(@NotNull File testDataFile) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        FirIdenticalCheckerHelper.addDirectiveToClassicFileAndAssert$default(this.simpleChecker, testDataFile, null, 2, null);
    }
}

