/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.utils.DiagnosticsRenderingConfiguration;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.backend.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.test.backend.handlers.JvmBackendDiagnosticsHandler;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicDiagnosticReporter;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicDiagnosticReporterKt;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DiagnosticsService;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.junit.jupiter.api.AssertionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/JvmBackendDiagnosticsHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "reporter", "Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicDiagnosticReporter;", "additionalServices", "", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "()Ljava/util/List;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "processAfterAllModules", "someAssertionWasFailed", "", "reportDiagnostics", "reportKtDiagnostics", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nJvmBackendDiagnosticsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmBackendDiagnosticsHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/JvmBackendDiagnosticsHandler\n+ 2 TestServices.kt\norg/jetbrains/kotlin/test/services/TestServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n25#2:51\n1202#3,2:52\n1230#3,4:54\n*S KotlinDebug\n*F\n+ 1 JvmBackendDiagnosticsHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/JvmBackendDiagnosticsHandler\n*L\n21#1:51\n33#1:52,2\n33#1:54,4\n*E\n"})
public final class JvmBackendDiagnosticsHandler
extends JvmBinaryArtifactHandler {
    @NotNull
    private final ClassicDiagnosticReporter reporter;

    public JvmBackendDiagnosticsHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, 2, null);
        this.reporter = new ClassicDiagnosticReporter(testServices);
    }

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        Function1 serviceConstructor$iv = additionalServices.1.INSTANCE;
        boolean $i$f$service = false;
        return CollectionsKt.listOf((Object)new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(DiagnosticsService.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv));
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.Jvm info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.reportDiagnostics(module, info);
        this.reportKtDiagnostics(module, info);
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        HandlerUtilsKt.checkFullDiagnosticRender(this);
    }

    /*
     * WARNING - void declaration
     */
    private final void reportDiagnostics(TestModule module, BinaryArtifacts.Jvm info) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = module.getFiles();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            TestFile testFile = (TestFile)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put('/' + it.getName(), element$iv$iv);
        }
        Map testFiles = destination$iv$iv;
        DiagnosticsRenderingConfiguration configuration2 = this.reporter.createConfiguration(module);
        boolean withNewInferenceModeEnabled = ClassicDiagnosticReporterKt.withNewInferenceModeEnabled(this.getTestServices());
        Collection diagnostics = info.getClassFileFactory().getGenerationState().getCollectedExtraJvmDiagnostics().all();
        for (Diagnostic diagnostic : diagnostics) {
            TestFile testFile;
            PsiFile psiFile = diagnostic.getPsiFile();
            KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
            if (ktFile == null) {
                AssertionsKt.fail$default((String)("PSI file is not a KtFile: " + diagnostic.getPsiFile()), null, (int)2, null);
                throw null;
            }
            KtFile ktFile2 = ktFile;
            if ((TestFile)testFiles.get(ktFile2.getVirtualFilePath()) == null) {
                AssertionsKt.fail$default((String)("Test file for KtFile not found: " + ktFile2.getVirtualFilePath()), null, (int)2, null);
                throw null;
            }
            this.reporter.reportDiagnostic(diagnostic, module, testFile, configuration2, withNewInferenceModeEnabled);
        }
    }

    private final void reportKtDiagnostics(TestModule module, BinaryArtifacts.Jvm info) {
        DiagnosticReporter diagnosticReporter = info.getClassFileFactory().getGenerationState().getDiagnosticReporter();
        Intrinsics.checkNotNull((Object)diagnosticReporter, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector");
        BaseDiagnosticsCollector ktDiagnosticReporter = (BaseDiagnosticsCollector)diagnosticReporter;
        HandlerUtilsKt.reportKtDiagnostics(this, module, ktDiagnosticReporter);
    }
}

