/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codeMetaInfo.model.ParsedCodeMetaInfo;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.backend.handlers.IrInterpreterBackendHandlerKt;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.model.BackendKinds;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\rH\u0016J\u001c\u0010\u0010\u001a\u00020\u000b*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u00180\u0017*\u00020\u0013H\u0002R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001a\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrInterpreterDumpHandler;", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "globalMetadataInfoHandler", "Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "getGlobalMetadataInfoHandler", "()Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "isSuppressedForK2", "", "processFile", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "testFile", "Lorg/jetbrains/kotlin/test/model/TestFile;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "extractRangesWithoutRender", "", "Lkotlin/Pair;", "", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nIrInterpreterDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInterpreterDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrInterpreterDumpHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1863#2,2:118\n1755#2,3:121\n216#3:120\n217#3:124\n1#4:125\n*S KotlinDebug\n*F\n+ 1 IrInterpreterDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrInterpreterDumpHandler\n*L\n31#1:118,2\n56#1:121,3\n54#1:120\n54#1:124\n*E\n"})
public interface IrInterpreterDumpHandler {
    @NotNull
    public TestServices getTestServices();

    private GlobalMetadataInfoHandler getGlobalMetadataInfoHandler() {
        return GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler(this.getTestServices());
    }

    default public void processModule(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!this.isSuppressedForK2(module) && Intrinsics.areEqual(DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getDefaultFrontend(), (Object)FrontendKinds.ClassicFrontend.INSTANCE)) {
            Iterable $this$forEach$iv = module.getFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TestFile testFile = (TestFile)element$iv;
                boolean bl = false;
                List<ParsedCodeMetaInfo> expected = this.getGlobalMetadataInfoHandler().getExistingMetaInfosForFile(testFile);
                this.getGlobalMetadataInfoHandler().addMetadataInfosForFile(testFile, expected);
            }
            return;
        }
        CompilerConfiguration configuration2 = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.getTestServices()).getCompilerConfiguration(module);
        EvaluatedConstTracker evaluatedConstTracker = (EvaluatedConstTracker)configuration2.get(CommonConfigurationKeys.EVALUATED_CONST_TRACKER);
        if (evaluatedConstTracker == null) {
            return;
        }
        EvaluatedConstTracker evaluatedConstTracker2 = evaluatedConstTracker;
        IrModuleFragment irModule = ((IrBackendInput)DependencyProviderKt.getDependencyProvider(this.getTestServices()).getArtifact(module, BackendKinds.IrBackend.INSTANCE)).getIrModuleFragment();
        for (Pair<IrFile, TestFile> pair : IrInterpreterBackendHandlerKt.matchIrFileWithTestFile(irModule, module)) {
            IrFile irFile = (IrFile)pair.component1();
            TestFile testFile = (TestFile)pair.component2();
            this.processFile(evaluatedConstTracker2, testFile, irFile);
        }
    }

    default public boolean isSuppressedForK2(@NotNull TestModule $this$isSuppressedForK2) {
        TargetBackend targetBackend;
        Intrinsics.checkNotNullParameter((Object)$this$isSuppressedForK2, (String)"<this>");
        List<TargetBackend> ignoredBackends = $this$isSuppressedForK2.getDirectives().get(CodegenTestDirectives.INSTANCE.getIGNORE_BACKEND_K2());
        TargetBackend targetBackend2 = DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getDefaultTargetBackend();
        if (targetBackend2 == null) {
            targetBackend2 = $this$isSuppressedForK2.getTargetBackend();
        }
        return CollectionsKt.contains((Iterable)ignoredBackends, (Object)((Object)(targetBackend = targetBackend2))) || ignoredBackends.contains((Object)TargetBackend.ANY);
    }

    private void processFile(EvaluatedConstTracker $this$processFile, TestFile testFile, IrFile irFile) {
        block5: {
            List<Pair<Integer, Integer>> rangesThatAreNotSupposedToBeRendered = this.extractRangesWithoutRender(testFile);
            Map map = $this$processFile.load(IrDeclarationsKt.getNameWithPackage((IrFile)irFile));
            if (map == null) break block5;
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean bl;
                int end;
                int start;
                ConstantValue constantValue;
                block4: {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    Pair pair = (Pair)entry.getKey();
                    constantValue = (ConstantValue)entry.getValue();
                    start = ((Number)pair.component1()).intValue();
                    end = ((Number)pair.component2()).intValue();
                    Iterable $this$any$iv = rangesThatAreNotSupposedToBeRendered;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            Pair it = (Pair)element$iv2;
                            boolean bl3 = false;
                            if (!(start >= ((Number)it.getFirst()).intValue() && start <= ((Number)it.getSecond()).intValue())) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (bl) continue;
                String message = constantValue.stringTemplateValue();
                ParsedCodeMetaInfo metaInfo = new ParsedCodeMetaInfo(start, end, new ArrayList(), constantValue instanceof ErrorValue ? "WAS_NOT_EVALUATED" : "EVALUATED", StringUtil.escapeLineBreak((String)message));
                this.getGlobalMetadataInfoHandler().addMetadataInfosForFile(testFile, CollectionsKt.listOf((Object)metaInfo));
            }
        }
    }

    private List<Pair<Integer, Integer>> extractRangesWithoutRender(TestFile $this$extractRangesWithoutRender) {
        List list;
        String content = SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getContentOfSourceFile($this$extractRangesWithoutRender);
        List $this$extractRangesWithoutRender_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int indexOfStop = -1;
        while ((indexOfStop = StringsKt.indexOf$default((CharSequence)content, (String)"// STOP_EVALUATION_CHECKS", (int)(indexOfStop + 1), (boolean)false, (int)4, null)) >= 0) {
            Integer n = StringsKt.indexOf$default((CharSequence)content, (String)"// START_EVALUATION_CHECKS", (int)indexOfStop, (boolean)false, (int)4, null);
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            Integer n2 = it != -1 ? n : null;
            int indexOfStart = n2 != null ? n2.intValue() : content.length();
            $this$extractRangesWithoutRender_u24lambda_u244.add(TuplesKt.to((Object)indexOfStop, (Object)indexOfStart));
        }
        return CollectionsKt.build((List)list);
    }
}

