/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.backend.handlers.FirIrDumpIdenticalChecker;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.FirIdenticalCheckerHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0002\f\u000f\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0007H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/FirIrDumpIdenticalChecker;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "simpleDumpChecker", "org/jetbrains/kotlin/test/backend/handlers/FirIrDumpIdenticalChecker$simpleDumpChecker$1", "Lorg/jetbrains/kotlin/test/backend/handlers/FirIrDumpIdenticalChecker$simpleDumpChecker$1;", "prettyDumpChecker", "org/jetbrains/kotlin/test/backend/handlers/FirIrDumpIdenticalChecker$prettyDumpChecker$1", "Lorg/jetbrains/kotlin/test/backend/handlers/FirIrDumpIdenticalChecker$prettyDumpChecker$1;", "check", "", "failedAssertions", "Lorg/jetbrains/kotlin/test/WrappedException;", "tests-common-new_test"})
public final class FirIrDumpIdenticalChecker
extends AfterAnalysisChecker {
    @NotNull
    private final simpleDumpChecker.1 simpleDumpChecker;
    @NotNull
    private final prettyDumpChecker.1 prettyDumpChecker;

    public FirIrDumpIdenticalChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
        this.simpleDumpChecker = new FirIdenticalCheckerHelper(testServices){

            public File getClassicFileToCompare(File testDataFile) {
                File file;
                Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
                File it = file = FileUtilsKt.withExtension(testDataFile, "ir.txt");
                boolean bl = false;
                return it.exists() ? file : null;
            }

            public File getFirFileToCompare(File testDataFile) {
                File file;
                Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
                File it = file = FileUtilsKt.withExtension(testDataFile, "fir.ir.txt");
                boolean bl = false;
                return it.exists() ? file : null;
            }
        };
        this.prettyDumpChecker = new FirIdenticalCheckerHelper(testServices){

            public File getClassicFileToCompare(File testDataFile) {
                File file;
                Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
                File it = file = FileUtilsKt.withExtension(testDataFile, "kt.txt");
                boolean bl = false;
                return it.exists() ? file : null;
            }

            public File getFirFileToCompare(File testDataFile) {
                File file;
                Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
                File it = file = FileUtilsKt.withExtension(testDataFile, "fir.kt.txt");
                boolean bl = false;
                return it.exists() ? file : null;
            }
        };
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void check(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        if (!((Collection)failedAssertions).isEmpty()) {
            return;
        }
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        if (!Intrinsics.areEqual(DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getDefaultFrontend(), (Object)FrontendKinds.FIR.INSTANCE)) {
            return;
        }
        if (!TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_IR())) {
            return;
        }
        if (TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL())) {
            this.simpleDumpChecker.deleteFirFile(testDataFile);
            this.prettyDumpChecker.deleteFirFile(testDataFile);
            return;
        }
        if (FirIdenticalCheckerHelper.firAndClassicContentsAreEquals$default(this.simpleDumpChecker, testDataFile, false, 2, null) && this.prettyDumpChecker.firAndClassicContentsAreEquals(testDataFile, true)) {
            this.simpleDumpChecker.deleteFirFile(testDataFile);
            this.prettyDumpChecker.deleteFirFile(testDataFile);
            FirIdenticalCheckerHelper.addDirectiveToClassicFileAndAssert$default(this.simpleDumpChecker, testDataFile, null, 2, null);
        }
    }
}

