/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.backend.TargetInliner;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectivesKt;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0016J,\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/test/backend/BlackBoxInlinerCodegenSuppressor;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "suppressIfNeeded", "Lorg/jetbrains/kotlin/test/WrappedException;", "failedAssertions", "suppressForTargetFrontend", "directive", "Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", "Lorg/jetbrains/kotlin/test/backend/TargetInliner;", "tests-common-new_test"})
public final class BlackBoxInlinerCodegenSuppressor
extends AfterAnalysisChecker {
    public BlackBoxInlinerCodegenSuppressor(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    @Override
    @NotNull
    public List<WrappedException> suppressIfNeeded(@NotNull List<? extends WrappedException> failedAssertions) {
        List<WrappedException> list;
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        FrontendKind<?> targetFrontend = DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getDefaultFrontend();
        List<WrappedException> commonResult = this.suppressForTargetFrontend(failedAssertions, CodegenTestDirectives.INSTANCE.getIGNORE_INLINER());
        if (commonResult != null) {
            return commonResult;
        }
        FrontendKind<?> frontendKind = targetFrontend;
        if (Intrinsics.areEqual(frontendKind, (Object)FrontendKinds.ClassicFrontend.INSTANCE)) {
            list = this.suppressForTargetFrontend(failedAssertions, CodegenTestDirectives.INSTANCE.getIGNORE_INLINER_K1());
            if (list == null) {
                list = failedAssertions;
            }
        } else if (Intrinsics.areEqual(frontendKind, (Object)FrontendKinds.FIR.INSTANCE)) {
            list = this.suppressForTargetFrontend(failedAssertions, CodegenTestDirectives.INSTANCE.getIGNORE_INLINER_K2());
            if (list == null) {
                list = failedAssertions;
            }
        } else {
            list = failedAssertions;
        }
        return list;
    }

    private final List<WrappedException> suppressForTargetFrontend(List<? extends WrappedException> failedAssertions, ValueDirective<TargetInliner> directive) {
        TargetInliner ignoreDirective = CodegenTestDirectivesKt.tryRetrieveIgnoredInliner(this.getTestServices(), directive);
        boolean enabledIrInliner = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(LanguageSettingsDirectives.INSTANCE.getENABLE_JVM_IR_INLINER());
        List unmuteError = CollectionsKt.listOf((Object)this.wrap((Throwable)((Object)new AssertionError((Object)("Looks like this test can be unmuted. Please remove " + directive.getName() + " directive.")))));
        if (ignoreDirective == TargetInliner.IR && enabledIrInliner || ignoreDirective == TargetInliner.BYTECODE && !enabledIrInliner) {
            return !((Collection)failedAssertions).isEmpty() ? CollectionsKt.emptyList() : unmuteError;
        }
        return null;
    }
}

