/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.common.CommonPlatformAnalyzerServices;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.js.resolve.JsPlatformAnalyzerServices;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.WasmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;
import org.jetbrains.kotlin.resolve.konan.platform.NativePlatformAnalyzerServices;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.wasm.resolve.WasmPlatformAnalyzerServices;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a/\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\b0\u000e\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"initIdeaConfiguration", "", "computeHomeDirectory", "", "getAnalyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "runWithEnablingFirUseOption", "T", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "lambda", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/test/model/TestModule;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "tests-common-new_test"})
public final class TestSetupUtilsKt {
    public static final void initIdeaConfiguration() {
        System.setProperty("idea.home", TestSetupUtilsKt.computeHomeDirectory());
        System.setProperty("idea.ignore.disabled.plugins", "true");
    }

    private static final String computeHomeDirectory() {
        String userDir = System.getProperty("user.dir");
        String string = userDir;
        if (string == null) {
            string = ".";
        }
        String string2 = new File(string).getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
        return string2;
    }

    @NotNull
    public static final PlatformDependentAnalyzerServices getAnalyzerServices(@NotNull TargetPlatform $this$getAnalyzerServices) {
        PlatformDependentAnalyzerServices platformDependentAnalyzerServices;
        Intrinsics.checkNotNullParameter((Object)$this$getAnalyzerServices, (String)"<this>");
        if (JvmPlatformKt.isJvm((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)JvmPlatformAnalyzerServices.INSTANCE;
        } else if (JsPlatformKt.isJs((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)JsPlatformAnalyzerServices.INSTANCE;
        } else if (NativePlatformKt.isNative((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)NativePlatformAnalyzerServices.INSTANCE;
        } else if (TargetPlatformKt.isCommon((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)CommonPlatformAnalyzerServices.INSTANCE;
        } else if (WasmPlatformKt.isWasm((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)WasmPlatformAnalyzerServices.INSTANCE;
        } else {
            throw new IllegalStateException(("Unknown target platform: " + $this$getAnalyzerServices).toString());
        }
        return platformDependentAnalyzerServices;
    }

    public static final <T> T runWithEnablingFirUseOption(@NotNull TestServices testServices, @NotNull TestModule module, @NotNull Function0<? extends T> lambda) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(lambda, (String)"lambda");
        CompilerConfiguration compilerConfiguration = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(testServices).getCompilerConfiguration(module);
        compilerConfiguration.put(CommonConfigurationKeys.USE_FIR, (Object)true);
        Object result = lambda.invoke();
        compilerConfiguration.put(CommonConfigurationKeys.USE_FIR, (Object)false);
        return (T)result;
    }
}

