/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.generators.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\t\u001a\u00020\u0007\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"TAGS_FILE_NAME", "", "PROHIBITED_SYMBOLS", "", "", "extractTagsFromDirectory", "dir", "Ljava/io/File;", "extractTagsFromTestFile", "file", "validateTag", "", "tag", "test-generator_test"})
@SourceDebugExtension(value={"SMAP\nTagsExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TagsExtractor.kt\norg/jetbrains/kotlin/generators/util/TagsExtractorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,30:1\n774#2:31\n865#2,2:32\n2642#2:34\n2632#2,3:36\n1#3:35\n*S KotlinDebug\n*F\n+ 1 TagsExtractor.kt\norg/jetbrains/kotlin/generators/util/TagsExtractorKt\n*L\n19#1:31\n19#1:32,2\n19#1:34\n26#1:36,3\n19#1:35\n*E\n"})
public final class TagsExtractorKt {
    @NotNull
    private static final String TAGS_FILE_NAME = "_tags.txt";
    @NotNull
    private static final List<Character> PROHIBITED_SYMBOLS;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> extractTagsFromDirectory(@NotNull File dir) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!dir.isDirectory()) {
            boolean $i$a$-require-TagsExtractorKt$extractTagsFromDirectory$22 = false;
            String $i$a$-require-TagsExtractorKt$extractTagsFromDirectory$22 = dir.getAbsolutePath() + " is not a directory";
            throw new IllegalArgumentException($i$a$-require-TagsExtractorKt$extractTagsFromDirectory$22.toString());
        }
        File tagsFile = FilesKt.resolve((File)dir, (String)TAGS_FILE_NAME);
        if (!tagsFile.exists()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = FilesKt.readLines$default((File)tagsFile, null, (int)1, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$onEach$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2419$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
            String p0 = (String)element$iv;
            boolean bl3 = false;
            TagsExtractorKt.validateTag(p0);
        }
        return (List)iterable;
    }

    @NotNull
    public static final List<String> extractTagsFromTestFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return CollectionsKt.emptyList();
    }

    private static final void validateTag(String tag) {
        boolean bl;
        block4: {
            Iterable $this$none$iv = PROHIBITED_SYMBOLS;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    char it = ((Character)element$iv).charValue();
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)tag, (char)it, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Tag \"tag\" contains one of prohibited symbols: " + PROHIBITED_SYMBOLS;
            throw new IllegalArgumentException(string.toString());
        }
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf(' '), Character.valueOf(','), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('!')};
        PROHIBITED_SYMBOLS = CollectionsKt.listOf((Object[])objectArray);
    }
}

