/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.services.JUnit5Assertions;
import org.jetbrains.kotlin.test.utils.LocalVariableRecord;
import org.jetbrains.kotlin.test.utils.SteppingTestLoggedData;
import org.jetbrains.kotlin.test.utils.SteppingTestUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u001a8\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0010\b\u0002\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"EXPECTATIONS_MARKER", "", "FORCE_STEP_INTO_MARKER", "checkSteppingTestResult", "", "frontendKind", "Lorg/jetbrains/kotlin/test/model/FrontendKind;", "targetBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "wholeFile", "Ljava/io/File;", "loggedItems", "", "Lorg/jetbrains/kotlin/test/utils/SteppingTestLoggedData;", "compressSequencesWithoutLineNumber", "formatAsSteppingTestExpectation", "sourceName", "lineNumber", "", "functionName", "isSynthetic", "", "visibleVars", "Lorg/jetbrains/kotlin/test/utils/LocalVariableRecord;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nSteppingTestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SteppingTestUtils.kt\norg/jetbrains/kotlin/test/utils/SteppingTestUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 ModuleStructureExtractorImpl.kt\norg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImplKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,166:1\n1745#2,3:167\n764#2:170\n855#2,2:171\n1547#2:173\n1618#2,3:174\n1144#3:177\n1313#3:178\n1314#3:186\n1145#3:187\n1144#3:189\n1313#3:190\n1314#3:192\n1145#3:193\n488#4,6:179\n1#5:185\n1#5:188\n1#5:191\n1#5:194\n32#6,2:195\n*S KotlinDebug\n*F\n+ 1 SteppingTestUtils.kt\norg/jetbrains/kotlin/test/utils/SteppingTestUtilsKt\n*L\n64#1:167,3\n67#1:170\n67#1:171,2\n71#1:173\n71#1:174,3\n96#1:177\n96#1:178\n96#1:186\n96#1:187\n100#1:189\n100#1:190\n100#1:192\n100#1:193\n96#1:179,6\n96#1:185\n100#1:191\n116#1:195,2\n*E\n"})
public final class SteppingTestUtilsKt {
    @NotNull
    private static final String EXPECTATIONS_MARKER = "// EXPECTATIONS";
    @NotNull
    private static final String FORCE_STEP_INTO_MARKER = "// FORCE_STEP_INTO";

    /*
     * WARNING - void declaration
     */
    public static final void checkSteppingTestResult(@NotNull FrontendKind<?> frontendKind, @NotNull TargetBackend targetBackend, @NotNull File wholeFile, @NotNull List<SteppingTestLoggedData> loggedItems) {
        ListIterator lineIterator;
        ListIterator $this$mapTo$iv$iv;
        void $this$map$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object element$iv2;
        boolean bl;
        List lines;
        List actual;
        block18: {
            Intrinsics.checkNotNullParameter(frontendKind, (String)"frontendKind");
            Intrinsics.checkNotNullParameter((Object)((Object)targetBackend), (String)"targetBackend");
            Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
            Intrinsics.checkNotNullParameter(loggedItems, (String)"loggedItems");
            actual = new ArrayList();
            lines = FilesKt.readLines$default((File)wholeFile, null, (int)1, null);
            Iterable $this$any$iv = lines;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    String it2 = (String)element$iv2;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)it2, (String)FORCE_STEP_INTO_MARKER, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block18;
                }
                bl = false;
            }
        }
        boolean forceStepInto = bl;
        Iterable $i$f$any = SteppingTestUtilsKt.compressSequencesWithoutLineNumber(loggedItems);
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SteppingTestLoggedData)element$iv$iv;
            boolean bl3 = false;
            if (!(forceStepInto || !((SteppingTestLoggedData)it).isSynthetic())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            it = (SteppingTestLoggedData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add("// " + ((SteppingTestLoggedData)it).getExpectation());
        }
        List actualLineNumbers = (List)destination$iv$iv;
        Iterator actualLineNumbersIterator = actualLineNumbers.iterator();
        $this$mapTo$iv$iv = lineIterator = lines.listIterator();
        while (((Iterator)$this$mapTo$iv$iv).hasNext()) {
            String line = (String)$this$mapTo$iv$iv.next();
            if (StringsKt.startsWith$default((String)line, (String)EXPECTATIONS_MARKER, (boolean)false, (int)2, null)) {
                if (!lineIterator.hasPrevious()) break;
                lineIterator.previous();
                break;
            }
            actual.add(line);
            if (!StringsKt.startsWith$default((String)line, (String)FORCE_STEP_INTO_MARKER, (boolean)false, (int)2, null)) continue;
        }
        Set currentBackends = SetsKt.setOf((Object)((Object)TargetBackend.ANY));
        Set currentFrontends = SetsKt.setOf(frontendKind);
        ListIterator $i$f$mapTo22 = lineIterator;
        while (((Iterator)$i$f$mapTo22).hasNext()) {
            String line = (String)$i$f$mapTo22.next();
            if (((CharSequence)line).length() == 0) {
                actual.add(line);
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)EXPECTATIONS_MARKER, (boolean)false, (int)2, null)) {
                Collection $this$mapNotNullTo$iv;
                actual.add(line);
                it = StringsKt.removePrefix((String)line, (CharSequence)EXPECTATIONS_MARKER);
                Regex bl4 = new Regex("\\s+");
                int n = 0;
                Sequence backendsAndFrontends2 = SequencesKt.filter((Sequence)bl4.splitToSequence((CharSequence)it, n), (Function1)checkSteppingTestResult.backendsAndFrontends.1.INSTANCE);
                bl4 = backendsAndFrontends2;
                Collection destination$iv = new LinkedHashSet();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    TargetBackend targetBackend2;
                    block19: {
                        Object element$iv$iv;
                        Object element$iv3 = element$iv$iv = iterator2.next();
                        boolean bl5 = false;
                        String it3 = (String)element$iv3;
                        boolean bl6 = false;
                        boolean $i$f$valueOfOrNull = false;
                        for (TargetBackend enumValue$iv : TargetBackend.values()) {
                            if (!Intrinsics.areEqual((Object)enumValue$iv.name(), (Object)it3)) continue;
                            targetBackend2 = enumValue$iv;
                            break block19;
                        }
                        targetBackend2 = null;
                    }
                    if (targetBackend2 == null) continue;
                    TargetBackend it$iv = targetBackend2;
                    boolean bl7 = false;
                    destination$iv.add(it$iv);
                }
                $this$mapNotNullTo$iv = destination$iv;
                Collection it4 = (Set)$this$mapNotNullTo$iv;
                boolean $i$a$-takeIf-SteppingTestUtilsKt$checkSteppingTestResult$32 = false;
                Set set = (Set)(!((Collection)it4).isEmpty() ? $this$mapNotNullTo$iv : null);
                if (set == null) {
                    set = SetsKt.setOf((Object)((Object)TargetBackend.ANY));
                }
                currentBackends = set;
                $this$mapNotNullTo$iv = backendsAndFrontends2;
                it4 = new LinkedHashSet();
                FrontendKinds $i$a$-takeIf-SteppingTestUtilsKt$checkSteppingTestResult$32 = FrontendKinds.INSTANCE;
                boolean $i$f$mapNotNullTo2 = false;
                Collection $this$forEach$iv$iv2 = $this$mapNotNullTo$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator3 = $this$forEach$iv$iv2.iterator();
                while (iterator3.hasNext()) {
                    FrontendKind<?> it$iv;
                    Object element$iv$iv;
                    Object element$iv4 = element$iv$iv = iterator3.next();
                    boolean bl8 = false;
                    String p0 = (String)element$iv4;
                    boolean bl9 = false;
                    if ($i$a$-takeIf-SteppingTestUtilsKt$checkSteppingTestResult$32.fromString(p0) == null) continue;
                    boolean bl10 = false;
                    destination$iv.add(it$iv);
                }
                $this$mapNotNullTo$iv = destination$iv;
                it4 = (Set)$this$mapNotNullTo$iv;
                boolean bl11 = false;
                Set set2 = (Set)(!((Collection)it4).isEmpty() ? $this$mapNotNullTo$iv : null);
                if (set2 == null) {
                    set2 = SetsKt.setOf(frontendKind);
                }
                currentFrontends = set2;
                continue;
            }
            if ((currentBackends.contains((Object)TargetBackend.ANY) || currentBackends.contains((Object)targetBackend)) && currentFrontends.contains(frontendKind)) {
                if (!actualLineNumbersIterator.hasNext()) continue;
                actual.add(actualLineNumbersIterator.next());
                continue;
            }
            actual.add(line);
        }
        Iterator $this$forEach$iv = actualLineNumbersIterator;
        boolean $i$f$forEach = false;
        Iterator iterator4 = $this$forEach$iv;
        while (iterator4.hasNext()) {
            Object element$iv5 = iterator4.next();
            String it5 = (String)element$iv5;
            boolean bl12 = false;
            actual.add(it5);
        }
        if (!StringsKt.isBlank((CharSequence)((CharSequence)CollectionsKt.last((List)actual)))) {
            actual.add("");
        }
        Assertions.assertEqualsToFile$default((Assertions)JUnit5Assertions.INSTANCE, wholeFile, CollectionsKt.joinToString$default((Iterable)actual, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, 4, null);
    }

    private static final List<SteppingTestLoggedData> compressSequencesWithoutLineNumber(List<SteppingTestLoggedData> loggedItems) {
        if (loggedItems.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterator<SteppingTestLoggedData> logIterator = loggedItems.iterator();
        SteppingTestLoggedData currentItem = logIterator.next();
        Object object = new SteppingTestLoggedData[]{currentItem};
        List result = CollectionsKt.mutableListOf((Object[])object);
        object = logIterator;
        while (object.hasNext()) {
            SteppingTestLoggedData logItem = (SteppingTestLoggedData)object.next();
            if (currentItem.getLine() == -1 && Intrinsics.areEqual((Object)currentItem.getExpectation(), (Object)logItem.getExpectation())) continue;
            result.add(logItem);
            currentItem = logItem;
        }
        return result;
    }

    @NotNull
    public static final String formatAsSteppingTestExpectation(@NotNull String sourceName, int lineNumber, @NotNull String functionName, boolean isSynthetic, @Nullable List<LocalVariableRecord> visibleVars) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        StringBuilder $this$formatAsSteppingTestExpectation_u24lambda_u247 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$formatAsSteppingTestExpectation_u24lambda_u247.append(sourceName);
        $this$formatAsSteppingTestExpectation_u24lambda_u247.append(':');
        $this$formatAsSteppingTestExpectation_u24lambda_u247.append(lineNumber);
        $this$formatAsSteppingTestExpectation_u24lambda_u247.append(' ');
        $this$formatAsSteppingTestExpectation_u24lambda_u247.append(functionName);
        if (isSynthetic) {
            $this$formatAsSteppingTestExpectation_u24lambda_u247.append(" (synthetic)");
        }
        if (visibleVars != null) {
            $this$formatAsSteppingTestExpectation_u24lambda_u247.append(": ");
            CollectionsKt.joinTo$default((Iterable)visibleVars, (Appendable)$this$formatAsSteppingTestExpectation_u24lambda_u247, null, null, null, (int)0, null, null, (int)126, null);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    public static /* synthetic */ String formatAsSteppingTestExpectation$default(String string, int n, String string2, boolean bl, List list, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            list = null;
        }
        return SteppingTestUtilsKt.formatAsSteppingTestExpectation(string, n, string2, bl, list);
    }
}

