/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.ir;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.FirParser;
import org.jetbrains.kotlin.test.backend.handlers.AbstractIrHandler;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.backend.ir.IrDiagnosticsHandler;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirDiagnosticsHandlerKt;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FullDiagnosticsRenderer;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DiagnosticsService;
import org.jetbrains.kotlin.test.services.DiagnosticsServiceKt;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/test/backend/ir/IrDiagnosticsHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/AbstractIrHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "globalMetadataInfoHandler", "Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "getGlobalMetadataInfoHandler", "()Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "diagnosticsService", "Lorg/jetbrains/kotlin/test/services/DiagnosticsService;", "getDiagnosticsService", "()Lorg/jetbrains/kotlin/test/services/DiagnosticsService;", "additionalServices", "", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "()Ljava/util/List;", "fullDiagnosticsRenderer", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FullDiagnosticsRenderer;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "processAfterAllModules", "someAssertionWasFailed", "", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nIrDiagnosticsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrDiagnosticsHandler.kt\norg/jetbrains/kotlin/test/backend/ir/IrDiagnosticsHandler\n+ 2 TestServices.kt\norg/jetbrains/kotlin/test/services/TestServicesKt\n*L\n1#1,53:1\n25#2:54\n*S KotlinDebug\n*F\n+ 1 IrDiagnosticsHandler.kt\norg/jetbrains/kotlin/test/backend/ir/IrDiagnosticsHandler\n*L\n26#1:54\n*E\n"})
public final class IrDiagnosticsHandler
extends AbstractIrHandler {
    @NotNull
    private final FullDiagnosticsRenderer fullDiagnosticsRenderer;

    public IrDiagnosticsHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, null, false, false, 14, null);
        this.fullDiagnosticsRenderer = new FullDiagnosticsRenderer(DiagnosticsDirectives.INSTANCE.getRENDER_IR_DIAGNOSTICS_FULL_TEXT());
    }

    private final GlobalMetadataInfoHandler getGlobalMetadataInfoHandler() {
        return GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler(this.getTestServices());
    }

    private final DiagnosticsService getDiagnosticsService() {
        return DiagnosticsServiceKt.getDiagnosticsService(this.getTestServices());
    }

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        Function1 serviceConstructor$iv = additionalServices.1.INSTANCE;
        boolean $i$f$service = false;
        return CollectionsKt.listOf((Object)new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(DiagnosticsService.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv));
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull IrBackendInput info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Map diagnosticsByFilePath = info.getDiagnosticReporter().getDiagnosticsByFilePath();
        for (TestModule currentModule : TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules()) {
            boolean lightTreeComparingModeEnabled = currentModule.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getCOMPARE_WITH_LIGHT_TREE());
            boolean lightTreeEnabled = DirectiveKt.singleOrZeroValue(currentModule.getDirectives(), FirDiagnosticsDirectives.INSTANCE.getFIR_PARSER()) == FirParser.LightTree;
            for (TestFile file : currentModule.getFiles()) {
                List diagnostics = (List)diagnosticsByFilePath.get('/' + file.getRelativePath());
                if (diagnostics == null || !(!((Collection)diagnostics).isEmpty())) continue;
                List diagnosticsMetadataInfos = FirDiagnosticsHandlerKt.diagnosticCodeMetaInfos$default(diagnostics, module, file, this.getDiagnosticsService(), this.getGlobalMetadataInfoHandler(), lightTreeEnabled, lightTreeComparingModeEnabled, false, 64, null);
                this.getGlobalMetadataInfoHandler().addMetadataInfosForFile(file, diagnosticsMetadataInfos);
                this.fullDiagnosticsRenderer.storeFullDiagnosticRender(module, diagnostics, file);
            }
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        this.fullDiagnosticsRenderer.assertCollectedDiagnostics(this.getTestServices(), ".fir.ir.diag.txt");
    }
}

