/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.abicmp.HtmlKt;
import org.jetbrains.kotlin.abicmp.defects.Location;
import org.jetbrains.kotlin.abicmp.reports.ClassReport;
import org.jetbrains.kotlin.abicmp.reports.ComparisonReport;
import org.jetbrains.kotlin.abicmp.reports.ComparisonReportKt;
import org.jetbrains.kotlin.abicmp.reports.DefectReport;
import org.jetbrains.kotlin.abicmp.reports.PlainTextDumpUtilsKt;
import org.jetbrains.kotlin.abicmp.reports.TextTreeBuilderContext;
import org.jetbrains.kotlin.abicmp.tasks.CheckerConfiguration;
import org.jetbrains.kotlin.abicmp.tasks.CheckerConfigurationBuilder;
import org.jetbrains.kotlin.abicmp.tasks.ClassTask;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.test.backend.handlers.JvmAbiConsistencyHandler;
import org.jetbrains.kotlin.test.backend.ir.AbiCheckerSuppressor;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.model.AnalysisHandler;
import org.jetbrains.kotlin.test.model.ArtifactKinds;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.JUnit5Assertions;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002!\"B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/JvmAbiConsistencyHandler;", "Lorg/jetbrains/kotlin/test/model/AnalysisHandler;", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$JvmFromK1AndK2;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "artifactKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "getArtifactKind", "()Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "testReport", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmAbiConsistencyHandler$TestReport;", "processAfterAllModules", "", "someAssertionWasFailed", "", "fileNotFoundMessageBuilder", "Lkotlin/Function1;", "Ljava/io/File;", "", "isTeamCityVersion", "isDiffExplained", "fail", "message", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "parseClassNode", "Lorg/jetbrains/org/objectweb/asm/tree/ClassNode;", "byteArray", "", "ModuleReport", "TestReport", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nJvmAbiConsistencyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmAbiConsistencyHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/JvmAbiConsistencyHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CheckerConfiguration.kt\norg/jetbrains/kotlin/abicmp/tasks/CheckerConfigurationKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1177#2,2:194\n1251#2,4:196\n1177#2,2:200\n1251#2,4:202\n1853#2:206\n1854#2:210\n198#3,3:207\n1#4:211\n*S KotlinDebug\n*F\n+ 1 JvmAbiConsistencyHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/JvmAbiConsistencyHandler\n*L\n165#1:194,2\n165#1:196,4\n166#1:200,2\n166#1:202,4\n172#1:206\n172#1:210\n176#1:207,3\n*E\n"})
public final class JvmAbiConsistencyHandler
extends AnalysisHandler<BinaryArtifacts.JvmFromK1AndK2> {
    @NotNull
    private final TestReport testReport;

    public JvmAbiConsistencyHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, true, true);
        this.testReport = new TestReport();
    }

    @Override
    @NotNull
    public TestArtifactKind<BinaryArtifacts.JvmFromK1AndK2> getArtifactKind() {
        return ArtifactKinds.JvmFromK1AndK2.INSTANCE;
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        File txtDiffPath = FileUtilsKt.withExtension((File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles()), ".jvm_abi.txt");
        boolean isDifferenceExplained = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(CodegenTestDirectives.INSTANCE.getJVM_ABI_K1_K2_DIFF());
        if (!this.testReport.isEmpty()) {
            JUnit5Assertions.INSTANCE.assertEqualsToFile(txtDiffPath, this.testReport.dumpAsPlainText(), (Function1<? super String, String>)((Function1)processAfterAllModules.1.INSTANCE), (Function0<String>)((Function0)processAfterAllModules.2.INSTANCE), this.fileNotFoundMessageBuilder(true, isDifferenceExplained), this.fileNotFoundMessageBuilder(false, isDifferenceExplained));
            if (!isDifferenceExplained) {
                this.fail("K1/K2 JVM ABI difference obtained. Add " + CodegenTestDirectives.INSTANCE.getJVM_ABI_K1_K2_DIFF().getName() + " directive with an explanation");
            }
        } else {
            if (isDifferenceExplained && txtDiffPath.exists()) {
                this.fail("No K1/K2 JVM ABI difference found. Remove " + CodegenTestDirectives.INSTANCE.getJVM_ABI_K1_K2_DIFF().getName() + " directive and " + txtDiffPath);
            }
            if (isDifferenceExplained) {
                this.fail("No K1/K2 JVM ABI difference found. Remove " + CodegenTestDirectives.INSTANCE.getJVM_ABI_K1_K2_DIFF().getName() + " directive");
            }
            if (txtDiffPath.exists()) {
                this.fail("No K1/K2 JVM ABI difference found. Remove " + txtDiffPath);
            }
        }
    }

    private final Function1<File, String> fileNotFoundMessageBuilder(boolean isTeamCityVersion, boolean isDiffExplained) {
        return (Function1)new Function1<File, String>(isTeamCityVersion, isDiffExplained){
            final /* synthetic */ boolean $isTeamCityVersion;
            final /* synthetic */ boolean $isDiffExplained;
            {
                this.$isTeamCityVersion = $isTeamCityVersion;
                this.$isDiffExplained = $isDiffExplained;
                super(1);
            }

            public final String invoke(File it) {
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                boolean bl = this.$isTeamCityVersion;
                boolean bl2 = this.$isDiffExplained;
                StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                StringBuilder stringBuilder2 = bl ? $this$invoke_u24lambda_u240.append("Expected data file did not exist `" + it + '`') : $this$invoke_u24lambda_u240.append("Expected data file did not exist. Generating: " + it);
                if (!bl2) {
                    $this$invoke_u24lambda_u240.append("\n");
                    $this$invoke_u24lambda_u240.append("Also add " + CodegenTestDirectives.INSTANCE.getJVM_ABI_K1_K2_DIFF().getName() + " directive with an explanation");
                }
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
        };
    }

    private final void fail(String message) {
        JUnit5Assertions.INSTANCE.fail((Function0<String>)((Function0)new Function0<String>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(0);
            }

            public final String invoke() {
                return this.$message;
            }
        }));
        throw null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.JvmFromK1AndK2 info) {
        block8: {
            List nonEmptyClassReports;
            Sets.SetView missingInK1;
            Sets.SetView missingInK2;
            block7: {
                void $this$associateTo$iv$iv;
                Object it;
                void $this$associateTo$iv$iv2;
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                if (AbiCheckerSuppressor.Companion.ignoredByBackendOrInliner(this.getTestServices())) {
                    return;
                }
                Iterable $this$associate$iv = ClassFileUtilsKt.getClassFiles((ClassFileFactory)info.getFromK1().getClassFileFactory());
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Object destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv2) {
                    Map map = destination$iv$iv;
                    it = (OutputFile)element$iv$iv;
                    boolean bl = false;
                    it = TuplesKt.to((Object)it.getRelativePath(), (Object)it.asByteArray());
                    map.put(it.getFirst(), it.getSecond());
                }
                Map classesFromK1 = destination$iv$iv;
                Iterable $this$associate$iv2 = ClassFileUtilsKt.getClassFiles((ClassFileFactory)info.getFromK2().getClassFileFactory());
                boolean $i$f$associate2 = false;
                int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
                destination$iv$iv = $this$associate$iv2;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
                boolean $i$f$associateTo2 = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    it = destination$iv$iv2;
                    OutputFile it2 = (OutputFile)element$iv$iv;
                    boolean bl = false;
                    it2 = TuplesKt.to((Object)it2.getRelativePath(), (Object)it2.asByteArray());
                    it.put(it2.getFirst(), it2.getSecond());
                }
                Map classesFromK2 = destination$iv$iv2;
                missingInK2 = Sets.difference(classesFromK1.keySet(), classesFromK2.keySet());
                missingInK1 = Sets.difference(classesFromK2.keySet(), classesFromK1.keySet());
                Sets.SetView commonClasses = Sets.intersection(classesFromK1.keySet(), classesFromK2.keySet());
                nonEmptyClassReports = new ArrayList();
                Intrinsics.checkNotNull((Object)commonClasses);
                Iterable $this$forEach$iv = (Iterable)commonClasses;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CheckerConfigurationBuilder builder$iv;
                    String classInternalName = (String)element$iv;
                    boolean bl = false;
                    Object v = classesFromK1.get(classInternalName);
                    Intrinsics.checkNotNull(v);
                    ClassNode k1ClassNode = this.parseClassNode((byte[])v);
                    Object v2 = classesFromK2.get(classInternalName);
                    Intrinsics.checkNotNull(v2);
                    ClassNode k2ClassNode = this.parseClassNode((byte[])v2);
                    Intrinsics.checkNotNull((Object)classInternalName);
                    ClassReport classReport = new ClassReport(new Location.Class("", classInternalName), classInternalName, "K1", "K2", new DefectReport());
                    boolean $i$f$checkerConfiguration = false;
                    CheckerConfigurationBuilder $this$processModule_u24lambda_u243_u24lambda_u242 = builder$iv = new CheckerConfigurationBuilder();
                    boolean bl2 = false;
                    $this$processModule_u24lambda_u243_u24lambda_u242.disable("class.metadata.property.hasConstant");
                    ClassReport classReport2 = classReport;
                    ClassNode classNode = k2ClassNode;
                    ClassNode classNode2 = k1ClassNode;
                    CheckerConfiguration checkerConfiguration = builder$iv.build();
                    new ClassTask(checkerConfiguration, classNode2, classNode, classReport2).run();
                    if (!ComparisonReportKt.isNotEmpty((ComparisonReport)((ComparisonReport)classReport))) continue;
                    nonEmptyClassReports.add(classReport);
                }
                if (!((Collection)nonEmptyClassReports).isEmpty()) break block7;
                Intrinsics.checkNotNull((Object)missingInK1);
                if (!((Collection)missingInK1).isEmpty()) break block7;
                Intrinsics.checkNotNull((Object)missingInK2);
                if (!(!((Collection)missingInK2).isEmpty())) break block8;
            }
            String string = module.getName();
            Intrinsics.checkNotNull((Object)missingInK1);
            Set set = (Set)missingInK1;
            Intrinsics.checkNotNull((Object)missingInK2);
            this.testReport.addModuleReport(string, new ModuleReport(set, (Set)missingInK2, nonEmptyClassReports));
        }
    }

    private final ClassNode parseClassNode(byte[] byteArray) {
        ClassNode classNode;
        ClassNode it = classNode = new ClassNode();
        boolean bl = false;
        new ClassReader((InputStream)new ByteArrayInputStream(byteArray)).accept((ClassVisitor)it, 1);
        return classNode;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/JvmAbiConsistencyHandler$ModuleReport;", "", "missingInK1", "", "", "missingInK2", "nonEmptyClassReports", "", "Lorg/jetbrains/kotlin/abicmp/reports/ClassReport;", "<init>", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/List;)V", "getMissingInK1", "()Ljava/util/Set;", "getMissingInK2", "getNonEmptyClassReports", "()Ljava/util/List;", "tests-common-new_test"})
    private static final class ModuleReport {
        @NotNull
        private final Set<String> missingInK1;
        @NotNull
        private final Set<String> missingInK2;
        @NotNull
        private final List<ClassReport> nonEmptyClassReports;

        public ModuleReport(@NotNull Set<String> missingInK1, @NotNull Set<String> missingInK2, @NotNull List<ClassReport> nonEmptyClassReports) {
            Intrinsics.checkNotNullParameter(missingInK1, (String)"missingInK1");
            Intrinsics.checkNotNullParameter(missingInK2, (String)"missingInK2");
            Intrinsics.checkNotNullParameter(nonEmptyClassReports, (String)"nonEmptyClassReports");
            this.missingInK1 = missingInK1;
            this.missingInK2 = missingInK2;
            this.nonEmptyClassReports = nonEmptyClassReports;
        }

        @NotNull
        public final Set<String> getMissingInK1() {
            return this.missingInK1;
        }

        @NotNull
        public final Set<String> getMissingInK2() {
            return this.missingInK2;
        }

        @NotNull
        public final List<ClassReport> getNonEmptyClassReports() {
            return this.nonEmptyClassReports;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u0006J\u0006\u0010\u000f\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/JvmAbiConsistencyHandler$TestReport;", "", "<init>", "()V", "modulesWithNonEmptyReports", "", "", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmAbiConsistencyHandler$ModuleReport;", "addModuleReport", "", "moduleName", "report", "isEmpty", "", "dumpAsPlainText", "dumpAsHtml", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nJvmAbiConsistencyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmAbiConsistencyHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/JvmAbiConsistencyHandler$TestReport\n+ 2 html.kt\norg/jetbrains/kotlin/abicmp/HtmlKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n28#2,2:194\n28#2,4:196\n28#2,2:200\n30#2,2:206\n30#2,2:208\n215#3:202\n216#3:205\n1853#4,2:203\n*S KotlinDebug\n*F\n+ 1 JvmAbiConsistencyHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/JvmAbiConsistencyHandler$TestReport\n*L\n90#1:194,2\n91#1:196,4\n94#1:200,2\n94#1:206,2\n90#1:208,2\n95#1:202\n95#1:205\n99#1:203,2\n*E\n"})
    private static final class TestReport {
        @NotNull
        private final Map<String, ModuleReport> modulesWithNonEmptyReports = new LinkedHashMap();

        public final void addModuleReport(@NotNull String moduleName, @NotNull ModuleReport report) {
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)report, (String)"report");
            this.modulesWithNonEmptyReports.put(moduleName, report);
        }

        public final boolean isEmpty() {
            return this.modulesWithNonEmptyReports.isEmpty();
        }

        @NotNull
        public final String dumpAsPlainText() {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(outputStream);
            PlainTextDumpUtilsKt.dumpTree((PrintWriter)out, (Function1)((Function1)new Function1<TextTreeBuilderContext, Unit>(this){
                final /* synthetic */ TestReport this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(TextTreeBuilderContext $this$dumpTree) {
                    Intrinsics.checkNotNullParameter((Object)$this$dumpTree, (String)"$this$dumpTree");
                    Map $this$forEach$iv = TestReport.access$getModulesWithNonEmptyReports$p(this.this$0);
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> entry = element$iv = iterator.next();
                        boolean bl = false;
                        String module = (String)entry.getKey();
                        ModuleReport report = (ModuleReport)entry.getValue();
                        PlainTextDumpUtilsKt.node((TextTreeBuilderContext)$this$dumpTree, (String)("MODULE " + module), (Function1)((Function1)new Function1<TextTreeBuilderContext, Unit>(report){
                            final /* synthetic */ ModuleReport $report;
                            {
                                this.$report = $report;
                                super(1);
                            }

                            public final void invoke(TextTreeBuilderContext $this$node) {
                                Intrinsics.checkNotNullParameter((Object)$this$node, (String)"$this$node");
                                TestReport.access$dumpAsPlainText$reportMissing($this$node, "K1", this.$report.getMissingInK1());
                                TestReport.access$dumpAsPlainText$reportMissing($this$node, "K2", this.$report.getMissingInK2());
                                Iterable $this$forEach$iv = this.$report.getNonEmptyClassReports();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    ClassReport classReport = (ClassReport)element$iv;
                                    boolean bl = false;
                                    ClassReport $this$invoke_u24lambda_u241_u24lambda_u240 = classReport;
                                    boolean bl2 = false;
                                    $this$invoke_u24lambda_u241_u24lambda_u240.appendClassReport($this$node);
                                }
                            }
                        }));
                    }
                }
            }));
            String string = outputStream.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final String dumpAsHtml() {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Closeable closeable = new PrintWriter(outputStream, true);
            Throwable throwable = null;
            try {
                PrintWriter $this$tag$iv;
                void $this$tag$iv2;
                PrintWriter out = (PrintWriter)closeable;
                boolean bl = false;
                PrintWriter printWriter = out;
                String tagName$iv = "html";
                boolean $i$f$tag = false;
                $this$tag$iv2.print('<' + tagName$iv + '>');
                boolean bl2 = false;
                PrintWriter printWriter2 = out;
                String tagName$iv2 = "head";
                boolean $i$f$tag2 = false;
                $this$tag$iv.print('<' + tagName$iv2 + '>');
                boolean bl3 = false;
                HtmlKt.tag((PrintWriter)out, (String)"style", (String)"\ntable, th, td {\n  border: 1px solid black;\n  border-collapse: collapse;\n  padding: 2px;\n}\nth {\n  background: #B0B0B0;\n}\ntd {\n  background: #EFEFB0;\n  vertical-align: top;\n}\ntd.location {\n  background: #E0E0E0;\n  vertical-align: top;\n}\nhr {\n  border: 1px solid black;\n  border-collapse: collapse;\n}\n");
                $this$tag$iv.println("</" + tagName$iv2 + '>');
                $this$tag$iv = out;
                tagName$iv2 = "body";
                $i$f$tag2 = false;
                $this$tag$iv.print('<' + tagName$iv2 + '>');
                boolean bl4 = false;
                Map<String, ModuleReport> $this$forEach$iv = this.modulesWithNonEmptyReports;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, ModuleReport>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ModuleReport> element$iv;
                    Map.Entry<String, ModuleReport> entry = element$iv = iterator.next();
                    boolean bl5 = false;
                    String module = entry.getKey();
                    ModuleReport report = entry.getValue();
                    HtmlKt.tag((PrintWriter)out, (String)"h2", (String)("Module: " + module));
                    TestReport.dumpAsHtml$reportMissing$0(out, "K1", report.getMissingInK1());
                    TestReport.dumpAsHtml$reportMissing$0(out, "K2", report.getMissingInK2());
                    Iterable $this$forEach$iv2 = report.getNonEmptyClassReports();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        ClassReport it = (ClassReport)element$iv2;
                        boolean bl6 = false;
                        it.writeAsHtml(out);
                    }
                }
                $this$tag$iv.println("</" + tagName$iv2 + '>');
                $this$tag$iv2.println("</" + tagName$iv + '>');
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String string = outputStream.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private static final void dumpAsPlainText$reportMissing(TextTreeBuilderContext $this$dumpAsPlainText_u24reportMissing, String frontendName, Set<String> missing) {
            if (missing.isEmpty()) {
                return;
            }
            PlainTextDumpUtilsKt.node((TextTreeBuilderContext)$this$dumpAsPlainText_u24reportMissing, (String)("Missing in " + frontendName), (Function1)((Function1)new Function1<TextTreeBuilderContext, Unit>(missing){
                final /* synthetic */ Set<String> $missing;
                {
                    this.$missing = $missing;
                    super(1);
                }

                public final void invoke(TextTreeBuilderContext $this$node) {
                    Intrinsics.checkNotNullParameter((Object)$this$node, (String)"$this$node");
                    PlainTextDumpUtilsKt.node$default((TextTreeBuilderContext)$this$node, (String)CollectionsKt.joinToString$default((Iterable)this.$missing, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
                }
            }));
        }

        private static final void dumpAsHtml$reportMissing$0(PrintWriter $this$dumpAsHtml_u24reportMissing_u240, String frontendName, Set<String> missing) {
            if (missing.isEmpty()) {
                return;
            }
            $this$dumpAsHtml_u24reportMissing_u240.println("Missing in " + frontendName + ':');
            HtmlKt.tag((PrintWriter)$this$dumpAsHtml_u24reportMissing_u240, (String)"br");
            $this$dumpAsHtml_u24reportMissing_u240.println(CollectionsKt.joinToString$default((Iterable)missing, null, null, null, (int)0, null, null, (int)63, null));
            HtmlKt.tag((PrintWriter)$this$dumpAsHtml_u24reportMissing_u240, (String)"br");
            HtmlKt.tag((PrintWriter)$this$dumpAsHtml_u24reportMissing_u240, (String)"br");
        }

        public static final /* synthetic */ Map access$getModulesWithNonEmptyReports$p(TestReport $this) {
            return $this.modulesWithNonEmptyReports;
        }

        public static final /* synthetic */ void access$dumpAsPlainText$reportMissing(TextTreeBuilderContext $receiver, String frontendName, Set missing) {
            TestReport.dumpAsPlainText$reportMissing($receiver, frontendName, missing);
        }
    }
}

