/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.CodegenTestFiles;
import org.jetbrains.kotlin.codegen.GenerationUtils;
import org.jetbrains.kotlin.codegen.forTestCompile.ForTestCompileRuntime;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.JvmCompilationUtils;
import org.jetbrains.kotlin.test.KtAssert;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.StringsKt;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.jetbrains.org.objectweb.asm.util.Printer;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class CodegenTestUtil {
    private static final boolean IS_SOURCE_6_STILL_SUPPORTED = Arrays.asList("1.6", "1.7", "1.8", "9", "10", "11").contains(System.getProperty("java.specification.version"));
    private static final String JAVA_COMPILATION_TARGET = System.getProperty("kotlin.test.java.compilation.target");

    private CodegenTestUtil() {
    }

    @NotNull
    public static ClassFileFactory generateFiles(@NotNull KotlinCoreEnvironment environment, @NotNull CodegenTestFiles files) {
        if (environment == null) {
            CodegenTestUtil.$$$reportNull$$$0(0);
        }
        if (files == null) {
            CodegenTestUtil.$$$reportNull$$$0(1);
        }
        ClassFileFactory classFileFactory = GenerationUtils.compileFiles(files.getPsiFiles(), environment).getFactory();
        if (classFileFactory == null) {
            CodegenTestUtil.$$$reportNull$$$0(2);
        }
        return classFileFactory;
    }

    public static void assertThrows(@NotNull Method foo, @NotNull Class<? extends Throwable> exceptionClass, @Nullable Object instance, Object ... args) throws IllegalAccessException {
        if (foo == null) {
            CodegenTestUtil.$$$reportNull$$$0(3);
        }
        if (exceptionClass == null) {
            CodegenTestUtil.$$$reportNull$$$0(4);
        }
        if (args == null) {
            CodegenTestUtil.$$$reportNull$$$0(5);
        }
        boolean caught = false;
        try {
            foo.invoke(instance, args);
        }
        catch (InvocationTargetException ex) {
            caught = exceptionClass.isInstance(ex.getTargetException());
        }
        KtAssert.assertTrue(String.format("Exception of class %s must be thrown", exceptionClass.getName()), caught);
    }

    @NotNull
    public static Method findDeclaredMethodByName(@NotNull Class<?> aClass, @NotNull String name2) {
        Method result;
        if (aClass == null) {
            CodegenTestUtil.$$$reportNull$$$0(6);
        }
        if (name2 == null) {
            CodegenTestUtil.$$$reportNull$$$0(7);
        }
        if ((result = CodegenTestUtil.findDeclaredMethodByNameOrNull(aClass, name2)) == null) {
            throw new AssertionError((Object)("Method " + name2 + " is not found in " + aClass));
        }
        Method method = result;
        if (method == null) {
            CodegenTestUtil.$$$reportNull$$$0(8);
        }
        return method;
    }

    public static Method findDeclaredMethodByNameOrNull(@NotNull Class<?> aClass, @NotNull String name2) {
        if (aClass == null) {
            CodegenTestUtil.$$$reportNull$$$0(9);
        }
        if (name2 == null) {
            CodegenTestUtil.$$$reportNull$$$0(10);
        }
        for (Method method : aClass.getDeclaredMethods()) {
            if (!method.getName().equals(name2)) continue;
            return method;
        }
        return null;
    }

    @NotNull
    public static File compileJava(@NotNull List<String> fileNames, @NotNull List<String> additionalClasspath, @NotNull List<String> additionalOptions, @NotNull Assertions assertions) {
        File file;
        if (fileNames == null) {
            CodegenTestUtil.$$$reportNull$$$0(11);
        }
        if (additionalClasspath == null) {
            CodegenTestUtil.$$$reportNull$$$0(12);
        }
        if (additionalOptions == null) {
            CodegenTestUtil.$$$reportNull$$$0(13);
        }
        if (assertions == null) {
            CodegenTestUtil.$$$reportNull$$$0(14);
        }
        try {
            File directory = KtTestUtil.tmpDir("java-classes");
            CodegenTestUtil.compileJava(fileNames, additionalClasspath, additionalOptions, directory, assertions);
            file = directory;
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
        if (file == null) {
            CodegenTestUtil.$$$reportNull$$$0(15);
        }
        return file;
    }

    public static void compileJava(@NotNull List<String> fileNames, @NotNull List<String> additionalClasspath, @NotNull List<String> additionalOptions, @NotNull File outDirectory, @NotNull Assertions assertions) {
        if (fileNames == null) {
            CodegenTestUtil.$$$reportNull$$$0(16);
        }
        if (additionalClasspath == null) {
            CodegenTestUtil.$$$reportNull$$$0(17);
        }
        if (additionalOptions == null) {
            CodegenTestUtil.$$$reportNull$$$0(18);
        }
        if (outDirectory == null) {
            CodegenTestUtil.$$$reportNull$$$0(19);
        }
        if (assertions == null) {
            CodegenTestUtil.$$$reportNull$$$0(20);
        }
        try {
            List<String> options = CodegenTestUtil.prepareJavacOptions(additionalClasspath, additionalOptions, outDirectory);
            JvmCompilationUtils.compileJavaFiles(CollectionsKt.map(fileNames, File::new), options, assertions);
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    @NotNull
    public static List<String> prepareJavacOptions(@NotNull List<String> additionalClasspath, @NotNull List<String> additionalOptions, @NotNull File outDirectory) {
        if (additionalClasspath == null) {
            CodegenTestUtil.$$$reportNull$$$0(21);
        }
        if (additionalOptions == null) {
            CodegenTestUtil.$$$reportNull$$$0(22);
        }
        if (outDirectory == null) {
            CodegenTestUtil.$$$reportNull$$$0(23);
        }
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(ForTestCompileRuntime.runtimeJarForTests().getPath());
        classpath.add(ForTestCompileRuntime.reflectJarForTests().getPath());
        classpath.add(KtTestUtil.getAnnotationsJar().getPath());
        classpath.addAll(additionalClasspath);
        ArrayList<String> options = new ArrayList<String>(Arrays.asList("-classpath", StringsKt.join(classpath, (String)File.pathSeparator), "-d", outDirectory.getPath()));
        options.addAll(additionalOptions);
        ArrayList<String> arrayList = options;
        if (arrayList == null) {
            CodegenTestUtil.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    public static Method findTheOnlyMethod(@NotNull Class<?> aClass) {
        if (aClass == null) {
            CodegenTestUtil.$$$reportNull$$$0(25);
        }
        Method r = null;
        for (Method method : aClass.getMethods()) {
            if (method.getDeclaringClass().equals(Object.class)) continue;
            if (r != null) {
                throw new AssertionError((Object)("More than one public method in class " + aClass));
            }
            r = method;
        }
        if (r == null) {
            throw new AssertionError((Object)("No public methods in class " + aClass));
        }
        Method method = r;
        if (method == null) {
            CodegenTestUtil.$$$reportNull$$$0(26);
        }
        return method;
    }

    @Nullable
    public static Object getAnnotationAttribute(@NotNull Object annotation, @NotNull String name2) {
        if (annotation == null) {
            CodegenTestUtil.$$$reportNull$$$0(27);
        }
        if (name2 == null) {
            CodegenTestUtil.$$$reportNull$$$0(28);
        }
        try {
            return annotation.getClass().getMethod(name2, new Class[0]).invoke(annotation, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    @NotNull
    public static List<String> findJavaSourcesInDirectory(@NotNull File directory) {
        if (directory == null) {
            CodegenTestUtil.$$$reportNull$$$0(29);
        }
        ArrayList<String> javaFilePaths = new ArrayList<String>(1);
        FileUtil.processFilesRecursively((File)directory, file -> {
            if (file.isFile() && FilesKt.getExtension((File)file).equals("java")) {
                javaFilePaths.add(file.getPath());
            }
            return true;
        });
        ArrayList<String> arrayList = javaFilePaths;
        if (arrayList == null) {
            CodegenTestUtil.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @Nullable
    public static String computeJavaTarget(@NotNull List<String> javacOptions, @Nullable JvmTarget kotlinTarget) {
        if (javacOptions == null) {
            CodegenTestUtil.$$$reportNull$$$0(31);
        }
        if (JAVA_COMPILATION_TARGET != null && !javacOptions.contains("-target")) {
            return JAVA_COMPILATION_TARGET;
        }
        if (kotlinTarget != null) {
            return kotlinTarget.getDescription();
        }
        if (IS_SOURCE_6_STILL_SUPPORTED) {
            return "1.6";
        }
        return null;
    }

    public static boolean verifyAllFilesWithAsm(ClassFileFactory factory, ClassLoader loader, boolean reportProblems) {
        boolean noErrors = true;
        for (OutputFile file : ClassFileUtilsKt.getClassFiles((ClassFileFactory)factory)) {
            noErrors &= CodegenTestUtil.verifyWithAsm(file, loader, reportProblems);
        }
        return noErrors;
    }

    private static boolean verifyWithAsm(@NotNull OutputFile file, ClassLoader loader, boolean reportProblems) {
        if (file == null) {
            CodegenTestUtil.$$$reportNull$$$0(32);
        }
        ClassNode classNode = new ClassNode();
        new ClassReader(file.asByteArray()).accept((ClassVisitor)classNode, 0);
        SimpleVerifier verifier = new SimpleVerifier();
        verifier.setClassLoader(loader);
        Analyzer analyzer = new Analyzer((Interpreter)verifier);
        boolean noErrors = true;
        for (MethodNode method : classNode.methods) {
            try {
                analyzer.analyze(classNode.name, method);
            }
            catch (Throwable e) {
                if (reportProblems) {
                    try {
                        System.err.println(file.asText());
                        System.err.println(classNode.name + "::" + method.name + method.desc);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (e instanceof AnalyzerException) {
                        TraceMethodVisitor tmv = new TraceMethodVisitor((Printer)new Textifier());
                        ((AnalyzerException)e).node.accept((MethodVisitor)tmv);
                        PrintWriter pw = new PrintWriter(System.err);
                        tmv.p.print(pw);
                        pw.flush();
                    }
                    e.printStackTrace();
                }
                noErrors = false;
            }
        }
        return noErrors;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 24: 
            case 26: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 24: 
            case 26: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 24: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/CodegenTestUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: 
            case 9: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 7: 
            case 10: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 12: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalClasspath";
                break;
            }
            case 13: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalOptions";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertions";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDirectory";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javacOptions";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/CodegenTestUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeclaredMethodByName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "compileJava";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareJavacOptions";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findTheOnlyMethod";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaSourcesInDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateFiles";
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 24: 
            case 26: 
            case 30: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertThrows";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredMethodByName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredMethodByNameOrNull";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "compileJava";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "prepareJavacOptions";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findTheOnlyMethod";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationAttribute";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findJavaSourcesInDirectory";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "computeJavaTarget";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "verifyWithAsm";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 24: 
            case 26: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

