/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.runners.AbstractJvmAbiConsistencyTest;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

public class JvmAbiConsistencyTestRestGenerated
extends AbstractJvmAbiConsistencyTest {

    @Nested
    @TestMetadata(value="compiler/testData/codegen/script")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Script {
        @Test
        @TestMetadata(value="adder.kts")
        public void testAdder() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/adder.kts");
        }

        @Test
        public void testAllFilesPresentInScript() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/script"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="classLiteralInsideFunction.kts")
        public void testClassLiteralInsideFunction() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/classLiteralInsideFunction.kts");
        }

        @Test
        @TestMetadata(value="destructuringDeclaration.kts")
        public void testDestructuringDeclaration() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/destructuringDeclaration.kts");
        }

        @Test
        @TestMetadata(value="destructuringDeclarationUnderscore.kts")
        public void testDestructuringDeclarationUnderscore() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/destructuringDeclarationUnderscore.kts");
        }

        @Test
        @TestMetadata(value="empty.kts")
        public void testEmpty() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/empty.kts");
        }

        @Test
        @TestMetadata(value="helloWorld.kts")
        public void testHelloWorld() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/helloWorld.kts");
        }

        @Test
        @TestMetadata(value="inline.kts")
        public void testInline() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/inline.kts");
        }

        @Test
        @TestMetadata(value="innerClass.kts")
        public void testInnerClass() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/innerClass.kts");
        }

        @Test
        @TestMetadata(value="kt20707.kts")
        public void testKt20707() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/kt20707.kts");
        }

        @Test
        @TestMetadata(value="kt22029.kts")
        public void testKt22029() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/kt22029.kts");
        }

        @Test
        @TestMetadata(value="kt48025.kts")
        public void testKt48025() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/kt48025.kts");
        }

        @Test
        @TestMetadata(value="localDelegatedProperty.kts")
        public void testLocalDelegatedProperty() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/localDelegatedProperty.kts");
        }

        @Test
        @TestMetadata(value="localDelegatedPropertyInLambda.kts")
        public void testLocalDelegatedPropertyInLambda() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/localDelegatedPropertyInLambda.kts");
        }

        @Test
        @TestMetadata(value="localDelegatedPropertyNoExplicitType.kts")
        public void testLocalDelegatedPropertyNoExplicitType() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/localDelegatedPropertyNoExplicitType.kts");
        }

        @Test
        @TestMetadata(value="localFunction.kts")
        public void testLocalFunction() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/localFunction.kts");
        }

        @Test
        @TestMetadata(value="outerCapture.kts")
        public void testOuterCapture() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/outerCapture.kts");
        }

        @Test
        @TestMetadata(value="parameter.kts")
        public void testParameter() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/parameter.kts");
        }

        @Test
        @TestMetadata(value="parameterArray.kts")
        public void testParameterArray() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/parameterArray.kts");
        }

        @Test
        @TestMetadata(value="parameterClosure.kts")
        public void testParameterClosure() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/parameterClosure.kts");
        }

        @Test
        @TestMetadata(value="parameterLong.kts")
        public void testParameterLong() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/parameterLong.kts");
        }

        @Test
        @TestMetadata(value="secondLevelFunction.kts")
        public void testSecondLevelFunction() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/secondLevelFunction.kts");
        }

        @Test
        @TestMetadata(value="secondLevelFunctionClosure.kts")
        public void testSecondLevelFunctionClosure() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/secondLevelFunctionClosure.kts");
        }

        @Test
        @TestMetadata(value="secondLevelVal.kts")
        public void testSecondLevelVal() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/secondLevelVal.kts");
        }

        @Test
        @TestMetadata(value="simpleClass.kts")
        public void testSimpleClass() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/simpleClass.kts");
        }

        @Test
        @TestMetadata(value="string.kts")
        public void testString() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/string.kts");
        }

        @Test
        @TestMetadata(value="topLevelFunction.kts")
        public void testTopLevelFunction() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/topLevelFunction.kts");
        }

        @Test
        @TestMetadata(value="topLevelFunctionClosure.kts")
        public void testTopLevelFunctionClosure() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/topLevelFunctionClosure.kts");
        }

        @Test
        @TestMetadata(value="topLevelLocalDelegatedProperty.kts")
        public void testTopLevelLocalDelegatedProperty() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/topLevelLocalDelegatedProperty.kts");
        }

        @Test
        @TestMetadata(value="topLevelPropertiesWithGetSet.kts")
        public void testTopLevelPropertiesWithGetSet() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/topLevelPropertiesWithGetSet.kts");
        }

        @Test
        @TestMetadata(value="topLevelProperty.kts")
        public void testTopLevelProperty() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/topLevelProperty.kts");
        }

        @Test
        @TestMetadata(value="topLevelPropertyWithProvideDelegate.kts")
        public void testTopLevelPropertyWithProvideDelegate() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/topLevelPropertyWithProvideDelegate.kts");
        }

        @Test
        @TestMetadata(value="topLevelTypealias.kts")
        public void testTopLevelTypealias() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/topLevelTypealias.kts");
        }

        @Test
        @TestMetadata(value="twoDestructuringDeclarations.kts")
        public void testTwoDestructuringDeclarations() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/twoDestructuringDeclarations.kts");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/script/scriptInstanceCapturing")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ScriptInstanceCapturing {
            @Test
            public void testAllFilesPresentInScriptInstanceCapturing() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/script/scriptInstanceCapturing"), Pattern.compile("^(.*)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="anonymousObjectCapturesProperty.kts")
            public void testAnonymousObjectCapturesProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/anonymousObjectCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="classCapturesExtensionIndirect.kts")
            public void testClassCapturesExtensionIndirect() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesExtensionIndirect.kts");
            }

            @Test
            @TestMetadata(value="classCapturesExtensionIndirect2x.kts")
            public void testClassCapturesExtensionIndirect2x() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesExtensionIndirect2x.kts");
            }

            @Test
            @TestMetadata(value="classCapturesFunction.kts")
            public void testClassCapturesFunction() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesFunction.kts");
            }

            @Test
            @TestMetadata(value="classCapturesProperty.kts")
            public void testClassCapturesProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="classCapturesPropertyInStringTemplate.kts")
            public void testClassCapturesPropertyInStringTemplate() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesPropertyInStringTemplate.kts");
            }

            @Test
            @TestMetadata(value="classCapturesPropertyIndirect.kts")
            public void testClassCapturesPropertyIndirect() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesPropertyIndirect.kts");
            }

            @Test
            @TestMetadata(value="classCapturesPropertyIndirect2x.kts")
            public void testClassCapturesPropertyIndirect2x() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/classCapturesPropertyIndirect2x.kts");
            }

            @Test
            @TestMetadata(value="companionCapturesProperty.kts")
            public void testCompanionCapturesProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/companionCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="enumCapturesProperty.kts")
            public void testEnumCapturesProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/enumCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="enumEntryCapturesProperty.kts")
            public void testEnumEntryCapturesProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/enumEntryCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="innerClassesHierarchyCaptureProperty.kts")
            public void testInnerClassesHierarchyCaptureProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/innerClassesHierarchyCaptureProperty.kts");
            }

            @Test
            @TestMetadata(value="interfaceCapturesProperty.kts")
            public void testInterfaceCapturesProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/interfaceCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="nestedAndOuterClassesCaptureProperty.kts")
            public void testNestedAndOuterClassesCaptureProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/nestedAndOuterClassesCaptureProperty.kts");
            }

            @Test
            @TestMetadata(value="nestedClassCapturesProperty.kts")
            public void testNestedClassCapturesProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/nestedClassCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="nestedInnerClassCapturesProperty.kts")
            public void testNestedInnerClassCapturesProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/nestedInnerClassCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="nestedToObjectClassCapturesProperty.kts")
            public void testNestedToObjectClassCapturesProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/nestedToObjectClassCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="objectCapturesProperty.kts")
            public void testObjectCapturesProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/objectCapturesProperty.kts");
            }

            @Test
            @TestMetadata(value="objectCapturesPropertyIndirect.kts")
            public void testObjectCapturesPropertyIndirect() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/objectCapturesPropertyIndirect.kts");
            }

            @Test
            @TestMetadata(value="objectCapturesPropertyViaExtension.kts")
            public void testObjectCapturesPropertyViaExtension() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/script/scriptInstanceCapturing/objectCapturesPropertyViaExtension.kts");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/dumpDeclarations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DumpDeclarations {
        @Test
        public void testAllFilesPresentInDumpDeclarations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/dumpDeclarations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="annotation.kt")
        public void testAnnotation() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/dumpDeclarations/annotation.kt");
        }

        @Test
        @TestMetadata(value="classMembers.kt")
        public void testClassMembers() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/dumpDeclarations/classMembers.kt");
        }

        @Test
        @TestMetadata(value="classes.kt")
        public void testClasses() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/dumpDeclarations/classes.kt");
        }

        @Test
        @TestMetadata(value="interfaces.kt")
        public void testInterfaces() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/dumpDeclarations/interfaces.kt");
        }

        @Test
        @TestMetadata(value="intermediateAbstractSuspendFunction.kt")
        public void testIntermediateAbstractSuspendFunction() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/dumpDeclarations/intermediateAbstractSuspendFunction.kt");
        }

        @Test
        @TestMetadata(value="localClasses.kt")
        public void testLocalClasses() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/dumpDeclarations/localClasses.kt");
        }

        @Test
        @TestMetadata(value="multifileFacadeMembers.kt")
        public void testMultifileFacadeMembers() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/dumpDeclarations/multifileFacadeMembers.kt");
        }

        @Test
        @TestMetadata(value="suspendLambda.kt")
        public void testSuspendLambda() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/dumpDeclarations/suspendLambda.kt");
        }

        @Test
        @TestMetadata(value="suspendOverride.kt")
        public void testSuspendOverride() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/dumpDeclarations/suspendOverride.kt");
        }

        @Test
        @TestMetadata(value="topLevelMembers.kt")
        public void testTopLevelMembers() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/dumpDeclarations/topLevelMembers.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/defaultArguments")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DefaultArguments {
        @Test
        public void testAllFilesPresentInDefaultArguments() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/defaultArguments/reflection")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Reflection {
            @Test
            public void testAllFilesPresentInReflection() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/defaultArguments/reflection"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classInClassObject.kt")
            public void testClassInClassObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/classInClassObject.kt");
            }

            @Test
            @TestMetadata(value="classInObject.kt")
            public void testClassInObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/classInObject.kt");
            }

            @Test
            @TestMetadata(value="classWithTwoDefaultArgs.kt")
            public void testClassWithTwoDefaultArgs() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/classWithTwoDefaultArgs.kt");
            }

            @Test
            @TestMetadata(value="classWithVararg.kt")
            public void testClassWithVararg() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/classWithVararg.kt");
            }

            @Test
            @TestMetadata(value="enum.kt")
            public void testEnum() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/enum.kt");
            }

            @Test
            @TestMetadata(value="internalClass.kt")
            public void testInternalClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/internalClass.kt");
            }

            @Test
            @TestMetadata(value="privateClass.kt")
            public void testPrivateClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/privateClass.kt");
            }

            @Test
            @TestMetadata(value="privateConstructor.kt")
            public void testPrivateConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/privateConstructor.kt");
            }

            @Test
            @TestMetadata(value="publicClass.kt")
            public void testPublicClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/publicClass.kt");
            }

            @Test
            @TestMetadata(value="publicClassWoDefArgs.kt")
            public void testPublicClassWoDefArgs() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/publicClassWoDefArgs.kt");
            }

            @Test
            @TestMetadata(value="publicInnerClass.kt")
            public void testPublicInnerClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/publicInnerClass.kt");
            }

            @Test
            @TestMetadata(value="publicInnerClassInPrivateClass.kt")
            public void testPublicInnerClassInPrivateClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/defaultArguments/reflection/publicInnerClassInPrivateClass.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/composeLikeBytecodeText")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ComposeLikeBytecodeText {
        @Test
        public void testAllFilesPresentInComposeLikeBytecodeText() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/composeLikeBytecodeText"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="default.kt")
        public void testDefault() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/composeLikeBytecodeText/default.kt");
        }

        @Test
        @TestMetadata(value="defaultInline.kt")
        public void testDefaultInline() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/composeLikeBytecodeText/defaultInline.kt");
        }

        @Test
        @TestMetadata(value="defaultLocal.kt")
        public void testDefaultLocal() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/composeLikeBytecodeText/defaultLocal.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/composeLike")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ComposeLike {
        @Test
        public void testAllFilesPresentInComposeLike() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/composeLike"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="default.kt")
        public void testDefault() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/composeLike/default.kt");
        }

        @Test
        @TestMetadata(value="defaultInline.kt")
        public void testDefaultInline() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/composeLike/defaultInline.kt");
        }

        @Test
        @TestMetadata(value="defaultLocal.kt")
        public void testDefaultLocal() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/composeLike/defaultLocal.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeListing")
    @TestDataPath(value="$PROJECT_ROOT")
    public class BytecodeListing {
        @Test
        @TestMetadata(value="accessorForProtectedPropertyWithPrivateSetter.kt")
        public void testAccessorForProtectedPropertyWithPrivateSetter() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/accessorForProtectedPropertyWithPrivateSetter.kt");
        }

        @Test
        @TestMetadata(value="accessorForProtectedPropertyWithPrivateSetterInObjectLiteral.kt")
        public void testAccessorForProtectedPropertyWithPrivateSetterInObjectLiteral() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/accessorForProtectedPropertyWithPrivateSetterInObjectLiteral.kt");
        }

        @Test
        @TestMetadata(value="accessorForTopLevelMembers.kt")
        public void testAccessorForTopLevelMembers() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/accessorForTopLevelMembers.kt");
        }

        @Test
        @TestMetadata(value="accessorsForProtectedStaticJavaFieldInOtherPackage.kt")
        public void testAccessorsForProtectedStaticJavaFieldInOtherPackage() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/accessorsForProtectedStaticJavaFieldInOtherPackage.kt");
        }

        @Test
        public void testAllFilesPresentInBytecodeListing() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="anonymousObjectInGenericFun.kt")
        public void testAnonymousObjectInGenericFun() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/anonymousObjectInGenericFun.kt");
        }

        @Test
        @TestMetadata(value="callableNameIntrinsic.kt")
        public void testCallableNameIntrinsic() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/callableNameIntrinsic.kt");
        }

        @Test
        @TestMetadata(value="callableReferenceArrayConstructorArguments.kt")
        public void testCallableReferenceArrayConstructorArguments() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/callableReferenceArrayConstructorArguments.kt");
        }

        @Test
        @TestMetadata(value="cloneable.kt")
        public void testCloneable() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/cloneable.kt");
        }

        @Test
        @TestMetadata(value="companionObjectVisibility_after.kt")
        public void testCompanionObjectVisibility_after() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/companionObjectVisibility_after.kt");
        }

        @Test
        @TestMetadata(value="companionObjectVisibility_before.kt")
        public void testCompanionObjectVisibility_before() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/companionObjectVisibility_before.kt");
        }

        @Test
        @TestMetadata(value="defaultImpls.kt")
        public void testDefaultImpls() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/defaultImpls.kt");
        }

        @Test
        @TestMetadata(value="delegationToJavaInterfaceWithWildcardType.kt")
        public void testDelegationToJavaInterfaceWithWildcardType() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/delegationToJavaInterfaceWithWildcardType.kt");
        }

        @Test
        @TestMetadata(value="deprecatedConstantPropertyInterfaceCompanion.kt")
        public void testDeprecatedConstantPropertyInterfaceCompanion() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecatedConstantPropertyInterfaceCompanion.kt");
        }

        @Test
        @TestMetadata(value="deserializeLambdaMethod.kt")
        public void testDeserializeLambdaMethod() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deserializeLambdaMethod.kt");
        }

        @Test
        @TestMetadata(value="enum.kt")
        public void testEnum() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/enum.kt");
        }

        @Test
        @TestMetadata(value="enumEntries.kt")
        public void testEnumEntries() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/enumEntries.kt");
        }

        @Test
        @TestMetadata(value="extension.kt")
        public void testExtension() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/extension.kt");
        }

        @Test
        @TestMetadata(value="fileClassWithPrivateDeclarationsOnly_after.kt")
        public void testFileClassWithPrivateDeclarationsOnly_after() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/fileClassWithPrivateDeclarationsOnly_after.kt");
        }

        @Test
        @TestMetadata(value="fileClassWithPrivateDeclarationsOnly_before.kt")
        public void testFileClassWithPrivateDeclarationsOnly_before() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/fileClassWithPrivateDeclarationsOnly_before.kt");
        }

        @Test
        @TestMetadata(value="immutableCollection.kt")
        public void testImmutableCollection() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/immutableCollection.kt");
        }

        @Test
        @TestMetadata(value="javaDeprecated.kt")
        public void testJavaDeprecated() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/javaDeprecated.kt");
        }

        @Test
        @TestMetadata(value="jvmOverloadsAndParametersAnnotations.kt")
        public void testJvmOverloadsAndParametersAnnotations() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvmOverloadsAndParametersAnnotations.kt");
        }

        @Test
        @TestMetadata(value="jvmOverloadsExternal.kt")
        public void testJvmOverloadsExternal() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvmOverloadsExternal.kt");
        }

        @Test
        @TestMetadata(value="jvmRecordStructure.kt")
        public void testJvmRecordStructure() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvmRecordStructure.kt");
        }

        @Test
        @TestMetadata(value="kt42137.kt")
        public void testKt42137() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt42137.kt");
        }

        @Test
        @TestMetadata(value="kt42879.kt")
        public void testKt42879() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt42879.kt");
        }

        @Test
        @TestMetadata(value="kt43217.kt")
        public void testKt43217() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt43217.kt");
        }

        @Test
        @TestMetadata(value="kt43440.kt")
        public void testKt43440() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt43440.kt");
        }

        @Test
        @TestMetadata(value="kt45853.kt")
        public void testKt45853() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt45853.kt");
        }

        @Test
        @TestMetadata(value="kt45853a.kt")
        public void testKt45853a() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt45853a.kt");
        }

        @Test
        @TestMetadata(value="kt45934.kt")
        public void testKt45934() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt45934.kt");
        }

        @Test
        @TestMetadata(value="kt47328.kt")
        public void testKt47328() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt47328.kt");
        }

        @Test
        @TestMetadata(value="kt55769.kt")
        public void testKt55769() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/kt55769.kt");
        }

        @Test
        @TestMetadata(value="noCollectionStubMethodsInInterface.kt")
        public void testNoCollectionStubMethodsInInterface() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/noCollectionStubMethodsInInterface.kt");
        }

        @Test
        @TestMetadata(value="noDelegationsToPrivateInterfaceMembers.kt")
        public void testNoDelegationsToPrivateInterfaceMembers() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/noDelegationsToPrivateInterfaceMembers.kt");
        }

        @Test
        @TestMetadata(value="noReceiverInCallableReferenceClasses.kt")
        public void testNoReceiverInCallableReferenceClasses() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/noReceiverInCallableReferenceClasses.kt");
        }

        @Test
        @TestMetadata(value="noRemoveAtInReadOnly.kt")
        public void testNoRemoveAtInReadOnly() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/noRemoveAtInReadOnly.kt");
        }

        @Test
        @TestMetadata(value="overrideWithPrimitiveUpperBound.kt")
        public void testOverrideWithPrimitiveUpperBound() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/overrideWithPrimitiveUpperBound.kt");
        }

        @Test
        @TestMetadata(value="overrideWithPrimitiveUpperBound2.kt")
        public void testOverrideWithPrimitiveUpperBound2() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/overrideWithPrimitiveUpperBound2.kt");
        }

        @Test
        @TestMetadata(value="privateCompanionFields.kt")
        public void testPrivateCompanionFields() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/privateCompanionFields.kt");
        }

        @Test
        @TestMetadata(value="privateDefaultImpls.kt")
        public void testPrivateDefaultImpls() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/privateDefaultImpls.kt");
        }

        @Test
        @TestMetadata(value="privateDefaultSetter.kt")
        public void testPrivateDefaultSetter() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/privateDefaultSetter.kt");
        }

        @Test
        @TestMetadata(value="privateNestedClassInInterface.kt")
        public void testPrivateNestedClassInInterface() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/privateNestedClassInInterface.kt");
        }

        @Test
        @TestMetadata(value="rawTypeInSignature.kt")
        public void testRawTypeInSignature() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/rawTypeInSignature.kt");
        }

        @Test
        @TestMetadata(value="strictfpFlag.kt")
        public void testStrictfpFlag() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/strictfpFlag.kt");
        }

        @Test
        @TestMetadata(value="synchronizedFlag.kt")
        public void testSynchronizedFlag() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/synchronizedFlag.kt");
        }

        @Test
        @TestMetadata(value="varargsBridge.kt")
        public void testVarargsBridge() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/varargsBridge.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/valueClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ValueClasses {
            @Test
            public void testAllFilesPresentInValueClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/valueClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="annotations.kt")
            public void testAnnotations() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/valueClasses/annotations.kt");
            }

            @Test
            @TestMetadata(value="nullabilityAnnotationsOnInlineClassMembers.kt")
            public void testNullabilityAnnotationsOnInlineClassMembers() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/valueClasses/nullabilityAnnotationsOnInlineClassMembers.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/specialBridges")
        @TestDataPath(value="$PROJECT_ROOT")
        public class SpecialBridges {
            @Test
            @TestMetadata(value="abstractCollections.kt")
            public void testAbstractCollections() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractCollections.kt");
            }

            @Test
            @TestMetadata(value="abstractIterables.kt")
            public void testAbstractIterables() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractIterables.kt");
            }

            @Test
            @TestMetadata(value="abstractLists.kt")
            public void testAbstractLists() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractLists.kt");
            }

            @Test
            @TestMetadata(value="abstractListsWithJavaBase.kt")
            public void testAbstractListsWithJavaBase() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractListsWithJavaBase.kt");
            }

            @Test
            @TestMetadata(value="abstractMutableCollectionOfPrimitive.kt")
            public void testAbstractMutableCollectionOfPrimitive() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableCollectionOfPrimitive.kt");
            }

            @Test
            @TestMetadata(value="abstractMutableListOfPrimitive.kt")
            public void testAbstractMutableListOfPrimitive() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableListOfPrimitive.kt");
            }

            @Test
            @TestMetadata(value="abstractMutableLists.kt")
            public void testAbstractMutableLists() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractMutableLists.kt");
            }

            @Test
            @TestMetadata(value="abstractSets.kt")
            public void testAbstractSets() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/abstractSets.kt");
            }

            @Test
            public void testAllFilesPresentInSpecialBridges() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/specialBridges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="charSequence.kt")
            public void testCharSequence() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/charSequence.kt");
            }

            @Test
            @TestMetadata(value="contains.kt")
            public void testContains() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/contains.kt");
            }

            @Test
            @TestMetadata(value="kt41123.kt")
            public void testKt41123() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/kt41123.kt");
            }

            @Test
            @TestMetadata(value="kt48945.kt")
            public void testKt48945() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/kt48945.kt");
            }

            @Test
            @TestMetadata(value="mutableCollectionOfPrimitive.kt")
            public void testMutableCollectionOfPrimitive() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/mutableCollectionOfPrimitive.kt");
            }

            @Test
            @TestMetadata(value="mutableListOfPrimitive.kt")
            public void testMutableListOfPrimitive() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/mutableListOfPrimitive.kt");
            }

            @Test
            @TestMetadata(value="noDefaultImplsOnEmptySubInterface.kt")
            public void testNoDefaultImplsOnEmptySubInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/noDefaultImplsOnEmptySubInterface.kt");
            }

            @Test
            @TestMetadata(value="noSpecialBridgeIfPresentInSuperClass.kt")
            public void testNoSpecialBridgeIfPresentInSuperClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/noSpecialBridgeIfPresentInSuperClass.kt");
            }

            @Test
            @TestMetadata(value="number.kt")
            public void testNumber() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/number.kt");
            }

            @Test
            @TestMetadata(value="redundantStubForSize.kt")
            public void testRedundantStubForSize() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/redundantStubForSize.kt");
            }

            @Test
            @TestMetadata(value="removeAtTwoSpecialBridges.kt")
            public void testRemoveAtTwoSpecialBridges() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/removeAtTwoSpecialBridges.kt");
            }

            @Test
            @TestMetadata(value="specialBridgeForGet.kt")
            public void testSpecialBridgeForGet() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/specialBridgeForGet.kt");
            }

            @Test
            @TestMetadata(value="unsignedArray.kt")
            public void testUnsignedArray() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/unsignedArray.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/specialBridges/signatures")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Signatures {
                @Test
                public void testAllFilesPresentInSignatures() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/specialBridges/signatures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="genericClass.kt")
                public void testGenericClass() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/genericClass.kt");
                }

                @Test
                @TestMetadata(value="implementsJavaMap.kt")
                public void testImplementsJavaMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsJavaMap.kt");
                }

                @Test
                @TestMetadata(value="implementsJavaMapWithCustomEntries.kt")
                public void testImplementsJavaMapWithCustomEntries() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsJavaMapWithCustomEntries.kt");
                }

                @Test
                @TestMetadata(value="implementsMap.kt")
                public void testImplementsMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsMap.kt");
                }

                @Test
                @TestMetadata(value="implementsSortedMap.kt")
                public void testImplementsSortedMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/implementsSortedMap.kt");
                }

                @Test
                @TestMetadata(value="kt43610.kt")
                public void testKt43610() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/kt43610.kt");
                }

                @Test
                @TestMetadata(value="nonGenericClass.kt")
                public void testNonGenericClass() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/nonGenericClass.kt");
                }

                @Test
                @TestMetadata(value="partiallySpecializedClass.kt")
                public void testPartiallySpecializedClass() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/specialBridges/signatures/partiallySpecializedClass.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/sealed")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Sealed {
            @Test
            public void testAllFilesPresentInSealed() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/sealed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="annotationsOnSealedConstructor.kt")
            public void testAnnotationsOnSealedConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sealed/annotationsOnSealedConstructor.kt");
            }

            @Test
            @TestMetadata(value="permittedSubclasses_1_7.kt")
            public void testPermittedSubclasses_1_7() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sealed/permittedSubclasses_1_7.kt");
            }

            @Test
            @TestMetadata(value="sealedClassConstructor_1_4.kt")
            public void testSealedClassConstructor_1_4() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sealed/sealedClassConstructor_1_4.kt");
            }

            @Test
            @TestMetadata(value="sealedClassConstructor_1_5.kt")
            public void testSealedClassConstructor_1_5() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sealed/sealedClassConstructor_1_5.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/sam")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Sam {
            @Test
            public void testAllFilesPresentInSam() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="callableRefGenericFunInterface.kt")
            public void testCallableRefGenericFunInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefGenericFunInterface.kt");
            }

            @Test
            @TestMetadata(value="callableRefGenericSamInterface.kt")
            public void testCallableRefGenericSamInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefGenericSamInterface.kt");
            }

            @Test
            @TestMetadata(value="callableRefSpecializedFunInterface.kt")
            public void testCallableRefSpecializedFunInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefSpecializedFunInterface.kt");
            }

            @Test
            @TestMetadata(value="callableRefSpecializedSamInterface.kt")
            public void testCallableRefSpecializedSamInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/callableRefSpecializedSamInterface.kt");
            }

            @Test
            @TestMetadata(value="genericFunInterface.kt")
            public void testGenericFunInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/genericFunInterface.kt");
            }

            @Test
            @TestMetadata(value="genericSamInterface.kt")
            public void testGenericSamInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/genericSamInterface.kt");
            }

            @Test
            @TestMetadata(value="indySamConversionViaProxyFun.kt")
            public void testIndySamConversionViaProxyFun() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/indySamConversionViaProxyFun.kt");
            }

            @Test
            @TestMetadata(value="kt16650.kt")
            public void testKt16650() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/kt16650.kt");
            }

            @Test
            @TestMetadata(value="lambdaGenericFunInterface.kt")
            public void testLambdaGenericFunInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaGenericFunInterface.kt");
            }

            @Test
            @TestMetadata(value="lambdaGenericSamInterface.kt")
            public void testLambdaGenericSamInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaGenericSamInterface.kt");
            }

            @Test
            @TestMetadata(value="lambdaSpecializedFunInterface.kt")
            public void testLambdaSpecializedFunInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaSpecializedFunInterface.kt");
            }

            @Test
            @TestMetadata(value="lambdaSpecializedSamInterface.kt")
            public void testLambdaSpecializedSamInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/lambdaSpecializedSamInterface.kt");
            }

            @Test
            @TestMetadata(value="nonApproxToValidSupertype.kt")
            public void testNonApproxToValidSupertype() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/nonApproxToValidSupertype.kt");
            }

            @Test
            @TestMetadata(value="nonApproxToValidSupertype2.kt")
            public void testNonApproxToValidSupertype2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/nonApproxToValidSupertype2.kt");
            }

            @Test
            @TestMetadata(value="privateInlineSamAdapter.kt")
            public void testPrivateInlineSamAdapter() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/privateInlineSamAdapter.kt");
            }

            @Test
            @TestMetadata(value="reusedSamWrapperClasses.kt")
            public void testReusedSamWrapperClasses() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/reusedSamWrapperClasses.kt");
            }

            @Test
            @TestMetadata(value="samAdapterAndInlinedOne.kt")
            public void testSamAdapterAndInlinedOne() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/samAdapterAndInlinedOne.kt");
            }

            @Test
            @TestMetadata(value="samAdapterInInlineLambda.kt")
            public void testSamAdapterInInlineLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/samAdapterInInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="samWithContravariantProjection.kt")
            public void testSamWithContravariantProjection() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/samWithContravariantProjection.kt");
            }

            @Test
            @TestMetadata(value="severalProxyFunsInInit.kt")
            public void testSeveralProxyFunsInInit() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/severalProxyFunsInInit.kt");
            }

            @Test
            @TestMetadata(value="specializedFunInterface.kt")
            public void testSpecializedFunInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/specializedFunInterface.kt");
            }

            @Test
            @TestMetadata(value="specializedSamInterface.kt")
            public void testSpecializedSamInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/specializedSamInterface.kt");
            }

            @Test
            @TestMetadata(value="wrapperInlinedFromAnotherClass.kt")
            public void testWrapperInlinedFromAnotherClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/sam/wrapperInlinedFromAnotherClass.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/properties")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Properties {
            @Test
            public void testAllFilesPresentInProperties() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/properties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/properties/backingField")
            @TestDataPath(value="$PROJECT_ROOT")
            public class BackingField {
                @Test
                public void testAllFilesPresentInBackingField() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/properties/backingField"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="explicitBackingFieldsInJava.kt")
                public void testExplicitBackingFieldsInJava() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/properties/backingField/explicitBackingFieldsInJava.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/nullabilityAnnotations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NullabilityAnnotations {
            @Test
            public void testAllFilesPresentInNullabilityAnnotations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="lateInitNotNull.kt")
            public void testLateInitNotNull() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/lateInitNotNull.kt");
            }

            @Test
            @TestMetadata(value="nullabilityAnnotationsForReturnType.kt")
            public void testNullabilityAnnotationsForReturnType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/nullabilityAnnotationsForReturnType.kt");
            }

            @Test
            @TestMetadata(value="nullabilityAnnotationsOnDelegatedMembers.kt")
            public void testNullabilityAnnotationsOnDelegatedMembers() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/nullabilityAnnotationsOnDelegatedMembers.kt");
            }

            @Test
            @TestMetadata(value="platformTypes.kt")
            public void testPlatformTypes() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/platformTypes.kt");
            }

            @Test
            @TestMetadata(value="samAdapterForJavaInterfaceWithNullability.kt")
            public void testSamAdapterForJavaInterfaceWithNullability() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/samAdapterForJavaInterfaceWithNullability.kt");
            }

            @Test
            @TestMetadata(value="suspendFunction.kt")
            public void testSuspendFunction() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/nullabilityAnnotations/suspendFunction.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/multiplatform")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Multiplatform {
            @Test
            public void testAllFilesPresentInMultiplatform() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="optionalExpectation.kt")
            public void testOptionalExpectation() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multiplatform/optionalExpectation.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/multifileClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class MultifileClasses {
            @Test
            public void testAllFilesPresentInMultifileClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="emptyMultifileFacade.kt")
            public void testEmptyMultifileFacade() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/emptyMultifileFacade.kt");
            }

            @Test
            @TestMetadata(value="jvmSynthetic.kt")
            public void testJvmSynthetic() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/jvmSynthetic.kt");
            }

            @Test
            @TestMetadata(value="kt43519.kt")
            public void testKt43519() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/kt43519.kt");
            }

            @Test
            @TestMetadata(value="multiClassPartSourceMultipleParts.kt")
            public void testMultiClassPartSourceMultipleParts() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/multiClassPartSourceMultipleParts.kt");
            }

            @Test
            @TestMetadata(value="multiClassPartSourceSinglePart.kt")
            public void testMultiClassPartSourceSinglePart() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/multifileClasses/multiClassPartSourceSinglePart.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/main")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Main {
            @Test
            public void testAllFilesPresentInMain() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/main"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="multifileSuspend.kt")
            public void testMultifileSuspend() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/main/multifileSuspend.kt");
            }

            @Test
            @TestMetadata(value="parameterlessMain.kt")
            public void testParameterlessMain() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/main/parameterlessMain.kt");
            }

            @Test
            @TestMetadata(value="parameterlessMain_before.kt")
            public void testParameterlessMain_before() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/main/parameterlessMain_before.kt");
            }

            @Test
            @TestMetadata(value="suspendMain.kt")
            public void testSuspendMain() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/main/suspendMain.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/localFunctions")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LocalFunctions {
            @Test
            public void testAllFilesPresentInLocalFunctions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/localFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="genericClass.kt")
            public void testGenericClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericClass.kt");
            }

            @Test
            @TestMetadata(value="genericInnerClass.kt")
            public void testGenericInnerClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericInnerClass.kt");
            }

            @Test
            @TestMetadata(value="genericLocalClass.kt")
            public void testGenericLocalClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/genericLocalClass.kt");
            }

            @Test
            @TestMetadata(value="inInitBlock.kt")
            public void testInInitBlock() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/inInitBlock.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/localFunctions/simple.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvmStatic")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JvmStatic {
            @Test
            public void testAllFilesPresentInJvmStatic() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvmStatic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="jvmStaticExternal.kt")
            public void testJvmStaticExternal() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticExternal.kt");
            }

            @Test
            @TestMetadata(value="jvmStaticPrivate.kt")
            public void testJvmStaticPrivate() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticPrivate.kt");
            }

            @Test
            @TestMetadata(value="jvmStaticWithDefaultParameters.kt")
            public void testJvmStaticWithDefaultParameters() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/jvmStaticWithDefaultParameters.kt");
            }

            @Test
            @TestMetadata(value="kt31389.kt")
            public void testKt31389() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvmStatic/kt31389.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Jvm8 {
            @Test
            public void testAllFilesPresentInJvm8() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8/defaults")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Defaults {
                @Test
                public void testAllFilesPresentInDefaults() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl")
                @TestDataPath(value="$PROJECT_ROOT")
                public class NoDefaultImpl {
                    @Test
                    public void testAllFilesPresentInNoDefaultImpl() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="interfaceProperty.kt")
                    public void testInterfaceProperty() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl/interfaceProperty.kt");
                    }

                    @Test
                    @TestMetadata(value="privateAccessorNaming.kt")
                    public void testPrivateAccessorNaming() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/noDefaultImpl/privateAccessorNaming.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility")
                @TestDataPath(value="$PROJECT_ROOT")
                public class AllCompatibility {
                    @Test
                    public void testAllFilesPresentInAllCompatibility() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="deprecation.kt")
                    public void testDeprecation() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/deprecation.kt");
                    }

                    @Test
                    @TestMetadata(value="deprecationWithDefault.kt")
                    public void testDeprecationWithDefault() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/deprecationWithDefault.kt");
                    }

                    @Test
                    @TestMetadata(value="interfaceProperty.kt")
                    public void testInterfaceProperty() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/interfaceProperty.kt");
                    }

                    @Test
                    @TestMetadata(value="jvmDefaultWithoutCompatibility.kt")
                    public void testJvmDefaultWithoutCompatibility() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/jvmDefaultWithoutCompatibility.kt");
                    }

                    @Test
                    @TestMetadata(value="noDefaultImplsOnEmptySubInterface.kt")
                    public void testNoDefaultImplsOnEmptySubInterface() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/noDefaultImplsOnEmptySubInterface.kt");
                    }

                    @Nested
                    @TestMetadata(value="compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization")
                    @TestDataPath(value="$PROJECT_ROOT")
                    public class Specialization {
                        @Test
                        public void testAllFilesPresentInSpecialization() throws Exception {
                            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                        }

                        @Test
                        @TestMetadata(value="primitiveAndAny.kt")
                        public void testPrimitiveAndAny() throws Exception {
                            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization/primitiveAndAny.kt");
                        }

                        @Test
                        @TestMetadata(value="primitiveAndNullable.kt")
                        public void testPrimitiveAndNullable() throws Exception {
                            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/jvm8/defaults/allCompatibility/specialization/primitiveAndNullable.kt");
                        }
                    }
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="annotatedPropertyWithInlineClassTypeInSignature.kt")
            public void testAnnotatedPropertyWithInlineClassTypeInSignature() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotatedPropertyWithInlineClassTypeInSignature.kt");
            }

            @Test
            @TestMetadata(value="annotationGetters.kt")
            public void testAnnotationGetters() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotationGetters.kt");
            }

            @Test
            @TestMetadata(value="annotationsOnHiddenConstructor.kt")
            public void testAnnotationsOnHiddenConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/annotationsOnHiddenConstructor.kt");
            }

            @Test
            @TestMetadata(value="companionObjectInsideInlineClass.kt")
            public void testCompanionObjectInsideInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/companionObjectInsideInlineClass.kt");
            }

            @Test
            @TestMetadata(value="computablePropertiesInsideInlineClass.kt")
            public void testComputablePropertiesInsideInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/computablePropertiesInsideInlineClass.kt");
            }

            @Test
            @TestMetadata(value="constructor.kt")
            public void testConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/constructor.kt");
            }

            @Test
            @TestMetadata(value="constructorsWithDefaultParameterValues.kt")
            public void testConstructorsWithDefaultParameterValues() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/constructorsWithDefaultParameterValues.kt");
            }

            @Test
            @TestMetadata(value="defaultInterfaceMethodsInInlineClass.kt")
            public void testDefaultInterfaceMethodsInInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMethodsInInlineClass.kt");
            }

            @Test
            @TestMetadata(value="genericChild.kt")
            public void testGenericChild() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/genericChild.kt");
            }

            @Test
            @TestMetadata(value="hiddenConstructor.kt")
            public void testHiddenConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/hiddenConstructor.kt");
            }

            @Test
            @TestMetadata(value="inlineCharSequence.kt")
            public void testInlineCharSequence() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCharSequence.kt");
            }

            @Test
            @TestMetadata(value="inlineClassMembersVisibility.kt")
            public void testInlineClassMembersVisibility() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassMembersVisibility.kt");
            }

            @Test
            @TestMetadata(value="inlineClassTypeParametersInConstructor.kt")
            public void testInlineClassTypeParametersInConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassTypeParametersInConstructor.kt");
            }

            @Test
            @TestMetadata(value="inlineClassWithInlineClassUnderlyingType.kt")
            public void testInlineClassWithInlineClassUnderlyingType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassWithInlineClassUnderlyingType.kt");
            }

            @Test
            @TestMetadata(value="inlineClassWithManyKindsOfMembers.kt")
            public void testInlineClassWithManyKindsOfMembers() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineClassWithManyKindsOfMembers.kt");
            }

            @Test
            @TestMetadata(value="jvmName.kt")
            public void testJvmName() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/jvmName.kt");
            }

            @Test
            @TestMetadata(value="jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt")
            public void testJvmOverloadsOnTopLevelFunctionReturningInlineClassValue() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/jvmOverloadsOnTopLevelFunctionReturningInlineClassValue.kt");
            }

            @Test
            @TestMetadata(value="memberExtensionProperty.kt")
            public void testMemberExtensionProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/memberExtensionProperty.kt");
            }

            @Test
            @TestMetadata(value="noArgConstructorForInlineClassParameter.kt")
            public void testNoArgConstructorForInlineClassParameter() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/noArgConstructorForInlineClassParameter.kt");
            }

            @Test
            @TestMetadata(value="noBridgesForErasedInlineClass.kt")
            public void testNoBridgesForErasedInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/noBridgesForErasedInlineClass.kt");
            }

            @Test
            @TestMetadata(value="nullabilityAnnotationsOnInlineClassMembers.kt")
            public void testNullabilityAnnotationsOnInlineClassMembers() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullabilityAnnotationsOnInlineClassMembers.kt");
            }

            @Test
            @TestMetadata(value="nullabilityInExpansion.kt")
            public void testNullabilityInExpansion() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullabilityInExpansion.kt");
            }

            @Test
            @TestMetadata(value="nullableAndNotNullPrimitive.kt")
            public void testNullableAndNotNullPrimitive() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/nullableAndNotNullPrimitive.kt");
            }

            @Test
            @TestMetadata(value="overridingGenericMethodWithInlineClassParameterType.kt")
            public void testOverridingGenericMethodWithInlineClassParameterType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/overridingGenericMethodWithInlineClassParameterType.kt");
            }

            @Test
            @TestMetadata(value="overridingGenericMethodWithInlineClassReturnType.kt")
            public void testOverridingGenericMethodWithInlineClassReturnType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/overridingGenericMethodWithInlineClassReturnType.kt");
            }

            @Test
            @TestMetadata(value="primaryValsWithDifferentVisibilities.kt")
            public void testPrimaryValsWithDifferentVisibilities() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/primaryValsWithDifferentVisibilities.kt");
            }

            @Test
            @TestMetadata(value="publishedApiAnnotationOnInlineClassConstructor.kt")
            public void testPublishedApiAnnotationOnInlineClassConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/publishedApiAnnotationOnInlineClassConstructor.kt");
            }

            @Test
            @TestMetadata(value="shapeOfInlineClassWithPrimitive.kt")
            public void testShapeOfInlineClassWithPrimitive() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/shapeOfInlineClassWithPrimitive.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430")
            @TestDataPath(value="$PROJECT_ROOT")
            public class StdlibManglingIn1430 {
                @Test
                public void testAllFilesPresentInStdlibManglingIn1430() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="new.kt")
                public void testNew() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430/new.kt");
                }

                @Test
                @TestMetadata(value="old.kt")
                public void testOld() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/stdlibManglingIn1430/old.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ReturnResult {
                @Test
                public void testAllFilesPresentInReturnResult() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="class.kt")
                public void testClass() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/class.kt");
                }

                @Test
                @TestMetadata(value="classAnyOverride.kt")
                public void testClassAnyOverride() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classAnyOverride.kt");
                }

                @Test
                @TestMetadata(value="classGenericOverride.kt")
                public void testClassGenericOverride() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classGenericOverride.kt");
                }

                @Test
                @TestMetadata(value="classResultOverride.kt")
                public void testClassResultOverride() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/classResultOverride.kt");
                }

                @Test
                @TestMetadata(value="interface.kt")
                public void testInterface() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/interface.kt");
                }

                @Test
                @TestMetadata(value="topLevel.kt")
                public void testTopLevel() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/returnResult/topLevel.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineCollectionOfInlineClass {
                @Test
                public void testAllFilesPresentInInlineCollectionOfInlineClass() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="collection.kt")
                public void testCollection() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/collection.kt");
                }

                @Test
                @TestMetadata(value="iterable.kt")
                public void testIterable() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/iterable.kt");
                }

                @Test
                @TestMetadata(value="iterator.kt")
                public void testIterator() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/iterator.kt");
                }

                @Test
                @TestMetadata(value="list.kt")
                public void testList() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/list.kt");
                }

                @Test
                @TestMetadata(value="map.kt")
                public void testMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/map.kt");
                }

                @Test
                @TestMetadata(value="mapEntry.kt")
                public void testMapEntry() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mapEntry.kt");
                }

                @Test
                @TestMetadata(value="mutableCollection.kt")
                public void testMutableCollection() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableCollection.kt");
                }

                @Test
                @TestMetadata(value="mutableIterable.kt")
                public void testMutableIterable() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableIterable.kt");
                }

                @Test
                @TestMetadata(value="mutableIterator.kt")
                public void testMutableIterator() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableIterator.kt");
                }

                @Test
                @TestMetadata(value="mutableList.kt")
                public void testMutableList() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableList.kt");
                }

                @Test
                @TestMetadata(value="mutableMap.kt")
                public void testMutableMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableMap.kt");
                }

                @Test
                @TestMetadata(value="mutableMapEntry.kt")
                public void testMutableMapEntry() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableMapEntry.kt");
                }

                @Test
                @TestMetadata(value="mutableSet.kt")
                public void testMutableSet() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableSet.kt");
                }

                @Test
                @TestMetadata(value="mutableSet2.kt")
                public void testMutableSet2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/mutableSet2.kt");
                }

                @Test
                @TestMetadata(value="set.kt")
                public void testSet() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollectionOfInlineClass/set.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineCollection {
                @Test
                public void testAllFilesPresentInInlineCollection() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="collection.kt")
                public void testCollection() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/collection.kt");
                }

                @Test
                @TestMetadata(value="iterable.kt")
                public void testIterable() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/iterable.kt");
                }

                @Test
                @TestMetadata(value="iterator.kt")
                public void testIterator() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/iterator.kt");
                }

                @Test
                @TestMetadata(value="list.kt")
                public void testList() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/list.kt");
                }

                @Test
                @TestMetadata(value="map.kt")
                public void testMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/map.kt");
                }

                @Test
                @TestMetadata(value="mapEntry.kt")
                public void testMapEntry() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mapEntry.kt");
                }

                @Test
                @TestMetadata(value="mutableCollection.kt")
                public void testMutableCollection() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableCollection.kt");
                }

                @Test
                @TestMetadata(value="mutableIterable.kt")
                public void testMutableIterable() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableIterable.kt");
                }

                @Test
                @TestMetadata(value="mutableIterator.kt")
                public void testMutableIterator() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableIterator.kt");
                }

                @Test
                @TestMetadata(value="mutableList.kt")
                public void testMutableList() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableList.kt");
                }

                @Test
                @TestMetadata(value="mutableMap.kt")
                public void testMutableMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableMap.kt");
                }

                @Test
                @TestMetadata(value="mutableMapEntry.kt")
                public void testMutableMapEntry() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableMapEntry.kt");
                }

                @Test
                @TestMetadata(value="mutableSet.kt")
                public void testMutableSet() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/mutableSet.kt");
                }

                @Test
                @TestMetadata(value="set.kt")
                public void testSet() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/set.kt");
                }

                @Test
                @TestMetadata(value="UIntArrayWithFullJdk.kt")
                public void testUIntArrayWithFullJdk() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/inlineCollection/UIntArrayWithFullJdk.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DefaultInterfaceMembers {
                @Test
                public void testAllFilesPresentInDefaultInterfaceMembers() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="javaDefaultInterfaceMember.kt")
                public void testJavaDefaultInterfaceMember() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers/javaDefaultInterfaceMember.kt");
                }

                @Test
                @TestMetadata(value="jvmDefaultAll.kt")
                public void testJvmDefaultAll() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inlineClasses/defaultInterfaceMembers/jvmDefaultAll.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inline")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Inline {
            @Test
            public void testAllFilesPresentInInline() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="genericReified.kt")
            public void testGenericReified() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/genericReified.kt");
            }

            @Test
            @TestMetadata(value="inlineOnly.kt")
            public void testInlineOnly() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineOnly.kt");
            }

            @Test
            @TestMetadata(value="InlineOnlyMultifile.kt")
            public void testInlineOnlyMultifile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/InlineOnlyMultifile.kt");
            }

            @Test
            @TestMetadata(value="inlineOnlyProperty.kt")
            public void testInlineOnlyProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineOnlyProperty.kt");
            }

            @Test
            @TestMetadata(value="InlineOnlyPropertyMultifile.kt")
            public void testInlineOnlyPropertyMultifile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/InlineOnlyPropertyMultifile.kt");
            }

            @Test
            @TestMetadata(value="inlineReified.kt")
            public void testInlineReified() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReified.kt");
            }

            @Test
            @TestMetadata(value="InlineReifiedMultifile.kt")
            public void testInlineReifiedMultifile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/InlineReifiedMultifile.kt");
            }

            @Test
            @TestMetadata(value="inlineReifiedProperty.kt")
            public void testInlineReifiedProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedProperty.kt");
            }

            @Test
            @TestMetadata(value="InlineReifiedPropertyMultifile.kt")
            public void testInlineReifiedPropertyMultifile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/InlineReifiedPropertyMultifile.kt");
            }

            @Test
            @TestMetadata(value="inlineReifiedPropertyVisibility.kt")
            public void testInlineReifiedPropertyVisibility() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedPropertyVisibility.kt");
            }

            @Test
            @TestMetadata(value="inlineReifiedVisibility.kt")
            public void testInlineReifiedVisibility() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/inlineReifiedVisibility.kt");
            }

            @Test
            @TestMetadata(value="simpleNamed.kt")
            public void testSimpleNamed() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/simpleNamed.kt");
            }

            @Test
            @TestMetadata(value="suspendInlineReified.kt")
            public void testSuspendInlineReified() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/suspendInlineReified.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/inline/enclosingInfo")
            @TestDataPath(value="$PROJECT_ROOT")
            public class EnclosingInfo {
                @Test
                public void testAllFilesPresentInEnclosingInfo() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="crossinlineLambdaChain.kt")
                public void testCrossinlineLambdaChain() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/crossinlineLambdaChain.kt");
                }

                @Test
                @TestMetadata(value="kt10259.kt")
                public void testKt10259() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/kt10259.kt");
                }

                @Test
                @TestMetadata(value="lambdaInInitBlockNoPrimaryConstructor.kt")
                public void testLambdaInInitBlockNoPrimaryConstructor() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/lambdaInInitBlockNoPrimaryConstructor.kt");
                }

                @Test
                @TestMetadata(value="lambdaInInnerClassConstructor.kt")
                public void testLambdaInInnerClassConstructor() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/lambdaInInnerClassConstructor.kt");
                }

                @Test
                @TestMetadata(value="transformedConstructor.kt")
                public void testTransformedConstructor() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/transformedConstructor.kt");
                }

                @Test
                @TestMetadata(value="transformedConstructorWithNestedInline.kt")
                public void testTransformedConstructorWithNestedInline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/inline/enclosingInfo/transformedConstructorWithNestedInline.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/deprecated")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Deprecated {
            @Test
            public void testAllFilesPresentInDeprecated() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/deprecated"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="deprecatedClass.kt")
            public void testDeprecatedClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedClass.kt");
            }

            @Test
            @TestMetadata(value="deprecatedEnumEntryFields.kt")
            public void testDeprecatedEnumEntryFields() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedEnumEntryFields.kt");
            }

            @Test
            @TestMetadata(value="deprecatedInMultifileClass.kt")
            public void testDeprecatedInMultifileClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedInMultifileClass.kt");
            }

            @Test
            @TestMetadata(value="deprecatedLateinitVar.kt")
            public void testDeprecatedLateinitVar() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedLateinitVar.kt");
            }

            @Test
            @TestMetadata(value="deprecatedProperty.kt")
            public void testDeprecatedProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/deprecatedProperty.kt");
            }

            @Test
            @TestMetadata(value="hidden.kt")
            public void testHidden() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/hidden.kt");
            }

            @Test
            @TestMetadata(value="inheritingDeprecation.kt")
            public void testInheritingDeprecation() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/inheritingDeprecation.kt");
            }

            @Test
            @TestMetadata(value="inlineClassTypesInSignature.kt")
            public void testInlineClassTypesInSignature() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/inlineClassTypesInSignature.kt");
            }

            @Test
            @TestMetadata(value="jvmStaticDeprecatedProperty.kt")
            public void testJvmStaticDeprecatedProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/deprecated/jvmStaticDeprecatedProperty.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/delegatedProperty")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DelegatedProperty {
            @Test
            public void testAllFilesPresentInDelegatedProperty() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="delegateMethodIsNonOverridable.kt")
            public void testDelegateMethodIsNonOverridable() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/delegateMethodIsNonOverridable.kt");
            }

            @Test
            @TestMetadata(value="delegatedPropertiesInCompanionObject.kt")
            public void testDelegatedPropertiesInCompanionObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/delegatedPropertiesInCompanionObject.kt");
            }

            @Test
            @TestMetadata(value="localDelegatedProperty.kt")
            public void testLocalDelegatedProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/delegatedProperty/localDelegatedProperty.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/defaultArguments")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DefaultArguments {
            @Test
            public void testAllFilesPresentInDefaultArguments() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="functionInMultifileClass.kt")
            public void testFunctionInMultifileClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/functionInMultifileClass.kt");
            }

            @Test
            @TestMetadata(value="functionInMultifileClassWithInheritedParts.kt")
            public void testFunctionInMultifileClassWithInheritedParts() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/functionInMultifileClassWithInheritedParts.kt");
            }

            @Test
            @TestMetadata(value="internalNameMangling.kt")
            public void testInternalNameMangling() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/defaultArguments/internalNameMangling.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/coroutines")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Coroutines {
            @Test
            public void testAllFilesPresentInCoroutines() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="coroutineContextIntrinsic.kt")
            public void testCoroutineContextIntrinsic() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/coroutineContextIntrinsic.kt");
            }

            @Test
            @TestMetadata(value="coroutineFields.kt")
            public void testCoroutineFields() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/coroutineFields.kt");
            }

            @Test
            @TestMetadata(value="oomInReturnUnit.kt")
            public void testOomInReturnUnit() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/oomInReturnUnit.kt");
            }

            @Test
            @TestMetadata(value="privateAccessor.kt")
            public void testPrivateAccessor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/privateAccessor.kt");
            }

            @Test
            @TestMetadata(value="privateSuspendFun.kt")
            public void testPrivateSuspendFun() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/privateSuspendFun.kt");
            }

            @Test
            @TestMetadata(value="suspendConversion.kt")
            public void testSuspendConversion() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendConversion.kt");
            }

            @Test
            @TestMetadata(value="suspendImpl.kt")
            public void testSuspendImpl() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendImpl.kt");
            }

            @Test
            @TestMetadata(value="suspendReifiedFun.kt")
            public void testSuspendReifiedFun() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/suspendReifiedFun.kt");
            }

            @Test
            @TestMetadata(value="tcoContinuation.kt")
            public void testTcoContinuation() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/tcoContinuation.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/coroutines/spilling")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Spilling {
                @Test
                public void testAllFilesPresentInSpilling() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/coroutines/spilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="booleanParameter.kt")
                public void testBooleanParameter() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/booleanParameter.kt");
                }

                @Test
                @TestMetadata(value="component1.kt")
                public void testComponent1() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/component1.kt");
                }

                @Test
                @TestMetadata(value="destructured.kt")
                public void testDestructured() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/destructured.kt");
                }

                @Test
                @TestMetadata(value="field.kt")
                public void testField() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/field.kt");
                }

                @Test
                @TestMetadata(value="lambda.kt")
                public void testLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/lambda.kt");
                }

                @Test
                @TestMetadata(value="select.kt")
                public void testSelect() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/select.kt");
                }

                @Test
                @TestMetadata(value="unreachable.kt")
                public void testUnreachable() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/coroutines/spilling/unreachable.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/contextReceivers")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ContextReceivers {
            @Test
            public void testAllFilesPresentInContextReceivers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/contextReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="class.kt")
            public void testClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/class.kt");
            }

            @Test
            @TestMetadata(value="function.kt")
            public void testFunction() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/function.kt");
            }

            @Test
            @TestMetadata(value="property.kt")
            public void testProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/property.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP")
            @TestDataPath(value="$PROJECT_ROOT")
            public class FromKEEP {
                @Test
                public void testAllFilesPresentInFromKEEP() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="canvas.kt")
                public void testCanvas() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/canvas.kt");
                }

                @Test
                @TestMetadata(value="compareTo.kt")
                public void testCompareTo() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/compareTo.kt");
                }

                @Test
                @TestMetadata(value="dp.kt")
                public void testDp() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/dp.kt");
                }

                @Test
                @TestMetadata(value="functionalType.kt")
                public void testFunctionalType() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/functionalType.kt");
                }

                @Test
                @TestMetadata(value="monoidSum.kt")
                public void testMonoidSum() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/contextReceivers/fromKEEP/monoidSum.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/collectionStubs")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CollectionStubs {
            @Test
            @TestMetadata(value="abstractMapRedefiningGetAny.kt")
            public void testAbstractMapRedefiningGetAny() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractMapRedefiningGetAny.kt");
            }

            @Test
            public void testAllFilesPresentInCollectionStubs() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="collectionByDelegation.kt")
            public void testCollectionByDelegation() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation.kt");
            }

            @Test
            @TestMetadata(value="collectionByDelegation2.kt")
            public void testCollectionByDelegation2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation2.kt");
            }

            @Test
            @TestMetadata(value="collectionByDelegation2WithFullJdk.kt")
            public void testCollectionByDelegation2WithFullJdk() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation2WithFullJdk.kt");
            }

            @Test
            @TestMetadata(value="collectionByDelegation3.kt")
            public void testCollectionByDelegation3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation3.kt");
            }

            @Test
            @TestMetadata(value="collectionByDelegation3WithFullJdk.kt")
            public void testCollectionByDelegation3WithFullJdk() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegation3WithFullJdk.kt");
            }

            @Test
            @TestMetadata(value="collectionByDelegationWithFullJdk.kt")
            public void testCollectionByDelegationWithFullJdk() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionByDelegationWithFullJdk.kt");
            }

            @Test
            @TestMetadata(value="collectionWithInternalRemove.kt")
            public void testCollectionWithInternalRemove() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionWithInternalRemove.kt");
            }

            @Test
            @TestMetadata(value="collectionsWithFullJdk.kt")
            public void testCollectionsWithFullJdk() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/collectionsWithFullJdk.kt");
            }

            @Test
            @TestMetadata(value="customListIterator.kt")
            public void testCustomListIterator() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/customListIterator.kt");
            }

            @Test
            @TestMetadata(value="customMutableListIterator.kt")
            public void testCustomMutableListIterator() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/customMutableListIterator.kt");
            }

            @Test
            @TestMetadata(value="emptyList.kt")
            public void testEmptyList() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/emptyList.kt");
            }

            @Test
            @TestMetadata(value="extendingAbstractCollection.kt")
            public void testExtendingAbstractCollection() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/extendingAbstractCollection.kt");
            }

            @Test
            @TestMetadata(value="inheritingFromAbstractCollections.kt")
            public void testInheritingFromAbstractCollections() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractCollections.kt");
            }

            @Test
            @TestMetadata(value="inheritingFromAbstractMap.kt")
            public void testInheritingFromAbstractMap() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractMap.kt");
            }

            @Test
            @TestMetadata(value="inheritingFromAbstractMutableList.kt")
            public void testInheritingFromAbstractMutableList() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/inheritingFromAbstractMutableList.kt");
            }

            @Test
            @TestMetadata(value="intArrayList.kt")
            public void testIntArrayList() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/intArrayList.kt");
            }

            @Test
            @TestMetadata(value="kt44233.kt")
            public void testKt44233() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/kt44233.kt");
            }

            @Test
            @TestMetadata(value="ListAndSet.kt")
            public void testListAndSet() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/ListAndSet.kt");
            }

            @Test
            @TestMetadata(value="mapOfPrimitivesFullJdk.kt")
            public void testMapOfPrimitivesFullJdk() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/mapOfPrimitivesFullJdk.kt");
            }

            @Test
            @TestMetadata(value="noStubsForCollection.kt")
            public void testNoStubsForCollection() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForCollection.kt");
            }

            @Test
            @TestMetadata(value="noStubsForMapImplementations.kt")
            public void testNoStubsForMapImplementations() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForMapImplementations.kt");
            }

            @Test
            @TestMetadata(value="noStubsForMutableSetIterators.kt")
            public void testNoStubsForMutableSetIterators() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForMutableSetIterators.kt");
            }

            @Test
            @TestMetadata(value="noStubsForSetIterators.kt")
            public void testNoStubsForSetIterators() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsForSetIterators.kt");
            }

            @Test
            @TestMetadata(value="noStubsInIterable.kt")
            public void testNoStubsInIterable() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInIterable.kt");
            }

            @Test
            @TestMetadata(value="noStubsInJavaSuperClass.kt")
            public void testNoStubsInJavaSuperClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInJavaSuperClass.kt");
            }

            @Test
            @TestMetadata(value="noStubsInMutableIterable.kt")
            public void testNoStubsInMutableIterable() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/noStubsInMutableIterable.kt");
            }

            @Test
            @TestMetadata(value="observableMutableMap.kt")
            public void testObservableMutableMap() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/observableMutableMap.kt");
            }

            @Test
            @TestMetadata(value="stubForAbstractFun.kt")
            public void testStubForAbstractFun() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFun.kt");
            }

            @Test
            @TestMetadata(value="stubForAbstractFunInAbstractClass.kt")
            public void testStubForAbstractFunInAbstractClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunInAbstractClass.kt");
            }

            @Test
            @TestMetadata(value="stubForAbstractFunInAbstractClassWithCovariantOverride.kt")
            public void testStubForAbstractFunInAbstractClassWithCovariantOverride() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunInAbstractClassWithCovariantOverride.kt");
            }

            @Test
            @TestMetadata(value="stubForAbstractFunWithCovariantOverride.kt")
            public void testStubForAbstractFunWithCovariantOverride() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubForAbstractFunWithCovariantOverride.kt");
            }

            @Test
            @TestMetadata(value="stubLikeMethodSignatures.kt")
            public void testStubLikeMethodSignatures() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubLikeMethodSignatures.kt");
            }

            @Test
            @TestMetadata(value="stubsFromSuperclass.kt")
            public void testStubsFromSuperclass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubsFromSuperclass.kt");
            }

            @Test
            @TestMetadata(value="stubsFromSuperclassNoBridges.kt")
            public void testStubsFromSuperclassNoBridges() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/stubsFromSuperclassNoBridges.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/collectionStubs/toArray")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ToArray {
                @Test
                public void testAllFilesPresentInToArray() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="customNonGenericToArray.kt")
                public void testCustomNonGenericToArray() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/customNonGenericToArray.kt");
                }

                @Test
                @TestMetadata(value="internalGenericToArray.kt")
                public void testInternalGenericToArray() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/internalGenericToArray.kt");
                }

                @Test
                @TestMetadata(value="noToArrayInJava.kt")
                public void testNoToArrayInJava() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/toArray/noToArrayInJava.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures")
            @TestDataPath(value="$PROJECT_ROOT")
            public class AbstractStubSignatures {
                @Test
                public void testAllFilesPresentInAbstractStubSignatures() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="byteShortMap.kt")
                public void testByteShortMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/byteShortMap.kt");
                }

                @Test
                @TestMetadata(value="byteShortMutableMap.kt")
                public void testByteShortMutableMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/byteShortMutableMap.kt");
                }

                @Test
                @TestMetadata(value="collection.kt")
                public void testCollection() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/collection.kt");
                }

                @Test
                @TestMetadata(value="genericCollection.kt")
                public void testGenericCollection() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericCollection.kt");
                }

                @Test
                @TestMetadata(value="genericMap.kt")
                public void testGenericMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMap.kt");
                }

                @Test
                @TestMetadata(value="genericMutableCollection.kt")
                public void testGenericMutableCollection() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableCollection.kt");
                }

                @Test
                @TestMetadata(value="genericMutableList.kt")
                public void testGenericMutableList() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableList.kt");
                }

                @Test
                @TestMetadata(value="genericMutableMap.kt")
                public void testGenericMutableMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericMutableMap.kt");
                }

                @Test
                @TestMetadata(value="genericStringMap.kt")
                public void testGenericStringMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericStringMap.kt");
                }

                @Test
                @TestMetadata(value="genericStringMutableMap.kt")
                public void testGenericStringMutableMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/genericStringMutableMap.kt");
                }

                @Test
                @TestMetadata(value="iterable.kt")
                public void testIterable() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/iterable.kt");
                }

                @Test
                @TestMetadata(value="iterator.kt")
                public void testIterator() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/iterator.kt");
                }

                @Test
                @TestMetadata(value="list.kt")
                public void testList() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/list.kt");
                }

                @Test
                @TestMetadata(value="listIterator.kt")
                public void testListIterator() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/listIterator.kt");
                }

                @Test
                @TestMetadata(value="mapEntry.kt")
                public void testMapEntry() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mapEntry.kt");
                }

                @Test
                @TestMetadata(value="mutableCollection.kt")
                public void testMutableCollection() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableCollection.kt");
                }

                @Test
                @TestMetadata(value="mutableIterable.kt")
                public void testMutableIterable() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableIterable.kt");
                }

                @Test
                @TestMetadata(value="mutableIterator.kt")
                public void testMutableIterator() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableIterator.kt");
                }

                @Test
                @TestMetadata(value="mutableList.kt")
                public void testMutableList() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableList.kt");
                }

                @Test
                @TestMetadata(value="mutableListIterator.kt")
                public void testMutableListIterator() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableListIterator.kt");
                }

                @Test
                @TestMetadata(value="mutableMapEntry.kt")
                public void testMutableMapEntry() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/mutableMapEntry.kt");
                }

                @Test
                @TestMetadata(value="numberStringMap.kt")
                public void testNumberStringMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/numberStringMap.kt");
                }

                @Test
                @TestMetadata(value="numberStringMutableMap.kt")
                public void testNumberStringMutableMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/numberStringMutableMap.kt");
                }

                @Test
                @TestMetadata(value="set.kt")
                public void testSet() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/set.kt");
                }

                @Test
                @TestMetadata(value="specializedGenericMap.kt")
                public void testSpecializedGenericMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/specializedGenericMap.kt");
                }

                @Test
                @TestMetadata(value="stringGenericMap.kt")
                public void testStringGenericMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/stringGenericMap.kt");
                }

                @Test
                @TestMetadata(value="stringGenericMutableMap.kt")
                public void testStringGenericMutableMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/collectionStubs/abstractStubSignatures/stringGenericMutableMap.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/callableReference")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CallableReference {
            @Test
            @TestMetadata(value="adaptedReference.kt")
            public void testAdaptedReference() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/callableReference/adaptedReference.kt");
            }

            @Test
            public void testAllFilesPresentInCallableReference() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeListing/annotations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Annotations {
            @Test
            public void testAllFilesPresentInAnnotations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="annotationCtorCallGenerateSynthetic.kt")
            public void testAnnotationCtorCallGenerateSynthetic() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationCtorCallGenerateSynthetic.kt");
            }

            @Test
            @TestMetadata(value="annotationCtorCallNoSynthetic.kt")
            public void testAnnotationCtorCallNoSynthetic() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationCtorCallNoSynthetic.kt");
            }

            @Test
            @TestMetadata(value="annotationsOnDelegatedMembers.kt")
            public void testAnnotationsOnDelegatedMembers() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/annotationsOnDelegatedMembers.kt");
            }

            @Test
            @TestMetadata(value="defaultTargets.kt")
            public void testDefaultTargets() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/defaultTargets.kt");
            }

            @Test
            @TestMetadata(value="deprecatedJvmOverloads.kt")
            public void testDeprecatedJvmOverloads() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/deprecatedJvmOverloads.kt");
            }

            @Test
            @TestMetadata(value="internalPropertyOrTypealias.kt")
            public void testInternalPropertyOrTypealias() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/internalPropertyOrTypealias.kt");
            }

            @Test
            @TestMetadata(value="JvmSynthetic.kt")
            public void testJvmSynthetic() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/JvmSynthetic.kt");
            }

            @Test
            @TestMetadata(value="kt27895.kt")
            public void testKt27895() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/kt27895.kt");
            }

            @Test
            @TestMetadata(value="kt43399.kt")
            public void testKt43399() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/kt43399.kt");
            }

            @Test
            @TestMetadata(value="kt43459.kt")
            public void testKt43459() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/kt43459.kt");
            }

            @Test
            @TestMetadata(value="kt9320.kt")
            public void testKt9320() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/kt9320.kt");
            }

            @Test
            @TestMetadata(value="literals.kt")
            public void testLiterals() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/literals.kt");
            }

            @Test
            @TestMetadata(value="localClassWithCapturedParams.kt")
            public void testLocalClassWithCapturedParams() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/localClassWithCapturedParams.kt");
            }

            @Test
            @TestMetadata(value="noAdditionalAnnotationsInAccessors.kt")
            public void testNoAdditionalAnnotationsInAccessors() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/noAdditionalAnnotationsInAccessors.kt");
            }

            @Test
            @TestMetadata(value="noAnnotationsInSyntheticAccessors.kt")
            public void testNoAnnotationsInSyntheticAccessors() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/noAnnotationsInSyntheticAccessors.kt");
            }

            @Test
            @TestMetadata(value="onProperties.kt")
            public void testOnProperties() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/onProperties.kt");
            }

            @Test
            @TestMetadata(value="onReceiver.kt")
            public void testOnReceiver() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/onReceiver.kt");
            }

            @Test
            @TestMetadata(value="unsignedTypes.kt")
            public void testUnsignedTypes() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/unsignedTypes.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeListing/annotations/repeatable")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Repeatable {
                @Test
                public void testAllFilesPresentInRepeatable() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeListing/annotations/repeatable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="javaAnnotation.kt")
                public void testJavaAnnotation() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/javaAnnotation.kt");
                }

                @Test
                @TestMetadata(value="kotlinAnnotation.kt")
                public void testKotlinAnnotation() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinAnnotation.kt");
                }

                @Test
                @TestMetadata(value="kotlinAnnotationWithBothRepeatables.kt")
                public void testKotlinAnnotationWithBothRepeatables() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinAnnotationWithBothRepeatables.kt");
                }

                @Test
                @TestMetadata(value="kotlinSpecificTargets.kt")
                public void testKotlinSpecificTargets() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/kotlinSpecificTargets.kt");
                }

                @Test
                @TestMetadata(value="multipleRepeatableOrder.kt")
                public void testMultipleRepeatableOrder() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/multipleRepeatableOrder.kt");
                }

                @Test
                @TestMetadata(value="nonRepeatedAnnotationWithItsContainer.kt")
                public void testNonRepeatedAnnotationWithItsContainer() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/nonRepeatedAnnotationWithItsContainer.kt");
                }

                @Test
                @TestMetadata(value="propertyGetterUseSiteTarget.kt")
                public void testPropertyGetterUseSiteTarget() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/propertyGetterUseSiteTarget.kt");
                }

                @Test
                @TestMetadata(value="retentionAndTarget.kt")
                public void testRetentionAndTarget() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeListing/annotations/repeatable/retentionAndTarget.kt");
                }
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText")
    @TestDataPath(value="$PROJECT_ROOT")
    public class BytecodeText {
        @Test
        @TestMetadata(value="accessorForOverridenVal.kt")
        public void testAccessorForOverridenVal() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/accessorForOverridenVal.kt");
        }

        @Test
        @TestMetadata(value="accessorForProtected.kt")
        public void testAccessorForProtected() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/accessorForProtected.kt");
        }

        @Test
        @TestMetadata(value="accessorNaming.kt")
        public void testAccessorNaming() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/accessorNaming.kt");
        }

        @Test
        public void testAllFilesPresentInBytecodeText() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="annotationDefaultValue.kt")
        public void testAnnotationDefaultValue() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/annotationDefaultValue.kt");
        }

        @Test
        @TestMetadata(value="annotationDefaultValueOfUnsigned.kt")
        public void testAnnotationDefaultValueOfUnsigned() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/annotationDefaultValueOfUnsigned.kt");
        }

        @Test
        @TestMetadata(value="annotationJavaRetentionPolicyRuntime.kt")
        public void testAnnotationJavaRetentionPolicyRuntime() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/annotationJavaRetentionPolicyRuntime.kt");
        }

        @Test
        @TestMetadata(value="annotationRetentionPolicyClass.kt")
        public void testAnnotationRetentionPolicyClass() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyClass.kt");
        }

        @Test
        @TestMetadata(value="annotationRetentionPolicyRuntime.kt")
        public void testAnnotationRetentionPolicyRuntime() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyRuntime.kt");
        }

        @Test
        @TestMetadata(value="annotationRetentionPolicySource.kt")
        public void testAnnotationRetentionPolicySource() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicySource.kt");
        }

        @Test
        @TestMetadata(value="boxedNotNumberTypeOnUnboxing.kt")
        public void testBoxedNotNumberTypeOnUnboxing() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxedNotNumberTypeOnUnboxing.kt");
        }

        @Test
        @TestMetadata(value="bridgeForFakeOverride.kt")
        public void testBridgeForFakeOverride() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/bridgeForFakeOverride.kt");
        }

        @Test
        @TestMetadata(value="charConstant.kt")
        public void testCharConstant() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/charConstant.kt");
        }

        @Test
        @TestMetadata(value="checkcastOnThrow.kt")
        public void testCheckcastOnThrow() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcastOnThrow.kt");
        }

        @Test
        @TestMetadata(value="collectionStubs.kt")
        public void testCollectionStubs() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/collectionStubs.kt");
        }

        @Test
        @TestMetadata(value="componentEvaluatesOnlyOnce.kt")
        public void testComponentEvaluatesOnlyOnce() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/componentEvaluatesOnlyOnce.kt");
        }

        @Test
        @TestMetadata(value="constClosureOptimization.kt")
        public void testConstClosureOptimization() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constClosureOptimization.kt");
        }

        @Test
        @TestMetadata(value="defaultMethodBody.kt")
        public void testDefaultMethodBody() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultMethodBody.kt");
        }

        @Test
        @TestMetadata(value="doNotStoreNullForTmpInDestructuring.kt")
        public void testDoNotStoreNullForTmpInDestructuring() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/doNotStoreNullForTmpInDestructuring.kt");
        }

        @Test
        @TestMetadata(value="doNotStoreNullsForCapturedVars.kt")
        public void testDoNotStoreNullsForCapturedVars() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/doNotStoreNullsForCapturedVars.kt");
        }

        @Test
        @TestMetadata(value="falseSmartCast.kt")
        public void testFalseSmartCast() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/falseSmartCast.kt");
        }

        @Test
        @TestMetadata(value="flagsInMultiFileInherit.kt")
        public void testFlagsInMultiFileInherit() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/flagsInMultiFileInherit.kt");
        }

        @Test
        @TestMetadata(value="iincGeneration.kt")
        public void testIincGeneration() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/iincGeneration.kt");
        }

        @Test
        @TestMetadata(value="inheritedPropertyAnnotations.kt")
        public void testInheritedPropertyAnnotations() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inheritedPropertyAnnotations.kt");
        }

        @Test
        @TestMetadata(value="inlineFromOtherModule.kt")
        public void testInlineFromOtherModule() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineFromOtherModule.kt");
        }

        @Test
        @TestMetadata(value="inlineJavaConstantFromSubclass.kt")
        public void testInlineJavaConstantFromSubclass() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineJavaConstantFromSubclass.kt");
        }

        @Test
        @TestMetadata(value="inlineJavaStaticFields.kt")
        public void testInlineJavaStaticFields() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineJavaStaticFields.kt");
        }

        @Test
        @TestMetadata(value="inlineProtectedJavaConstantFromOtherPackage.kt")
        public void testInlineProtectedJavaConstantFromOtherPackage() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineProtectedJavaConstantFromOtherPackage.kt");
        }

        @Test
        @TestMetadata(value="intConstantNotNull.kt")
        public void testIntConstantNotNull() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intConstantNotNull.kt");
        }

        @Test
        @TestMetadata(value="intConstantNullable.kt")
        public void testIntConstantNullable() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intConstantNullable.kt");
        }

        @Test
        @TestMetadata(value="intConstantNullableSafeCall.kt")
        public void testIntConstantNullableSafeCall() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intConstantNullableSafeCall.kt");
        }

        @Test
        @TestMetadata(value="intConstantSafeCall.kt")
        public void testIntConstantSafeCall() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intConstantSafeCall.kt");
        }

        @Test
        @TestMetadata(value="intProgressionNoBoxing.kt")
        public void testIntProgressionNoBoxing() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intProgressionNoBoxing.kt");
        }

        @Test
        @TestMetadata(value="intRangeNoBoxing.kt")
        public void testIntRangeNoBoxing() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intRangeNoBoxing.kt");
        }

        @Test
        @TestMetadata(value="interfaceDefaultImpl.kt")
        public void testInterfaceDefaultImpl() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaceDefaultImpl.kt");
        }

        @Test
        @TestMetadata(value="isArrayOf.kt")
        public void testIsArrayOf() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/isArrayOf.kt");
        }

        @Test
        @TestMetadata(value="javaExtensionPropertyIntrinsic.kt")
        public void testJavaExtensionPropertyIntrinsic() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/javaExtensionPropertyIntrinsic.kt");
        }

        @Test
        @TestMetadata(value="javaFields.kt")
        public void testJavaFields() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/javaFields.kt");
        }

        @Test
        @TestMetadata(value="javaFieldsWithIntersectionTypes.kt")
        public void testJavaFieldsWithIntersectionTypes() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/javaFieldsWithIntersectionTypes.kt");
        }

        @Test
        @TestMetadata(value="javaFieldsWithIntersectionTypes_k1.kt")
        public void testJavaFieldsWithIntersectionTypes_k1() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/javaFieldsWithIntersectionTypes_k1.kt");
        }

        @Test
        @TestMetadata(value="javaFields_k1.kt")
        public void testJavaFields_k1() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/javaFields_k1.kt");
        }

        @Test
        @TestMetadata(value="javaStatics.kt")
        public void testJavaStatics() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/javaStatics.kt");
        }

        @Test
        @TestMetadata(value="jvmField.kt")
        public void testJvmField() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvmField.kt");
        }

        @Test
        @TestMetadata(value="jvmStaticInternalMangling.kt")
        public void testJvmStaticInternalMangling() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvmStaticInternalMangling.kt");
        }

        @Test
        @TestMetadata(value="kt10259.kt")
        public void testKt10259() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt10259.kt");
        }

        @Test
        @TestMetadata(value="kt10259_2.kt")
        public void testKt10259_2() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt10259_2.kt");
        }

        @Test
        @TestMetadata(value="kt10259_3.kt")
        public void testKt10259_3() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt10259_3.kt");
        }

        @Test
        @TestMetadata(value="kt2202.kt")
        public void testKt2202() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt2202.kt");
        }

        @Test
        @TestMetadata(value="kt2887.kt")
        public void testKt2887() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt2887.kt");
        }

        @Test
        @TestMetadata(value="kt3845.kt")
        public void testKt3845() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt3845.kt");
        }

        @Test
        @TestMetadata(value="kt46615.kt")
        public void testKt46615() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt46615.kt");
        }

        @Test
        @TestMetadata(value="kt48367.kt")
        public void testKt48367() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt48367.kt");
        }

        @Test
        @TestMetadata(value="kt5016.kt")
        public void testKt5016() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt5016.kt");
        }

        @Test
        @TestMetadata(value="kt5016int.kt")
        public void testKt5016int() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt5016int.kt");
        }

        @Test
        @TestMetadata(value="kt5016intOrNull.kt")
        public void testKt5016intOrNull() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt5016intOrNull.kt");
        }

        @Test
        @TestMetadata(value="kt56923.kt")
        public void testKt56923() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt56923.kt");
        }

        @Test
        @TestMetadata(value="kt7188.kt")
        public void testKt7188() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt7188.kt");
        }

        @Test
        @TestMetadata(value="kt7769.kt")
        public void testKt7769() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt7769.kt");
        }

        @Test
        @TestMetadata(value="kt9603.kt")
        public void testKt9603() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/kt9603.kt");
        }

        @Test
        @TestMetadata(value="mapGetOrDefault.kt")
        public void testMapGetOrDefault() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/mapGetOrDefault.kt");
        }

        @Test
        @TestMetadata(value="maxStackAfterOptimizations.kt")
        public void testMaxStackAfterOptimizations() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/maxStackAfterOptimizations.kt");
        }

        @Test
        @TestMetadata(value="mergedProgression.kt")
        public void testMergedProgression() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/mergedProgression.kt");
        }

        @Test
        @TestMetadata(value="noAccessorForProtectedInSamePackageCrossinline.kt")
        public void testNoAccessorForProtectedInSamePackageCrossinline() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/noAccessorForProtectedInSamePackageCrossinline.kt");
        }

        @Test
        @TestMetadata(value="noAccessorForProtectedInSamePackagePrivateInline.kt")
        public void testNoAccessorForProtectedInSamePackagePrivateInline() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/noAccessorForProtectedInSamePackagePrivateInline.kt");
        }

        @Test
        @TestMetadata(value="noFlagAnnotations.kt")
        public void testNoFlagAnnotations() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/noFlagAnnotations.kt");
        }

        @Test
        @TestMetadata(value="noNumberCheckCast.kt")
        public void testNoNumberCheckCast() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/noNumberCheckCast.kt");
        }

        @Test
        @TestMetadata(value="noSuperCheckInDefaultConstuctor.kt")
        public void testNoSuperCheckInDefaultConstuctor() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/noSuperCheckInDefaultConstuctor.kt");
        }

        @Test
        @TestMetadata(value="noSyntheticAccessorForPrivateCompanionObjectWhenNotRequired.kt")
        public void testNoSyntheticAccessorForPrivateCompanionObjectWhenNotRequired() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/noSyntheticAccessorForPrivateCompanionObjectWhenNotRequired.kt");
        }

        @Test
        @TestMetadata(value="noWrapperForMethodReturningPrimitive.kt")
        public void testNoWrapperForMethodReturningPrimitive() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/noWrapperForMethodReturningPrimitive.kt");
        }

        @Test
        @TestMetadata(value="nopsInDoWhile.kt")
        public void testNopsInDoWhile() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nopsInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="partMembersCall.kt")
        public void testPartMembersCall() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/partMembersCall.kt");
        }

        @Test
        @TestMetadata(value="partMembersInline.kt")
        public void testPartMembersInline() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/partMembersInline.kt");
        }

        @Test
        @TestMetadata(value="preEvaluateInlineJavaStaticFields.kt")
        public void testPreEvaluateInlineJavaStaticFields() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/preEvaluateInlineJavaStaticFields.kt");
        }

        @Test
        @TestMetadata(value="prefixIntVarIncrement.kt")
        public void testPrefixIntVarIncrement() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/prefixIntVarIncrement.kt");
        }

        @Test
        @TestMetadata(value="privateDefaultArgs.kt")
        public void testPrivateDefaultArgs() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/privateDefaultArgs.kt");
        }

        @Test
        @TestMetadata(value="redundantGotoRemoving.kt")
        public void testRedundantGotoRemoving() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/redundantGotoRemoving.kt");
        }

        @Test
        @TestMetadata(value="redundantInitializer.kt")
        public void testRedundantInitializer() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/redundantInitializer.kt");
        }

        @Test
        @TestMetadata(value="redundantInitializerNumber.kt")
        public void testRedundantInitializerNumber() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/redundantInitializerNumber.kt");
        }

        @Test
        @TestMetadata(value="redundantValInitializer.kt")
        public void testRedundantValInitializer() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/redundantValInitializer.kt");
        }

        @Test
        @TestMetadata(value="redundantValInitializerInObject.kt")
        public void testRedundantValInitializerInObject() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/redundantValInitializerInObject.kt");
        }

        @Test
        @TestMetadata(value="redundantVarInitializer.kt")
        public void testRedundantVarInitializer() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/redundantVarInitializer.kt");
        }

        @Test
        @TestMetadata(value="redundantVarInitializerInObject.kt")
        public void testRedundantVarInitializerInObject() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/redundantVarInitializerInObject.kt");
        }

        @Test
        @TestMetadata(value="reifiedAsCheck.kt")
        public void testReifiedAsCheck() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/reifiedAsCheck.kt");
        }

        @Test
        @TestMetadata(value="reifiedAsCheckWithNullable.kt")
        public void testReifiedAsCheckWithNullable() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/reifiedAsCheckWithNullable.kt");
        }

        @Test
        @TestMetadata(value="reifiedIsCheck.kt")
        public void testReifiedIsCheck() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/reifiedIsCheck.kt");
        }

        @Test
        @TestMetadata(value="reifiedIsCheckWithNullable.kt")
        public void testReifiedIsCheckWithNullable() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/reifiedIsCheckWithNullable.kt");
        }

        @Test
        @TestMetadata(value="reifiedSafeAsCheck.kt")
        public void testReifiedSafeAsCheck() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/reifiedSafeAsCheck.kt");
        }

        @Test
        @TestMetadata(value="safeAsWithMutable.kt")
        public void testSafeAsWithMutable() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/safeAsWithMutable.kt");
        }

        @Test
        @TestMetadata(value="superFlagInMultiFileFacade.kt")
        public void testSuperFlagInMultiFileFacade() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/superFlagInMultiFileFacade.kt");
        }

        @Test
        @TestMetadata(value="superToString.kt")
        public void testSuperToString() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/superToString.kt");
        }

        @Test
        @TestMetadata(value="suspendCoroutineUninterceptedOrReturn.kt")
        public void testSuspendCoroutineUninterceptedOrReturn() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/suspendCoroutineUninterceptedOrReturn.kt");
        }

        @Test
        @TestMetadata(value="topLevelFunWithDefaultArgs.kt")
        public void testTopLevelFunWithDefaultArgs() throws Exception {
            JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/topLevelFunWithDefaultArgs.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/whenStringOptimization")
        @TestDataPath(value="$PROJECT_ROOT")
        public class WhenStringOptimization {
            @Test
            public void testAllFilesPresentInWhenStringOptimization() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenStringOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="denseHashCode.kt")
            public void testDenseHashCode() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/denseHashCode.kt");
            }

            @Test
            @TestMetadata(value="duplicatingItems.kt")
            public void testDuplicatingItems() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItems.kt");
            }

            @Test
            @TestMetadata(value="duplicatingItemsSameHashCodeFewBranches.kt")
            public void testDuplicatingItemsSameHashCodeFewBranches() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItemsSameHashCodeFewBranches.kt");
            }

            @Test
            @TestMetadata(value="duplicatingItemsSameHashCodeMoreBranches.kt")
            public void testDuplicatingItemsSameHashCodeMoreBranches() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItemsSameHashCodeMoreBranches.kt");
            }

            @Test
            @TestMetadata(value="expression.kt")
            public void testExpression() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/expression.kt");
            }

            @Test
            @TestMetadata(value="inlineStringConstInsideWhen.kt")
            public void testInlineStringConstInsideWhen() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/inlineStringConstInsideWhen.kt");
            }

            @Test
            @TestMetadata(value="nullability.kt")
            public void testNullability() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/nullability.kt");
            }

            @Test
            @TestMetadata(value="sameHashCode.kt")
            public void testSameHashCode() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/sameHashCode.kt");
            }

            @Test
            @TestMetadata(value="statement.kt")
            public void testStatement() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/statement.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/whenEnumOptimization")
        @TestDataPath(value="$PROJECT_ROOT")
        public class WhenEnumOptimization {
            @Test
            public void testAllFilesPresentInWhenEnumOptimization() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenEnumOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="bigEnum.kt")
            public void testBigEnum() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/bigEnum.kt");
            }

            @Test
            @TestMetadata(value="differentEnumClasses.kt")
            public void testDifferentEnumClasses() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/differentEnumClasses.kt");
            }

            @Test
            @TestMetadata(value="differentEnumClasses2.kt")
            public void testDifferentEnumClasses2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/differentEnumClasses2.kt");
            }

            @Test
            @TestMetadata(value="duplicatingItems.kt")
            public void testDuplicatingItems() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/duplicatingItems.kt");
            }

            @Test
            @TestMetadata(value="expression.kt")
            public void testExpression() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/expression.kt");
            }

            @Test
            @TestMetadata(value="functionLiteralInTopLevel.kt")
            public void testFunctionLiteralInTopLevel() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/functionLiteralInTopLevel.kt");
            }

            @Test
            @TestMetadata(value="importedEnumEntry.kt")
            public void testImportedEnumEntry() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/importedEnumEntry.kt");
            }

            @Test
            @TestMetadata(value="kt14597_full.kt")
            public void testKt14597_full() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt14597_full.kt");
            }

            @Test
            @TestMetadata(value="kt14802.kt")
            public void testKt14802() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt14802.kt");
            }

            @Test
            @TestMetadata(value="manyWhensWithinClass.kt")
            public void testManyWhensWithinClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/manyWhensWithinClass.kt");
            }

            @Test
            @TestMetadata(value="nestedWhenInCondition.kt")
            public void testNestedWhenInCondition() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nestedWhenInCondition.kt");
            }

            @Test
            @TestMetadata(value="nonConstantEnum.kt")
            public void testNonConstantEnum() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nonConstantEnum.kt");
            }

            @Test
            @TestMetadata(value="nullability.kt")
            public void testNullability() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nullability.kt");
            }

            @Test
            @TestMetadata(value="subjectAny.kt")
            public void testSubjectAny() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/subjectAny.kt");
            }

            @Test
            @TestMetadata(value="whenOr.kt")
            public void testWhenOr() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/whenOr.kt");
            }

            @Test
            @TestMetadata(value="withoutElse.kt")
            public void testWithoutElse() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/withoutElse.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/when")
        @TestDataPath(value="$PROJECT_ROOT")
        public class When {
            @Test
            public void testAllFilesPresentInWhen() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/when"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="edgeCases.kt")
            public void testEdgeCases() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/edgeCases.kt");
            }

            @Test
            @TestMetadata(value="exhaustiveWhenInitialization.kt")
            public void testExhaustiveWhenInitialization() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenInitialization.kt");
            }

            @Test
            @TestMetadata(value="exhaustiveWhenReturn.kt")
            public void testExhaustiveWhenReturn() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenReturn.kt");
            }

            @Test
            @TestMetadata(value="exhaustiveWhenSpecialCases.kt")
            public void testExhaustiveWhenSpecialCases() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenSpecialCases.kt");
            }

            @Test
            @TestMetadata(value="exhaustiveWhenUnit.kt")
            public void testExhaustiveWhenUnit() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnit.kt");
            }

            @Test
            @TestMetadata(value="exhaustiveWhenUnitStatement.kt")
            public void testExhaustiveWhenUnitStatement() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnitStatement.kt");
            }

            @Test
            @TestMetadata(value="inlineConstValsInsideWhen.kt")
            public void testInlineConstValsInsideWhen() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/inlineConstValsInsideWhen.kt");
            }

            @Test
            @TestMetadata(value="integralWhenWithNoInlinedConstants.kt")
            public void testIntegralWhenWithNoInlinedConstants() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/integralWhenWithNoInlinedConstants.kt");
            }

            @Test
            @TestMetadata(value="kt18818.kt")
            public void testKt18818() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/kt18818.kt");
            }

            @Test
            @TestMetadata(value="lookupSwitch.kt")
            public void testLookupSwitch() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/lookupSwitch.kt");
            }

            @Test
            @TestMetadata(value="lookupSwitchWithSubjectVal.kt")
            public void testLookupSwitchWithSubjectVal() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/lookupSwitchWithSubjectVal.kt");
            }

            @Test
            @TestMetadata(value="noBoxingInDefaultWhenWithSpecialCases.kt")
            public void testNoBoxingInDefaultWhenWithSpecialCases() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/noBoxingInDefaultWhenWithSpecialCases.kt");
            }

            @Test
            @TestMetadata(value="qualifiedConstValsInsideWhen.kt")
            public void testQualifiedConstValsInsideWhen() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/qualifiedConstValsInsideWhen.kt");
            }

            @Test
            @TestMetadata(value="sealedWhenInitialization.kt")
            public void testSealedWhenInitialization() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/sealedWhenInitialization.kt");
            }

            @Test
            @TestMetadata(value="simpleConstValsInsideWhen.kt")
            public void testSimpleConstValsInsideWhen() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/simpleConstValsInsideWhen.kt");
            }

            @Test
            @TestMetadata(value="stringSwitchWithSubjectVal.kt")
            public void testStringSwitchWithSubjectVal() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/stringSwitchWithSubjectVal.kt");
            }

            @Test
            @TestMetadata(value="subjectValHasLocalVariableSlot.kt")
            public void testSubjectValHasLocalVariableSlot() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValHasLocalVariableSlot.kt");
            }

            @Test
            @TestMetadata(value="subjectValInEnumWhenHasLocalVariableSlot.kt")
            public void testSubjectValInEnumWhenHasLocalVariableSlot() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValInEnumWhenHasLocalVariableSlot.kt");
            }

            @Test
            @TestMetadata(value="subjectValInIntWhenHasLocalVariableSlot.kt")
            public void testSubjectValInIntWhenHasLocalVariableSlot() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValInIntWhenHasLocalVariableSlot.kt");
            }

            @Test
            @TestMetadata(value="subjectValInStringWhenHasLocalVariableSlot.kt")
            public void testSubjectValInStringWhenHasLocalVariableSlot() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValInStringWhenHasLocalVariableSlot.kt");
            }

            @Test
            @TestMetadata(value="switchOptimizationDuplicates.kt")
            public void testSwitchOptimizationDuplicates() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/switchOptimizationDuplicates.kt");
            }

            @Test
            @TestMetadata(value="tableSwitch.kt")
            public void testTableSwitch() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/tableSwitch.kt");
            }

            @Test
            @TestMetadata(value="tableSwitchWithSubjectVal.kt")
            public void testTableSwitchWithSubjectVal() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/tableSwitchWithSubjectVal.kt");
            }

            @Test
            @TestMetadata(value="whenNull.kt")
            public void testWhenNull() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/whenNull.kt");
            }

            @Test
            @TestMetadata(value="whenZero.kt")
            public void testWhenZero() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/whenZero.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/varargs")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Varargs {
            @Test
            public void testAllFilesPresentInVarargs() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/varargs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="doNotCopyImmediatelyCreatedArrays.kt")
            public void testDoNotCopyImmediatelyCreatedArrays() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/varargs/doNotCopyImmediatelyCreatedArrays.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/valueClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ValueClasses {
            @Test
            public void testAllFilesPresentInValueClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/valueClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="conditionalExpressions.kt")
            public void testConditionalExpressions() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/conditionalExpressions.kt");
            }

            @Test
            @TestMetadata(value="equalsBoxTest.kt")
            public void testEqualsBoxTest() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/equalsBoxTest.kt");
            }

            @Test
            @TestMetadata(value="mfvcDeclaration.kt")
            public void testMfvcDeclaration() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/mfvcDeclaration.kt");
            }

            @Test
            @TestMetadata(value="mfvcReassignments.kt")
            public void testMfvcReassignments() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/mfvcReassignments.kt");
            }

            @Test
            @TestMetadata(value="passingMFVC2Functions.kt")
            public void testPassingMFVC2Functions() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/passingMFVC2Functions.kt");
            }

            @Test
            @TestMetadata(value="regularClassWithMFVC.kt")
            public void testRegularClassWithMFVC() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/regularClassWithMFVC.kt");
            }

            @Test
            @TestMetadata(value="tryExpressions.kt")
            public void testTryExpressions() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/tryExpressions.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/unsignedTypes")
        @TestDataPath(value="$PROJECT_ROOT")
        public class UnsignedTypes {
            @Test
            public void testAllFilesPresentInUnsignedTypes() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/unsignedTypes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="unsignedIntCompare_jvm18.kt")
            public void testUnsignedIntCompare_jvm18() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntCompare_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedIntDivide_jvm18.kt")
            public void testUnsignedIntDivide_jvm18() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntDivide_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedIntRemainder_jvm18.kt")
            public void testUnsignedIntRemainder_jvm18() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntRemainder_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedIntSmartCasts_jvm18.kt")
            public void testUnsignedIntSmartCasts_jvm18() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntSmartCasts_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedIntToString_jvm18.kt")
            public void testUnsignedIntToString_jvm18() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntToString_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedLongCompare_jvm18.kt")
            public void testUnsignedLongCompare_jvm18() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongCompare_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedLongDivide_jvm18.kt")
            public void testUnsignedLongDivide_jvm18() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongDivide_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedLongRemainder_jvm18.kt")
            public void testUnsignedLongRemainder_jvm18() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongRemainder_jvm18.kt");
            }

            @Test
            @TestMetadata(value="unsignedLongToString_jvm18.kt")
            public void testUnsignedLongToString_jvm18() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongToString_jvm18.kt");
            }

            @Test
            @TestMetadata(value="whenByUnsigned.kt")
            public void testWhenByUnsigned() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/whenByUnsigned.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/toArray")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ToArray {
            @Test
            public void testAllFilesPresentInToArray() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/toArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="noAccessorForToArray.kt")
            public void testNoAccessorForToArray() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/toArray/noAccessorForToArray.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/temporaryVals")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TemporaryVals {
            @Test
            public void testAllFilesPresentInTemporaryVals() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/temporaryVals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayCompoundAssignment.kt")
            public void testArrayCompoundAssignment() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/arrayCompoundAssignment.kt");
            }

            @Test
            @TestMetadata(value="elvisChain.kt")
            public void testElvisChain() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/elvisChain.kt");
            }

            @Test
            @TestMetadata(value="noTemporaryInCheckedCast.kt")
            public void testNoTemporaryInCheckedCast() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/noTemporaryInCheckedCast.kt");
            }

            @Test
            @TestMetadata(value="notNullReceiversInChain.kt")
            public void testNotNullReceiversInChain() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/notNullReceiversInChain.kt");
            }

            @Test
            @TestMetadata(value="safeCallChain1.kt")
            public void testSafeCallChain1() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChain1.kt");
            }

            @Test
            @TestMetadata(value="safeCallChain2.kt")
            public void testSafeCallChain2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChain2.kt");
            }

            @Test
            @TestMetadata(value="safeCallChainMemberExt1.kt")
            public void testSafeCallChainMemberExt1() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChainMemberExt1.kt");
            }

            @Test
            @TestMetadata(value="safeCallChainMemberExt2.kt")
            public void testSafeCallChainMemberExt2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChainMemberExt2.kt");
            }

            @Test
            @TestMetadata(value="safeCallElvisSafeCallElvisSomething.kt")
            public void testSafeCallElvisSafeCallElvisSomething() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallElvisSafeCallElvisSomething.kt");
            }

            @Test
            @TestMetadata(value="safeCallWithElvis.kt")
            public void testSafeCallWithElvis() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallWithElvis.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/stringOperations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class StringOperations {
            @Test
            public void testAllFilesPresentInStringOperations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/stringOperations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="concat.kt")
            public void testConcat() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concat.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic.kt")
            public void testConcatDynamic() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic199.kt")
            public void testConcatDynamic199() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic199.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic200.kt")
            public void testConcatDynamic200() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic200.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic201.kt")
            public void testConcatDynamic201() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic201.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicConstants.kt")
            public void testConcatDynamicConstants() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicConstants.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicDataClass.kt")
            public void testConcatDynamicDataClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicDataClass.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicIndy.kt")
            public void testConcatDynamicIndy() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndy.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicIndy201.kt")
            public void testConcatDynamicIndy201() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndy201.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicIndyDataClass.kt")
            public void testConcatDynamicIndyDataClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndyDataClass.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicSpecialSymbols.kt")
            public void testConcatDynamicSpecialSymbols() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicSpecialSymbols.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicUnit.kt")
            public void testConcatDynamicUnit() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicUnit.kt");
            }

            @Test
            @TestMetadata(value="concatNotDynamic.kt")
            public void testConcatNotDynamic() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatNotDynamic.kt");
            }

            @Test
            @TestMetadata(value="constConcat.kt")
            public void testConstConcat() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/constConcat.kt");
            }

            @Test
            @TestMetadata(value="constValConcat.kt")
            public void testConstValConcat() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/constValConcat.kt");
            }

            @Test
            @TestMetadata(value="doNotAppendEmptyString.kt")
            public void testDoNotAppendEmptyString() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/doNotAppendEmptyString.kt");
            }

            @Test
            @TestMetadata(value="interpolation.kt")
            public void testInterpolation() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/interpolation.kt");
            }

            @Test
            @TestMetadata(value="kt15235.kt")
            public void testKt15235() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt15235.kt");
            }

            @Test
            @TestMetadata(value="kt19037.kt")
            public void testKt19037() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt19037.kt");
            }

            @Test
            @TestMetadata(value="kt42457_old.kt")
            public void testKt42457_old() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt42457_old.kt");
            }

            @Test
            @TestMetadata(value="multipleNestedConcat.kt")
            public void testMultipleNestedConcat() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/multipleNestedConcat.kt");
            }

            @Test
            @TestMetadata(value="nestedConcat.kt")
            public void testNestedConcat() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/nestedConcat.kt");
            }

            @Test
            @TestMetadata(value="nonNullableStringPlus.kt")
            public void testNonNullableStringPlus() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/nonNullableStringPlus.kt");
            }

            @Test
            @TestMetadata(value="nullableStringPlus.kt")
            public void testNullableStringPlus() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/nullableStringPlus.kt");
            }

            @Test
            @TestMetadata(value="partiallyConstConcat.kt")
            public void testPartiallyConstConcat() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/partiallyConstConcat.kt");
            }

            @Test
            @TestMetadata(value="plusAssign.kt")
            public void testPlusAssign() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/plusAssign.kt");
            }

            @Test
            @TestMetadata(value="primitiveToString.kt")
            public void testPrimitiveToString() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitiveToString.kt");
            }

            @Test
            @TestMetadata(value="primitiveToStringNotOptimizable.kt")
            public void testPrimitiveToStringNotOptimizable() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitiveToStringNotOptimizable.kt");
            }

            @Test
            @TestMetadata(value="primitivesAsStringTemplates.kt")
            public void testPrimitivesAsStringTemplates() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitivesAsStringTemplates.kt");
            }

            @Test
            @TestMetadata(value="singleConcat.kt")
            public void testSingleConcat() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/singleConcat.kt");
            }

            @Test
            @TestMetadata(value="stringBuilderToString.kt")
            public void testStringBuilderToString() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/stringBuilderToString.kt");
            }

            @Test
            @TestMetadata(value="stringPlus.kt")
            public void testStringPlus() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/stringPlus.kt");
            }

            @Test
            @TestMetadata(value="useAppendCharForOneCharStringInTemplate.kt")
            public void testUseAppendCharForOneCharStringInTemplate() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringInTemplate.kt");
            }

            @Test
            @TestMetadata(value="useAppendCharForOneCharStringInTemplate_2.kt")
            public void testUseAppendCharForOneCharStringInTemplate_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringInTemplate_2.kt");
            }

            @Test
            @TestMetadata(value="useAppendCharForOneCharStringUsingPlus.kt")
            public void testUseAppendCharForOneCharStringUsingPlus() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringUsingPlus.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/storeStackBeforeInline")
        @TestDataPath(value="$PROJECT_ROOT")
        public class StoreStackBeforeInline {
            @Test
            public void testAllFilesPresentInStoreStackBeforeInline() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/storeStackBeforeInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayConstructor.kt")
            public void testArrayConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/arrayConstructor.kt");
            }

            @Test
            @TestMetadata(value="differentTypes.kt")
            public void testDifferentTypes() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/differentTypes.kt");
            }

            @Test
            @TestMetadata(value="primitiveMerge.kt")
            public void testPrimitiveMerge() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/primitiveMerge.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/simple.kt");
            }

            @Test
            @TestMetadata(value="unreachableMarker.kt")
            public void testUnreachableMarker() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/unreachableMarker.kt");
            }

            @Test
            @TestMetadata(value="withLambda.kt")
            public void testWithLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/withLambda.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/staticFields")
        @TestDataPath(value="$PROJECT_ROOT")
        public class StaticFields {
            @Test
            public void testAllFilesPresentInStaticFields() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/staticFields"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classObject.kt")
            public void testClassObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/staticFields/classObject.kt");
            }

            @Test
            @TestMetadata(value="object.kt")
            public void testObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/staticFields/object.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/statements")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Statements {
            @Test
            public void testAllFilesPresentInStatements() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/statements"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="ifSingleBranch.kt")
            public void testIfSingleBranch() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/ifSingleBranch.kt");
            }

            @Test
            @TestMetadata(value="ifThenElse.kt")
            public void testIfThenElse() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/ifThenElse.kt");
            }

            @Test
            @TestMetadata(value="ifThenElseEmpty.kt")
            public void testIfThenElseEmpty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/ifThenElseEmpty.kt");
            }

            @Test
            @TestMetadata(value="labeled.kt")
            public void testLabeled() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/labeled.kt");
            }

            @Test
            @TestMetadata(value="statementsComposition.kt")
            public void testStatementsComposition() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/statementsComposition.kt");
            }

            @Test
            @TestMetadata(value="tryCatchFinally.kt")
            public void testTryCatchFinally() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/tryCatchFinally.kt");
            }

            @Test
            @TestMetadata(value="when.kt")
            public void testWhen() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/when.kt");
            }

            @Test
            @TestMetadata(value="whenSubject.kt")
            public void testWhenSubject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/whenSubject.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/sam")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Sam {
            @Test
            public void testAllFilesPresentInSam() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="samWrapperForNullInitialization.kt")
            public void testSamWrapperForNullInitialization() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperForNullInitialization.kt");
            }

            @Test
            @TestMetadata(value="samWrapperForNullableInitialization.kt")
            public void testSamWrapperForNullableInitialization() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperForNullableInitialization.kt");
            }

            @Test
            @TestMetadata(value="samWrapperInInlineLambda.kt")
            public void testSamWrapperInInlineLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperInInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="samWrapperInInlineLambda2.kt")
            public void testSamWrapperInInlineLambda2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperInInlineLambda2.kt");
            }

            @Test
            @TestMetadata(value="samWrapperOfLambda.kt")
            public void testSamWrapperOfLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperOfLambda.kt");
            }

            @Test
            @TestMetadata(value="samWrapperOfReference.kt")
            public void testSamWrapperOfReference() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperOfReference.kt");
            }

            @Test
            @TestMetadata(value="samWrapperRawTypes.kt")
            public void testSamWrapperRawTypes() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperRawTypes.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/ranges")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Ranges {
            @Test
            public void testAllFilesPresentInRanges() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ranges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="ifNotInRange.kt")
            public void testIfNotInRange() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/ifNotInRange.kt");
            }

            @Test
            @TestMetadata(value="inArrayIndices.kt")
            public void testInArrayIndices() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inArrayIndices.kt");
            }

            @Test
            @TestMetadata(value="inCharSequenceIndices.kt")
            public void testInCharSequenceIndices() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inCharSequenceIndices.kt");
            }

            @Test
            @TestMetadata(value="inCollectionIndices.kt")
            public void testInCollectionIndices() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inCollectionIndices.kt");
            }

            @Test
            @TestMetadata(value="inComparableRangeLiteral.kt")
            public void testInComparableRangeLiteral() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inComparableRangeLiteral.kt");
            }

            @Test
            @TestMetadata(value="inMixedUnsignedRange.kt")
            public void testInMixedUnsignedRange() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inMixedUnsignedRange.kt");
            }

            @Test
            @TestMetadata(value="inMixedUnsignedRange_2.kt")
            public void testInMixedUnsignedRange_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inMixedUnsignedRange_2.kt");
            }

            @Test
            @TestMetadata(value="inNonMatchingRangeIntrinsified.kt")
            public void testInNonMatchingRangeIntrinsified() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inNonMatchingRangeIntrinsified.kt");
            }

            @Test
            @TestMetadata(value="inOptimizableRange.kt")
            public void testInOptimizableRange() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inOptimizableRange.kt");
            }

            @Test
            @TestMetadata(value="inOptimizableUnsignedRange.kt")
            public void testInOptimizableUnsignedRange() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inOptimizableUnsignedRange.kt");
            }

            @Test
            @TestMetadata(value="inRangeUntil.kt")
            public void testInRangeUntil() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inRangeUntil.kt");
            }

            @Test
            @TestMetadata(value="inUntil.kt")
            public void testInUntil() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inUntil.kt");
            }

            @Test
            @TestMetadata(value="noDupXForLiteralRangeContains.kt")
            public void testNoDupXForLiteralRangeContains() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/noDupXForLiteralRangeContains.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/properties")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Properties {
            @Test
            public void testAllFilesPresentInProperties() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/properties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="dataClass.kt")
            public void testDataClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/dataClass.kt");
            }

            @Test
            @TestMetadata(value="openDataClass.kt")
            public void testOpenDataClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/openDataClass.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/properties/lateinit")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Lateinit {
                @Test
                public void testAllFilesPresentInLateinit() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/properties/lateinit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="companionObject.kt")
                public void testCompanionObject() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/lateinit/companionObject.kt");
                }

                @Test
                @TestMetadata(value="companionObjectFromLambda.kt")
                public void testCompanionObjectFromLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/lateinit/companionObjectFromLambda.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/parameterlessMain")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ParameterlessMain {
            @Test
            public void testAllFilesPresentInParameterlessMain() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/parameterlessMain"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="dontGenerateOnExtensionReceiver.kt")
            public void testDontGenerateOnExtensionReceiver() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnExtensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="dontGenerateOnJvmNameMain.kt")
            public void testDontGenerateOnJvmNameMain() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnJvmNameMain.kt");
            }

            @Test
            @TestMetadata(value="dontGenerateOnJvmOverloads.kt")
            public void testDontGenerateOnJvmOverloads() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnJvmOverloads.kt");
            }

            @Test
            @TestMetadata(value="dontGenerateOnMain.kt")
            public void testDontGenerateOnMain() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnMain.kt");
            }

            @Test
            @TestMetadata(value="dontGenerateOnMainExtension.kt")
            public void testDontGenerateOnMainExtension() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnMainExtension.kt");
            }

            @Test
            @TestMetadata(value="dontGenerateOnNullableArray.kt")
            public void testDontGenerateOnNullableArray() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnNullableArray.kt");
            }

            @Test
            @TestMetadata(value="dontGenerateOnNullableString.kt")
            public void testDontGenerateOnNullableString() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnNullableString.kt");
            }

            @Test
            @TestMetadata(value="dontGenerateOnVarargsString.kt")
            public void testDontGenerateOnVarargsString() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnVarargsString.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/outerClass")
        @TestDataPath(value="$PROJECT_ROOT")
        public class OuterClass {
            @Test
            public void testAllFilesPresentInOuterClass() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/outerClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classInClinit.kt")
            public void testClassInClinit() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/outerClass/classInClinit.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties")
        @TestDataPath(value="$PROJECT_ROOT")
        public class OptimizedDelegatedProperties {
            @Test
            public void testAllFilesPresentInOptimizedDelegatedProperties() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="definedInSources.kt")
            public void testDefinedInSources() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/definedInSources.kt");
            }

            @Test
            @TestMetadata(value="delegateToAnother.kt")
            public void testDelegateToAnother() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/delegateToAnother.kt");
            }

            @Test
            @TestMetadata(value="inSeparateModule.kt")
            public void testInSeparateModule() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/inSeparateModule.kt");
            }

            @Test
            @TestMetadata(value="lazy.kt")
            public void testLazy() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/lazy.kt");
            }

            @Test
            @TestMetadata(value="withNonNullMetadataParameter.kt")
            public void testWithNonNullMetadataParameter() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/withNonNullMetadataParameter.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/nullCheckOptimization")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NullCheckOptimization {
            @Test
            public void testAllFilesPresentInNullCheckOptimization() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/nullCheckOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="alreadyCheckedForIs.kt")
            public void testAlreadyCheckedForIs() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/alreadyCheckedForIs.kt");
            }

            @Test
            @TestMetadata(value="alreadyCheckedForNull.kt")
            public void testAlreadyCheckedForNull() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/alreadyCheckedForNull.kt");
            }

            @Test
            @TestMetadata(value="deterministicNotNullChecks.kt")
            public void testDeterministicNotNullChecks() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/deterministicNotNullChecks.kt");
            }

            @Test
            @TestMetadata(value="exclExclAsNotNullType.kt")
            public void testExclExclAsNotNullType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/exclExclAsNotNullType.kt");
            }

            @Test
            @TestMetadata(value="expressionValueIsNotNull.kt")
            public void testExpressionValueIsNotNull() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNull.kt");
            }

            @Test
            @TestMetadata(value="expressionValueIsNotNullAfterExclExcl.kt")
            public void testExpressionValueIsNotNullAfterExclExcl() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNullAfterExclExcl.kt");
            }

            @Test
            @TestMetadata(value="expressionValueIsNotNullTwice.kt")
            public void testExpressionValueIsNotNullTwice() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNullTwice.kt");
            }

            @Test
            @TestMetadata(value="ifNullEqualsNull.kt")
            public void testIfNullEqualsNull() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifNullEqualsNull.kt");
            }

            @Test
            @TestMetadata(value="ifNullEqualsNullInline.kt")
            public void testIfNullEqualsNullInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifNullEqualsNullInline.kt");
            }

            @Test
            @TestMetadata(value="ifUnitEqualsNull.kt")
            public void testIfUnitEqualsNull() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifUnitEqualsNull.kt");
            }

            @Test
            @TestMetadata(value="ifUnitEqualsNullInline.kt")
            public void testIfUnitEqualsNullInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifUnitEqualsNullInline.kt");
            }

            @Test
            @TestMetadata(value="kt12839.kt")
            public void testKt12839() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/kt12839.kt");
            }

            @Test
            @TestMetadata(value="multipleExclExcl_1_4.kt")
            public void testMultipleExclExcl_1_4() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/multipleExclExcl_1_4.kt");
            }

            @Test
            @TestMetadata(value="noNullCheckAfterCast.kt")
            public void testNoNullCheckAfterCast() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/noNullCheckAfterCast.kt");
            }

            @Test
            @TestMetadata(value="notNullAsNotNullable.kt")
            public void testNotNullAsNotNullable() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/notNullAsNotNullable.kt");
            }

            @Test
            @TestMetadata(value="notNullExpressionValueTwice_1_4.kt")
            public void testNotNullExpressionValueTwice_1_4() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/notNullExpressionValueTwice_1_4.kt");
            }

            @Test
            @TestMetadata(value="nullCheckAfterExclExcl_1_4.kt")
            public void testNullCheckAfterExclExcl_1_4() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/nullCheckAfterExclExcl_1_4.kt");
            }

            @Test
            @TestMetadata(value="nullabilityAssertionOnDispatchReceiver.kt")
            public void testNullabilityAssertionOnDispatchReceiver() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/nullabilityAssertionOnDispatchReceiver.kt");
            }

            @Test
            @TestMetadata(value="primitiveCheck.kt")
            public void testPrimitiveCheck() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/primitiveCheck.kt");
            }

            @Test
            @TestMetadata(value="redundantSafeCall.kt")
            public void testRedundantSafeCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/redundantSafeCall.kt");
            }

            @Test
            @TestMetadata(value="redundantSafeCall_1_4.kt")
            public void testRedundantSafeCall_1_4() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/redundantSafeCall_1_4.kt");
            }

            @Test
            @TestMetadata(value="reifiedIs.kt")
            public void testReifiedIs() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/reifiedIs.kt");
            }

            @Test
            @TestMetadata(value="reifiedNullIs.kt")
            public void testReifiedNullIs() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/reifiedNullIs.kt");
            }

            @Test
            @TestMetadata(value="safeCallAndElvisChains.kt")
            public void testSafeCallAndElvisChains() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/safeCallAndElvisChains.kt");
            }

            @Test
            @TestMetadata(value="trivialInstanceOf.kt")
            public void testTrivialInstanceOf() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/trivialInstanceOf.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit")
            @TestDataPath(value="$PROJECT_ROOT")
            public class LocalLateinit {
                @Test
                public void testAllFilesPresentInLocalLateinit() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="checkedAlways.kt")
                public void testCheckedAlways() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/checkedAlways.kt");
                }

                @Test
                @TestMetadata(value="checkedOnce.kt")
                public void testCheckedOnce() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/checkedOnce.kt");
                }

                @Test
                @TestMetadata(value="initialized.kt")
                public void testInitialized() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/initialized.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/notNullAssertions")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NotNullAssertions {
            @Test
            public void testAllFilesPresentInNotNullAssertions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/notNullAssertions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayListGet.kt")
            public void testArrayListGet() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/arrayListGet.kt");
            }

            @Test
            @TestMetadata(value="assertionForNotNullCaptured.kt")
            public void testAssertionForNotNullCaptured() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullCaptured.kt");
            }

            @Test
            @TestMetadata(value="assertionForNotNullTypeParam.kt")
            public void testAssertionForNotNullTypeParam() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullTypeParam.kt");
            }

            @Test
            @TestMetadata(value="assertionForNotNullTypeParam_1_4.kt")
            public void testAssertionForNotNullTypeParam_1_4() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullTypeParam_1_4.kt");
            }

            @Test
            @TestMetadata(value="doNotGenerateParamAssertions.kt")
            public void testDoNotGenerateParamAssertions() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/doNotGenerateParamAssertions.kt");
            }

            @Test
            @TestMetadata(value="javaMultipleSubstitutions.kt")
            public void testJavaMultipleSubstitutions() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/javaMultipleSubstitutions.kt");
            }

            @Test
            @TestMetadata(value="noAssertionForNullableCaptured.kt")
            public void testNoAssertionForNullableCaptured() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableCaptured.kt");
            }

            @Test
            @TestMetadata(value="noAssertionForNullableGenericMethod.kt")
            public void testNoAssertionForNullableGenericMethod() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableGenericMethod.kt");
            }

            @Test
            @TestMetadata(value="noAssertionForNullableGenericMethodCall.kt")
            public void testNoAssertionForNullableGenericMethodCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableGenericMethodCall.kt");
            }

            @Test
            @TestMetadata(value="noAssertionForPrivateMethod.kt")
            public void testNoAssertionForPrivateMethod() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForPrivateMethod.kt");
            }

            @Test
            @TestMetadata(value="noAssertionsForKotlin.kt")
            public void testNoAssertionsForKotlin() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionsForKotlin.kt");
            }

            @Test
            @TestMetadata(value="noTemporaryVariableInNullCheckOnExpression.kt")
            public void testNoTemporaryVariableInNullCheckOnExpression() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noTemporaryVariableInNullCheckOnExpression.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/multifileClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class MultifileClasses {
            @Test
            public void testAllFilesPresentInMultifileClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultFunctionInMultifileClass.kt")
            public void testDefaultFunctionInMultifileClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/multifileClasses/defaultFunctionInMultifileClass.kt");
            }

            @Test
            @TestMetadata(value="optimizedMultifileClassFacadeMethods.kt")
            public void testOptimizedMultifileClassFacadeMethods() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/multifileClasses/optimizedMultifileClassFacadeMethods.kt");
            }

            @Test
            @TestMetadata(value="privateFunctionName.kt")
            public void testPrivateFunctionName() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/multifileClasses/privateFunctionName.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/mangling")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Mangling {
            @Test
            public void testAllFilesPresentInMangling() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/mangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="parentheses.kt")
            public void testParentheses() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/mangling/parentheses.kt");
            }

            @Test
            @TestMetadata(value="parenthesesNoSanitize.kt")
            public void testParenthesesNoSanitize() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/mangling/parenthesesNoSanitize.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/localInitializationLVT")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LocalInitializationLVT {
            @Test
            public void testAllFilesPresentInLocalInitializationLVT() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/localInitializationLVT"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="boxing.kt")
            public void testBoxing() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/boxing.kt");
            }

            @Test
            @TestMetadata(value="boxingVar.kt")
            public void testBoxingVar() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/boxingVar.kt");
            }

            @Test
            @TestMetadata(value="contract.kt")
            public void testContract() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/contract.kt");
            }

            @Test
            @TestMetadata(value="contractVar.kt")
            public void testContractVar() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/contractVar.kt");
            }

            @Test
            @TestMetadata(value="generics.kt")
            public void testGenerics() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/generics.kt");
            }

            @Test
            @TestMetadata(value="genericsVar.kt")
            public void testGenericsVar() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/genericsVar.kt");
            }

            @Test
            @TestMetadata(value="ifStatement.kt")
            public void testIfStatement() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatement.kt");
            }

            @Test
            @TestMetadata(value="ifStatementVar.kt")
            public void testIfStatementVar() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementVar.kt");
            }

            @Test
            @TestMetadata(value="ifStatementWithoutBlock.kt")
            public void testIfStatementWithoutBlock() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementWithoutBlock.kt");
            }

            @Test
            @TestMetadata(value="ifStatementWithoutBlockVar.kt")
            public void testIfStatementWithoutBlockVar() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementWithoutBlockVar.kt");
            }

            @Test
            @TestMetadata(value="inlineClass.kt")
            public void testInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/inlineClass.kt");
            }

            @Test
            @TestMetadata(value="inlineClassVar.kt")
            public void testInlineClassVar() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/inlineClassVar.kt");
            }

            @Test
            @TestMetadata(value="lateinit.kt")
            public void testLateinit() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/lateinit.kt");
            }

            @Test
            @TestMetadata(value="run.kt")
            public void testRun() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/run.kt");
            }

            @Test
            @TestMetadata(value="runVar.kt")
            public void testRunVar() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/runVar.kt");
            }

            @Test
            @TestMetadata(value="singleBlock.kt")
            public void testSingleBlock() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/singleBlock.kt");
            }

            @Test
            @TestMetadata(value="singleBlockVar.kt")
            public void testSingleBlockVar() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/singleBlockVar.kt");
            }

            @Test
            @TestMetadata(value="whenStatement.kt")
            public void testWhenStatement() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/whenStatement.kt");
            }

            @Test
            @TestMetadata(value="whenStatementVar.kt")
            public void testWhenStatementVar() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/whenStatementVar.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/lineNumbers")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LineNumbers {
            @Test
            public void testAllFilesPresentInLineNumbers() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lineNumbers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="delegationToList.kt")
            public void testDelegationToList() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/delegationToList.kt");
            }

            @Test
            @TestMetadata(value="ifConsts.kt")
            public void testIfConsts() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifConsts.kt");
            }

            @Test
            @TestMetadata(value="ifElse.kt")
            public void testIfElse() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifElse.kt");
            }

            @Test
            @TestMetadata(value="ifFalse.kt")
            public void testIfFalse() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifFalse.kt");
            }

            @Test
            @TestMetadata(value="ifFalseElse.kt")
            public void testIfFalseElse() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifFalseElse.kt");
            }

            @Test
            @TestMetadata(value="ifTrue.kt")
            public void testIfTrue() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifTrue.kt");
            }

            @Test
            @TestMetadata(value="ifTrueElse.kt")
            public void testIfTrueElse() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifTrueElse.kt");
            }

            @Test
            @TestMetadata(value="inlineCondition.kt")
            public void testInlineCondition() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineCondition.kt");
            }

            @Test
            @TestMetadata(value="inlineCondition2.kt")
            public void testInlineCondition2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineCondition2.kt");
            }

            @Test
            @TestMetadata(value="inlineLambdaObjectInit.kt")
            public void testInlineLambdaObjectInit() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineLambdaObjectInit.kt");
            }

            @Test
            @TestMetadata(value="kt61768.kt")
            public void testKt61768() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/kt61768.kt");
            }

            @Test
            @TestMetadata(value="singleThen.kt")
            public void testSingleThen() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/singleThen.kt");
            }

            @Test
            @TestMetadata(value="tryCatch.kt")
            public void testTryCatch() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/tryCatch.kt");
            }

            @Test
            @TestMetadata(value="tryFinally.kt")
            public void testTryFinally() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/tryFinally.kt");
            }

            @Test
            @TestMetadata(value="when.kt")
            public void testWhen() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/when.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/lazyCodegen")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LazyCodegen {
            @Test
            public void testAllFilesPresentInLazyCodegen() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lazyCodegen"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="inlineConstInsideComparison.kt")
            public void testInlineConstInsideComparison() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/inlineConstInsideComparison.kt");
            }

            @Test
            @TestMetadata(value="negateConst.kt")
            public void testNegateConst() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateConst.kt");
            }

            @Test
            @TestMetadata(value="negateObjectComp.kt")
            public void testNegateObjectComp() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectComp.kt");
            }

            @Test
            @TestMetadata(value="negateObjectCompChaing.kt")
            public void testNegateObjectCompChaing() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectCompChaing.kt");
            }

            @Test
            @TestMetadata(value="negateVar.kt")
            public void testNegateVar() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVar.kt");
            }

            @Test
            @TestMetadata(value="negateVarChain.kt")
            public void testNegateVarChain() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVarChain.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Jvm8 {
            @Test
            public void testAllFilesPresentInJvm8() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8/jvmDefault")
            @TestDataPath(value="$PROJECT_ROOT")
            public class JvmDefault {
                @Test
                public void testAllFilesPresentInJvmDefault() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility")
                @TestDataPath(value="$PROJECT_ROOT")
                public class AllCompatibility {
                    @Test
                    public void testAllFilesPresentInAllCompatibility() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="defaultArgs.kt")
                    public void testDefaultArgs() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/defaultArgs.kt");
                    }

                    @Test
                    @TestMetadata(value="simpleDiamond.kt")
                    public void testSimpleDiamond() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleDiamond.kt");
                    }

                    @Test
                    @TestMetadata(value="simpleFunction.kt")
                    public void testSimpleFunction() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleFunction.kt");
                    }

                    @Test
                    @TestMetadata(value="simpleFunctionWithAbstractOverride.kt")
                    public void testSimpleFunctionWithAbstractOverride() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleFunctionWithAbstractOverride.kt");
                    }

                    @Test
                    @TestMetadata(value="simpleProperty.kt")
                    public void testSimpleProperty() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleProperty.kt");
                    }
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8/hashCode")
            @TestDataPath(value="$PROJECT_ROOT")
            public class HashCode {
                @Test
                public void testAllFilesPresentInHashCode() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="dataClass.kt")
                public void testDataClass() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/hashCode/dataClass.kt");
                }

                @Test
                @TestMetadata(value="hashCode.kt")
                public void testHashCode() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/hashCode/hashCode.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/invokedynamic")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Invokedynamic {
            @Test
            public void testAllFilesPresentInInvokedynamic() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/invokedynamic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="extensionReceiversNames.kt")
            public void testExtensionReceiversNames() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/extensionReceiversNames.kt");
            }

            @Test
            @TestMetadata(value="functionRefToJavaInterface.kt")
            public void testFunctionRefToJavaInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/functionRefToJavaInterface.kt");
            }

            @Test
            @TestMetadata(value="lambdas.kt")
            public void testLambdas() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/lambdas.kt");
            }

            @Test
            @TestMetadata(value="streamApi.kt")
            public void testStreamApi() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/streamApi.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/intrinsicsTrim")
        @TestDataPath(value="$PROJECT_ROOT")
        public class IntrinsicsTrim {
            @Test
            public void testAllFilesPresentInIntrinsicsTrim() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsicsTrim"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="trimIndentNegative.kt")
            public void testTrimIndentNegative() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimIndentNegative.kt");
            }

            @Test
            @TestMetadata(value="trimIndentPositive.kt")
            public void testTrimIndentPositive() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimIndentPositive.kt");
            }

            @Test
            @TestMetadata(value="trimMarginNegative.kt")
            public void testTrimMarginNegative() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimMarginNegative.kt");
            }

            @Test
            @TestMetadata(value="trimMarginPositive.kt")
            public void testTrimMarginPositive() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimMarginPositive.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/intrinsicsCompare")
        @TestDataPath(value="$PROJECT_ROOT")
        public class IntrinsicsCompare {
            @Test
            public void testAllFilesPresentInIntrinsicsCompare() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsicsCompare"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="byteSmartCast_after.kt")
            public void testByteSmartCast_after() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/byteSmartCast_after.kt");
            }

            @Test
            @TestMetadata(value="byteSmartCast_before.kt")
            public void testByteSmartCast_before() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/byteSmartCast_before.kt");
            }

            @Test
            @TestMetadata(value="charSmartCast.kt")
            public void testCharSmartCast() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/charSmartCast.kt");
            }

            @Test
            @TestMetadata(value="differentTypes_after.kt")
            public void testDifferentTypes_after() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/differentTypes_after.kt");
            }

            @Test
            @TestMetadata(value="differentTypes_before.kt")
            public void testDifferentTypes_before() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/differentTypes_before.kt");
            }

            @Test
            @TestMetadata(value="intSmartCast_after.kt")
            public void testIntSmartCast_after() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/intSmartCast_after.kt");
            }

            @Test
            @TestMetadata(value="intSmartCast_before.kt")
            public void testIntSmartCast_before() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/intSmartCast_before.kt");
            }

            @Test
            @TestMetadata(value="longSmartCast.kt")
            public void testLongSmartCast() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/longSmartCast.kt");
            }

            @Test
            @TestMetadata(value="shortSmartCast_after.kt")
            public void testShortSmartCast_after() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/shortSmartCast_after.kt");
            }

            @Test
            @TestMetadata(value="shortSmartCast_before.kt")
            public void testShortSmartCast_before() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/shortSmartCast_before.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/intrinsics")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Intrinsics {
            @Test
            public void testAllFilesPresentInIntrinsics() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="javaObjectType.kt")
            public void testJavaObjectType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsics/javaObjectType.kt");
            }

            @Test
            @TestMetadata(value="javaPrimitiveType.kt")
            public void testJavaPrimitiveType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsics/javaPrimitiveType.kt");
            }

            @Test
            @TestMetadata(value="postfixIncrDecr.kt")
            public void testPostfixIncrDecr() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsics/postfixIncrDecr.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/interfaces")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Interfaces {
            @Test
            @TestMetadata(value="addedInterfaceBridge.kt")
            public void testAddedInterfaceBridge() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/addedInterfaceBridge.kt");
            }

            @Test
            public void testAllFilesPresentInInterfaces() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/interfaces"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="firstInheritedMethodIsAbstract.kt")
            public void testFirstInheritedMethodIsAbstract() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/firstInheritedMethodIsAbstract.kt");
            }

            @Test
            @TestMetadata(value="noAnyMethodsOnInterfaceInheritance.kt")
            public void testNoAnyMethodsOnInterfaceInheritance() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/noAnyMethodsOnInterfaceInheritance.kt");
            }

            @Test
            @TestMetadata(value="noNullCheckOnThisInDefaultMethod.kt")
            public void testNoNullCheckOnThisInDefaultMethod() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/noNullCheckOnThisInDefaultMethod.kt");
            }

            @Test
            @TestMetadata(value="noPrivateMemberInJavaInterface.kt")
            public void testNoPrivateMemberInJavaInterface() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/noPrivateMemberInJavaInterface.kt");
            }

            @Test
            @TestMetadata(value="traitImplGeneratedOnce.kt")
            public void testTraitImplGeneratedOnce() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/traitImplGeneratedOnce.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/innerClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InnerClasses {
            @Test
            public void testAllFilesPresentInInnerClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/innerClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt27936.kt")
            public void testKt27936() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt27936.kt");
            }

            @Test
            @TestMetadata(value="kt53804.kt")
            public void testKt53804() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt53804.kt");
            }

            @Test
            @TestMetadata(value="kt56104.kt")
            public void testKt56104() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt56104.kt");
            }

            @Test
            @TestMetadata(value="kt57714.kt")
            public void testKt57714() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt57714.kt");
            }

            @Test
            @TestMetadata(value="nestedClassInAnnotationArgument.kt")
            public void testNestedClassInAnnotationArgument() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/nestedClassInAnnotationArgument.kt");
            }

            @Test
            @TestMetadata(value="nestedClassInAnnotationArgumentOldMode.kt")
            public void testNestedClassInAnnotationArgumentOldMode() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/nestedClassInAnnotationArgumentOldMode.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/inlineClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="asCastForInlineClass.kt")
            public void testAsCastForInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/asCastForInlineClass.kt");
            }

            @Test
            @TestMetadata(value="assertionsForParametersOfInlineClassTypes.kt")
            public void testAssertionsForParametersOfInlineClassTypes() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/assertionsForParametersOfInlineClassTypes.kt");
            }

            @Test
            @TestMetadata(value="boxInlineClassInsideElvisWithNullConstant.kt")
            public void testBoxInlineClassInsideElvisWithNullConstant() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxInlineClassInsideElvisWithNullConstant.kt");
            }

            @Test
            @TestMetadata(value="boxInlineClassesOnPassingToVarargs.kt")
            public void testBoxInlineClassesOnPassingToVarargs() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxInlineClassesOnPassingToVarargs.kt");
            }

            @Test
            @TestMetadata(value="boxMethodCalledByInlineClass.kt")
            public void testBoxMethodCalledByInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxMethodCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="boxResultAfterConstructorCall.kt")
            public void testBoxResultAfterConstructorCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxResultAfterConstructorCall.kt");
            }

            @Test
            @TestMetadata(value="boxResultInlineClassOfConstructorCall.kt")
            public void testBoxResultInlineClassOfConstructorCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxResultInlineClassOfConstructorCall.kt");
            }

            @Test
            @TestMetadata(value="boxThisOfInlineClass.kt")
            public void testBoxThisOfInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxThisOfInlineClass.kt");
            }

            @Test
            @TestMetadata(value="boxUnboxInlineClassFromMethodReturnType.kt")
            public void testBoxUnboxInlineClassFromMethodReturnType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxInlineClassFromMethodReturnType.kt");
            }

            @Test
            @TestMetadata(value="boxUnboxInsideLambdaAsLastExpression.kt")
            public void testBoxUnboxInsideLambdaAsLastExpression() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxInsideLambdaAsLastExpression.kt");
            }

            @Test
            @TestMetadata(value="boxUnboxOfInlineClassesWithFunctionalTypes.kt")
            public void testBoxUnboxOfInlineClassesWithFunctionalTypes() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxOfInlineClassesWithFunctionalTypes.kt");
            }

            @Test
            @TestMetadata(value="boxUnboxOnInlinedParameters.kt")
            public void testBoxUnboxOnInlinedParameters() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxOnInlinedParameters.kt");
            }

            @Test
            @TestMetadata(value="boxingForNonLocalAndLabeledReturnsOfInlineClasses.kt")
            public void testBoxingForNonLocalAndLabeledReturnsOfInlineClasses() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxingForNonLocalAndLabeledReturnsOfInlineClasses.kt");
            }

            @Test
            @TestMetadata(value="callMemberMethodsInsideInlineClass.kt")
            public void testCallMemberMethodsInsideInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/callMemberMethodsInsideInlineClass.kt");
            }

            @Test
            @TestMetadata(value="checkBoxingInInlineClass.kt")
            public void testCheckBoxingInInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/checkBoxingInInlineClass.kt");
            }

            @Test
            @TestMetadata(value="checkOuterInlineFunctionCall.kt")
            public void testCheckOuterInlineFunctionCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/checkOuterInlineFunctionCall.kt");
            }

            @Test
            @TestMetadata(value="constructorBridge.kt")
            public void testConstructorBridge() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/constructorBridge.kt");
            }

            @Test
            @TestMetadata(value="constructorWithDefaultArguments.kt")
            public void testConstructorWithDefaultArguments() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/constructorWithDefaultArguments.kt");
            }

            @Test
            @TestMetadata(value="defaultParametersDontBox.kt")
            public void testDefaultParametersDontBox() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/defaultParametersDontBox.kt");
            }

            @Test
            @TestMetadata(value="delegatedPropertyMangling.kt")
            public void testDelegatedPropertyMangling() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/delegatedPropertyMangling.kt");
            }

            @Test
            @TestMetadata(value="equalsDoesNotBox.kt")
            public void testEqualsDoesNotBox() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/equalsDoesNotBox.kt");
            }

            @Test
            @TestMetadata(value="equalsIsCalledByInlineClass.kt")
            public void testEqualsIsCalledByInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/equalsIsCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="factoryMethodForSecondaryConstructorsCalledByInlineClass.kt")
            public void testFactoryMethodForSecondaryConstructorsCalledByInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/factoryMethodForSecondaryConstructorsCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="functionsWithInlineClassParametersHaveStableMangledNames.kt")
            public void testFunctionsWithInlineClassParametersHaveStableMangledNames() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/functionsWithInlineClassParametersHaveStableMangledNames.kt");
            }

            @Test
            @TestMetadata(value="generationOfAccessorToUnderlyingValue.kt")
            public void testGenerationOfAccessorToUnderlyingValue() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/generationOfAccessorToUnderlyingValue.kt");
            }

            @Test
            @TestMetadata(value="genericNoUnbox.kt")
            public void testGenericNoUnbox() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/genericNoUnbox.kt");
            }

            @Test
            @TestMetadata(value="hashCodeIsCalledByInlineClass.kt")
            public void testHashCodeIsCalledByInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/hashCodeIsCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="inlineClassBoxingOnAssignment.kt")
            public void testInlineClassBoxingOnAssignment() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingOnAssignment.kt");
            }

            @Test
            @TestMetadata(value="inlineClassBoxingOnFunctionCall.kt")
            public void testInlineClassBoxingOnFunctionCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingOnFunctionCall.kt");
            }

            @Test
            @TestMetadata(value="inlineClassBoxingUnboxingInsideInlinedLambda.kt")
            public void testInlineClassBoxingUnboxingInsideInlinedLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingUnboxingInsideInlinedLambda.kt");
            }

            @Test
            @TestMetadata(value="inlineClassInGeneratedToString.kt")
            public void testInlineClassInGeneratedToString() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassInGeneratedToString.kt");
            }

            @Test
            @TestMetadata(value="inlineClassInStringTemplate.kt")
            public void testInlineClassInStringTemplate() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassInStringTemplate.kt");
            }

            @Test
            @TestMetadata(value="inlineClassesUnboxingAfterAssertionOperator.kt")
            public void testInlineClassesUnboxingAfterAssertionOperator() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassesUnboxingAfterAssertionOperator.kt");
            }

            @Test
            @TestMetadata(value="interfaceDefaultImplStubs.kt")
            public void testInterfaceDefaultImplStubs() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/interfaceDefaultImplStubs.kt");
            }

            @Test
            @TestMetadata(value="isCheckForInlineClass.kt")
            public void testIsCheckForInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/isCheckForInlineClass.kt");
            }

            @Test
            @TestMetadata(value="kt33722.kt")
            public void testKt33722() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/kt33722.kt");
            }

            @Test
            @TestMetadata(value="mangledInlineClassInterfaceImplementation.kt")
            public void testMangledInlineClassInterfaceImplementation() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledInlineClassInterfaceImplementation.kt");
            }

            @Test
            @TestMetadata(value="mangledSamWrappers.kt")
            public void testMangledSamWrappers() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappers.kt");
            }

            @Test
            @TestMetadata(value="mangledSamWrappersIndy.kt")
            public void testMangledSamWrappersIndy() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappersIndy.kt");
            }

            @Test
            @TestMetadata(value="mangledSamWrappersOld.kt")
            public void testMangledSamWrappersOld() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappersOld.kt");
            }

            @Test
            @TestMetadata(value="noActualCallsOfInlineFunctionsOfInlineClass.kt")
            public void testNoActualCallsOfInlineFunctionsOfInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noActualCallsOfInlineFunctionsOfInlineClass.kt");
            }

            @Test
            @TestMetadata(value="noAssertionsForInlineClassesBasedOnNullableTypes.kt")
            public void testNoAssertionsForInlineClassesBasedOnNullableTypes() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noAssertionsForInlineClassesBasedOnNullableTypes.kt");
            }

            @Test
            @TestMetadata(value="noBoxingInMethod.kt")
            public void testNoBoxingInMethod() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingInMethod.kt");
            }

            @Test
            @TestMetadata(value="noBoxingOnCastOperations.kt")
            public void testNoBoxingOnCastOperations() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingOnCastOperations.kt");
            }

            @Test
            @TestMetadata(value="noBoxingOperationsOnNonTrivialSpread.kt")
            public void testNoBoxingOperationsOnNonTrivialSpread() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingOperationsOnNonTrivialSpread.kt");
            }

            @Test
            @TestMetadata(value="noBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate.kt")
            public void testNoBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate.kt");
            }

            @Test
            @TestMetadata(value="noManglingForFunctionsWithJvmName.kt")
            public void testNoManglingForFunctionsWithJvmName() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noManglingForFunctionsWithJvmName.kt");
            }

            @Test
            @TestMetadata(value="noReturnTypeMangling.kt")
            public void testNoReturnTypeMangling() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noReturnTypeMangling.kt");
            }

            @Test
            @TestMetadata(value="nonOverridingMethodsAreCalledByInlineClass.kt")
            public void testNonOverridingMethodsAreCalledByInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/nonOverridingMethodsAreCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="overridingMethodsAreCalledByInlineClass.kt")
            public void testOverridingMethodsAreCalledByInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/overridingMethodsAreCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="passInlineClassesWithSpreadOperatorToVarargs.kt")
            public void testPassInlineClassesWithSpreadOperatorToVarargs() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/passInlineClassesWithSpreadOperatorToVarargs.kt");
            }

            @Test
            @TestMetadata(value="primaryConstructorCalledByInlineClass.kt")
            public void testPrimaryConstructorCalledByInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/primaryConstructorCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="propertyAccessorsAreCalledByInlineClass.kt")
            public void testPropertyAccessorsAreCalledByInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/propertyAccessorsAreCalledByInlineClass.kt");
            }

            @Test
            @TestMetadata(value="propertySetterWithInlineClassTypeArgument.kt")
            public void testPropertySetterWithInlineClassTypeArgument() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/propertySetterWithInlineClassTypeArgument.kt");
            }

            @Test
            @TestMetadata(value="resultApiDoesntCallSpecializedEquals.kt")
            public void testResultApiDoesntCallSpecializedEquals() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiDoesntCallSpecializedEquals.kt");
            }

            @Test
            @TestMetadata(value="resultApiDoesntUseBox.kt")
            public void testResultApiDoesntUseBox() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiDoesntUseBox.kt");
            }

            @Test
            @TestMetadata(value="resultApiEqualsDoesntBox.kt")
            public void testResultApiEqualsDoesntBox() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiEqualsDoesntBox.kt");
            }

            @Test
            @TestMetadata(value="resultApiRunCatchingDoesntBox.kt")
            public void testResultApiRunCatchingDoesntBox() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiRunCatchingDoesntBox.kt");
            }

            @Test
            @TestMetadata(value="resultApiStringInterpolationDoesntBox.kt")
            public void testResultApiStringInterpolationDoesntBox() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiStringInterpolationDoesntBox.kt");
            }

            @Test
            @TestMetadata(value="resultMangling.kt")
            public void testResultMangling() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultMangling.kt");
            }

            @Test
            @TestMetadata(value="skipCallToUnderlyingValueOfInlineClass.kt")
            public void testSkipCallToUnderlyingValueOfInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/skipCallToUnderlyingValueOfInlineClass.kt");
            }

            @Test
            @TestMetadata(value="suspendFunctionMangling.kt")
            public void testSuspendFunctionMangling() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/suspendFunctionMangling.kt");
            }

            @Test
            @TestMetadata(value="toStringOfInlineClassValue.kt")
            public void testToStringOfInlineClassValue() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/toStringOfInlineClassValue.kt");
            }

            @Test
            @TestMetadata(value="toStringOfReferenceInlineClassValue.kt")
            public void testToStringOfReferenceInlineClassValue() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/toStringOfReferenceInlineClassValue.kt");
            }

            @Test
            @TestMetadata(value="uIntArrayIteratorWithoutBoxing.kt")
            public void testUIntArrayIteratorWithoutBoxing() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/uIntArrayIteratorWithoutBoxing.kt");
            }

            @Test
            @TestMetadata(value="uIntArraySwapBoxing.kt")
            public void testUIntArraySwapBoxing() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/uIntArraySwapBoxing.kt");
            }

            @Test
            @TestMetadata(value="unboxInlineClassAfterElvis.kt")
            public void testUnboxInlineClassAfterElvis() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassAfterElvis.kt");
            }

            @Test
            @TestMetadata(value="unboxInlineClassAfterSafeCall.kt")
            public void testUnboxInlineClassAfterSafeCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassAfterSafeCall.kt");
            }

            @Test
            @TestMetadata(value="unboxInlineClassFromParameterizedType.kt")
            public void testUnboxInlineClassFromParameterizedType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassFromParameterizedType.kt");
            }

            @Test
            @TestMetadata(value="unboxInlineClassesAfterSmartCasts.kt")
            public void testUnboxInlineClassesAfterSmartCasts() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassesAfterSmartCasts.kt");
            }

            @Test
            @TestMetadata(value="unboxMethodCalledByInlineClass.kt")
            public void testUnboxMethodCalledByInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxMethodCalledByInlineClass.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/inlineArgsInPlace")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineArgsInPlace {
            @Test
            public void testAllFilesPresentInInlineArgsInPlace() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inlineArgsInPlace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kotlinMathMax.kt")
            public void testKotlinMathMax() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/kotlinMathMax.kt");
            }

            @Test
            @TestMetadata(value="println.kt")
            public void testPrintln() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/println.kt");
            }

            @Test
            @TestMetadata(value="sin.kt")
            public void testSin() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/sin.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/inline")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Inline {
            @Test
            public void testAllFilesPresentInInline() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultLambda.kt")
            public void testDefaultLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/defaultLambda.kt");
            }

            @Test
            @TestMetadata(value="deleteClassOnTransformation.kt")
            public void testDeleteClassOnTransformation() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/deleteClassOnTransformation.kt");
            }

            @Test
            @TestMetadata(value="entriesMappingOnCallSite.kt")
            public void testEntriesMappingOnCallSite() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/entriesMappingOnCallSite.kt");
            }

            @Test
            @TestMetadata(value="finallyMarkers.kt")
            public void testFinallyMarkers() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/finallyMarkers.kt");
            }

            @Test
            @TestMetadata(value="inlineArgumentSlots.kt")
            public void testInlineArgumentSlots() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineArgumentSlots.kt");
            }

            @Test
            @TestMetadata(value="inlineReturnsNothing1.kt")
            public void testInlineReturnsNothing1() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing1.kt");
            }

            @Test
            @TestMetadata(value="inlineReturnsNothing2.kt")
            public void testInlineReturnsNothing2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing2.kt");
            }

            @Test
            @TestMetadata(value="inlineReturnsNothing3.kt")
            public void testInlineReturnsNothing3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing3.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendReifiedNoSpilling.kt")
            public void testInlineSuspendReifiedNoSpilling() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineSuspendReifiedNoSpilling.kt");
            }

            @Test
            @TestMetadata(value="interfaceDefaultMethod.kt")
            public void testInterfaceDefaultMethod() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/interfaceDefaultMethod.kt");
            }

            @Test
            @TestMetadata(value="linenumberForOneParametersArgumentCall.kt")
            public void testLinenumberForOneParametersArgumentCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/linenumberForOneParametersArgumentCall.kt");
            }

            @Test
            @TestMetadata(value="noFakeVariableForInlineOnlyFun.kt")
            public void testNoFakeVariableForInlineOnlyFun() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFun.kt");
            }

            @Test
            @TestMetadata(value="noFakeVariableForInlineOnlyFunFromStdlib.kt")
            public void testNoFakeVariableForInlineOnlyFunFromStdlib() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunFromStdlib.kt");
            }

            @Test
            @TestMetadata(value="noFakeVariableForInlineOnlyFunMap.kt")
            public void testNoFakeVariableForInlineOnlyFunMap() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunMap.kt");
            }

            @Test
            @TestMetadata(value="noFakeVariableForInlineOnlyFunWithLambda.kt")
            public void testNoFakeVariableForInlineOnlyFunWithLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunWithLambda.kt");
            }

            @Test
            @TestMetadata(value="noSynAccessor.kt")
            public void testNoSynAccessor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessor.kt");
            }

            @Test
            @TestMetadata(value="noSynAccessorToDirectFieldAccess.kt")
            public void testNoSynAccessorToDirectFieldAccess() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToDirectFieldAccess.kt");
            }

            @Test
            @TestMetadata(value="noSynAccessorToSuper.kt")
            public void testNoSynAccessorToSuper() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToSuper.kt");
            }

            @Test
            @TestMetadata(value="notSplitedExceptionTable.kt")
            public void testNotSplitedExceptionTable() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/notSplitedExceptionTable.kt");
            }

            @Test
            @TestMetadata(value="reifiedSafeAsWithMutable.kt")
            public void testReifiedSafeAsWithMutable() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/reifiedSafeAsWithMutable.kt");
            }

            @Test
            @TestMetadata(value="remappedLocalVar.kt")
            public void testRemappedLocalVar() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/remappedLocalVar.kt");
            }

            @Test
            @TestMetadata(value="removedFinallyMarkers.kt")
            public void testRemovedFinallyMarkers() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/removedFinallyMarkers.kt");
            }

            @Test
            @TestMetadata(value="specialEnumFunction.kt")
            public void testSpecialEnumFunction() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/specialEnumFunction.kt");
            }

            @Test
            @TestMetadata(value="splitedExceptionTable.kt")
            public void testSplitedExceptionTable() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/splitedExceptionTable.kt");
            }

            @Test
            @TestMetadata(value="whenMappingOnCallSite.kt")
            public void testWhenMappingOnCallSite() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/whenMappingOnCallSite.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/inline/property")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Property {
                @Test
                public void testAllFilesPresentInProperty() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/property/simple.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/ieee754")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Ieee754 {
            @Test
            public void testAllFilesPresentInIeee754() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ieee754"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="nullableDoubleEquals.kt")
            public void testNullableDoubleEquals() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleEquals.kt");
            }

            @Test
            @TestMetadata(value="nullableDoubleNotEquals.kt")
            public void testNullableDoubleNotEquals() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleNotEquals.kt");
            }

            @Test
            @TestMetadata(value="nullableFloatEquals.kt")
            public void testNullableFloatEquals() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatEquals.kt");
            }

            @Test
            @TestMetadata(value="nullableFloatNotEquals.kt")
            public void testNullableFloatNotEquals() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatNotEquals.kt");
            }

            @Test
            @TestMetadata(value="smartCastsForDouble.kt")
            public void testSmartCastsForDouble() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForDouble.kt");
            }

            @Test
            @TestMetadata(value="smartCastsForFloat.kt")
            public void testSmartCastsForFloat() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForFloat.kt");
            }

            @Test
            @TestMetadata(value="when.kt")
            public void testWhen() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/when.kt");
            }

            @Test
            @TestMetadata(value="whenNullableSmartCast.kt")
            public void testWhenNullableSmartCast() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/whenNullableSmartCast.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/hashCode")
        @TestDataPath(value="$PROJECT_ROOT")
        public class HashCode {
            @Test
            public void testAllFilesPresentInHashCode() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="interfaceHashCode.kt")
            public void testInterfaceHashCode() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/hashCode/interfaceHashCode.kt");
            }

            @Test
            @TestMetadata(value="interfaceHashCodeWithSmartCast.kt")
            public void testInterfaceHashCodeWithSmartCast() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/hashCode/interfaceHashCodeWithSmartCast.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForLoop {
            @Test
            public void testAllFilesPresentInForLoop() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInCharSequence.kt")
            public void testForInCharSequence() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequence.kt");
            }

            @Test
            @TestMetadata(value="forInCharSequenceTypeParameter.kt")
            public void testForInCharSequenceTypeParameter() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceTypeParameter.kt");
            }

            @Test
            @TestMetadata(value="forInDownToCharMinValue.kt")
            public void testForInDownToCharMinValue() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToCharMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInDownToIntMinValue.kt")
            public void testForInDownToIntMinValue() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToIntMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInDownToLongConstNoUnderflow.kt")
            public void testForInDownToLongConstNoUnderflow() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToLongConstNoUnderflow.kt");
            }

            @Test
            @TestMetadata(value="forInDownToLongMinValue.kt")
            public void testForInDownToLongMinValue() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToLongMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInObjectArray.kt")
            public void testForInObjectArray() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInObjectArray.kt");
            }

            @Test
            @TestMetadata(value="forInPrimitiveArray.kt")
            public void testForInPrimitiveArray() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInPrimitiveArray.kt");
            }

            @Test
            @TestMetadata(value="forInRangeSpecializedToUntil.kt")
            public void testForInRangeSpecializedToUntil() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeSpecializedToUntil.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToCharConst.kt")
            public void testForInRangeToCharConst() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToCharConst.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToCharMaxValue.kt")
            public void testForInRangeToCharMaxValue() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToCharMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToConst.kt")
            public void testForInRangeToConst() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToConst.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToIntMaxValue.kt")
            public void testForInRangeToIntMaxValue() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToIntMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToLongConst.kt")
            public void testForInRangeToLongConst() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToLongConst.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToLongMaxValue.kt")
            public void testForInRangeToLongMaxValue() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToLongMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToQualifiedConst.kt")
            public void testForInRangeToQualifiedConst() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToQualifiedConst.kt");
            }

            @Test
            @TestMetadata(value="forInRangeWithImplicitReceiver.kt")
            public void testForInRangeWithImplicitReceiver() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithImplicitReceiver.kt");
            }

            @Test
            @TestMetadata(value="forInStringSpecialized.kt")
            public void testForInStringSpecialized() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInStringSpecialized.kt");
            }

            @Test
            @TestMetadata(value="forIntInDownTo.kt")
            public void testForIntInDownTo() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forIntInDownTo.kt");
            }

            @Test
            @TestMetadata(value="iincGeneration.kt")
            public void testIincGeneration() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/iincGeneration.kt");
            }

            @Test
            @TestMetadata(value="intrinsicArrayConstructorsUseCounterLoop.kt")
            public void testIntrinsicArrayConstructorsUseCounterLoop() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/intrinsicArrayConstructorsUseCounterLoop.kt");
            }

            @Test
            @TestMetadata(value="loopVarInterval.kt")
            public void testLoopVarInterval() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/loopVarInterval.kt");
            }

            @Test
            @TestMetadata(value="primitiveLiteralRange1.kt")
            public void testPrimitiveLiteralRange1() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange1.kt");
            }

            @Test
            @TestMetadata(value="primitiveLiteralRange2.kt")
            public void testPrimitiveLiteralRange2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange2.kt");
            }

            @Test
            @TestMetadata(value="primitiveProgression.kt")
            public void testPrimitiveProgression() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveProgression.kt");
            }

            @Test
            @TestMetadata(value="primitiveRange.kt")
            public void testPrimitiveRange() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveRange.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/unsigned")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Unsigned {
                @Test
                public void testAllFilesPresentInUnsigned() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/unsigned"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInConstBoundUnsignedRange.kt")
                public void testForInConstBoundUnsignedRange() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInConstBoundUnsignedRange.kt");
                }

                @Test
                @TestMetadata(value="forInDownToUIntMinValue.kt")
                public void testForInDownToUIntMinValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInDownToUIntMinValue.kt");
                }

                @Test
                @TestMetadata(value="forInDownToULongMinValue.kt")
                public void testForInDownToULongMinValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInDownToULongMinValue.kt");
                }

                @Test
                @TestMetadata(value="forInOptimizableUnsignedRange.kt")
                public void testForInOptimizableUnsignedRange() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInOptimizableUnsignedRange.kt");
                }

                @Test
                @TestMetadata(value="forInRangeToUIntMaxValue.kt")
                public void testForInRangeToUIntMaxValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInRangeToUIntMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInRangeToULongMaxValue.kt")
                public void testForInRangeToULongMaxValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInRangeToULongMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInUnsignedArray.kt")
                public void testForInUnsignedArray() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArray.kt");
                }

                @Test
                @TestMetadata(value="forInUnsignedArrayIndices.kt")
                public void testForInUnsignedArrayIndices() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArrayIndices.kt");
                }

                @Test
                @TestMetadata(value="forInUnsignedArrayWithIndex.kt")
                public void testForInUnsignedArrayWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArrayWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInUntilUIntMaxValue.kt")
                public void testForInUntilUIntMaxValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilUIntMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilUIntMinValue.kt")
                public void testForInUntilUIntMinValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilUIntMinValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilULongMaxValue.kt")
                public void testForInUntilULongMaxValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilULongMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilULongMinValue.kt")
                public void testForInUntilULongMinValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilULongMinValue.kt");
                }

                @Test
                @TestMetadata(value="illegalStepConst.kt")
                public void testIllegalStepConst() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/illegalStepConst.kt");
                }

                @Test
                @TestMetadata(value="reversedThenStep.kt")
                public void testReversedThenStep() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/reversedThenStep.kt");
                }

                @Test
                @TestMetadata(value="stepConstOnNonLiteralProgression.kt")
                public void testStepConstOnNonLiteralProgression() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepConstOnNonLiteralProgression.kt");
                }

                @Test
                @TestMetadata(value="stepNonConstOnNonLiteralProgression.kt")
                public void testStepNonConstOnNonLiteralProgression() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepNonConstOnNonLiteralProgression.kt");
                }

                @Test
                @TestMetadata(value="stepOnNonLiteralRange.kt")
                public void testStepOnNonLiteralRange() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepOnNonLiteralRange.kt");
                }

                @Test
                @TestMetadata(value="stepThenDifferentStep.kt")
                public void testStepThenDifferentStep() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepThenDifferentStep.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/stepped")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Stepped {
                @Test
                public void testAllFilesPresentInStepped() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/stepped"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="illegalStepConst.kt")
                public void testIllegalStepConst() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/illegalStepConst.kt");
                }

                @Test
                @TestMetadata(value="reversedThenStep.kt")
                public void testReversedThenStep() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/reversedThenStep.kt");
                }

                @Test
                @TestMetadata(value="stepConst.kt")
                public void testStepConst() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepConst.kt");
                }

                @Test
                @TestMetadata(value="stepConstOnNonLiteralProgression.kt")
                public void testStepConstOnNonLiteralProgression() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepConstOnNonLiteralProgression.kt");
                }

                @Test
                @TestMetadata(value="stepNonConst.kt")
                public void testStepNonConst() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepNonConst.kt");
                }

                @Test
                @TestMetadata(value="stepNonConstOnNonLiteralProgression.kt")
                public void testStepNonConstOnNonLiteralProgression() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepNonConstOnNonLiteralProgression.kt");
                }

                @Test
                @TestMetadata(value="stepOnNonLiteralRange.kt")
                public void testStepOnNonLiteralRange() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOnNonLiteralRange.kt");
                }

                @Test
                @TestMetadata(value="stepOne.kt")
                public void testStepOne() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOne.kt");
                }

                @Test
                @TestMetadata(value="stepOneThenStepOne.kt")
                public void testStepOneThenStepOne() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOneThenStepOne.kt");
                }

                @Test
                @TestMetadata(value="stepThenDifferentStep.kt")
                public void testStepThenDifferentStep() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenDifferentStep.kt");
                }

                @Test
                @TestMetadata(value="stepThenReversed.kt")
                public void testStepThenReversed() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenReversed.kt");
                }

                @Test
                @TestMetadata(value="stepThenSameStep.kt")
                public void testStepThenSameStep() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenSameStep.kt");
                }

                @Test
                @TestMetadata(value="stepThenStepNonConst.kt")
                public void testStepThenStepNonConst() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenStepNonConst.kt");
                }

                @Test
                @TestMetadata(value="stepThenStepOne.kt")
                public void testStepThenStepOne() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenStepOne.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInUntil")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInUntil {
                @Test
                public void testAllFilesPresentInForInUntil() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInUntil"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInUntilChar.kt")
                public void testForInUntilChar() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilChar.kt");
                }

                @Test
                @TestMetadata(value="forInUntilCharMaxValue.kt")
                public void testForInUntilCharMaxValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilCharMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilCharMinValue.kt")
                public void testForInUntilCharMinValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilCharMinValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilInt.kt")
                public void testForInUntilInt() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilInt.kt");
                }

                @Test
                @TestMetadata(value="forInUntilIntMaxValue.kt")
                public void testForInUntilIntMaxValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilIntMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilIntMinValue.kt")
                public void testForInUntilIntMinValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilIntMinValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilLong.kt")
                public void testForInUntilLong() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLong.kt");
                }

                @Test
                @TestMetadata(value="forInUntilLongMaxValue.kt")
                public void testForInUntilLongMaxValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLongMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInUntilLongMinValue.kt")
                public void testForInUntilLongMinValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLongMinValue.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInSequenceWithIndex {
                @Test
                public void testAllFilesPresentInForInSequenceWithIndex() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInEmptySequenceWithIndex.kt")
                public void testForInEmptySequenceWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInEmptySequenceWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInSequenceTypeParameterWithIndex.kt")
                public void testForInSequenceTypeParameterWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceTypeParameterWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInSequenceWithIndex.kt")
                public void testForInSequenceWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInSequenceWithIndexNoElementVar.kt")
                public void testForInSequenceWithIndexNoElementVar() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexNoElementVar.kt");
                }

                @Test
                @TestMetadata(value="forInSequenceWithIndexNoIndexVar.kt")
                public void testForInSequenceWithIndexNoIndexVar() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVar.kt");
                }

                @Test
                @TestMetadata(value="forInSequenceWithIndexThrowsCME.kt")
                public void testForInSequenceWithIndexThrowsCME() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexThrowsCME.kt");
                }

                @Test
                @TestMetadata(value="forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt")
                public void testForInSequenceWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInReversed")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInReversed {
                @Test
                public void testAllFilesPresentInForInReversed() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInReversed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInReversedArrayIndices.kt")
                public void testForInReversedArrayIndices() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedArrayIndices.kt");
                }

                @Test
                @TestMetadata(value="forInReversedCharSequenceIndices.kt")
                public void testForInReversedCharSequenceIndices() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedCharSequenceIndices.kt");
                }

                @Test
                @TestMetadata(value="forInReversedCollectionIndices.kt")
                public void testForInReversedCollectionIndices() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedCollectionIndices.kt");
                }

                @Test
                @TestMetadata(value="forInReversedDownTo.kt")
                public void testForInReversedDownTo() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedDownTo.kt");
                }

                @Test
                @TestMetadata(value="forInReversedEmptyRangeLiteral.kt")
                public void testForInReversedEmptyRangeLiteral() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedEmptyRangeLiteral.kt");
                }

                @Test
                @TestMetadata(value="forInReversedRange.kt")
                public void testForInReversedRange() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedRange.kt");
                }

                @Test
                @TestMetadata(value="forInReversedRangeLiteral.kt")
                public void testForInReversedRangeLiteral() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedRangeLiteral.kt");
                }

                @Test
                @TestMetadata(value="forInReversedReversedArrayIndices.kt")
                public void testForInReversedReversedArrayIndices() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedArrayIndices.kt");
                }

                @Test
                @TestMetadata(value="forInReversedReversedDownTo.kt")
                public void testForInReversedReversedDownTo() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedDownTo.kt");
                }

                @Test
                @TestMetadata(value="forInReversedReversedRange.kt")
                public void testForInReversedReversedRange() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedRange.kt");
                }

                @Test
                @TestMetadata(value="forInReversedReversedReversedRange.kt")
                public void testForInReversedReversedReversedRange() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedReversedRange.kt");
                }

                @Test
                @TestMetadata(value="forInReversedReversedUntil.kt")
                public void testForInReversedReversedUntil() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedUntil.kt");
                }

                @Test
                @TestMetadata(value="forInReversedUntil.kt")
                public void testForInReversedUntil() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedUntil.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInRangeWithUpperBoundMinus1 {
                @Test
                public void testAllFilesPresentInForInRangeWithUpperBoundMinus1() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="booleanArray.kt")
                public void testBooleanArray() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/booleanArray.kt");
                }

                @Test
                @TestMetadata(value="byteArray.kt")
                public void testByteArray() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/byteArray.kt");
                }

                @Test
                @TestMetadata(value="charArray.kt")
                public void testCharArray() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/charArray.kt");
                }

                @Test
                @TestMetadata(value="charSequence.kt")
                public void testCharSequence() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/charSequence.kt");
                }

                @Test
                @TestMetadata(value="doubleArray.kt")
                public void testDoubleArray() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/doubleArray.kt");
                }

                @Test
                @TestMetadata(value="emptyList.kt")
                public void testEmptyList() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptyList.kt");
                }

                @Test
                @TestMetadata(value="emptyMap.kt")
                public void testEmptyMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptyMap.kt");
                }

                @Test
                @TestMetadata(value="emptySet.kt")
                public void testEmptySet() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptySet.kt");
                }

                @Test
                @TestMetadata(value="floatArray.kt")
                public void testFloatArray() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/floatArray.kt");
                }

                @Test
                @TestMetadata(value="intArray.kt")
                public void testIntArray() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/intArray.kt");
                }

                @Test
                @TestMetadata(value="list.kt")
                public void testList() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/list.kt");
                }

                @Test
                @TestMetadata(value="longArray.kt")
                public void testLongArray() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/longArray.kt");
                }

                @Test
                @TestMetadata(value="map.kt")
                public void testMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/map.kt");
                }

                @Test
                @TestMetadata(value="mutableList.kt")
                public void testMutableList() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableList.kt");
                }

                @Test
                @TestMetadata(value="mutableMap.kt")
                public void testMutableMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableMap.kt");
                }

                @Test
                @TestMetadata(value="mutableSet.kt")
                public void testMutableSet() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableSet.kt");
                }

                @Test
                @TestMetadata(value="set.kt")
                public void testSet() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/set.kt");
                }

                @Test
                @TestMetadata(value="shortArray.kt")
                public void testShortArray() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/shortArray.kt");
                }

                @Test
                @TestMetadata(value="string.kt")
                public void testString() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/string.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInRangeUntil {
                @Test
                public void testAllFilesPresentInForInRangeUntil() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInRangeUntilChar.kt")
                public void testForInRangeUntilChar() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilChar.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilCharMaxValue.kt")
                public void testForInRangeUntilCharMaxValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilCharMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilCharMinValue.kt")
                public void testForInRangeUntilCharMinValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilCharMinValue.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilInt.kt")
                public void testForInRangeUntilInt() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilInt.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilIntMaxValue.kt")
                public void testForInRangeUntilIntMaxValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilIntMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilIntMinValue.kt")
                public void testForInRangeUntilIntMinValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilIntMinValue.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilLong.kt")
                public void testForInRangeUntilLong() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLong.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilLongMaxValue.kt")
                public void testForInRangeUntilLongMaxValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLongMaxValue.kt");
                }

                @Test
                @TestMetadata(value="forInRangeUntilLongMinValue.kt")
                public void testForInRangeUntilLongMinValue() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLongMinValue.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInProgressionWithIndex {
                @Test
                public void testAllFilesPresentInForInProgressionWithIndex() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInDownToWithIndex.kt")
                public void testForInDownToWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInDownToWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInIndicesWithIndex.kt")
                public void testForInIndicesWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInIndicesWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInRangeToWithIndex.kt")
                public void testForInRangeToWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInRangeToWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInReversedStepWithIndex.kt")
                public void testForInReversedStepWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInReversedStepWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInReversedWithIndex.kt")
                public void testForInReversedWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInReversedWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInStepReversedWithIndex.kt")
                public void testForInStepReversedWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInStepReversedWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInStepWithIndex.kt")
                public void testForInStepWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInStepWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInUntilWithIndex.kt")
                public void testForInUntilWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInUntilWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInWithIndexNoIndexOrElementVar.kt")
                public void testForInWithIndexNoIndexOrElementVar() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexNoIndexOrElementVar.kt");
                }

                @Test
                @TestMetadata(value="forInWithIndexNotDestructured.kt")
                public void testForInWithIndexNotDestructured() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexNotDestructured.kt");
                }

                @Test
                @TestMetadata(value="forInWithIndexReversed.kt")
                public void testForInWithIndexReversed() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexReversed.kt");
                }

                @Test
                @TestMetadata(value="forInWithIndexWithIndex.kt")
                public void testForInWithIndexWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexWithIndex.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInIterableWithIndex {
                @Test
                public void testAllFilesPresentInForInIterableWithIndex() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInEmptyListWithIndex.kt")
                public void testForInEmptyListWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInEmptyListWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInIterableTypeParameterWithIndex.kt")
                public void testForInIterableTypeParameterWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInIterableTypeParameterWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInListWithIndex.kt")
                public void testForInListWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInListWithIndexNoElementVar.kt")
                public void testForInListWithIndexNoElementVar() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexNoElementVar.kt");
                }

                @Test
                @TestMetadata(value="forInListWithIndexNoIndexVar.kt")
                public void testForInListWithIndexNoIndexVar() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexNoIndexVar.kt");
                }

                @Test
                @TestMetadata(value="forInListWithIndexWithExplicitlyTypedIndexVariable.kt")
                public void testForInListWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexWithExplicitlyTypedIndexVariable.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInIndices")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInIndices {
                @Test
                public void testAllFilesPresentInForInIndices() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIndices"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInArrayListIndices.kt")
                public void testForInArrayListIndices() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInArrayListIndices.kt");
                }

                @Test
                @TestMetadata(value="forInCharSequenceIndices.kt")
                public void testForInCharSequenceIndices() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCharSequenceIndices.kt");
                }

                @Test
                @TestMetadata(value="forInCharSequenceTypeParameterIndices.kt")
                public void testForInCharSequenceTypeParameterIndices() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCharSequenceTypeParameterIndices.kt");
                }

                @Test
                @TestMetadata(value="forInCollectionImplicitReceiverIndices.kt")
                public void testForInCollectionImplicitReceiverIndices() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionImplicitReceiverIndices.kt");
                }

                @Test
                @TestMetadata(value="forInCollectionIndices.kt")
                public void testForInCollectionIndices() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionIndices.kt");
                }

                @Test
                @TestMetadata(value="forInCollectionTypeParameterIndices.kt")
                public void testForInCollectionTypeParameterIndices() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionTypeParameterIndices.kt");
                }

                @Test
                @TestMetadata(value="forInNonOptimizedIndices.kt")
                public void testForInNonOptimizedIndices() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInNonOptimizedIndices.kt");
                }

                @Test
                @TestMetadata(value="forInObjectArrayIndices.kt")
                public void testForInObjectArrayIndices() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInObjectArrayIndices.kt");
                }

                @Test
                @TestMetadata(value="forInPrimitiveArrayIndices.kt")
                public void testForInPrimitiveArrayIndices() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInPrimitiveArrayIndices.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInCharSequenceWithIndex {
                @Test
                public void testAllFilesPresentInForInCharSequenceWithIndex() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInCharSequenceWithIndex.kt")
                public void testForInCharSequenceWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInCharSequenceWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInEmptyStringWithIndex.kt")
                public void testForInEmptyStringWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInEmptyStringWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInStringWithIndex.kt")
                public void testForInStringWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInStringWithIndexNoElementVar.kt")
                public void testForInStringWithIndexNoElementVar() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexNoElementVar.kt");
                }

                @Test
                @TestMetadata(value="forInStringWithIndexNoIndexVar.kt")
                public void testForInStringWithIndexNoIndexVar() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexNoIndexVar.kt");
                }

                @Test
                @TestMetadata(value="forInStringWithIndexWithExplicitlyTypedIndexVariable.kt")
                public void testForInStringWithIndexWithExplicitlyTypedIndexVariable() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexWithExplicitlyTypedIndexVariable.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ForInArrayWithIndex {
                @Test
                public void testAllFilesPresentInForInArrayWithIndex() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="forInArrayWithIndexNoElementVar.kt")
                public void testForInArrayWithIndexNoElementVar() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInArrayWithIndexNoElementVar.kt");
                }

                @Test
                @TestMetadata(value="forInArrayWithIndexNoIndexVar.kt")
                public void testForInArrayWithIndexNoIndexVar() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInArrayWithIndexNoIndexVar.kt");
                }

                @Test
                @TestMetadata(value="forInEmptyArrayWithIndex.kt")
                public void testForInEmptyArrayWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInEmptyArrayWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInIntArrayWithIndex.kt")
                public void testForInIntArrayWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInIntArrayWithIndex.kt");
                }

                @Test
                @TestMetadata(value="forInObjectArrayWithIndex.kt")
                public void testForInObjectArrayWithIndex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInObjectArrayWithIndex.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/fieldsForCapturedValues")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FieldsForCapturedValues {
            @Test
            public void testAllFilesPresentInFieldsForCapturedValues() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="constructorOnly.kt")
            public void testConstructorOnly() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/constructorOnly.kt");
            }

            @Test
            @TestMetadata(value="extensionLambdaExtensionReceiver.kt")
            public void testExtensionLambdaExtensionReceiver() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/extensionLambdaExtensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="extensionReceiver.kt")
            public void testExtensionReceiver() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/extensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="innerAndOuterThis.kt")
            public void testInnerAndOuterThis() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/innerAndOuterThis.kt");
            }

            @Test
            @TestMetadata(value="labeledExtensionLambdaExtensionReceiver.kt")
            public void testLabeledExtensionLambdaExtensionReceiver() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/labeledExtensionLambdaExtensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="multipleExtensionReceivers.kt")
            public void testMultipleExtensionReceivers() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/multipleExtensionReceivers.kt");
            }

            @Test
            @TestMetadata(value="outerThis.kt")
            public void testOuterThis() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThis.kt");
            }

            @Test
            @TestMetadata(value="outerThisInInnerConstructor.kt")
            public void testOuterThisInInnerConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThisInInnerConstructor.kt");
            }

            @Test
            @TestMetadata(value="outerThisInInnerInitBlock.kt")
            public void testOuterThisInInnerInitBlock() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThisInInnerInitBlock.kt");
            }

            @Test
            @TestMetadata(value="this.kt")
            public void testThis() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/this.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/exclExcl")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ExclExcl {
            @Test
            public void testAllFilesPresentInExclExcl() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/exclExcl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="exclExclOnPlatformType.kt")
            public void testExclExclOnPlatformType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/exclExcl/exclExclOnPlatformType.kt");
            }

            @Test
            @TestMetadata(value="primitive.kt")
            public void testPrimitive() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/exclExcl/primitive.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/enum")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Enum {
            @Test
            public void testAllFilesPresentInEnum() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="constructorAccessors.kt")
            public void testConstructorAccessors() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/constructorAccessors.kt");
            }

            @Test
            @TestMetadata(value="enumCheckcasts.kt")
            public void testEnumCheckcasts() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumCheckcasts.kt");
            }

            @Test
            @TestMetadata(value="enumEntries.kt")
            public void testEnumEntries() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntries.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesIntrinsic.kt")
            public void testEnumEntriesIntrinsic() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesIntrinsic.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesIntrinsicForJava.kt")
            public void testEnumEntriesIntrinsicForJava() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesIntrinsicForJava.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesMapping.kt")
            public void testEnumEntriesMapping() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesMapping.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesMultiMapping.kt")
            public void testEnumEntriesMultiMapping() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesMultiMapping.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesNoMapping.kt")
            public void testEnumEntriesNoMapping() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesNoMapping.kt");
            }

            @Test
            @TestMetadata(value="kt18731.kt")
            public void testKt18731() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/kt18731.kt");
            }

            @Test
            @TestMetadata(value="kt18731_2.kt")
            public void testKt18731_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/kt18731_2.kt");
            }

            @Test
            @TestMetadata(value="kt57671_1.kt")
            public void testKt57671_1() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/kt57671_1.kt");
            }

            @Test
            @TestMetadata(value="kt57671_2.kt")
            public void testKt57671_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/kt57671_2.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/disabledOptimizations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DisabledOptimizations {
            @Test
            public void testAllFilesPresentInDisabledOptimizations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/disabledOptimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="noJumpInLastBranch.kt")
            public void testNoJumpInLastBranch() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noJumpInLastBranch.kt");
            }

            @Test
            @TestMetadata(value="noJumpInSingleBranch.kt")
            public void testNoJumpInSingleBranch() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noJumpInSingleBranch.kt");
            }

            @Test
            @TestMetadata(value="noObjectCastAfterReification.kt")
            public void testNoObjectCastAfterReification() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noObjectCastAfterReification.kt");
            }

            @Test
            @TestMetadata(value="noUnitInstanceInDefaultParameterInitialization.kt")
            public void testNoUnitInstanceInDefaultParameterInitialization() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnitInstanceInDefaultParameterInitialization.kt");
            }

            @Test
            @TestMetadata(value="noUnitInstanceOnVoidFunctionCall.kt")
            public void testNoUnitInstanceOnVoidFunctionCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnitInstanceOnVoidFunctionCall.kt");
            }

            @Test
            @TestMetadata(value="noUnusedLabel.kt")
            public void testNoUnusedLabel() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnusedLabel.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/directInvoke")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DirectInvoke {
            @Test
            public void testAllFilesPresentInDirectInvoke() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/directInvoke"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="callableReference.kt")
            public void testCallableReference() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/directInvoke/callableReference.kt");
            }

            @Test
            @TestMetadata(value="inplaceClosure.kt")
            public void testInplaceClosure() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/directInvoke/inplaceClosure.kt");
            }

            @Test
            @TestMetadata(value="localFun.kt")
            public void testLocalFun() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/directInvoke/localFun.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/defaultArguments")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DefaultArguments {
            @Test
            public void testAllFilesPresentInDefaultArguments() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="inheritedInterfaceFunction.kt")
            public void testInheritedInterfaceFunction() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/inheritedInterfaceFunction.kt");
            }

            @Test
            @TestMetadata(value="kt11962.kt")
            public void testKt11962() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/kt11962.kt");
            }

            @Test
            @TestMetadata(value="localVariablesInInlinedDefaultStubs.kt")
            public void testLocalVariablesInInlinedDefaultStubs() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/localVariablesInInlinedDefaultStubs.kt");
            }

            @Test
            @TestMetadata(value="maskAndArgumentElimination.kt")
            public void testMaskAndArgumentElimination() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/maskAndArgumentElimination.kt");
            }

            @Test
            @TestMetadata(value="maskCheckSequence.kt")
            public void testMaskCheckSequence() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/maskCheckSequence.kt");
            }

            @Test
            @TestMetadata(value="methodHandlerElimination.kt")
            public void testMethodHandlerElimination() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/methodHandlerElimination.kt");
            }

            @Test
            @TestMetadata(value="noAccessorForDefault.kt")
            public void testNoAccessorForDefault() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noAccessorForDefault.kt");
            }

            @Test
            @TestMetadata(value="noAnonymousObjectRegenerationInDefaultStub.kt")
            public void testNoAnonymousObjectRegenerationInDefaultStub() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noAnonymousObjectRegenerationInDefaultStub.kt");
            }

            @Test
            @TestMetadata(value="noEmptyArray.kt")
            public void testNoEmptyArray() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noEmptyArray.kt");
            }

            @Test
            @TestMetadata(value="noSyntheticParameters.kt")
            public void testNoSyntheticParameters() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noSyntheticParameters.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/deadCodeElimination")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DeadCodeElimination {
            @Test
            public void testAllFilesPresentInDeadCodeElimination() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/deadCodeElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayConstructor.kt")
            public void testArrayConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/arrayConstructor.kt");
            }

            @Test
            @TestMetadata(value="boxing.kt")
            public void testBoxing() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/boxing.kt");
            }

            @Test
            @TestMetadata(value="boxingNotOptimizable.kt")
            public void testBoxingNotOptimizable() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/boxingNotOptimizable.kt");
            }

            @Test
            @TestMetadata(value="emptyVariableRange.kt")
            public void testEmptyVariableRange() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/emptyVariableRange.kt");
            }

            @Test
            @TestMetadata(value="kt14357.kt")
            public void testKt14357() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/kt14357.kt");
            }

            @Test
            @TestMetadata(value="lastReturn.kt")
            public void testLastReturn() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/lastReturn.kt");
            }

            @Test
            @TestMetadata(value="literal.kt")
            public void testLiteral() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/literal.kt");
            }

            @Test
            @TestMetadata(value="simpleConstructor.kt")
            public void testSimpleConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructor.kt");
            }

            @Test
            @TestMetadata(value="simpleConstructorNotRedundant.kt")
            public void testSimpleConstructorNotRedundant() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructorNotRedundant.kt");
            }

            @Test
            @TestMetadata(value="simpleConstructorNotRedundantNotOptimizable.kt")
            public void testSimpleConstructorNotRedundantNotOptimizable() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructorNotRedundantNotOptimizable.kt");
            }

            @Test
            @TestMetadata(value="unusedPrimitiveAndObjectEquals.kt")
            public void testUnusedPrimitiveAndObjectEquals() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/unusedPrimitiveAndObjectEquals.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Coroutines {
            @Test
            public void testAllFilesPresentInCoroutines() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="crossinlineSuspendContinuation_1_3.kt")
            public void testCrossinlineSuspendContinuation_1_3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/crossinlineSuspendContinuation_1_3.kt");
            }

            @Test
            @TestMetadata(value="doNotReassignContinuation.kt")
            public void testDoNotReassignContinuation() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/doNotReassignContinuation.kt");
            }

            @Test
            @TestMetadata(value="effectivelyInlineOnly.kt")
            public void testEffectivelyInlineOnly() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/effectivelyInlineOnly.kt");
            }

            @Test
            @TestMetadata(value="internalInlineSuspend.kt")
            public void testInternalInlineSuspend() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/internalInlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="mergeLvt.kt")
            public void testMergeLvt() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/mergeLvt.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn.kt")
            public void testNonLocalReturn() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/nonLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="returnUnitInLambda.kt")
            public void testReturnUnitInLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/returnUnitInLambda.kt");
            }

            @Test
            @TestMetadata(value="suspendMain.kt")
            public void testSuspendMain() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/suspendMain.kt");
            }

            @Test
            @TestMetadata(value="throwOnFailure.kt")
            public void testThrowOnFailure() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/throwOnFailure.kt");
            }

            @Test
            @TestMetadata(value="varValueConflictsWithTable.kt")
            public void testVarValueConflictsWithTable() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTable.kt");
            }

            @Test
            @TestMetadata(value="varValueConflictsWithTableSameSort.kt")
            public void testVarValueConflictsWithTableSameSort() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTableSameSort.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/stateMachine")
            @TestDataPath(value="$PROJECT_ROOT")
            public class StateMachine {
                @Test
                public void testAllFilesPresentInStateMachine() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/stateMachine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="kt25893.kt")
                public void testKt25893() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/stateMachine/kt25893.kt");
                }

                @Test
                @TestMetadata(value="withTypeParameter.kt")
                public void testWithTypeParameter() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/stateMachine/withTypeParameter.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling")
            @TestDataPath(value="$PROJECT_ROOT")
            public class IntLikeVarSpilling {
                @Test
                public void testAllFilesPresentInIntLikeVarSpilling() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="complicatedMerge.kt")
                public void testComplicatedMerge() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/complicatedMerge.kt");
                }

                @Test
                @TestMetadata(value="i2bResult.kt")
                public void testI2bResult() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/i2bResult.kt");
                }

                @Test
                @TestMetadata(value="loadFromBooleanArray.kt")
                public void testLoadFromBooleanArray() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt");
                }

                @Test
                @TestMetadata(value="loadFromByteArray.kt")
                public void testLoadFromByteArray() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromByteArray.kt");
                }

                @Test
                @TestMetadata(value="noVariableInTable.kt")
                public void testNoVariableInTable() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/noVariableInTable.kt");
                }

                @Test
                @TestMetadata(value="sameIconst1ManyVars.kt")
                public void testSameIconst1ManyVars() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt");
                }

                @Test
                @TestMetadata(value="usedInArrayStore.kt")
                public void testUsedInArrayStore() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInArrayStore.kt");
                }

                @Test
                @TestMetadata(value="usedInMethodCall.kt")
                public void testUsedInMethodCall() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInMethodCall.kt");
                }

                @Test
                @TestMetadata(value="usedInPutfield.kt")
                public void testUsedInPutfield() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInPutfield.kt");
                }

                @Test
                @TestMetadata(value="usedInVarStore.kt")
                public void testUsedInVarStore() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInVarStore.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/inlineClasses")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineClasses {
                @Test
                public void testAllFilesPresentInInlineClasses() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineClassBoxingInSuspendFunReturn_Primitive.kt")
                public void testInlineClassBoxingInSuspendFunReturn_Primitive() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/inlineClassBoxingInSuspendFunReturn_Primitive.kt");
                }

                @Test
                @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_Any.kt")
                public void testNoInlineClassBoxingInSuspendFunReturn_Any() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_Any.kt");
                }

                @Test
                @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_InlineAny.kt")
                public void testNoInlineClassBoxingInSuspendFunReturn_InlineAny() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_InlineAny.kt");
                }

                @Test
                @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_SameJvmType.kt")
                public void testNoInlineClassBoxingInSuspendFunReturn_SameJvmType() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_SameJvmType.kt");
                }

                @Test
                @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_String.kt")
                public void testNoInlineClassBoxingInSuspendFunReturn_String() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_String.kt");
                }

                @Test
                @TestMetadata(value="returnResult.kt")
                public void testReturnResult() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/returnResult.kt");
                }

                @Test
                @TestMetadata(value="returnStringOverride.kt")
                public void testReturnStringOverride() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/returnStringOverride.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DestructuringInLambda {
                @Test
                public void testAllFilesPresentInDestructuringInLambda() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineSeparateFiles.kt")
                public void testInlineSeparateFiles() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda/inlineSeparateFiles.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/debug")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Debug {
                @Test
                public void testAllFilesPresentInDebug() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/debug"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="continuationInLvt.kt")
                public void testContinuationInLvt() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/continuationInLvt.kt");
                }

                @Test
                @TestMetadata(value="localVariableCorrectLabel.kt")
                public void testLocalVariableCorrectLabel() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/localVariableCorrectLabel.kt");
                }

                @Test
                @TestMetadata(value="probeCoroutineSuspended.kt")
                public void testProbeCoroutineSuspended() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/probeCoroutineSuspended.kt");
                }

                @Test
                @TestMetadata(value="shrinkLvtTopLevel.kt")
                public void testShrinkLvtTopLevel() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/shrinkLvtTopLevel.kt");
                }

                @Test
                @TestMetadata(value="thisAndResultInLvt.kt")
                public void testThisAndResultInLvt() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/thisAndResultInLvt.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/controlStructures")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ControlStructures {
            @Test
            public void testAllFilesPresentInControlStructures() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/controlStructures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="ifConsts.kt")
            public void testIfConsts() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/controlStructures/ifConsts.kt");
            }

            @Test
            @TestMetadata(value="kt17110.kt")
            public void testKt17110() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/controlStructures/kt17110.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/constructors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Constructors {
            @Test
            public void testAllFilesPresentInConstructors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constructors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="enumPrimaryDefaults.kt")
            public void testEnumPrimaryDefaults() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/enumPrimaryDefaults.kt");
            }

            @Test
            @TestMetadata(value="inlineArgumentPrimaryDefaults.kt")
            public void testInlineArgumentPrimaryDefaults() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/inlineArgumentPrimaryDefaults.kt");
            }

            @Test
            @TestMetadata(value="inlinePrimaryDefaults.kt")
            public void testInlinePrimaryDefaults() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/inlinePrimaryDefaults.kt");
            }

            @Test
            @TestMetadata(value="innerClassConstructor.kt")
            public void testInnerClassConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/innerClassConstructor.kt");
            }

            @Test
            @TestMetadata(value="innerPrimaryDefaults.kt")
            public void testInnerPrimaryDefaults() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/innerPrimaryDefaults.kt");
            }

            @Test
            @TestMetadata(value="internalPrimaryDefaults.kt")
            public void testInternalPrimaryDefaults() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/internalPrimaryDefaults.kt");
            }

            @Test
            @TestMetadata(value="localPrimaryDefaults.kt")
            public void testLocalPrimaryDefaults() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/localPrimaryDefaults.kt");
            }

            @Test
            @TestMetadata(value="parameterlessPrimary.kt")
            public void testParameterlessPrimary() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/parameterlessPrimary.kt");
            }

            @Test
            @TestMetadata(value="privatePrimaryDefaults.kt")
            public void testPrivatePrimaryDefaults() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/privatePrimaryDefaults.kt");
            }

            @Test
            @TestMetadata(value="protectedPrimaryDefaults.kt")
            public void testProtectedPrimaryDefaults() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/protectedPrimaryDefaults.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/constants")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Constants {
            @Test
            public void testAllFilesPresentInConstants() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constants"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="byte.kt")
            public void testByte() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/byte.kt");
            }

            @Test
            @TestMetadata(value="comparisonFalse.kt")
            public void testComparisonFalse() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/comparisonFalse.kt");
            }

            @Test
            @TestMetadata(value="comparisonTrue.kt")
            public void testComparisonTrue() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/comparisonTrue.kt");
            }

            @Test
            @TestMetadata(value="floatingPoints.kt")
            public void testFloatingPoints() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/floatingPoints.kt");
            }

            @Test
            @TestMetadata(value="inlineUnsignedIntConstant.kt")
            public void testInlineUnsignedIntConstant() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/inlineUnsignedIntConstant.kt");
            }

            @Test
            @TestMetadata(value="kt9532.kt")
            public void testKt9532() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/kt9532.kt");
            }

            @Test
            @TestMetadata(value="noInlineNonConst.kt")
            public void testNoInlineNonConst() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonConst.kt");
            }

            @Test
            @TestMetadata(value="noInlineNonStaticJavaField.kt")
            public void testNoInlineNonStaticJavaField() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonStaticJavaField.kt");
            }

            @Test
            @TestMetadata(value="nullableByteAndShort.kt")
            public void testNullableByteAndShort() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/nullableByteAndShort.kt");
            }

            @Test
            @TestMetadata(value="partialString.kt")
            public void testPartialString() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/partialString.kt");
            }

            @Test
            @TestMetadata(value="short.kt")
            public void testShort() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/short.kt");
            }

            @Test
            @TestMetadata(value="string.kt")
            public void testString() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/string.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/constantConditions")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ConstantConditions {
            @Test
            public void testAllFilesPresentInConstantConditions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constantConditions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="cmpIntWith0.kt")
            public void testCmpIntWith0() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/cmpIntWith0.kt");
            }

            @Test
            @TestMetadata(value="constantFlag.kt")
            public void testConstantFlag() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/constantFlag.kt");
            }

            @Test
            @TestMetadata(value="constantInt.kt")
            public void testConstantInt() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/constantInt.kt");
            }

            @Test
            @TestMetadata(value="inlineIfFalse.kt")
            public void testInlineIfFalse() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/inlineIfFalse.kt");
            }

            @Test
            @TestMetadata(value="kt3098.kt")
            public void testKt3098() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/kt3098.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/constProperty")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ConstProperty {
            @Test
            public void testAllFilesPresentInConstProperty() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="noAccessorsForPrivateConstants.kt")
            public void testNoAccessorsForPrivateConstants() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constProperty/noAccessorsForPrivateConstants.kt");
            }

            @Test
            @TestMetadata(value="nonConstValHasNoDefaultValue_after.kt")
            public void testNonConstValHasNoDefaultValue_after() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constProperty/nonConstValHasNoDefaultValue_after.kt");
            }

            @Test
            @TestMetadata(value="nonConstValHasNoDefaultValue_before.kt")
            public void testNonConstValHasNoDefaultValue_before() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constProperty/nonConstValHasNoDefaultValue_before.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/conditions")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Conditions {
            @Test
            public void testAllFilesPresentInConditions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/conditions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="conjunction.kt")
            public void testConjunction() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/conjunction.kt");
            }

            @Test
            @TestMetadata(value="conjunctionInDoWhile.kt")
            public void testConjunctionInDoWhile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/conjunctionInDoWhile.kt");
            }

            @Test
            @TestMetadata(value="conjunctionInWhile.kt")
            public void testConjunctionInWhile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/conjunctionInWhile.kt");
            }

            @Test
            @TestMetadata(value="disjunction.kt")
            public void testDisjunction() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/disjunction.kt");
            }

            @Test
            @TestMetadata(value="negatedConjuction.kt")
            public void testNegatedConjuction() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedConjuction.kt");
            }

            @Test
            @TestMetadata(value="negatedDisjunction.kt")
            public void testNegatedDisjunction() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedDisjunction.kt");
            }

            @Test
            @TestMetadata(value="negatedNonZeroCompareInDoWhile.kt")
            public void testNegatedNonZeroCompareInDoWhile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInDoWhile.kt");
            }

            @Test
            @TestMetadata(value="negatedNonZeroCompareInIf.kt")
            public void testNegatedNonZeroCompareInIf() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInIf.kt");
            }

            @Test
            @TestMetadata(value="negatedNonZeroCompareInWhile.kt")
            public void testNegatedNonZeroCompareInWhile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInWhile.kt");
            }

            @Test
            @TestMetadata(value="negatedNullCompareInDoWhile.kt")
            public void testNegatedNullCompareInDoWhile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInDoWhile.kt");
            }

            @Test
            @TestMetadata(value="negatedNullCompareInIf.kt")
            public void testNegatedNullCompareInIf() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInIf.kt");
            }

            @Test
            @TestMetadata(value="negatedNullCompareInWhile.kt")
            public void testNegatedNullCompareInWhile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInWhile.kt");
            }

            @Test
            @TestMetadata(value="negatedZeroCompareInDoWhile.kt")
            public void testNegatedZeroCompareInDoWhile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInDoWhile.kt");
            }

            @Test
            @TestMetadata(value="negatedZeroCompareInIf.kt")
            public void testNegatedZeroCompareInIf() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInIf.kt");
            }

            @Test
            @TestMetadata(value="negatedZeroCompareInWhile.kt")
            public void testNegatedZeroCompareInWhile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInWhile.kt");
            }

            @Test
            @TestMetadata(value="noBoxingForBoxedEqPrimitive.kt")
            public void testNoBoxingForBoxedEqPrimitive() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForBoxedEqPrimitive.kt");
            }

            @Test
            @TestMetadata(value="noBoxingForPrimitiveEqBoxed.kt")
            public void testNoBoxingForPrimitiveEqBoxed() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForPrimitiveEqBoxed.kt");
            }

            @Test
            @TestMetadata(value="noBoxingForPrimitiveEqObject.kt")
            public void testNoBoxingForPrimitiveEqObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForPrimitiveEqObject.kt");
            }

            @Test
            @TestMetadata(value="nonZeroCompareInDoWhile.kt")
            public void testNonZeroCompareInDoWhile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInDoWhile.kt");
            }

            @Test
            @TestMetadata(value="nonZeroCompareInIf.kt")
            public void testNonZeroCompareInIf() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInIf.kt");
            }

            @Test
            @TestMetadata(value="nonZeroCompareInWhile.kt")
            public void testNonZeroCompareInWhile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInWhile.kt");
            }

            @Test
            @TestMetadata(value="nullCompareConst.kt")
            public void testNullCompareConst() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareConst.kt");
            }

            @Test
            @TestMetadata(value="nullCompareInDoWhile.kt")
            public void testNullCompareInDoWhile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInDoWhile.kt");
            }

            @Test
            @TestMetadata(value="nullCompareInIf.kt")
            public void testNullCompareInIf() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInIf.kt");
            }

            @Test
            @TestMetadata(value="nullCompareInWhile.kt")
            public void testNullCompareInWhile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInWhile.kt");
            }

            @Test
            @TestMetadata(value="zeroCompareInDoWhile.kt")
            public void testZeroCompareInDoWhile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInDoWhile.kt");
            }

            @Test
            @TestMetadata(value="zeroCompareInIf.kt")
            public void testZeroCompareInIf() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInIf.kt");
            }

            @Test
            @TestMetadata(value="zeroCompareInWhile.kt")
            public void testZeroCompareInWhile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInWhile.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/companion")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Companion {
            @Test
            public void testAllFilesPresentInCompanion() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/companion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="directAccessToBackingField.kt")
            public void testDirectAccessToBackingField() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/directAccessToBackingField.kt");
            }

            @Test
            @TestMetadata(value="floatingPointCompanionAccess.kt")
            public void testFloatingPointCompanionAccess() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/floatingPointCompanionAccess.kt");
            }

            @Test
            @TestMetadata(value="inlineFunctionCompanionPropertyAccess.kt")
            public void testInlineFunctionCompanionPropertyAccess() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/inlineFunctionCompanionPropertyAccess.kt");
            }

            @Test
            @TestMetadata(value="inlineFunctionObjectCompanionPropertyAccess.kt")
            public void testInlineFunctionObjectCompanionPropertyAccess() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/inlineFunctionObjectCompanionPropertyAccess.kt");
            }

            @Test
            @TestMetadata(value="kt14258_1.kt")
            public void testKt14258_1() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_1.kt");
            }

            @Test
            @TestMetadata(value="kt14258_2.kt")
            public void testKt14258_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_2.kt");
            }

            @Test
            @TestMetadata(value="kt14258_3.kt")
            public void testKt14258_3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_3.kt");
            }

            @Test
            @TestMetadata(value="kt14258_4.kt")
            public void testKt14258_4() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_4.kt");
            }

            @Test
            @TestMetadata(value="kt14258_5.kt")
            public void testKt14258_5() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_5.kt");
            }

            @Test
            @TestMetadata(value="nonDefaultAccessors.kt")
            public void testNonDefaultAccessors() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/nonDefaultAccessors.kt");
            }

            @Test
            @TestMetadata(value="privateCompanionObjectAccessors_after.kt")
            public void testPrivateCompanionObjectAccessors_after() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/privateCompanionObjectAccessors_after.kt");
            }

            @Test
            @TestMetadata(value="privateCompanionObjectAccessors_before.kt")
            public void testPrivateCompanionObjectAccessors_before() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/privateCompanionObjectAccessors_before.kt");
            }

            @Test
            @TestMetadata(value="protectedCompanionObjectAccessors_after.kt")
            public void testProtectedCompanionObjectAccessors_after() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/protectedCompanionObjectAccessors_after.kt");
            }

            @Test
            @TestMetadata(value="protectedCompanionObjectAccessors_before.kt")
            public void testProtectedCompanionObjectAccessors_before() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/protectedCompanionObjectAccessors_before.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/coercionToUnitOptimization")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CoercionToUnitOptimization {
            @Test
            public void testAllFilesPresentInCoercionToUnitOptimization() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="inRangeCheckWithConst.kt")
            public void testInRangeCheckWithConst() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/inRangeCheckWithConst.kt");
            }

            @Test
            @TestMetadata(value="kt14360.kt")
            public void testKt14360() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/kt14360.kt");
            }

            @Test
            @TestMetadata(value="largeMethodWithCoercionToUnit.kt")
            public void testLargeMethodWithCoercionToUnit() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/largeMethodWithCoercionToUnit.kt");
            }

            @Test
            @TestMetadata(value="nopInlineFuns.kt")
            public void testNopInlineFuns() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/nopInlineFuns.kt");
            }

            @Test
            @TestMetadata(value="returnsUnit.kt")
            public void testReturnsUnit() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/returnsUnit.kt");
            }

            @Test
            @TestMetadata(value="safeCall.kt")
            public void testSafeCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCall.kt");
            }

            @Test
            @TestMetadata(value="safeCallWithReturnValue.kt")
            public void testSafeCallWithReturnValue() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCallWithReturnValue.kt");
            }

            @Test
            @TestMetadata(value="safeLet.kt")
            public void testSafeLet() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeLet.kt");
            }

            @Test
            @TestMetadata(value="tryInlined.kt")
            public void testTryInlined() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/tryInlined.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/checkcast")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Checkcast {
            @Test
            public void testAllFilesPresentInCheckcast() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/checkcast"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt14811.kt")
            public void testKt14811() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt14811.kt");
            }

            @Test
            @TestMetadata(value="kt14963.kt")
            public void testKt14963() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt14963.kt");
            }

            @Test
            @TestMetadata(value="kt15411.kt")
            public void testKt15411() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt15411.kt");
            }

            @Test
            @TestMetadata(value="kt22714.kt")
            public void testKt22714() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt22714.kt");
            }

            @Test
            @TestMetadata(value="kt53465.kt")
            public void testKt53465() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt53465.kt");
            }

            @Test
            @TestMetadata(value="noCheckcastOnDelegatingDefaultImplsCall.kt")
            public void testNoCheckcastOnDelegatingDefaultImplsCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/noCheckcastOnDelegatingDefaultImplsCall.kt");
            }

            @Test
            @TestMetadata(value="noCheckcastOnSuper.kt")
            public void testNoCheckcastOnSuper() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/noCheckcastOnSuper.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/capturedVarsOptimization")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CapturedVarsOptimization {
            @Test
            public void testAllFilesPresentInCapturedVarsOptimization() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/capturedVarsOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="capturedInChainOfInlineFuns.kt")
            public void testCapturedInChainOfInlineFuns() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInChainOfInlineFuns.kt");
            }

            @Test
            @TestMetadata(value="capturedInInlineOnly.kt")
            public void testCapturedInInlineOnly() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInInlineOnly.kt");
            }

            @Test
            @TestMetadata(value="capturedInLocalObject.kt")
            public void testCapturedInLocalObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInLocalObject.kt");
            }

            @Test
            @TestMetadata(value="capturedInNoInlineOnly.kt")
            public void testCapturedInNoInlineOnly() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInNoInlineOnly.kt");
            }

            @Test
            @TestMetadata(value="capturedInNoInlneInsideChainOfInlineFuns.kt")
            public void testCapturedInNoInlneInsideChainOfInlineFuns() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInNoInlneInsideChainOfInlineFuns.kt");
            }

            @Test
            @TestMetadata(value="capturedValInLambdaInitializedInside.kt")
            public void testCapturedValInLambdaInitializedInside() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedValInLambdaInitializedInside.kt");
            }

            @Test
            @TestMetadata(value="capturedValInLambdaInitializedOutside.kt")
            public void testCapturedValInLambdaInitializedOutside() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedValInLambdaInitializedOutside.kt");
            }

            @Test
            @TestMetadata(value="capturedVarsOfSize2.kt")
            public void testCapturedVarsOfSize2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedVarsOfSize2.kt");
            }

            @Test
            @TestMetadata(value="returnValueOfArrayConstructor.kt")
            public void testReturnValueOfArrayConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/returnValueOfArrayConstructor.kt");
            }

            @Test
            @TestMetadata(value="sharedSlotsWithCapturedVars.kt")
            public void testSharedSlotsWithCapturedVars() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/sharedSlotsWithCapturedVars.kt");
            }

            @Test
            @TestMetadata(value="withStackNormalization.kt")
            public void testWithStackNormalization() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/withStackNormalization.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/callableReference")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CallableReference {
            @Test
            public void testAllFilesPresentInCallableReference() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="boundFieldReferenceInInline.kt")
            public void testBoundFieldReferenceInInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/boundFieldReferenceInInline.kt");
            }

            @Test
            @TestMetadata(value="boundFunReferenceInInline.kt")
            public void testBoundFunReferenceInInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/boundFunReferenceInInline.kt");
            }

            @Test
            @TestMetadata(value="boundPropertyReferenceInInline.kt")
            public void testBoundPropertyReferenceInInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/boundPropertyReferenceInInline.kt");
            }

            @Test
            @TestMetadata(value="kt36975.kt")
            public void testKt36975() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/kt36975.kt");
            }

            @Test
            @TestMetadata(value="kt39612.kt")
            public void testKt39612() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/kt39612.kt");
            }

            @Test
            @TestMetadata(value="nameIntrinsicWithImplicitThis.kt")
            public void testNameIntrinsicWithImplicitThis() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/nameIntrinsicWithImplicitThis.kt");
            }

            @Test
            @TestMetadata(value="noMetadata.kt")
            public void testNoMetadata() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/noMetadata.kt");
            }

            @Test
            @TestMetadata(value="unboundFieldReferenceInInline.kt")
            public void testUnboundFieldReferenceInInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundFieldReferenceInInline.kt");
            }

            @Test
            @TestMetadata(value="unboundFunReferenceInInline.kt")
            public void testUnboundFunReferenceInInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundFunReferenceInInline.kt");
            }

            @Test
            @TestMetadata(value="unboundPropertyReferenceInInline.kt")
            public void testUnboundPropertyReferenceInInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundPropertyReferenceInInline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/builtinFunctions")
        @TestDataPath(value="$PROJECT_ROOT")
        public class BuiltinFunctions {
            @Test
            public void testAllFilesPresentInBuiltinFunctions() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="charSequence.kt")
            public void testCharSequence() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/charSequence.kt");
            }

            @Test
            @TestMetadata(value="contains.kt")
            public void testContains() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/contains.kt");
            }

            @Test
            @TestMetadata(value="removeAt.kt")
            public void testRemoveAt() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/removeAt.kt");
            }

            @Test
            @TestMetadata(value="size.kt")
            public void testSize() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/size.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge")
            @TestDataPath(value="$PROJECT_ROOT")
            public class GenericParameterBridge {
                @Test
                @TestMetadata(value="abstractList.kt")
                public void testAbstractList() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/abstractList.kt");
                }

                @Test
                public void testAllFilesPresentInGenericParameterBridge() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="IntMC.kt")
                public void testIntMC() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/IntMC.kt");
                }

                @Test
                @TestMetadata(value="mutableCollection.kt")
                public void testMutableCollection() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableCollection.kt");
                }

                @Test
                @TestMetadata(value="mutableSetInterfaces.kt")
                public void testMutableSetInterfaces() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableSetInterfaces.kt");
                }

                @Test
                @TestMetadata(value="notNullAnyMC.kt")
                public void testNotNullAnyMC() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullAnyMC.kt");
                }

                @Test
                @TestMetadata(value="notNullParamMC.kt")
                public void testNotNullParamMC() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullParamMC.kt");
                }

                @Test
                @TestMetadata(value="nullableAnyMC.kt")
                public void testNullableAnyMC() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/nullableAnyMC.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/boxingOptimization")
        @TestDataPath(value="$PROJECT_ROOT")
        public class BoxingOptimization {
            @Test
            public void testAllFilesPresentInBoxingOptimization() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxingOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="boxingAndEquals.kt")
            public void testBoxingAndEquals() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/boxingAndEquals.kt");
            }

            @Test
            @TestMetadata(value="casts.kt")
            public void testCasts() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/casts.kt");
            }

            @Test
            @TestMetadata(value="checkcastAndInstanceOf.kt")
            public void testCheckcastAndInstanceOf() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/checkcastAndInstanceOf.kt");
            }

            @Test
            @TestMetadata(value="fold.kt")
            public void testFold() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/fold.kt");
            }

            @Test
            @TestMetadata(value="hashCodeOnNonNull.kt")
            public void testHashCodeOnNonNull() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/hashCodeOnNonNull.kt");
            }

            @Test
            @TestMetadata(value="inlineClassesAndInlinedLambda.kt")
            public void testInlineClassesAndInlinedLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/inlineClassesAndInlinedLambda.kt");
            }

            @Test
            @TestMetadata(value="intCompareTo.kt")
            public void testIntCompareTo() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/intCompareTo.kt");
            }

            @Test
            @TestMetadata(value="kClassInAnnotation.kt")
            public void testKClassInAnnotation() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotation.kt");
            }

            @Test
            @TestMetadata(value="kClassInAnnotationEscaping.kt")
            public void testKClassInAnnotationEscaping() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotationEscaping.kt");
            }

            @Test
            @TestMetadata(value="kt15862.kt")
            public void testKt15862() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt15862.kt");
            }

            @Test
            @TestMetadata(value="kt15862_2.kt")
            public void testKt15862_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt15862_2.kt");
            }

            @Test
            @TestMetadata(value="kt6842.kt")
            public void testKt6842() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt6842.kt");
            }

            @Test
            @TestMetadata(value="kt7224.kt")
            public void testKt7224() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt7224.kt");
            }

            @Test
            @TestMetadata(value="maxMinByOrNull.kt")
            public void testMaxMinByOrNull() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/maxMinByOrNull.kt");
            }

            @Test
            @TestMetadata(value="nullCheck.kt")
            public void testNullCheck() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/nullCheck.kt");
            }

            @Test
            @TestMetadata(value="progressions.kt")
            public void testProgressions() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/progressions.kt");
            }

            @Test
            @TestMetadata(value="safeCallToPrimitiveEquality1.kt")
            public void testSafeCallToPrimitiveEquality1() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality1.kt");
            }

            @Test
            @TestMetadata(value="safeCallToPrimitiveEquality2.kt")
            public void testSafeCallToPrimitiveEquality2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality2.kt");
            }

            @Test
            @TestMetadata(value="safeCallToPrimitiveEquality3.kt")
            public void testSafeCallToPrimitiveEquality3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality3.kt");
            }

            @Test
            @TestMetadata(value="safeCallWithElvis.kt")
            public void testSafeCallWithElvis() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallWithElvis.kt");
            }

            @Test
            @TestMetadata(value="safeCallWithElvisMultipleFiles.kt")
            public void testSafeCallWithElvisMultipleFiles() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallWithElvisMultipleFiles.kt");
            }

            @Test
            @TestMetadata(value="severalInlines.kt")
            public void testSeveralInlines() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/severalInlines.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/simple.kt");
            }

            @Test
            @TestMetadata(value="simpleUninitializedMerge.kt")
            public void testSimpleUninitializedMerge() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/simpleUninitializedMerge.kt");
            }

            @Test
            @TestMetadata(value="suspendBoxing.kt")
            public void testSuspendBoxing() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/suspendBoxing.kt");
            }

            @Test
            @TestMetadata(value="unsafeRemoving.kt")
            public void testUnsafeRemoving() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/unsafeRemoving.kt");
            }

            @Test
            @TestMetadata(value="unsignedRangeIteratorSpecialization.kt")
            public void testUnsignedRangeIteratorSpecialization() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/unsignedRangeIteratorSpecialization.kt");
            }

            @Test
            @TestMetadata(value="variableClash.kt")
            public void testVariableClash() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/variableClash.kt");
            }

            @Test
            @TestMetadata(value="variables.kt")
            public void testVariables() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/variables.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/boxing")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Boxing {
            @Test
            public void testAllFilesPresentInBoxing() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="crossinlineSuspend.kt")
            public void testCrossinlineSuspend() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxing/crossinlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspend.kt")
            public void testInlineSuspend() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxing/inlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="suspend.kt")
            public void testSuspend() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxing/suspend.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/assert")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Assert {
            @Test
            public void testAllFilesPresentInAssert() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="jvmCrossinline.kt")
            public void testJvmCrossinline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmCrossinline.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineAssertInLambda.kt")
            public void testJvmCrossinlineAssertInLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmCrossinlineAssertInLambda.kt");
            }

            @Test
            @TestMetadata(value="jvmInline.kt")
            public void testJvmInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmInline.kt");
            }

            @Test
            @TestMetadata(value="jvmInlineLambda.kt")
            public void testJvmInlineLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="jvmNestedClass.kt")
            public void testJvmNestedClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmNestedClass.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/argumentOrder")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ArgumentOrder {
            @Test
            public void testAllFilesPresentInArgumentOrder() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="sameOrder.kt")
            public void testSameOrder() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrder.kt");
            }

            @Test
            @TestMetadata(value="sameOrderWithDefault.kt")
            public void testSameOrderWithDefault() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrderWithDefault.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/boxModernJdk")
    @TestDataPath(value="$PROJECT_ROOT")
    public class BoxModernJdk {
        @Test
        public void testAllFilesPresentInBoxModernJdk() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava21")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TestsWithJava21 {
            @Test
            @TestMetadata(value="addRemoveOnMutableList.kt")
            public void testAddRemoveOnMutableList() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava21/addRemoveOnMutableList.kt");
            }

            @Test
            public void testAllFilesPresentInTestsWithJava21() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava21"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }
        }

        @Nested
        @Tag(value="<modernJava>")
        @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TestsWithJava17 {
            @Test
            public void testAllFilesPresentInTestsWithJava17() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Sealed {
                @Test
                public void testAllFilesPresentInSealed() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="compiledJavaSealedClass.kt")
                public void testCompiledJavaSealedClass() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/compiledJavaSealedClass.kt");
                }

                @Test
                @TestMetadata(value="compiledJavaSealedInterface.kt")
                public void testCompiledJavaSealedInterface() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/compiledJavaSealedInterface.kt");
                }

                @Test
                @TestMetadata(value="javaExhaustiveWhenOnKotlinSealedClass.kt")
                public void testJavaExhaustiveWhenOnKotlinSealedClass() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/javaExhaustiveWhenOnKotlinSealedClass.kt");
                }

                @Test
                @TestMetadata(value="javaRecordsViaKotlinReflection.kt")
                public void testJavaRecordsViaKotlinReflection() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/javaRecordsViaKotlinReflection.kt");
                }

                @Test
                @TestMetadata(value="javaSealedClass.kt")
                public void testJavaSealedClass() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/javaSealedClass.kt");
                }

                @Test
                @TestMetadata(value="javaSealedInterface.kt")
                public void testJavaSealedInterface() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/javaSealedInterface.kt");
                }

                @Test
                @TestMetadata(value="kotlinExhaustiveWhenOnJavaSealedClass.kt")
                public void testKotlinExhaustiveWhenOnJavaSealedClass() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/kotlinExhaustiveWhenOnJavaSealedClass.kt");
                }

                @Test
                @TestMetadata(value="permittedSubclassesOfSealedKotlinClass.kt")
                public void testPermittedSubclassesOfSealedKotlinClass() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/permittedSubclassesOfSealedKotlinClass.kt");
                }

                @Test
                @TestMetadata(value="sealedJavaClassViaJavaReflection.kt")
                public void testSealedJavaClassViaJavaReflection() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/sealedJavaClassViaJavaReflection.kt");
                }

                @Test
                @TestMetadata(value="sealedJavaClassViaKotlinReflection.kt")
                public void testSealedJavaClassViaKotlinReflection() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/sealedJavaClassViaKotlinReflection.kt");
                }

                @Test
                @TestMetadata(value="sealedJavaInterfaceViaKotlinReflection.kt")
                public void testSealedJavaInterfaceViaKotlinReflection() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/sealed/sealedJavaInterfaceViaKotlinReflection.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ReleaseFlag {
                @Test
                public void testAllFilesPresentInReleaseFlag() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava")
                @TestDataPath(value="$PROJECT_ROOT")
                public class WithJava {
                    @Test
                    public void testAllFilesPresentInWithJava() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="withJava_10.kt")
                    public void testWithJava_10() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_10.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_11.kt")
                    public void testWithJava_11() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_11.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_12.kt")
                    public void testWithJava_12() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_12.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_13.kt")
                    public void testWithJava_13() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_13.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_14.kt")
                    public void testWithJava_14() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_14.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_15.kt")
                    public void testWithJava_15() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_15.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_16.kt")
                    public void testWithJava_16() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_16.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_17.kt")
                    public void testWithJava_17() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_17.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_8.kt")
                    public void testWithJava_8() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_8.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_9.kt")
                    public void testWithJava_9() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/withJava/withJava_9.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass")
                @TestDataPath(value="$PROJECT_ROOT")
                public class InnerClass {
                    @Test
                    public void testAllFilesPresentInInnerClass() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="threadState_10.kt")
                    public void testThreadState_10() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_10.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_11.kt")
                    public void testThreadState_11() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_11.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_12.kt")
                    public void testThreadState_12() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_12.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_13.kt")
                    public void testThreadState_13() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_13.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_14.kt")
                    public void testThreadState_14() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_14.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_15.kt")
                    public void testThreadState_15() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_15.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_16.kt")
                    public void testThreadState_16() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_16.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_17.kt")
                    public void testThreadState_17() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_17.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_8.kt")
                    public void testThreadState_8() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_8.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_9.kt")
                    public void testThreadState_9() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/innerClass/threadState_9.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable")
                @TestDataPath(value="$PROJECT_ROOT")
                public class Constable {
                    @Test
                    public void testAllFilesPresentInConstable() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="constable.kt")
                    public void testConstable() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_10.kt")
                    public void testConstable_10() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_10.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_11.kt")
                    public void testConstable_11() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_11.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_12.kt")
                    public void testConstable_12() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_12.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_13.kt")
                    public void testConstable_13() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_13.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_14.kt")
                    public void testConstable_14() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_14.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_15.kt")
                    public void testConstable_15() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_15.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_16.kt")
                    public void testConstable_16() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_16.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_17.kt")
                    public void testConstable_17() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_17.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_8.kt")
                    public void testConstable_8() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_8.kt");
                    }

                    @Test
                    @TestMetadata(value="constable_9.kt")
                    public void testConstable_9() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/constable/constable_9.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer")
                @TestDataPath(value="$PROJECT_ROOT")
                public class ByteBuffer {
                    @Test
                    public void testAllFilesPresentInByteBuffer() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="byteBuffer.kt")
                    public void testByteBuffer() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_10.kt")
                    public void testByteBuffer_10() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_10.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_11.kt")
                    public void testByteBuffer_11() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_11.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_12.kt")
                    public void testByteBuffer_12() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_12.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_13.kt")
                    public void testByteBuffer_13() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_13.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_14.kt")
                    public void testByteBuffer_14() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_14.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_15.kt")
                    public void testByteBuffer_15() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_15.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_16.kt")
                    public void testByteBuffer_16() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_16.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_17.kt")
                    public void testByteBuffer_17() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_17.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_8.kt")
                    public void testByteBuffer_8() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_8.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_9.kt")
                    public void testByteBuffer_9() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/releaseFlag/byteBuffer/byteBuffer_9.kt");
                    }
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava17/records")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Records {
                @Test
                public void testAllFilesPresentInRecords() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava17/records"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="binaryRecord.kt")
                public void testBinaryRecord() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/binaryRecord.kt");
                }

                @Test
                @TestMetadata(value="bytecodeShapeForJava.kt")
                public void testBytecodeShapeForJava() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/bytecodeShapeForJava.kt");
                }

                @Test
                @TestMetadata(value="callableReferenceToGenericRecord.kt")
                public void testCallableReferenceToGenericRecord() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/callableReferenceToGenericRecord.kt");
                }

                @Test
                @TestMetadata(value="collectionSizeOverrides.kt")
                public void testCollectionSizeOverrides() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/collectionSizeOverrides.kt");
                }

                @Test
                @TestMetadata(value="dataJvmRecord.kt")
                public void testDataJvmRecord() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/dataJvmRecord.kt");
                }

                @Test
                @TestMetadata(value="jvmRecordBinary.kt")
                public void testJvmRecordBinary() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/jvmRecordBinary.kt");
                }

                @Test
                @TestMetadata(value="kt54573.kt")
                public void testKt54573() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/kt54573.kt");
                }

                @Test
                @TestMetadata(value="propertiesOverrides.kt")
                public void testPropertiesOverrides() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/propertiesOverrides.kt");
                }

                @Test
                @TestMetadata(value="propertiesOverridesAllCompatibilityJvmDefault.kt")
                public void testPropertiesOverridesAllCompatibilityJvmDefault() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/propertiesOverridesAllCompatibilityJvmDefault.kt");
                }

                @Test
                @TestMetadata(value="propertiesOverridesAllJvmDefault.kt")
                public void testPropertiesOverridesAllJvmDefault() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/propertiesOverridesAllJvmDefault.kt");
                }

                @Test
                @TestMetadata(value="recordDifferentPropertyOverride.kt")
                public void testRecordDifferentPropertyOverride() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/recordDifferentPropertyOverride.kt");
                }

                @Test
                @TestMetadata(value="recordDifferentSyntheticProperty.kt")
                public void testRecordDifferentSyntheticProperty() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/recordDifferentSyntheticProperty.kt");
                }

                @Test
                @TestMetadata(value="recordPropertyAccess.kt")
                public void testRecordPropertyAccess() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/recordPropertyAccess.kt");
                }

                @Test
                @TestMetadata(value="recordWithCompanion.kt")
                public void testRecordWithCompanion() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava17/records/recordWithCompanion.kt");
                }
            }
        }

        @Nested
        @Tag(value="<modernJava>")
        @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava11")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TestsWithJava11 {
            @Test
            public void testAllFilesPresentInTestsWithJava11() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="concatDynamic.kt")
            public void testConcatDynamic() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic199Long.kt")
            public void testConcatDynamic199Long() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic199Long.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic200.kt")
            public void testConcatDynamic200() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic200.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic200Long.kt")
            public void testConcatDynamic200Long() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic200Long.kt");
            }

            @Test
            @TestMetadata(value="concatDynamic201.kt")
            public void testConcatDynamic201() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamic201.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicIndy199Long.kt")
            public void testConcatDynamicIndy199Long() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicIndy199Long.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicIndy200.kt")
            public void testConcatDynamicIndy200() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicIndy200.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicIndy200Long.kt")
            public void testConcatDynamicIndy200Long() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicIndy200Long.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicIndy201.kt")
            public void testConcatDynamicIndy201() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicIndy201.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicInlineClasses.kt")
            public void testConcatDynamicInlineClasses() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicInlineClasses.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicSpecialSymbols.kt")
            public void testConcatDynamicSpecialSymbols() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicSpecialSymbols.kt");
            }

            @Test
            @TestMetadata(value="concatDynamicWithInline.kt")
            public void testConcatDynamicWithInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/concatDynamicWithInline.kt");
            }

            @Test
            @TestMetadata(value="kt36984.kt")
            public void testKt36984() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt36984.kt");
            }

            @Test
            @TestMetadata(value="kt47917.kt")
            public void testKt47917() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt47917.kt");
            }

            @Test
            @TestMetadata(value="kt47917_oldBackend.kt")
            public void testKt47917_oldBackend() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt47917_oldBackend.kt");
            }

            @Test
            @TestMetadata(value="kt47917_russian.kt")
            public void testKt47917_russian() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt47917_russian.kt");
            }

            @Test
            @TestMetadata(value="kt47917_surrogatePairs.kt")
            public void testKt47917_surrogatePairs() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/kt47917_surrogatePairs.kt");
            }

            @Test
            @TestMetadata(value="varHandle.kt")
            public void testVarHandle() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/varHandle.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ReleaseFlag {
                @Test
                public void testAllFilesPresentInReleaseFlag() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava")
                @TestDataPath(value="$PROJECT_ROOT")
                public class WithJava {
                    @Test
                    public void testAllFilesPresentInWithJava() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="withJava_10.kt")
                    public void testWithJava_10() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_10.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_11.kt")
                    public void testWithJava_11() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_11.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_6.kt")
                    public void testWithJava_6() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_6.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_8.kt")
                    public void testWithJava_8() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_8.kt");
                    }

                    @Test
                    @TestMetadata(value="withJava_9.kt")
                    public void testWithJava_9() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/withJava/withJava_9.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective")
                @TestDataPath(value="$PROJECT_ROOT")
                public class Reflective {
                    @Test
                    public void testAllFilesPresentInReflective() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="reflective.kt")
                    public void testReflective() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective.kt");
                    }

                    @Test
                    @TestMetadata(value="reflective_10.kt")
                    public void testReflective_10() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_10.kt");
                    }

                    @Test
                    @TestMetadata(value="reflective_11.kt")
                    public void testReflective_11() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_11.kt");
                    }

                    @Test
                    @TestMetadata(value="reflective_6.kt")
                    public void testReflective_6() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_6.kt");
                    }

                    @Test
                    @TestMetadata(value="reflective_8.kt")
                    public void testReflective_8() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_8.kt");
                    }

                    @Test
                    @TestMetadata(value="reflective_9.kt")
                    public void testReflective_9() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/reflective/reflective_9.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass")
                @TestDataPath(value="$PROJECT_ROOT")
                public class InnerClass {
                    @Test
                    public void testAllFilesPresentInInnerClass() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="threadState_10.kt")
                    public void testThreadState_10() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass/threadState_10.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_11.kt")
                    public void testThreadState_11() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass/threadState_11.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_8.kt")
                    public void testThreadState_8() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass/threadState_8.kt");
                    }

                    @Test
                    @TestMetadata(value="threadState_9.kt")
                    public void testThreadState_9() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/innerClass/threadState_9.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer")
                @TestDataPath(value="$PROJECT_ROOT")
                public class ByteBuffer {
                    @Test
                    public void testAllFilesPresentInByteBuffer() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="byteBuffer.kt")
                    public void testByteBuffer() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_10.kt")
                    public void testByteBuffer_10() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_10.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_11.kt")
                    public void testByteBuffer_11() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_11.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_6.kt")
                    public void testByteBuffer_6() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_6.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_8.kt")
                    public void testByteBuffer_8() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_8.kt");
                    }

                    @Test
                    @TestMetadata(value="byteBuffer_9.kt")
                    public void testByteBuffer_9() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxModernJdk/testsWithJava11/releaseFlag/byteBuffer/byteBuffer_9.kt");
                    }
                }
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/boxInline")
    @TestDataPath(value="$PROJECT_ROOT")
    public class BoxInline {
        @Test
        public void testAllFilesPresentInBoxInline() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/varargs")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Varargs {
            @Test
            public void testAllFilesPresentInVarargs() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/varargs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt17653.kt")
            public void testKt17653() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/varargs/kt17653.kt");
            }

            @Test
            @TestMetadata(value="varargAndDefaultParameters.kt")
            public void testVarargAndDefaultParameters() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/varargs/varargAndDefaultParameters.kt");
            }

            @Test
            @TestMetadata(value="varargAndDefaultParameters2.kt")
            public void testVarargAndDefaultParameters2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/varargs/varargAndDefaultParameters2.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/typeParameters")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TypeParameters {
            @Test
            public void testAllFilesPresentInTypeParameters() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/typeParameters"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="anonymousObject.kt")
            public void testAnonymousObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/anonymousObject.kt");
            }

            @Test
            @TestMetadata(value="basic.kt")
            public void testBasic() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/basic.kt");
            }

            @Test
            @TestMetadata(value="projectionTypeArguments.kt")
            public void testProjectionTypeArguments() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/projectionTypeArguments.kt");
            }

            @Test
            @TestMetadata(value="severalUpperBounds.kt")
            public void testSeveralUpperBounds() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/severalUpperBounds.kt");
            }

            @Test
            @TestMetadata(value="typeArgFromGenericBaseClass.kt")
            public void testTypeArgFromGenericBaseClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/typeArgFromGenericBaseClass.kt");
            }

            @Test
            @TestMetadata(value="uncheckedCastToNothing.kt")
            public void testUncheckedCastToNothing() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/uncheckedCastToNothing.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/tryCatchFinally")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TryCatchFinally {
            @Test
            public void testAllFilesPresentInTryCatchFinally() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/tryCatchFinally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt5863.kt")
            public void testKt5863() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/tryCatchFinally/kt5863.kt");
            }

            @Test
            @TestMetadata(value="tryCatch.kt")
            public void testTryCatch() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatch.kt");
            }

            @Test
            @TestMetadata(value="tryCatch2.kt")
            public void testTryCatch2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatch2.kt");
            }

            @Test
            @TestMetadata(value="tryCatchFinally.kt")
            public void testTryCatchFinally() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatchFinally.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/trait")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Trait {
            @Test
            public void testAllFilesPresentInTrait() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/trait"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="trait.kt")
            public void testTrait() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/trait/trait.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/syntheticAccessors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class SyntheticAccessors {
            @Test
            public void testAllFilesPresentInSyntheticAccessors() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/syntheticAccessors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="constField.kt")
            public void testConstField() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/constField.kt");
            }

            @Test
            @TestMetadata(value="packagePrivateMembers.kt")
            public void testPackagePrivateMembers() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/packagePrivateMembers.kt");
            }

            @Test
            @TestMetadata(value="propertyModifiers.kt")
            public void testPropertyModifiers() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/propertyModifiers.kt");
            }

            @Test
            @TestMetadata(value="protectedMembers.kt")
            public void testProtectedMembers() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/protectedMembers.kt");
            }

            @Test
            @TestMetadata(value="protectedMembersFromSuper.kt")
            public void testProtectedMembersFromSuper() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/protectedMembersFromSuper.kt");
            }

            @Test
            @TestMetadata(value="superCall.kt")
            public void testSuperCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superCall.kt");
            }

            @Test
            @TestMetadata(value="superCallFromMultipleSubclasses.kt")
            public void testSuperCallFromMultipleSubclasses() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superCallFromMultipleSubclasses.kt");
            }

            @Test
            @TestMetadata(value="superProperty.kt")
            public void testSuperProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superProperty.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda")
            @TestDataPath(value="$PROJECT_ROOT")
            public class WithinInlineLambda {
                @Test
                public void testAllFilesPresentInWithinInlineLambda() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="directFieldAccess.kt")
                public void testDirectFieldAccess() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/directFieldAccess.kt");
                }

                @Test
                @TestMetadata(value="directFieldAccessInCrossInline.kt")
                public void testDirectFieldAccessInCrossInline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/directFieldAccessInCrossInline.kt");
                }

                @Test
                @TestMetadata(value="privateCall.kt")
                public void testPrivateCall() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateCall.kt");
                }

                @Test
                @TestMetadata(value="privateInCrossInline.kt")
                public void testPrivateInCrossInline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateInCrossInline.kt");
                }

                @Test
                @TestMetadata(value="privateInDefaultStubArgument.kt")
                public void testPrivateInDefaultStubArgument() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateInDefaultStubArgument.kt");
                }

                @Test
                @TestMetadata(value="protectedInCrossinline.kt")
                public void testProtectedInCrossinline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/protectedInCrossinline.kt");
                }

                @Test
                @TestMetadata(value="protectedMembersFromSuper.kt")
                public void testProtectedMembersFromSuper() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/protectedMembersFromSuper.kt");
                }

                @Test
                @TestMetadata(value="superCall.kt")
                public void testSuperCall() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/superCall.kt");
                }

                @Test
                @TestMetadata(value="superInCrossInline.kt")
                public void testSuperInCrossInline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/superInCrossInline.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/suspend")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Suspend {
            @Test
            public void testAllFilesPresentInSuspend() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="capturedVariables.kt")
            public void testCapturedVariables() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/capturedVariables.kt");
            }

            @Test
            @TestMetadata(value="crossinlineSuspendLambdaInsideCrossinlineSuspendLambda.kt")
            public void testCrossinlineSuspendLambdaInsideCrossinlineSuspendLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/crossinlineSuspendLambdaInsideCrossinlineSuspendLambda.kt");
            }

            @Test
            @TestMetadata(value="debugMetadataCrossinline.kt")
            public void testDebugMetadataCrossinline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/debugMetadataCrossinline.kt");
            }

            @Test
            @TestMetadata(value="delegatedProperties.kt")
            public void testDelegatedProperties() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/delegatedProperties.kt");
            }

            @Test
            @TestMetadata(value="doubleRegenerationWithNonSuspendingLambda.kt")
            public void testDoubleRegenerationWithNonSuspendingLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/doubleRegenerationWithNonSuspendingLambda.kt");
            }

            @Test
            @TestMetadata(value="enclodingMethod.kt")
            public void testEnclodingMethod() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/enclodingMethod.kt");
            }

            @Test
            @TestMetadata(value="fileNameInMetadata.kt")
            public void testFileNameInMetadata() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/fileNameInMetadata.kt");
            }

            @Test
            @TestMetadata(value="inlineOrdinaryOfCrossinlineSuspend.kt")
            public void testInlineOrdinaryOfCrossinlineSuspend() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineOrdinaryOfCrossinlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="inlineOrdinaryOfNoinlineSuspend.kt")
            public void testInlineOrdinaryOfNoinlineSuspend() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineOrdinaryOfNoinlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="inlinePassthrough.kt")
            public void testInlinePassthrough() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlinePassthrough.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendContinuation.kt")
            public void testInlineSuspendContinuation() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendContinuation.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendInMultifileClass.kt")
            public void testInlineSuspendInMultifileClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendInMultifileClass.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfCrossinlineOrdinary.kt")
            public void testInlineSuspendOfCrossinlineOrdinary() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfCrossinlineOrdinary.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfCrossinlineSuspend.kt")
            public void testInlineSuspendOfCrossinlineSuspend() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfCrossinlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfNoinlineOrdinary.kt")
            public void testInlineSuspendOfNoinlineOrdinary() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfNoinlineOrdinary.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfNoinlineSuspend.kt")
            public void testInlineSuspendOfNoinlineSuspend() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfNoinlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfOrdinary.kt")
            public void testInlineSuspendOfOrdinary() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfOrdinary.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfSuspend.kt")
            public void testInlineSuspendOfSuspend() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfSuspend.kt");
            }

            @Test
            @TestMetadata(value="jvmName.kt")
            public void testJvmName() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/jvmName.kt");
            }

            @Test
            @TestMetadata(value="kt26658.kt")
            public void testKt26658() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/kt26658.kt");
            }

            @Test
            @TestMetadata(value="kt52198.kt")
            public void testKt52198() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/kt52198.kt");
            }

            @Test
            @TestMetadata(value="maxStackWithCrossinline.kt")
            public void testMaxStackWithCrossinline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/maxStackWithCrossinline.kt");
            }

            @Test
            @TestMetadata(value="multipleLocals.kt")
            public void testMultipleLocals() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/multipleLocals.kt");
            }

            @Test
            @TestMetadata(value="multipleSuspensionPoints.kt")
            public void testMultipleSuspensionPoints() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/multipleSuspensionPoints.kt");
            }

            @Test
            @TestMetadata(value="nestedMethodWith2XParameter.kt")
            public void testNestedMethodWith2XParameter() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/nestedMethodWith2XParameter.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn.kt")
            public void testNonLocalReturn() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/nonLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="nonSuspendCrossinline.kt")
            public void testNonSuspendCrossinline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/nonSuspendCrossinline.kt");
            }

            @Test
            @TestMetadata(value="returnValue.kt")
            public void testReturnValue() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/returnValue.kt");
            }

            @Test
            @TestMetadata(value="tryCatchReceiver.kt")
            public void testTryCatchReceiver() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/tryCatchReceiver.kt");
            }

            @Test
            @TestMetadata(value="tryCatchStackTransform.kt")
            public void testTryCatchStackTransform() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/tryCatchStackTransform.kt");
            }

            @Test
            @TestMetadata(value="twiceRegeneratedAnonymousObject.kt")
            public void testTwiceRegeneratedAnonymousObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/twiceRegeneratedAnonymousObject.kt");
            }

            @Test
            @TestMetadata(value="twiceRegeneratedSuspendLambda.kt")
            public void testTwiceRegeneratedSuspendLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/twiceRegeneratedSuspendLambda.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/stateMachine")
            @TestDataPath(value="$PROJECT_ROOT")
            public class StateMachine {
                @Test
                public void testAllFilesPresentInStateMachine() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/stateMachine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="crossingCoroutineBoundaries.kt")
                public void testCrossingCoroutineBoundaries() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/crossingCoroutineBoundaries.kt");
                }

                @Test
                @TestMetadata(value="independentInline.kt")
                public void testIndependentInline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/independentInline.kt");
                }

                @Test
                @TestMetadata(value="innerLambda.kt")
                public void testInnerLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambda.kt");
                }

                @Test
                @TestMetadata(value="innerLambdaInsideLambda.kt")
                public void testInnerLambdaInsideLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambdaInsideLambda.kt");
                }

                @Test
                @TestMetadata(value="innerLambdaWithoutCrossinline.kt")
                public void testInnerLambdaWithoutCrossinline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambdaWithoutCrossinline.kt");
                }

                @Test
                @TestMetadata(value="innerMadness.kt")
                public void testInnerMadness() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerMadness.kt");
                }

                @Test
                @TestMetadata(value="innerMadnessCallSite.kt")
                public void testInnerMadnessCallSite() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerMadnessCallSite.kt");
                }

                @Test
                @TestMetadata(value="innerObject.kt")
                public void testInnerObject() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObject.kt");
                }

                @Test
                @TestMetadata(value="innerObjectInsideInnerObject.kt")
                public void testInnerObjectInsideInnerObject() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectInsideInnerObject.kt");
                }

                @Test
                @TestMetadata(value="innerObjectRetransformation.kt")
                public void testInnerObjectRetransformation() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectRetransformation.kt");
                }

                @Test
                @TestMetadata(value="innerObjectSeveralFunctions.kt")
                public void testInnerObjectSeveralFunctions() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectSeveralFunctions.kt");
                }

                @Test
                @TestMetadata(value="innerObjectWithoutCapturingCrossinline.kt")
                public void testInnerObjectWithoutCapturingCrossinline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectWithoutCapturingCrossinline.kt");
                }

                @Test
                @TestMetadata(value="insideObject.kt")
                public void testInsideObject() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/insideObject.kt");
                }

                @Test
                @TestMetadata(value="kt30708.kt")
                public void testKt30708() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/kt30708.kt");
                }

                @Test
                @TestMetadata(value="lambdaTransformation.kt")
                public void testLambdaTransformation() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/lambdaTransformation.kt");
                }

                @Test
                @TestMetadata(value="normalInline.kt")
                public void testNormalInline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/normalInline.kt");
                }

                @Test
                @TestMetadata(value="numberOfSuspentions.kt")
                public void testNumberOfSuspentions() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/numberOfSuspentions.kt");
                }

                @Test
                @TestMetadata(value="objectInsideLambdas.kt")
                public void testObjectInsideLambdas() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/objectInsideLambdas.kt");
                }

                @Test
                @TestMetadata(value="oneInlineTwoCaptures.kt")
                public void testOneInlineTwoCaptures() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/oneInlineTwoCaptures.kt");
                }

                @Test
                @TestMetadata(value="passLambda.kt")
                public void testPassLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passLambda.kt");
                }

                @Test
                @TestMetadata(value="passParameter.kt")
                public void testPassParameter() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passParameter.kt");
                }

                @Test
                @TestMetadata(value="passParameterLambda.kt")
                public void testPassParameterLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passParameterLambda.kt");
                }

                @Test
                @TestMetadata(value="unreachableSuspendMarker.kt")
                public void testUnreachableSuspendMarker() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/unreachableSuspendMarker.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/receiver")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Receiver {
                @Test
                public void testAllFilesPresentInReceiver() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/receiver"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineOrdinaryOfCrossinlineSuspend.kt")
                public void testInlineOrdinaryOfCrossinlineSuspend() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineOrdinaryOfCrossinlineSuspend.kt");
                }

                @Test
                @TestMetadata(value="inlineOrdinaryOfNoinlineSuspend.kt")
                public void testInlineOrdinaryOfNoinlineSuspend() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineOrdinaryOfNoinlineSuspend.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfCrossinlineOrdinary.kt")
                public void testInlineSuspendOfCrossinlineOrdinary() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfCrossinlineOrdinary.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfCrossinlineSuspend.kt")
                public void testInlineSuspendOfCrossinlineSuspend() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfCrossinlineSuspend.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfNoinlineOrdinary.kt")
                public void testInlineSuspendOfNoinlineOrdinary() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfNoinlineOrdinary.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfNoinlineSuspend.kt")
                public void testInlineSuspendOfNoinlineSuspend() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfNoinlineSuspend.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfOrdinary.kt")
                public void testInlineSuspendOfOrdinary() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfOrdinary.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfSuspend.kt")
                public void testInlineSuspendOfSuspend() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfSuspend.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineUsedAsNoinline {
                @Test
                public void testAllFilesPresentInInlineUsedAsNoinline() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineOnly.kt")
                public void testInlineOnly() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/inlineOnly.kt");
                }

                @Test
                @TestMetadata(value="simpleNamed.kt")
                public void testSimpleNamed() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/simpleNamed.kt");
                }

                @Test
                @TestMetadata(value="withCapturedInlineLambda.kt")
                public void testWithCapturedInlineLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/withCapturedInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="withCapturedInlineLambda2.kt")
                public void testWithCapturedInlineLambda2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/withCapturedInlineLambda2.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/inlineClass")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineClass {
                @Test
                public void testAllFilesPresentInInlineClass() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/inlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="returnBoxedFromLambda.kt")
                public void testReturnBoxedFromLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnBoxedFromLambda.kt");
                }

                @Test
                @TestMetadata(value="returnUnboxedDirect.kt")
                public void testReturnUnboxedDirect() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedDirect.kt");
                }

                @Test
                @TestMetadata(value="returnUnboxedFromLambda.kt")
                public void testReturnUnboxedFromLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedFromLambda.kt");
                }

                @Test
                @TestMetadata(value="returnUnboxedResume.kt")
                public void testReturnUnboxedResume() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedResume.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/defaultParameter")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DefaultParameter {
                @Test
                public void testAllFilesPresentInDefaultParameter() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/defaultParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="defaultInlineLambda.kt")
                public void testDefaultInlineLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="defaultInlineReference.kt")
                public void testDefaultInlineReference() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultInlineReference.kt");
                }

                @Test
                @TestMetadata(value="defaultValueCrossinline.kt")
                public void testDefaultValueCrossinline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueCrossinline.kt");
                }

                @Test
                @TestMetadata(value="defaultValueInClass.kt")
                public void testDefaultValueInClass() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInClass.kt");
                }

                @Test
                @TestMetadata(value="defaultValueInline.kt")
                public void testDefaultValueInline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInline.kt");
                }

                @Test
                @TestMetadata(value="defaultValueInlineFromMultiFileFacade.kt")
                public void testDefaultValueInlineFromMultiFileFacade() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInlineFromMultiFileFacade.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/callableReference")
            @TestDataPath(value="$PROJECT_ROOT")
            public class CallableReference {
                @Test
                public void testAllFilesPresentInCallableReference() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="isAsReified.kt")
                public void testIsAsReified() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/isAsReified.kt");
                }

                @Test
                @TestMetadata(value="isAsReified2.kt")
                public void testIsAsReified2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/isAsReified2.kt");
                }

                @Test
                @TestMetadata(value="nonTailCall.kt")
                public void testNonTailCall() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/nonTailCall.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/simple.kt");
                }

                @Test
                @TestMetadata(value="unitReturn.kt")
                public void testUnitReturn() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/unitReturn.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/stackOnReturn")
        @TestDataPath(value="$PROJECT_ROOT")
        public class StackOnReturn {
            @Test
            public void testAllFilesPresentInStackOnReturn() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/stackOnReturn"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="elvis.kt")
            public void testElvis() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/elvis.kt");
            }

            @Test
            @TestMetadata(value="ifThenElse.kt")
            public void testIfThenElse() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/ifThenElse.kt");
            }

            @Test
            @TestMetadata(value="kt11499.kt")
            public void testKt11499() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt11499.kt");
            }

            @Test
            @TestMetadata(value="kt17591.kt")
            public void testKt17591() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591.kt");
            }

            @Test
            @TestMetadata(value="kt17591a.kt")
            public void testKt17591a() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591a.kt");
            }

            @Test
            @TestMetadata(value="kt17591b.kt")
            public void testKt17591b() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591b.kt");
            }

            @Test
            @TestMetadata(value="mixedTypesOnStack1.kt")
            public void testMixedTypesOnStack1() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack1.kt");
            }

            @Test
            @TestMetadata(value="mixedTypesOnStack2.kt")
            public void testMixedTypesOnStack2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack2.kt");
            }

            @Test
            @TestMetadata(value="mixedTypesOnStack3.kt")
            public void testMixedTypesOnStack3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack3.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn1.kt")
            public void testNonLocalReturn1() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn1.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn2.kt")
            public void testNonLocalReturn2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn2.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn3.kt")
            public void testNonLocalReturn3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn3.kt");
            }

            @Test
            @TestMetadata(value="poppedLocalReturn.kt")
            public void testPoppedLocalReturn() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/poppedLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="poppedLocalReturn2.kt")
            public void testPoppedLocalReturn2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/poppedLocalReturn2.kt");
            }

            @Test
            @TestMetadata(value="returnLong.kt")
            public void testReturnLong() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/returnLong.kt");
            }

            @Test
            @TestMetadata(value="tryFinally.kt")
            public void testTryFinally() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/tryFinally.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/special")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Special {
            @Test
            public void testAllFilesPresentInSpecial() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/special"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="identityCheck.kt")
            public void testIdentityCheck() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/identityCheck.kt");
            }

            @Test
            @TestMetadata(value="ifBranches.kt")
            public void testIfBranches() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/ifBranches.kt");
            }

            @Test
            @TestMetadata(value="iinc.kt")
            public void testIinc() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/iinc.kt");
            }

            @Test
            @TestMetadata(value="inlineChain.kt")
            public void testInlineChain() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/inlineChain.kt");
            }

            @Test
            @TestMetadata(value="loopInStoreLoadChains.kt")
            public void testLoopInStoreLoadChains() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/loopInStoreLoadChains.kt");
            }

            @Test
            @TestMetadata(value="loopInStoreLoadChains2.kt")
            public void testLoopInStoreLoadChains2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/loopInStoreLoadChains2.kt");
            }

            @Test
            @TestMetadata(value="monitorEnterExit.kt")
            public void testMonitorEnterExit() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/monitorEnterExit.kt");
            }

            @Test
            @TestMetadata(value="plusAssign.kt")
            public void testPlusAssign() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/plusAssign.kt");
            }

            @Test
            @TestMetadata(value="stackHeightBug.kt")
            public void testStackHeightBug() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/stackHeightBug.kt");
            }

            @Test
            @TestMetadata(value="unusedInlineLambda.kt")
            public void testUnusedInlineLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/unusedInlineLambda.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/smap")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Smap {
            @Test
            public void testAllFilesPresentInSmap() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="assertion.kt")
            public void testAssertion() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/assertion.kt");
            }

            @Test
            @TestMetadata(value="classCycle.kt")
            public void testClassCycle() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/classCycle.kt");
            }

            @Test
            @TestMetadata(value="classFromDefaultPackage.kt")
            public void testClassFromDefaultPackage() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/classFromDefaultPackage.kt");
            }

            @Test
            @TestMetadata(value="coroutinesWithTailCallOtpimization.kt")
            public void testCoroutinesWithTailCallOtpimization() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/coroutinesWithTailCallOtpimization.kt");
            }

            @Test
            @TestMetadata(value="crossroutines.kt")
            public void testCrossroutines() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/crossroutines.kt");
            }

            @Test
            @TestMetadata(value="defaultFunction.kt")
            public void testDefaultFunction() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultFunction.kt");
            }

            @Test
            @TestMetadata(value="defaultFunctionWithInlineCall.kt")
            public void testDefaultFunctionWithInlineCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultFunctionWithInlineCall.kt");
            }

            @Test
            @TestMetadata(value="forInline.kt")
            public void testForInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/forInline.kt");
            }

            @Test
            @TestMetadata(value="inlineProperty.kt")
            public void testInlineProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineProperty.kt");
            }

            @Test
            @TestMetadata(value="interleavedFiles.kt")
            public void testInterleavedFiles() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/interleavedFiles.kt");
            }

            @Test
            @TestMetadata(value="kt23369.kt")
            public void testKt23369() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/kt23369.kt");
            }

            @Test
            @TestMetadata(value="kt23369_2.kt")
            public void testKt23369_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/kt23369_2.kt");
            }

            @Test
            @TestMetadata(value="kt23369_3.kt")
            public void testKt23369_3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/kt23369_3.kt");
            }

            @Test
            @TestMetadata(value="kt35006.kt")
            public void testKt35006() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/kt35006.kt");
            }

            @Test
            @TestMetadata(value="multiFileFacade.kt")
            public void testMultiFileFacade() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/multiFileFacade.kt");
            }

            @Test
            @TestMetadata(value="oneFile.kt")
            public void testOneFile() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/oneFile.kt");
            }

            @Test
            @TestMetadata(value="rangeFolding.kt")
            public void testRangeFolding() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/rangeFolding.kt");
            }

            @Test
            @TestMetadata(value="rangeFoldingInClass.kt")
            public void testRangeFoldingInClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/rangeFoldingInClass.kt");
            }

            @Test
            @TestMetadata(value="smap.kt")
            public void testSmap() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/smap.kt");
            }

            @Test
            @TestMetadata(value="smapWithNewSyntax.kt")
            public void testSmapWithNewSyntax() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/smapWithNewSyntax.kt");
            }

            @Test
            @TestMetadata(value="smapWithOldSyntax.kt")
            public void testSmapWithOldSyntax() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/smapWithOldSyntax.kt");
            }

            @Test
            @TestMetadata(value="tryFinally1.kt")
            public void testTryFinally1() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/tryFinally1.kt");
            }

            @Test
            @TestMetadata(value="tryFinally2.kt")
            public void testTryFinally2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/tryFinally2.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/resolve")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Resolve {
                @Test
                public void testAllFilesPresentInResolve() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/resolve"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineComponent.kt")
                public void testInlineComponent() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/resolve/inlineComponent.kt");
                }

                @Test
                @TestMetadata(value="inlineIterator.kt")
                public void testInlineIterator() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/resolve/inlineIterator.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/newsmap")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Newsmap {
                @Test
                public void testAllFilesPresentInNewsmap() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/newsmap"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="differentMapping.kt")
                public void testDifferentMapping() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/newsmap/differentMapping.kt");
                }

                @Test
                @TestMetadata(value="mappingInInlineFunLambda.kt")
                public void testMappingInInlineFunLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInInlineFunLambda.kt");
                }

                @Test
                @TestMetadata(value="mappingInSubInlineLambda.kt")
                public void testMappingInSubInlineLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInSubInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="mappingInSubInlineLambdaSameFileInline.kt")
                public void testMappingInSubInlineLambdaSameFileInline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInSubInlineLambdaSameFileInline.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/inlineOnly")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineOnly {
                @Test
                public void testAllFilesPresentInInlineOnly() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/inlineOnly"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="noSmap.kt")
                public void testNoSmap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/noSmap.kt");
                }

                @Test
                @TestMetadata(value="noSmapWithProperty.kt")
                public void testNoSmapWithProperty() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/noSmapWithProperty.kt");
                }

                @Test
                @TestMetadata(value="reified.kt")
                public void testReified() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/reified.kt");
                }

                @Test
                @TestMetadata(value="reifiedProperty.kt")
                public void testReifiedProperty() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/reifiedProperty.kt");
                }

                @Test
                @TestMetadata(value="stdlibInlineOnly.kt")
                public void testStdlibInlineOnly() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/stdlibInlineOnly.kt");
                }

                @Test
                @TestMetadata(value="stdlibInlineOnlyOneLine.kt")
                public void testStdlibInlineOnlyOneLine() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/stdlibInlineOnlyOneLine.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/defaultLambda")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DefaultLambda {
                @Test
                public void testAllFilesPresentInDefaultLambda() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/defaultLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="defaultLambdaInAnonymous.kt")
                public void testDefaultLambdaInAnonymous() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/defaultLambdaInAnonymous.kt");
                }

                @Test
                @TestMetadata(value="inlineAnonymousInDefault.kt")
                public void testInlineAnonymousInDefault() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineAnonymousInDefault.kt");
                }

                @Test
                @TestMetadata(value="inlineAnonymousInDefault2.kt")
                public void testInlineAnonymousInDefault2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineAnonymousInDefault2.kt");
                }

                @Test
                @TestMetadata(value="inlineInDefault.kt")
                public void testInlineInDefault() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineInDefault.kt");
                }

                @Test
                @TestMetadata(value="inlineInDefault2.kt")
                public void testInlineInDefault2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineInDefault2.kt");
                }

                @Test
                @TestMetadata(value="kt21827.kt")
                public void testKt21827() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/kt21827.kt");
                }

                @Test
                @TestMetadata(value="nested.kt")
                public void testNested() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/nested.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/simple.kt");
                }

                @Test
                @TestMetadata(value="simple2.kt")
                public void testSimple2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/simple2.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/anonymous")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Anonymous {
                @Test
                public void testAllFilesPresentInAnonymous() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/anonymous"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="kt19175.kt")
                public void testKt19175() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/kt19175.kt");
                }

                @Test
                @TestMetadata(value="lambda.kt")
                public void testLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambda.kt");
                }

                @Test
                @TestMetadata(value="lambdaOnCallSite.kt")
                public void testLambdaOnCallSite() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambdaOnCallSite.kt");
                }

                @Test
                @TestMetadata(value="lambdaOnInlineCallSite.kt")
                public void testLambdaOnInlineCallSite() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambdaOnInlineCallSite.kt");
                }

                @Test
                @TestMetadata(value="object.kt")
                public void testObject() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/object.kt");
                }

                @Test
                @TestMetadata(value="objectOnCallSite.kt")
                public void testObjectOnCallSite() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnCallSite.kt");
                }

                @Test
                @TestMetadata(value="objectOnInlineCallSite.kt")
                public void testObjectOnInlineCallSite() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSite.kt");
                }

                @Test
                @TestMetadata(value="objectOnInlineCallSite2.kt")
                public void testObjectOnInlineCallSite2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSite2.kt");
                }

                @Test
                @TestMetadata(value="objectOnInlineCallSiteWithCapture.kt")
                public void testObjectOnInlineCallSiteWithCapture() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSiteWithCapture.kt");
                }

                @Test
                @TestMetadata(value="severalMappingsForDefaultFile.kt")
                public void testSeveralMappingsForDefaultFile() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/severalMappingsForDefaultFile.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/simple")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Simple {
            @Test
            public void testAllFilesPresentInSimple() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/simple"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="captureAndArgumentIncompatibleTypes.kt")
            public void testCaptureAndArgumentIncompatibleTypes() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/captureAndArgumentIncompatibleTypes.kt");
            }

            @Test
            @TestMetadata(value="classObject.kt")
            public void testClassObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/classObject.kt");
            }

            @Test
            @TestMetadata(value="destructuring.kt")
            public void testDestructuring() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/destructuring.kt");
            }

            @Test
            @TestMetadata(value="destructuringIndexClash.kt")
            public void testDestructuringIndexClash() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/destructuringIndexClash.kt");
            }

            @Test
            @TestMetadata(value="extension.kt")
            public void testExtension() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/extension.kt");
            }

            @Test
            @TestMetadata(value="extensionLambda.kt")
            public void testExtensionLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/extensionLambda.kt");
            }

            @Test
            @TestMetadata(value="funImportedFromObject.kt")
            public void testFunImportedFromObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/funImportedFromObject.kt");
            }

            @Test
            @TestMetadata(value="importedJavaStaticField.kt")
            public void testImportedJavaStaticField() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/importedJavaStaticField.kt");
            }

            @Test
            @TestMetadata(value="inlineCallInInlineLambda.kt")
            public void testInlineCallInInlineLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/inlineCallInInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="kt17431.kt")
            public void testKt17431() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/kt17431.kt");
            }

            @Test
            @TestMetadata(value="kt28547.kt")
            public void testKt28547() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/kt28547.kt");
            }

            @Test
            @TestMetadata(value="kt28547_2.kt")
            public void testKt28547_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/kt28547_2.kt");
            }

            @Test
            @TestMetadata(value="params.kt")
            public void testParams() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/params.kt");
            }

            @Test
            @TestMetadata(value="propImportedFromObject.kt")
            public void testPropImportedFromObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/propImportedFromObject.kt");
            }

            @Test
            @TestMetadata(value="rootConstructor.kt")
            public void testRootConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/rootConstructor.kt");
            }

            @Test
            @TestMetadata(value="safeCall.kt")
            public void testSafeCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/safeCall.kt");
            }

            @Test
            @TestMetadata(value="severalClosures.kt")
            public void testSeveralClosures() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/severalClosures.kt");
            }

            @Test
            @TestMetadata(value="severalUsage.kt")
            public void testSeveralUsage() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/severalUsage.kt");
            }

            @Test
            @TestMetadata(value="simpleDouble.kt")
            public void testSimpleDouble() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleDouble.kt");
            }

            @Test
            @TestMetadata(value="simpleEnum.kt")
            public void testSimpleEnum() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleEnum.kt");
            }

            @Test
            @TestMetadata(value="simpleGenerics.kt")
            public void testSimpleGenerics() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleGenerics.kt");
            }

            @Test
            @TestMetadata(value="simpleInt.kt")
            public void testSimpleInt() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleInt.kt");
            }

            @Test
            @TestMetadata(value="simpleLambda.kt")
            public void testSimpleLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleLambda.kt");
            }

            @Test
            @TestMetadata(value="simpleObject.kt")
            public void testSimpleObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleObject.kt");
            }

            @Test
            @TestMetadata(value="vararg.kt")
            public void testVararg() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/vararg.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/signatureMangling")
        @TestDataPath(value="$PROJECT_ROOT")
        public class SignatureMangling {
            @Test
            public void testAllFilesPresentInSignatureMangling() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/signatureMangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="flexibleType.kt")
            public void testFlexibleType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signatureMangling/flexibleType.kt");
            }

            @Test
            @TestMetadata(value="indices.kt")
            public void testIndices() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signatureMangling/indices.kt");
            }

            @Test
            @TestMetadata(value="inheritFromJava.kt")
            public void testInheritFromJava() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signatureMangling/inheritFromJava.kt");
            }

            @Test
            @TestMetadata(value="rawType.kt")
            public void testRawType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signatureMangling/rawType.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/signature")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Signature {
            @Test
            public void testAllFilesPresentInSignature() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/signature"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="byteIteratorWithForLoop.kt")
            public void testByteIteratorWithForLoop() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/byteIteratorWithForLoop.kt");
            }

            @Test
            @TestMetadata(value="byteIteratorWithWhileLoop.kt")
            public void testByteIteratorWithWhileLoop() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/byteIteratorWithWhileLoop.kt");
            }

            @Test
            @TestMetadata(value="inProjectionSubstitution.kt")
            public void testInProjectionSubstitution() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/inProjectionSubstitution.kt");
            }

            @Test
            @TestMetadata(value="outProjectionSubstitution.kt")
            public void testOutProjectionSubstitution() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/outProjectionSubstitution.kt");
            }

            @Test
            @TestMetadata(value="recursion.kt")
            public void testRecursion() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/recursion.kt");
            }

            @Test
            @TestMetadata(value="sameFormalParameterName.kt")
            public void testSameFormalParameterName() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/sameFormalParameterName.kt");
            }

            @Test
            @TestMetadata(value="sameReifiedFormalParameterName.kt")
            public void testSameReifiedFormalParameterName() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/sameReifiedFormalParameterName.kt");
            }

            @Test
            @TestMetadata(value="starProjectionSubstitution.kt")
            public void testStarProjectionSubstitution() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/starProjectionSubstitution.kt");
            }

            @Test
            @TestMetadata(value="typeParameterInLambda.kt")
            public void testTypeParameterInLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/typeParameterInLambda.kt");
            }

            @Test
            @TestMetadata(value="typeParametersSubstitution.kt")
            public void testTypeParametersSubstitution() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/typeParametersSubstitution.kt");
            }

            @Test
            @TestMetadata(value="typeParametersSubstitution2.kt")
            public void testTypeParametersSubstitution2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/typeParametersSubstitution2.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/reified")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Reified {
            @Test
            public void testAllFilesPresentInReified() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayConstructor.kt")
            public void testArrayConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/arrayConstructor.kt");
            }

            @Test
            @TestMetadata(value="arrayOf.kt")
            public void testArrayOf() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/arrayOf.kt");
            }

            @Test
            @TestMetadata(value="capturedLambda.kt")
            public void testCapturedLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/capturedLambda.kt");
            }

            @Test
            @TestMetadata(value="capturedLambda2.kt")
            public void testCapturedLambda2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/capturedLambda2.kt");
            }

            @Test
            @TestMetadata(value="dontSubstituteNonReified.kt")
            public void testDontSubstituteNonReified() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/dontSubstituteNonReified.kt");
            }

            @Test
            @TestMetadata(value="kt11081.kt")
            public void testKt11081() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt11081.kt");
            }

            @Test
            @TestMetadata(value="kt11677.kt")
            public void testKt11677() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt11677.kt");
            }

            @Test
            @TestMetadata(value="kt15956.kt")
            public void testKt15956() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt15956.kt");
            }

            @Test
            @TestMetadata(value="kt15997.kt")
            public void testKt15997() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt15997.kt");
            }

            @Test
            @TestMetadata(value="kt15997_2.kt")
            public void testKt15997_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt15997_2.kt");
            }

            @Test
            @TestMetadata(value="kt18977.kt")
            public void testKt18977() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt18977.kt");
            }

            @Test
            @TestMetadata(value="kt28234.kt")
            public void testKt28234() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt28234.kt");
            }

            @Test
            @TestMetadata(value="kt35511.kt")
            public void testKt35511() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt35511.kt");
            }

            @Test
            @TestMetadata(value="kt35511_try.kt")
            public void testKt35511_try() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt35511_try.kt");
            }

            @Test
            @TestMetadata(value="kt35511_try_valueOf.kt")
            public void testKt35511_try_valueOf() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt35511_try_valueOf.kt");
            }

            @Test
            @TestMetadata(value="kt35511_try_values.kt")
            public void testKt35511_try_values() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt35511_try_values.kt");
            }

            @Test
            @TestMetadata(value="kt44770.kt")
            public void testKt44770() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt44770.kt");
            }

            @Test
            @TestMetadata(value="kt44770_2.kt")
            public void testKt44770_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt44770_2.kt");
            }

            @Test
            @TestMetadata(value="kt46584.kt")
            public void testKt46584() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt46584.kt");
            }

            @Test
            @TestMetadata(value="kt46584_2.kt")
            public void testKt46584_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt46584_2.kt");
            }

            @Test
            @TestMetadata(value="kt55398.kt")
            public void testKt55398() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt55398.kt");
            }

            @Test
            @TestMetadata(value="kt6988.kt")
            public void testKt6988() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt6988.kt");
            }

            @Test
            @TestMetadata(value="kt6988_2.kt")
            public void testKt6988_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt6988_2.kt");
            }

            @Test
            @TestMetadata(value="kt6990.kt")
            public void testKt6990() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt6990.kt");
            }

            @Test
            @TestMetadata(value="kt7017.kt")
            public void testKt7017() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt7017.kt");
            }

            @Test
            @TestMetadata(value="kt8047.kt")
            public void testKt8047() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt8047.kt");
            }

            @Test
            @TestMetadata(value="kt8047_2.kt")
            public void testKt8047_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt8047_2.kt");
            }

            @Test
            @TestMetadata(value="kt9637.kt")
            public void testKt9637() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt9637.kt");
            }

            @Test
            @TestMetadata(value="kt9637_2.kt")
            public void testKt9637_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt9637_2.kt");
            }

            @Test
            @TestMetadata(value="nameClash.kt")
            public void testNameClash() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/nameClash.kt");
            }

            @Test
            @TestMetadata(value="nonCapturingObjectInLambda.kt")
            public void testNonCapturingObjectInLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/nonCapturingObjectInLambda.kt");
            }

            @Test
            @TestMetadata(value="packages.kt")
            public void testPackages() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/packages.kt");
            }

            @Test
            @TestMetadata(value="singletonLambda.kt")
            public void testSingletonLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/singletonLambda.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/reified/isCheck")
            @TestDataPath(value="$PROJECT_ROOT")
            public class IsCheck {
                @Test
                public void testAllFilesPresentInIsCheck() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/isCheck"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="chain.kt")
                public void testChain() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/isCheck/chain.kt");
                }

                @Test
                @TestMetadata(value="nullable.kt")
                public void testNullable() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/isCheck/nullable.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/isCheck/simple.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/reified/defaultLambda")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DefaultLambda {
                @Test
                public void testAllFilesPresentInDefaultLambda() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/defaultLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="chain.kt")
                public void testChain() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/chain.kt");
                }

                @Test
                @TestMetadata(value="nested.kt")
                public void testNested() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested.kt");
                }

                @Test
                @TestMetadata(value="nested2.kt")
                public void testNested2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested2.kt");
                }

                @Test
                @TestMetadata(value="nested2Static.kt")
                public void testNested2Static() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested2Static.kt");
                }

                @Test
                @TestMetadata(value="nestedStatic.kt")
                public void testNestedStatic() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nestedStatic.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/simple.kt");
                }

                @Test
                @TestMetadata(value="transitiveChain.kt")
                public void testTransitiveChain() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/transitiveChain.kt");
                }

                @Test
                @TestMetadata(value="transitiveChainStatic.kt")
                public void testTransitiveChainStatic() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/transitiveChainStatic.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/reified/checkCast")
            @TestDataPath(value="$PROJECT_ROOT")
            public class CheckCast {
                @Test
                public void testAllFilesPresentInCheckCast() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/checkCast"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="chain.kt")
                public void testChain() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/chain.kt");
                }

                @Test
                @TestMetadata(value="kt26435.kt")
                public void testKt26435() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435.kt");
                }

                @Test
                @TestMetadata(value="kt26435_2.kt")
                public void testKt26435_2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435_2.kt");
                }

                @Test
                @TestMetadata(value="kt26435_3.kt")
                public void testKt26435_3() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435_3.kt");
                }

                @Test
                @TestMetadata(value="kt8043.kt")
                public void testKt8043() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt8043.kt");
                }

                @Test
                @TestMetadata(value="maxStack.kt")
                public void testMaxStack() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/maxStack.kt");
                }

                @Test
                @TestMetadata(value="nullable.kt")
                public void testNullable() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/nullable.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/simple.kt");
                }

                @Test
                @TestMetadata(value="simpleSafe.kt")
                public void testSimpleSafe() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/simpleSafe.kt");
                }

                @Test
                @TestMetadata(value="simple_1_3.kt")
                public void testSimple_1_3() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/simple_1_3.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/property")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Property {
            @Test
            public void testAllFilesPresentInProperty() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="augAssignmentAndInc.kt")
            public void testAugAssignmentAndInc() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndInc.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncInClass.kt")
            public void testAugAssignmentAndIncInClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncInClass.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncInClassViaConvention.kt")
            public void testAugAssignmentAndIncInClassViaConvention() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncInClassViaConvention.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncOnExtension.kt")
            public void testAugAssignmentAndIncOnExtension() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncOnExtension.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncOnExtensionInClass.kt")
            public void testAugAssignmentAndIncOnExtensionInClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncOnExtensionInClass.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncViaConvention.kt")
            public void testAugAssignmentAndIncViaConvention() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncViaConvention.kt");
            }

            @Test
            @TestMetadata(value="crossinlineFunctional.kt")
            public void testCrossinlineFunctional() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/crossinlineFunctional.kt");
            }

            @Test
            @TestMetadata(value="fromObject.kt")
            public void testFromObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/fromObject.kt");
            }

            @Test
            @TestMetadata(value="kt22649.kt")
            public void testKt22649() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/kt22649.kt");
            }

            @Test
            @TestMetadata(value="noinlineFunctional.kt")
            public void testNoinlineFunctional() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/noinlineFunctional.kt");
            }

            @Test
            @TestMetadata(value="property.kt")
            public void testProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/property.kt");
            }

            @Test
            @TestMetadata(value="reifiedVal.kt")
            public void testReifiedVal() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/reifiedVal.kt");
            }

            @Test
            @TestMetadata(value="reifiedValMultiModule.kt")
            public void testReifiedValMultiModule() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/reifiedValMultiModule.kt");
            }

            @Test
            @TestMetadata(value="reifiedVar.kt")
            public void testReifiedVar() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/reifiedVar.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/simple.kt");
            }

            @Test
            @TestMetadata(value="simpleExtension.kt")
            public void testSimpleExtension() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/simpleExtension.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/private")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Private {
            @Test
            @TestMetadata(value="accessorForConst.kt")
            public void testAccessorForConst() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/accessorForConst.kt");
            }

            @Test
            @TestMetadata(value="accessorStability.kt")
            public void testAccessorStability() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/accessorStability.kt");
            }

            @Test
            @TestMetadata(value="accessorStabilityInClass.kt")
            public void testAccessorStabilityInClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/accessorStabilityInClass.kt");
            }

            @Test
            public void testAllFilesPresentInPrivate() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/private"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="effectivePrivate.kt")
            public void testEffectivePrivate() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/effectivePrivate.kt");
            }

            @Test
            @TestMetadata(value="kt6453.kt")
            public void testKt6453() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/kt6453.kt");
            }

            @Test
            @TestMetadata(value="kt8094.kt")
            public void testKt8094() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/kt8094.kt");
            }

            @Test
            @TestMetadata(value="kt8095.kt")
            public void testKt8095() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/kt8095.kt");
            }

            @Test
            @TestMetadata(value="nestedInPrivateClass.kt")
            public void testNestedInPrivateClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/nestedInPrivateClass.kt");
            }

            @Test
            @TestMetadata(value="nestedInPrivateClass2.kt")
            public void testNestedInPrivateClass2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/nestedInPrivateClass2.kt");
            }

            @Test
            @TestMetadata(value="privateClass.kt")
            public void testPrivateClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/privateClass.kt");
            }

            @Test
            @TestMetadata(value="privateClassExtensionLambda.kt")
            public void testPrivateClassExtensionLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/privateClassExtensionLambda.kt");
            }

            @Test
            @TestMetadata(value="privateInInlineInMultiFileFacade.kt")
            public void testPrivateInInlineInMultiFileFacade() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/privateInInlineInMultiFileFacade.kt");
            }

            @Test
            @TestMetadata(value="privateInline.kt")
            public void testPrivateInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/privateInline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/optimizations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Optimizations {
            @Test
            public void testAllFilesPresentInOptimizations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/optimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt20844.kt")
            public void testKt20844() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/optimizations/kt20844.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NonLocalReturns {
            @Test
            public void testAllFilesPresentInNonLocalReturns() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="explicitLocalReturn.kt")
            public void testExplicitLocalReturn() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/explicitLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGenerator.kt")
            public void testFromArrayGenerator() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGenerator.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorCatch.kt")
            public void testFromArrayGeneratorCatch() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorCatch.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorNested.kt")
            public void testFromArrayGeneratorNested() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorNested.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithCapture.kt")
            public void testFromArrayGeneratorWithCapture() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithCapture.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithCatch.kt")
            public void testFromArrayGeneratorWithCatch() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithCatch.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithFinally.kt")
            public void testFromArrayGeneratorWithFinally() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinally.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithFinallyX2.kt")
            public void testFromArrayGeneratorWithFinallyX2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinallyX2.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithFinallyX2_2.kt")
            public void testFromArrayGeneratorWithFinallyX2_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinallyX2_2.kt");
            }

            @Test
            @TestMetadata(value="fromInterfaceDefaultGetter.kt")
            public void testFromInterfaceDefaultGetter() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromInterfaceDefaultGetter.kt");
            }

            @Test
            @TestMetadata(value="justReturnInLambda.kt")
            public void testJustReturnInLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/justReturnInLambda.kt");
            }

            @Test
            @TestMetadata(value="kt5199.kt")
            public void testKt5199() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt5199.kt");
            }

            @Test
            @TestMetadata(value="kt8948.kt")
            public void testKt8948() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt8948.kt");
            }

            @Test
            @TestMetadata(value="kt8948v2.kt")
            public void testKt8948v2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt8948v2.kt");
            }

            @Test
            @TestMetadata(value="kt9304.kt")
            public void testKt9304() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt9304.kt");
            }

            @Test
            @TestMetadata(value="nestedNonLocals.kt")
            public void testNestedNonLocals() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/nestedNonLocals.kt");
            }

            @Test
            @TestMetadata(value="noInlineLocalReturn.kt")
            public void testNoInlineLocalReturn() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/noInlineLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturnFromOuterLambda.kt")
            public void testNonLocalReturnFromOuterLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/nonLocalReturnFromOuterLambda.kt");
            }

            @Test
            @TestMetadata(value="propertyAccessors.kt")
            public void testPropertyAccessors() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/propertyAccessors.kt");
            }

            @Test
            @TestMetadata(value="returnFromFunctionExpr.kt")
            public void testReturnFromFunctionExpr() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/returnFromFunctionExpr.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simple.kt");
            }

            @Test
            @TestMetadata(value="simpleFunctional.kt")
            public void testSimpleFunctional() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simpleFunctional.kt");
            }

            @Test
            @TestMetadata(value="simpleVoid.kt")
            public void testSimpleVoid() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simpleVoid.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally")
            @TestDataPath(value="$PROJECT_ROOT")
            public class TryFinally {
                @Test
                public void testAllFilesPresentInTryFinally() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="kt16417.kt")
                public void testKt16417() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt16417.kt");
                }

                @Test
                @TestMetadata(value="kt20433.kt")
                public void testKt20433() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433.kt");
                }

                @Test
                @TestMetadata(value="kt20433_2.kt")
                public void testKt20433_2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_2.kt");
                }

                @Test
                @TestMetadata(value="kt20433_2_void.kt")
                public void testKt20433_2_void() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_2_void.kt");
                }

                @Test
                @TestMetadata(value="kt20433_void.kt")
                public void testKt20433_void() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_void.kt");
                }

                @Test
                @TestMetadata(value="kt26384.kt")
                public void testKt26384() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt26384.kt");
                }

                @Test
                @TestMetadata(value="kt26384_2.kt")
                public void testKt26384_2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt26384_2.kt");
                }

                @Test
                @TestMetadata(value="kt28546.kt")
                public void testKt28546() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt28546.kt");
                }

                @Test
                @TestMetadata(value="kt6956.kt")
                public void testKt6956() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt6956.kt");
                }

                @Test
                @TestMetadata(value="kt7273.kt")
                public void testKt7273() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt7273.kt");
                }

                @Test
                @TestMetadata(value="nonLocalReturnFromCatchBlock.kt")
                public void testNonLocalReturnFromCatchBlock() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnFromCatchBlock.kt");
                }

                @Test
                @TestMetadata(value="nonLocalReturnFromOuterLambda.kt")
                public void testNonLocalReturnFromOuterLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnFromOuterLambda.kt");
                }

                @Test
                @TestMetadata(value="nonLocalReturnToCatchBlock.kt")
                public void testNonLocalReturnToCatchBlock() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnToCatchBlock.kt");
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables")
                @TestDataPath(value="$PROJECT_ROOT")
                public class Variables {
                    @Test
                    public void testAllFilesPresentInVariables() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="kt7792.kt")
                    public void testKt7792() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables/kt7792.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable")
                @TestDataPath(value="$PROJECT_ROOT")
                public class ExceptionTable {
                    @Test
                    public void testAllFilesPresentInExceptionTable() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="break.kt")
                    public void testBreak() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/break.kt");
                    }

                    @Test
                    @TestMetadata(value="continue.kt")
                    public void testContinue() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/continue.kt");
                    }

                    @Test
                    @TestMetadata(value="exceptionInFinally.kt")
                    public void testExceptionInFinally() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/exceptionInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="forInFinally.kt")
                    public void testForInFinally() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/forInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="innerAndExternal.kt")
                    public void testInnerAndExternal() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternal.kt");
                    }

                    @Test
                    @TestMetadata(value="innerAndExternalNested.kt")
                    public void testInnerAndExternalNested() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternalNested.kt");
                    }

                    @Test
                    @TestMetadata(value="innerAndExternalSimple.kt")
                    public void testInnerAndExternalSimple() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternalSimple.kt");
                    }

                    @Test
                    @TestMetadata(value="kt31653.kt")
                    public void testKt31653() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31653.kt");
                    }

                    @Test
                    @TestMetadata(value="kt31653_2.kt")
                    public void testKt31653_2() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31653_2.kt");
                    }

                    @Test
                    @TestMetadata(value="kt31923.kt")
                    public void testKt31923() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923.kt");
                    }

                    @Test
                    @TestMetadata(value="kt31923_2.kt")
                    public void testKt31923_2() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923_2.kt");
                    }

                    @Test
                    @TestMetadata(value="kt31923_wrong.kt")
                    public void testKt31923_wrong() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923_wrong.kt");
                    }

                    @Test
                    @TestMetadata(value="nested.kt")
                    public void testNested() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nested.kt");
                    }

                    @Test
                    @TestMetadata(value="nestedWithReturns.kt")
                    public void testNestedWithReturns() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nestedWithReturns.kt");
                    }

                    @Test
                    @TestMetadata(value="nestedWithReturnsSimple.kt")
                    public void testNestedWithReturnsSimple() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nestedWithReturnsSimple.kt");
                    }

                    @Test
                    @TestMetadata(value="noFinally.kt")
                    public void testNoFinally() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/noFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="severalCatchClause.kt")
                    public void testSeveralCatchClause() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/severalCatchClause.kt");
                    }

                    @Test
                    @TestMetadata(value="simpleThrow.kt")
                    public void testSimpleThrow() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/simpleThrow.kt");
                    }

                    @Test
                    @TestMetadata(value="synchonized.kt")
                    public void testSynchonized() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/synchonized.kt");
                    }

                    @Test
                    @TestMetadata(value="throwInFinally.kt")
                    public void testThrowInFinally() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/throwInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="tryCatchInFinally.kt")
                    public void testTryCatchInFinally() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/tryCatchInFinally.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite")
                @TestDataPath(value="$PROJECT_ROOT")
                public class DeclSite {
                    @Test
                    public void testAllFilesPresentInDeclSite() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="complex.kt")
                    public void testComplex() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/complex.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturn.kt")
                    public void testIntReturn() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/intReturn.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex.kt")
                    public void testIntReturnComplex() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/intReturnComplex.kt");
                    }

                    @Test
                    @TestMetadata(value="longReturn.kt")
                    public void testLongReturn() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/longReturn.kt");
                    }

                    @Test
                    @TestMetadata(value="nested.kt")
                    public void testNested() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/nested.kt");
                    }

                    @Test
                    @TestMetadata(value="returnInFinally.kt")
                    public void testReturnInFinally() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="returnInTry.kt")
                    public void testReturnInTry() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInTry.kt");
                    }

                    @Test
                    @TestMetadata(value="returnInTryAndFinally.kt")
                    public void testReturnInTryAndFinally() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInTryAndFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="severalInTry.kt")
                    public void testSeveralInTry() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/severalInTry.kt");
                    }

                    @Test
                    @TestMetadata(value="severalInTryComplex.kt")
                    public void testSeveralInTryComplex() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/severalInTryComplex.kt");
                    }

                    @Test
                    @TestMetadata(value="voidInlineFun.kt")
                    public void testVoidInlineFun() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/voidInlineFun.kt");
                    }

                    @Test
                    @TestMetadata(value="voidNonLocal.kt")
                    public void testVoidNonLocal() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/voidNonLocal.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained")
                @TestDataPath(value="$PROJECT_ROOT")
                public class Chained {
                    @Test
                    public void testAllFilesPresentInChained() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="finallyInFinally.kt")
                    public void testFinallyInFinally() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/finallyInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="finallyInFinally2.kt")
                    public void testFinallyInFinally2() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/finallyInFinally2.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturn.kt")
                    public void testIntReturn() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturn.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex.kt")
                    public void testIntReturnComplex() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex2.kt")
                    public void testIntReturnComplex2() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex2.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex3.kt")
                    public void testIntReturnComplex3() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex3.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex4.kt")
                    public void testIntReturnComplex4() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex4.kt");
                    }

                    @Test
                    @TestMetadata(value="nestedLambda.kt")
                    public void testNestedLambda() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/nestedLambda.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite")
                @TestDataPath(value="$PROJECT_ROOT")
                public class CallSite {
                    @Test
                    public void testAllFilesPresentInCallSite() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="callSite.kt")
                    public void testCallSite() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/callSite.kt");
                    }

                    @Test
                    @TestMetadata(value="callSiteComplex.kt")
                    public void testCallSiteComplex() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/callSiteComplex.kt");
                    }

                    @Test
                    @TestMetadata(value="exceptionTableSplit.kt")
                    public void testExceptionTableSplit() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/exceptionTableSplit.kt");
                    }

                    @Test
                    @TestMetadata(value="exceptionTableSplitNoReturn.kt")
                    public void testExceptionTableSplitNoReturn() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/exceptionTableSplitNoReturn.kt");
                    }

                    @Test
                    @TestMetadata(value="finallyInFinally.kt")
                    public void testFinallyInFinally() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/finallyInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="wrongVarInterval.kt")
                    public void testWrongVarInterval() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/wrongVarInterval.kt");
                    }
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Deparenthesize {
                @Test
                public void testAllFilesPresentInDeparenthesize() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="bracket.kt")
                public void testBracket() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize/bracket.kt");
                }

                @Test
                @TestMetadata(value="labeled.kt")
                public void testLabeled() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize/labeled.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/noInline")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NoInline {
            @Test
            public void testAllFilesPresentInNoInline() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/noInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="extensionReceiver.kt")
            public void testExtensionReceiver() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/extensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="lambdaAsGeneric.kt")
            public void testLambdaAsGeneric() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/lambdaAsGeneric.kt");
            }

            @Test
            @TestMetadata(value="lambdaAsNonFunction.kt")
            public void testLambdaAsNonFunction() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/lambdaAsNonFunction.kt");
            }

            @Test
            @TestMetadata(value="noInline.kt")
            public void testNoInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/noInline.kt");
            }

            @Test
            @TestMetadata(value="noInlineLambdaChain.kt")
            public void testNoInlineLambdaChain() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/noInlineLambdaChain.kt");
            }

            @Test
            @TestMetadata(value="noInlineLambdaChainWithCapturedInline.kt")
            public void testNoInlineLambdaChainWithCapturedInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/noInlineLambdaChainWithCapturedInline.kt");
            }

            @Test
            @TestMetadata(value="withoutInline.kt")
            public void testWithoutInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/withoutInline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/multiplatform")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Multiplatform {
            @Test
            public void testAllFilesPresentInMultiplatform() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/multiplatform/defaultArguments")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DefaultArguments {
                @Test
                public void testAllFilesPresentInDefaultArguments() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiplatform/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="receiversAndParametersInLambda.kt")
                public void testReceiversAndParametersInLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/multiplatform/defaultArguments/receiversAndParametersInLambda.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/multifileClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class MultifileClasses {
            @Test
            public void testAllFilesPresentInMultifileClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultArguments.kt")
            public void testDefaultArguments() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/multifileClasses/defaultArguments.kt");
            }

            @Test
            @TestMetadata(value="inlineFromOptimizedMultifileClass.kt")
            public void testInlineFromOptimizedMultifileClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/multifileClasses/inlineFromOptimizedMultifileClass.kt");
            }

            @Test
            @TestMetadata(value="inlineFromOtherPackage.kt")
            public void testInlineFromOtherPackage() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/multifileClasses/inlineFromOtherPackage.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/multiModule")
        @TestDataPath(value="$PROJECT_ROOT")
        public class MultiModule {
            @Test
            public void testAllFilesPresentInMultiModule() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiModule"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="tryCatchWithRecursiveInline.kt")
            public void testTryCatchWithRecursiveInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/multiModule/tryCatchWithRecursiveInline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/localFunInLambda")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LocalFunInLambda {
            @Test
            public void testAllFilesPresentInLocalFunInLambda() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/localFunInLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultParam.kt")
            public void testDefaultParam() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/localFunInLambda/defaultParam.kt");
            }

            @Test
            @TestMetadata(value="lambdaInLambdaCapturesAnotherFun.kt")
            public void testLambdaInLambdaCapturesAnotherFun() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/localFunInLambda/lambdaInLambdaCapturesAnotherFun.kt");
            }

            @Test
            @TestMetadata(value="localFunInLambda.kt")
            public void testLocalFunInLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambda.kt");
            }

            @Test
            @TestMetadata(value="localFunInLambdaCapturesAnotherFun.kt")
            public void testLocalFunInLambdaCapturesAnotherFun() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambdaCapturesAnotherFun.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/lambdaTransformation")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LambdaTransformation {
            @Test
            public void testAllFilesPresentInLambdaTransformation() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/lambdaTransformation"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="lambdaCloning.kt")
            public void testLambdaCloning() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaCloning.kt");
            }

            @Test
            @TestMetadata(value="lambdaInLambda2.kt")
            public void testLambdaInLambda2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaInLambda2.kt");
            }

            @Test
            @TestMetadata(value="lambdaInLambdaNoInline.kt")
            public void testLambdaInLambdaNoInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaInLambdaNoInline.kt");
            }

            @Test
            @TestMetadata(value="regeneratedLambdaName.kt")
            public void testRegeneratedLambdaName() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/regeneratedLambdaName.kt");
            }

            @Test
            @TestMetadata(value="regeneratedLambdaName2.kt")
            public void testRegeneratedLambdaName2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/regeneratedLambdaName2.kt");
            }

            @Test
            @TestMetadata(value="sameCaptured.kt")
            public void testSameCaptured() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/sameCaptured.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/lambdaClassClash")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LambdaClassClash {
            @Test
            public void testAllFilesPresentInLambdaClassClash() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/lambdaClassClash"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="lambdaClassClash.kt")
            public void testLambdaClassClash() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaClassClash/lambdaClassClash.kt");
            }

            @Test
            @TestMetadata(value="noInlineLambdaX2.kt")
            public void testNoInlineLambdaX2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaClassClash/noInlineLambdaX2.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/jvmPackageName")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JvmPackageName {
            @Test
            public void testAllFilesPresentInJvmPackageName() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/jvmPackageName"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/jvmPackageName/simple.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/jvmName")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JvmName {
            @Test
            public void testAllFilesPresentInJvmName() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/jvmName"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/jvmName/simple.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/invokedynamic")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Invokedynamic {
            @Test
            public void testAllFilesPresentInInvokedynamic() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/invokedynamic/sam")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Sam {
                @Test
                public void testAllFilesPresentInSam() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="crossinlineLambda1.kt")
                public void testCrossinlineLambda1() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/crossinlineLambda1.kt");
                }

                @Test
                @TestMetadata(value="crossinlineLambda2.kt")
                public void testCrossinlineLambda2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/crossinlineLambda2.kt");
                }

                @Test
                @TestMetadata(value="inlineFunInDifferentPackage.kt")
                public void testInlineFunInDifferentPackage() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/inlineFunInDifferentPackage.kt");
                }

                @Test
                @TestMetadata(value="inlineLambda1.kt")
                public void testInlineLambda1() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/inlineLambda1.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/invokedynamic/lambdas")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Lambdas {
                @Test
                public void testAllFilesPresentInLambdas() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic/lambdas"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="crossinlineLambda1.kt")
                public void testCrossinlineLambda1() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/crossinlineLambda1.kt");
                }

                @Test
                @TestMetadata(value="crossinlineLambda2.kt")
                public void testCrossinlineLambda2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/crossinlineLambda2.kt");
                }

                @Test
                @TestMetadata(value="inlineFunInDifferentPackage.kt")
                public void testInlineFunInDifferentPackage() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/inlineFunInDifferentPackage.kt");
                }

                @Test
                @TestMetadata(value="inlineLambda1.kt")
                public void testInlineLambda1() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/inlineLambda1.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/innerClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InnerClasses {
            @Test
            public void testAllFilesPresentInInnerClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/innerClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="captureThisAndOuter.kt")
            public void testCaptureThisAndOuter() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/captureThisAndOuter.kt");
            }

            @Test
            @TestMetadata(value="fakeOverride.kt")
            public void testFakeOverride() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/fakeOverride.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuter.kt")
            public void testInnerInlineFunCapturesOuter() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuter.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuterByAnotherInlineFun.kt")
            public void testInnerInlineFunCapturesOuterByAnotherInlineFun() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterByAnotherInlineFun.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuterDeep.kt")
            public void testInnerInlineFunCapturesOuterDeep() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterDeep.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuterFunRef.kt")
            public void testInnerInlineFunCapturesOuterFunRef() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterFunRef.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuterWithInlineClass.kt")
            public void testInnerInlineFunCapturesOuterWithInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterWithInlineClass.kt");
            }

            @Test
            @TestMetadata(value="innerLambda.kt")
            public void testInnerLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerLambda.kt");
            }

            @Test
            @TestMetadata(value="kt10259.kt")
            public void testKt10259() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/kt10259.kt");
            }

            @Test
            @TestMetadata(value="kt12126.kt")
            public void testKt12126() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/kt12126.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="anonymousObject.kt")
            public void testAnonymousObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/anonymousObject.kt");
            }

            @Test
            @TestMetadata(value="inlineClassWithInlineValReturningInlineClass.kt")
            public void testInlineClassWithInlineValReturningInlineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/inlineClassWithInlineValReturningInlineClass.kt");
            }

            @Test
            @TestMetadata(value="inlineFunctionInsideInlineClassesBox.kt")
            public void testInlineFunctionInsideInlineClassesBox() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/inlineFunctionInsideInlineClassesBox.kt");
            }

            @Test
            @TestMetadata(value="kt62313.kt")
            public void testKt62313() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/kt62313.kt");
            }

            @Test
            @TestMetadata(value="noReturnTypeManglingFun.kt")
            public void testNoReturnTypeManglingFun() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/noReturnTypeManglingFun.kt");
            }

            @Test
            @TestMetadata(value="noReturnTypeManglingFunJvmName.kt")
            public void testNoReturnTypeManglingFunJvmName() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/noReturnTypeManglingFunJvmName.kt");
            }

            @Test
            @TestMetadata(value="noReturnTypeManglingVal.kt")
            public void testNoReturnTypeManglingVal() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/noReturnTypeManglingVal.kt");
            }

            @Test
            @TestMetadata(value="withReturnTypeManglingFun.kt")
            public void testWithReturnTypeManglingFun() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingFun.kt");
            }

            @Test
            @TestMetadata(value="withReturnTypeManglingFunJvmName.kt")
            public void testWithReturnTypeManglingFunJvmName() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingFunJvmName.kt");
            }

            @Test
            @TestMetadata(value="withReturnTypeManglingVal.kt")
            public void testWithReturnTypeManglingVal() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingVal.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter")
            @TestDataPath(value="$PROJECT_ROOT")
            public class UnboxGenericParameter {
                @Test
                public void testAllFilesPresentInUnboxGenericParameter() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral")
                @TestDataPath(value="$PROJECT_ROOT")
                public class ObjectLiteral {
                    @Test
                    public void testAllFilesPresentInObjectLiteral() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="any.kt")
                    public void testAny() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/any.kt");
                    }

                    @Test
                    @TestMetadata(value="anyN.kt")
                    public void testAnyN() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/anyN.kt");
                    }

                    @Test
                    @TestMetadata(value="iface.kt")
                    public void testIface() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/iface.kt");
                    }

                    @Test
                    @TestMetadata(value="ifaceChild.kt")
                    public void testIfaceChild() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/ifaceChild.kt");
                    }

                    @Test
                    @TestMetadata(value="primitive.kt")
                    public void testPrimitive() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/primitive.kt");
                    }

                    @Test
                    @TestMetadata(value="string.kt")
                    public void testString() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/string.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda")
                @TestDataPath(value="$PROJECT_ROOT")
                public class Lambda {
                    @Test
                    public void testAllFilesPresentInLambda() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="any.kt")
                    public void testAny() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/any.kt");
                    }

                    @Test
                    @TestMetadata(value="anyN.kt")
                    public void testAnyN() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/anyN.kt");
                    }

                    @Test
                    @TestMetadata(value="iface.kt")
                    public void testIface() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/iface.kt");
                    }

                    @Test
                    @TestMetadata(value="ifaceChild.kt")
                    public void testIfaceChild() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/ifaceChild.kt");
                    }

                    @Test
                    @TestMetadata(value="primitive.kt")
                    public void testPrimitive() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/primitive.kt");
                    }

                    @Test
                    @TestMetadata(value="string.kt")
                    public void testString() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/string.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface")
                @TestDataPath(value="$PROJECT_ROOT")
                public class FunInterface {
                    @Test
                    public void testAllFilesPresentInFunInterface() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="any.kt")
                    public void testAny() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/any.kt");
                    }

                    @Test
                    @TestMetadata(value="anyN.kt")
                    public void testAnyN() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/anyN.kt");
                    }

                    @Test
                    @TestMetadata(value="iface.kt")
                    public void testIface() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/iface.kt");
                    }

                    @Test
                    @TestMetadata(value="ifaceChild.kt")
                    public void testIfaceChild() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/ifaceChild.kt");
                    }

                    @Test
                    @TestMetadata(value="primitive.kt")
                    public void testPrimitive() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/primitive.kt");
                    }

                    @Test
                    @TestMetadata(value="string.kt")
                    public void testString() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/string.kt");
                    }
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/inlineArgsInplace")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineArgsInplace {
            @Test
            public void testAllFilesPresentInInlineArgsInplace() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineArgsInplace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="callArgumentReordering.kt")
            public void testCallArgumentReordering() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineArgsInplace/callArgumentReordering.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/functionExpression")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FunctionExpression {
            @Test
            public void testAllFilesPresentInFunctionExpression() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/functionExpression"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="extension.kt")
            public void testExtension() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/functionExpression/extension.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/enum")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Enum {
            @Test
            public void testAllFilesPresentInEnum() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="enumEntries.kt")
            public void testEnumEntries() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/enumEntries.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesChainCapturedType.kt")
            public void testEnumEntriesChainCapturedType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/enumEntriesChainCapturedType.kt");
            }

            @Test
            @TestMetadata(value="javaEnumEntries.kt")
            public void testJavaEnumEntries() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/javaEnumEntries.kt");
            }

            @Test
            @TestMetadata(value="javaEnumEntriesChainCapturedType.kt")
            public void testJavaEnumEntriesChainCapturedType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/javaEnumEntriesChainCapturedType.kt");
            }

            @Test
            @TestMetadata(value="kt10569.kt")
            public void testKt10569() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/kt10569.kt");
            }

            @Test
            @TestMetadata(value="kt18254.kt")
            public void testKt18254() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/kt18254.kt");
            }

            @Test
            @TestMetadata(value="valueOf.kt")
            public void testValueOf() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOf.kt");
            }

            @Test
            @TestMetadata(value="valueOfCapturedType.kt")
            public void testValueOfCapturedType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOfCapturedType.kt");
            }

            @Test
            @TestMetadata(value="valueOfChain.kt")
            public void testValueOfChain() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOfChain.kt");
            }

            @Test
            @TestMetadata(value="valueOfChainCapturedType.kt")
            public void testValueOfChainCapturedType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOfChainCapturedType.kt");
            }

            @Test
            @TestMetadata(value="valueOfNonReified.kt")
            public void testValueOfNonReified() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOfNonReified.kt");
            }

            @Test
            @TestMetadata(value="values.kt")
            public void testValues() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/values.kt");
            }

            @Test
            @TestMetadata(value="valuesAsArray.kt")
            public void testValuesAsArray() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesAsArray.kt");
            }

            @Test
            @TestMetadata(value="valuesCapturedType.kt")
            public void testValuesCapturedType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesCapturedType.kt");
            }

            @Test
            @TestMetadata(value="valuesChain.kt")
            public void testValuesChain() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesChain.kt");
            }

            @Test
            @TestMetadata(value="valuesChainCapturedType.kt")
            public void testValuesChainCapturedType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesChainCapturedType.kt");
            }

            @Test
            @TestMetadata(value="valuesNonReified.kt")
            public void testValuesNonReified() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesNonReified.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/enclosingInfo")
        @TestDataPath(value="$PROJECT_ROOT")
        public class EnclosingInfo {
            @Test
            public void testAllFilesPresentInEnclosingInfo() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/enclosingInfo"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="anonymousInLambda.kt")
            public void testAnonymousInLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/anonymousInLambda.kt");
            }

            @Test
            @TestMetadata(value="inlineChain.kt")
            public void testInlineChain() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/inlineChain.kt");
            }

            @Test
            @TestMetadata(value="inlineChain2.kt")
            public void testInlineChain2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/inlineChain2.kt");
            }

            @Test
            @TestMetadata(value="kt52417.kt")
            public void testKt52417() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/kt52417.kt");
            }

            @Test
            @TestMetadata(value="objectInInlineFun.kt")
            public void testObjectInInlineFun() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/objectInInlineFun.kt");
            }

            @Test
            @TestMetadata(value="transformedConstructor.kt")
            public void testTransformedConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructor.kt");
            }

            @Test
            @TestMetadata(value="transformedConstructorWithAdditionalObject.kt")
            public void testTransformedConstructorWithAdditionalObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructorWithAdditionalObject.kt");
            }

            @Test
            @TestMetadata(value="transformedConstructorWithNestedInline.kt")
            public void testTransformedConstructorWithNestedInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructorWithNestedInline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/delegatedProperty")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DelegatedProperty {
            @Test
            public void testAllFilesPresentInDelegatedProperty() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt16864.kt")
            public void testKt16864() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/kt16864.kt");
            }

            @Test
            @TestMetadata(value="kt48498.kt")
            public void testKt48498() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/kt48498.kt");
            }

            @Test
            @TestMetadata(value="local.kt")
            public void testLocal() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/local.kt");
            }

            @Test
            @TestMetadata(value="localDeclaredInLambda.kt")
            public void testLocalDeclaredInLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/localDeclaredInLambda.kt");
            }

            @Test
            @TestMetadata(value="localInAnonymousObject.kt")
            public void testLocalInAnonymousObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/localInAnonymousObject.kt");
            }

            @Test
            @TestMetadata(value="localInLambda.kt")
            public void testLocalInLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/localInLambda.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/defaultValues")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DefaultValues {
            @Test
            @TestMetadata(value="33Parameters.kt")
            public void test33Parameters() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/33Parameters.kt");
            }

            @Test
            @TestMetadata(value="33ParametersInConstructor.kt")
            public void test33ParametersInConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/33ParametersInConstructor.kt");
            }

            @Test
            public void testAllFilesPresentInDefaultValues() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultInExtension.kt")
            public void testDefaultInExtension() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/defaultInExtension.kt");
            }

            @Test
            @TestMetadata(value="defaultMethod.kt")
            public void testDefaultMethod() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/defaultMethod.kt");
            }

            @Test
            @TestMetadata(value="defaultMethodInClass.kt")
            public void testDefaultMethodInClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/defaultMethodInClass.kt");
            }

            @Test
            @TestMetadata(value="defaultParamRemapping.kt")
            public void testDefaultParamRemapping() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/defaultParamRemapping.kt");
            }

            @Test
            @TestMetadata(value="inlineInDefaultParameter.kt")
            public void testInlineInDefaultParameter() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/inlineInDefaultParameter.kt");
            }

            @Test
            @TestMetadata(value="inlineLambdaInNoInlineDefault.kt")
            public void testInlineLambdaInNoInlineDefault() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/inlineLambdaInNoInlineDefault.kt");
            }

            @Test
            @TestMetadata(value="kt11479.kt")
            public void testKt11479() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt11479.kt");
            }

            @Test
            @TestMetadata(value="kt11479InlinedDefaultParameter.kt")
            public void testKt11479InlinedDefaultParameter() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt11479InlinedDefaultParameter.kt");
            }

            @Test
            @TestMetadata(value="kt14564.kt")
            public void testKt14564() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt14564.kt");
            }

            @Test
            @TestMetadata(value="kt14564_2.kt")
            public void testKt14564_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt14564_2.kt");
            }

            @Test
            @TestMetadata(value="kt16496.kt")
            public void testKt16496() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt16496.kt");
            }

            @Test
            @TestMetadata(value="kt18689.kt")
            public void testKt18689() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689.kt");
            }

            @Test
            @TestMetadata(value="kt18689_2.kt")
            public void testKt18689_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_2.kt");
            }

            @Test
            @TestMetadata(value="kt18689_3.kt")
            public void testKt18689_3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_3.kt");
            }

            @Test
            @TestMetadata(value="kt18689_4.kt")
            public void testKt18689_4() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_4.kt");
            }

            @Test
            @TestMetadata(value="kt5685.kt")
            public void testKt5685() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt5685.kt");
            }

            @Test
            @TestMetadata(value="simpleDefaultMethod.kt")
            public void testSimpleDefaultMethod() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/simpleDefaultMethod.kt");
            }

            @Test
            @TestMetadata(value="varArgNoInline.kt")
            public void testVarArgNoInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/varArgNoInline.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/defaultValues/maskElimination")
            @TestDataPath(value="$PROJECT_ROOT")
            public class MaskElimination {
                @Test
                @TestMetadata(value="32Parameters.kt")
                public void test32Parameters() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/32Parameters.kt");
                }

                @Test
                @TestMetadata(value="33Parameters.kt")
                public void test33Parameters() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/33Parameters.kt");
                }

                @Test
                public void testAllFilesPresentInMaskElimination() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/maskElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="kt18792.kt")
                public void testKt18792() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt18792.kt");
                }

                @Test
                @TestMetadata(value="kt19679.kt")
                public void testKt19679() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679.kt");
                }

                @Test
                @TestMetadata(value="kt19679_2.kt")
                public void testKt19679_2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679_2.kt");
                }

                @Test
                @TestMetadata(value="kt19679_3.kt")
                public void testKt19679_3() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679_3.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/simple.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/defaultValues/lambdaInlining")
            @TestDataPath(value="$PROJECT_ROOT")
            public class LambdaInlining {
                @Test
                public void testAllFilesPresentInLambdaInlining() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="checkLambdaClassIsPresent.kt")
                public void testCheckLambdaClassIsPresent() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkLambdaClassIsPresent.kt");
                }

                @Test
                @TestMetadata(value="checkLambdaClassesArePresent.kt")
                public void testCheckLambdaClassesArePresent() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkLambdaClassesArePresent.kt");
                }

                @Test
                @TestMetadata(value="checkObjectClassIsPresent.kt")
                public void testCheckObjectClassIsPresent() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkObjectClassIsPresent.kt");
                }

                @Test
                @TestMetadata(value="checkStaticLambdaClassIsPresent.kt")
                public void testCheckStaticLambdaClassIsPresent() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticLambdaClassIsPresent.kt");
                }

                @Test
                @TestMetadata(value="checkStaticLambdaClassesArePresent.kt")
                public void testCheckStaticLambdaClassesArePresent() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticLambdaClassesArePresent.kt");
                }

                @Test
                @TestMetadata(value="checkStaticObjectClassIsPresent.kt")
                public void testCheckStaticObjectClassIsPresent() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticObjectClassIsPresent.kt");
                }

                @Test
                @TestMetadata(value="defaultAfterCapturing.kt")
                public void testDefaultAfterCapturing() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultAfterCapturing.kt");
                }

                @Test
                @TestMetadata(value="defaultCallInDefaultLambda.kt")
                public void testDefaultCallInDefaultLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultCallInDefaultLambda.kt");
                }

                @Test
                @TestMetadata(value="defaultLambdaInNoInline.kt")
                public void testDefaultLambdaInNoInline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultLambdaInNoInline.kt");
                }

                @Test
                @TestMetadata(value="differentInvokeSignature.kt")
                public void testDifferentInvokeSignature() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/differentInvokeSignature.kt");
                }

                @Test
                @TestMetadata(value="genericLambda.kt")
                public void testGenericLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/genericLambda.kt");
                }

                @Test
                @TestMetadata(value="instanceCapturedInClass.kt")
                public void testInstanceCapturedInClass() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/instanceCapturedInClass.kt");
                }

                @Test
                @TestMetadata(value="instanceCapturedInInterface.kt")
                public void testInstanceCapturedInInterface() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/instanceCapturedInInterface.kt");
                }

                @Test
                @TestMetadata(value="jvmStaticDefault.kt")
                public void testJvmStaticDefault() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/jvmStaticDefault.kt");
                }

                @Test
                @TestMetadata(value="kt21827.kt")
                public void testKt21827() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt21827.kt");
                }

                @Test
                @TestMetadata(value="kt21946.kt")
                public void testKt21946() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt21946.kt");
                }

                @Test
                @TestMetadata(value="kt24477.kt")
                public void testKt24477() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt24477.kt");
                }

                @Test
                @TestMetadata(value="kt25106.kt")
                public void testKt25106() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt25106.kt");
                }

                @Test
                @TestMetadata(value="kt26636.kt")
                public void testKt26636() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt26636.kt");
                }

                @Test
                @TestMetadata(value="lambdaTakesResult.kt")
                public void testLambdaTakesResult() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/lambdaTakesResult.kt");
                }

                @Test
                @TestMetadata(value="noInline.kt")
                public void testNoInline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/noInline.kt");
                }

                @Test
                @TestMetadata(value="nonDefaultInlineInNoInline.kt")
                public void testNonDefaultInlineInNoInline() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/nonDefaultInlineInNoInline.kt");
                }

                @Test
                @TestMetadata(value="receiverClash.kt")
                public void testReceiverClash() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClash.kt");
                }

                @Test
                @TestMetadata(value="receiverClash2.kt")
                public void testReceiverClash2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClash2.kt");
                }

                @Test
                @TestMetadata(value="receiverClashInClass.kt")
                public void testReceiverClashInClass() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClashInClass.kt");
                }

                @Test
                @TestMetadata(value="receiverClashInClass2.kt")
                public void testReceiverClashInClass2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClashInClass2.kt");
                }

                @Test
                @TestMetadata(value="reordering.kt")
                public void testReordering() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/reordering.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simple.kt");
                }

                @Test
                @TestMetadata(value="simpleErased.kt")
                public void testSimpleErased() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleErased.kt");
                }

                @Test
                @TestMetadata(value="simpleErasedStaticInstance.kt")
                public void testSimpleErasedStaticInstance() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleErasedStaticInstance.kt");
                }

                @Test
                @TestMetadata(value="simpleExtension.kt")
                public void testSimpleExtension() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleExtension.kt");
                }

                @Test
                @TestMetadata(value="simpleGeneric.kt")
                public void testSimpleGeneric() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleGeneric.kt");
                }

                @Test
                @TestMetadata(value="simpleStaticInstance.kt")
                public void testSimpleStaticInstance() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleStaticInstance.kt");
                }

                @Test
                @TestMetadata(value="thisClash.kt")
                public void testThisClash() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/thisClash.kt");
                }

                @Test
                @TestMetadata(value="thisClashInClass.kt")
                public void testThisClashInClass() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/thisClashInClass.kt");
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences")
                @TestDataPath(value="$PROJECT_ROOT")
                public class CallableReferences {
                    @Test
                    public void testAllFilesPresentInCallableReferences() throws Exception {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="boundFunctionReference.kt")
                    public void testBoundFunctionReference() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReference.kt");
                    }

                    @Test
                    @TestMetadata(value="boundFunctionReferenceOnInt.kt")
                    public void testBoundFunctionReferenceOnInt() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReferenceOnInt.kt");
                    }

                    @Test
                    @TestMetadata(value="boundFunctionReferenceOnLong.kt")
                    public void testBoundFunctionReferenceOnLong() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReferenceOnLong.kt");
                    }

                    @Test
                    @TestMetadata(value="boundInlineClassMethod.kt")
                    public void testBoundInlineClassMethod() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethod.kt");
                    }

                    @Test
                    @TestMetadata(value="boundInlineClassMethodWithAny.kt")
                    public void testBoundInlineClassMethodWithAny() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethodWithAny.kt");
                    }

                    @Test
                    @TestMetadata(value="boundInlineClassMethodWithInt.kt")
                    public void testBoundInlineClassMethodWithInt() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethodWithInt.kt");
                    }

                    @Test
                    @TestMetadata(value="boundPropertyReference.kt")
                    public void testBoundPropertyReference() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReference.kt");
                    }

                    @Test
                    @TestMetadata(value="boundPropertyReferenceOnInt.kt")
                    public void testBoundPropertyReferenceOnInt() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReferenceOnInt.kt");
                    }

                    @Test
                    @TestMetadata(value="boundPropertyReferenceOnLong.kt")
                    public void testBoundPropertyReferenceOnLong() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReferenceOnLong.kt");
                    }

                    @Test
                    @TestMetadata(value="constuctorReference.kt")
                    public void testConstuctorReference() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/constuctorReference.kt");
                    }

                    @Test
                    @TestMetadata(value="defaultAfterBoundReference.kt")
                    public void testDefaultAfterBoundReference() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/defaultAfterBoundReference.kt");
                    }

                    @Test
                    @TestMetadata(value="differentInvokeSignature.kt")
                    public void testDifferentInvokeSignature() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature.kt");
                    }

                    @Test
                    @TestMetadata(value="differentInvokeSignature2.kt")
                    public void testDifferentInvokeSignature2() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature2.kt");
                    }

                    @Test
                    @TestMetadata(value="differentInvokeSignature3.kt")
                    public void testDifferentInvokeSignature3() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature3.kt");
                    }

                    @Test
                    @TestMetadata(value="functionImportedFromObject.kt")
                    public void testFunctionImportedFromObject() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionImportedFromObject.kt");
                    }

                    @Test
                    @TestMetadata(value="functionReference.kt")
                    public void testFunctionReference() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReference.kt");
                    }

                    @Test
                    @TestMetadata(value="functionReferenceFromClass.kt")
                    public void testFunctionReferenceFromClass() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReferenceFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="functionReferenceFromObject.kt")
                    public void testFunctionReferenceFromObject() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReferenceFromObject.kt");
                    }

                    @Test
                    @TestMetadata(value="innerClassConstuctorReference.kt")
                    public void testInnerClassConstuctorReference() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/innerClassConstuctorReference.kt");
                    }

                    @Test
                    @TestMetadata(value="mutableBoundPropertyReferenceFromClass.kt")
                    public void testMutableBoundPropertyReferenceFromClass() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/mutableBoundPropertyReferenceFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="mutablePropertyReferenceFromClass.kt")
                    public void testMutablePropertyReferenceFromClass() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/mutablePropertyReferenceFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="privateFunctionReference.kt")
                    public void testPrivateFunctionReference() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/privateFunctionReference.kt");
                    }

                    @Test
                    @TestMetadata(value="privatePropertyReference.kt")
                    public void testPrivatePropertyReference() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/privatePropertyReference.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyImportedFromObject.kt")
                    public void testPropertyImportedFromObject() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyImportedFromObject.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyReference.kt")
                    public void testPropertyReference() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReference.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyReferenceFromClass.kt")
                    public void testPropertyReferenceFromClass() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReferenceFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyReferenceFromObject.kt")
                    public void testPropertyReferenceFromObject() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReferenceFromObject.kt");
                    }

                    @Test
                    @TestMetadata(value="withInlineClassParameter.kt")
                    public void testWithInlineClassParameter() throws Exception {
                        JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/withInlineClassParameter.kt");
                    }
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/contracts")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Contracts {
            @Test
            public void testAllFilesPresentInContracts() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/contracts"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="cfgDependendValInitialization.kt")
            public void testCfgDependendValInitialization() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/cfgDependendValInitialization.kt");
            }

            @Test
            @TestMetadata(value="complexInitializer.kt")
            public void testComplexInitializer() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/complexInitializer.kt");
            }

            @Test
            @TestMetadata(value="complexInitializerWithStackTransformation.kt")
            public void testComplexInitializerWithStackTransformation() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/complexInitializerWithStackTransformation.kt");
            }

            @Test
            @TestMetadata(value="crossinlineCallableReference.kt")
            public void testCrossinlineCallableReference() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/crossinlineCallableReference.kt");
            }

            @Test
            @TestMetadata(value="definiteLongValInitialization.kt")
            public void testDefiniteLongValInitialization() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/definiteLongValInitialization.kt");
            }

            @Test
            @TestMetadata(value="definiteNestedValInitialization.kt")
            public void testDefiniteNestedValInitialization() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/definiteNestedValInitialization.kt");
            }

            @Test
            @TestMetadata(value="definiteValInitInInitializer.kt")
            public void testDefiniteValInitInInitializer() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/definiteValInitInInitializer.kt");
            }

            @Test
            @TestMetadata(value="definiteValInitialization.kt")
            public void testDefiniteValInitialization() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/definiteValInitialization.kt");
            }

            @Test
            @TestMetadata(value="exactlyOnceCrossinline.kt")
            public void testExactlyOnceCrossinline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceCrossinline.kt");
            }

            @Test
            @TestMetadata(value="exactlyOnceCrossinline2.kt")
            public void testExactlyOnceCrossinline2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceCrossinline2.kt");
            }

            @Test
            @TestMetadata(value="exactlyOnceNoinline.kt")
            public void testExactlyOnceNoinline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceNoinline.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn.kt")
            public void testNonLocalReturn() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/nonLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturnWithCycle.kt")
            public void testNonLocalReturnWithCycle() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/nonLocalReturnWithCycle.kt");
            }

            @Test
            @TestMetadata(value="propertyInitialization.kt")
            public void testPropertyInitialization() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/propertyInitialization.kt");
            }

            @Test
            @TestMetadata(value="valInitializationAndUsageInNestedLambda.kt")
            public void testValInitializationAndUsageInNestedLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/valInitializationAndUsageInNestedLambda.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/complexStack")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ComplexStack {
            @Test
            public void testAllFilesPresentInComplexStack() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/complexStack"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="asCheck.kt")
            public void testAsCheck() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/asCheck.kt");
            }

            @Test
            @TestMetadata(value="asCheck2.kt")
            public void testAsCheck2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/asCheck2.kt");
            }

            @Test
            @TestMetadata(value="breakContinueInInlineLambdaArgument.kt")
            public void testBreakContinueInInlineLambdaArgument() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/breakContinueInInlineLambdaArgument.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simple.kt");
            }

            @Test
            @TestMetadata(value="simple2.kt")
            public void testSimple2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simple2.kt");
            }

            @Test
            @TestMetadata(value="simple3.kt")
            public void testSimple3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simple3.kt");
            }

            @Test
            @TestMetadata(value="simple4.kt")
            public void testSimple4() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simple4.kt");
            }

            @Test
            @TestMetadata(value="simpleExtension.kt")
            public void testSimpleExtension() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simpleExtension.kt");
            }

            @Test
            @TestMetadata(value="spillConstructorArgumentsAndInlineLambdaParameter.kt")
            public void testSpillConstructorArgumentsAndInlineLambdaParameter() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/spillConstructorArgumentsAndInlineLambdaParameter.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/complex")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Complex {
            @Test
            public void testAllFilesPresentInComplex() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/complex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="closureChain.kt")
            public void testClosureChain() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/closureChain.kt");
            }

            @Test
            @TestMetadata(value="forEachLine.kt")
            public void testForEachLine() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/forEachLine.kt");
            }

            @Test
            @TestMetadata(value="kt44429.kt")
            public void testKt44429() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/kt44429.kt");
            }

            @Test
            @TestMetadata(value="kt44429MustFail.kt")
            public void testKt44429MustFail() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/kt44429MustFail.kt");
            }

            @Test
            @TestMetadata(value="lambdaInLambda.kt")
            public void testLambdaInLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/lambdaInLambda.kt");
            }

            @Test
            @TestMetadata(value="nestedCallsWithGeneric.kt")
            public void testNestedCallsWithGeneric() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/nestedCallsWithGeneric.kt");
            }

            @Test
            @TestMetadata(value="nestedCallsWithGenericToInt.kt")
            public void testNestedCallsWithGenericToInt() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/nestedCallsWithGenericToInt.kt");
            }

            @Test
            @TestMetadata(value="swapAndWith.kt")
            public void testSwapAndWith() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/swapAndWith.kt");
            }

            @Test
            @TestMetadata(value="swapAndWith2.kt")
            public void testSwapAndWith2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/swapAndWith2.kt");
            }

            @Test
            @TestMetadata(value="use.kt")
            public void testUse() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/use.kt");
            }

            @Test
            @TestMetadata(value="with.kt")
            public void testWith() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/with.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/capture")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Capture {
            @Test
            public void testAllFilesPresentInCapture() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/capture"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="captureInlinable.kt")
            public void testCaptureInlinable() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/captureInlinable.kt");
            }

            @Test
            @TestMetadata(value="captureInlinableAndOther.kt")
            public void testCaptureInlinableAndOther() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/captureInlinableAndOther.kt");
            }

            @Test
            @TestMetadata(value="captureThisAndReceiver.kt")
            public void testCaptureThisAndReceiver() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/captureThisAndReceiver.kt");
            }

            @Test
            @TestMetadata(value="generics.kt")
            public void testGenerics() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/generics.kt");
            }

            @Test
            @TestMetadata(value="kt48230.kt")
            public void testKt48230() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt48230.kt");
            }

            @Test
            @TestMetadata(value="kt48230_2.kt")
            public void testKt48230_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt48230_2.kt");
            }

            @Test
            @TestMetadata(value="kt56500.kt")
            public void testKt56500() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt56500.kt");
            }

            @Test
            @TestMetadata(value="kt56965.kt")
            public void testKt56965() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt56965.kt");
            }

            @Test
            @TestMetadata(value="kt56965_2.kt")
            public void testKt56965_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt56965_2.kt");
            }

            @Test
            @TestMetadata(value="simpleCapturingInClass.kt")
            public void testSimpleCapturingInClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/simpleCapturingInClass.kt");
            }

            @Test
            @TestMetadata(value="simpleCapturingInPackage.kt")
            public void testSimpleCapturingInPackage() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/simpleCapturingInPackage.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/callableReference")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CallableReference {
            @Test
            @TestMetadata(value="adapted.kt")
            public void testAdapted() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adapted.kt");
            }

            @Test
            public void testAllFilesPresentInCallableReference() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classLevel.kt")
            public void testClassLevel() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/classLevel.kt");
            }

            @Test
            @TestMetadata(value="classLevel2.kt")
            public void testClassLevel2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/classLevel2.kt");
            }

            @Test
            @TestMetadata(value="constructor.kt")
            public void testConstructor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/constructor.kt");
            }

            @Test
            @TestMetadata(value="inlineCallableReference.kt")
            public void testInlineCallableReference() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/inlineCallableReference.kt");
            }

            @Test
            @TestMetadata(value="innerGenericConstuctor.kt")
            public void testInnerGenericConstuctor() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/innerGenericConstuctor.kt");
            }

            @Test
            @TestMetadata(value="intrinsic.kt")
            public void testIntrinsic() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/intrinsic.kt");
            }

            @Test
            @TestMetadata(value="jvmFieldProperty.kt")
            public void testJvmFieldProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/jvmFieldProperty.kt");
            }

            @Test
            @TestMetadata(value="kt15449.kt")
            public void testKt15449() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/kt15449.kt");
            }

            @Test
            @TestMetadata(value="kt15751_2.kt")
            public void testKt15751_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/kt15751_2.kt");
            }

            @Test
            @TestMetadata(value="kt16411.kt")
            public void testKt16411() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/kt16411.kt");
            }

            @Test
            @TestMetadata(value="kt35101.kt")
            public void testKt35101() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/kt35101.kt");
            }

            @Test
            @TestMetadata(value="propertyIntrinsic.kt")
            public void testPropertyIntrinsic() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/propertyIntrinsic.kt");
            }

            @Test
            @TestMetadata(value="propertyReference.kt")
            public void testPropertyReference() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/propertyReference.kt");
            }

            @Test
            @TestMetadata(value="topLevel.kt")
            public void testTopLevel() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/topLevel.kt");
            }

            @Test
            @TestMetadata(value="topLevelExtension.kt")
            public void testTopLevelExtension() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/topLevelExtension.kt");
            }

            @Test
            @TestMetadata(value="topLevelProperty.kt")
            public void testTopLevelProperty() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/topLevelProperty.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/callableReference/bound")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Bound {
                @Test
                public void testAllFilesPresentInBound() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="classProperty.kt")
                public void testClassProperty() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/classProperty.kt");
                }

                @Test
                @TestMetadata(value="doubleBoundToThis.kt")
                public void testDoubleBoundToThis() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/doubleBoundToThis.kt");
                }

                @Test
                @TestMetadata(value="emptyLhsFunction.kt")
                public void testEmptyLhsFunction() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsFunction.kt");
                }

                @Test
                @TestMetadata(value="emptyLhsOnInlineProperty.kt")
                public void testEmptyLhsOnInlineProperty() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsOnInlineProperty.kt");
                }

                @Test
                @TestMetadata(value="emptyLhsProperty.kt")
                public void testEmptyLhsProperty() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsProperty.kt");
                }

                @Test
                @TestMetadata(value="expression.kt")
                public void testExpression() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/expression.kt");
                }

                @Test
                @TestMetadata(value="extensionReceiver.kt")
                public void testExtensionReceiver() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/extensionReceiver.kt");
                }

                @Test
                @TestMetadata(value="filter.kt")
                public void testFilter() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/filter.kt");
                }

                @Test
                @TestMetadata(value="inlineValueParameterInsteadOfReceiver.kt")
                public void testInlineValueParameterInsteadOfReceiver() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/inlineValueParameterInsteadOfReceiver.kt");
                }

                @Test
                @TestMetadata(value="innerGenericConstuctor.kt")
                public void testInnerGenericConstuctor() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/innerGenericConstuctor.kt");
                }

                @Test
                @TestMetadata(value="intrinsic.kt")
                public void testIntrinsic() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/intrinsic.kt");
                }

                @Test
                @TestMetadata(value="jvmFieldProperty.kt")
                public void testJvmFieldProperty() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/jvmFieldProperty.kt");
                }

                @Test
                @TestMetadata(value="kt18728.kt")
                public void testKt18728() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728.kt");
                }

                @Test
                @TestMetadata(value="kt18728_2.kt")
                public void testKt18728_2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_2.kt");
                }

                @Test
                @TestMetadata(value="kt18728_3.kt")
                public void testKt18728_3() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_3.kt");
                }

                @Test
                @TestMetadata(value="kt18728_4.kt")
                public void testKt18728_4() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_4.kt");
                }

                @Test
                @TestMetadata(value="kt30933.kt")
                public void testKt30933() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt30933.kt");
                }

                @Test
                @TestMetadata(value="lambdaOnLhs.kt")
                public void testLambdaOnLhs() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/lambdaOnLhs.kt");
                }

                @Test
                @TestMetadata(value="map.kt")
                public void testMap() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/map.kt");
                }

                @Test
                @TestMetadata(value="mixed.kt")
                public void testMixed() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/mixed.kt");
                }

                @Test
                @TestMetadata(value="objectProperty.kt")
                public void testObjectProperty() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/objectProperty.kt");
                }

                @Test
                @TestMetadata(value="propertyImportedFromObject.kt")
                public void testPropertyImportedFromObject() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/propertyImportedFromObject.kt");
                }

                @Test
                @TestMetadata(value="sideEffect.kt")
                public void testSideEffect() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/sideEffect.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/simple.kt");
                }

                @Test
                @TestMetadata(value="simpleVal.kt")
                public void testSimpleVal() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/simpleVal.kt");
                }

                @Test
                @TestMetadata(value="simpleVal2.kt")
                public void testSimpleVal2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/simpleVal2.kt");
                }

                @Test
                @TestMetadata(value="topLevelExtensionProperty.kt")
                public void testTopLevelExtensionProperty() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/topLevelExtensionProperty.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/callableReference/adaptedReferences")
            @TestDataPath(value="$PROJECT_ROOT")
            public class AdaptedReferences {
                @Test
                public void testAllFilesPresentInAdaptedReferences() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference/adaptedReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineBound.kt")
                public void testInlineBound() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineBound.kt");
                }

                @Test
                @TestMetadata(value="inlineDefault.kt")
                public void testInlineDefault() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineDefault.kt");
                }

                @Test
                @TestMetadata(value="inlineVararg.kt")
                public void testInlineVararg() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVararg.kt");
                }

                @Test
                @TestMetadata(value="inlineVarargAndDefault.kt")
                public void testInlineVarargAndDefault() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVarargAndDefault.kt");
                }

                @Test
                @TestMetadata(value="inlineVarargInts.kt")
                public void testInlineVarargInts() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVarargInts.kt");
                }

                @Test
                @TestMetadata(value="multipleCallableReferenceUsage.kt")
                public void testMultipleCallableReferenceUsage() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/multipleCallableReferenceUsage.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/bytecodePreprocessing")
        @TestDataPath(value="$PROJECT_ROOT")
        public class BytecodePreprocessing {
            @Test
            public void testAllFilesPresentInBytecodePreprocessing() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/bytecodePreprocessing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="apiVersionAtLeast1.kt")
            public void testApiVersionAtLeast1() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/bytecodePreprocessing/apiVersionAtLeast1.kt");
            }

            @Test
            @TestMetadata(value="inlineApiVersionAtLeastInStdlibInlineFunction.kt")
            public void testInlineApiVersionAtLeastInStdlibInlineFunction() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/bytecodePreprocessing/inlineApiVersionAtLeastInStdlibInlineFunction.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/builders")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Builders {
            @Test
            public void testAllFilesPresentInBuilders() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/builders"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="builders.kt")
            public void testBuilders() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/builders/builders.kt");
            }

            @Test
            @TestMetadata(value="buildersAndLambdaCapturing.kt")
            public void testBuildersAndLambdaCapturing() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/builders/buildersAndLambdaCapturing.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/assert")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Assert {
            @Test
            public void testAllFilesPresentInAssert() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="jvmAssertInlineFunctionAssertionsDisabled.kt")
            public void testJvmAssertInlineFunctionAssertionsDisabled() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineFunctionAssertionsDisabled.kt");
            }

            @Test
            @TestMetadata(value="jvmAssertInlineFunctionAssertionsEnabled.kt")
            public void testJvmAssertInlineFunctionAssertionsEnabled() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineFunctionAssertionsEnabled.kt");
            }

            @Test
            @TestMetadata(value="jvmAssertInlineLambda.kt")
            public void testJvmAssertInlineLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="jvmClassInitializer.kt")
            public void testJvmClassInitializer() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmClassInitializer.kt");
            }

            @Test
            @TestMetadata(value="jvmCompanion.kt")
            public void testJvmCompanion() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCompanion.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineLambda.kt")
            public void testJvmCrossinlineLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambda.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineLambda2.kt")
            public void testJvmCrossinlineLambda2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambda2.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineLambdaDeclarationSite.kt")
            public void testJvmCrossinlineLambdaDeclarationSite() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambdaDeclarationSite.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineLambdaDeclarationSiteOnly.kt")
            public void testJvmCrossinlineLambdaDeclarationSiteOnly() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambdaDeclarationSiteOnly.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineRedundant.kt")
            public void testJvmCrossinlineRedundant() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineRedundant.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineSAMDeclarationSite.kt")
            public void testJvmCrossinlineSAMDeclarationSite() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineSAMDeclarationSite.kt");
            }

            @Test
            @TestMetadata(value="jvmDoubleInline.kt")
            public void testJvmDoubleInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmDoubleInline.kt");
            }

            @Test
            @TestMetadata(value="jvmInlineIntoTwoMethods.kt")
            public void testJvmInlineIntoTwoMethods() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmInlineIntoTwoMethods.kt");
            }

            @Test
            @TestMetadata(value="jvmInlineUsedAsNoinline.kt")
            public void testJvmInlineUsedAsNoinline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmInlineUsedAsNoinline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/arrayConvention")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ArrayConvention {
            @Test
            public void testAllFilesPresentInArrayConvention() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/arrayConvention"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="simpleAccess.kt")
            public void testSimpleAccess() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccess.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessInClass.kt")
            public void testSimpleAccessInClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessInClass.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessWithDefault.kt")
            public void testSimpleAccessWithDefault() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithDefault.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessWithDefaultInClass.kt")
            public void testSimpleAccessWithDefaultInClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithDefaultInClass.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessWithLambda.kt")
            public void testSimpleAccessWithLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithLambda.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessWithLambdaInClass.kt")
            public void testSimpleAccessWithLambdaInClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithLambdaInClass.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/argumentOrder")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ArgumentOrder {
            @Test
            public void testAllFilesPresentInArgumentOrder() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="boundFunctionReference.kt")
            public void testBoundFunctionReference() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/boundFunctionReference.kt");
            }

            @Test
            @TestMetadata(value="boundFunctionReference2.kt")
            public void testBoundFunctionReference2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/boundFunctionReference2.kt");
            }

            @Test
            @TestMetadata(value="captured.kt")
            public void testCaptured() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/captured.kt");
            }

            @Test
            @TestMetadata(value="capturedInExtension.kt")
            public void testCapturedInExtension() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/capturedInExtension.kt");
            }

            @Test
            @TestMetadata(value="defaultParametersAndLastVararg.kt")
            public void testDefaultParametersAndLastVararg() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/defaultParametersAndLastVararg.kt");
            }

            @Test
            @TestMetadata(value="defaultParametersAndLastVarargWithCorrectOrder.kt")
            public void testDefaultParametersAndLastVarargWithCorrectOrder() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/defaultParametersAndLastVarargWithCorrectOrder.kt");
            }

            @Test
            @TestMetadata(value="extension.kt")
            public void testExtension() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/extension.kt");
            }

            @Test
            @TestMetadata(value="extensionInClass.kt")
            public void testExtensionInClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/extensionInClass.kt");
            }

            @Test
            @TestMetadata(value="lambdaMigration.kt")
            public void testLambdaMigration() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/lambdaMigration.kt");
            }

            @Test
            @TestMetadata(value="lambdaMigrationInClass.kt")
            public void testLambdaMigrationInClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/lambdaMigrationInClass.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/simple.kt");
            }

            @Test
            @TestMetadata(value="simpleInClass.kt")
            public void testSimpleInClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/simpleInClass.kt");
            }

            @Test
            @TestMetadata(value="varargAndDefaultParameters.kt")
            public void testVarargAndDefaultParameters() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/varargAndDefaultParameters.kt");
            }

            @Test
            @TestMetadata(value="varargAndDefaultParametersWithCorrectOrder.kt")
            public void testVarargAndDefaultParametersWithCorrectOrder() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/varargAndDefaultParametersWithCorrectOrder.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject")
        @TestDataPath(value="$PROJECT_ROOT")
        public class AnonymousObject {
            @Test
            public void testAllFilesPresentInAnonymousObject() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="anonymousObjectInCallChildren.kt")
            public void testAnonymousObjectInCallChildren() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectInCallChildren.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectInDefault.kt")
            public void testAnonymousObjectInDefault() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectInDefault.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectOnCallSite.kt")
            public void testAnonymousObjectOnCallSite() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnCallSite.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectOnCallSiteSuperParams.kt")
            public void testAnonymousObjectOnCallSiteSuperParams() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnCallSiteSuperParams.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectOnDeclarationSite.kt")
            public void testAnonymousObjectOnDeclarationSite() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnDeclarationSite.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectOnDeclarationSiteSuperParams.kt")
            public void testAnonymousObjectOnDeclarationSiteSuperParams() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnDeclarationSiteSuperParams.kt");
            }

            @Test
            @TestMetadata(value="capturedLambdaInInline.kt")
            public void testCapturedLambdaInInline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline.kt");
            }

            @Test
            @TestMetadata(value="capturedLambdaInInline2.kt")
            public void testCapturedLambdaInInline2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline2.kt");
            }

            @Test
            @TestMetadata(value="capturedLambdaInInline3.kt")
            public void testCapturedLambdaInInline3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline3.kt");
            }

            @Test
            @TestMetadata(value="capturedLambdaInInlineObject.kt")
            public void testCapturedLambdaInInlineObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInlineObject.kt");
            }

            @Test
            @TestMetadata(value="capturedLocalFun.kt")
            public void testCapturedLocalFun() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLocalFun.kt");
            }

            @Test
            @TestMetadata(value="capturedLocalFunRef.kt")
            public void testCapturedLocalFunRef() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLocalFunRef.kt");
            }

            @Test
            @TestMetadata(value="changingReturnType.kt")
            public void testChangingReturnType() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/changingReturnType.kt");
            }

            @Test
            @TestMetadata(value="constructOriginalInRegenerated.kt")
            public void testConstructOriginalInRegenerated() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/constructOriginalInRegenerated.kt");
            }

            @Test
            @TestMetadata(value="constructorVisibility.kt")
            public void testConstructorVisibility() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibility.kt");
            }

            @Test
            @TestMetadata(value="constructorVisibilityInConstLambda.kt")
            public void testConstructorVisibilityInConstLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibilityInConstLambda.kt");
            }

            @Test
            @TestMetadata(value="constructorVisibilityInLambda.kt")
            public void testConstructorVisibilityInLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibilityInLambda.kt");
            }

            @Test
            @TestMetadata(value="defineClass.kt")
            public void testDefineClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/defineClass.kt");
            }

            @Test
            @TestMetadata(value="fakeOverrideInDefaultMultiModule.kt")
            public void testFakeOverrideInDefaultMultiModule() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/fakeOverrideInDefaultMultiModule.kt");
            }

            @Test
            @TestMetadata(value="fakeOverrideMultiModule.kt")
            public void testFakeOverrideMultiModule() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/fakeOverrideMultiModule.kt");
            }

            @Test
            @TestMetadata(value="functionExpression.kt")
            public void testFunctionExpression() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/functionExpression.kt");
            }

            @Test
            @TestMetadata(value="inlineCallInsideInlineLambda.kt")
            public void testInlineCallInsideInlineLambda() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/inlineCallInsideInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="kt13133.kt")
            public void testKt13133() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13133.kt");
            }

            @Test
            @TestMetadata(value="kt13182.kt")
            public void testKt13182() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13182.kt");
            }

            @Test
            @TestMetadata(value="kt13374.kt")
            public void testKt13374() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13374.kt");
            }

            @Test
            @TestMetadata(value="kt14011.kt")
            public void testKt14011() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011.kt");
            }

            @Test
            @TestMetadata(value="kt14011_2.kt")
            public void testKt14011_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011_2.kt");
            }

            @Test
            @TestMetadata(value="kt14011_3.kt")
            public void testKt14011_3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011_3.kt");
            }

            @Test
            @TestMetadata(value="kt15751.kt")
            public void testKt15751() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt15751.kt");
            }

            @Test
            @TestMetadata(value="kt16193.kt")
            public void testKt16193() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt16193.kt");
            }

            @Test
            @TestMetadata(value="kt17972.kt")
            public void testKt17972() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972.kt");
            }

            @Test
            @TestMetadata(value="kt17972_2.kt")
            public void testKt17972_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_2.kt");
            }

            @Test
            @TestMetadata(value="kt17972_3.kt")
            public void testKt17972_3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_3.kt");
            }

            @Test
            @TestMetadata(value="kt17972_4.kt")
            public void testKt17972_4() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_4.kt");
            }

            @Test
            @TestMetadata(value="kt17972_5.kt")
            public void testKt17972_5() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_5.kt");
            }

            @Test
            @TestMetadata(value="kt17972_super.kt")
            public void testKt17972_super() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super.kt");
            }

            @Test
            @TestMetadata(value="kt17972_super2.kt")
            public void testKt17972_super2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super2.kt");
            }

            @Test
            @TestMetadata(value="kt17972_super3.kt")
            public void testKt17972_super3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super3.kt");
            }

            @Test
            @TestMetadata(value="kt19389.kt")
            public void testKt19389() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19389.kt");
            }

            @Test
            @TestMetadata(value="kt19399.kt")
            public void testKt19399() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19399.kt");
            }

            @Test
            @TestMetadata(value="kt19434.kt")
            public void testKt19434() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19434.kt");
            }

            @Test
            @TestMetadata(value="kt19434_2.kt")
            public void testKt19434_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19434_2.kt");
            }

            @Test
            @TestMetadata(value="kt19723.kt")
            public void testKt19723() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19723.kt");
            }

            @Test
            @TestMetadata(value="kt29595.kt")
            public void testKt29595() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt29595.kt");
            }

            @Test
            @TestMetadata(value="kt30696.kt")
            public void testKt30696() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt30696.kt");
            }

            @Test
            @TestMetadata(value="kt34656.kt")
            public void testKt34656() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt34656.kt");
            }

            @Test
            @TestMetadata(value="kt38197.kt")
            public void testKt38197() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt38197.kt");
            }

            @Test
            @TestMetadata(value="kt41174.kt")
            public void testKt41174() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt41174.kt");
            }

            @Test
            @TestMetadata(value="kt42815.kt")
            public void testKt42815() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt42815.kt");
            }

            @Test
            @TestMetadata(value="kt42815_delegated.kt")
            public void testKt42815_delegated() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt42815_delegated.kt");
            }

            @Test
            @TestMetadata(value="kt51950.kt")
            public void testKt51950() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt51950.kt");
            }

            @Test
            @TestMetadata(value="kt52795.kt")
            public void testKt52795() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795.kt");
            }

            @Test
            @TestMetadata(value="kt52795_2.kt")
            public void testKt52795_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_2.kt");
            }

            @Test
            @TestMetadata(value="kt52795_3.kt")
            public void testKt52795_3() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_3.kt");
            }

            @Test
            @TestMetadata(value="kt52795_4.kt")
            public void testKt52795_4() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_4.kt");
            }

            @Test
            @TestMetadata(value="kt52795_5.kt")
            public void testKt52795_5() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_5.kt");
            }

            @Test
            @TestMetadata(value="kt57053.kt")
            public void testKt57053() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt57053.kt");
            }

            @Test
            @TestMetadata(value="kt6007.kt")
            public void testKt6007() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt6007.kt");
            }

            @Test
            @TestMetadata(value="kt6552.kt")
            public void testKt6552() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt6552.kt");
            }

            @Test
            @TestMetadata(value="kt8133.kt")
            public void testKt8133() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt8133.kt");
            }

            @Test
            @TestMetadata(value="kt9064.kt")
            public void testKt9064() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9064.kt");
            }

            @Test
            @TestMetadata(value="kt9064v2.kt")
            public void testKt9064v2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9064v2.kt");
            }

            @Test
            @TestMetadata(value="kt9591.kt")
            public void testKt9591() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9591.kt");
            }

            @Test
            @TestMetadata(value="kt9877.kt")
            public void testKt9877() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9877.kt");
            }

            @Test
            @TestMetadata(value="kt9877_2.kt")
            public void testKt9877_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9877_2.kt");
            }

            @Test
            @TestMetadata(value="objectInLambdaCapturesAnotherObject.kt")
            public void testObjectInLambdaCapturesAnotherObject() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/objectInLambdaCapturesAnotherObject.kt");
            }

            @Test
            @TestMetadata(value="safeCall.kt")
            public void testSafeCall() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/safeCall.kt");
            }

            @Test
            @TestMetadata(value="safeCall_2.kt")
            public void testSafeCall_2() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/safeCall_2.kt");
            }

            @Test
            @TestMetadata(value="sam.kt")
            public void testSam() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam.kt");
            }

            @Test
            @TestMetadata(value="sharedFromCrossinline.kt")
            public void testSharedFromCrossinline() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sharedFromCrossinline.kt");
            }

            @Test
            @TestMetadata(value="superConstructorWithObjectParameter.kt")
            public void testSuperConstructorWithObjectParameter() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/superConstructorWithObjectParameter.kt");
            }

            @Test
            @TestMetadata(value="typeInfo.kt")
            public void testTypeInfo() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/typeInfo.kt");
            }

            @Test
            @TestMetadata(value="withInlineMethod.kt")
            public void testWithInlineMethod() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/withInlineMethod.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers")
            @TestDataPath(value="$PROJECT_ROOT")
            public class TwoCapturedReceivers {
                @Test
                public void testAllFilesPresentInTwoCapturedReceivers() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="kt8668.kt")
                public void testKt8668() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668.kt");
                }

                @Test
                @TestMetadata(value="kt8668_2.kt")
                public void testKt8668_2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_2.kt");
                }

                @Test
                @TestMetadata(value="kt8668_3.kt")
                public void testKt8668_3() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_3.kt");
                }

                @Test
                @TestMetadata(value="kt8668_nested.kt")
                public void testKt8668_nested() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_nested.kt");
                }

                @Test
                @TestMetadata(value="kt8668_nested_2.kt")
                public void testKt8668_nested_2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_nested_2.kt");
                }

                @Test
                @TestMetadata(value="twoDifferentDispatchReceivers.kt")
                public void testTwoDifferentDispatchReceivers() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/twoDifferentDispatchReceivers.kt");
                }

                @Test
                @TestMetadata(value="twoExtensionReceivers.kt")
                public void testTwoExtensionReceivers() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/twoExtensionReceivers.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/sam")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Sam {
                @Test
                public void testAllFilesPresentInSam() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="anonymousObjectToSam.kt")
                public void testAnonymousObjectToSam() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/anonymousObjectToSam.kt");
                }

                @Test
                @TestMetadata(value="kt17091.kt")
                public void testKt17091() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt17091.kt");
                }

                @Test
                @TestMetadata(value="kt21671.kt")
                public void testKt21671() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671.kt");
                }

                @Test
                @TestMetadata(value="kt21671_2.kt")
                public void testKt21671_2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671_2.kt");
                }

                @Test
                @TestMetadata(value="kt21671_3.kt")
                public void testKt21671_3() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671_3.kt");
                }

                @Test
                @TestMetadata(value="kt22304.kt")
                public void testKt22304() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt22304.kt");
                }

                @Test
                @TestMetadata(value="samOnCallSite.kt")
                public void testSamOnCallSite() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/samOnCallSite.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ProperRecapturingInClass {
                @Test
                public void testAllFilesPresentInProperRecapturingInClass() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineChain.kt")
                public void testInlineChain() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/inlineChain.kt");
                }

                @Test
                @TestMetadata(value="inlinelambdaChain.kt")
                public void testInlinelambdaChain() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/inlinelambdaChain.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain.kt")
                public void testLambdaChain() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain.kt");
                }

                @Test
                @TestMetadata(value="lambdaChainSimple.kt")
                public void testLambdaChainSimple() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChainSimple.kt");
                }

                @Test
                @TestMetadata(value="lambdaChainSimple_2.kt")
                public void testLambdaChainSimple_2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChainSimple_2.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain_2.kt")
                public void testLambdaChain_2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain_2.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain_3.kt")
                public void testLambdaChain_3() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain_3.kt");
                }

                @Test
                @TestMetadata(value="noCapturedThisOnCallSite.kt")
                public void testNoCapturedThisOnCallSite() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/noCapturedThisOnCallSite.kt");
                }

                @Test
                @TestMetadata(value="noInlineLambda.kt")
                public void testNoInlineLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/noInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="twoInlineLambda.kt")
                public void testTwoInlineLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="twoInlineLambdaComplex.kt")
                public void testTwoInlineLambdaComplex() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambdaComplex.kt");
                }

                @Test
                @TestMetadata(value="twoInlineLambdaComplex_2.kt")
                public void testTwoInlineLambdaComplex_2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambdaComplex_2.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/properRecapturing")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ProperRecapturing {
                @Test
                public void testAllFilesPresentInProperRecapturing() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineChain.kt")
                public void testInlineChain() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/inlineChain.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain.kt")
                public void testLambdaChain() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain.kt");
                }

                @Test
                @TestMetadata(value="lambdaChainSimple.kt")
                public void testLambdaChainSimple() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChainSimple.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain_2.kt")
                public void testLambdaChain_2() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain_2.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain_3.kt")
                public void testLambdaChain_3() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain_3.kt");
                }

                @Test
                @TestMetadata(value="noInlineLambda.kt")
                public void testNoInlineLambda() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/noInlineLambda.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/enumWhen")
            @TestDataPath(value="$PROJECT_ROOT")
            public class EnumWhen {
                @Test
                public void testAllFilesPresentInEnumWhen() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/enumWhen"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="callSite.kt")
                public void testCallSite() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/callSite.kt");
                }

                @Test
                @TestMetadata(value="declSite.kt")
                public void testDeclSite() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSite.kt");
                }

                @Test
                @TestMetadata(value="declSiteSeveralMappings.kt")
                public void testDeclSiteSeveralMappings() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSiteSeveralMappings.kt");
                }

                @Test
                @TestMetadata(value="declSiteSeveralMappingsDifOrder.kt")
                public void testDeclSiteSeveralMappingsDifOrder() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSiteSeveralMappingsDifOrder.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/enumEntries")
            @TestDataPath(value="$PROJECT_ROOT")
            public class EnumEntries {
                @Test
                public void testAllFilesPresentInEnumEntries() throws Exception {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/enumEntries"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="callSite.kt")
                public void testCallSite() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/callSite.kt");
                }

                @Test
                @TestMetadata(value="declSite.kt")
                public void testDeclSite() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/declSite.kt");
                }

                @Test
                @TestMetadata(value="declSiteSeveralMappings.kt")
                public void testDeclSiteSeveralMappings() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/declSiteSeveralMappings.kt");
                }

                @Test
                @TestMetadata(value="declSiteSeveralMappingsDifOrder.kt")
                public void testDeclSiteSeveralMappingsDifOrder() throws Exception {
                    JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/declSiteSeveralMappingsDifOrder.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/annotations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Annotations {
            @Test
            public void testAllFilesPresentInAnnotations() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="annotationInstanceInlining.kt")
            public void testAnnotationInstanceInlining() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/annotations/annotationInstanceInlining.kt");
            }

            @Test
            @TestMetadata(value="instanceInAnonymousClass.kt")
            public void testInstanceInAnonymousClass() throws Exception {
                JvmAbiConsistencyTestRestGenerated.this.runTest("compiler/testData/codegen/boxInline/annotations/instanceInAnonymousClass.kt");
            }
        }
    }
}

