/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.WasmTarget;
import org.jetbrains.kotlin.library.metadata.resolver.KotlinResolvedLibrary;
import org.jetbrains.kotlin.test.frontend.fir.SessionFactoryHelpersKt;
import org.jetbrains.kotlin.test.model.DependencyRelation;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.WasmEnvironmentConfigurator;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f\u001aB\u0010\r\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00010\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0010"}, d2={"resolveWasmLibraries", "", "Lorg/jetbrains/kotlin/library/metadata/resolver/KotlinResolvedLibrary;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getAllWasmDependenciesPaths", "", "target", "Lorg/jetbrains/kotlin/js/config/WasmTarget;", "getWasmDependencies", "Lkotlin/Triple;", "Ljava/io/File;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nTestFirWasmSessionFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestFirWasmSessionFactory.kt\norg/jetbrains/kotlin/test/frontend/fir/TestFirWasmSessionFactoryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1547#2:108\n1618#2,3:109\n*S KotlinDebug\n*F\n+ 1 TestFirWasmSessionFactory.kt\norg/jetbrains/kotlin/test/frontend/fir/TestFirWasmSessionFactoryKt\n*L\n95#1:108\n95#1:109,3\n*E\n"})
public final class TestFirWasmSessionFactoryKt {
    @NotNull
    public static final List<KotlinResolvedLibrary> resolveWasmLibraries(@NotNull TestModule module, @NotNull TestServices testServices, @NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Object object = configuration2.get(JSConfigurationKeys.WASM_TARGET, (Object)WasmTarget.JS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        List<String> paths = TestFirWasmSessionFactoryKt.getAllWasmDependenciesPaths(module, testServices, (WasmTarget)object);
        return SessionFactoryHelpersKt.resolveLibraries(configuration2, paths);
    }

    @NotNull
    public static final List<String> getAllWasmDependenciesPaths(@NotNull TestModule module, @NotNull TestServices testServices, @NotNull WasmTarget target) {
        File it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Triple<List<String>, List<File>, List<File>> triple = TestFirWasmSessionFactoryKt.getWasmDependencies(module, testServices, target);
        List runtimeKlibsPaths = (List)triple.component1();
        List transitiveLibraries = (List)triple.component2();
        List friendLibraries = (List)triple.component3();
        Iterable iterable = transitiveLibraries;
        Collection collection2 = runtimeKlibsPaths;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        $this$map$iv = friendLibraries;
        collection2 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final Triple<List<String>, List<File>, List<File>> getWasmDependencies(@NotNull TestModule module, @NotNull TestServices testServices, @NotNull WasmTarget target) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        List<String> runtimeKlibsPaths = WasmEnvironmentConfigurator.Companion.getRuntimePathsForModule(target);
        List<File> transitiveLibraries = WasmEnvironmentConfigurator.Companion.getKlibDependencies(module, testServices, DependencyRelation.RegularDependency);
        List<File> friendLibraries = WasmEnvironmentConfigurator.Companion.getKlibDependencies(module, testServices, DependencyRelation.FriendDependency);
        return new Triple(runtimeKlibsPaths, transitiveLibraries, friendLibraries);
    }
}

