/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.fir.SequentialPositionFinder;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.codeMetaInfo.model.CodeMetaInfo;
import org.jetbrains.kotlin.codeMetaInfo.model.DiagnosticCodeMetaInfo;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.RootDiagnosticRendererFactory;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.FirParser;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirDiagnosticCodeMetaInfo;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirDiagnosticsHandlerKt;
import org.jetbrains.kotlin.test.model.BinaryArtifactHandler;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"reportKtDiagnostics", "", "Lorg/jetbrains/kotlin/test/model/BinaryArtifactHandler;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "ktDiagnosticReporter", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "checkFullDiagnosticRender", "renderDiagnosticMessage", "", "fileName", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "message", "line", "", "column", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nHandlerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HandlerUtils.kt\norg/jetbrains/kotlin/test/backend/handlers/HandlerUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1043#2:91\n1853#2,2:92\n*S KotlinDebug\n*F\n+ 1 HandlerUtils.kt\norg/jetbrains/kotlin/test/backend/handlers/HandlerUtilsKt\n*L\n62#1:91\n41#1:92,2\n*E\n"})
public final class HandlerUtilsKt {
    public static final void reportKtDiagnostics(@NotNull BinaryArtifactHandler<?> $this$reportKtDiagnostics, @NotNull TestModule module, @NotNull BaseDiagnosticsCollector ktDiagnosticReporter) {
        Intrinsics.checkNotNullParameter($this$reportKtDiagnostics, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)ktDiagnosticReporter, (String)"ktDiagnosticReporter");
        GlobalMetadataInfoHandler globalMetadataInfoHandler = GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler($this$reportKtDiagnostics.getTestServices());
        FirParser firParser = DirectiveKt.singleOrZeroValue(module.getDirectives(), FirDiagnosticsDirectives.INSTANCE.getFIR_PARSER());
        boolean lightTreeComparingModeEnabled = firParser != null && module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getCOMPARE_WITH_LIGHT_TREE());
        boolean lightTreeEnabled = firParser == FirParser.LightTree;
        Set processedModules = new LinkedHashSet();
        HandlerUtilsKt.reportKtDiagnostics$processModule(processedModules, ktDiagnosticReporter, $this$reportKtDiagnostics, globalMetadataInfoHandler, lightTreeEnabled, lightTreeComparingModeEnabled, module);
    }

    public static final void checkFullDiagnosticRender(@NotNull BinaryArtifactHandler<?> $this$checkFullDiagnosticRender, @NotNull TestModule module) {
        Intrinsics.checkNotNullParameter($this$checkFullDiagnosticRender, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!module.getDirectives().contains(DiagnosticsDirectives.INSTANCE.getRENDER_ALL_DIAGNOSTICS_FULL_TEXT())) {
            return;
        }
        List reportedDiagnostics = new ArrayList();
        for (TestFile testFile : module.getFiles()) {
            Iterator iterator = SourceFileProviderKt.getSourceFileProvider($this$checkFullDiagnosticRender.getTestServices()).getContentOfSourceFile(testFile);
            Charset charset = Charsets.UTF_8;
            byte[] byArray = ((String)((Object)iterator)).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            iterator = new ByteArrayInputStream(byArray);
            charset = Charsets.UTF_8;
            SequentialPositionFinder finder = new SequentialPositionFinder(new InputStreamReader((InputStream)((Object)iterator), charset));
            Iterable $this$sortedBy$iv = GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler($this$checkFullDiagnosticRender.getTestServices()).getReportedMetaInfosForFile(testFile);
            boolean $i$f$sortedBy = false;
            for (CodeMetaInfo metaInfo : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CodeMetaInfo it = (CodeMetaInfo)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getStart());
                    it = (CodeMetaInfo)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
                }
            })) {
                String message;
                PsiDiagnosticUtils.LineAndColumn position;
                Diagnostic it;
                CodeMetaInfo codeMetaInfo = metaInfo;
                if (codeMetaInfo instanceof DiagnosticCodeMetaInfo) {
                    it = ((DiagnosticCodeMetaInfo)metaInfo).getDiagnostic();
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)it)), (String)"render(...)");
                    position = DiagnosticUtils.getLineAndColumnRange((PsiFile)it.getPsiFile(), (List)it.getTextRanges()).getStart();
                    Collection collection = reportedDiagnostics;
                    String string = it.getPsiFile().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String string2 = HandlerUtilsKt.renderDiagnosticMessage(string, it.getSeverity(), message, position.getLine(), position.getColumn());
                    collection.add(string2);
                    continue;
                }
                if (!(codeMetaInfo instanceof FirDiagnosticCodeMetaInfo)) continue;
                it = ((FirDiagnosticCodeMetaInfo)metaInfo).getDiagnostic();
                boolean bl = false;
                message = RootDiagnosticRendererFactory.INSTANCE.invoke((KtDiagnostic)it).render((KtDiagnostic)it);
                position = finder.findNextPosition(DiagnosticUtils.firstRange((List)it.getTextRanges()).getStartOffset(), false);
                ((Collection)reportedDiagnostics).add(HandlerUtilsKt.renderDiagnosticMessage(testFile.getRelativePath(), it.getSeverity(), message, position.getLine(), position.getColumn()));
            }
        }
        Assertions.assertEqualsToFile$default((Assertions)AssertionsKt.getAssertions($this$checkFullDiagnosticRender.getTestServices()), new File(FileUtil.getNameWithoutExtension((String)((TestFile)CollectionsKt.first(module.getFiles())).getOriginalFile().getAbsolutePath()) + ".diag.txt"), CollectionsKt.joinToString$default((Iterable)reportedDiagnostics, (CharSequence)"\n\n", null, (CharSequence)"\n", (int)0, null, null, (int)58, null), null, 4, null);
    }

    private static final String renderDiagnosticMessage(String fileName, Severity severity, String message, int line, int column) {
        String severityString = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)AnalyzerWithCompilerReport.Companion.convertSeverity(severity).toString());
        return '/' + fileName + ':' + line + ':' + column + ": " + severityString + ": " + message;
    }

    private static final void reportKtDiagnostics$processModule(Set<TestModule> processedModules, BaseDiagnosticsCollector $ktDiagnosticReporter, BinaryArtifactHandler<?> $this_reportKtDiagnostics, GlobalMetadataInfoHandler globalMetadataInfoHandler, boolean lightTreeEnabled, boolean lightTreeComparingModeEnabled, TestModule module) {
        if (!processedModules.add(module)) {
            return;
        }
        for (TestFile testFile : module.getFiles()) {
            List ktDiagnostics;
            if ((List)$ktDiagnosticReporter.getDiagnosticsByFilePath().get('/' + testFile.getName()) == null) continue;
            Iterable $this$forEach$iv = ktDiagnostics;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtDiagnostic it = (KtDiagnostic)element$iv;
                boolean bl = false;
                List metaInfos = FirDiagnosticsHandlerKt.toMetaInfos$default(it, module, testFile, globalMetadataInfoHandler, lightTreeEnabled, lightTreeComparingModeEnabled, false, 32, null);
                globalMetadataInfoHandler.addMetadataInfosForFile(testFile, metaInfos);
            }
        }
        Iterator<Object> iterator = module.getDependsOnDependencies().iterator();
        while (iterator.hasNext()) {
            String moduleName = ((DependencyDescription)iterator.next()).component1();
            TestModule dependantModule = DependencyProviderKt.getDependencyProvider($this_reportKtDiagnostics.getTestServices()).getTestModule(moduleName);
            HandlerUtilsKt.reportKtDiagnostics$processModule(processedModules, $ktDiagnosticReporter, $this_reportKtDiagnostics, globalMetadataInfoHandler, lightTreeEnabled, lightTreeComparingModeEnabled, dependantModule);
        }
    }
}

