/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.KotlinStandardLibrariesPathProviderKt;
import org.jetbrains.kotlin.test.services.RuntimeClasspathProvider;
import org.jetbrains.kotlin.test.services.RuntimeClasspathProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.JvmEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManager;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManagerKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"generatedTestClassLoader", "Lorg/jetbrains/kotlin/codegen/GeneratedClassLoader;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "classFileFactory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "computeTestRuntimeClasspath", "", "Ljava/io/File;", "rootModule", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nJvmBoxRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmBoxRunner.kt\norg/jetbrains/kotlin/test/backend/handlers/JvmBoxRunnerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,356:1\n1547#2:357\n1618#2,3:358\n1444#2,5:363\n37#3,2:361\n*S KotlinDebug\n*F\n+ 1 JvmBoxRunner.kt\norg/jetbrains/kotlin/test/backend/handlers/JvmBoxRunnerKt\n*L\n330#1:357\n330#1:358,3\n353#1:363,5\n330#1:361,2\n*E\n"})
public final class JvmBoxRunnerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GeneratedClassLoader generatedTestClassLoader(@NotNull TestServices testServices, @NotNull TestModule module, @NotNull ClassFileFactory classFileFactory) {
        void $this$toTypedArray$iv;
        Collection<URL> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)classFileFactory, (String)"classFileFactory");
        CompilerConfiguration configuration2 = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(testServices).getCompilerConfiguration(module);
        ConfigurationKind configurationKind = (ConfigurationKind)((Object)configuration2.get(JvmEnvironmentConfigurator.Companion.getTEST_CONFIGURATION_KIND_KEY()));
        ClassLoader parentClassLoader = (configurationKind != null ? configurationKind.getWithReflection() : false) ? KotlinStandardLibrariesPathProviderKt.getStandardLibrariesPathProvider(testServices).getRuntimeAndReflectJarClassLoader() : KotlinStandardLibrariesPathProviderKt.getStandardLibrariesPathProvider(testServices).getRuntimeJarClassLoader();
        List<File> classpath = JvmBoxRunnerKt.computeTestRuntimeClasspath(testServices, module);
        Iterable iterable = classpath;
        ClassLoader classLoader = parentClassLoader;
        ClassFileFactory classFileFactory2 = classFileFactory;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toURI().toURL());
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        URL[] uRLArray2 = Arrays.copyOf(uRLArray, uRLArray.length);
        ClassLoader classLoader2 = classLoader;
        ClassFileFactory classFileFactory3 = classFileFactory2;
        return new GeneratedClassLoader(classFileFactory3, classLoader2, uRLArray2);
    }

    private static final List<File> computeTestRuntimeClasspath(TestServices testServices, TestModule rootModule) {
        Set visited = new LinkedHashSet();
        List result = new ArrayList();
        JvmBoxRunnerKt.computeTestRuntimeClasspath$computeClasspath(visited, result, testServices, rootModule, true);
        Iterable $this$flatMapTo$iv = RuntimeClasspathProviderKt.getRuntimeClasspathProviders(testServices);
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            RuntimeClasspathProvider it = (RuntimeClasspathProvider)element$iv;
            boolean bl = false;
            Iterable list$iv = it.runtimeClassPaths(rootModule);
            kotlin.collections.CollectionsKt.addAll((Collection)result, (Iterable)list$iv);
        }
        return result;
    }

    private static final void computeTestRuntimeClasspath$computeClasspath(Set<TestModule> visited, List<File> result, TestServices $testServices, TestModule module, boolean isRoot) {
        if (!visited.add(module)) {
            return;
        }
        if (!isRoot) {
            result.add(CompiledClassesManager.getCompiledKotlinDirForModule$default(CompiledClassesManagerKt.getCompiledClassesManager($testServices), module, null, 2, null));
        }
        CollectionsKt.addIfNotNull((Collection)result, (Object)CompiledClassesManagerKt.getCompiledClassesManager($testServices).getCompiledJavaDirForModule(module));
        for (DependencyDescription dependency : module.getAllDependencies()) {
            if (dependency.getKind() != DependencyKind.Binary) continue;
            JvmBoxRunnerKt.computeTestRuntimeClasspath$computeClasspath(visited, result, $testServices, DependencyProviderKt.getDependencyProvider($testServices).getTestModule(dependency.getModuleName()), false);
        }
    }
}

