/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.common.CommonPlatformAnalyzerServices;
import org.jetbrains.kotlin.js.resolve.JsPlatformAnalyzerServices;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.WasmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;
import org.jetbrains.kotlin.resolve.konan.platform.NativePlatformAnalyzerServices;
import org.jetbrains.kotlin.wasm.resolve.WasmPlatformAnalyzerServices;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\u0007"}, d2={"initIdeaConfiguration", "", "computeHomeDirectory", "", "getAnalyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "tests-common-new_test"})
public final class TestSetupUtilsKt {
    public static final void initIdeaConfiguration() {
        System.setProperty("idea.home", TestSetupUtilsKt.computeHomeDirectory());
        System.setProperty("idea.ignore.disabled.plugins", "true");
    }

    private static final String computeHomeDirectory() {
        String userDir = System.getProperty("user.dir");
        String string = userDir;
        if (string == null) {
            string = ".";
        }
        String string2 = new File(string).getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
        return string2;
    }

    @NotNull
    public static final PlatformDependentAnalyzerServices getAnalyzerServices(@NotNull TargetPlatform $this$getAnalyzerServices) {
        PlatformDependentAnalyzerServices platformDependentAnalyzerServices;
        Intrinsics.checkNotNullParameter((Object)$this$getAnalyzerServices, (String)"<this>");
        if (JvmPlatformKt.isJvm((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)JvmPlatformAnalyzerServices.INSTANCE;
        } else if (JsPlatformKt.isJs((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)JsPlatformAnalyzerServices.INSTANCE;
        } else if (NativePlatformKt.isNative((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)NativePlatformAnalyzerServices.INSTANCE;
        } else if (TargetPlatformKt.isCommon((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)CommonPlatformAnalyzerServices.INSTANCE;
        } else if (WasmPlatformKt.isWasm((TargetPlatform)$this$getAnalyzerServices)) {
            platformDependentAnalyzerServices = (PlatformDependentAnalyzerServices)WasmPlatformAnalyzerServices.INSTANCE;
        } else {
            throw new IllegalStateException(("Unknown target platform: " + $this$getAnalyzerServices).toString());
        }
        return platformDependentAnalyzerServices;
    }
}

