/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.util.Arrays;
import java.util.Locale;

public final class AppMainV2 {
    public static final String LAUNCHER_PORT_NUMBER = "idea.launcher.port";
    public static final String LAUNCHER_BIN_PATH = "idea.launcher.bin.path";

    private static native void triggerControlBreak();

    private static boolean loadHelper(String binPath) {
        String arch;
        File libFile;
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (osName.startsWith("windows") && (libFile = new File(binPath, "x86_64".equals(arch = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH)) || "amd64".equals(arch) ? "breakgen64.dll" : "breakgen.dll")).isFile()) {
            System.load(libFile.getAbsolutePath());
            return true;
        }
        return false;
    }

    private static void startMonitor(final int portNumber, final boolean helperLibLoaded) {
        Thread t = new Thread("Monitor Ctrl-Break"){

            @Override
            public void run() {
                try {
                    Socket client = new Socket("127.0.0.1", portNumber);
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream(), "US-ASCII"));
                        try {
                            while (true) {
                                String msg;
                                if ((msg = reader.readLine()) == null || "TERM".equals(msg)) {
                                    return;
                                }
                                if ("BREAK".equals(msg)) {
                                    if (!helperLibLoaded) continue;
                                    AppMainV2.triggerControlBreak();
                                    continue;
                                }
                                if (!"STOP".equals(msg)) continue;
                                System.exit(1);
                            }
                        }
                        finally {
                            reader.close();
                        }
                    }
                    finally {
                        client.close();
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public static void main(String[] args) throws Throwable {
        Method m;
        try {
            boolean helperLibLoaded = AppMainV2.loadHelper(System.getProperty(LAUNCHER_BIN_PATH));
            int portNumber = Integer.parseInt(System.getProperty(LAUNCHER_PORT_NUMBER));
            AppMainV2.startMonitor(portNumber, helperLibLoaded);
        }
        catch (Throwable t) {
            System.err.println("Launcher failed - \"Dump Threads\" and \"Exit\" actions are unavailable (" + t.getMessage() + ')');
        }
        String mainClass = args[0];
        String[] params = Arrays.copyOfRange(args, 1, args.length);
        Class<?> appClass = Class.forName(mainClass);
        try {
            m = appClass.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            if (!AppMainV2.startJavaFXApplication(params, appClass)) {
                throw e;
            }
            return;
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            System.err.println("main method should be static");
            return;
        }
        if (!Void.TYPE.isAssignableFrom(m.getReturnType())) {
            System.err.println("main method must return a value of type void");
            return;
        }
        try {
            m.setAccessible(true);
            m.invoke(null, new Object[]{params});
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private static boolean startJavaFXApplication(String[] params, Class<?> appClass) {
        try {
            Method launchApplication = Class.forName("com.sun.javafx.application.LauncherImpl").getMethod("launchApplication", Class.class, String[].class);
            launchApplication.invoke(null, appClass, params);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void premain(String args) {
        try {
            int p = args.indexOf(58);
            if (p < 0) {
                throw new IllegalArgumentException("incorrect parameter: " + args);
            }
            boolean helperLibLoaded = AppMainV2.loadHelper(args.substring(p + 1));
            int portNumber = Integer.parseInt(args.substring(0, p));
            AppMainV2.startMonitor(portNumber, helperLibLoaded);
        }
        catch (Throwable t) {
            System.err.println("Launcher failed - \"Dump Threads\" and \"Exit\" actions are unavailable (" + t.getMessage() + ')');
        }
    }

    public static final class Agent {
        public static void premain(String args, Instrumentation i) {
            AppMainV2.premain(args);
        }
    }
}

