/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.AbstractKtDiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryForDeprecation;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryToRendererMap;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters1Renderer;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters2Renderer;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters3Renderer;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters4Renderer;
import org.junit.Assert;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\u001a\u001e\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u001a\u0012\u0010\t\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"messageParameterRegex", "Lkotlin/text/Regex;", "verifyMessageForFactory", "", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactoryToRendererMap;", "factory", "Lorg/jetbrains/kotlin/diagnostics/AbstractKtDiagnosticFactory;", "property", "Lkotlin/reflect/KProperty;", "verifyMessages", "objectWithErrors", "", "tests-common-new_test"})
public final class FirErrorsDefaultMessagesHelperKt {
    @NotNull
    private static final Regex messageParameterRegex = new Regex("\\{\\d.*?}");

    public static final void verifyMessages(@NotNull KtDiagnosticFactoryToRendererMap $this$verifyMessages, @NotNull Object objectWithErrors) {
        Intrinsics.checkNotNullParameter((Object)$this$verifyMessages, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)objectWithErrors, (String)"objectWithErrors");
        for (KProperty1 property : KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(objectWithErrors.getClass()))) {
            Object[] objectArray = new Object[]{objectWithErrors};
            Object factory = property.getGetter().call(objectArray);
            if (factory instanceof AbstractKtDiagnosticFactory) {
                FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory($this$verifyMessages, (AbstractKtDiagnosticFactory)factory, (KProperty)property);
                continue;
            }
            if (!(factory instanceof KtDiagnosticFactoryForDeprecation)) continue;
            FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory($this$verifyMessages, ((KtDiagnosticFactoryForDeprecation)factory).getWarningFactory(), (KProperty)property);
            FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory($this$verifyMessages, ((KtDiagnosticFactoryForDeprecation)factory).getErrorFactory(), (KProperty)property);
        }
    }

    public static final void verifyMessageForFactory(@NotNull KtDiagnosticFactoryToRendererMap $this$verifyMessageForFactory, @NotNull AbstractKtDiagnosticFactory factory, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter((Object)$this$verifyMessageForFactory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Assert.assertTrue((String)("No default diagnostic renderer is provided for " + property.getName()), (boolean)$this$verifyMessageForFactory.containsKey(factory));
        KtDiagnosticRenderer ktDiagnosticRenderer = $this$verifyMessageForFactory.get(factory);
        Intrinsics.checkNotNull((Object)ktDiagnosticRenderer);
        KtDiagnosticRenderer renderer = ktDiagnosticRenderer;
        KtDiagnosticRenderer ktDiagnosticRenderer2 = renderer;
        int parameterCount = ktDiagnosticRenderer2 instanceof KtDiagnosticWithParameters4Renderer ? 4 : (ktDiagnosticRenderer2 instanceof KtDiagnosticWithParameters3Renderer ? 3 : (ktDiagnosticRenderer2 instanceof KtDiagnosticWithParameters2Renderer ? 2 : (ktDiagnosticRenderer2 instanceof KtDiagnosticWithParameters1Renderer ? 1 : 0)));
        for (MatchResult parameter : Regex.findAll$default((Regex)messageParameterRegex, (CharSequence)renderer.getMessage(), (int)0, (int)2, null)) {
            String string = parameter.getValue().substring(1, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            int index = Integer.parseInt(string);
            Assert.assertTrue((String)("Message for " + property.getName() + " references wrong parameter {" + index + '}'), (index < parameterCount ? 1 : 0) != 0);
        }
    }
}

