/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compiler.plugin.CompilerPluginRegistrar;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AbstractEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.DirectiveToConfigurationKeyExtractor;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u0015\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e*\u00020\u0010J\f\u0010 \u001a\u00020\f*\u00020!H\u0016J\u001c\u0010\"\u001a\u00020\f*\u00020#2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/AbstractEnvironmentConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "moduleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "getModuleStructure", "()Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "configureCompileConfigurationWithAdditionalConfigurationKeys", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "configureCompilerConfiguration", "legacyRegisterCompilerExtensions", "project", "Lcom/intellij/openapi/project/Project;", "provideAdditionalAnalysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "directives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "allTransitiveDependencies", "", "Lorg/jetbrains/kotlin/test/model/DependencyDescription;", "provideConfigurationKeys", "Lorg/jetbrains/kotlin/test/services/DirectiveToConfigurationKeyExtractor;", "registerCompilerExtensions", "Lorg/jetbrains/kotlin/compiler/plugin/CompilerPluginRegistrar$ExtensionStorage;", "test-infrastructure_test"})
@SourceDebugExtension(value={"SMAP\nAbstractEnvironmentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/EnvironmentConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1360#2:111\n1446#2,2:112\n618#2,12:114\n1448#2,3:126\n*S KotlinDebug\n*F\n+ 1 AbstractEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/EnvironmentConfigurator\n*L\n58#1:111\n58#1:112,2\n58#1:114,12\n58#1:126,3\n*E\n"})
public abstract class EnvironmentConfigurator
extends AbstractEnvironmentConfigurator {
    @NotNull
    private final TestServices testServices;

    public EnvironmentConfigurator(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
    }

    @NotNull
    protected final TestServices getTestServices() {
        return this.testServices;
    }

    @NotNull
    protected final TestModuleStructure getModuleStructure() {
        return TestModuleStructureKt.getModuleStructure(this.testServices);
    }

    protected void configureCompilerConfiguration(@NotNull CompilerConfiguration configuration2, @NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
    }

    @Override
    public final void configureCompileConfigurationWithAdditionalConfigurationKeys(@NotNull CompilerConfiguration configuration2, @NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        DirectiveToConfigurationKeyExtractor extractor = new DirectiveToConfigurationKeyExtractor();
        this.provideConfigurationKeys(extractor);
        extractor.configure(configuration2, module.getDirectives());
        this.configureCompilerConfiguration(configuration2, module);
    }

    public void provideConfigurationKeys(@NotNull DirectiveToConfigurationKeyExtractor $this$provideConfigurationKeys) {
        Intrinsics.checkNotNullParameter((Object)$this$provideConfigurationKeys, (String)"<this>");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<DependencyDescription> allTransitiveDependencies(@NotNull TestModule $this$allTransitiveDependencies) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)$this$allTransitiveDependencies, (String)"<this>");
        List<TestModule> modules = TestModuleStructureKt.getModuleStructure(this.testServices).getModules();
        Iterable iterable = $this$allTransitiveDependencies.getRegularDependencies();
        Set set = CollectionsKt.toSet((Iterable)$this$allTransitiveDependencies.getRegularDependencies());
        boolean $i$f$flatMap = false;
        void var5_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$single$iv;
            DependencyDescription it = (DependencyDescription)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = modules;
            EnvironmentConfigurator environmentConfigurator = this;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                TestModule module = (TestModule)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)module.getName(), (Object)it.getModuleName())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Iterable list$iv$iv = environmentConfigurator.allTransitiveDependencies(single$iv);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return SetsKt.plus((Set)set, (Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public Map<AnalysisFlag<?>, Object> provideAdditionalAnalysisFlags(@NotNull RegisteredDirectives directives2, @NotNull LanguageVersion languageVersion) {
        Intrinsics.checkNotNullParameter((Object)directives2, (String)"directives");
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        return MapsKt.emptyMap();
    }

    @Override
    public void legacyRegisterCompilerExtensions(@NotNull Project project, @NotNull TestModule module, @NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
    }

    @Override
    public void registerCompilerExtensions(@NotNull CompilerPluginRegistrar.ExtensionStorage $this$registerCompilerExtensions, @NotNull TestModule module, @NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)$this$registerCompilerExtensions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
    }
}

