/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporterFactory;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.AbstractFirAnalyzerFacade;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.pipeline.AnalyseKt;
import org.jetbrains.kotlin.fir.pipeline.FirResult;
import org.jetbrains.kotlin.fir.pipeline.FirUtilsKt;
import org.jetbrains.kotlin.fir.pipeline.ModuleCompilerAnalyzedOutput;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.FirParser;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\b\u0010&\u001a\u00020'H\u0002J\u001a\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0011H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120\u0013H\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/FirAnalyzerFacade;", "Lorg/jetbrains/kotlin/fir/AbstractFirAnalyzerFacade;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "lightTreeFiles", "Lorg/jetbrains/kotlin/KtSourceFile;", "parser", "Lorg/jetbrains/kotlin/test/FirParser;", "diagnosticReporterForLightTree", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/Collection;Ljava/util/Collection;Lorg/jetbrains/kotlin/test/FirParser;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "_scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "collectedDiagnostics", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "getDiagnosticReporterForLightTree", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "firFiles", "getKtFiles", "()Ljava/util/Collection;", "getLightTreeFiles", "getParser", "()Lorg/jetbrains/kotlin/test/FirParser;", "result", "Lorg/jetbrains/kotlin/fir/pipeline/FirResult;", "getResult", "()Lorg/jetbrains/kotlin/fir/pipeline/FirResult;", "scopeSession", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "buildRawFir", "", "runCheckers", "runResolution", "tests-compiler-utils_test"})
public final class FirAnalyzerFacade
extends AbstractFirAnalyzerFacade {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Collection<KtFile> ktFiles;
    @NotNull
    private final Collection<KtSourceFile> lightTreeFiles;
    @NotNull
    private final FirParser parser;
    @Nullable
    private final DiagnosticReporter diagnosticReporterForLightTree;
    @Nullable
    private List<? extends FirFile> firFiles;
    @Nullable
    private ScopeSession _scopeSession;
    @Nullable
    private Map<FirFile, ? extends List<? extends KtDiagnostic>> collectedDiagnostics;

    public FirAnalyzerFacade(@NotNull FirSession session, @NotNull Collection<? extends KtFile> ktFiles, @NotNull Collection<? extends KtSourceFile> lightTreeFiles, @NotNull FirParser parser2, @Nullable DiagnosticReporter diagnosticReporterForLightTree) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        Intrinsics.checkNotNullParameter(lightTreeFiles, (String)"lightTreeFiles");
        Intrinsics.checkNotNullParameter((Object)((Object)parser2), (String)"parser");
        this.session = session;
        this.ktFiles = ktFiles;
        this.lightTreeFiles = lightTreeFiles;
        this.parser = parser2;
        this.diagnosticReporterForLightTree = diagnosticReporterForLightTree;
    }

    public /* synthetic */ FirAnalyzerFacade(FirSession firSession, Collection collection, Collection collection2, FirParser firParser, DiagnosticReporter diagnosticReporter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            collection2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            diagnosticReporter = null;
        }
        this(firSession, collection, collection2, firParser, diagnosticReporter);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final Collection<KtFile> getKtFiles() {
        return this.ktFiles;
    }

    @NotNull
    public final Collection<KtSourceFile> getLightTreeFiles() {
        return this.lightTreeFiles;
    }

    @NotNull
    public final FirParser getParser() {
        return this.parser;
    }

    @Nullable
    public final DiagnosticReporter getDiagnosticReporterForLightTree() {
        return this.diagnosticReporterForLightTree;
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        ScopeSession scopeSession = this._scopeSession;
        Intrinsics.checkNotNull((Object)scopeSession);
        return scopeSession;
    }

    @Override
    @NotNull
    public FirResult getResult() {
        ScopeSession scopeSession = this.getScopeSession();
        List<? extends FirFile> list = this.firFiles;
        Intrinsics.checkNotNull(list);
        return new FirResult(CollectionsKt.listOf((Object)new ModuleCompilerAnalyzedOutput(this.session, scopeSession, list)));
    }

    private final void buildRawFir() {
        List list;
        if (this.firFiles != null) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.parser.ordinal()]) {
            case 1: {
                list = FirUtilsKt.buildFirViaLightTree$default((FirSession)this.session, this.lightTreeFiles, (DiagnosticReporter)this.diagnosticReporterForLightTree, null, (int)4, null);
                break;
            }
            case 2: {
                list = FirUtilsKt.buildFirFromKtFiles((FirSession)this.session, this.ktFiles);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.firFiles = list;
    }

    @Override
    @NotNull
    public List<FirFile> runResolution() {
        if (this.firFiles == null) {
            this.buildRawFir();
        }
        if (this._scopeSession != null) {
            List<FirFile> list = this.firFiles;
            Intrinsics.checkNotNull(list);
            return list;
        }
        List<? extends FirFile> list = this.firFiles;
        Intrinsics.checkNotNull(list);
        this._scopeSession = (ScopeSession)AnalyseKt.runResolution((FirSession)this.session, list).getFirst();
        List<FirFile> list2 = this.firFiles;
        Intrinsics.checkNotNull(list2);
        return list2;
    }

    @Override
    @NotNull
    public Map<FirFile, List<KtDiagnostic>> runCheckers() {
        if (this._scopeSession == null) {
            this.runResolution();
        }
        if (this.collectedDiagnostics != null) {
            Map<FirFile, List<KtDiagnostic>> map = this.collectedDiagnostics;
            Intrinsics.checkNotNull(map);
            return map;
        }
        ScopeSession scopeSession = this.getScopeSession();
        List<? extends FirFile> list = this.firFiles;
        Intrinsics.checkNotNull(list);
        this.collectedDiagnostics = AnalyseKt.runCheckers((FirSession)this.session, (ScopeSession)scopeSession, list, (BaseDiagnosticsCollector)((BaseDiagnosticsCollector)DiagnosticReporterFactory.createPendingReporter$default((DiagnosticReporterFactory)DiagnosticReporterFactory.INSTANCE, null, (int)1, null)));
        Map<FirFile, List<KtDiagnostic>> map = this.collectedDiagnostics;
        Intrinsics.checkNotNull(map);
        return map;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirParser.values().length];
            try {
                nArray[FirParser.LightTree.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirParser.Psi.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

