/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.model.TestModule;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\n\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u000b\u001a\u00020\u0003J\u0012\u0010\n\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u0012*\u00060\u0007j\u0002`\bH\u0002R2\u0010\u0005\u001a&\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006j\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\u0007j\u0002`\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "", "moduleHeaderTemplate", "", "(Ljava/lang/String;)V", "builderByModule", "Ljava/util/LinkedHashMap;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lkotlin/collections/LinkedHashMap;", "builderForModule", "moduleName", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "generateResultingDump", "isEmpty", "", "addNewLineIfNeeded", "", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nMultiModuleInfoDumper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiModuleInfoDumper.kt\norg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n372#2,7:46\n1#3:53\n*S KotlinDebug\n*F\n+ 1 MultiModuleInfoDumper.kt\norg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper\n*L\n17#1:46,7\n*E\n"})
public final class MultiModuleInfoDumper {
    @Nullable
    private final String moduleHeaderTemplate;
    @NotNull
    private final LinkedHashMap<String, StringBuilder> builderByModule;

    public MultiModuleInfoDumper(@Nullable String moduleHeaderTemplate) {
        this.moduleHeaderTemplate = moduleHeaderTemplate;
        this.builderByModule = new LinkedHashMap();
    }

    public /* synthetic */ MultiModuleInfoDumper(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "Module: %s";
        }
        this(string);
    }

    @NotNull
    public final StringBuilder builderForModule(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.builderForModule(module.getName());
    }

    @NotNull
    public final StringBuilder builderForModule(@NotNull String moduleName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Map $this$getOrPut$iv = this.builderByModule;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(moduleName);
        if (value$iv == null) {
            boolean bl = false;
            StringBuilder answer$iv = new StringBuilder();
            $this$getOrPut$iv.put(moduleName, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (StringBuilder)object;
    }

    @NotNull
    public final String generateResultingDump() {
        Collection<StringBuilder> collection = this.builderByModule.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        StringBuilder stringBuilder = (StringBuilder)CollectionsKt.singleOrNull((Iterable)collection);
        if (stringBuilder != null) {
            StringBuilder it = stringBuilder;
            boolean bl = false;
            this.addNewLineIfNeeded(it);
            String string = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        StringBuilder $this$generateResultingDump_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Map.Entry entry : ((Map)this.builderByModule).entrySet()) {
            StringBuilder stringBuilder2;
            String moduleName = (String)entry.getKey();
            StringBuilder builder = (StringBuilder)entry.getValue();
            if (this.moduleHeaderTemplate != null) {
                String string;
                String it;
                boolean bl2 = false;
                StringBuilder stringBuilder3 = $this$generateResultingDump_u24lambda_u242;
                Object[] objectArray = new Object[]{moduleName};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(it, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
                StringBuilder stringBuilder4 = stringBuilder3.append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                StringBuilder stringBuilder5 = stringBuilder4.append('\n');
                stringBuilder2 = stringBuilder5;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            } else {
                stringBuilder2 = null;
            }
            $this$generateResultingDump_u24lambda_u242.append((CharSequence)builder);
        }
        this.addNewLineIfNeeded($this$generateResultingDump_u24lambda_u242);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean isEmpty() {
        return this.builderByModule.isEmpty();
    }

    private final void addNewLineIfNeeded(StringBuilder $this$addNewLineIfNeeded) {
        if (((CharSequence)$this$addNewLineIfNeeded).length() == 0) {
            return;
        }
        if (StringsKt.last((CharSequence)$this$addNewLineIfNeeded) != '\n') {
            Intrinsics.checkNotNullExpressionValue((Object)$this$addNewLineIfNeeded.append('\n'), (String)"append(...)");
        }
    }

    public MultiModuleInfoDumper() {
        this(null, 1, null);
    }
}

