/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.backend.handlers.PhasedIrDumpHandler;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/PhasedIrDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nPhasedIrDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhasedIrDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/PhasedIrDumpHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,47:1\n3792#2:48\n4307#2,2:49\n3792#2:51\n4307#2,2:52\n*S KotlinDebug\n*F\n+ 1 PhasedIrDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/PhasedIrDumpHandler\n*L\n20#1:48\n20#1:49,2\n33#1:51\n33#1:52,2\n*E\n"})
public final class PhasedIrDumpHandler
extends JvmBinaryArtifactHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DUMPED_IR_FOLDER_NAME = "dumped_ir";
    @NotNull
    private static final String AFTER_PREFIX = "AFTER";
    @NotNull
    private static final String BEFORE_PREFIX = "BEFORE";

    public PhasedIrDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.Jvm info) {
        Collection destination$iv$iv;
        int n;
        int n2;
        Collection destination$iv$iv2;
        File[] fileArray;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_IR_FOR_GIVEN_PHASES())) {
            return;
        }
        File dumpDirectory = TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.getTestServices(), DUMPED_IR_FOLDER_NAME);
        File[] fileArray2 = FilesKt.resolve((File)dumpDirectory, (String)module.getName()).listFiles();
        if (fileArray2 != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray2;
            boolean $i$f$filter = false;
            fileArray = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            n2 = ((void)$this$filterTo$iv$iv).length;
            for (n = 0; n < n2; ++n) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[n];
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)AFTER_PREFIX, (boolean)false, (int)2, null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
        } else {
            return;
        }
        List dumpFiles = (List)destination$iv$iv2;
        TestFile testFile = (TestFile)CollectionsKt.first(module.getFiles());
        File testDirectory = testFile.getOriginalFile().getParentFile();
        List visitedFiles = new ArrayList();
        for (File actualFile : dumpFiles) {
            String $i$f$filterTo;
            StringBuilder stringBuilder = new StringBuilder().append(FilesKt.getNameWithoutExtension((File)testFile.getOriginalFile()));
            Intrinsics.checkNotNullExpressionValue((Object)actualFile.getName(), (String)"getName(...)");
            n = 0;
            n2 = 2;
            String expectedFileName = stringBuilder.append(((Object)StringsKt.removeRange((CharSequence)$i$f$filterTo, (int)n, (int)n2)).toString()).toString();
            ((Collection)visitedFiles).add(expectedFileName);
            Assertions assertions = this.getAssertions();
            Intrinsics.checkNotNull((Object)testDirectory);
            File file = FilesKt.resolve((File)testDirectory, (String)expectedFileName);
            Intrinsics.checkNotNull((Object)actualFile);
            Assertions.assertEqualsToFile$default(assertions, file, FilesKt.readText$default((File)actualFile, null, (int)1, null), null, 4, null);
        }
        fileArray = testDirectory.listFiles((arg_0, arg_1) -> PhasedIrDumpHandler.processModule$lambda$1(testFile, arg_0, arg_1));
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            File[] $i$f$filterTo = fileArray;
            boolean $i$f$filter = false;
            void var13_14 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            int n3 = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n3; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!(!visitedFiles.contains(it.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } else {
            return;
        }
        List remainFiles = (List)destination$iv$iv;
        this.getAssertions().assertTrue(remainFiles.isEmpty(), (Function0<String>)((Function0)new Function0<String>((List<? extends File>)remainFiles){
            final /* synthetic */ List<File> $remainFiles;
            {
                this.$remainFiles = $remainFiles;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "There are some files in test directory (" + CollectionsKt.joinToString$default((Iterable)this.$remainFiles, null, null, null, (int)0, null, (Function1)processModule.1.INSTANCE, (int)31, null) + ") that don't have actual dump";
            }
        }));
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }

    private static final boolean processModule$lambda$1(TestFile $testFile, File file, String name2) {
        Intrinsics.checkNotNullParameter((Object)$testFile, (String)"$testFile");
        Intrinsics.checkNotNull((Object)name2);
        return StringsKt.startsWith$default((String)name2, (String)(FilesKt.getNameWithoutExtension((File)$testFile.getOriginalFile()) + '_'), (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/PhasedIrDumpHandler$Companion;", "", "()V", "AFTER_PREFIX", "", "getAFTER_PREFIX", "()Ljava/lang/String;", "BEFORE_PREFIX", "getBEFORE_PREFIX", "DUMPED_IR_FOLDER_NAME", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getAFTER_PREFIX() {
            return AFTER_PREFIX;
        }

        @NotNull
        public final String getBEFORE_PREFIX() {
            return BEFORE_PREFIX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

