/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.js.config.WasmTarget;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.test.directives.JsEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.WasmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.frontend.classic.ModuleDescriptorProviderKt;
import org.jetbrains.kotlin.test.model.ArtifactKinds;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.DependencyRelation;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.DirectiveToConfigurationKeyExtractor;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.LibraryProvider;
import org.jetbrains.kotlin.test.services.LibraryProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.JsEnvironmentConfigurator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J*\u0010\u0010\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u000b*\u00020\u0019H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/WasmEnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "configureCompilerConfiguration", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "provideAdditionalAnalysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "directives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "provideConfigurationKeys", "Lorg/jetbrains/kotlin/test/services/DirectiveToConfigurationKeyExtractor;", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nWasmEnvironmentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/WasmEnvironmentConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1549#2:185\n1620#2,3:186\n*S KotlinDebug\n*F\n+ 1 WasmEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/WasmEnvironmentConfigurator\n*L\n171#1:185\n171#1:186,3\n*E\n"})
public abstract class WasmEnvironmentConfigurator
extends EnvironmentConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String OUTPUT_KLIB_DIR_NAME = "outputKlibDir";

    public WasmEnvironmentConfigurator(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)WasmEnvironmentConfigurationDirectives.INSTANCE);
    }

    @Override
    @NotNull
    public Map<AnalysisFlag<?>, Object> provideAdditionalAnalysisFlags(@NotNull RegisteredDirectives directives2, @NotNull LanguageVersion languageVersion) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)directives2, (String)"directives");
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        Map it = map = MapsKt.toMutableMap(super.provideAdditionalAnalysisFlags(directives2, languageVersion));
        boolean bl = false;
        it.put(AnalysisFlags.getAllowFullyQualifiedNameInKClass(), false);
        return map;
    }

    @Override
    public void provideConfigurationKeys(@NotNull DirectiveToConfigurationKeyExtractor $this$provideConfigurationKeys) {
        Intrinsics.checkNotNullParameter((Object)$this$provideConfigurationKeys, (String)"<this>");
        SimpleDirective simpleDirective = JsEnvironmentConfigurationDirectives.INSTANCE.getPROPERTY_LAZY_INITIALIZATION();
        CompilerConfigurationKey compilerConfigurationKey = JSConfigurationKeys.PROPERTY_LAZY_INITIALIZATION;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey, (String)"PROPERTY_LAZY_INITIALIZATION");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective, compilerConfigurationKey, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureCompilerConfiguration(@NotNull CompilerConfiguration configuration2, @NotNull TestModule module) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        RegisteredDirectives registeredDirectives = module.getDirectives();
        configuration2.put(JSConfigurationKeys.MODULE_KIND, (Object)ModuleKind.ES);
        configuration2.put(CommonConfigurationKeys.MODULE_NAME, (Object)module.getName());
        configuration2.put(JSConfigurationKeys.WASM_ENABLE_ASSERTS, (Object)true);
        configuration2.put(JSConfigurationKeys.WASM_ENABLE_ARRAY_RANGE_CHECKS, (Object)true);
        Iterable $this$map$iv = module.getFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TestFile testFile = (TestFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOriginalFile().getParent());
        }
        List sourceDirs = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        configuration2.put(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, (Object)sourceDirs);
        configuration2.put(JSConfigurationKeys.SOURCE_MAP, (Object)true);
        SourceMapSourceEmbedding sourceMapSourceEmbedding = (SourceMapSourceEmbedding)CollectionsKt.singleOrNull(registeredDirectives.get(JsEnvironmentConfigurationDirectives.INSTANCE.getSOURCE_MAP_EMBED_SOURCES()));
        if (sourceMapSourceEmbedding == null) {
            sourceMapSourceEmbedding = SourceMapSourceEmbedding.NEVER;
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding2 = sourceMapSourceEmbedding;
        configuration2.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, (Object)sourceMapSourceEmbedding2);
        configuration2.put(CommonConfigurationKeys.EXPECT_ACTUAL_LINKER, (Object)registeredDirectives.contains(JsEnvironmentConfigurationDirectives.INSTANCE.getEXPECT_ACTUAL_LINKER()));
        configuration2.put(JSConfigurationKeys.WASM_USE_TRAPS_INSTEAD_OF_EXCEPTIONS, (Object)registeredDirectives.contains(WasmEnvironmentConfigurationDirectives.INSTANCE.getDISABLE_WASM_EXCEPTION_HANDLING()));
        configuration2.put(JSConfigurationKeys.WASM_TARGET, (Object)WasmTarget.JS);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/WasmEnvironmentConfigurator$Companion;", "", "()V", "OUTPUT_KLIB_DIR_NAME", "", "getAllDependenciesMappingFor", "", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "getAllRecursiveDependenciesFor", "", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "getAllRecursiveLibrariesFor", "getDependencies", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "kind", "Lorg/jetbrains/kotlin/test/model/DependencyRelation;", "getKlibDependencies", "Ljava/io/File;", "getMainModule", "getRuntimePathsForModule", "target", "Lorg/jetbrains/kotlin/js/config/WasmTarget;", "getWasmKlibArtifactPath", "moduleName", "getWasmKlibOutputDir", "isMainModule", "", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nWasmEnvironmentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/WasmEnvironmentConfigurator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,184:1\n1549#2:185\n1620#2,3:186\n1549#2:189\n1620#2,3:190\n1194#2,2:193\n1222#2,4:195\n1271#2,2:203\n1285#2,2:205\n766#2:207\n857#2,2:208\n1549#2:210\n1620#2,3:211\n1288#2:214\n661#2,11:215\n766#2:226\n857#2,2:227\n1549#2:229\n1620#2,3:230\n1855#2,2:233\n1855#2,2:235\n125#3:199\n152#3,3:200\n*S KotlinDebug\n*F\n+ 1 WasmEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/WasmEnvironmentConfigurator$Companion\n*L\n84#1:185\n84#1:186,3\n89#1:189\n89#1:190,3\n121#1:193,2\n121#1:195,4\n129#1:203,2\n129#1:205,2\n131#1:207\n131#1:208,2\n131#1:210\n131#1:211,3\n129#1:214\n140#1:215,11\n75#1:226\n75#1:227,2\n76#1:229\n76#1:230,3\n76#1:233,2\n107#1:235,2\n127#1:199\n127#1:200,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getRuntimePathsForModule(@NotNull WasmTarget target) {
            String string;
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
                case 1: {
                    string = "-js";
                    break;
                }
                case 2: {
                    string = "-wasi";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected wasi target".toString());
                }
            }
            String suffix = string;
            Object[] objectArray = new String[2];
            Intrinsics.checkNotNull((Object)System.getProperty("kotlin.wasm" + suffix + ".stdlib.path"));
            Intrinsics.checkNotNull((Object)System.getProperty("kotlin.wasm" + suffix + ".kotlin.test.path"));
            return CollectionsKt.listOf((Object[])objectArray);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<File> getKlibDependencies(@NotNull TestModule module, @NotNull TestServices testServices, @NotNull DependencyRelation kind) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Set visited = new LinkedHashSet();
            org.jetbrains.kotlin.test.services.configuration.WasmEnvironmentConfigurator$Companion.getKlibDependencies$getRecursive(testServices, visited, module, kind);
            Iterable $this$map$iv = visited;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TestModule testModule = (TestModule)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((BinaryArtifacts.KLib)DependencyProviderKt.getDependencyProvider(testServices).getArtifact((TestModule)it, ArtifactKinds.KLib.INSTANCE)).getOutputFile());
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ModuleDescriptor> getDependencies(@NotNull TestModule module, @NotNull TestServices testServices, @NotNull DependencyRelation kind) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Iterable iterable = this.getKlibDependencies(module, testServices, kind);
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                LibraryProvider libraryProvider = LibraryProviderKt.getLibraryProvider(testServices);
                String string = it.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                collection.add(libraryProvider.getDescriptorByPath(string));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final String getWasmKlibArtifactPath(@NotNull TestServices testServices, @NotNull String moduleName) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            return this.getWasmKlibOutputDir(testServices).getAbsolutePath() + File.separator + JsEnvironmentConfigurator.Companion.getJsArtifactSimpleName(testServices, moduleName);
        }

        @NotNull
        public final File getWasmKlibOutputDir(@NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            return TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(testServices).getOrCreateTempDirectory(WasmEnvironmentConfigurator.OUTPUT_KLIB_DIR_NAME);
        }

        @NotNull
        public final Set<ModuleDescriptorImpl> getAllRecursiveDependenciesFor(@NotNull TestModule module, @NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Set visited = new LinkedHashSet();
            org.jetbrains.kotlin.test.services.configuration.WasmEnvironmentConfigurator$Companion.getAllRecursiveDependenciesFor$getRecursive$6(visited, ModuleDescriptorProviderKt.getModuleDescriptorProvider(testServices).getModuleDescriptor(module));
            return visited;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<KotlinLibrary, ModuleDescriptorImpl> getAllRecursiveLibrariesFor(@NotNull TestModule module, @NotNull TestServices testServices) {
            void $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Set<ModuleDescriptorImpl> dependencies = this.getAllRecursiveDependenciesFor(module, testServices);
            Iterable $this$associateBy$iv = dependencies;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                ModuleDescriptorImpl moduleDescriptorImpl = (ModuleDescriptorImpl)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(LibraryProviderKt.getLibraryProvider(testServices).getCompiledLibraryByDescriptor((ModuleDescriptor)it), element$iv$iv);
            }
            return destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<KotlinLibrary, List<KotlinLibrary>> getAllDependenciesMappingFor(@NotNull TestModule module, @NotNull TestServices testServices) {
            KotlinLibrary it;
            Object object;
            void $this$mapTo$iv$iv;
            Map<KotlinLibrary, ModuleDescriptorImpl> allRecursiveLibraries;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Map<KotlinLibrary, ModuleDescriptorImpl> $this$map$iv = allRecursiveLibraries = this.getAllRecursiveLibrariesFor(module, testServices);
            boolean $i$f$map = false;
            Map<KotlinLibrary, ModuleDescriptorImpl> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                object = destination$iv$iv;
                boolean bl = false;
                object.add(TuplesKt.to(it.getValue(), it.getKey()));
            }
            Map m2l = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            Iterable $this$associateWith$iv = allRecursiveLibraries.keySet();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Map.Entry element$iv$iv : $this$associateWithTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                ModuleDescriptor it2;
                void $this$filterTo$iv$iv;
                ModuleDescriptor descriptor;
                void m;
                it = (KotlinLibrary)element$iv$iv;
                Map.Entry entry = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                if ((ModuleDescriptor)allRecursiveLibraries.get(m) == null) {
                    throw new IllegalStateException(("No descriptor found for library " + m.getLibraryName()).toString());
                }
                Iterable $this$filter$iv = descriptor.getAllDependencyModules();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    it2 = (ModuleDescriptor)element$iv$iv2;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it2, (Object)descriptor))) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$map2 = false;
                $this$filterTo$iv$iv = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it2 = (ModuleDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add((KotlinLibrary)MapsKt.getValue((Map)m2l, (Object)it2));
                }
                List list = (List)destination$iv$iv2;
                object.put(entry, list);
            }
            return result$iv;
        }

        @NotNull
        public final TestModule getMainModule(@NotNull TestServices testServices) {
            TestModule testModule;
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            List<TestModule> modules = TestModuleStructureKt.getModuleStructure(testServices).getModules();
            boolean inferMainModule = TestModuleStructureKt.getModuleStructure(testServices).getAllDirectives().contains(JsEnvironmentConfigurationDirectives.INSTANCE.getINFER_MAIN_MODULE());
            if (inferMainModule) {
                testModule = (TestModule)CollectionsKt.last(modules);
            } else {
                Object v1;
                block5: {
                    Iterable $this$singleOrNull$iv = modules;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        TestModule it = (TestModule)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"main")) continue;
                        if (found$iv) {
                            v1 = null;
                            break block5;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                if ((testModule = (TestModule)v1) == null) {
                    testModule = (TestModule)CollectionsKt.last(modules);
                }
            }
            return testModule;
        }

        public final boolean isMainModule(@NotNull TestModule module, @NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            return Intrinsics.areEqual((Object)module, (Object)this.getMainModule(testServices));
        }

        /*
         * WARNING - void declaration
         */
        private static final void getKlibDependencies$getRecursive(TestServices $testServices, Set<TestModule> visited, TestModule module, DependencyRelation relation) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            DependencyDescription it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            List<DependencyDescription> dependencies = relation == DependencyRelation.FriendDependency ? module.getFriendDependencies() : module.getRegularDependencies();
            Iterable iterable = dependencies;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (DependencyDescription)element$iv$iv;
                boolean bl = false;
                if (!(it.getKind() != DependencyKind.Source)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (DependencyDescription)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DependencyProviderKt.getDependencyProvider($testServices).getTestModule(it.getModuleName()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TestModule it2 = (TestModule)element$iv;
                boolean bl = false;
                if (visited.contains(it2)) continue;
                ((Collection)visited).add(it2);
                org.jetbrains.kotlin.test.services.configuration.WasmEnvironmentConfigurator$Companion.getKlibDependencies$getRecursive($testServices, visited, it2, relation);
            }
        }

        private static final void getAllRecursiveDependenciesFor$getRecursive$6(Set<ModuleDescriptorImpl> visited, ModuleDescriptor descriptor) {
            Iterable $this$forEach$iv = descriptor.getAllDependencyModules();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModuleDescriptor it = (ModuleDescriptor)element$iv;
                boolean bl = false;
                if (!(it instanceof ModuleDescriptorImpl) || visited.contains(it)) continue;
                ((Collection)visited).add(it);
                org.jetbrains.kotlin.test.services.configuration.WasmEnvironmentConfigurator$Companion.getAllRecursiveDependenciesFor$getRecursive$6(visited, it);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[WasmTarget.values().length];
                try {
                    nArray[WasmTarget.JS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WasmTarget.WASI.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

