/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.utils.DiagnosticsRenderingConfiguration;
import org.jetbrains.kotlin.cli.common.fir.SequentialPositionFinder;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.codeMetaInfo.model.CodeMetaInfo;
import org.jetbrains.kotlin.codeMetaInfo.model.DiagnosticCodeMetaInfo;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.KtDefaultJvmErrorMessages;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.FirParser;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicDiagnosticReporter;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicDiagnosticReporterKt;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirDiagnosticCodeMetaInfo;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirDiagnosticsHandlerKt;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.junit.jupiter.api.AssertionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J2\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/JvmBackendDiagnosticsHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "reporter", "Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicDiagnosticReporter;", "checkFullDiagnosticRender", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "processAfterAllModules", "someAssertionWasFailed", "", "processModule", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "renderDiagnosticMessage", "", "fileName", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "message", "line", "", "column", "reportDiagnostics", "reportKtDiagnostics", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nJvmBackendDiagnosticsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmBackendDiagnosticsHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/JvmBackendDiagnosticsHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1194#2,2:122\n1222#2,4:124\n1045#2:128\n1855#2,2:129\n*S KotlinDebug\n*F\n+ 1 JvmBackendDiagnosticsHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/JvmBackendDiagnosticsHandler\n*L\n46#1:122,2\n46#1:124,4\n92#1:128\n71#1:129,2\n*E\n"})
public final class JvmBackendDiagnosticsHandler
extends JvmBinaryArtifactHandler {
    @NotNull
    private final ClassicDiagnosticReporter reporter;

    public JvmBackendDiagnosticsHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, 2, null);
        this.reporter = new ClassicDiagnosticReporter(testServices);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.Jvm info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.reportDiagnostics(module, info);
        this.reportKtDiagnostics(module, info);
        this.checkFullDiagnosticRender(module);
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }

    /*
     * WARNING - void declaration
     */
    private final void reportDiagnostics(TestModule module, BinaryArtifacts.Jvm info) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = module.getFiles();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            TestFile testFile = (TestFile)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put('/' + it.getName(), element$iv$iv);
        }
        Map testFiles = destination$iv$iv;
        DiagnosticsRenderingConfiguration configuration2 = this.reporter.createConfiguration(module);
        boolean withNewInferenceModeEnabled = ClassicDiagnosticReporterKt.withNewInferenceModeEnabled(this.getTestServices());
        Collection diagnostics = info.getClassFileFactory().getGenerationState().getCollectedExtraJvmDiagnostics().all();
        for (Diagnostic diagnostic : diagnostics) {
            TestFile testFile;
            PsiFile psiFile = diagnostic.getPsiFile();
            KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
            if (ktFile == null) {
                AssertionsKt.fail$default((String)("PSI file is not a KtFile: " + diagnostic.getPsiFile()), null, (int)2, null);
                throw null;
            }
            KtFile ktFile2 = ktFile;
            if ((TestFile)testFiles.get(ktFile2.getVirtualFilePath()) == null) {
                AssertionsKt.fail$default((String)("Test file for KtFile not found: " + ktFile2.getVirtualFilePath()), null, (int)2, null);
                throw null;
            }
            this.reporter.reportDiagnostic(diagnostic, module, testFile, configuration2, withNewInferenceModeEnabled);
        }
    }

    private final void reportKtDiagnostics(TestModule module, BinaryArtifacts.Jvm info) {
        DiagnosticReporter diagnosticReporter = info.getClassFileFactory().getGenerationState().getDiagnosticReporter();
        Intrinsics.checkNotNull((Object)diagnosticReporter, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector");
        BaseDiagnosticsCollector ktDiagnosticReporter = (BaseDiagnosticsCollector)diagnosticReporter;
        GlobalMetadataInfoHandler globalMetadataInfoHandler = GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler(this.getTestServices());
        FirParser firParser = DirectiveKt.singleOrZeroValue(module.getDirectives(), FirDiagnosticsDirectives.INSTANCE.getFIR_PARSER());
        boolean lightTreeComparingModeEnabled = firParser != null && module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getCOMPARE_WITH_LIGHT_TREE());
        boolean lightTreeEnabled = firParser == FirParser.LightTree;
        Set processedModules = new LinkedHashSet();
        JvmBackendDiagnosticsHandler.reportKtDiagnostics$processModule(processedModules, ktDiagnosticReporter, this, globalMetadataInfoHandler, lightTreeEnabled, lightTreeComparingModeEnabled, module);
    }

    private final void checkFullDiagnosticRender(TestModule module) {
        if (!module.getDirectives().contains(DiagnosticsDirectives.INSTANCE.getRENDER_ALL_DIAGNOSTICS_FULL_TEXT())) {
            return;
        }
        List reportedDiagnostics = new ArrayList();
        for (TestFile testFile : module.getFiles()) {
            Iterator iterator = SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getContentOfSourceFile(testFile);
            Charset charset = Charsets.UTF_8;
            byte[] byArray = ((String)((Object)iterator)).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            iterator = new ByteArrayInputStream(byArray);
            charset = Charsets.UTF_8;
            SequentialPositionFinder finder = new SequentialPositionFinder(new InputStreamReader((InputStream)((Object)iterator), charset));
            Iterable $this$sortedBy$iv = GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler(this.getTestServices()).getReportedMetaInfosForFile(testFile);
            boolean $i$f$sortedBy = false;
            for (CodeMetaInfo metaInfo : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CodeMetaInfo it = (CodeMetaInfo)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getStart());
                    it = (CodeMetaInfo)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
                }
            })) {
                String message;
                PsiDiagnosticUtils.LineAndColumn position;
                Diagnostic it;
                CodeMetaInfo codeMetaInfo = metaInfo;
                if (codeMetaInfo instanceof DiagnosticCodeMetaInfo) {
                    it = ((DiagnosticCodeMetaInfo)metaInfo).getDiagnostic();
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)it)), (String)"render(...)");
                    position = DiagnosticUtils.getLineAndColumnRange((PsiFile)it.getPsiFile(), (List)it.getTextRanges()).getStart();
                    Collection collection = reportedDiagnostics;
                    String string = it.getPsiFile().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String string2 = this.renderDiagnosticMessage(string, it.getSeverity(), message, position.getLine(), position.getColumn());
                    collection.add(string2);
                    continue;
                }
                if (!(codeMetaInfo instanceof FirDiagnosticCodeMetaInfo)) continue;
                it = ((FirDiagnosticCodeMetaInfo)metaInfo).getDiagnostic();
                boolean bl = false;
                KtDiagnosticRenderer ktDiagnosticRenderer = KtDefaultJvmErrorMessages.INSTANCE.getMAP().get(it.getFactory());
                message = ktDiagnosticRenderer != null ? ktDiagnosticRenderer.render((KtDiagnostic)it) : null;
                position = finder.findNextPosition(DiagnosticUtils.firstRange((List)it.getTextRanges()).getStartOffset(), false);
                ((Collection)reportedDiagnostics).add(this.renderDiagnosticMessage(testFile.getRelativePath(), it.getSeverity(), message, position.getLine(), position.getColumn()));
            }
        }
        Assertions.assertEqualsToFile$default((Assertions)org.jetbrains.kotlin.test.services.AssertionsKt.getAssertions(this.getTestServices()), new File(FileUtil.getNameWithoutExtension((String)((TestFile)CollectionsKt.first(module.getFiles())).getOriginalFile().getAbsolutePath()) + ".diag.txt"), CollectionsKt.joinToString$default((Iterable)reportedDiagnostics, (CharSequence)"\n\n", null, (CharSequence)"\n", (int)0, null, null, (int)58, null), null, 4, null);
    }

    private final String renderDiagnosticMessage(String fileName, Severity severity, String message, int line, int column) {
        String severityString = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)AnalyzerWithCompilerReport.Companion.convertSeverity(severity).toString());
        return '/' + fileName + ':' + line + ':' + column + ": " + severityString + ": " + message;
    }

    private static final void reportKtDiagnostics$processModule(Set<TestModule> processedModules, BaseDiagnosticsCollector ktDiagnosticReporter, JvmBackendDiagnosticsHandler this$0, GlobalMetadataInfoHandler globalMetadataInfoHandler, boolean lightTreeEnabled, boolean lightTreeComparingModeEnabled, TestModule module) {
        if (!processedModules.add(module)) {
            return;
        }
        for (TestFile testFile : module.getFiles()) {
            List ktDiagnostics;
            if ((List)ktDiagnosticReporter.getDiagnosticsByFilePath().get('/' + testFile.getName()) == null) continue;
            Iterable $this$forEach$iv = ktDiagnostics;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtDiagnostic it = (KtDiagnostic)element$iv;
                boolean bl = false;
                List metaInfos = FirDiagnosticsHandlerKt.toMetaInfos$default(it, module, testFile, globalMetadataInfoHandler, lightTreeEnabled, lightTreeComparingModeEnabled, false, 32, null);
                globalMetadataInfoHandler.addMetadataInfosForFile(testFile, metaInfos);
            }
        }
        Iterator<Object> iterator = module.getDependsOnDependencies().iterator();
        while (iterator.hasNext()) {
            String moduleName = ((DependencyDescription)iterator.next()).component1();
            TestModule dependantModule = DependencyProviderKt.getDependencyProvider(this$0.getTestServices()).getTestModule(moduleName);
            JvmBackendDiagnosticsHandler.reportKtDiagnostics$processModule(processedModules, ktDiagnosticReporter, this$0, globalMetadataInfoHandler, lightTreeEnabled, lightTreeComparingModeEnabled, dependantModule);
        }
    }
}

