/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.services.KotlinTestInfo;
import org.jetbrains.kotlin.test.services.KotlinTestInfoKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManager;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/TemporaryDirectoryManagerImpl;", "Lorg/jetbrains/kotlin/test/services/TemporaryDirectoryManager;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "cache", "", "", "Ljava/io/File;", "rootDir", "getRootDir", "()Ljava/io/File;", "rootTempDir", "cleanupTemporaryDirectories", "", "getOrCreateTempDirectory", "name", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nTemporaryDirectoryManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemporaryDirectoryManagerImpl.kt\norg/jetbrains/kotlin/test/services/impl/TemporaryDirectoryManagerImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,54:1\n372#2,7:55\n*S KotlinDebug\n*F\n+ 1 TemporaryDirectoryManagerImpl.kt\norg/jetbrains/kotlin/test/services/impl/TemporaryDirectoryManagerImpl\n*L\n38#1:55,7\n*E\n"})
public final class TemporaryDirectoryManagerImpl
extends TemporaryDirectoryManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, File> cache;
    @NotNull
    private final File rootTempDir;
    private static final boolean onWindows;

    public TemporaryDirectoryManagerImpl(@NotNull TestServices testServices) {
        File file;
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
        this.cache = new LinkedHashMap();
        TemporaryDirectoryManagerImpl temporaryDirectoryManagerImpl = this;
        TemporaryDirectoryManagerImpl temporaryDirectoryManagerImpl2 = this;
        boolean bl = false;
        KotlinTestInfo testInfo = KotlinTestInfoKt.getTestInfo(testServices);
        String className = testInfo.getClassName();
        String methodName = testInfo.getMethodName();
        if (!onWindows && className.length() + methodName.length() < 255) {
            file = KtTestUtil.tmpDirForTest(className, methodName);
        } else {
            int lastDot = StringsKt.lastIndexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null);
            String string = className.substring(0, lastDot + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String packageName = string;
            String string2 = className.substring(lastDot + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String simplifiedClassName = TemporaryDirectoryManagerImpl.Companion.getOnlyUpperCaseSymbols(string2);
            String simplifiedMethodName = TemporaryDirectoryManagerImpl.Companion.getOnlyUpperCaseSymbols(methodName);
            file = KtTestUtil.tmpDirForTest(packageName + simplifiedClassName, "test" + simplifiedMethodName);
        }
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"run {\n        val testIn\u2026plifiedMethodName\")\n    }");
        temporaryDirectoryManagerImpl2.rootTempDir = file;
    }

    @Override
    @NotNull
    public File getRootDir() {
        return this.rootTempDir;
    }

    @Override
    @NotNull
    public File getOrCreateTempDirectory(@NotNull String name2) {
        File file;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Map<String, File> $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(name2);
        if (value$iv == null) {
            boolean bl = false;
            File file2 = KtTestUtil.tmpDir(this.rootTempDir, name2);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tmpDir(rootTempDir, name)");
            File answer$iv = file2;
            $this$getOrPut$iv.put(name2, answer$iv);
            file = answer$iv;
        } else {
            file = value$iv;
        }
        return file;
    }

    @Override
    public void cleanupTemporaryDirectories() {
        this.cache.clear();
        FileUtil.delete((File)this.rootTempDir);
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        onWindows = StringsKt.contains$default((CharSequence)string3, (CharSequence)"windows", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/TemporaryDirectoryManagerImpl$Companion;", "", "()V", "onWindows", "", "getOnlyUpperCaseSymbols", "", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nTemporaryDirectoryManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemporaryDirectoryManagerImpl.kt\norg/jetbrains/kotlin/test/services/impl/TemporaryDirectoryManagerImpl$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,54:1\n429#2:55\n502#2,5:56\n*S KotlinDebug\n*F\n+ 1 TemporaryDirectoryManagerImpl.kt\norg/jetbrains/kotlin/test/services/impl/TemporaryDirectoryManagerImpl$Companion\n*L\n50#1:55\n50#1:56,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final String getOnlyUpperCaseSymbols(String $this$getOnlyUpperCaseSymbols) {
            void $this$filterTo$iv$iv;
            String $this$filter$iv = $this$getOnlyUpperCaseSymbols;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!(Character.isUpperCase(it) || it == '$')) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
            return CollectionsKt.joinToString$default((Iterable)StringsKt.toList((CharSequence)string), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

