/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.extensions.GeneratedDeclarationsUtilsKt;
import org.jetbrains.kotlin.fir.renderer.FirClassMemberRenderer;
import org.jetbrains.kotlin.fir.renderer.FirPackageDirectiveRenderer;
import org.jetbrains.kotlin.fir.renderer.FirRenderer;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputPartForDependsOnModule;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirAnalysisHandler;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirDumpHandler;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirDumpHandler;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "FirClassMemberRendererWithGeneratedDeclarations", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nFirDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDumpHandler.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/FirDumpHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1855#2,2:80\n*S KotlinDebug\n*F\n+ 1 FirDumpHandler.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/FirDumpHandler\n*L\n52#1:80,2\n*E\n"})
public final class FirDumpHandler
extends FirAnalysisHandler {
    @NotNull
    private final MultiModuleInfoDumper dumper;

    public FirDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, false, 6, null);
        this.dumper = new MultiModuleInfoDumper(null, 1, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull FirOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        for (FirOutputPartForDependsOnModule part : info.getPartsForDependsOnModules()) {
            List list;
            TestModule currentModule = part.getModule();
            if (!currentModule.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getFIR_DUMP())) {
                return;
            }
            StringBuilder builderForModule = this.dumper.builderForModule(currentModule);
            Map<TestFile, FirFile> firFiles = info.getMainFirFiles();
            List $this$processModule_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean $i$a$-buildList-FirDumpHandler$processModule$allFiles$22 = false;
            $this$processModule_u24lambda_u240.addAll(firFiles.values());
            $this$processModule_u24lambda_u240.addAll(ConversionUtilsKt.createFilesWithGeneratedDeclarations((FirSession)part.getSession()));
            List allFiles = CollectionsKt.build((List)list);
            FirLazyDeclarationResolverKt.getLazyDeclarationResolver((FirSession)part.getSession()).startResolvingPhase(FirResolvePhase.BODY_RESOLVE);
            $this$processModule_u24lambda_u240 = new FirPackageDirectiveRenderer();
            FirClassMemberRendererWithGeneratedDeclarations $i$a$-buildList-FirDumpHandler$processModule$allFiles$22 = new FirClassMemberRendererWithGeneratedDeclarations(part.getSession());
            FirRenderer renderer = new FirRenderer(builderForModule, null, null, null, (FirClassMemberRenderer)$i$a$-buildList-FirDumpHandler$processModule$allFiles$22, null, null, null, null, (FirPackageDirectiveRenderer)$this$processModule_u24lambda_u240, null, null, null, null, null, null, 65006, null);
            Iterable $this$forEach$iv = allFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirFile it = (FirFile)element$iv;
                boolean bl = false;
                FirRenderer.renderElementAsString$default((FirRenderer)renderer, (FirElement)((FirElement)it), (boolean)false, (int)2, null);
            }
            FirLazyDeclarationResolverKt.getLazyDeclarationResolver((FirSession)part.getSession()).finishResolvingPhase(FirResolvePhase.BODY_RESOLVE);
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        if (this.dumper.isEmpty()) {
            return;
        }
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        File file = testDataFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"testDataFile.parentFile");
        File expectedFile = FilesKt.resolve((File)file, (String)(this.getNameWithoutFirExtension(testDataFile) + ".fir.txt"));
        String actualText = this.dumper.generateResultingDump();
        Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, actualText, null, processAfterAllModules.1.INSTANCE, 4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirDumpHandler$FirClassMemberRendererWithGeneratedDeclarations;", "Lorg/jetbrains/kotlin/fir/renderer/FirClassMemberRenderer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "render", "", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "tests-common-new_test"})
    private static final class FirClassMemberRendererWithGeneratedDeclarations
    extends FirClassMemberRenderer {
        @NotNull
        private final FirSession session;

        public FirClassMemberRendererWithGeneratedDeclarations(@NotNull FirSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        public void render(@NotNull FirRegularClass regularClass) {
            List list;
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            List $this$render_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$render_u24lambda_u240.addAll(regularClass.getDeclarations());
            $this$render_u24lambda_u240.addAll(GeneratedDeclarationsUtilsKt.generatedMembers((FirClass)((FirClass)regularClass), (FirSession)this.session));
            $this$render_u24lambda_u240.addAll(GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirClass)((FirClass)regularClass), (FirSession)this.session));
            List allDeclarations = CollectionsKt.build((List)list);
            this.render(allDeclarations);
        }
    }
}

