/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aF\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0010\u0010\u0005\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0001H\u0007\u001a,\u0010\f\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\r\u001a\u00020\u0004\u001a$\u0010\u000e\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u001a\u001e\u0010\u000f\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u00a8\u0006\u0014"}, d2={"compileJavaFiles", "", "files", "", "Ljava/io/File;", "options", "", "", "javaErrorFile", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "ignoreJavaErrors", "compileJavaFilesExternally", "jdkHome", "compileJavaFilesExternallyWithJava11", "errorsToString", "diagnosticCollector", "Ljavax/tools/DiagnosticCollector;", "Ljavax/tools/JavaFileObject;", "humanReadable", "tests-compiler-utils_test"})
@JvmName(name="JvmCompilationUtils")
public final class JvmCompilationUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public static final boolean compileJavaFiles(@NotNull Collection<? extends File> files, @Nullable List<String> options, @Nullable File javaErrorFile, @NotNull Assertions assertions, boolean ignoreJavaErrors) throws IOException {
        Boolean success;
        block10: {
            DiagnosticCollector<JavaFileObject> diagnosticCollector;
            block9: {
                Intrinsics.checkNotNullParameter(files, (String)"files");
                Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
                JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
                diagnosticCollector = new DiagnosticCollector<JavaFileObject>();
                Closeable closeable = javaCompiler.getStandardFileManager((DiagnosticListener<? super JavaFileObject>)diagnosticCollector, Locale.ENGLISH, Charset.forName("utf-8"));
                Throwable throwable = null;
                try {
                    JavaCompiler.CompilationTask compilationTask;
                    StandardJavaFileManager fileManager = (StandardJavaFileManager)closeable;
                    boolean bl = false;
                    Iterable<? extends JavaFileObject> javaFileObjectsFromFiles = fileManager.getJavaFileObjectsFromFiles((Iterable<? extends File>)files);
                    try {
                        compilationTask = javaCompiler.getTask(new StringWriter(), fileManager, (DiagnosticListener<? super JavaFileObject>)diagnosticCollector, (Iterable<String>)options, null, javaFileObjectsFromFiles);
                    }
                    catch (Throwable e) {
                        if (ignoreJavaErrors) {
                            boolean bl2 = false;
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            return bl2;
                        }
                        throw e;
                    }
                    JavaCompiler.CompilationTask task = compilationTask;
                    success = task.call();
                    if (javaErrorFile != null && javaErrorFile.exists()) break block9;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Intrinsics.checkNotNullExpressionValue((Object)success, (String)"success");
                assertions.assertTrue(success != false || ignoreJavaErrors, (Function0<String>)((Function0)new Function0<String>(diagnosticCollector){
                    final /* synthetic */ DiagnosticCollector<JavaFileObject> $diagnosticCollector;
                    {
                        this.$diagnosticCollector = $diagnosticCollector;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return JvmCompilationUtils.access$errorsToString(this.$diagnosticCollector, true);
                    }
                }));
                break block10;
            }
            Assertions.assertEqualsToFile$default(assertions, javaErrorFile, JvmCompilationUtils.errorsToString(diagnosticCollector, false), null, 4, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)success, (String)"success");
        boolean bl = success;
        return bl;
    }

    public static /* synthetic */ boolean compileJavaFiles$default(Collection collection, List list, File file, Assertions assertions, boolean bl, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return JvmCompilationUtils.compileJavaFiles(collection, list, file, assertions, bl);
    }

    public static final boolean compileJavaFilesExternallyWithJava11(@NotNull Collection<? extends File> files, @NotNull List<String> options) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        File file = KtTestUtil.getJdk11Home();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getJdk11Home()");
        return JvmCompilationUtils.compileJavaFilesExternally(files, options, file);
    }

    public static final boolean compileJavaFilesExternally(@NotNull Collection<? extends File> files, @NotNull List<String> options, @NotNull File jdkHome) {
        boolean isSuccess;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)jdkHome, (String)"jdkHome");
        List command2 = new ArrayList();
        command2.add(new File(jdkHome, "bin/javac").getPath());
        command2.addAll((Collection)options);
        for (File file : files) {
            command2.add(file.getPath());
        }
        Process process = new ProcessBuilder(new String[0]).command(command2).start();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String errors = bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
        process.waitFor();
        boolean bl = isSuccess = process.exitValue() == 0;
        if (!isSuccess) {
            System.err.println(errors);
        }
        return isSuccess;
    }

    private static final String errorsToString(DiagnosticCollector<JavaFileObject> diagnosticCollector, boolean humanReadable) {
        StringBuilder builder = new StringBuilder();
        for (Diagnostic<JavaFileObject> diagnostic : diagnosticCollector.getDiagnostics()) {
            if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
            if (humanReadable) {
                builder.append(diagnostic).append("\n");
                continue;
            }
            builder.append(new File(diagnostic.getSource().toUri()).getName()).append(":").append(diagnostic.getLineNumber()).append(":").append(diagnostic.getColumnNumber()).append(":").append(diagnostic.getCode()).append("\n");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @JvmOverloads
    public static final boolean compileJavaFiles(@NotNull Collection<? extends File> files, @Nullable List<String> options, @Nullable File javaErrorFile, @NotNull Assertions assertions) throws IOException {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        return JvmCompilationUtils.compileJavaFiles$default(files, options, javaErrorFile, assertions, false, 16, null);
    }

    @JvmOverloads
    public static final boolean compileJavaFiles(@NotNull Collection<? extends File> files, @Nullable List<String> options, @NotNull Assertions assertions) throws IOException {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        return JvmCompilationUtils.compileJavaFiles$default(files, options, null, assertions, false, 20, null);
    }

    public static final /* synthetic */ String access$errorsToString(DiagnosticCollector diagnosticCollector, boolean humanReadable) {
        return JvmCompilationUtils.errorsToString(diagnosticCollector, humanReadable);
    }
}

