/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.config.JvmStringConcat;
import org.jetbrains.kotlin.test.BooleanPatternWithExtractor;
import org.jetbrains.kotlin.test.PatternWithExtractor;
import org.jetbrains.kotlin.test.ValuePatternWithExtractor;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0004\u001aB\u0010\u0011\u001a\u00020\u00122\u0016\u0010\u0013\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002\u001aR\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001b0\n\"\b\b\u0000\u0010\u001b*\u00020\u000f*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u001c2\u0006\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u000e2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u0001H\u001b0 H\u0002\u001a2\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\n*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u001c2\u0006\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u000eH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"BOOLEAN_FLAG_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "FLAG_CLASSES", "", "Ljava/lang/Class;", "FLAG_NAMESPACE_TO_CLASS", "", "", "patterns", "Lorg/jetbrains/kotlin/test/PatternWithExtractor;", "getPatterns$annotations", "()V", "parseAnalysisFlags", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "", "rawFlags", "tryApplyBooleanFlag", "", "destination", "", "flag", "flagEnabled", "", "flagNamespace", "flagName", "createPattern", "E", "", "directive", "configurationKey", "extractor", "Lkotlin/Function1;", "tests-compiler-utils_test"})
@SourceDebugExtension(value={"SMAP\nAnalysisFlagExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalysisFlagExtractor.kt\norg/jetbrains/kotlin/test/AnalysisFlagExtractorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
public final class AnalysisFlagExtractorKt {
    private static final Pattern BOOLEAN_FLAG_PATTERN;
    @NotNull
    private static final List<PatternWithExtractor<?>> patterns;
    @NotNull
    private static final List<Class<?>> FLAG_CLASSES;
    @NotNull
    private static final Map<String, Class<?>> FLAG_NAMESPACE_TO_CLASS;

    private static /* synthetic */ void getPatterns$annotations() {
    }

    private static final <E> PatternWithExtractor<E> createPattern(List<PatternWithExtractor<?>> $this$createPattern, String directive2, CompilerConfigurationKey<E> configurationKey, Function1<? super String, ? extends E> extractor) {
        ValuePatternWithExtractor<? extends E> valuePatternWithExtractor;
        ValuePatternWithExtractor<? extends E> it = valuePatternWithExtractor = new ValuePatternWithExtractor<E>(directive2, configurationKey, extractor);
        boolean bl = false;
        ((Collection)$this$createPattern).add(it);
        return valuePatternWithExtractor;
    }

    private static final PatternWithExtractor<Boolean> createPattern(List<PatternWithExtractor<?>> $this$createPattern, String directive2, CompilerConfigurationKey<Boolean> configurationKey) {
        BooleanPatternWithExtractor booleanPatternWithExtractor;
        BooleanPatternWithExtractor it = booleanPatternWithExtractor = new BooleanPatternWithExtractor(directive2, configurationKey);
        boolean bl = false;
        ((Collection)$this$createPattern).add(it);
        return booleanPatternWithExtractor;
    }

    @NotNull
    public static final Map<CompilerConfigurationKey<?>, Object> parseAnalysisFlags(@NotNull List<String> rawFlags) {
        Intrinsics.checkNotNullParameter(rawFlags, (String)"rawFlags");
        Map result = new LinkedHashMap();
        for (String flag : rawFlags) {
            Matcher m = BOOLEAN_FLAG_PATTERN.matcher(flag);
            if (m.matches()) {
                boolean flagEnabled = !Intrinsics.areEqual((Object)"-", (Object)m.group(1));
                String flagNamespace = m.group(3);
                String flagName = m.group(4);
                Intrinsics.checkNotNullExpressionValue((Object)flagName, (String)"flagName");
                AnalysisFlagExtractorKt.tryApplyBooleanFlag(result, flag, flagEnabled, flagNamespace, flagName);
                continue;
            }
            for (PatternWithExtractor<?> pattern : patterns) {
                m = pattern.getPattern().matcher(flag);
                if (!m.matches()) continue;
                Map map = result;
                CompilerConfigurationKey<?> compilerConfigurationKey = pattern.getConfigurationKey();
                Matcher matcher = m;
                Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"m");
                Object obj = pattern.extract(matcher);
                map.put(compilerConfigurationKey, obj);
            }
        }
        return result;
    }

    private static final void tryApplyBooleanFlag(Map<CompilerConfigurationKey<?>, Object> destination, String flag, boolean flagEnabled, String flagNamespace, String flagName) {
        block12: {
            boolean bl;
            Class<?> configurationKeysClass = null;
            Object configurationKeyField = null;
            if (flagNamespace == null) {
                for (Class<?> flagClass : FLAG_CLASSES) {
                    try {
                        configurationKeyField = flagClass.getField(flagName);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            } else {
                Object object;
                boolean bl2;
                configurationKeysClass = FLAG_NAMESPACE_TO_CLASS.get(flagNamespace);
                boolean bl3 = bl2 = configurationKeysClass != null;
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-AnalysisFlagExtractorKt$tryApplyBooleanFlag$42 = false;
                    String $i$a$-assert-AnalysisFlagExtractorKt$tryApplyBooleanFlag$42 = "Expected [+|-][namespace.]configurationKey, got: " + flag;
                    throw new AssertionError((Object)$i$a$-assert-AnalysisFlagExtractorKt$tryApplyBooleanFlag$42);
                }
                try {
                    Class<?> clazz = configurationKeysClass;
                    Intrinsics.checkNotNull(clazz);
                    object = clazz.getField(flagName);
                }
                catch (Exception e) {
                    object = null;
                }
                configurationKeyField = object;
            }
            boolean bl4 = bl = configurationKeyField != null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl5 = false;
                String string = "Expected [+|-][namespace.]configurationKey, got: " + flag;
                throw new AssertionError((Object)string);
            }
            try {
                Field field = configurationKeyField;
                Intrinsics.checkNotNull((Object)field);
                Object object = field.get(null);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.config.CompilerConfigurationKey<kotlin.Boolean>");
                CompilerConfigurationKey configurationKey = (CompilerConfigurationKey)object;
                Boolean bl6 = flagEnabled;
                destination.put(configurationKey, bl6);
            }
            catch (Exception e) {
                if (!_Assertions.ENABLED) break block12;
                boolean bl7 = false;
                String string = "Expected [+|-][namespace.]configurationKey, got: " + flag;
                throw new AssertionError((Object)string);
            }
        }
    }

    static {
        Object[] objectArray;
        BOOLEAN_FLAG_PATTERN = Pattern.compile("([+-])(([a-zA-Z_0-9]*)\\.)?([a-zA-Z_0-9]*)");
        Object[] $this$patterns_u24lambda_u240 = objectArray = CollectionsKt.createListBuilder();
        boolean bl = false;
        CompilerConfigurationKey compilerConfigurationKey = JVMConfigurationKeys.ASSERTIONS_MODE;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey, (String)"ASSERTIONS_MODE");
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u240, "ASSERTIONS_MODE", compilerConfigurationKey, (Function1)new Function1<String, JVMAssertionsMode>((Object)JVMAssertionsMode.Companion){

            @NotNull
            public final JVMAssertionsMode invoke(@Nullable String p0) {
                return ((JVMAssertionsMode.Companion)this.receiver).fromString(p0);
            }

            @NotNull
            public final String getSignature() {
                return "fromString(Ljava/lang/String;)Lorg/jetbrains/kotlin/config/JVMAssertionsMode;";
            }

            @NotNull
            public final String getName() {
                return "fromString";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JVMAssertionsMode.Companion.class);
            }
        });
        CompilerConfigurationKey compilerConfigurationKey2 = JVMConfigurationKeys.STRING_CONCAT;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey2, (String)"STRING_CONCAT");
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u240, "STRING_CONCAT", compilerConfigurationKey2, (Function1)new Function1<String, JvmStringConcat>((Object)JvmStringConcat.Companion){

            @Nullable
            public final JvmStringConcat invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((JvmStringConcat.Companion)this.receiver).fromString(p0);
            }

            @NotNull
            public final String getSignature() {
                return "fromString(Ljava/lang/String;)Lorg/jetbrains/kotlin/config/JvmStringConcat;";
            }

            @NotNull
            public final String getName() {
                return "fromString";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JvmStringConcat.Companion.class);
            }
        });
        CompilerConfigurationKey compilerConfigurationKey3 = JVMConfigurationKeys.SAM_CONVERSIONS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey3, (String)"SAM_CONVERSIONS");
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u240, "SAM_CONVERSIONS", compilerConfigurationKey3, (Function1)new Function1<String, JvmClosureGenerationScheme>((Object)JvmClosureGenerationScheme.Companion){

            @Nullable
            public final JvmClosureGenerationScheme invoke(@Nullable String p0) {
                return ((JvmClosureGenerationScheme.Companion)this.receiver).fromString(p0);
            }

            @NotNull
            public final String getSignature() {
                return "fromString(Ljava/lang/String;)Lorg/jetbrains/kotlin/config/JvmClosureGenerationScheme;";
            }

            @NotNull
            public final String getName() {
                return "fromString";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JvmClosureGenerationScheme.Companion.class);
            }
        });
        CompilerConfigurationKey compilerConfigurationKey4 = JVMConfigurationKeys.LAMBDAS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey4, (String)"LAMBDAS");
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u240, "LAMBDAS", compilerConfigurationKey4, (Function1)new Function1<String, JvmClosureGenerationScheme>((Object)JvmClosureGenerationScheme.Companion){

            @Nullable
            public final JvmClosureGenerationScheme invoke(@Nullable String p0) {
                return ((JvmClosureGenerationScheme.Companion)this.receiver).fromString(p0);
            }

            @NotNull
            public final String getSignature() {
                return "fromString(Ljava/lang/String;)Lorg/jetbrains/kotlin/config/JvmClosureGenerationScheme;";
            }

            @NotNull
            public final String getName() {
                return "fromString";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JvmClosureGenerationScheme.Companion.class);
            }
        });
        CompilerConfigurationKey compilerConfigurationKey5 = JVMConfigurationKeys.USE_OLD_INLINE_CLASSES_MANGLING_SCHEME;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey5, (String)"USE_OLD_INLINE_CLASSES_MANGLING_SCHEME");
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u240, "USE_OLD_INLINE_CLASSES_MANGLING_SCHEME", (CompilerConfigurationKey<Boolean>)compilerConfigurationKey5);
        CompilerConfigurationKey compilerConfigurationKey6 = JVMConfigurationKeys.SERIALIZE_IR;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey6, (String)"SERIALIZE_IR");
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u240, "SERIALIZE_IR", compilerConfigurationKey6, (Function1)new Function1<String, JvmSerializeIrMode>((Object)JvmSerializeIrMode.Companion){

            @NotNull
            public final JvmSerializeIrMode invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((JvmSerializeIrMode.Companion)this.receiver).fromString(p0);
            }

            @NotNull
            public final String getSignature() {
                return "fromString(Ljava/lang/String;)Lorg/jetbrains/kotlin/config/JvmSerializeIrMode;";
            }

            @NotNull
            public final String getName() {
                return "fromString";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JvmSerializeIrMode.Companion.class);
            }
        });
        patterns = CollectionsKt.build((List)objectArray);
        objectArray = new Class[]{CLIConfigurationKeys.class, JVMConfigurationKeys.class};
        FLAG_CLASSES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"CLI", CLIConfigurationKeys.class), TuplesKt.to((Object)"JVM", JVMConfigurationKeys.class)};
        FLAG_NAMESPACE_TO_CLASS = MapsKt.mapOf((Pair[])objectArray);
    }
}

