/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.frontend.fir.TestWithDisableLazyResolveDirectivePassesException;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirResolveContractViolationErrorHandler;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/DisableLazyResolveChecksAfterAnalysisChecker;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "check", "", "failedAssertions", "", "Lorg/jetbrains/kotlin/test/WrappedException;", "isDisableLazyResolveDirectivePresent", "", "suppressIfNeeded", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nDisableLazyResolveChecksAfterAnalysisChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisableLazyResolveChecksAfterAnalysisChecker.kt\norg/jetbrains/kotlin/test/frontend/fir/DisableLazyResolveChecksAfterAnalysisChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1855#2,2:71\n819#2:73\n847#2,2:74\n*S KotlinDebug\n*F\n+ 1 DisableLazyResolveChecksAfterAnalysisChecker.kt\norg/jetbrains/kotlin/test/frontend/fir/DisableLazyResolveChecksAfterAnalysisChecker\n*L\n35#1:71,2\n57#1:73\n57#1:74,2\n*E\n"})
public final class DisableLazyResolveChecksAfterAnalysisChecker
extends AfterAnalysisChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final boolean isTeamCityBuild = System.getenv("TEAMCITY_VERSION") != null;

    public DisableLazyResolveChecksAfterAnalysisChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    public void check(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        if (!this.isDisableLazyResolveDirectivePresent()) {
            return;
        }
        if (!((Collection)failedAssertions).isEmpty()) {
            return;
        }
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        if (!isTeamCityBuild) {
            Object[] objectArray = new File[]{CustomTestDataUtilsKt.getOriginalTestDataFile(testDataFile), CustomTestDataUtilsKt.getFirTestDataFile(testDataFile)};
            Iterable $this$forEach$iv = SetsKt.setOf((Object[])objectArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                FileUtilsKt.removeDirectiveFromFile(file, FirDiagnosticsDirectives.INSTANCE.getFIR_DISABLE_LAZY_RESOLVE_CHECKS());
            }
        }
        String message = isTeamCityBuild ? "Please remove // " + FirDiagnosticsDirectives.INSTANCE.getFIR_DISABLE_LAZY_RESOLVE_CHECKS() + " from the test source" : "Removed // " + FirDiagnosticsDirectives.INSTANCE.getFIR_DISABLE_LAZY_RESOLVE_CHECKS() + " from the test source";
        throw new TestWithDisableLazyResolveDirectivePassesException(StringsKt.trimIndent((String)("\n                    Lazy resolve contracts are satisfied now for this test and the test pass\n                    " + message + "\n                    Please re-run the test now\n                ")));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<WrappedException> suppressIfNeeded(@NotNull List<? extends WrappedException> failedAssertions) {
        List list;
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        if (this.isDisableLazyResolveDirectivePresent()) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = failedAssertions;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                WrappedException it = (WrappedException)element$iv$iv;
                boolean bl = false;
                if (it instanceof WrappedException.FromHandler && ((WrappedException.FromHandler)it).getHandler() instanceof FirResolveContractViolationErrorHandler) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = failedAssertions;
        }
        return list;
    }

    private final boolean isDisableLazyResolveDirectivePresent() {
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure(this.getTestServices());
        return moduleStructure.getAllDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getFIR_DISABLE_LAZY_RESOLVE_CHECKS());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/DisableLazyResolveChecksAfterAnalysisChecker$Companion;", "", "()V", "isTeamCityBuild", "", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

