/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic.handlers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.diagnostics.GenericDiagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontendOutputArtifact;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicFrontendAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/DiagnosticMessagesTextHandler;", "Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicFrontendAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "processAfterAllModules", "", "someAssertionWasFailed", "", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/classic/ClassicFrontendOutputArtifact;", "tests-common-new_test"})
public final class DiagnosticMessagesTextHandler
extends ClassicFrontendAnalysisHandler {
    @NotNull
    private final MultiModuleInfoDumper dumper;

    public DiagnosticMessagesTextHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, false, 6, null);
        this.dumper = new MultiModuleInfoDumper("// -- Module: <%s> --");
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)DiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        if (this.dumper.isEmpty()) {
            return;
        }
        String resultDump = this.dumper.generateResultingDump();
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        File expectedFile = FileUtilsKt.withExtension(testDataFile, ".diag.txt");
        Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, resultDump, null, 4, null);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull ClassicFrontendOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module.getDirectives().contains(DiagnosticsDirectives.INSTANCE.getRENDER_DIAGNOSTICS_FULL_TEXT())) {
            return;
        }
        ByteArrayOutputStream diagnosticsFullTextByteArrayStream = new ByteArrayOutputStream();
        PrintStream diagnosticsFullTextPrintStream = new PrintStream(diagnosticsFullTextByteArrayStream);
        GroupingMessageCollector diagnosticsFullTextCollector = new GroupingMessageCollector((MessageCollector)new PrintingMessageCollector(diagnosticsFullTextPrintStream, MessageRenderer.SYSTEM_INDEPENDENT_RELATIVE_PATHS, true), false);
        Diagnostics diagnostics = info.getAnalysisResult().getBindingContext().getDiagnostics();
        Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"info.analysisResult.bindingContext.diagnostics");
        AnalyzerWithCompilerReport.Companion.reportDiagnostics((GenericDiagnostics)diagnostics, (MessageCollector)diagnosticsFullTextCollector, false);
        diagnosticsFullTextCollector.flush();
        diagnosticsFullTextPrintStream.flush();
        StringBuilder stringBuilder = this.dumper.builderForModule(module);
        byte[] byArray = diagnosticsFullTextByteArrayStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"diagnosticsFullTextByteArrayStream.toByteArray()");
        Object object = byArray;
        object = new String((byte[])object, Charsets.UTF_8);
        StringBuilder stringBuilder2 = stringBuilder.append((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
    }
}

