/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.builders;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.services.AbstractEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.DefaultsDsl;
import org.jetbrains.kotlin.test.util.PatternsKt;

@DefaultsDsl
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0015\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u0005\u0012\u0004\u0012\u0002H\u0017\u0018\u00010\u0016\"\b\b\u0000\u0010\u0017*\u00020\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00052\r\u0010\u0019\u001a\t\u0018\u0001H\u0017\u00a2\u0006\u0002\b\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ.\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u0013J\u000e\u0010+\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u0013J\u000e\u0010,\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u0013J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/H\u0002J\u0017\u00100\u001a\u0004\u0018\u00010(2\u0006\u00101\u001a\u00020(H\u0002\u00a2\u0006\u0002\u00102J'\u00103\u001a\u00020\u001f\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00052\u0006\u0010\u0019\u001a\u0002H\u0017\u00a2\u0006\u0002\u00104R \u0010\u0003\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/test/builders/LanguageVersionSettingsBuilder;", "", "()V", "analysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "setApiVersion", "(Lorg/jetbrains/kotlin/config/ApiVersion;)V", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "getLanguageVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "setLanguageVersion", "(Lorg/jetbrains/kotlin/config/LanguageVersion;)V", "specificFeatures", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "analysisFlag", "Lkotlin/Pair;", "T", "flag", "value", "Lkotlin/internal/NoInfer;", "(Lorg/jetbrains/kotlin/config/AnalysisFlag;Ljava/lang/Object;)Lkotlin/Pair;", "build", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "configureUsingDirectives", "", "directives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "environmentConfigurators", "", "Lorg/jetbrains/kotlin/test/services/AbstractEnvironmentConfigurator;", "targetBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "useK2", "", "disable", "feature", "enable", "enableWithWarning", "parseLanguageFeature", "featureString", "", "trueOrNull", "condition", "(Z)Ljava/lang/Boolean;", "withFlag", "(Lorg/jetbrains/kotlin/config/AnalysisFlag;Ljava/lang/Object;)V", "Companion", "test-infrastructure_test"})
@SourceDebugExtension(value={"SMAP\nLanguageVersionSettingsBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageVersionSettingsBuilder.kt\norg/jetbrains/kotlin/test/builders/LanguageVersionSettingsBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,134:1\n1#2:135\n1855#3,2:136\n1855#3:138\n1855#3,2:139\n1856#3:141\n1855#3,2:142\n216#4:144\n*S KotlinDebug\n*F\n+ 1 LanguageVersionSettingsBuilder.kt\norg/jetbrains/kotlin/test/builders/LanguageVersionSettingsBuilder\n*L\n86#1:136,2\n88#1:138\n89#1:139,2\n88#1:141\n98#1:142,2\n127#1:144\n*E\n"})
public final class LanguageVersionSettingsBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LanguageVersion languageVersion = LanguageVersion.LATEST_STABLE;
    @NotNull
    private ApiVersion apiVersion = ApiVersion.LATEST_STABLE;
    @NotNull
    private final Map<LanguageFeature, LanguageFeature.State> specificFeatures = new LinkedHashMap();
    @NotNull
    private final Map<AnalysisFlag<?>, Object> analysisFlags = new LinkedHashMap();

    @NotNull
    public final LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    public final void setLanguageVersion(@NotNull LanguageVersion languageVersion) {
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"<set-?>");
        this.languageVersion = languageVersion;
    }

    @NotNull
    public final ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public final void setApiVersion(@NotNull ApiVersion apiVersion) {
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"<set-?>");
        this.apiVersion = apiVersion;
    }

    public final void enable(@NotNull LanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        this.specificFeatures.put(feature, LanguageFeature.State.ENABLED);
    }

    public final void enableWithWarning(@NotNull LanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        this.specificFeatures.put(feature, LanguageFeature.State.ENABLED_WITH_WARNING);
    }

    public final void disable(@NotNull LanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        this.specificFeatures.put(feature, LanguageFeature.State.DISABLED);
    }

    public final <T> void withFlag(@NotNull AnalysisFlag<? extends T> flag, T value) {
        Intrinsics.checkNotNullParameter(flag, (String)"flag");
        this.analysisFlags.put(flag, value);
    }

    /*
     * WARNING - void declaration
     */
    public final void configureUsingDirectives(@NotNull RegisteredDirectives directives2, @NotNull List<? extends AbstractEnvironmentConfigurator> environmentConfigurators, @Nullable TargetBackend targetBackend, boolean useK2) {
        Object it;
        void it2;
        Intrinsics.checkNotNullParameter((Object)directives2, (String)"directives");
        Intrinsics.checkNotNullParameter(environmentConfigurators, (String)"environmentConfigurators");
        ApiVersion apiVersion = DirectiveKt.singleOrZeroValue(directives2, LanguageSettingsDirectives.INSTANCE.getAPI_VERSION());
        if (apiVersion != null) {
            LanguageVersion languageVersion;
            this.apiVersion = apiVersion;
            Comparable comparable = (Comparable)LanguageVersion.LATEST_STABLE;
            LanguageVersion languageVersion2 = LanguageVersion.Companion.fromVersionString(apiVersion.getVersionString());
            Intrinsics.checkNotNull((Object)languageVersion2);
            this.languageVersion = languageVersion = (LanguageVersion)ComparisonsKt.maxOf((Comparable)comparable, (Comparable)((Comparable)languageVersion2));
        }
        if (useK2 && this.languageVersion.compareTo((Enum)LanguageVersion.KOTLIN_2_0) < 0) {
            this.languageVersion = LanguageVersion.KOTLIN_2_0;
        } else if (!useK2 && this.languageVersion.compareTo((Enum)LanguageVersion.KOTLIN_1_9) > 0) {
            this.languageVersion = LanguageVersion.KOTLIN_1_9;
        }
        Object[] objectArray = new Pair[11];
        List<String> list = directives2.get(LanguageSettingsDirectives.INSTANCE.getOPT_IN());
        Iterator iterator = list;
        AnalysisFlag analysisFlag = AnalysisFlags.getOptIn();
        LanguageVersionSettingsBuilder languageVersionSettingsBuilder = this;
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        boolean bl2 = !((Collection)it2).isEmpty();
        objectArray2[n] = languageVersionSettingsBuilder.analysisFlag(analysisFlag, bl2 ? list : null);
        objectArray[1] = this.analysisFlag(AnalysisFlags.getIgnoreDataFlowInAssert(), this.trueOrNull(directives2.contains(LanguageSettingsDirectives.INSTANCE.getIGNORE_DATA_FLOW_IN_ASSERT())));
        objectArray[2] = this.analysisFlag(AnalysisFlags.getAllowResultReturnType(), this.trueOrNull(directives2.contains(LanguageSettingsDirectives.INSTANCE.getALLOW_RESULT_RETURN_TYPE())));
        objectArray[3] = this.analysisFlag(AnalysisFlags.getExplicitApiMode(), DirectiveKt.singleOrZeroValue(directives2, LanguageSettingsDirectives.INSTANCE.getEXPLICIT_API_MODE()));
        objectArray[4] = this.analysisFlag(AnalysisFlags.getAllowKotlinPackage(), this.trueOrNull(directives2.contains(LanguageSettingsDirectives.INSTANCE.getALLOW_KOTLIN_PACKAGE())));
        objectArray[5] = this.analysisFlag(JvmAnalysisFlags.getJvmDefaultMode(), DirectiveKt.singleOrZeroValue(directives2, LanguageSettingsDirectives.INSTANCE.getJVM_DEFAULT_MODE()));
        objectArray[6] = this.analysisFlag(JvmAnalysisFlags.getInheritMultifileParts(), this.trueOrNull(directives2.contains(LanguageSettingsDirectives.INSTANCE.getINHERIT_MULTIFILE_PARTS())));
        objectArray[7] = this.analysisFlag(JvmAnalysisFlags.getSanitizeParentheses(), this.trueOrNull(directives2.contains(LanguageSettingsDirectives.INSTANCE.getSANITIZE_PARENTHESES())));
        objectArray[8] = this.analysisFlag(JvmAnalysisFlags.getEnableJvmPreview(), this.trueOrNull(directives2.contains(LanguageSettingsDirectives.INSTANCE.getENABLE_JVM_PREVIEW())));
        TargetBackend targetBackend2 = targetBackend;
        objectArray[9] = this.analysisFlag(JvmAnalysisFlags.getUseIR(), !(targetBackend2 != null ? !targetBackend2.isIR() : false));
        objectArray[10] = this.analysisFlag(AnalysisFlags.getExplicitApiVersion(), this.trueOrNull(apiVersion != null));
        List analysisFlags = CollectionsKt.listOfNotNull((Object[])objectArray);
        Iterable $this$forEach$iv = analysisFlags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl3 = false;
            this.withFlag((AnalysisFlag)it.getFirst(), it.getSecond());
        }
        $this$forEach$iv = environmentConfigurators;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AbstractEnvironmentConfigurator)element$iv;
            boolean bl4 = false;
            Iterable $this$forEach$iv2 = ((AbstractEnvironmentConfigurator)it).provideAdditionalAnalysisFlags(directives2, this.languageVersion).entrySet();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Map.Entry entry = (Map.Entry)element$iv2;
                boolean bl5 = false;
                AnalysisFlag flag = (AnalysisFlag)entry.getKey();
                Object value = entry.getValue();
                this.withFlag(flag, value);
            }
        }
        TargetBackend targetBackend3 = targetBackend;
        boolean bl6 = targetBackend3 != null ? targetBackend3.isIR() : false;
        if (bl6) {
            this.specificFeatures.put(LanguageFeature.JsAllowValueClassesInExternals, LanguageFeature.State.ENABLED);
        }
        $this$forEach$iv = directives2.get(LanguageSettingsDirectives.INSTANCE.getLANGUAGE());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl7 = false;
            this.parseLanguageFeature((String)it);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parseLanguageFeature(String featureString) {
        LanguageFeature.State state;
        Matcher matcher = PatternsKt.getLANGUAGE_FEATURE_PATTERN().matcher(featureString);
        if (!matcher.find()) {
            throw new IllegalStateException(("Wrong syntax in the '// !" + LanguageSettingsDirectives.INSTANCE.getLANGUAGE().getName() + ": ...' directive:\n                   found: '" + featureString + "'\n                   Must be '((+|-|warn:)LanguageFeatureName)+'\n                   where '+' means 'enable', '-' means 'disable', 'warn:' means 'enable with warning'\n                   and language feature names are names of enum entries in LanguageFeature enum class").toString());
        }
        String mode = matcher.group(1);
        if (mode == null) throw new IllegalStateException(("Unknown mode for language feature: " + mode).toString());
        int n = -1;
        switch (mode.hashCode()) {
            case 43: {
                if (mode.equals("+")) {
                    n = 1;
                }
                break;
            }
            case 45: {
                if (mode.equals("-")) {
                    n = 2;
                }
                break;
            }
            case 112901748: {
                if (mode.equals("warn:")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                state = LanguageFeature.State.ENABLED;
                break;
            }
            case 2: {
                state = LanguageFeature.State.DISABLED;
                break;
            }
            case 3: {
                state = LanguageFeature.State.ENABLED_WITH_WARNING;
                break;
            }
            default: {
                throw new IllegalStateException(("Unknown mode for language feature: " + mode).toString());
            }
        }
        LanguageFeature.State mode2 = state;
        String name2 = matcher.group(2);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
        LanguageFeature languageFeature = LanguageFeature.Companion.fromString(name2);
        if (languageFeature == null) {
            throw new IllegalStateException(("Language feature with name \"" + name2 + "\" not found").toString());
        }
        LanguageFeature feature = languageFeature;
        this.specificFeatures.put(feature, mode2);
    }

    private final <T> Pair<AnalysisFlag<T>, T> analysisFlag(AnalysisFlag<? extends T> flag, T value) {
        Pair pair;
        T t = value;
        if (t != null) {
            T p0 = t;
            boolean bl = false;
            pair = TuplesKt.to(flag, p0);
        } else {
            pair = null;
        }
        return pair;
    }

    private final Boolean trueOrNull(boolean condition) {
        Boolean bl;
        boolean $i$f$runIf = false;
        if (condition) {
            boolean bl2 = false;
            bl = true;
        } else {
            bl = null;
        }
        return bl;
    }

    @NotNull
    public final LanguageVersionSettings build() {
        return (LanguageVersionSettings)new LanguageVersionSettingsImpl(this.languageVersion, this.apiVersion, this.analysisFlags, this.specificFeatures);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/builders/LanguageVersionSettingsBuilder$Companion;", "", "()V", "fromExistingSettings", "Lorg/jetbrains/kotlin/test/builders/LanguageVersionSettingsBuilder;", "builder", "test-infrastructure_test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LanguageVersionSettingsBuilder fromExistingSettings(@NotNull LanguageVersionSettingsBuilder builder) {
            LanguageVersionSettingsBuilder languageVersionSettingsBuilder;
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            LanguageVersionSettingsBuilder $this$fromExistingSettings_u24lambda_u240 = languageVersionSettingsBuilder = new LanguageVersionSettingsBuilder();
            boolean bl = false;
            $this$fromExistingSettings_u24lambda_u240.setLanguageVersion(builder.getLanguageVersion());
            $this$fromExistingSettings_u24lambda_u240.setApiVersion(builder.getApiVersion());
            $this$fromExistingSettings_u24lambda_u240.specificFeatures.putAll(builder.specificFeatures);
            $this$fromExistingSettings_u24lambda_u240.analysisFlags.putAll(builder.analysisFlags);
            return languageVersionSettingsBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

