/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.backend.TargetInliner;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/test/backend/BlackBoxInlinerCodegenSuppressor;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "suppressForTargetFrontend", "Lorg/jetbrains/kotlin/test/WrappedException;", "failedAssertions", "directive", "Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", "Lorg/jetbrains/kotlin/test/backend/TargetInliner;", "suppressIfNeeded", "tests-common-new_test"})
public final class BlackBoxInlinerCodegenSuppressor
extends AfterAnalysisChecker {
    public BlackBoxInlinerCodegenSuppressor(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    @Override
    @NotNull
    public List<WrappedException> suppressIfNeeded(@NotNull List<? extends WrappedException> failedAssertions) {
        List<WrappedException> list;
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        FrontendKind<?> targetFrontend = DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getDefaultFrontend();
        List<WrappedException> commonResult = this.suppressForTargetFrontend(failedAssertions, CodegenTestDirectives.INSTANCE.getIGNORE_INLINER());
        if (commonResult != null) {
            return commonResult;
        }
        FrontendKind<?> frontendKind = targetFrontend;
        if (Intrinsics.areEqual(frontendKind, (Object)FrontendKinds.ClassicFrontend.INSTANCE)) {
            list = this.suppressForTargetFrontend(failedAssertions, CodegenTestDirectives.INSTANCE.getIGNORE_INLINER_K1());
            if (list == null) {
                list = failedAssertions;
            }
        } else if (Intrinsics.areEqual(frontendKind, (Object)FrontendKinds.FIR.INSTANCE)) {
            list = this.suppressForTargetFrontend(failedAssertions, CodegenTestDirectives.INSTANCE.getIGNORE_INLINER_K2());
            if (list == null) {
                list = failedAssertions;
            }
        } else {
            list = failedAssertions;
        }
        return list;
    }

    private final List<WrappedException> suppressForTargetFrontend(List<? extends WrappedException> failedAssertions, ValueDirective<TargetInliner> directive2) {
        String directiveName = directive2.getName();
        List<TargetInliner> ignoreDirectives = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().get(directive2);
        if (ignoreDirectives.size() > 1) {
            throw new IllegalArgumentException("Directive " + directiveName + " should contains only one value");
        }
        TargetInliner ignoreDirective = (TargetInliner)((Object)CollectionsKt.singleOrNull(ignoreDirectives));
        boolean enabledIrInliner = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(LanguageSettingsDirectives.INSTANCE.getENABLE_JVM_IR_INLINER());
        List unmuteError = CollectionsKt.listOf((Object)this.wrap((Throwable)((Object)new AssertionError((Object)("Looks like this test can be unmuted. Please remove " + directiveName + " directive.")))));
        if (ignoreDirective == TargetInliner.IR && enabledIrInliner || ignoreDirective == TargetInliner.BYTECODE && !enabledIrInliner) {
            return !((Collection)failedAssertions).isEmpty() ? CollectionsKt.emptyList() : unmuteError;
        }
        return null;
    }
}

