/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.util;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KtAssert;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;

public class KtTestUtil {
    private static final String homeDir = KtTestUtil.computeHomeDirectory();
    private static final String PLEASE_REGENERATE_TESTS = "Please regenerate tests (GenerateTests.kt)";

    @NotNull
    public static File tmpDirForTest(@NotNull String testClassName, @NotNull String testName) throws IOException {
        if (testClassName == null) {
            KtTestUtil.$$$reportNull$$$0(0);
        }
        if (testName == null) {
            KtTestUtil.$$$reportNull$$$0(1);
        }
        File file = KtTestUtil.normalizeFile(FileUtil.createTempDirectory((String)testClassName, (String)testName, (boolean)false));
        if (file == null) {
            KtTestUtil.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    public static File tmpDir(String name2) throws IOException {
        File file = KtTestUtil.normalizeFile(FileUtil.createTempDirectory((String)name2, (String)"", (boolean)false));
        if (file == null) {
            KtTestUtil.$$$reportNull$$$0(3);
        }
        return file;
    }

    @NotNull
    public static File tmpDir(@NotNull File parentDir, @NotNull String name2) throws IOException {
        if (parentDir == null) {
            KtTestUtil.$$$reportNull$$$0(4);
        }
        if (name2 == null) {
            KtTestUtil.$$$reportNull$$$0(5);
        }
        File file = KtTestUtil.normalizeFile(FileUtil.createTempDirectory((File)parentDir, (String)name2, (String)"", (boolean)false));
        if (file == null) {
            KtTestUtil.$$$reportNull$$$0(6);
        }
        return file;
    }

    @NotNull
    public static File tmpDirForReusableFolder(String name2) throws IOException {
        File file = KtTestUtil.normalizeFile(FileUtil.createTempDirectory((File)new File(System.getProperty("java.io.tmpdir")), (String)name2, (String)"", (boolean)true));
        if (file == null) {
            KtTestUtil.$$$reportNull$$$0(7);
        }
        return file;
    }

    private static File normalizeFile(File file) throws IOException {
        return file.getCanonicalFile();
    }

    @NotNull
    public static KtFile createFile(@NotNull @NonNls String name2, @NotNull String text, @NotNull Project project) {
        if (name2 == null) {
            KtTestUtil.$$$reportNull$$$0(8);
        }
        if (text == null) {
            KtTestUtil.$$$reportNull$$$0(9);
        }
        if (project == null) {
            KtTestUtil.$$$reportNull$$$0(10);
        }
        String shortName = name2.substring(name2.lastIndexOf(47) + 1);
        shortName = shortName.substring(shortName.lastIndexOf(92) + 1);
        LightVirtualFile virtualFile = new LightVirtualFile(shortName, (Language)KotlinLanguage.INSTANCE, (CharSequence)StringUtilRt.convertLineSeparators((String)text));
        virtualFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        PsiFileFactoryImpl factory = (PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)project);
        KtFile ktFile = (KtFile)factory.trySetupPsiForFile(virtualFile, (Language)KotlinLanguage.INSTANCE, true, false);
        if (ktFile == null) {
            KtTestUtil.$$$reportNull$$$0(11);
        }
        return ktFile;
    }

    public static String doLoadFile(String myFullDataPath, String name2) throws IOException {
        String fullName = myFullDataPath + File.separatorChar + name2;
        return KtTestUtil.doLoadFile(new File(fullName));
    }

    public static String doLoadFile(@NotNull File file) throws IOException {
        if (file == null) {
            KtTestUtil.$$$reportNull$$$0(12);
        }
        try {
            return FileUtil.loadFile((File)file, (String)"UTF-8", (boolean)true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String messageWithFullPath = file.getAbsolutePath() + " (No such file or directory)";
            throw new IOException("Ensure you have your 'Working Directory' configured correctly as the root Kotlin project directory in your test configuration\n\t" + messageWithFullPath, fileNotFoundException);
        }
    }

    public static String getFilePath(File file) {
        return FileUtil.toSystemIndependentName((String)file.getPath());
    }

    @NotNull
    private static File getJdkHome(@NotNull String mainProperty) {
        if (mainProperty == null) {
            KtTestUtil.$$$reportNull$$$0(13);
        }
        return KtTestUtil.getJdkHome(mainProperty, null);
    }

    @NotNull
    private static File getJdkHome(@NotNull String mainProperty, @Nullable String propertyVariant) {
        if (mainProperty == null) {
            KtTestUtil.$$$reportNull$$$0(14);
        }
        return KtTestUtil.getJdkHome(mainProperty, propertyVariant, null);
    }

    @NotNull
    private static File getJdkHome(@NotNull String mainProperty, @Nullable String propertyVariant1, @Nullable String propertyVariant2) {
        String jdkPath;
        if (mainProperty == null) {
            KtTestUtil.$$$reportNull$$$0(15);
        }
        if ((jdkPath = KtTestUtil.getStringProperty(mainProperty)) == null && propertyVariant1 != null) {
            jdkPath = KtTestUtil.getStringProperty(propertyVariant1);
        }
        if (jdkPath == null && propertyVariant2 != null) {
            jdkPath = KtTestUtil.getStringProperty(propertyVariant2);
        }
        if (jdkPath == null) {
            throw new AssertionError((Object)("Environment variable " + mainProperty + " is not set!"));
        }
        return new File(jdkPath);
    }

    private static String getStringProperty(@NotNull String propertyName) {
        String value;
        if (propertyName == null) {
            KtTestUtil.$$$reportNull$$$0(16);
        }
        if ((value = System.getProperty(propertyName)) != null) {
            return value;
        }
        return System.getenv(propertyName);
    }

    @NotNull
    public static File getJdk6Home() {
        return KtTestUtil.getJdkHome("JDK_1_6", "JDK_6", "JDK_16");
    }

    @NotNull
    public static File getJdk8Home() {
        return KtTestUtil.getJdkHome("JDK_1_8", "JDK_8", "JDK_18");
    }

    @NotNull
    public static File getJdk11Home() {
        return KtTestUtil.getJdkHome("JDK_11_0", "JDK_11");
    }

    @NotNull
    public static File getJdk17Home() {
        return KtTestUtil.getJdkHome("JDK_17_0", "JDK_17");
    }

    @NotNull
    public static String getTestDataPathBase() {
        String string = KtTestUtil.getHomeDirectory() + "/compiler/testData";
        if (string == null) {
            KtTestUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static String getHomeDirectory() {
        String string = homeDir;
        if (string == null) {
            KtTestUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String computeHomeDirectory() {
        String userDir = System.getProperty("user.dir");
        File dir = new File(userDir == null ? "." : userDir);
        String string = FileUtil.toCanonicalPath((String)dir.getAbsolutePath());
        if (string == null) {
            KtTestUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    public static File findMockJdkRtJar() {
        return new File(KtTestUtil.getHomeDirectory(), "compiler/testData/mockJDK/jre/lib/rt.jar");
    }

    public static File findMockJdkRtModified() {
        return new File(KtTestUtil.getHomeDirectory(), "compiler/testData/mockJDKModified/rt.jar");
    }

    public static File findAndroidApiJar() {
        File androidJarFile;
        String androidJarProp = System.getProperty("android.jar");
        File file = androidJarFile = androidJarProp == null ? null : new File(androidJarProp);
        if (androidJarFile == null || !androidJarFile.isFile()) {
            throw new RuntimeException("Unable to get a valid path from 'android.jar' property (" + androidJarProp + "), please point it to the 'android.jar' file location");
        }
        return androidJarFile;
    }

    @NotNull
    public static File findAndroidSdk() {
        File androidSdkDir;
        String androidSdkProp = System.getProperty("android.sdk");
        File file = androidSdkDir = androidSdkProp == null ? null : new File(androidSdkProp);
        if (androidSdkDir == null || !androidSdkDir.isDirectory()) {
            throw new RuntimeException("Unable to get a valid path from 'android.sdk' property (" + androidSdkProp + "), please point it to the android SDK location");
        }
        File file2 = androidSdkDir;
        if (file2 == null) {
            KtTestUtil.$$$reportNull$$$0(20);
        }
        return file2;
    }

    public static String getAndroidSdkSystemIndependentPath() {
        return PathUtil.toSystemIndependentName((String)KtTestUtil.findAndroidSdk().getAbsolutePath());
    }

    public static File getAnnotationsJar() {
        return new File(KtTestUtil.getHomeDirectory(), "compiler/testData/mockJDK/jre/lib/annotations.jar");
    }

    public static void mkdirs(@NotNull File file) {
        if (file == null) {
            KtTestUtil.$$$reportNull$$$0(21);
        }
        if (file.isDirectory()) {
            return;
        }
        if (!file.mkdirs()) {
            if (file.exists()) {
                throw new IllegalStateException("Failed to create " + file + ": file exists and not a directory");
            }
            throw new IllegalStateException("Failed to create " + file);
        }
    }

    public static void assertAllTestsPresentByMetadataWithExcluded(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern, @Nullable Pattern excludedPattern, boolean recursive, String ... excludeDirs) {
        if (testCaseClass == null) {
            KtTestUtil.$$$reportNull$$$0(22);
        }
        if (testDataDir == null) {
            KtTestUtil.$$$reportNull$$$0(23);
        }
        if (filenamePattern == null) {
            KtTestUtil.$$$reportNull$$$0(24);
        }
        if (excludeDirs == null) {
            KtTestUtil.$$$reportNull$$$0(25);
        }
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(testCaseClass, testDataDir, filenamePattern, excludedPattern, TargetBackend.ANY, recursive, excludeDirs);
    }

    public static void assertAllTestsPresentByMetadata(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern, boolean recursive, String ... excludeDirs) {
        if (testCaseClass == null) {
            KtTestUtil.$$$reportNull$$$0(26);
        }
        if (testDataDir == null) {
            KtTestUtil.$$$reportNull$$$0(27);
        }
        if (filenamePattern == null) {
            KtTestUtil.$$$reportNull$$$0(28);
        }
        if (excludeDirs == null) {
            KtTestUtil.$$$reportNull$$$0(29);
        }
        KtTestUtil.assertAllTestsPresentByMetadata(testCaseClass, testDataDir, filenamePattern, TargetBackend.ANY, recursive, excludeDirs);
    }

    public static void assertAllTestsPresentByMetadataWithExcluded(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern, @Nullable Pattern excludedPattern, @NotNull TargetBackend targetBackend, boolean recursive, String ... excludeDirs) {
        if (testCaseClass == null) {
            KtTestUtil.$$$reportNull$$$0(30);
        }
        if (testDataDir == null) {
            KtTestUtil.$$$reportNull$$$0(31);
        }
        if (filenamePattern == null) {
            KtTestUtil.$$$reportNull$$$0(32);
        }
        if (targetBackend == null) {
            KtTestUtil.$$$reportNull$$$0(33);
        }
        if (excludeDirs == null) {
            KtTestUtil.$$$reportNull$$$0(34);
        }
        File rootFile = new File(KtTestUtil.getTestsRoot(testCaseClass));
        Set<String> filePaths = KtTestUtil.collectPathsMetadata(testCaseClass);
        Set exclude = SetsKt.setOf((Object[])excludeDirs);
        File[] files = testDataDir.listFiles();
        if (files != null) {
            for (File file : files) {
                boolean excluded;
                if (file.isDirectory()) {
                    if (!recursive || !KtTestUtil.containsTestData(file, filenamePattern, excludedPattern) || exclude.contains(file.getName())) continue;
                    KtTestUtil.assertTestClassPresentByMetadata(testCaseClass, file);
                    continue;
                }
                boolean bl = excluded = excludedPattern != null && excludedPattern.matcher(file.getName()).matches();
                if (excluded || !filenamePattern.matcher(file.getName()).matches() || !InTextDirectivesUtils.isCompatibleTarget(targetBackend, file)) continue;
                KtTestUtil.assertFilePathPresent(file, rootFile, filePaths);
            }
        }
    }

    public static void assertAllTestsPresentByMetadata(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern, @NotNull TargetBackend targetBackend, boolean recursive, String ... excludeDirs) {
        if (testCaseClass == null) {
            KtTestUtil.$$$reportNull$$$0(35);
        }
        if (testDataDir == null) {
            KtTestUtil.$$$reportNull$$$0(36);
        }
        if (filenamePattern == null) {
            KtTestUtil.$$$reportNull$$$0(37);
        }
        if (targetBackend == null) {
            KtTestUtil.$$$reportNull$$$0(38);
        }
        if (excludeDirs == null) {
            KtTestUtil.$$$reportNull$$$0(39);
        }
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(testCaseClass, testDataDir, filenamePattern, null, targetBackend, recursive, excludeDirs);
    }

    public static void assertAllTestsPresentInSingleGeneratedClass(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern) {
        if (testCaseClass == null) {
            KtTestUtil.$$$reportNull$$$0(40);
        }
        if (testDataDir == null) {
            KtTestUtil.$$$reportNull$$$0(41);
        }
        if (filenamePattern == null) {
            KtTestUtil.$$$reportNull$$$0(42);
        }
        KtTestUtil.assertAllTestsPresentInSingleGeneratedClass(testCaseClass, testDataDir, filenamePattern, TargetBackend.ANY);
    }

    public static void assertAllTestsPresentInSingleGeneratedClassWithExcluded(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern, @Nullable Pattern excludePattern) {
        if (testCaseClass == null) {
            KtTestUtil.$$$reportNull$$$0(43);
        }
        if (testDataDir == null) {
            KtTestUtil.$$$reportNull$$$0(44);
        }
        if (filenamePattern == null) {
            KtTestUtil.$$$reportNull$$$0(45);
        }
        KtTestUtil.assertAllTestsPresentInSingleGeneratedClass(testCaseClass, testDataDir, filenamePattern, excludePattern, TargetBackend.ANY);
    }

    public static void assertAllTestsPresentInSingleGeneratedClass(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern, @NotNull TargetBackend targetBackend) {
        if (testCaseClass == null) {
            KtTestUtil.$$$reportNull$$$0(46);
        }
        if (testDataDir == null) {
            KtTestUtil.$$$reportNull$$$0(47);
        }
        if (filenamePattern == null) {
            KtTestUtil.$$$reportNull$$$0(48);
        }
        if (targetBackend == null) {
            KtTestUtil.$$$reportNull$$$0(49);
        }
        KtTestUtil.assertAllTestsPresentInSingleGeneratedClass(testCaseClass, testDataDir, filenamePattern, null, targetBackend);
    }

    public static void assertAllTestsPresentInSingleGeneratedClass(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern, @Nullable Pattern excludePattern, @NotNull TargetBackend targetBackend) {
        if (testCaseClass == null) {
            KtTestUtil.$$$reportNull$$$0(50);
        }
        if (testDataDir == null) {
            KtTestUtil.$$$reportNull$$$0(51);
        }
        if (filenamePattern == null) {
            KtTestUtil.$$$reportNull$$$0(52);
        }
        if (targetBackend == null) {
            KtTestUtil.$$$reportNull$$$0(53);
        }
        File rootFile = new File(KtTestUtil.getTestsRoot(testCaseClass));
        Set<String> filePaths = KtTestUtil.collectPathsMetadata(testCaseClass);
        FileUtil.processFilesRecursively((File)testDataDir, file -> {
            boolean excluded;
            boolean bl = excluded = excludePattern != null && excludePattern.matcher(file.getName()).matches();
            if (file.isFile() && !excluded && filenamePattern.matcher(file.getName()).matches() && InTextDirectivesUtils.isCompatibleTarget(targetBackend, file)) {
                KtTestUtil.assertFilePathPresent(file, rootFile, filePaths);
            }
            return true;
        });
    }

    private static void assertFilePathPresent(File file, File rootFile, Set<String> filePaths) {
        String relativePath;
        String path = FileUtil.getRelativePath((File)rootFile, (File)file);
        if (path != null && !filePaths.contains(relativePath = KtTestUtil.nameToCompare(path))) {
            KtAssert.fail("Test data file missing from the generated test class: " + file + "\n" + PLEASE_REGENERATE_TESTS);
        }
    }

    private static Set<String> collectPathsMetadata(Class<?> testCaseClass) {
        return new HashSet<String>(ContainerUtil.map(KtTestUtil.collectMethodsMetadata(testCaseClass), KtTestUtil::nameToCompare));
    }

    @Nullable
    public static String getMethodMetadata(Method method) {
        TestMetadata testMetadata = method.getAnnotation(TestMetadata.class);
        return testMetadata != null ? testMetadata.value() : null;
    }

    private static Set<String> collectMethodsMetadata(Class<?> testCaseClass) {
        HashSet<String> filePaths = new HashSet<String>();
        for (Method method : testCaseClass.getDeclaredMethods()) {
            String path = KtTestUtil.getMethodMetadata(method);
            if (path == null) continue;
            filePaths.add(path);
        }
        return filePaths;
    }

    private static boolean containsTestData(File dir, Pattern filenamePattern, @Nullable Pattern excludedPattern) {
        File[] files = dir.listFiles();
        assert (files != null);
        for (File file : files) {
            boolean excluded;
            if (file.isDirectory()) {
                if (!KtTestUtil.containsTestData(file, filenamePattern, excludedPattern)) continue;
                return true;
            }
            boolean bl = excluded = excludedPattern != null && excludedPattern.matcher(file.getName()).matches();
            if (excluded || !filenamePattern.matcher(file.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    private static void assertTestClassPresentByMetadata(@NotNull Class<?> outerClass, @NotNull File testDataDir) {
        if (outerClass == null) {
            KtTestUtil.$$$reportNull$$$0(54);
        }
        if (testDataDir == null) {
            KtTestUtil.$$$reportNull$$$0(55);
        }
        for (Class<?> nestedClass : outerClass.getDeclaredClasses()) {
            TestMetadata testMetadata = nestedClass.getAnnotation(TestMetadata.class);
            if (testMetadata == null || !testMetadata.value().equals(KtTestUtil.getFilePath(testDataDir))) continue;
            return;
        }
        KtAssert.fail("Test data directory missing from the generated test class: " + testDataDir + "\n" + PLEASE_REGENERATE_TESTS);
    }

    public static String getTestsRoot(@NotNull Class<?> testCaseClass) {
        if (testCaseClass == null) {
            KtTestUtil.$$$reportNull$$$0(56);
        }
        TestMetadata testClassMetadata = testCaseClass.getAnnotation(TestMetadata.class);
        KtAssert.assertNotNull("No metadata for class: " + testCaseClass, testClassMetadata);
        return testClassMetadata.value();
    }

    public static String nameToCompare(@NotNull String name2) {
        if (name2 == null) {
            KtTestUtil.$$$reportNull$$$0(57);
        }
        return (SystemInfo.isFileSystemCaseSensitive ? name2 : name2.toLowerCase()).replace('\\', '/');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/test/util/KtTestUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDir";
                break;
            }
            case 5: 
            case 8: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainProperty";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 22: 
            case 26: 
            case 30: 
            case 35: 
            case 40: 
            case 43: 
            case 46: 
            case 50: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseClass";
                break;
            }
            case 23: 
            case 27: 
            case 31: 
            case 36: 
            case 41: 
            case 44: 
            case 47: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataDir";
                break;
            }
            case 24: 
            case 28: 
            case 32: 
            case 37: 
            case 42: 
            case 45: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filenamePattern";
                break;
            }
            case 25: 
            case 29: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeDirs";
                break;
            }
            case 33: 
            case 38: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetBackend";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/test/util/KtTestUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "tmpDirForTest";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "tmpDir";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "tmpDirForReusableFolder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataPathBase";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeDirectory";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHomeDirectory";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findAndroidSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tmpDirForTest";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tmpDir";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doLoadFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getJdkHome";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStringProperty";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "mkdirs";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "assertAllTestsPresentByMetadataWithExcluded";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "assertAllTestsPresentByMetadata";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "assertAllTestsPresentInSingleGeneratedClass";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "assertAllTestsPresentInSingleGeneratedClassWithExcluded";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "assertTestClassPresentByMetadata";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getTestsRoot";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "nameToCompare";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

