/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.configuration;

import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.jvm.JvmPhasesKt;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.config.JvmStringConcat;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.MockLibraryUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestJavacVersion;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.ConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.DirectiveToConfigurationKeyExtractor;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.JUnit5Assertions;
import org.jetbrains.kotlin.test.services.KotlinStandardLibrariesPathProvider;
import org.jetbrains.kotlin.test.services.KotlinStandardLibrariesPathProviderKt;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.SourceFileProvider;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.JvmEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManager;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManagerKt;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.util.StringUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006H\u0002J2\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006H\u0002J \u0010 \u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u001bH\u0002J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010$\u001a\u00020\u000e*\u00020%H\u0016J\u0014\u0010&\u001a\u00020\u000e*\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010'\u001a\u00020\u000e*\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0006*\b\u0012\u0004\u0012\u00020)0\u0006H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\t\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/JvmEnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "additionalServices", "", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "()Ljava/util/List;", "directiveContainers", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "addJavaBinaryRootsByJavaModules", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "configurationKind", "Lorg/jetbrains/kotlin/test/ConfigurationKind;", "moduleInfoFiles", "Lorg/jetbrains/kotlin/test/model/TestFile;", "addJavaCompiledModule", "moduleName", "", "bySources", "", "targetDir", "Ljava/io/File;", "addJavaCompiledModulesFromDependentKotlinModules", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "addJavaSourceRootsByJavaModules", "compileJavaFilesToModularJar", "sourcesDir", "configureCompilerConfiguration", "configureDefaultJvmTarget", "provideConfigurationKeys", "Lorg/jetbrains/kotlin/test/services/DirectiveToConfigurationKeyExtractor;", "putCustomPhaseConfigWithEnabledDump", "registerModuleDependencies", "toFileList", "Lorg/jetbrains/kotlin/test/model/DependencyDescription;", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nJvmEnvironmentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/JvmEnvironmentConfigurator\n+ 2 TestServices.kt\norg/jetbrains/kotlin/test/services/TestServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,429:1\n25#2:430\n1#3:431\n1#3:490\n766#4:432\n857#4,2:433\n766#4:435\n857#4,2:436\n1271#4,2:438\n1285#4,4:440\n3190#4,10:444\n1855#4,2:454\n1855#4,2:456\n766#4:458\n857#4,2:459\n1549#4:461\n1620#4,3:462\n1549#4:465\n1620#4,3:466\n1603#4,9:469\n1855#4:478\n661#4,11:479\n1856#4:491\n1612#4:492\n1549#4:493\n1620#4,3:494\n1549#4:497\n1620#4,3:498\n766#4:501\n857#4,2:502\n766#4:504\n857#4,2:505\n1549#4:507\n1620#4,3:508\n1360#4:511\n1446#4,5:512\n*S KotlinDebug\n*F\n+ 1 JvmEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/JvmEnvironmentConfigurator\n*L\n158#1:430\n329#1:490\n209#1:432\n209#1:433,2\n225#1:435\n225#1:436,2\n232#1:438,2\n232#1:440,4\n237#1:444,10\n241#1:454,2\n255#1:456,2\n259#1:458\n259#1:459,2\n269#1:461\n269#1:462,3\n323#1:465\n323#1:466,3\n329#1:469,9\n329#1:478\n329#1:479,11\n329#1:491\n329#1:492\n361#1:493\n361#1:494,3\n370#1:497\n370#1:498,3\n410#1:501\n410#1:502,2\n412#1:504\n412#1:505,2\n414#1:507\n414#1:508,3\n418#1:511\n418#1:512,5\n*E\n"})
public final class JvmEnvironmentConfigurator
extends EnvironmentConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CompilerConfigurationKey<ConfigurationKind> TEST_CONFIGURATION_KIND_KEY;
    @Nullable
    private static final String DEFAULT_JVM_TARGET_FROM_PROPERTY;
    @NotNull
    private static final String JAVA_BINARIES_JAR_NAME = "java-binaries";

    public JvmEnvironmentConfigurator(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)JvmEnvironmentConfigurationDirectives.INSTANCE);
    }

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        Function1 serviceConstructor$iv = additionalServices.1.INSTANCE;
        boolean $i$f$service = false;
        return CollectionsKt.listOf((Object)new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(CompiledClassesManager.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv));
    }

    @Override
    public void provideConfigurationKeys(@NotNull DirectiveToConfigurationKeyExtractor $this$provideConfigurationKeys) {
        Intrinsics.checkNotNullParameter((Object)$this$provideConfigurationKeys, (String)"<this>");
        ValueDirective<JvmStringConcat> valueDirective2 = JvmEnvironmentConfigurationDirectives.INSTANCE.getSTRING_CONCAT();
        CompilerConfigurationKey compilerConfigurationKey = JVMConfigurationKeys.STRING_CONCAT;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey, (String)"STRING_CONCAT");
        $this$provideConfigurationKeys.register(valueDirective2, compilerConfigurationKey);
        ValueDirective<JVMAssertionsMode> valueDirective3 = JvmEnvironmentConfigurationDirectives.INSTANCE.getASSERTIONS_MODE();
        CompilerConfigurationKey compilerConfigurationKey2 = JVMConfigurationKeys.ASSERTIONS_MODE;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey2, (String)"ASSERTIONS_MODE");
        $this$provideConfigurationKeys.register(valueDirective3, compilerConfigurationKey2);
        ValueDirective<JvmClosureGenerationScheme> valueDirective4 = JvmEnvironmentConfigurationDirectives.INSTANCE.getSAM_CONVERSIONS();
        CompilerConfigurationKey compilerConfigurationKey3 = JVMConfigurationKeys.SAM_CONVERSIONS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey3, (String)"SAM_CONVERSIONS");
        $this$provideConfigurationKeys.register(valueDirective4, compilerConfigurationKey3);
        ValueDirective<JvmClosureGenerationScheme> valueDirective5 = JvmEnvironmentConfigurationDirectives.INSTANCE.getLAMBDAS();
        CompilerConfigurationKey compilerConfigurationKey4 = JVMConfigurationKeys.LAMBDAS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey4, (String)"LAMBDAS");
        $this$provideConfigurationKeys.register(valueDirective5, compilerConfigurationKey4);
        SimpleDirective simpleDirective = JvmEnvironmentConfigurationDirectives.INSTANCE.getUSE_OLD_INLINE_CLASSES_MANGLING_SCHEME();
        CompilerConfigurationKey compilerConfigurationKey5 = JVMConfigurationKeys.USE_OLD_INLINE_CLASSES_MANGLING_SCHEME;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey5, (String)"USE_OLD_INLINE_CLASSES_MANGLING_SCHEME");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective, compilerConfigurationKey5, false, 4, null);
        SimpleDirective simpleDirective2 = LanguageSettingsDirectives.INSTANCE.getENABLE_JVM_PREVIEW();
        CompilerConfigurationKey compilerConfigurationKey6 = JVMConfigurationKeys.ENABLE_JVM_PREVIEW;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey6, (String)"ENABLE_JVM_PREVIEW");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective2, compilerConfigurationKey6, false, 4, null);
        SimpleDirective simpleDirective3 = LanguageSettingsDirectives.INSTANCE.getEMIT_JVM_TYPE_ANNOTATIONS();
        CompilerConfigurationKey compilerConfigurationKey7 = JVMConfigurationKeys.EMIT_JVM_TYPE_ANNOTATIONS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey7, (String)"EMIT_JVM_TYPE_ANNOTATIONS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective3, compilerConfigurationKey7, false, 4, null);
        SimpleDirective simpleDirective4 = LanguageSettingsDirectives.INSTANCE.getNO_OPTIMIZED_CALLABLE_REFERENCES();
        CompilerConfigurationKey compilerConfigurationKey8 = JVMConfigurationKeys.NO_OPTIMIZED_CALLABLE_REFERENCES;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey8, (String)"NO_OPTIMIZED_CALLABLE_REFERENCES");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective4, compilerConfigurationKey8, false, 4, null);
        SimpleDirective simpleDirective5 = LanguageSettingsDirectives.INSTANCE.getDISABLE_PARAM_ASSERTIONS();
        CompilerConfigurationKey compilerConfigurationKey9 = JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey9, (String)"DISABLE_PARAM_ASSERTIONS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective5, compilerConfigurationKey9, false, 4, null);
        SimpleDirective simpleDirective6 = LanguageSettingsDirectives.INSTANCE.getDISABLE_CALL_ASSERTIONS();
        CompilerConfigurationKey compilerConfigurationKey10 = JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey10, (String)"DISABLE_CALL_ASSERTIONS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective6, compilerConfigurationKey10, false, 4, null);
        SimpleDirective simpleDirective7 = LanguageSettingsDirectives.INSTANCE.getNO_UNIFIED_NULL_CHECKS();
        CompilerConfigurationKey compilerConfigurationKey11 = JVMConfigurationKeys.NO_UNIFIED_NULL_CHECKS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey11, (String)"NO_UNIFIED_NULL_CHECKS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective7, compilerConfigurationKey11, false, 4, null);
        SimpleDirective simpleDirective8 = LanguageSettingsDirectives.INSTANCE.getPARAMETERS_METADATA();
        CompilerConfigurationKey compilerConfigurationKey12 = JVMConfigurationKeys.PARAMETERS_METADATA;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey12, (String)"PARAMETERS_METADATA");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective8, compilerConfigurationKey12, false, 4, null);
        ValueDirective<JvmTarget> valueDirective6 = JvmEnvironmentConfigurationDirectives.INSTANCE.getJVM_TARGET();
        CompilerConfigurationKey compilerConfigurationKey13 = JVMConfigurationKeys.JVM_TARGET;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey13, (String)"JVM_TARGET");
        $this$provideConfigurationKeys.register(valueDirective6, compilerConfigurationKey13);
        ValueDirective<JvmSerializeIrMode> valueDirective7 = JvmEnvironmentConfigurationDirectives.INSTANCE.getSERIALIZE_IR();
        CompilerConfigurationKey compilerConfigurationKey14 = JVMConfigurationKeys.SERIALIZE_IR;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey14, (String)"SERIALIZE_IR");
        $this$provideConfigurationKeys.register(valueDirective7, compilerConfigurationKey14);
        ValueDirective<Integer> valueDirective8 = LanguageSettingsDirectives.INSTANCE.getJDK_RELEASE();
        CompilerConfigurationKey compilerConfigurationKey15 = JVMConfigurationKeys.JDK_RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey15, (String)"JDK_RELEASE");
        $this$provideConfigurationKeys.register(valueDirective8, compilerConfigurationKey15);
        SimpleDirective simpleDirective9 = LanguageSettingsDirectives.INSTANCE.getUSE_TYPE_TABLE();
        CompilerConfigurationKey compilerConfigurationKey16 = JVMConfigurationKeys.USE_TYPE_TABLE;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey16, (String)"USE_TYPE_TABLE");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective9, compilerConfigurationKey16, false, 4, null);
        SimpleDirective simpleDirective10 = JvmEnvironmentConfigurationDirectives.INSTANCE.getENABLE_DEBUG_MODE();
        CompilerConfigurationKey compilerConfigurationKey17 = JVMConfigurationKeys.ENABLE_DEBUG_MODE;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey17, (String)"ENABLE_DEBUG_MODE");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective10, compilerConfigurationKey17, false, 4, null);
        SimpleDirective simpleDirective11 = LanguageSettingsDirectives.INSTANCE.getNO_NEW_JAVA_ANNOTATION_TARGETS();
        CompilerConfigurationKey compilerConfigurationKey18 = JVMConfigurationKeys.NO_NEW_JAVA_ANNOTATION_TARGETS;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey18, (String)"NO_NEW_JAVA_ANNOTATION_TARGETS");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective11, compilerConfigurationKey18, false, 4, null);
        SimpleDirective simpleDirective12 = LanguageSettingsDirectives.INSTANCE.getOLD_INNER_CLASSES_LOGIC();
        CompilerConfigurationKey compilerConfigurationKey19 = JVMConfigurationKeys.OLD_INNER_CLASSES_LOGIC;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey19, (String)"OLD_INNER_CLASSES_LOGIC");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective12, compilerConfigurationKey19, false, 4, null);
        SimpleDirective simpleDirective13 = LanguageSettingsDirectives.INSTANCE.getLINK_VIA_SIGNATURES();
        CompilerConfigurationKey compilerConfigurationKey20 = JVMConfigurationKeys.LINK_VIA_SIGNATURES;
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey20, (String)"LINK_VIA_SIGNATURES");
        DirectiveToConfigurationKeyExtractor.register$default($this$provideConfigurationKeys, simpleDirective13, compilerConfigurationKey20, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureCompilerConfiguration(@NotNull CompilerConfiguration configuration2, @NotNull TestModule module) {
        void $this$filterTo$iv$iv;
        Object object;
        Object object2;
        Object object3;
        boolean useJava11ToCompileIncludedJavaFiles;
        List list;
        K2JVMCompilerArguments $this$filterTo$iv$iv2;
        Object it;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!JvmPlatforms.INSTANCE.getAllJvmPlatforms().contains(module.getTargetPlatform())) {
            return;
        }
        this.configureDefaultJvmTarget(configuration2);
        RegisteredDirectives registeredDirectives = module.getDirectives();
        TestJdkKind jdkKind = Companion.extractJdkKind(registeredDirectives);
        File file = Companion.getJdkHome(jdkKind);
        if (file != null) {
            it = file;
            boolean bl = false;
            configuration2.put(JVMConfigurationKeys.JDK_HOME, it);
        }
        File file2 = Companion.getJdkClasspathRoot(jdkKind);
        if (file2 != null) {
            it = file2;
            boolean bl = false;
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration2, (File)it);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[jdkKind.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                configuration2.put(JVMConfigurationKeys.NO_JDK, (Object)true);
            }
        }
        ConfigurationKind configurationKind = Companion.extractConfigurationKind(registeredDirectives);
        it = configurationKind;
        boolean bl = false;
        configuration2.put(TEST_CONFIGURATION_KIND_KEY, it);
        ConfigurationKind configurationKind2 = configurationKind;
        TestJavacVersion javaVersionToCompile = (TestJavacVersion)((Object)CollectionsKt.singleOrNull(registeredDirectives.get(JvmEnvironmentConfigurationDirectives.INSTANCE.getCOMPILE_JAVA_USING())));
        if (!registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getALL_JAVA_AS_BINARY())) {
            Iterable $this$filter$iv = SourceFileProviderKt.getJavaFiles(module);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                TestFile it2 = (TestFile)element$iv$iv;
                boolean bl2 = false;
                if (!it2.getDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getINCLUDE_JAVA_AS_BINARY())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = SourceFileProviderKt.getJavaFiles(module);
        }
        List javaBinaryFiles = list;
        boolean bl3 = useJava11ToCompileIncludedJavaFiles = javaVersionToCompile == TestJavacVersion.JAVAC_11;
        if (configurationKind2.getWithRuntime()) {
            void it3;
            K2JVMCompilerArguments $i$f$filter;
            $this$filterTo$iv$iv2 = $i$f$filter = new K2JVMCompilerArguments();
            object3 = KotlinStandardLibrariesPathProviderKt.getStandardLibrariesPathProvider(this.getTestServices());
            object2 = configuration2;
            boolean bl4 = false;
            it3.setNoReflect(true);
            object = Unit.INSTANCE;
            KotlinStandardLibrariesPathProviderKt.configureStandardLibs((CompilerConfiguration)object2, (KotlinStandardLibrariesPathProvider)object3, $i$f$filter);
        }
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)configuration2, Companion.getLibraryFilesExceptRealRuntime(this.getTestServices(), configurationKind2, module.getDirectives()));
        TargetBackend targetBackend = module.getTargetBackend();
        boolean isIr = targetBackend != null ? targetBackend.isIR() : false;
        configuration2.put(JVMConfigurationKeys.IR, (Object)isIr);
        Iterable $this$filter$iv = SourceFileProviderKt.getJavaFiles(module);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestFile it4 = (TestFile)element$iv$iv;
            boolean bl5 = false;
            if (!(!it4.getDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getINCLUDE_JAVA_AS_BINARY()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List javaSourceFiles = (List)destination$iv$iv;
        if (!((Collection)javaSourceFiles).isEmpty() && !module.getDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getSKIP_JAVA_SOURCES()) && !registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getALL_JAVA_AS_BINARY())) {
            Iterable $this$associateWith$iv = javaSourceFiles;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it5;
                TestFile bl5 = (TestFile)element$iv$iv;
                object3 = element$iv$iv;
                object2 = result$iv;
                boolean bl6 = false;
                object = SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getRealFileForSourceFile((TestFile)it5);
                object2.put(object3, object);
            }
            Map realSourceFileMap = result$iv;
            this.addJavaCompiledModulesFromDependentKotlinModules(configuration2, configurationKind2, module, true);
            Iterable $this$partition$iv = javaSourceFiles;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                TestFile it6 = (TestFile)element$iv;
                boolean bl7 = false;
                if (Intrinsics.areEqual((Object)it6.getName(), (Object)"module-info.java")) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            $this$associateWith$iv = new Pair(first$iv, second$iv);
            List moduleInfoFiles = (List)$this$associateWith$iv.component1();
            List sourceFiles = (List)$this$associateWith$iv.component2();
            if (!((Collection)moduleInfoFiles).isEmpty()) {
                this.addJavaSourceRootsByJavaModules(configuration2, moduleInfoFiles);
            } else {
                Iterable $this$forEach$iv = sourceFiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file3;
                    TestFile testFile = (TestFile)element$iv;
                    boolean bl8 = false;
                    if ((File)realSourceFileMap.get(testFile) == null || module.getDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getUSE_JAVAC()) || file3.isDirectory() || !Intrinsics.areEqual((Object)FilesKt.getExtension((File)file3), (Object)"java")) continue;
                    JvmContentRootsKt.addJavaSourceRoot$default((CompilerConfiguration)configuration2, (File)file3, null, (int)2, null);
                }
                JvmContentRootsKt.addJavaSourceRoot$default((CompilerConfiguration)configuration2, (File)SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getJavaSourceDirectory(), null, (int)2, null);
            }
        }
        if (!((Collection)javaBinaryFiles).isEmpty()) {
            void $this$filterTo$iv$iv3;
            Object element$iv2;
            Iterable $this$forEach$iv = javaBinaryFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                TestFile it7 = (TestFile)element$iv2;
                boolean bl9 = false;
                SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getRealFileForBinaryFile(it7);
            }
            this.addJavaCompiledModulesFromDependentKotlinModules(configuration2, configurationKind2, module, false);
            Iterable $this$filter$iv2 = javaBinaryFiles;
            boolean $i$f$filter2 = false;
            element$iv2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                TestFile it8 = (TestFile)element$iv$iv;
                boolean bl10 = false;
                if (!Intrinsics.areEqual((Object)it8.getName(), (Object)"module-info.java")) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List moduleInfoFiles = (List)destination$iv$iv2;
            if (!((Collection)moduleInfoFiles).isEmpty()) {
                this.addJavaBinaryRootsByJavaModules(configuration2, configurationKind2, moduleInfoFiles);
            } else {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String string = SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getJavaBinaryDirectory().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"testServices.sourceFileP\u2026.javaBinaryDirectory.path");
                $this$filter$iv2 = JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)configuration2);
                List list2 = null;
                boolean bl11 = false;
                object = JAVA_BINARIES_JAR_NAME;
                object3 = string;
                object2 = configuration2;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv3 = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    File it8 = (File)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl12 = false;
                    collection.add(it8.getAbsolutePath());
                }
                collection = (List)destination$iv$iv2;
                JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)object2, (File)MockLibraryUtil.compileJavaFilesLibraryToJar$default((String)object3, (String)object, bl11, list2, collection, null, JUnit5Assertions.INSTANCE, useJava11ToCompileIncludedJavaFiles, 44, null));
            }
        }
        this.registerModuleDependencies(configuration2, module);
        if (module.getDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getUSE_PSI_CLASS_FILES_READING())) {
            configuration2.put(JVMConfigurationKeys.USE_PSI_CLASS_FILES_READING, (Object)true);
        }
        if (module.getDirectives().contains(LanguageSettingsDirectives.INSTANCE.getALLOW_KOTLIN_PACKAGE())) {
            configuration2.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, (Object)true);
        }
        if (module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_IR_FOR_GIVEN_PHASES())) {
            this.putCustomPhaseConfigWithEnabledDump(configuration2, module);
        }
        configuration2.put(JVMConfigurationKeys.VALIDATE_IR, (Object)true);
        configuration2.put(JVMConfigurationKeys.VALIDATE_BYTECODE, (Object)true);
        JvmContentRootsKt.configureJdkClasspathRoots((CompilerConfiguration)configuration2);
    }

    private final void addJavaSourceRootsByJavaModules(CompilerConfiguration configuration2, List<TestFile> moduleInfoFiles) {
        File javaSourceDirectory2 = SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getJavaSourceDirectory();
        for (TestFile moduleInfoFile : moduleInfoFiles) {
            File file;
            String moduleName = StringsKt.substringBefore$default((String)moduleInfoFile.getRelativePath(), (char)'/', null, (int)2, null);
            File it = file = new File(javaSourceDirectory2.getPath() + '/' + moduleName);
            boolean bl = false;
            it.mkdir();
            File moduleDir = file;
            JvmContentRootsKt.addJavaSourceRoot$default((CompilerConfiguration)configuration2, (File)moduleDir, null, (int)2, null);
        }
    }

    private final void addJavaBinaryRootsByJavaModules(CompilerConfiguration configuration2, ConfigurationKind configurationKind, List<TestFile> moduleInfoFiles) {
        File javaBinaryDirectory2 = SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getJavaBinaryDirectory();
        for (TestFile moduleInfoFile : moduleInfoFiles) {
            String moduleName = StringsKt.substringBefore$default((String)moduleInfoFile.getRelativePath(), (char)'/', null, (int)2, null);
            this.addJavaCompiledModule(configuration2, configurationKind, moduleName, true, javaBinaryDirectory2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addJavaCompiledModulesFromDependentKotlinModules(CompilerConfiguration configuration2, ConfigurationKind configurationKind, TestModule module, boolean bySources) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = module.getAllDependencies();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DependencyDescription dependencyDescription = (DependencyDescription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DependencyProviderKt.getDependencyProvider(this.getTestServices()).getTestModule(it.getModuleName()));
        }
        List moduleDependencies = (List)destination$iv$iv;
        Function1 filterJavaModuleInfoFiles2 = (Function1)new Function1<TestFile, Boolean>(module, bySources){
            final /* synthetic */ TestModule $module;
            final /* synthetic */ boolean $bySources;
            {
                this.$module = $module;
                this.$bySources = $bySources;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TestFile testFile) {
                Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
                boolean binaryFilesFilter = testFile.getDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getINCLUDE_JAVA_AS_BINARY()) || this.$module.getDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getALL_JAVA_AS_BINARY());
                boolean includeOrExcludeBinaryFilesFilter = this.$bySources && !binaryFilesFilter || !this.$bySources && binaryFilesFilter;
                return includeOrExcludeBinaryFilesFilter && Intrinsics.areEqual((Object)testFile.getName(), (Object)"module-info.java");
            }
        };
        Iterable $this$mapNotNull$iv = moduleDependencies;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$mapTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TestFile it$iv$iv;
            Object v0;
            block5: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                TestModule it = (TestModule)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$singleOrNull$iv = SourceFileProviderKt.getJavaFiles(it);
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    if (!((Boolean)filterJavaModuleInfoFiles2.invoke(element$iv)).booleanValue()) continue;
                    if (found$iv) {
                        v0 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            if ((TestFile)v0 == null) continue;
            boolean bl = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List moduleInfoFilesFromDependencies = (List)destination$iv$iv2;
        for (TestFile dependentModuleInfoFile : moduleInfoFilesFromDependencies) {
            String moduleName = StringsKt.substringBefore$default((String)dependentModuleInfoFile.getRelativePath(), (char)'/', null, (int)2, null);
            JvmEnvironmentConfigurator.addJavaCompiledModule$default(this, configuration2, configurationKind, moduleName, bySources, null, 16, null);
        }
    }

    private final void addJavaCompiledModule(CompilerConfiguration configuration2, ConfigurationKind configurationKind, String moduleName, boolean bySources, File targetDir) {
        File moduleDir = new File(targetDir.getPath() + '/' + moduleName);
        File javaBinaries = bySources ? this.compileJavaFilesToModularJar(configuration2, configurationKind, moduleDir) : new File(moduleDir.getPath() + "/java-binaries.jar");
        JvmArgumentsKt.addModularRootIfNotNull((CompilerConfiguration)configuration2, (boolean)true, (String)moduleName, (File)javaBinaries);
    }

    static /* synthetic */ void addJavaCompiledModule$default(JvmEnvironmentConfigurator jvmEnvironmentConfigurator, CompilerConfiguration compilerConfiguration, ConfigurationKind configurationKind, String string, boolean bl, File file, int n, Object object) {
        if ((n & 0x10) != 0) {
            SourceFileProvider $this$addJavaCompiledModule_u24lambda_u2415 = SourceFileProviderKt.getSourceFileProvider(jvmEnvironmentConfigurator.getTestServices());
            boolean bl2 = false;
            file = bl ? $this$addJavaCompiledModule_u24lambda_u2415.getJavaSourceDirectory() : $this$addJavaCompiledModule_u24lambda_u2415.getJavaBinaryDirectory();
        }
        jvmEnvironmentConfigurator.addJavaCompiledModule(compilerConfiguration, configurationKind, string, bl, file);
    }

    /*
     * WARNING - void declaration
     */
    private final File compileJavaFilesToModularJar(CompilerConfiguration configuration2, ConfigurationKind configurationKind, File sourcesDir) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        List list;
        List $this$compileJavaFilesToModularJar_u24lambda_u2417 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object object = JvmContentRootsKt.getJvmModularRoots((CompilerConfiguration)configuration2);
        List list2 = $this$compileJavaFilesToModularJar_u24lambda_u2417;
        boolean $i$f$map22 = false;
        void var11_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            File file = (File)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getAbsolutePath());
        }
        list2.addAll((List)destination$iv$iv);
        if (configurationKind.getWithRuntime()) {
            $this$compileJavaFilesToModularJar_u24lambda_u2417.add(KotlinStandardLibrariesPathProviderKt.getStandardLibrariesPathProvider(this.getTestServices()).runtimeJarForTests().getPath());
        }
        List modulePath = CollectionsKt.build((List)list);
        String string = sourcesDir.getPath();
        $this$map$iv = JvmContentRootsKt.getJvmClasspathRoots((CompilerConfiguration)configuration2);
        boolean $i$f$map = false;
        Iterable $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(it.getAbsolutePath());
        }
        List list3 = (List)destination$iv$iv2;
        object = JUnit5Assertions.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
        return MockLibraryUtil.compileLibraryToJar$default(string, sourcesDir, JAVA_BINARIES_JAR_NAME, false, false, null, list3, modulePath, true, (Assertions)object, 56, null);
    }

    private final void configureDefaultJvmTarget(CompilerConfiguration configuration2) {
        if (DEFAULT_JVM_TARGET_FROM_PROPERTY == null) {
            return;
        }
        JvmTarget jvmTarget = JvmTarget.Companion.fromString(DEFAULT_JVM_TARGET_FROM_PROPERTY);
        if (jvmTarget == null) {
            throw new IllegalStateException(("Can't construct JvmTarget for " + DEFAULT_JVM_TARGET_FROM_PROPERTY).toString());
        }
        JvmTarget customDefaultTarget = jvmTarget;
        JvmTarget originalTarget = (JvmTarget)configuration2.get(JVMConfigurationKeys.JVM_TARGET);
        if (originalTarget == null || customDefaultTarget.getMajorVersion() > originalTarget.getMajorVersion()) {
            configuration2.put(JVMConfigurationKeys.JVM_TARGET, (Object)customDefaultTarget);
        }
    }

    private final void putCustomPhaseConfigWithEnabledDump(CompilerConfiguration $this$putCustomPhaseConfigWithEnabledDump, TestModule module) {
        File dumpDirectory = TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.getTestServices(), "dumped_ir");
        Set phases = CollectionsKt.toSet((Iterable)module.getDirectives().get(CodegenTestDirectives.INSTANCE.getDUMP_IR_FOR_GIVEN_PHASES()));
        if (!((Collection)phases).isEmpty()) {
            PhaseConfig phaseConfig = new PhaseConfig((CompilerPhase)JvmPhasesKt.getJvmPhases(), null, null, null, phases, phases, dumpDirectory.getAbsolutePath(), null, null, null, false, false, false, 8078, null);
            $this$putCustomPhaseConfigWithEnabledDump.put(CLIConfigurationKeys.PHASE_CONFIG, (Object)phaseConfig);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerModuleDependencies(CompilerConfiguration $this$registerModuleDependencies, TestModule module) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv;
        Iterable iterable = module.getAllDependencies();
        JvmEnvironmentConfigurator jvmEnvironmentConfigurator = this;
        CompilerConfiguration compilerConfiguration = $this$registerModuleDependencies;
        boolean $i$f$filter = false;
        void var5_8 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            DependencyDescription it = (DependencyDescription)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == DependencyKind.Binary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<String> collection = (List)destination$iv$iv;
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)compilerConfiguration, jvmEnvironmentConfigurator.toFileList((List<DependencyDescription>)collection));
        Iterable $this$filter$iv2 = module.getFriendDependencies();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DependencyDescription it = (DependencyDescription)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == DependencyKind.Binary)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List binaryFriends = (List)destination$iv$iv2;
        if (!((Collection)binaryFriends).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$filter$iv2 = this.toFileList(binaryFriends);
            jvmEnvironmentConfigurator = JVMConfigurationKeys.FRIEND_PATHS;
            compilerConfiguration = $this$registerModuleDependencies;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                File it = (File)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getAbsolutePath());
            }
            collection = (List)destination$iv$iv2;
            compilerConfiguration.put((CompilerConfigurationKey)jvmEnvironmentConfigurator, (Object)collection);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> toFileList(List<DependencyDescription> $this$toFileList) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$toFileList;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DependencyDescription dependency = (DependencyDescription)element$iv$iv;
            boolean bl = false;
            TestModule friendModule = DependencyProviderKt.getDependencyProvider(this.getTestServices()).getTestModule(dependency.getModuleName());
            Object[] objectArray = new File[]{CompiledClassesManager.getCompiledKotlinDirForModule$default(CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices()), friendModule, null, 2, null), CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices()).getCompiledJavaDirForModule(friendModule)};
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        CompilerConfigurationKey compilerConfigurationKey = CompilerConfigurationKey.create((String)"ConfigurationKind");
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfigurationKey, (String)"create<ConfigurationKind>(\"ConfigurationKind\")");
        TEST_CONFIGURATION_KIND_KEY = compilerConfigurationKey;
        DEFAULT_JVM_TARGET_FROM_PROPERTY = System.getProperty("kotlin.test.default.jvm.target");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u0010J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u000eR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/JvmEnvironmentConfigurator$Companion;", "", "()V", "DEFAULT_JVM_TARGET_FROM_PROPERTY", "", "JAVA_BINARIES_JAR_NAME", "TEST_CONFIGURATION_KIND_KEY", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "Lorg/jetbrains/kotlin/test/ConfigurationKind;", "kotlin.jvm.PlatformType", "getTEST_CONFIGURATION_KIND_KEY", "()Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "extractConfigurationKind", "registeredDirectives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "extractJdkKind", "Lorg/jetbrains/kotlin/test/TestJdkKind;", "getJdkClasspathRoot", "Ljava/io/File;", "jdkKind", "getJdkHome", "jdkKindTestJdkKind", "getLibraryFilesExceptRealRuntime", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "configurationKind", "directives", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompilerConfigurationKey<ConfigurationKind> getTEST_CONFIGURATION_KIND_KEY() {
            return TEST_CONFIGURATION_KIND_KEY;
        }

        @NotNull
        public final ConfigurationKind extractConfigurationKind(@NotNull RegisteredDirectives registeredDirectives) {
            Intrinsics.checkNotNullParameter((Object)registeredDirectives, (String)"registeredDirectives");
            boolean withStdlib = registeredDirectives.contains(ConfigurationDirectives.INSTANCE.getWITH_STDLIB());
            boolean withReflect = registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getWITH_REFLECT());
            boolean noRuntime = registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getNO_RUNTIME());
            if (noRuntime && withStdlib) {
                throw new IllegalStateException("NO_RUNTIME and WITH_STDLIB can not be used together".toString());
            }
            return withStdlib && !withReflect ? ConfigurationKind.NO_KOTLIN_REFLECT : (withStdlib || withReflect ? ConfigurationKind.ALL : (noRuntime ? ConfigurationKind.JDK_NO_RUNTIME : ConfigurationKind.JDK_ONLY));
        }

        @NotNull
        public final TestJdkKind extractJdkKind(@NotNull RegisteredDirectives registeredDirectives) {
            TestJdkKind testJdkKind;
            Intrinsics.checkNotNullParameter((Object)registeredDirectives, (String)"registeredDirectives");
            boolean fullJdkEnabled = registeredDirectives.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getFULL_JDK());
            List<TestJdkKind> jdkKinds = registeredDirectives.get(JvmEnvironmentConfigurationDirectives.INSTANCE.getJDK_KIND());
            if (fullJdkEnabled) {
                if (!((Collection)jdkKinds).isEmpty()) {
                    throw new IllegalStateException("FULL_JDK and JDK_KIND can not be used together".toString());
                }
                return TestJdkKind.FULL_JDK;
            }
            switch (jdkKinds.size()) {
                case 0: {
                    testJdkKind = TestJdkKind.MOCK_JDK;
                    break;
                }
                case 1: {
                    testJdkKind = (TestJdkKind)((Object)CollectionsKt.single(jdkKinds));
                    break;
                }
                default: {
                    throw new IllegalStateException(("Too many jdk kinds passed: " + StringUtilsKt.joinToArrayString((Iterable)jdkKinds)).toString());
                }
            }
            return testJdkKind;
        }

        @NotNull
        public final List<File> getLibraryFilesExceptRealRuntime(@NotNull TestServices testServices, @NotNull ConfigurationKind configurationKind, @NotNull RegisteredDirectives directives2) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)((Object)configurationKind), (String)"configurationKind");
            Intrinsics.checkNotNullParameter((Object)directives2, (String)"directives");
            KotlinStandardLibrariesPathProvider provider = KotlinStandardLibrariesPathProviderKt.getStandardLibrariesPathProvider(testServices);
            List files = new ArrayList();
            if (configurationKind.getWithRuntime()) {
                files.add(provider.kotlinTestJarForTests());
            } else if (configurationKind.getWithMockRuntime()) {
                files.add(provider.minimalRuntimeJarForTests());
                files.add(provider.scriptRuntimeJarForTests());
            }
            if (configurationKind.getWithReflection()) {
                files.add(provider.reflectJarForTests());
            }
            files.add(provider.getAnnotationsJar());
            if (directives2.contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getSTDLIB_JDK8())) {
                files.add(provider.runtimeJarForTestsWithJdk8());
            }
            return files;
        }

        @Nullable
        public final File getJdkHome(@NotNull TestJdkKind jdkKindTestJdkKind) {
            File file;
            Intrinsics.checkNotNullParameter((Object)((Object)jdkKindTestJdkKind), (String)"jdkKindTestJdkKind");
            switch (WhenMappings.$EnumSwitchMapping$0[jdkKindTestJdkKind.ordinal()]) {
                case 1: {
                    file = null;
                    break;
                }
                case 2: {
                    file = null;
                    break;
                }
                case 3: {
                    String string = System.getenv("JDK_16");
                    if (string == null) {
                        throw new IllegalStateException("Environment variable JDK_16 is not set".toString());
                    }
                    file = new File(string);
                    break;
                }
                case 4: {
                    file = KtTestUtil.getJdk11Home();
                    break;
                }
                case 5: {
                    file = KtTestUtil.getJdk17Home();
                    break;
                }
                case 6: {
                    if (SystemInfo.IS_AT_LEAST_JAVA9) {
                        file = new File(System.getProperty("java.home"));
                        break;
                    }
                    file = null;
                    break;
                }
                case 7: {
                    file = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return file;
        }

        @Nullable
        public final File getJdkClasspathRoot(@NotNull TestJdkKind jdkKind) {
            File file;
            Intrinsics.checkNotNullParameter((Object)((Object)jdkKind), (String)"jdkKind");
            switch (WhenMappings.$EnumSwitchMapping$0[jdkKind.ordinal()]) {
                case 1: {
                    file = KtTestUtil.findMockJdkRtJar();
                    break;
                }
                case 2: {
                    file = KtTestUtil.findMockJdkRtModified();
                    break;
                }
                case 7: {
                    file = KtTestUtil.findAndroidApiJar();
                    break;
                }
                case 3: {
                    file = null;
                    break;
                }
                case 4: {
                    file = null;
                    break;
                }
                case 5: {
                    file = null;
                    break;
                }
                case 6: {
                    file = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return file;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TestJdkKind.values().length];
                try {
                    nArray[TestJdkKind.MOCK_JDK.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.MODIFIED_MOCK_JDK.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.FULL_JDK_6.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.FULL_JDK_11.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.FULL_JDK_17.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.FULL_JDK.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TestJdkKind.ANDROID_API.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TestJdkKind.values().length];
            try {
                nArray[TestJdkKind.MOCK_JDK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.MODIFIED_MOCK_JDK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.ANDROID_API.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.FULL_JDK_6.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.FULL_JDK_11.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.FULL_JDK_17.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestJdkKind.FULL_JDK.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

